<?php

use Illuminate\Support\Facades\Route;
use \App\Http\Controllers\WebServiceController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('index');
});

Route::any('/webService', function (){

    ini_set('soap.wsdl_cache_enabled',0);
    ini_set('soap.wsdl_cache_ttl',0);

    $server = new SoapServer(
        null,
        [
            'uri'=> 'https://sispac.soliat.com/webService',
            'encoding' => 'UTF-8'
        ]
    );
    $server->setClass('App\Commands\FacturacionApiFunctions');
    $server->handle();

});

Route::any('/webService2', function (){

    ini_set('soap.wsdl_cache_enabled',0);
    ini_set('soap.wsdl_cache_ttl',0);

    class MiClase
    {
        public function saludar()
        {
            return 'Hola ' . func_get_args()[0] . PHP_EOL;
        }
    }


    $server = new SoapServer(
        null,
        [
            'uri'=> 'https://sispac.soliat.com/webService2',
            'encoding' => 'UTF-8'
        ]
    );
    $server->setClass('MiClase');
    $server->handle();

});


Route::get('/getXML33', [WebServiceController::class, 'getXML33External']);
Route::get('/getPDF33', [WebServiceController::class, 'getPDFExternal']);
