<?php use chillerlan\QRCode\QRCode;?>
<!DOCTYPE html>
<html>
<head>
<style type="text/css">
@page *{
	margin: 0;
	padding: 0;
	margin-bottom: 0;
	padding-bottom: 0;
}

html, .nopadding {
	margin: 0;
	padding: 0;
}

body {
	font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
	font-size: 12px;
	margin: 0;
	padding: 0;
	margin-bottom: 0;
	padding-bottom: 0;
	color: {{$factura->color}};
}

h3{
	color: #666666;
	font-size: 16px;
	padding-top: 1mm;
	margin-top: 1mm;
}

.panelLeft {
	color: #FFF;
}

.maxWidth {
	width: 200mm;
	margin: 0;
	padding: 0;
}

.panelLeft {
	width: 50mm;
	display: inline-block;
}

.panelContent {
	width: 158mm;
	display: inline-block;
	padding-top: 5mm;
	padding-left: 1mm;
	padding-right: 2mm;
}

.rowData {
	text-align: center;
	vertical-align: middle;
	padding: 10px;
	height: 53mm;
}

.text-center{
	text-align: center;
}
.text-left{
	text-align: left;
}
.text-right{
	text-align: right;
}
#contenidoFactura{
	padding-bottom: 5mm;
	line-height: 5mm;
}
.float{
	float: left;
}
.width50{
	width: 49%;
}
.noBorder{
	border: none;
}
.title3{
	font-weight: bold;
	font-size: 22px;
	padding-top: 5px;
	padding-bottom: 15px;
}
.lineHeight{
	line-height: 5mm;
}

.header{
	width: 100%;
	background: #EFF3F6;
	padding: 1mm;
}

.logo{
	width: 40%;
	text-align: center;
}

.logo img{
	height: 35mm;
}
.datosFacturas{
	width: 60%;
}
.datosFacturas tr td{
	border-bottom: 1px solid #999999;
	padding-bottom: 1mm;
}
.datosFacturas tr th{
	padding-top: 1mm;
}
.datosFacturas tr th, .datosFacturas tr td{
	padding: 1mm;
}
.datosFacturas h3{
	padding-top: 0;
	padding-bottom: 0px;
	margin-bottom: 0px;
}
.receptor{
	width: 200mm;
	padding-top: 2mm;
}

.receptor .h2{
	font-weight: bold;
	font-size: 16px;
}
.receptor .h3{
	font-weight: bold;
	font-size: 14px;
}
.float2{
	display: inline-block;
}
#total{
	background: {{$factura->color}};
	width: 50mm;
	font-size: 18px;
	color: #FFFFFF;
	text-align: center;
	padding: 4mm;
	font-weight: bold;
}
.rowProd{
	padding-top: 1mm;
	padding-left: 3mm;
	padding-bottom: 0mm;
}
.rowProd small{
	font-size: 11px;
}
.f13{
	font-size: 13px;
	font-weight: bold;

}
.tableTotales{
	padding-top: 2mm;
}

.tableTotales td, .tableTotales th{
	padding-bottom: 2mm;
	padding-top: 2mm;
	margin: 0;
}
.borderedTotales{
	border-bottom: 1px solid #E6E6E6;
}
.lastElements .title{
	background: #EFF3F6;
	padding-bottom: 2mm;
	padding-top: 2mm;
	text-align: center;
	font-weight: bold;
}

.lastElements .content{
	word-wrap: break-word;
	overflow-wrap: break-word;
	background: #FFFFFF;
}
.infoCFDI {
	text-align: left;
	width: 98%;
}
.infoCFDI td, .infoCFDI th{
	padding-bottom: 1mm;
	padding-top: 1mm;
}
.tablePago{
	padding-top: 5mm;
}
.tableImp{
    width: 100%;
}
.tablePago th, .tableImp th{
	border: 1px solid #e0e0e0;
	padding: 1mm;
}
.tablePago td, .tableImp td{
	border: 1px solid #e0e0e0;
	text-align: center;
	padding: 1mm;
}
.small{
    font-size: 10px;
}
.rowHead{
    text-align: center;
    font-weight: bold;
    border: 1px solid #E6E6E6;
}
.tableProdD tr td{
    height: 5mm;
    border: 1px solid #E6E6E6;
    font-size: 10px;
}
</style>
</head>
<body>


<div class="header">
		<table style="width: 100%;">
			<tr>
				<td class="logo">
                    @if($factura->base64 != '')
                        <img src="{{$factura->base64}}" />
                    @endif
                </td>
				<td class="datosFacturas">

					<table class="text-center" style="width: 100%;">
        				<tr>
        					<th style="color: red;">PAGO</th>
        					<th>FECHA EMISIÓN</th>
        				</tr>
        				<tr>
        					<td>{{$factura->serie}}{{$factura->noFactura}}</td>
        					<td>{{$factura->timeStamp}}</td>
        				</tr>
        				<tr>
        					<th>TIPO DOCUMENTO</th>
        					<th>USO DOCUMENTO</th>
        				</tr>
        				<tr>
        					<td>{{$adicionales['tipoDocumento'][$factura->tipoDeComprobante]}}</td>
        					<td>{{$factura->usoCFDI}}</td>
        				</tr>
        			</table>

				</td>
			</tr>
		</table>
		<div class="receptor">
			<table cellspacing="0" cellpadding="0">
				<tr>
					<td style="width: 150mm; padding-left: 1mm;">
                        <div class="h2">(E) {{$factura->nmbEmisor}} <br> {{$factura->rFCEmisor}}
                        </div>
                        {{$factura->regimenFiscal}}<br />
                        Lugar de expedición: {{$factura->lugarExpedicion}}
                        @if(!empty($factura->direccionProveedor))
                            - {{$factura->direccionProveedor}}
                        @endif

                        <div class="h2" style="padding-top: 5mm;">(R) {{$factura->nmbRecep}} <br /> {{$factura->rFCRecep}}</div>
                        @if(isset($factura->direccionCliente) && $factura->direccionCliente != '')
                            {{$factura->direccionCliente}}
                        @endif
					</td>
					<td style="width: 50mm;">
						<div id="total">
							${{number_format ($factura->totalPagos, 2, '.', ',')}}
						</div>
					</td>
				</tr>
			</table>
		</div>
	</div>

    <table cellspacing="0" cellpadding="0" style="width: 100%;" class="tableProdD">
        <tr>
            <td class="rowHead" style="width: 15mm;">CANT.</td>
            <td class="rowHead" style="width: 30mm;">C. PRODUCTO</td>
            <td class="rowHead">DESCRIPCION</td>
            <td class="rowHead" style="width: 20mm;">C. UNIDAD</td>
            <td class="rowHead" style="width: 25mm;">P. UNITARIO</td>
            <td class="rowHead" style="width: 25mm;">DESCUENTO</td>
            <td class="rowHead" style="width: 25mm;">IMPORTE</td>
        </tr>
    </table>
    @foreach($factura->conceptos as $concepto)
        <table cellspacing="0" cellpadding="0" style="width: 100%;" class="tableProdD">
            <tr>
                <td class="text-center" style="width: 15mm;">{{$concepto->qtyItem}}</td>
                <td class="text-center" style="width: 30mm;">{{$concepto->clave}}</td>
                <td>{{$concepto->dscItem}}</td>
                <td class="text-center" style="width: 20mm;">{{$concepto->unmdItem}}</td>
                <td class="text-center" style="width: 25mm;">${{number_format ($concepto->montoNetoItem, 2, '.', ',')}}</td>
                <td class="text-center" style="width: 25mm;">${{number_format ($concepto->descuento, 2, '.', ',')}}</td>
                <td class="text-center" style="width: 25mm;">${{number_format ($concepto->prcNetoItem, 2, '.', ',')}}</td>
            </tr>
        </table>
    @endforeach


	<div>
	@foreach($factura->pagos as $key => $pago)

		<div class="rowProd">
			<h3>Pago #{{$key +1}}</h3>
            <table class="infoCFDI" width="100%">
                <tr>
                    <td>
                        <label><strong>Forma de pago:</strong></label>
                        {{$pago->formaPago->codigo}} - {{$pago->formaPago->descripcion}}
                        <br />
                        <label><strong>Fecha de pago:</strong></label> {{$pago->FechaPago}}
                        @if($pago->rfcEmisorCtaBen != '' && $pago->rfcEmisorCtaBen != null)
                            <br /> <label><strong>Banco beneficiario:</strong></label> {{$pago->rfcEmisorCtaBen}} {{$pago->emisorCtaBenName}}
                        @endif
                        @if($pago->ctaBeneficiario != '' && $pago->ctaBeneficiario != null)
                            <br /> <label><strong>Cuenta beneficiario:</strong></label> {{$pago->ctaBeneficiario}}
                        @endif
                    </td>
                    <td>
                        <label><strong>Total del pago:</strong></label> ${{number_format
				        ($pago->Monto, 2, '.', ',')}} {{$pago->MonedaP}}
                        @if($pago->noOperacion != '')
                            <br /><label><strong>No. operación:</strong></label> {{$pago->noOperacion}}
                        @endif
                        @if($pago->banco != '' && $pago->banco != null)
                            <br /><label><strong>Banco ordenante:</strong></label> {{$pago->banco}} {{$pago->bancoName}}
                        @endif
                        @if($pago->cuenta != '' && $pago->cuenta != null)
                            <br /> <label><strong>Cuenta ordenante:</strong></label> {{$pago->cuenta}}
                        @endif
                    </td>
                </tr>
            </table>

			<table class="tablePago" cellspacing="0" cellpadding="0" class="tableProdD">
				<thead>
					<tr>
						<th style="width: 63mm;">UUID</th>
						<th style="width: 20mm;">Moneda</th>
						<th style="width: 20mm;">No. pago</th>
						<th style="width: 29mm;">Saldo anterior</th>
						<th style="width: 29mm;">Pago realizado</th>
						<th style="width: 29mm;">Saldo actual</th>
					</tr>
				</thead>
				<tbody>
				@foreach($pago->documentosRelacionado as $documento)
					<tr>
						<td>{{$documento->IdDocumento}}</td>
						<td>{{$documento->MonedaDR}}</td>
						<td>{{$documento->NumParcialidad}}</td>
						<td>${{number_format($documento->ImpSaldoAnt, 2, '.', ',')}}</td>
						<td>${{number_format($documento->ImpPagado, 2, '.', ',')}}</td>
						<td>${{number_format($documento->ImpSaldoInsoluto, 2, '.', ',')}}</td>
					</tr>

                    @if(!empty($documento->impuestos) &&
                    (count($documento->impuestos->impuestosRetenidos) > 0
                    || count($documento->impuestos->impuestosTrasladados) > 0))


                    <tr>
                        @if(count($documento->impuestos->impuestosRetenidos) > 0 )
                        <td colspan="3">
                            <table class="tableImp" cellspacing="0" cellpadding="0">
                                <thead>
                                <tr>
                                    <th colspan="5">Retenciones</th>
                                </tr>
                                <tr>
                                    <th>Impuesto</th>
                                    <th>Tasa/Cuota</th>
                                    <th>Tipo factor</th>
                                    <th>Base</th>
                                    <th>Importe</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach ($documento->impuestos->impuestosRetenidos as $impuestoRetenido)
                                <tr>
                                    <td>{{$impuestoRetenido->impuesto}}</td>
                                    <td>{{App\Commands\Utils::formatNumber ( $impuestoRetenido->tasaCuota, 6)}}</td>
                                    <td>{{$impuestoRetenido->tipoFactor}}</td>
                                    <td>{{App\Commands\Utils::formatNumber ($impuestoRetenido->base)}}</td>
                                    <td>{{App\Commands\Utils::formatNumber ($impuestoRetenido->importe)}}</td>
                                </tr>
                                @endforeach
                                </tbody>
                            </table>

                        </td>
                        @endif
                            @if(count($documento->impuestos->impuestosTrasladados) > 0 )
                        <td colspan="3">
                                <table class="tableImp" cellspacing="0" cellpadding="0">
                                    <thead>
                                    <tr>
                                        <th colspan="5">Traslados</th>
                                    </tr>
                                    <tr>
                                        <th>Impuesto</th>
                                        <th>Tasa/Cuota</th>
                                        <th>Tipo factor</th>
                                        <th>Base</th>
                                        <th>Importe</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach ($documento->impuestos->impuestosTrasladados as $impuestoTrasladado)
                                        <tr>
                                            <td>{{$impuestoTrasladado->impuesto}}</td>
                                            <td>{{App\Commands\Utils::formatNumber ( $impuestoTrasladado->tasaCuota, 6)}}</td>
                                            <td>{{$impuestoTrasladado->tipoFactor}}</td>
                                            <td>{{App\Commands\Utils::formatNumber ($impuestoTrasladado->base)}}</td>
                                            <td>{{App\Commands\Utils::formatNumber ($impuestoTrasladado->importe)}}</td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                        </td>
                            @endif

                    </tr>
                    @endif

                    @if($documento->MontoPagoMoneda > 0)
                        <tr>
                            <td><strong>Equivalencia:</strong> {{number_format( $documento->ImpPagado / $documento->MontoPagoMoneda, 6)}}</td>
                        </tr>
                    @endif
				@endforeach
				</tbody>
			</table>

		</div>
		@endforeach


	</div>

	<div class="row" style="width: 100%; padding-top: 5mm;">

		<div class="lastElements" style="padding-bottom: 5mm;">
				<div class="title">Información del CFDI</div>
				<div class="content"  style="padding-left: 2mm;">

				<table class="infoCFDI">
						<tr>
							<td><strong>Folio fiscal:</strong></td>
							<td style="width: 60mm;">{{$factura->uUID}}</td>
							<td><strong>No. de certificado:</strong></td>
							<td>{{$factura->noCertificado}}</td>
						</tr>
						<tr>
							<td><strong>Fecha certificación:</strong></td>
							<td>{{$factura->fechaTimbrado}}</td>
							@if($factura->nota != '')
								<td><strong>Nota:</strong></td>
								<td>{{$factura->nota}}</td>
							@endif
						</tr>
					</table>

				</div>
			</div>


		<div class="lastElements" style="padding-bottom: 2mm;">
				<div class="title">Sello digital del CFDI</div>
				<div class="content small"  style="padding-left: 2mm; padding-right: 2mm;">{{$factura->sello}}</div>
			</div>
		<div class="lastElements" style="padding-bottom: 2mm;">
				<div class="title">Sello digital del SAT</div>
				<div class="content small"  style="padding-left: 2mm; padding-right: 2mm;">{{$factura->selloSAT}}</div>
			</div>

		<div class="float" style="padding-left: 2mm; width: 40mm;">
            <img style="height: 40mm;" src="{{(new QRCode)->render($factura->qr)}}" alt="QR Code" />
		</div>
		<div class="float" style="width: 174mm;">
			<div class="lastElements">
				<div class="title">Cadena original del complemento de certificacion digital del SAT</div>
				<div class="content small" style="padding-right: 1mm;">||1.1|{{$factura->uUID}}|{{$factura->timeStamp}}|{{$factura->selloSAT}}|{{$factura->noCertificadoSAT}}||</div>
			</div>

		</div>
	</div>
	<div style="padding-left: 3mm; padding-top: 3mm;">**Este documento es una representación impresa de un CFDI.</div>
	</div>


</body>
</html>
