(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('MisDatosController', MisDatosController);

    MisDatosController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert'];

    function MisDatosController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert) {
        var vm = this;
        vm.proveedor = [];
        vm.tipoPersona = [{label:'Persona Moral', id: '1'}, {label: 'Persona física', id: '2'}];
        vm.files = [0,1];
        vm.cerFile = '';

        activate();

        ////////////////

        function activate() {


        	vm.obtenerDatos = function(){

	        	vm.loading = "whirl double-up";

	        	$http.post('/api/admin/proveedores/misDatos', {
					user : $rootScope.user
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						vm.loading = "";
						vm.proveedor = response.proveedor;
						vm.catalogoregimenfiscal = response.catalogoregimenfiscal;

					}

				}, function errorCallback(response) {

				  });
        	}

        	vm.guardarDatos = function(){

        		if(vm.proveedor.tipoPersona == undefined || vm.proveedor.tipoPersona == ''){
	        		Notify.alert('Debe seleccionar el tipo de persona.', {status: 'danger'});
	        		return;
	        	}

	        	if(vm.proveedor.regimenFiscal33 == undefined || vm.proveedor.regimenFiscal33 == ''){
	        		Notify.alert('Debe seleccionar su regimen fiscal.', {status: 'danger'});
	        		return;
	        	}

	        	vm.loading = "whirl double-up";

	        	$http.post('/api/admin/proveedores/guardarMisDatos', {
					user : $rootScope.user,
					proveedor: vm.proveedor
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						vm.loading = "";
						SweetAlert.swal('Datos guardados', 'Sus datos se han guardado de forma correcta', 'success');
					}

				}, function errorCallback(response) {
					Notify.alert('Ocurrió un error.', {status: 'danger'});
					vm.loading = "";
				  });
        	}


        	vm.obtenerRegimenesFiscales = function(){

        		vm.proveedor.regimenFiscal33 = '';

	        	vm.loading = "whirl double-up";

	        	$http.post('/api/admin/proveedores/obtenerRegimenesFiscales', {
					user : $rootScope.user,
					tipo: vm.proveedor.tipoPersona
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						vm.loading = "";
						vm.catalogoregimenfiscal = response.catalogoregimenfiscal;
					}

				}, function errorCallback(response) {
					Notify.alert('Ocurrió un error.', {status: 'danger'});
					vm.loading = "";
				  });
        	}


        	vm.obtenerDatos();

        }

        //Actualizar certificados
        $('#cerFile').on('change', prepareCerUpload);
        $('#keyFile').on('change', prepareKeyUpload);

        function prepareCerUpload(event) {
        	vm.files[0] = event.target.files[0];
        }
        function prepareKeyUpload(event) {
        	vm.files[1] = event.target.files[0];
        }

        vm.actualizarCertificado = async function () {

            var val1 = $("#cerFile").val();
            var val2 = $("#keyFile").val();
            var password = $("#password").val();


            if (val1 == '') {
                Notify.alert('Debe seleccionar el archivo .cer', {status: 'danger'});
                return;
            }

            if (val2 == '') {
                Notify.alert('Debe seleccionar el archivo .key', {status: 'danger'});
                return;
            }

            if (password == '') {
                Notify.alert('Debe ingresar el password', {status: 'danger'});
                $("#password").focus();
                return;
            }

            vm.loadingCers = 'whirl double-up';


            // Create a formdata object and add the files
            const cerFile = document.getElementById('cerFile').files[0];
            const keyFile = document.getElementById('keyFile').files[0];

            const formData = new FormData();
            formData.append('cerFile', cerFile);
            formData.append('keyFile', keyFile);
            formData.append('id_proveedor', $rootScope.user.id_proveedor);
            formData.append('token', $rootScope.user.token);
            formData.append('password', password);

            const response = await fetch('/api/admin/proveedores/actualizarCertificado', {
                method: 'POST',
                body: formData
            });

            if (response.ok) {
                console.log('Sergio response: ', response);
                const result = await response.json();
                if (result.errorCode == 0) {

                    $('#cerFile').val('');
                    $('#keyFile').val('');
                    $('#password').val('');

                    vm.proveedor.certificados.cerFile = result.cerFile;
                    vm.proveedor.certificados.keyFile = result.keyFile;

                    SweetAlert.swal('Certificado actualizado', 'Sus certificado se actualizó de forma correcta', 'success');

                } else {

                    Notify.alert(result.message, {status: 'danger'});

                }
                vm.loadingCers = '';
            } else {
                console.error('Error:', response.statusText);
            }
        };

    }
})();


