(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('FacturacionController', FacturacionController);

    FacturacionController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder', 'ngDialog'];

    function FacturacionController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder, ngDialog) {
        var vm = this;
        vm.facturas = [];
        vm.proveedoresRelacionados = [];
        vm.count = 0;
        vm.puedeFacturar = false;
        vm.tipoEstatusDocumento = ['canceladas', 'activas'];

        vm.dtOptions = DTOptionsBuilder.newOptions()
		.withOption('order', [0, 'desc'])
        .withDisplayLength(50);

        activate();

        ////////////////

        function activate() {


        	vm.obtenerFacturas = function(){

	        	vm.loading = "whirl double-up";

	        	$rootScope.filterDate.initialS = prepareDateForServer($rootScope.filterDate.initial);
	        	$rootScope.filterDate.endS = prepareDateForServer($rootScope.filterDate.end);

	        	$http.post('/api/admin/facturacion/listadoFacturas', {
					user : $rootScope.user,
					filtro: $rootScope.filterDate,
					id_proveedorPrincipal : $rootScope.user.id_proveedorPrincipal
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						vm.loading = "";
						vm.facturas = response.facturas;
						vm.proveedoresRelacionados = response.proveedoresRelacionados;
						vm.puedeFacturar = response.puedeFacturar;

					}

				}, function errorCallback(response) {

					if(vm.count >= 3){
						Notify.alert('Ocurrió un error al cargar las facturas, inténtelo más tarde.', {status: 'danger'});
					}else{
						vm.obtenerFacturas();
						vm.count++;
					}

				});
        	}


        	vm.buscarFactura = function(){

        		ngDialog.openConfirm({
                    template: 'filtroFacturas',
                    className: 'ngdialog-theme-default large-ngDialog',
                }).then(function (buscar) {
                    if (buscar == 1) {
                    	vm.obtenerFacturas();
                    }
                }, function (state) {

                });

        	};



        	vm.enviarFactura = function(factura){

        		ngDialog.openConfirm({
                    template: 'enviarFactura',
                    className: 'ngdialog-theme-default',
                    data: {factura: factura},
                    controller: 'EnviarFacturasController',
                }).then(function (buscar) {
                }, function (state) {
                    if(state == 1){
                    	Notify.alert('La factura se ha enviado de forma correcta.', {status: 'success'});
                    }
                });

        	};


        	vm.cancelarFactura = function(factura){

        		ngDialog.openConfirm({
                    template: 'cancelarFactura',
                    className: 'ngdialog-theme-default',
                    data: {factura: factura},
                    controller: 'CancelarFacturaController',
                }).then(function (buscar) {
                }, function (state) {
                    if(state == 1){
                    	Notify.alert('La factura se ha cancelado de forma correcta.', {status: 'success'});

                    	for(var x = 0; x < vm.facturas.length; x++){
                    		if(vm.facturas[x].id_factura == factura.id_factura){
                    			vm.facturas.splice(x, 1);
                    			break;
                    		}
                    	}
                    }
                });
        	};

        	vm.previewFactura = function(factura){

        		ngDialog.openConfirm({
                    template: 'previewFactura',
                    className: 'ngdialog-theme-default large-ngDialog no-padding-modal',
                    data: {id_factura: factura.id_factura},
                    controller: 'PreviewFacturaController',
                }).then(function (buscar) {
                }, function (state) {
                });
        	};


        	/*
        	vm.obtenerXML = function(id_factura, folio, serie, version){

        		var api = 'getXML';
        		if(version == '3.3'){
        			api = 'getXML33';
        		}

        		$http.post('/api/admin/facturacion/' + api, {
					user : $rootScope.user,
					id_factura: id_factura
				}).then(function(res) {
					var blob = new Blob([res.data]);
			        var link = document.createElement('a');
			        link.href = window.URL.createObjectURL(blob);
			        link.download = $rootScope.user.rfc + '-' + serie + folio + '.xml';
			        link.click();

				}, function errorCallback(response) {
					Notify.alert('Ocurrió un error.', {status: 'danger'});
					vm.loadingWare = "";
				  });

        	};
        	*/


        	vm.obtenerPDF = function(id_factura, folio, serie, version){
        		$("#id_factura").val(id_factura);
        		$("#token").val($rootScope.user.token);
        		$("#id_proveedor").val($rootScope.user.id_proveedor);
        		$("#downloadPDF").submit();
        	};

        	vm.obtenerXML = function(id_factura, folio, serie, version){
        		$("#id_facturaXML").val(id_factura);
        		$("#tokenXML").val($rootScope.user.token);
        		$("#id_proveedorXML").val($rootScope.user.id_proveedor);
        		$("#downloadXML").submit();
        	};

        	vm.generarPago = function(factura){
        		$state.transitionTo('app.nuevoPago', {id: factura.id_factura});
        	}

        	vm.cambiarUsuario = function(){

        		vm.loading = "whirl double-up";

        		$http.post('/api/admin/proveedores/getDataMultiusuario', {
					user : $rootScope.user,
					id_proveedor: $rootScope.user.id_proveedor
				}).then(function(res) {

					var response = res['data'];
					if (response['success']) {
						$rootScope.user.token = response.login.token;
                        $rootScope.user.id_proveedor = response.login.id_proveedor + '';
                        $rootScope.user.rfc = response.login.rfc;

                        var date = new Date(), y = date.getFullYear(), m = date.getMonth();
                        var firstDay = new Date(y, m, 1);
                        var lastDay = new Date(y, m + 1, 0);

                        $rootScope.filterDate ={
                        	initial: firstDay,
                        	end: lastDay,
                        	rfc: '',
                        	tipoDocumento: '',
                        	estatusDocumento: '1'
                        };
					}

					vm.obtenerFacturas();

				}, function errorCallback(response) {

				  });

        	};


        	vm.descargarExcel = function(){

        		$rootScope.filterDate.initialS = prepareDateForServer($rootScope.filterDate.initial);
	        	$rootScope.filterDate.endS = prepareDateForServer($rootScope.filterDate.end);

	        	$("#tokenExc").val($rootScope.user.token);
	        	$("#id_proveedorExc").val($rootScope.user.id_proveedor);
	        	$("#fechaInicial").val($rootScope.filterDate.initialS);
	        	$("#fechaFinal").val($rootScope.filterDate.endS);
	        	$("#estatusDocumento").val($rootScope.filterDate.estatusDocumento);
	        	$("#tipoDocumento").val($rootScope.filterDate.tipoDocumento);
	        	$("#rfcExc").val($rootScope.user.rfc);
	        	$("#rfcBusquedaExc").val($rootScope.filterDate.rfc);

	        	$("#downloadExcel").submit();

        	};

        	vm.obtenerFacturas();

        }


        function prepareDateForServer(dateObj) {

            if (dateObj instanceof Date) {

                var day = (dateObj.getDate() < 10) ? '0' + dateObj.getDate() : dateObj.getDate();
                var month = (dateObj.getMonth() < 9) ? '0' + (dateObj.getMonth() + 1) : (dateObj.getMonth() + 1);
                var year = dateObj.getFullYear();

                dateObj = year + '-' + month + '-' + day;

            }

            return dateObj;

        };
    }
})();


(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('NuevaFacturaController', NuevaFacturaController);

    NuevaFacturaController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder', 'ngDialog'];

    function NuevaFacturaController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder, ngDialog) {
        var vm = this;

        vm.clientes = [];
        vm.formasDePago = [];
        vm.productos = [];
        vm.unidadesMedida = [];
		vm.clavesProducto = [];
		vm.usosCFDI = [];
		vm.usosCFDITmp = [];
		vm.searchTextCustomer = '';
		vm.series = [];
        vm.factura = {
        		tipoDocumento: 'I',
        		id_cliente: '',
            	decimales: '2',
        		impuestosRetenidos : [],
        		guardarProd: false,
        		impuestosTrasladados : [{factor: 'Tasa', valor: 0.16, impuesto: '002', label: 'IVA'}],
        		moneda: 'MXN',
        		tipoCambio: 1.0,
        		detalles: [],
        		descuento: 0,
        		facturasRelacionadas: {
            		tipoRelacion: '',
            		noFactura: '',
            		uuids: []

            	},
        		cuentaPredial: '',
        		formaPago: '',
        		lugarExpedicion: '',
        		serie: 'A',
        		metodoDePago: 'PUE',
        		truncar: '0'
        }
        vm.productoAgregar = '';
        vm.tipoRelaciones = [
                             {value: '01', label: 'Nota de crédito de los documentos relacionados'},
                             {value: '02', label: 'Nota de débito de los documentos relacionados'},
                             {value: '03', label: 'Devolución de mercancía sobre facturas o traslados previos'},
                             {value: '04', label: 'Sustitución de los CFDI previos'},
                             {value: '05', label: 'Traslados de mercancias facturados previamente'},
                             {value: '06', label: 'Factura generada por los traslados previos'},
                             {value: '07', label: 'CFDI por aplicación de anticipo'}
                            ];
        vm.metodosDePago = [{codigo: 'PUE', descripcion: 'Pago en una sola exhibición'}, {codigo: 'PPD', descripcion: 'Pago en parcialidades o diferido'}];

        vm.cambiarTipoDocumento = function(tipo){
        	vm.factura.tipoDocumento = tipo;
        	if(vm.factura.tipoDocumento == 'P')
        		$state.transitionTo('app.nuevoPago');
        };

        activate();

        ////////////////

        function activate() {

        	if($rootScope.user.id_proveedor == 943){
				console.log("Si entro acá");
			}

        	vm.obtenerNombreTipoRelacion = function(){
        		for(var x = 0; x < vm.tipoRelaciones.length; x++){
        			if(vm.tipoRelaciones[x].value == vm.factura.facturasRelacionadas.tipoRelacion){
        				return vm.tipoRelaciones[x].label;
        			}
        		}
        	};


        	vm.obtenerDatos = function(){

        		if($stateParams.tipoDocumento != undefined && $stateParams.tipoDocumento != ''){
        			vm.factura.tipoDocumento = $stateParams.tipoDocumento;
        		}

	        	vm.loading = "whirl double-up";

	        	$http.post('/api/admin/facturacion/datosFacturar', {
					user : $rootScope.user
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						vm.loading = "";
						vm.clientes = response.clientes;
						vm.formasDePago = response.formasDePago;
						vm.productos = response.productos;
						vm.unidadesMedida = response.unidadesMedida;
						vm.clavesProducto = response.clavesProducto;
						vm.usosCFDI = response.usosCFDI;
						vm.series = response.series;
						vm.factura.lugarExpedicion = response.proveedor.domicilio.codigoPostal;
						vm.usosCFDITmp = response.usosCFDI;

					}

				}, function errorCallback(response) {
					vm.obtenerDatos();
				  });
        	};


        	vm.opcionesFactura = function(){

                ngDialog.openConfirm({
                    template: 'opcionesFactura',
                    className: 'ngdialog-theme-default large-ngDialog',
                    controller: 'OpcionesFacturaController',
                    data: {factura: vm.factura}
                }).then(function (buscar) {

                }, function (factura) {

                	if(factura.tipoDocumento != undefined){
                		vm.factura.impuestosTrasladados = factura.impuestosTrasladados;
                		vm.factura.impuestosRetenidos = factura.impuestosRetenidos;
                		vm.factura.cuentaPredial = factura.cuentaPredial;
                		vm.factura.moneda = factura.moneda;
                		vm.factura.tipoCambio = factura.tipoCambio;
                		vm.factura.truncar = factura.truncar;
                	}

                	vm.calcularTotales();
                });

            };



            vm.facturaRelacionada = function(){

            	vm.factura.facturasRelacionadas.noFactura = '';

                ngDialog.openConfirm({
                    template: 'facturasRelacionadas',
                    className: 'ngdialog-theme-default',
                    controller: 'FacturasRelacionadasController',
                    data: {tipoRelaciones: vm.tipoRelaciones, facturasRelacionadas: vm.factura.facturasRelacionadas}
                }).then(function (documento) {

                }, function (documento) {
                	console.log(documento);
                	if(documento.tipoRelacion != undefined){
                		vm.factura.facturasRelacionadas = documento;
                	}
                });

            };

            vm.agregrProdExistente = function(){
            	if(vm.productoAgregar.id_producto != undefined){
            		vm.productoAgregar.precioU = Number(vm.productoAgregar.precioU);
            		vm.productoAgregar.qty = 1;
            		vm.productoAgregar.descuento = 0;
            		vm.factura.detalles.push(angular.copy(vm.productoAgregar));
            		vm.productoAgregar = '';
            	}

            	vm.calcularTotales();
            };


            vm.agregrProdNuevo = function(){
            		var productoNuevo = {
            			codigo: '1',
            			clave: '',
            			nombre: '',
            			unidad: '',
            			qty: 1,
            			precioU: 1.00,
            			descuento: 0
            		};
            		vm.factura.detalles.push(productoNuevo);
            		vm.productoAgregar = '';

            	vm.calcularTotales();
            };

            vm.calcularTotales = function(){

            	vm.factura.subtotal = 0;
            	vm.factura.total = 0;
            	vm.factura.base = 0;
            	vm.factura.descuento = 0;
            	vm.factura.totalTraslados = 0;
            	vm.factura.totalRetenciones = 0;

            	for(var y = 0; y < vm.factura.impuestosTrasladados.length; y++){
        			vm.factura.impuestosTrasladados[y].total = 0;
            	}

            	for(var y = 0; y < vm.factura.impuestosRetenidos.length; y++){
        			vm.factura.impuestosRetenidos[y].total = 0;
            	}

            	for(var x = 0; x < vm.factura.detalles.length; x++){

            		vm.factura.detalles[x].precioU = $rootScope.toFixedNumber(vm.factura.detalles[x].precioU);
            		vm.factura.detalles[x].descuento = $rootScope.toFixedNumber(vm.factura.detalles[x].descuento);

            		var baseItem = $rootScope.toFixedNumberSpecial((vm.factura.detalles[x].qty * vm.factura.detalles[x].precioU))
            		vm.factura.subtotal += baseItem;
            		vm.factura.detalles[x].base = baseItem - vm.factura.detalles[x].descuento;
            		vm.factura.descuento += Number(vm.factura.detalles[x].descuento);

            		for(var y = 0; y < vm.factura.impuestosTrasladados.length; y++){

            			var valorImpuesto = 0;
                		if(vm.factura.impuestosTrasladados[y].factor == 'Tasa'){
                			valorImpuesto = vm.factura.impuestosTrasladados[y].valor * vm.factura.detalles[x].base;
                		}else{
                			valorImpuesto = vm.factura.impuestosTrasladados[y].valor;
                		}

                		if(vm.factura.truncar == '1'){
                			valorImpuesto = $rootScope.truncateNumbers(valorImpuesto);
                		}else{
                			valorImpuesto = $rootScope.toFixedNumberSpecial(valorImpuesto);
                		}

                		vm.factura.impuestosTrasladados[y].total += valorImpuesto;
                		vm.factura.totalTraslados += valorImpuesto ;
                	}


            		for(var y = 0; y < vm.factura.impuestosRetenidos.length; y++){

            			var valorImpuesto = 0;
                		if(vm.factura.impuestosRetenidos[y].factor == 'Tasa'){
                			var valorImpRet = vm.factura.impuestosRetenidos[y].valor;
                			var valorBaseProd = vm.factura.detalles[x].base;

                			valorImpuesto = valorImpRet * valorBaseProd;
                		}else{
                			valorImpuesto = vm.factura.impuestosRetenidos[y].valor;
                		}

                		if(vm.factura.truncar == '1'){
                			valorImpuesto = $rootScope.truncateNumbers(valorImpuesto);
                		}else{
                			valorImpuesto = $rootScope.toFixedNumberSpecial(valorImpuesto);
                		}

                		vm.factura.impuestosRetenidos[y].total += valorImpuesto;
                		vm.factura.totalRetenciones += valorImpuesto ;
                	}

            	}

            	vm.factura.total = vm.factura.base = vm.factura.subtotal - vm.factura.descuento;
            	vm.factura.total += (vm.factura.totalTraslados - vm.factura.totalRetenciones);
            	vm.factura.total = $rootScope.toFixedNumber(vm.factura.total);

            };


            vm.calcularTotalesEspecial = function(){

            	vm.factura.subtotal = 0;
            	vm.factura.total = 0;
            	vm.factura.base = 0;
            	vm.factura.descuento = 0;
            	vm.factura.totalTraslados = 0;
            	vm.factura.totalRetenciones = 0;

            	for(var x = 0; x < vm.factura.detalles.length; x++){

            		vm.factura.detalles[x].precioU = $rootScope.toFixedNumber(vm.factura.detalles[x].precioU);
            		vm.factura.detalles[x].descuento = $rootScope.toFixedNumber(vm.factura.detalles[x].descuento);

            		var baseItem = $rootScope.toFixedNumberSpecial((vm.factura.detalles[x].qty * vm.factura.detalles[x].precioU))
            		vm.factura.subtotal += baseItem;
            		vm.factura.detalles[x].base = baseItem - vm.factura.detalles[x].descuento;
            		vm.factura.descuento += Number(vm.factura.detalles[x].descuento);

            		for(var y = 0; y < vm.factura.impuestosTrasladados.length; y++){

                		valorImpuesto = Number(vm.factura.impuestosTrasladados[y].total);
                		vm.factura.impuestosTrasladados[y].total = valorImpuesto;
                		vm.factura.totalTraslados += valorImpuesto ;
                	}


            		for(var y = 0; y < vm.factura.impuestosRetenidos.length; y++){

            			var valorImpuesto = Number(vm.factura.impuestosRetenidos[y].total);
                		vm.factura.impuestosRetenidos[y].total = valorImpuesto;
                		vm.factura.totalRetenciones += valorImpuesto ;
                	}

            	}

            	vm.factura.total = vm.factura.base = vm.factura.subtotal - vm.factura.descuento;
            	vm.factura.total += (vm.factura.totalTraslados - vm.factura.totalRetenciones);
            	vm.factura.total = $rootScope.toFixedNumber(vm.factura.total);

            };

            vm.borrarConcepto = function(index){
            	vm.factura.detalles.splice(index, 1);
            	vm.calcularTotales();
            };


            /////Funcionalidad select de mobile para customer
            vm.getMatchesCustomer = function(searchText) {
				if(searchText == "" || searchText == null)
					return vm.clientes;
		            var states = vm.clientes.filter(function(customer) {
		            	var pordChane = customer.nmbRecep + " " + customer.rFCRecep;
		                return (pordChane.toUpperCase().match(searchText.toUpperCase()));
		            });

		        return states;
		    }

            vm.selectedCustomer = function(cliente){
				if(typeof(cliente) != 'undefined' && typeof(cliente.id_cliente) != 'undefined'){
					vm.factura.id_cliente = cliente;
					vm.obtenerPaises();
				}else{
					vm.factura.id_cliente = 0;
				}
			};
			////////////////////////////

			vm.obtenerPaises = function(){

				vm.usosCFDITmp = [];

				if(isNaN(Number(vm.factura.id_cliente.rFCRecep.charAt(3)))){

					vm.usosCFDITmp = vm.usosCFDI;

				}else{
					for(var x = 0; x < vm.usosCFDI.length; x++){
						if(vm.usosCFDI[x].validMoral == 1){
							vm.usosCFDITmp.push(vm.usosCFDI[x]);
						}
					}
				}

				vm.factura.formaPago = vm.factura.id_cliente.metodoPago;
				vm.factura.usoCFDI = vm.factura.id_cliente.usoCFDI

				if( vm.factura.id_cliente!= null && vm.factura.id_cliente.rFCRecep == 'XEXX010101000'){

					$http.post('/api/admin/facturacion/obtenerPaises', {
						user : $rootScope.user
					}).then(function(res) {
						var response = res['data'];
						if (response['success']) {

							vm.loading = "";
							vm.paises = response.paises;
						}

					}, function errorCallback(response) {
						vm.obtenerDatos();
					  });

				}
			};

			vm.borrarFacturaRelacionada = function(index){
				vm.factura.facturasRelacionadas.uuids.splice(index, 1);
			};


			vm.seleccionarMetodoPago = function(){
				if(vm.factura.metodoDePago == 'PPD'){
					vm.factura.formaPago = '99';
					$("#formaPago").trigger("chosen:updated");
				}
			};


			vm.facturar = function(){

				if(vm.factura.id_cliente == '' || vm.factura.id_cliente == null){
					Notify.alert('Debe seleccionar un cliente.', {status: 'danger'});
					$('#id_cliente').trigger('chosen:activate');
					return;
				}

				if(vm.factura.formaPago == '' || vm.factura.formaPago == null){
					Notify.alert('Debe seleccionar una forma de pago.', {status: 'danger'});
					$('#formaPago').trigger('chosen:activate');
					$('#formaPago').focus();
					return;
				}


				if(vm.factura.lugarExpedicion == '' || vm.factura.lugarExpedicion == null || vm.factura.lugarExpedicion.length < 5 ){
					Notify.alert('Debe ingresar un lugar de expedición correcto (C.P.)', {status: 'danger'});
					$('#lugarExpedicion').focus();
					return;
				}


				if(vm.factura.usoCFDI == '' || vm.factura.usoCFDI == null || vm.factura.usoCFDI == '0'){
					Notify.alert('Debe seleccionar el uso del CFDI.', {status: 'danger'});
					$('#usoCFDI').trigger('chosen:activate');
					$('#usoCFDI').focus();
					return;
				}

				if(vm.factura.detalles.length == 0){
					Notify.alert('Debe agregar al menos un producto.', {status: 'danger'});
					return;
				}

				for(var x = 0; x < vm.factura.detalles.length; x++){

					var concepto = vm.factura.detalles[x];

					if(concepto.clave == ''){
						Notify.alert('Debe seleccionar una clave para cada concepto.', {status: 'danger'});
						$('#clave' + x).focus();
						$('#clave' + x).trigger('chosen:activate');
						return;
					}

					if(concepto.nombre == ''){
						Notify.alert('Debe agregar una descripción para cada concepto.', {status: 'danger'});
						$('#nombre' + x).focus();
						return;
					}

					if(concepto.unidad == null || concepto.unidad == ''){
						Notify.alert('Debe seleccionar una unidad para cada concepto.', {status: 'danger'});
						$('#unidad' + x).focus();
						$('#unidad' + x).trigger('chosen:activate');
						return;
					}

					if(concepto.qty == null || concepto.qty < 0.00001){
						Notify.alert('La cantidad por concepto debe ser al mayor a 0.', {status: 'danger'});
						$('#qty' + x).focus();
						return;
					}

					if(concepto.precioU == null){
						Notify.alert('Debe ingresar un precio unitario.', {status: 'danger'});
						$('#precioU' + x).focus();
						return;
					}

				}

				vm.loading = "whirl double-up";

				var urlFacturar = '/api/admin/facturacion/facturar';
				$http.post(urlFacturar, {
					user : $rootScope.user,
					factura: vm.factura
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						SweetAlert.swal('Éxito!', 'Se generó su factura de forma correcta con el No. ' + response.facturaResult, 'success');
						$state.transitionTo('app.listadoFacturas');

					}else{
						SweetAlert.swal('Error!', response.errorCode + ' - ' + response.errortext + ' <br>' + response.nombreArchivo, 'error');
					}

					vm.loading = "";

				}, function errorCallback(response) {
					vm.loading = "";
				});



			};


			vm.facturarTest = function(){

				if(vm.factura.id_cliente == '' || vm.factura.id_cliente == null){
					Notify.alert('Debe seleccionar un cliente.', {status: 'danger'});
					$('#id_cliente').trigger('chosen:activate');
					return;
				}

				if(vm.factura.formaPago == '' || vm.factura.formaPago == null){
					Notify.alert('Debe seleccionar una forma de pago.', {status: 'danger'});
					$('#formaPago').trigger('chosen:activate');
					$('#formaPago').focus();
					return;
				}


				if(vm.factura.lugarExpedicion == '' || vm.factura.lugarExpedicion == null || vm.factura.lugarExpedicion.length < 5 ){
					Notify.alert('Debe ingresar un lugar de expedición correcto (C.P.)', {status: 'danger'});
					$('#lugarExpedicion').focus();
					return;
				}


				if(vm.factura.usoCFDI == '' || vm.factura.usoCFDI == null || vm.factura.usoCFDI == '0'){
					Notify.alert('Debe seleccionar el uso del CFDI.', {status: 'danger'});
					$('#usoCFDI').trigger('chosen:activate');
					$('#usoCFDI').focus();
					return;
				}

				if(vm.factura.detalles.length == 0){
					Notify.alert('Debe agregar al menos un producto.', {status: 'danger'});
					return;
				}

				for(var x = 0; x < vm.factura.detalles.length; x++){

					var concepto = vm.factura.detalles[x];

					if(concepto.clave == ''){
						Notify.alert('Debe seleccionar una clave para cada concepto.', {status: 'danger'});
						$('#clave' + x).focus();
						$('#clave' + x).trigger('chosen:activate');
						return;
					}

					if(concepto.nombre == ''){
						Notify.alert('Debe agregar una descripción para cada concepto.', {status: 'danger'});
						$('#nombre' + x).focus();
						return;
					}

					if(concepto.unidad == null || concepto.unidad == ''){
						Notify.alert('Debe seleccionar una unidad para cada concepto.', {status: 'danger'});
						$('#unidad' + x).focus();
						$('#unidad' + x).trigger('chosen:activate');
						return;
					}

					if(concepto.qty == null || concepto.qty < 0.00001){
						Notify.alert('La cantidad por concepto debe ser al mayor a 0.', {status: 'danger'});
						$('#qty' + x).focus();
						return;
					}

					if(concepto.precioU == null){
						Notify.alert('Debe ingresar un precio unitario.', {status: 'danger'});
						$('#precioU' + x).focus();
						return;
					}

				}

				vm.loading = "whirl double-up";


				$http.post('/api/admin/facturacion/facturarTest', {
					user : $rootScope.user,
					factura: vm.factura
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						SweetAlert.swal('Éxito!', 'Se generó su factura de forma correcta con el No. ' + response.facturaResult, 'success');
						$state.transitionTo('app.listadoFacturas');

					}else{
						SweetAlert.swal('Error!', response.errorCode + ' - ' + response.errortext + ' <br>' + response.nombreArchivo, 'error');
					}

					vm.loading = "";

				}, function errorCallback(response) {
					vm.loading = "";
				});



			};



        	vm.obtenerDatos();



        }
    }
})();



(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('NuevaFacturaComercioController', NuevaFacturaComercioController);

    NuevaFacturaComercioController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder', 'ngDialog'];

    function NuevaFacturaComercioController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder, ngDialog) {
        var vm = this;

        vm.clientes = [];
        vm.formasDePago = [];
        vm.productos = [];
        vm.unidadesMedida = [];
		vm.clavesProducto = [];
		vm.usosCFDI = [];
		vm.usosCFDITmp = [];
		vm.searchTextCustomer = '';
		vm.series = [];
        vm.factura = {
        		tipoDocumento: 'I',
        		isComercio: 1,
        		id_cliente: '',
            	decimales: '2',
        		impuestosRetenidos : [],
        		guardarProd: false,
        		impuestosTrasladados : [{factor: 'Tasa', valor: 0.16, impuesto: '002', label: 'IVA'}],
        		moneda: 'MXN',
        		tipoCambio: 1.0,
        		detalles: [],
        		descuento: 0,
        		facturasRelacionadas: {
            		tipoRelacion: '',
            		noFactura: '',
            		uuids: []

            	},
        		cuentaPredial: '',
        		formaPago: '',
        		lugarExpedicion: '',
        		serie: 'A',
        		metodoDePago: 'PUE',
        		comercio: {
        			incoterm: '',
        			pedimento: 'A1',
        			tipoOperacion: 2,
        			rfcExtranjero: ''
        		}

        }
        vm.productoAgregar = '';
        vm.tipoRelaciones = [
                             {value: '01', label: 'Nota de crédito de los documentos relacionados'},
                             {value: '02', label: 'Nota de débito de los documentos relacionados'},
                             {value: '03', label: 'Devolución de mercancía sobre facturas o traslados previos'},
                             {value: '04', label: 'Sustitución de los CFDI previos'},
                             {value: '05', label: 'Traslados de mercancias facturados previamente'},
                             {value: '06', label: 'Factura generada por los traslados previos'},
                             {value: '07', label: 'CFDI por aplicación de anticipo'}
                            ];
        vm.metodosDePago = [{codigo: 'PUE', descripcion: 'Pago en una sola exhibición'}, {codigo: 'PPD', descripcion: 'Pago en parcialidades o diferido'}];

        vm.cambiarTipoDocumento = function(tipo){
        	vm.factura.tipoDocumento = tipo;
        	if(vm.factura.tipoDocumento == 'P')
        		$state.transitionTo('app.nuevoPago');
        };

        activate();

        ////////////////

        function activate() {

        	if($rootScope.user.id_proveedor == 943){
				console.log("Si entro acá");
			}

        	vm.obtenerNombreTipoRelacion = function(){
        		for(var x = 0; x < vm.tipoRelaciones.length; x++){
        			if(vm.tipoRelaciones[x].value == vm.factura.facturasRelacionadas.tipoRelacion){
        				return vm.tipoRelaciones[x].label;
        			}
        		}
        	};


        	vm.obtenerDatos = function(){

        		if($stateParams.tipoDocumento != undefined && $stateParams.tipoDocumento != ''){
        			vm.factura.tipoDocumento = $stateParams.tipoDocumento;
        		}

	        	vm.loading = "whirl double-up";

	        	$http.post('/api/admin/facturacion/datosFacturar', {
					user : $rootScope.user
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						vm.loading = "";
						vm.clientes = response.clientes;
						vm.formasDePago = response.formasDePago;
						vm.productos = response.productos;
						vm.unidadesMedida = response.unidadesMedida;
						vm.clavesProducto = response.clavesProducto;
						vm.usosCFDI = response.usosCFDI;
						vm.series = response.series;
						vm.factura.lugarExpedicion = response.proveedor.domicilio.codigoPostal;
						vm.usosCFDITmp = response.usosCFDI;
						vm.incoterms = response.incoterms;

					}

				}, function errorCallback(response) {
					vm.obtenerDatos();
				  });
        	};


        	vm.opcionesFactura = function(){

                ngDialog.openConfirm({
                    template: 'opcionesFactura',
                    className: 'ngdialog-theme-default large-ngDialog',
                    controller: 'OpcionesFacturaController',
                    data: {factura: vm.factura}
                }).then(function (buscar) {

                }, function (factura) {

                	if(factura.tipoDocumento != undefined){
                		vm.factura.impuestosTrasladados = factura.impuestosTrasladados;
                		vm.factura.impuestosRetenidos = factura.impuestosRetenidos;
                		vm.factura.cuentaPredial = factura.cuentaPredial;
                		vm.factura.moneda = factura.moneda;
                		vm.factura.tipoCambio = factura.tipoCambio;
                		vm.factura.truncar = factura.truncar;
                	}

                	vm.calcularTotales();
                });

            };



            vm.facturaRelacionada = function(){

            	vm.factura.facturasRelacionadas.noFactura = '';

                ngDialog.openConfirm({
                    template: 'facturasRelacionadas',
                    className: 'ngdialog-theme-default',
                    controller: 'FacturasRelacionadasController',
                    data: {tipoRelaciones: vm.tipoRelaciones, facturasRelacionadas: vm.factura.facturasRelacionadas}
                }).then(function (documento) {

                }, function (documento) {
                	console.log(documento);
                	if(documento.tipoRelacion != undefined){
                		vm.factura.facturasRelacionadas = documento;
                	}
                });

            };

            vm.agregrProdExistente = function(){
            	if(vm.productoAgregar.id_producto != undefined){
            		vm.productoAgregar.precioU = Number(vm.productoAgregar.precioU);
            		vm.productoAgregar.qty = 1;
            		vm.productoAgregar.descuento = 0;
            		vm.factura.detalles.push(angular.copy(vm.productoAgregar));
            		vm.productoAgregar = '';
            	}

            	vm.calcularTotales();
            };


            vm.agregrProdNuevo = function(){
            		var productoNuevo = {
            			codigo: '1',
            			clave: '',
            			nombre: '',
            			unidad: '',
            			qty: 1,
            			precioU: 1.00,
            			descuento: 0
            		};
            		vm.factura.detalles.push(productoNuevo);
            		vm.productoAgregar = '';

            	vm.calcularTotales();
            };

            vm.calcularTotales = function(){

            	vm.factura.subtotal = 0;
            	vm.factura.total = 0;
            	vm.factura.base = 0;
            	vm.factura.descuento = 0;
            	vm.factura.totalTraslados = 0;
            	vm.factura.totalRetenciones = 0;

            	for(var y = 0; y < vm.factura.impuestosTrasladados.length; y++){
        			vm.factura.impuestosTrasladados[y].total = 0;
            	}

            	for(var y = 0; y < vm.factura.impuestosRetenidos.length; y++){
        			vm.factura.impuestosRetenidos[y].total = 0;
            	}

            	for(var x = 0; x < vm.factura.detalles.length; x++){

            		vm.factura.detalles[x].precioU = $rootScope.toFixedNumber(vm.factura.detalles[x].precioU);
            		vm.factura.detalles[x].descuento = $rootScope.toFixedNumber(vm.factura.detalles[x].descuento);

            		var baseItem = $rootScope.toFixedNumberSpecial((vm.factura.detalles[x].qty * vm.factura.detalles[x].precioU))
            		vm.factura.subtotal += baseItem;
            		vm.factura.detalles[x].base = baseItem - vm.factura.detalles[x].descuento;
            		vm.factura.descuento += Number(vm.factura.detalles[x].descuento);

            		for(var y = 0; y < vm.factura.impuestosTrasladados.length; y++){

            			var valorImpuesto = 0;
                		if(vm.factura.impuestosTrasladados[y].factor == 'Tasa'){
                			valorImpuesto = vm.factura.impuestosTrasladados[y].valor * vm.factura.detalles[x].base;
                		}else{
                			valorImpuesto = vm.factura.impuestosTrasladados[y].valor;
                		}

                		valorImpuesto = $rootScope.toFixedNumberSpecial(valorImpuesto);

                		vm.factura.impuestosTrasladados[y].total += valorImpuesto;
                		vm.factura.totalTraslados += valorImpuesto ;
                	}


            		for(var y = 0; y < vm.factura.impuestosRetenidos.length; y++){

            			var valorImpuesto = 0;
                		if(vm.factura.impuestosRetenidos[y].factor == 'Tasa'){
                			valorImpuesto = vm.factura.impuestosRetenidos[y].valor * vm.factura.detalles[x].base;
                		}else{
                			valorImpuesto = vm.factura.impuestosRetenidos[y].valor;
                		}

                		valorImpuesto = $rootScope.toFixedNumberSpecial(valorImpuesto);

                		vm.factura.impuestosRetenidos[y].total += valorImpuesto;
                		vm.factura.totalRetenciones += valorImpuesto ;
                	}

            	}

            	vm.factura.total = vm.factura.base = vm.factura.subtotal - vm.factura.descuento;
            	vm.factura.total += (vm.factura.totalTraslados - vm.factura.totalRetenciones);
            	vm.factura.total = $rootScope.toFixedNumber(vm.factura.total);

            };

            vm.borrarConcepto = function(index){
            	vm.factura.detalles.splice(index, 1);
            	vm.calcularTotales();
            };


            /////Funcionalidad select de mobile para customer
            vm.getMatchesCustomer = function(searchText) {
				if(searchText == "" || searchText == null)
					return vm.clientes;
		            var states = vm.clientes.filter(function(customer) {
		            	var pordChane = customer.nmbRecep + " " + customer.rFCRecep;
		                return (pordChane.toUpperCase().match(searchText.toUpperCase()));
		            });

		        return states;
		    }

            vm.selectedCustomer = function(cliente){
				if(typeof(cliente) != 'undefined' && typeof(cliente.id_cliente) != 'undefined'){
					vm.factura.id_cliente = cliente;
					vm.obtenerPaises();
				}else{
					vm.factura.id_cliente = 0;
				}
			};
			////////////////////////////

			vm.obtenerPaises = function(){

				vm.usosCFDITmp = [];

				if(isNaN(Number(vm.factura.id_cliente.rFCRecep.charAt(3)))){

					vm.usosCFDITmp = vm.usosCFDI;

				}else{
					for(var x = 0; x < vm.usosCFDI.length; x++){
						if(vm.usosCFDI[x].validMoral == 1){
							vm.usosCFDITmp.push(vm.usosCFDI[x]);
						}
					}
				}

				vm.factura.formaPago = vm.factura.id_cliente.metodoPago;
				vm.factura.usoCFDI = vm.factura.id_cliente.usoCFDI

				if( vm.factura.id_cliente!= null && vm.factura.id_cliente.rFCRecep == 'XEXX010101000'){

					$http.post('/api/admin/facturacion/obtenerPaises', {
						user : $rootScope.user
					}).then(function(res) {
						var response = res['data'];
						if (response['success']) {

							vm.loading = "";
							vm.paises = response.paises;
						}

					}, function errorCallback(response) {
						vm.obtenerDatos();
					  });

				}
			};


			vm.obtenerEstados = function(tipoDato){

				var pais = (tipoDato == 1)? vm.factura.comercio.emisor.pais : vm.factura.comercio.receptor.pais;

				$http.post('/api/admin/facturacion/obtenerEstados', {
					user : $rootScope.user,
					pais: pais
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						vm.loading = "";
						if(tipoDato == 1){
							vm.estados = response.estados;
						}else{
							vm.estadosR = response.estados;
						}

					}

				}, function errorCallback(response) {
				 });

			}

			vm.obtenerMunicipios = function(tipoDato){

				var estado = (tipoDato == 1)? vm.factura.comercio.emisor.estado : vm.factura.comercio.receptor.estado;

				$http.post('/api/admin/facturacion/obtenerMunicipios', {
					user : $rootScope.user,
					estado: estado
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						vm.loading = "";
						vm.municipios = response.municipios;
						if(tipoDato == 1){
							vm.municipios = response.municipios;
						}else{
							vm.municipiosR = response.municipios;
						}
					}

				}, function errorCallback(response) {
				 });

			}

			vm.borrarFacturaRelacionada = function(index){
				vm.factura.facturasRelacionadas.uuids.splice(index, 1);
			};


			vm.seleccionarMetodoPago = function(){
				if(vm.factura.metodoDePago == 'PPD'){
					vm.factura.formaPago = '99';
					$("#formaPago").trigger("chosen:updated");
				}
			};


			vm.facturar = function(){

				if(vm.factura.id_cliente == '' || vm.factura.id_cliente == null){
					Notify.alert('Debe seleccionar un cliente.', {status: 'danger'});
					$('#id_cliente').trigger('chosen:activate');
					return;
				}

				if(vm.factura.formaPago == '' || vm.factura.formaPago == null){
					Notify.alert('Debe seleccionar una forma de pago.', {status: 'danger'});
					$('#formaPago').trigger('chosen:activate');
					$('#formaPago').focus();
					return;
				}


				if(vm.factura.lugarExpedicion == '' || vm.factura.lugarExpedicion == null || vm.factura.lugarExpedicion.length < 5 ){
					Notify.alert('Debe ingresar un lugar de expedición correcto (C.P.)', {status: 'danger'});
					$('#lugarExpedicion').focus();
					return;
				}


				if(vm.factura.usoCFDI == '' || vm.factura.usoCFDI == null || vm.factura.usoCFDI == '0'){
					Notify.alert('Debe seleccionar el uso del CFDI.', {status: 'danger'});
					$('#usoCFDI').trigger('chosen:activate');
					$('#usoCFDI').focus();
					return;
				}

				if(vm.factura.detalles.length == 0){
					Notify.alert('Debe agregar al menos un producto.', {status: 'danger'});
					return;
				}

				for(var x = 0; x < vm.factura.detalles.length; x++){

					var concepto = vm.factura.detalles[x];

					if(concepto.clave == ''){
						Notify.alert('Debe seleccionar una clave para cada concepto.', {status: 'danger'});
						$('#clave' + x).focus();
						$('#clave' + x).trigger('chosen:activate');
						return;
					}

					if(concepto.nombre == ''){
						Notify.alert('Debe agregar una descripción para cada concepto.', {status: 'danger'});
						$('#nombre' + x).focus();
						return;
					}

					if(concepto.unidad == null || concepto.unidad == ''){
						Notify.alert('Debe seleccionar una unidad para cada concepto.', {status: 'danger'});
						$('#unidad' + x).focus();
						$('#unidad' + x).trigger('chosen:activate');
						return;
					}

					if(concepto.qty == null || concepto.qty < 0.00001){
						Notify.alert('La cantidad por concepto debe ser al mayor a 0.', {status: 'danger'});
						$('#qty' + x).focus();
						return;
					}

					if(concepto.precioU == null){
						Notify.alert('Debe ingresar un precio unitario.', {status: 'danger'});
						$('#precioU' + x).focus();
						return;
					}

				}

				vm.loading = "whirl double-up";

				var urlFacturar = '/api/admin/facturacion/facturar';
				$http.post(urlFacturar, {
					user : $rootScope.user,
					factura: vm.factura
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						SweetAlert.swal('Éxito!', 'Se generó su factura de forma correcta con el No. ' + response.facturaResult, 'success');
						$state.transitionTo('app.listadoFacturas');

					}else{
						SweetAlert.swal('Error!', response.errorCode + ' - ' + response.errortext + ' <br>' + response.nombreArchivo, 'error');
					}

					vm.loading = "";

				}, function errorCallback(response) {
					vm.loading = "";
				});



			};


			vm.facturarTest = function(){

				if(vm.factura.id_cliente == '' || vm.factura.id_cliente == null){
					Notify.alert('Debe seleccionar un cliente.', {status: 'danger'});
					$('#id_cliente').trigger('chosen:activate');
					return;
				}

				if(vm.factura.formaPago == '' || vm.factura.formaPago == null){
					Notify.alert('Debe seleccionar una forma de pago.', {status: 'danger'});
					$('#formaPago').trigger('chosen:activate');
					$('#formaPago').focus();
					return;
				}


				if(vm.factura.lugarExpedicion == '' || vm.factura.lugarExpedicion == null || vm.factura.lugarExpedicion.length < 5 ){
					Notify.alert('Debe ingresar un lugar de expedición correcto (C.P.)', {status: 'danger'});
					$('#lugarExpedicion').focus();
					return;
				}


				if(vm.factura.usoCFDI == '' || vm.factura.usoCFDI == null || vm.factura.usoCFDI == '0'){
					Notify.alert('Debe seleccionar el uso del CFDI.', {status: 'danger'});
					$('#usoCFDI').trigger('chosen:activate');
					$('#usoCFDI').focus();
					return;
				}

				if(vm.factura.detalles.length == 0){
					Notify.alert('Debe agregar al menos un producto.', {status: 'danger'});
					return;
				}

				for(var x = 0; x < vm.factura.detalles.length; x++){

					var concepto = vm.factura.detalles[x];

					if(concepto.clave == ''){
						Notify.alert('Debe seleccionar una clave para cada concepto.', {status: 'danger'});
						$('#clave' + x).focus();
						$('#clave' + x).trigger('chosen:activate');
						return;
					}

					if(concepto.nombre == ''){
						Notify.alert('Debe agregar una descripción para cada concepto.', {status: 'danger'});
						$('#nombre' + x).focus();
						return;
					}

					if(concepto.unidad == null || concepto.unidad == ''){
						Notify.alert('Debe seleccionar una unidad para cada concepto.', {status: 'danger'});
						$('#unidad' + x).focus();
						$('#unidad' + x).trigger('chosen:activate');
						return;
					}

					if(concepto.qty == null || concepto.qty < 0.00001){
						Notify.alert('La cantidad por concepto debe ser al mayor a 0.', {status: 'danger'});
						$('#qty' + x).focus();
						return;
					}

					if(concepto.precioU == null){
						Notify.alert('Debe ingresar un precio unitario.', {status: 'danger'});
						$('#precioU' + x).focus();
						return;
					}

				}

				vm.loading = "whirl double-up";


				$http.post('/api/admin/facturacion/facturarTest', {
					user : $rootScope.user,
					factura: vm.factura
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						SweetAlert.swal('Éxito!', 'Se generó su factura de forma correcta con el No. ' + response.facturaResult, 'success');
						$state.transitionTo('app.listadoFacturas');

					}else{
						SweetAlert.swal('Error!', response.errorCode + ' - ' + response.errortext + ' <br>' + response.nombreArchivo, 'error');
					}

					vm.loading = "";

				}, function errorCallback(response) {
					vm.loading = "";
				});



			};



        	vm.obtenerDatos();



        }
    }
})();




(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('NuevaFacturaConceptoController', NuevaFacturaConceptoController);

    NuevaFacturaConceptoController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder', 'ngDialog'];

    function NuevaFacturaConceptoController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder, ngDialog) {
        var vm = this;

        vm.clientes = [];
        vm.formasDePago = [];
        vm.productos = [];
        vm.unidadesMedida = [];
		vm.clavesProducto = [];
		vm.usosCFDI = [];
		vm.usosCFDITmp = [];
		vm.searchTextCustomer = '';
		vm.series = [];
        vm.factura = {
        		tipoDocumento: 'I',
        		id_cliente: '',
            	decimales: '2',
        		guardarProd: false,
        		moneda: 'MXN',
        		tipoCambio: 1.0,
        		detalles: [],
        		descuento: 0,
        		facturasRelacionadas: {
            		tipoRelacion: '',
            		noFactura: '',
            		uuids: []

            	},
        		cuentaPredial: '',
        		formaPago: '',
        		lugarExpedicion: '',
        		serie: 'A',
        		metodoDePago: 'PUE'
        }
        vm.productoAgregar = '';
        vm.tipoRelaciones = [
                             {value: '01', label: 'Nota de crédito de los documentos relacionados'},
                             {value: '02', label: 'Nota de débito de los documentos relacionados'},
                             {value: '03', label: 'Devolución de mercancía sobre facturas o traslados previos'},
                             {value: '04', label: 'Sustitución de los CFDI previos'},
                             {value: '05', label: 'Traslados de mercancias facturados previamente'},
                             {value: '06', label: 'Factura generada por los traslados previos'},
                             {value: '07', label: 'CFDI por aplicación de anticipo'}
                            ];
        vm.metodosDePago = [{codigo: 'PUE', descripcion: 'Pago en una sola exhibición'}, {codigo: 'PPD', descripcion: 'Pago en parcialidades o diferido'}];

        vm.cambiarTipoDocumento = function(tipo){
        	vm.factura.tipoDocumento = tipo;
        	if(vm.factura.tipoDocumento == 'P')
        		$state.transitionTo('app.nuevoPago');
        };

        activate();

        ////////////////

        function activate() {

        	vm.obtenerNombreTipoRelacion = function(){
        		for(var x = 0; x < vm.tipoRelaciones.length; x++){
        			if(vm.tipoRelaciones[x].value == vm.factura.facturasRelacionadas.tipoRelacion){
        				return vm.tipoRelaciones[x].label;
        			}
        		}
        	};


        	vm.obtenerDatos = function(){

        		if($stateParams.tipoDocumento != undefined && $stateParams.tipoDocumento != ''){
        			vm.factura.tipoDocumento = $stateParams.tipoDocumento;
        		}

	        	vm.loading = "whirl double-up";

	        	$http.post('/api/admin/facturacion/datosFacturar', {
					user : $rootScope.user
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						vm.loading = "";
						vm.clientes = response.clientes;
						vm.formasDePago = response.formasDePago;
						vm.productos = response.productos;
						vm.unidadesMedida = response.unidadesMedida;
						vm.clavesProducto = response.clavesProducto;
						vm.usosCFDI = response.usosCFDI;
						vm.series = response.series;
						vm.factura.lugarExpedicion = response.proveedor.domicilio.codigoPostal;
						vm.usosCFDITmp = response.usosCFDI;

					}

				}, function errorCallback(response) {
					vm.obtenerDatos();
				  });
        	};


        	vm.opcionesFactura = function(){

                ngDialog.openConfirm({
                    template: 'opcionesFactura',
                    className: 'ngdialog-theme-default large-ngDialog',
                    controller: 'OpcionesFacturaController',
                    data: {factura: vm.factura}
                }).then(function (buscar) {

                }, function (factura) {

                	if(factura.tipoDocumento != undefined){
                		vm.factura.impuestosTrasladados = factura.impuestosTrasladados;
                		vm.factura.impuestosRetenidos = factura.impuestosRetenidos;
                		vm.factura.cuentaPredial = factura.cuentaPredial;
                		vm.factura.moneda = factura.moneda;
                		vm.factura.tipoCambio = factura.tipoCambio;
                		vm.factura.truncar = factura.truncar;
                	}

                	vm.calcularTotales();
                });

            };



            vm.facturaRelacionada = function(){

            	vm.factura.facturasRelacionadas.noFactura = '';

                ngDialog.openConfirm({
                    template: 'facturasRelacionadas',
                    className: 'ngdialog-theme-default',
                    controller: 'FacturasRelacionadasController',
                    data: {tipoRelaciones: vm.tipoRelaciones, facturasRelacionadas: vm.factura.facturasRelacionadas}
                }).then(function (documento) {

                }, function (documento) {
                	if(documento.tipoRelacion != undefined){
                		vm.factura.facturasRelacionadas = documento;
                	}
                });

            };


            vm.impuestosConcepto = function(index){

            	var concepto = vm.factura.detalles[index];

                ngDialog.openConfirm({
                    template: 'impuestosConcepto',
                    className: 'ngdialog-theme-default large-ngDialog',
                    controller: 'ImpuestoConceptoController',
                    data: {concepto: concepto}
                }).then(function (concepto) {

                }, function (concepto) {
                	if(concepto.qty != undefined && concepto.qty > 0){
                		vm.factura.detalles[index] = concepto;
                		vm.calcularTotales();
                	}
                });

            };

            vm.agregrProdExistente = function(){
            	if(vm.productoAgregar.id_producto != undefined){
            		vm.productoAgregar.precioU = Number(vm.productoAgregar.precioU);
            		vm.productoAgregar.qty = 1;
            		vm.productoAgregar.descuento = 0;
            		vm.productoAgregar.impuestosTrasladados = [];
            		vm.productoAgregar.impuestosRetenidos = [];
            		vm.factura.detalles.push(angular.copy(vm.productoAgregar));
            		vm.productoAgregar = '';
            	}

            	vm.calcularTotales();
            };


            vm.agregrProdNuevo = function(){
            		var productoNuevo = {
            			codigo: '1',
            			clave: '',
            			nombre: '',
            			unidad: '',
            			qty: 1,
            			precioU: 1.00,
            			descuento: 0,
            			impuestosTrasladados: [],
            			impuestosRetenidos : []
            		};
            		vm.factura.detalles.push(productoNuevo);
            		vm.productoAgregar = '';

            	vm.calcularTotales();
            };

            vm.calcularTotales = function(){

            	vm.factura.subtotal = 0;
            	vm.factura.total = 0;
            	vm.factura.base = 0;
            	vm.factura.descuento = 0;
            	vm.factura.totalTraslados = 0;
            	vm.factura.totalRetenciones = 0;
            	vm.factura.impuestosTrasladados = [];
            	vm.factura.impuestosRetenidos = [];

            	console.log(vm.factura.detalles);

            	for(var x = 0; x < vm.factura.detalles.length; x++){

            		for(var y = 0; y < vm.factura.detalles[x].impuestosTrasladados.length; y++){
            			vm.factura.detalles[x].impuestosTrasladados[y].total = 0;
                	}

                	for(var y = 0; y < vm.factura.detalles[x].impuestosRetenidos.length; y++){
                		vm.factura.detalles[x].impuestosRetenidos[y].total = 0;
                	}

            		vm.factura.detalles[x].precioU = $rootScope.toFixedNumber(vm.factura.detalles[x].precioU);
            		vm.factura.detalles[x].descuento = $rootScope.toFixedNumber(vm.factura.detalles[x].descuento);

            		vm.factura.subtotal += $rootScope.toFixedNumber((vm.factura.detalles[x].qty * vm.factura.detalles[x].precioU));
            		vm.factura.detalles[x].base = (vm.factura.detalles[x].qty * vm.factura.detalles[x].precioU - vm.factura.detalles[x].descuento);
            		vm.factura.descuento += Number(vm.factura.detalles[x].descuento);


            		for(var y = 0; y < vm.factura.detalles[x].impuestosTrasladados.length; y++){

            			var tmp1 = vm.factura.detalles[x].impuestosTrasladados[y];
            			vm.factura.detalles[x].impuestosTrasladados[y].base = vm.factura.detalles[x].base;

            			var valorImpuesto = 0;
                		if(vm.factura.detalles[x].impuestosTrasladados[y].factor == 'Tasa'){
                			valorImpuesto = $rootScope.toFixedNumber(vm.factura.detalles[x].impuestosTrasladados[y].valor * vm.factura.detalles[x].impuestosTrasladados[y].base);
                		}else{
                			valorImpuesto = $rootScope.toFixedNumber(vm.factura.detalles[x].impuestosTrasladados[y].valor);
                		}
                		vm.factura.detalles[x].impuestosTrasladados[y].total = valorImpuesto;
                		vm.factura.totalTraslados += valorImpuesto ;

                		var addNewTax = true;

                		for(var z = 0; z < vm.factura.impuestosTrasladados.length; z++){

                			var tmp2 = vm.factura.impuestosTrasladados[z];

                			if(vm.factura.impuestosTrasladados[z].impuesto == vm.factura.detalles[x].impuestosTrasladados[y].impuesto
                					&& vm.factura.impuestosTrasladados[z].factor == vm.factura.detalles[x].impuestosTrasladados[y].factor
                						&& vm.factura.impuestosTrasladados[z].valor == vm.factura.detalles[x].impuestosTrasladados[y].valor){

                				vm.factura.impuestosTrasladados[z].total += valorImpuesto;
                				addNewTax = false;
                			}
                		}

                		if(addNewTax){
                			vm.factura.impuestosTrasladados.push(angular.copy(vm.factura.detalles[x].impuestosTrasladados[y]));
                		}

                	}


            		for(var y = 0; y < vm.factura.detalles[x].impuestosRetenidos.length; y++){

            			var valorImpuesto = 0;
            			vm.factura.detalles[x].impuestosRetenidos[y].base = vm.factura.detalles[x].base;

                		if(vm.factura.detalles[x].impuestosRetenidos[y].factor == 'Tasa'){
                			valorImpuesto = $rootScope.toFixedNumber(vm.factura.detalles[x].impuestosRetenidos[y].valor * vm.factura.detalles[x].impuestosRetenidos[y].base);
                		}else{
                			valorImpuesto = $rootScope.toFixedNumber(vm.factura.detalles[x].impuestosRetenidos[y].valor);
                		}
                		vm.factura.detalles[x].impuestosRetenidos[y].total += valorImpuesto;
                		vm.factura.totalRetenciones += valorImpuesto;

                		var addNewTax = true;

                		for(var z = 0; z < vm.factura.impuestosRetenidos.length; z++){
                			if(vm.factura.impuestosRetenidos[z].impuesto == vm.factura.detalles[x].impuestosRetenidos[y].impuesto
                					&& vm.factura.impuestosRetenidos[z].factor == vm.factura.detalles[x].impuestosRetenidos[y].factor
                						&& vm.factura.impuestosRetenidos[z].valor == vm.factura.detalles[x].impuestosRetenidos[y].valor){

                				vm.factura.impuestosRetenidos[z].total += valorImpuesto;
                				addNewTax = false;
                			}
                		}

                		if(addNewTax){
                			vm.factura.impuestosRetenidos.push(angular.copy(vm.factura.detalles[x].impuestosRetenidos[y]));
                		}
                	}

            	}

            	vm.factura.total = vm.factura.base = vm.factura.subtotal - vm.factura.descuento;
            	vm.factura.total += (vm.factura.totalTraslados - vm.factura.totalRetenciones);
            	vm.factura.total = $rootScope.toFixedNumber(vm.factura.total);

            };

            vm.borrarConcepto = function(index){
            	vm.factura.detalles.splice(index, 1);
            	vm.calcularTotales();
            };


            /////Funcionalidad select de mobile para customer
            vm.getMatchesCustomer = function(searchText) {
				if(searchText == "" || searchText == null)
					return vm.clientes;
		            var states = vm.clientes.filter(function(customer) {
		            	var pordChane = customer.nmbRecep + " " + customer.rFCRecep;
		                return (pordChane.toUpperCase().match(searchText.toUpperCase()));
		            });

		        return states;
		    }

            vm.selectedCustomer = function(cliente){
				if(typeof(cliente) != 'undefined' && typeof(cliente.id_cliente) != 'undefined'){
					vm.factura.id_cliente = cliente;
					vm.obtenerPaises();
				}else{
					vm.factura.id_cliente = 0;
				}
			};
			////////////////////////////

			vm.obtenerPaises = function(){

				vm.usosCFDITmp = [];

				if(isNaN(Number(vm.factura.id_cliente.rFCRecep.charAt(3)))){

					vm.usosCFDITmp = vm.usosCFDI;

				}else{
					for(var x = 0; x < vm.usosCFDI.length; x++){
						if(vm.usosCFDI[x].validMoral == 1){
							vm.usosCFDITmp.push(vm.usosCFDI[x]);
						}
					}
				}

				vm.factura.formaPago = vm.factura.id_cliente.metodoPago;
				vm.factura.usoCFDI = vm.factura.id_cliente.usoCFDI

				if( vm.factura.id_cliente!= null && vm.factura.id_cliente.rFCRecep == 'XEXX010101000'){

					$http.post('/api/admin/facturacion/obtenerPaises', {
						user : $rootScope.user
					}).then(function(res) {
						var response = res['data'];
						if (response['success']) {

							vm.loading = "";
							vm.paises = response.paises;
						}

					}, function errorCallback(response) {
						vm.obtenerDatos();
					  });

				}
			};

			vm.borrarFacturaRelacionada = function(index){
				vm.factura.facturasRelacionadas.uuids.splice(index, 1);
			};


			vm.seleccionarMetodoPago = function(){
				if(vm.factura.metodoDePago == 'PPD'){
					vm.factura.formaPago = '99';
					$("#formaPago").trigger("chosen:updated");
				}
			};


			vm.facturar = function(){

				if(vm.factura.id_cliente == '' || vm.factura.id_cliente == null){
					Notify.alert('Debe seleccionar un cliente.', {status: 'danger'});
					$('#id_cliente').trigger('chosen:activate');
					return;
				}

				if(vm.factura.formaPago == '' || vm.factura.formaPago == null){
					Notify.alert('Debe seleccionar una forma de pago.', {status: 'danger'});
					$('#formaPago').trigger('chosen:activate');
					$('#formaPago').focus();
					return;
				}


				if(vm.factura.lugarExpedicion == '' || vm.factura.lugarExpedicion == null || vm.factura.lugarExpedicion.length < 5 ){
					Notify.alert('Debe ingresar un lugar de expedición correcto (C.P.)', {status: 'danger'});
					$('#lugarExpedicion').focus();
					return;
				}


				if(vm.factura.usoCFDI == '' || vm.factura.usoCFDI == null){
					Notify.alert('Debe seleccionar el uso del CFDI.', {status: 'danger'});
					$('#usoCFDI').trigger('chosen:activate');
					$('#usoCFDI').focus();
					return;
				}

				if(vm.factura.detalles.length == 0){
					Notify.alert('Debe agregar al menos un producto.', {status: 'danger'});
					return;
				}

				for(var x = 0; x < vm.factura.detalles.length; x++){

					var concepto = vm.factura.detalles[x];

					if(concepto.clave == ''){
						Notify.alert('Debe seleccionar una clave para cada concepto.', {status: 'danger'});
						$('#clave' + x).focus();
						$('#clave' + x).trigger('chosen:activate');
						return;
					}

					if(concepto.nombre == ''){
						Notify.alert('Debe agregar una descripción para cada concepto.', {status: 'danger'});
						$('#nombre' + x).focus();
						return;
					}

					if(concepto.qty == null || concepto.qty < 0.00001){
						Notify.alert('La cantidad por concepto debe ser al mayor a 0.', {status: 'danger'});
						$('#qty' + x).focus();
						return;
					}

					if(concepto.precioU == null){
						Notify.alert('Debe ingresar un precio unitario.', {status: 'danger'});
						$('#precioU' + x).focus();
						return;
					}

				}

				vm.loading = "whirl double-up";

				var urlFacturar = '/api/admin/facturacion/facturarPorConcepto';
				$http.post(urlFacturar, {
					user : $rootScope.user,
					factura: vm.factura
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						SweetAlert.swal('Éxito!', 'Se generó su factura de forma correcta con el No. ' + response.facturaResult, 'success');
						$state.transitionTo('app.listadoFacturas');

					}else{
						SweetAlert.swal('Error!', response.errorCode + ' - ' + response.errortext + ' <br>' + response.nombreArchivo, 'error');
					}

					vm.loading = "";

				}, function errorCallback(response) {
					vm.loading = "";
				});



			};



        	vm.obtenerDatos();



        }
    }
})();



(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('OpcionesFacturaController', OpcionesFacturaController);

    OpcionesFacturaController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder', 'ngDialog'];

    function OpcionesFacturaController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder, ngDialog) {

    	$scope.factura = angular.copy($scope.ngDialogData.factura);

    	$scope.impTrasladados = [{
    	                        	 impuesto: 'IVA',
    	                        	 codigo: '002',
    	                        	 factor: [{label: 'Tasa', options: {isSelect: true, values: [0, 0.16, 0.06, 0.08] }}, {label: 'Exento', options: {isSelect: false}}]
    	                         },
    	                         {
    	                        	 impuesto: 'IEPS',
    	                        	 codigo: '003',
    	                        	 factor: [{label: 'Tasa', options: {isSelect: true, values: [0,0.03,0.06,0.07,0.08,0.09,0.25,0.265,0.3,0.304,0.50,0.53,1.60] }}, {label: 'Exento', options: {isSelect: false}}]
    	                         },
    	                         {
    	                        	 impuesto: 'ISH',
    	                        	 codigo: 'XXX',
    	                        	 factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 100 }}]
    	                         }];

    	$scope.impRetenidos = [{
    	                        	 impuesto: 'IVA',
    	                        	 codigo: '002',
    	                        	 factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 0.16 }}, {label: 'Exento', options: {isSelect: false}}]
    	                         },
    	                         {
    	                        	 impuesto: 'IEPS',
    	                        	 codigo: '003',
    	                        	 factor: [{label: 'Tasa', options: {isSelect: true, values: [0.06,0.07,0.08,0.09,0.25,0.265,0.3,0.304,0.50,0.53,1.60] }}, {label: 'Cuota', options: {isSelect: false, min: 0, max: 43.77}}, {label: 'Exento', options: {isSelect: false}}]
    	                         },
    	                         {
    	                        	 impuesto: 'ISR',
    	                        	 codigo: '001',
    	                        	 factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 0.35 }}, {label: 'Cuota', options: {isSelect: false, min: 0, max: 43.77}}, {label: 'Exento', options: {isSelect: false}}]
    	                         },
    	                         {
    	                        	 impuesto: 'ISH',
    	                        	 codigo: 'XXX',
    	                        	 factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 100 }}]
    	                         },
    	                         {
    	                        	 impuesto: 'Ret 5 al millar',
    	                        	 codigo: 'XXX',
    	                        	 factor: [{label: 'Cuota', options: {isSelect: false, min: 0, max: 99999999999999}}, {label: 'Tasa', options: {isSelect: false, min: 0, max: 1 }}]
    	                         },
    	                         {
    	                          	 impuesto: '.63% AL MILLAR INSPECCIÓN Y VIGILANCIA',
    	                          	 codigo: 'XXX',
    	                          	 factor: [{label: 'Cuota', options: {isSelect: false, min: 0, max: 99999999999999}}, {label: 'Tasa', options: {isSelect: false, min: 0, max: 99999999999999}}]
    	                           },
    	                           {
      	                          	 impuesto: 'Deducible',
      	                          	 codigo: 'XXX',
      	                          	 factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 99999999999999}}]
      	                           }];

    	$scope.traslado = {
    		impuesto: '',
    		factor: '',
    		valor: ''
    	};

    	$scope.retencion = {
        		impuesto: '',
        		factor: '',
        		valor: ''
        	};


    	$scope.agregarTraslado = function(){

    		if($scope.traslado.impuesto == '' || $scope.traslado.impuesto == null){
    			Notify.alert('Debe seleccionar un impuesto del listado.', {status: 'danger'});
    			return;
    		}

    		if($scope.traslado.factor == '' || $scope.traslado.factor == null){
    			Notify.alert('Debe seleccionar tasa/cuota/excento.', {status: 'danger'});
    			return;
    		}

    		if($scope.traslado.factor.label != 'Exento' && ($scope.traslado.valor === '' || $scope.traslado.valor === null)){
    			Notify.alert('Debe seleccionar/ingresar el valor del impuesto.', {status: 'danger'});
    			return;
    		}


    		var nuevoImpuesto = {
    				factor:  $scope.traslado.factor.label,
    				impuesto:  $scope.traslado.impuesto.codigo,
    				label: $scope.traslado.impuesto.impuesto,
    				valor: $rootScope.toFixedNumber($scope.traslado.valor, 6)
    		}

    		if(nuevoImpuesto.factor == 'Exento')
    			nuevoImpuesto.valor = 0;

    		$scope.factura.impuestosTrasladados.push(nuevoImpuesto);

    		$scope.traslado = {
            		impuesto: '',
            		factor: '',
            		valor: ''
            	};

    		$scope.validarImpuestosActuales();

    	};

    	$scope.agregarRetencion = function(){


    		if($scope.retencion.impuesto == '' || $scope.retencion.impuesto == null){
    			Notify.alert('Debe seleccionar un impuesto del listado.', {status: 'danger'});
    			return;
    		}

    		if($scope.retencion.factor == '' || $scope.retencion.factor == null){
    			Notify.alert('Debe seleccionar tasa/cuota/excento.', {status: 'danger'});
    			return;
    		}

    		if($scope.retencion.factor.label != 'Exento' && ($scope.retencion.valor == '' || $scope.retencion.valor == null)){
    			Notify.alert('Debe seleccionar/ingresar el valor del impuesto.', {status: 'danger'});
    			return;
    		}

    		if($scope.retencion.factor.options.isSelect == false){
    			if($scope.retencion.valor < $scope.retencion.factor.options.min || $scope.retencion.valor > $scope.retencion.factor.options.max){
    				Notify.alert('El valor del impuesto debe ser entre '+$rootScope.addCommas($scope.retencion.factor.options.min,3)+' y ' + $rootScope.addCommas($scope.retencion.factor.options.max,3), {status: 'danger'});
        			return;
    			}
    		}


    		var nuevoImpuesto = {
    				factor:  $scope.retencion.factor.label,
    				impuesto:  $scope.retencion.impuesto.codigo,
    				label: $scope.retencion.impuesto.impuesto,
    				valor: $rootScope.toFixedNumber($scope.retencion.valor, 6)
    		}

    		if(nuevoImpuesto.factor == 'Exento')
    			nuevoImpuesto.valor = 0;


    		$scope.factura.impuestosRetenidos.push(nuevoImpuesto);

    		$scope.retencion = {
            		impuesto: '',
            		factor: '',
            		valor: ''
            	};

    		$scope.validarImpuestosActuales();
    	};

    	$scope.validarImpuestosActuales = function(){

    		$scope.impTrasladados = [{
           	 impuesto: 'IVA',
           	 codigo: '002',
           	 factor: [{label: 'Tasa', options: {isSelect: true, values: [0, 0.16, 0.06, 0.08] }}, {label: 'Exento', options: {isSelect: false}}]
            },
            {
           	 impuesto: 'IEPS',
           	 codigo: '003',
           	 factor: [{label: 'Tasa', options: {isSelect: true, values: [0,0.03,0.06,0.07,0.08,0.09,0.25,0.265,0.3,0.304,0.50,0.53,1.60] }}, {label: 'Exento', options: {isSelect: false}}]
            },
            {
           	 impuesto: 'ISH',
           	 codigo: 'XXX',
           	 factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 100 }}]
            }];

    		$scope.impRetenidos = [{
           	 impuesto: 'IVA',
           	 codigo: '002',
           	 factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 0.16 }}, {label: 'Exento', options: {isSelect: false}}]
            },
            {
           	 impuesto: 'IEPS',
           	 codigo: '003',
           	 factor: [{label: 'Tasa', options: {isSelect: true, values: [0.06,0.07,0.08,0.09,0.25,0.265,0.3,0.304,0.50,0.53,1.60] }}, {label: 'Cuota', options: {isSelect: false, min: 0, max: 43.77}}, {label: 'Exento', options: {isSelect: false}}]
            },
            {
           	 impuesto: 'ISR',
           	 codigo: '001',
           	 factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 0.35 }}, {label: 'Cuota', options: {isSelect: false, min: 0, max: 43.77}}, {label: 'Exento', options: {isSelect: false}}]
            },
            {
              impuesto: 'CEDULAR',
              codigo: 'XXX',
              factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 100 }}]
            },
            {
             impuesto: 'ISH',
             codigo: 'XXX',
             factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 100 }}]
            },
            {
             impuesto: 'Amortización por devolución de anticipo',
             codigo: 'XXX',
             factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 100 }}]
            },
            {
             impuesto: 'Por garantía de obra',
             codigo: 'XXX',
             factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 100 }}]
            },
            {
                impuesto: 'RTP',
                codigo: 'XXX',
                factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 100 }}]
            },
            {
           	 impuesto: 'Ret 5 al millar',
           	 codigo: 'XXX',
           	 factor: [{label: 'Cuota', options: {isSelect: false, min: 0, max: 99999999999999}}, {label: 'Tasa', options: {isSelect: false, min: 0, max: 1 }}]
            },
            {
              	 impuesto: '.63% AL MILLAR INSPECCIÓN Y VIGILANCIA',
              	 codigo: 'XXX',
              	 factor: [{label: 'Cuota', options: {isSelect: false, min: 0, max: 99999999999999}}, {label: 'Tasa', options: {isSelect: false, min: 0, max: 99999999999999}}]
            },
            {
            	impuesto: 'Deducible',
                codigo: 'XXX',
                factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 99999999999999}}]
            }];

    		for(var x = 0; x < $scope.factura.impuestosRetenidos.length; x++){
    			for(var y = 0; y < $scope.impRetenidos.length; y++){
    				if($scope.factura.impuestosRetenidos[x].impuesto == $scope.impRetenidos[y].codigo){
    					$scope.impRetenidos.splice(y, 1);
    					break;
    				}
    			}
    		}

    		for(var x = 0; x < $scope.factura.impuestosTrasladados.length; x++){
    			for(var y = 0; y < $scope.impTrasladados.length; y++){
    				if($scope.factura.impuestosTrasladados[x].impuesto == $scope.impTrasladados[y].codigo){
    					$scope.impTrasladados.splice(y, 1);
    					break;
    				}
    			}
    		}

    	}

    	$scope.borrarImpuesto = function(index, tipoImp){

    		if(tipoImp == 1){
    			$scope.factura.impuestosTrasladados.splice(index, 1);
    		}else{
    			$scope.factura.impuestosRetenidos.splice(index, 1);
    		}

    		$scope.validarImpuestosActuales();
    	};

    	$scope.aplicarCambios = function(){

    		if($scope.factura.cuentaPredial != undefined
    				&& $scope.factura.cuentaPredial != ''){

    			var validarData = /^[0-9]*$/.test($scope.factura.cuentaPredial);

    			if(validarData == false){
    				Notify.alert('La cuenta predial debe contener únicamente números, sin létras. Puede agregarlo completo en el concepto.', {status: 'danger'});
        			return;
    			}
    		}


    		$scope.closeThisDialog($scope.factura);
    	};


    	$scope.validarImpuestosActuales();

    }
})();



(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('FacturasRelacionadasController', FacturasRelacionadasController);

    FacturasRelacionadasController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder', 'ngDialog'];

    function FacturasRelacionadasController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder, ngDialog) {

    	$scope.facturas = [];
    	$scope.facturasRelacionadas = [];
    	$scope.loadingRel = "";
    	$scope.relacionado = angular.copy($scope.ngDialogData.facturasRelacionadas);

    	var wto;

    	$scope.obtenerFacturasRel = function(){

    		if($scope.relacionado.noFactura == null || $scope.relacionado.noFactura == '')
    			return;



	    		$scope.loadingRel = "whirl double-up";

	    		$http.post('/api/admin/facturacion/obtenerFacturasRel', {
					user : $rootScope.user,
					noFactura: $scope.relacionado.noFactura
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						$scope.loadingRel = "";
						$scope.facturas = response.facturas;

					}

				}, function errorCallback(response) {
					Notify.alert('Ocurrió un error.', {status: 'danger'});
					$scope.loadingRel = "";
				  });

    	};

    	$scope.agregarFacturaRelacionada = function(){

    		if($scope.selectedUUID != null && $scope.selectedUUID.id_factura != undefined){
	    		$scope.relacionado.uuids.push($scope.selectedUUID);
    		}
    	};


    	$scope.agregarRelacion = function(){

    		$scope.closeThisDialog($scope.relacionado);

    	};



    }
})();



(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('EnviarFacturasController', EnviarFacturasController);

    EnviarFacturasController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder', 'ngDialog'];

    function EnviarFacturasController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder, ngDialog) {

    	$scope.elementoEnviar = {email: '', id_factura: 0, nota: ''};


    	$scope.obtenerEmailPorCliente = function(){

	    		$scope.loadingEmail = "whirl double-up";

	    		$http.post('/api/admin/facturacion/obtenerEmailPorCliente', {
					user : $rootScope.user,
					id_cliente: $scope.ngDialogData.factura.id_cliente
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						$scope.loadingEmail = "";
						$scope.elementoEnviar.email = response.email;

					}

				}, function errorCallback(response) {
					Notify.alert('Ocurrió un error.', {status: 'danger'});
					$scope.loadingEmail = "";
				  });
    	};

    	$scope.enviarFactura = function(){

    		if(!$rootScope.validarEmail($scope.elementoEnviar.email)){
    			Notify.alert('Por favor ingrese un correo válido.', {status: 'danger'});
    			return;
    		}

    		$scope.loadingEmail = "whirl double-up";
    		$scope.elementoEnviar.id_factura = $scope.ngDialogData.factura.id_factura;

    		$http.post('/api/admin/facturacion/enviarFactura', {
				user : $rootScope.user,
				factura: $scope.elementoEnviar
			}).then(function(res) {
				var response = res['data'];
				if (response['success']) {

					$scope.loadingEmail = "";
					$scope.closeThisDialog(1);

				}

			}, function errorCallback(response) {
				Notify.alert('Ocurrió un error.', {status: 'danger'});
				$scope.loadingEmail = "";
			  });
	};

    	$scope.obtenerEmailPorCliente();

    }
})();


(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('CancelarFacturaController', CancelarFacturaController);

    CancelarFacturaController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder', 'ngDialog'];

    function CancelarFacturaController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder, ngDialog) {

    	$scope.elementoEnviar = {password: '', id_factura: 0, nota: ''};


    	$scope.cancelar = function(){

    		if($scope.elementoEnviar.password == null || $scope.elementoEnviar.password == ''){
    			Notify.alert('Por favor ingrese la contraseña.', {status: 'danger'});
    			return;
    		}

    		$scope.elementoEnviar.id_factura = $scope.ngDialogData.factura.id_factura;
    		$scope.elementoEnviar.uUID = $scope.ngDialogData.factura.iddoc.uUID;

    		$scope.loadingEmail = "whirl double-up";




    		var urlFacturar = '/api/admin/facturacion/cancelarFacturaPro';
			if($scope.ngDialogData.factura.generadoPor == 4){
				urlFacturar = '/api/admin/facturacion/cancelarFactura';
			}

    		$http.post(urlFacturar, {
				user : $rootScope.user,
				factura: $scope.elementoEnviar
			}).then(function(res) {
				var response = res['data'];
				if (response['success']) {

					$scope.loadingEmail = "";
					if(response.passCorrecto == true){
						if(response.seraCancelado == true){
							$scope.closeThisDialog(1);
						}else{
							Notify.alert('En este momento no es posible cancelar tu factura, inténtalo más tarde.', {status: 'danger'});
						}
					}else{

						Notify.alert('La contraseña no es correcta.', {status: 'danger'});

					}

				}

			}, function errorCallback(response) {
				Notify.alert('Ocurrió un error.', {status: 'danger'});
				$scope.loadingEmail = "";
			  });
    	};

    }
})();


(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('PreviewFacturaController', PreviewFacturaController);

    PreviewFacturaController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder', 'ngDialog'];

    function PreviewFacturaController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder, ngDialog) {




    	$scope.obtenerFactura = function(){

    		$scope.loading = "whirl double-up";

    		$http.post('/api/admin/facturacion/verVistaPreviaFactura', {
				user : $rootScope.user,
				id_factura: $scope.ngDialogData.id_factura
			}).then(function(res) {
				var response = res['data'];
				if (response['success']) {

					$("#previewFacturaIframe").html(response.html);

					$scope.loading = "";

				}

			}, function errorCallback(response) {
				Notify.alert('Ocurrió un error.', {status: 'danger'});
				$scope.loadingEmail = "";
			  });

    	}


    	$scope.obtenerFactura();

    }
})();



(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('NuevaFacturaPagoController', NuevaFacturaPagoController);

    NuevaFacturaPagoController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder', 'ngDialog'];

    function NuevaFacturaPagoController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder, ngDialog) {
        var vm = this;

        vm.clientes = [];
        vm.formasDePago = [];
        vm.productos = [];
        vm.unidadesMedida = [];
		vm.clavesProducto = [];
		vm.usosCFDI = [];
		vm.usosCFDITmp = [];
		vm.searchTextCustomer = '';
		vm.series = [];
		vm.bancos = [];
        vm.factura = {
        		tipoDocumento: 'P',
        		id_cliente: '',
            	decimales: '2',
        		impuestosRetenidos : [],
        		impuestosTrasladados : [],
        		moneda: 'MXN',
        		tipoCambio: 1.0,
        		detalles: [],
        		descuento: 0,
        		facturasRelacionadas: {
            		tipoRelacion: '',
            		noFactura: '',
            		uuids: []

            	},
        		cuentaPredial: '',
        		formaPago: '',
        		lugarExpedicion: '',
        		serie: 'A',
        		metodoDePago: 'PUE',
        		pagos: []
        }
        vm.productoAgregar = '';
        vm.tipoRelaciones = [
                             {value: '01', label: 'Nota de crédito de los documentos relacionados'},
                             {value: '02', label: 'Nota de débito de los documentos relacionados'},
                             {value: '03', label: 'Devolución de mercancía sobre facturas o traslados previos'},
                             {value: '04', label: 'Sustitución de los CFDI previos'},
                             {value: '05', label: 'Traslados de mercancias facturados previamente'},
                             {value: '06', label: 'Factura generada por los traslados previos'},
                             {value: '07', label: 'CFDI por aplicación de anticipo'}
                            ];
        vm.metodosDePago = [{codigo: 'PUE', descripcion: 'Pago en una sola exhibición'}, {codigo: 'PPD', descripcion: 'Pago en parcialidades o diferido'}];



        activate();

        ////////////////

        function activate() {

        	vm.obtenerNombreTipoRelacion = function(){
        		for(var x = 0; x < vm.tipoRelaciones.length; x++){
        			if(vm.tipoRelaciones[x].value == vm.factura.facturasRelacionadas.tipoRelacion){
        				return vm.tipoRelaciones[x].label;
        			}
        		}
        	};


        	vm.obtenerDatos = function(){

	        	vm.loading = "whirl double-up";

	        	$http.post('/api/admin/facturacion/datosFacturar', {
					user : $rootScope.user
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						vm.loading = "";
						vm.clientes = response.clientes;
						vm.formasDePago = response.formasDePago;
						vm.productos = response.productos;
						vm.unidadesMedida = response.unidadesMedida;
						vm.clavesProducto = response.clavesProducto;
						vm.usosCFDI = response.usosCFDI;
						vm.series = response.series;
						vm.factura.lugarExpedicion = response.proveedor.domicilio.codigoPostal;
						vm.usosCFDITmp = vm.usosCFDI;
						vm.bancos = response.bancos;

						if($stateParams.id != undefined && $stateParams.id != ''){
							vm.agregarPagoDirecto($stateParams.id);
						}

					}

				}, function errorCallback(response) {
					vm.obtenerDatos();
				  });
        	};


        	vm.agregarPago = function(){

        		if( vm.factura.id_cliente == "" || vm.factura.id_cliente == null){
        			Notify.alert('Debe seleccionar el cliente antes de agregar el pago.', {status: 'danger'});

        			$('#id_cliente').trigger('chosen:activate');
					$('#id_cliente').focus();

        			return;
        		}

                ngDialog.openConfirm({
                    template: 'pagoFactura',
                    className: 'ngdialog-theme-default large-ngDialog',
                    controller: 'AgregarPagoController',
                    data: {formasDePago: vm.formasDePago, facturasCliente: vm.facturasCliente, pagos: vm.factura.pagos, bancos: vm.bancos}
                }).then(function (buscar) {
                	console.log(vm.factura.pagos);
                }, function (factura) {
                	console.log(vm.factura.pagos);
                });

            };


            vm.editarPago = function(index){

                ngDialog.openConfirm({
                    template: 'pagoFactura',
                    className: 'ngdialog-theme-default large-ngDialog',
                    controller: 'AgregarPagoController',
                    data: {formasDePago: vm.formasDePago, facturasCliente: vm.facturasCliente, pagos: vm.factura.pagos, index: index, edit: true, bancos: vm.bancos}
                }).then(function (buscar) {
                	console.log(vm.factura.pagos);
                }, function (factura) {
                	console.log(vm.factura.pagos);
                });

            };



            vm.facturaRelacionada = function(){

            	vm.factura.facturasRelacionadas.noFactura = '';

                ngDialog.openConfirm({
                    template: 'facturasRelacionadas',
                    className: 'ngdialog-theme-default',
                    controller: 'FacturasRelacionadasController',
                    data: {tipoRelaciones: vm.tipoRelaciones, facturasRelacionadas: vm.factura.facturasRelacionadas}
                }).then(function (documento) {

                }, function (documento) {
                	console.log(documento);
                	if(documento.tipoRelacion != undefined){
                		vm.factura.facturasRelacionadas = documento;
                	}
                });

            };

            vm.agregrProdExistente = function(){
            	if(vm.productoAgregar.id_producto != undefined){
            		vm.productoAgregar.precioU = Number(vm.productoAgregar.precioU);
            		vm.productoAgregar.qty = 1;
            		vm.productoAgregar.descuento = 0;
            		vm.factura.detalles.push(angular.copy(vm.productoAgregar));
            		vm.productoAgregar = '';
            	}

            	vm.calcularTotales();
            };


            vm.agregrProdNuevo = function(){
            		var productoNuevo = {
            			codigo: '1',
            			clave: '',
            			nombre: '',
            			unidad: '',
            			qty: 1,
            			precioU: 1.00,
            			descuento: 0
            		};
            		vm.factura.detalles.push(productoNuevo);
            		vm.productoAgregar = '';

            	vm.calcularTotales();
            };

            vm.calcularTotales = function(){

            	vm.factura.subtotal = 0;
            	vm.factura.total = 0;
            	vm.factura.base = 0;
            	vm.factura.descuento = 0;

            	for(var x = 0; x < vm.factura.detalles.length; x++){
            		vm.factura.subtotal += (vm.factura.detalles[x].qty * vm.factura.detalles[x].precioU);
            		vm.factura.detalles[x].base = (vm.factura.detalles[x].qty * vm.factura.detalles[x].precioU - vm.factura.detalles[x].descuento);
            		vm.factura.descuento += Number(vm.factura.detalles[x].descuento);
            	}

            	vm.factura.total = vm.factura.base = vm.factura.subtotal - vm.factura.descuento;

            	for(var x = 0; x < vm.factura.impuestosRetenidos.length; x++){

            		if(vm.factura.impuestosRetenidos[x].factor == 'Tasa'){
            			vm.factura.impuestosRetenidos[x].total = vm.factura.impuestosRetenidos[x].valor * vm.factura.base;
            		}else{
            			vm.factura.impuestosRetenidos[x].total = vm.factura.impuestosRetenidos[x].valor;
            		}

            		vm.factura.total -= vm.factura.impuestosRetenidos[x].total;
            	}



            	for(var x = 0; x < vm.factura.impuestosTrasladados.length; x++){

            		if(vm.factura.impuestosTrasladados[x].factor == 'Tasa'){
            			vm.factura.impuestosTrasladados[x].total = vm.factura.impuestosTrasladados[x].valor * vm.factura.base;
            		}else{
            			vm.factura.impuestosTrasladados[x].total = vm.factura.impuestosTrasladados[x].valor;
            		}

            		vm.factura.total += vm.factura.impuestosTrasladados[x].total;
            	}

            };

            vm.borrarConcepto = function(index){
            	vm.factura.detalles.splice(index, 1);
            	vm.calcularTotales();
            };


            /////Funcionalidad select de mobile para customer
            vm.getMatchesCustomer = function(searchText) {
				if(searchText == "" || searchText == null)
					return vm.clientes;
		            var states = vm.clientes.filter(function(customer) {
		            	var pordChane = customer.nmbRecep + " " + customer.rFCRecep;
		                return (pordChane.toUpperCase().match(searchText.toUpperCase()));
		            });

		        return states;
		    }

            vm.selectedCustomer = function(cliente){
				if(typeof(cliente) != 'undefined' && typeof(cliente.id_cliente) != 'undefined'){
					vm.factura.id_cliente = cliente;
					vm.obtenerFacturasPorCliente();
				}else{
					vm.factura.id_cliente = 0;
				}
			};
			////////////////////////////

			vm.obtenerPaises = function(){

				vm.factura.formaPago = vm.factura.id_cliente.metodoPago;
				vm.factura.usoCFDI = vm.factura.id_cliente.usoCFDI

				if( vm.factura.id_cliente!= null && vm.factura.id_cliente.rFCRecep == 'XEXX010101000'){

					$http.post('/api/admin/facturacion/obtenerPaises', {
						user : $rootScope.user
					}).then(function(res) {
						var response = res['data'];
						if (response['success']) {

							vm.loading = "";
							vm.paises = response.paises;
						}

					}, function errorCallback(response) {
						vm.obtenerDatos();
					  });

				}
			};

			vm.borrarFacturaRelacionada = function(index){
				vm.factura.facturasRelacionadas.uuids.splice(index, 1);
			};


			vm.seleccionarMetodoPago = function(){
				if(vm.factura.metodoDePago == 'PPD'){
					vm.factura.formaPago = '99';
					$("#formaPago").trigger("chosen:updated");
				}
			};

			vm.obtenerFacturasPorCliente = function(){

				vm.factura.pagos = [];

				$http.post('/api/admin/facturacion/obtenerFacturasPorCliente', {
					user : $rootScope.user,
					id_cliente: vm.factura.id_cliente.id_cliente
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						vm.loading = "";
						vm.facturasCliente = response.facturas;
					}

				}, function errorCallback(response) {
					vm.obtenerDatos();
				  });

			};


			vm.cambiarTipoDocumento = function(tipo){
	        	vm.factura.tipoDocumento = tipo;
	        	if(vm.factura.tipoDocumento != 'P'){
	        		$state.transitionTo('app.nuevaFactura', {tipoDocumento: vm.factura.tipoDocumento});
	        	}

	        };

			vm.facturar = function(){

				if(vm.factura.id_cliente == '' || vm.factura.id_cliente == null){
					Notify.alert('Debe seleccionar un cliente.', {status: 'danger'});
					$('#id_cliente').trigger('chosen:activate');
					return;
				}

				if(vm.factura.lugarExpedicion == '' || vm.factura.lugarExpedicion == null || vm.factura.lugarExpedicion.length < 5 ){
					Notify.alert('Debe ingresar un lugar de expedición correcto (C.P.)', {status: 'danger'});
					$('#lugarExpedicion').focus();
					return;
				}


				if(vm.factura.pagos.length == 0){
					Notify.alert('Debe agregar al menos un pago.', {status: 'danger'});
					return;
				}

				vm.loading = "whirl double-up";

				for(var x = 0; x < vm.factura.pagos.length; x++){
					var pagoTmp = vm.factura.pagos[x];
					pagoTmp.fechaPago = $rootScope.prepareDateForServer(pagoTmp.fechaPago, true);
				}

				var urlFacturar = '/api/admin/facturacion/facturarPago';
				$http.post(urlFacturar, {
					user : $rootScope.user,
					factura: vm.factura
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						SweetAlert.swal('Éxito!', 'Se generó su factura de forma correcta con el No. ' + response.facturaResult, 'success');
						$state.transitionTo('app.listadoFacturas');

					}else{
						SweetAlert.swal('Error!', response.errorCode + ' - ' + response.errortext, 'error');
					}

					vm.loading = "";

				}, function errorCallback(response) {
					vm.loading = "";
				});



			};


			vm.agregarPagoDirecto = function(id_factura){

				vm.loading = "whirl double-up";

				$http.post('/api/admin/facturacion/obtenerFacturaPago', {
					user : $rootScope.user,
					id_factura: id_factura
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						var facturaPago = response.factura;

						for(var x = 0; x < vm.clientes.length; x++){
							if(vm.clientes[x].id_cliente == facturaPago.id_cliente){
								vm.factura.id_cliente = vm.clientes[x];
							}
						}


						vm.obtenerFacturasPorCliente();
						$("#id_cliente").trigger("chosen:updated");

						var pago = {
							formaPago: '01',
							moneda: facturaPago.totales.moneda,
							fechaPago: new Date(),
							documentoRelacionado: [],
							tipoCambio: ''
						}

						if(facturaPago.iddoc.moneda != 'MXN'){
							pago.tipoCambio = '1';
						}

						var tmp2 = {
			        		facturaLbl: facturaPago.iddoc.serie + facturaPago.noFactura,
			        		id_factura: facturaPago.id_factura,
			        		total: facturaPago.totales.VlrPagar,
			        		moneda: facturaPago.totales.moneda,
			        		uuid: facturaPago.iddoc.uUID,
			        		parcialidad: 1,
			        		saldoAnterior: Number(facturaPago.totales.VlrPagar) - Number(facturaPago.importePagado),
			        		pago: Number(facturaPago.totales.VlrPagar) - Number(facturaPago.importePagado),
			        		saldoInsoluto: 0,
			        		tipoCambio: '',
                            tipoCambioDR: facturaPago.totales.tipoCambio,
			        	};

						pago.totalPago = tmp2.pago;

						pago.documentoRelacionado.push(tmp2);

						vm.factura.pagos.push(pago);

						vm.loading = "";
					}

				}, function errorCallback(response) {
					vm.loading = "";
					Notify.alert('Hubo un error al cargar el pago, favor de hacerlo manualmente.', {status: 'danger'});
				  });

			};



        	vm.obtenerDatos();



        }
    }
})();


(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('AgregarPagoController', AgregarPagoController);

    AgregarPagoController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder', 'ngDialog'];

    function AgregarPagoController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder, ngDialog) {

    	$scope.monedas = ['MXN', 'USD'];
    	$scope.pago = {moneda: 'MXN', fechaPago: new Date(), formaPago: '01', tipoCambio: '', documentoRelacionado: [], totalPago: 0,
    			banco: '', cuenta: ''};


    	$scope.agregarDocumento = function(){

    		var facturaSeleccionada = $scope.pago.facturaSeleccionada;
    		for(var y = 0; y < $scope.pago.documentoRelacionado.length; y++){

    			if($scope.pago.documentoRelacionado[y].id_factura == facturaSeleccionada.id_factura){
    				Notify.alert('El documento ya fue agregado anteriormente.', {status: 'danger'});
    				$scope.pago.facturaSeleccionada = '';
    				return;
    			}
    		}

    		var documentoAgregar = {
        			facturaLbl: facturaSeleccionada.iddoc.serie + facturaSeleccionada.noFactura,
        			id_factura: facturaSeleccionada.id_factura,
        			total: facturaSeleccionada.totales.VlrPagar,
        			moneda: facturaSeleccionada.totales.moneda,
        			uuid: facturaSeleccionada.iddoc.uUID,
        			parcialidad: 1,
        			saldoAnterior: 0,
        			pago: 0,
        			saldoInsoluto: 0,
        			tipoCambio: '',
        		};

    		$scope.pago.documentoRelacionado.push(documentoAgregar);

    		$scope.pago.totalPago += Number(documentoAgregar.total);

    		$scope.obtenerImportePagado(documentoAgregar.uuid, documentoAgregar);

    		$scope.pago.facturaSeleccionada = '';
    	};

    	$scope.borrarDocumento = function($index){
    		$scope.pago.documentoRelacionado.splice($index, 1);
    	};

    	$scope.aplicarCambios = function(){

    		if($scope.pago.formaPago == null || $scope.pago.formaPago == ''){
    			Notify.alert('Debe seleccionar una forma de pago.', {status: 'danger'});
    			$("#formaDePagoP").focus();
    			return;
    		}

    		if($scope.pago.moneda == null || $scope.pago.moneda == ''){
    			Notify.alert('Debe seleccionar una moneda de pago.', {status: 'danger'});
    			$("#monedaP").focus();
    			return;
    		}

    		if($scope.pago.banco != undefined && $scope.pago.banco != '' && $scope.pago.banco.length > 0){

	    		var re = /^[0-9]*$/;
	    		if( $scope.pago.cuenta != '' && !re.test($scope.pago.cuenta) ){
	    			Notify.alert('El número de cuenta debe contener sólo números.', {status: 'danger'});
	    			$("#cuenta").focus();
	    			return;
	    		}

	    		if( $scope.pago.cuenta != '' ){

	    		    if($scope.pago.formaPago == '02'){
                        if( !($scope.pago.cuenta.length == 11 || $scope.pago.cuenta.length == 18) ){
                            Notify.alert('Si el método de pago es con cheque, la cuenta debe ser de 11 o 18 dígitos.', {status: 'danger'});
                            $("#cuenta").focus();
                            return;
                        }
                    }

                    if($scope.pago.formaPago == '03'){
                        if( !($scope.pago.cuenta.length == 10 || $scope.pago.cuenta.length == 16 || $scope.pago.cuenta.length == 18) ){
                            Notify.alert('Si el método de pago es con cheque, la cuenta debe ser de 10, 16 o 18 dígitos.', {status: 'danger'});
                            $("#cuenta").focus();
                            return;
                        }
                    }
	    		}

	    		var listOfValidPayments = '02030428';
	    		if( $scope.pago.cuenta != '' && listOfValidPayments.indexOf($scope.pago.formaPago) == -1 ){
	    			Notify.alert('Sólo debe indicar cuenta cuando es pago por transferencia, tarjeta, o cheque..', {status: 'danger'});
	    			$("#cuenta").focus();
	    			return;
	    		}
    		}


    		if($scope.pago.moneda == 'USD'){

    			var tmp = $scope.pago.tipoCambio.replace(',', '');
    			tmp = Number(tmp);

    			if(tmp == 0 || isNaN(tmp)){
    				Notify.alert('Debe ingrear un tipo de cambio mayor a 0.', {status: 'danger'});
        			$("#tipoCambioP").focus();
        			return;
    			}

    			$scope.pago.tipoCambio = tmp;

    		}

    		if($scope.pago.documentoRelacionado.length == 0){
    			Notify.alert('Debe agregar al menos una factura pagada.', {status: 'danger'});
    			return;
    		}

    		$scope.pago.totalPago = 0;

    		for(var x = 0; x < $scope.pago.documentoRelacionado.length; x++){

    			var tmpParcialdiad = Number($scope.pago.documentoRelacionado[x].parcialidad);
    			var tmpSaldo = Number($scope.pago.documentoRelacionado[x].saldoAnterior);
    			var tmpPago = Number($scope.pago.documentoRelacionado[x].pago);

    			if(tmpParcialdiad == 0 || isNaN(tmpParcialdiad)){
    				Notify.alert('El no. de parcialidad debe ser numérico y mayor a 0.', {status: 'danger'});
        			return;
    			}

    			if(tmpSaldo == 0 || isNaN(tmpSaldo)){
    				Notify.alert('El saldo anterior debe ser numérico y mayor a 0.', {status: 'danger'});
        			return;
    			}

    			if(tmpPago == 0 || isNaN(tmpPago)){
    				Notify.alert('El pago realizado debe ser numérico y mayor a 0.', {status: 'danger'});
        			return;
    			}

    			$scope.pago.totalPago += tmpPago;
    		}


    		if($scope.ngDialogData.edit == true){
    			$scope.ngDialogData.pagos[$scope.ngDialogData.index] = $scope.pago;
    		}else{
    			$scope.ngDialogData.pagos.push($scope.pago);
    		}


    		$scope.closeThisDialog();
    	};


    	$scope.cancelar = function(){
    		$scope.closeThisDialog();
    	};


    	$scope.obtenerImportePagado = function(uuid, documentoAgregar){

    		$scope.loadingWare = "whirl double-up";

    		$http.post('/api/admin/facturacion/obtenerAbonosFactura', {
				user : $rootScope.user,
				uuid: uuid
			}).then(function(res) {
				var response = res['data'];
				if (response['success']) {

					documentoAgregar.saldoAnterior = Number(documentoAgregar.total) - Number(response.importePagado);
					documentoAgregar.pago = documentoAgregar.saldoAnterior;
					documentoAgregar.parcialidad = response.noPago;
				}

				$scope.loadingWare = "";

			}, function errorCallback(response) {
				$scope.loadingWare = "";
			});

    	};

    	$scope.calcularRestantePago = function(index){

    		var documento = $scope.pago.documentoRelacionado[index];
    		documento.pago = documento.pago.replace(',', '');
    		documento.saldoInsoluto = documento.saldoAnterior - Number(documento.pago);

    		$scope.pago.totalPago = 0;
    		for(var x = 0; x < $scope.pago.documentoRelacionado.length; x++){
    			$scope.pago.totalPago += Number($scope.pago.documentoRelacionado[x].pago);
    		}


    	};

    	$scope.procesoInicial = function(){

    		if($scope.ngDialogData.edit == true){

    			$scope.pago = angular.copy($scope.ngDialogData.pagos[$scope.ngDialogData.index]);

    		}else{
	    		if($scope.ngDialogData.facturasCliente.length == 1){
	        		$scope.pago.facturaSeleccionada = $scope.ngDialogData.facturasCliente[0];
	        		$scope.agregarDocumento();
	        	}
    		}
    	};

    	$scope.procesoInicial();


    }
})();



(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('ImpuestoConceptoController', ImpuestoConceptoController);

    ImpuestoConceptoController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder', 'ngDialog'];

    function ImpuestoConceptoController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder, ngDialog) {


    	$scope.concepto = angular.copy($scope.ngDialogData.concepto);


    	$scope.impTrasladados = [{
	       	 impuesto: 'IVA',
	       	 codigo: '002',
	       	 factor: [{label: 'Tasa', options: {isSelect: true, values: [0, 0.16, 0.06, 0.08] }}, {label: 'Exento', options: {isSelect: false}}]
	        },
	        {
	       	 impuesto: 'IEPS',
	       	 codigo: '003',
	       	 factor: [{label: 'Tasa', options: {isSelect: true, values: [0,0.03,0.06,0.07,0.08,0.09,0.25,0.265,0.3,0.304,0.50,0.53,1.60] }}, {label: 'Exento', options: {isSelect: false}}]
	        },
	        {
	       	 impuesto: 'ISH',
	       	 codigo: 'XXX',
	       	 factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 100 }}]
	    }];

    	$scope.impRetenidos = [{
	       	 impuesto: 'IVA',
	       	 codigo: '002',
	       	 factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 0.16 }}, {label: 'Exento', options: {isSelect: false}}]
	        },
	        {
	       	 impuesto: 'IEPS',
	       	 codigo: '003',
	       	 factor: [{label: 'Tasa', options: {isSelect: true, values: [0.06,0.07,0.08,0.09,0.25,0.265,0.3,0.304,0.50,0.53,1.60] }}, {label: 'Cuota', options: {isSelect: false, min: 0, max: 43.77}}, {label: 'Exento', options: {isSelect: false}}]
	        },
	        {
	       	 impuesto: 'ISR',
	       	 codigo: '001',
	       	 factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 0.35 }}, {label: 'Cuota', options: {isSelect: false, min: 0, max: 43.77}}, {label: 'Exento', options: {isSelect: false}}]
	        },
	        {
                impuesto: 'RTP',
                codigo: 'XXX',
                factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 100 }}]
            }];

		$scope.traslado = {
			impuesto: '',
			factor: '',
			valor: ''
		};

		$scope.retencion = {
			impuesto: '',
			factor: '',
			valor: ''
		};


		$scope.agregarTraslado = function(){

    		if($scope.traslado.impuesto == '' || $scope.traslado.impuesto == null){
    			Notify.alert('Debe seleccionar un impuesto del listado.', {status: 'danger'});
    			return;
    		}

    		if($scope.traslado.factor == '' || $scope.traslado.factor == null){
    			Notify.alert('Debe seleccionar tasa/cuota/excento.', {status: 'danger'});
    			return;
    		}

    		if($scope.traslado.factor.label != 'Exento' && ($scope.traslado.valor === '' || $scope.traslado.valor === null)){
    			Notify.alert('Debe seleccionar/ingresar el valor del impuesto.', {status: 'danger'});
    			return;
    		}


    		$scope.traslado.valor = Number($scope.traslado.valor);
    		$scope.traslado.valor = $scope.traslado.valor.toFixed(6);

    		var nuevoImpuesto = {
    				factor:  $scope.traslado.factor.label,
    				impuesto:  $scope.traslado.impuesto.codigo,
    				label: $scope.traslado.impuesto.impuesto,
    				valor: $scope.traslado.valor
    		}

    		if(nuevoImpuesto.factor == 'Exento')
    			nuevoImpuesto.valor = 0;

    		console.log(nuevoImpuesto);

    		$scope.concepto.impuestosTrasladados.push(nuevoImpuesto);

    		$scope.traslado = {
            		impuesto: '',
            		factor: '',
            		valor: ''
            	};

    		$scope.validarImpuestosActuales();

    	};

    	$scope.agregarRetencion = function(){


    		if($scope.retencion.impuesto == '' || $scope.retencion.impuesto == null){
    			Notify.alert('Debe seleccionar un impuesto del listado.', {status: 'danger'});
    			return;
    		}

    		if($scope.retencion.factor == '' || $scope.retencion.factor == null){
    			Notify.alert('Debe seleccionar tasa/cuota/excento.', {status: 'danger'});
    			return;
    		}

    		if($scope.retencion.factor.label != 'Exento' && ($scope.retencion.valor == '' || $scope.retencion.valor == null)){
    			Notify.alert('Debe seleccionar/ingresar el valor del impuesto.', {status: 'danger'});
    			return;
    		}

    		if($scope.retencion.factor.options.isSelect == false){
    			if($scope.retencion.valor < $scope.retencion.factor.options.min || $scope.retencion.valor > $scope.retencion.factor.options.max){
    				Notify.alert('El valor del impuesto debe ser entre '+$rootScope.addCommas($scope.retencion.factor.options.min,3)+' y ' + $rootScope.addCommas($scope.retencion.factor.options.max,3), {status: 'danger'});
        			return;
    			}
    		}

    		$scope.retencion.valor = Number($scope.retencion.valor);
    		$scope.retencion.valor = $scope.retencion.valor.toFixed(6);


    		var nuevoImpuesto = {
    				factor:  $scope.retencion.factor.label,
    				impuesto:  $scope.retencion.impuesto.codigo,
    				label: $scope.retencion.impuesto.impuesto,
    				valor: $scope.retencion.valor
    		}

    		if(nuevoImpuesto.factor == 'Exento')
    			nuevoImpuesto.valor = 0;


    		$scope.concepto.impuestosRetenidos.push(nuevoImpuesto);

    		$scope.retencion = {
            		impuesto: '',
            		factor: '',
            		valor: ''
            	};

    		$scope.validarImpuestosActuales();
    	};

    	$scope.validarImpuestosActuales = function(){

    		$scope.impTrasladados = [{
           	 impuesto: 'IVA',
           	 codigo: '002',
           	 factor: [{label: 'Tasa', options: {isSelect: true, values: [0, 0.16, 0.06, 0.08] }}, {label: 'Exento', options: {isSelect: false}}]
            },
            {
           	 impuesto: 'IEPS',
           	 codigo: '003',
           	 factor: [{label: 'Tasa', options: {isSelect: true, values: [0,0.03,0.06,0.07,0.08,0.09,0.25,0.265,0.3,0.304,0.50,0.53,1.60] }}, {label: 'Exento', options: {isSelect: false}}]
            },
            {
           	 impuesto: 'ISH',
           	 codigo: 'XXX',
           	 factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 100 }}]
            }];

    		$scope.impRetenidos = [{
           	 impuesto: 'IVA',
           	 codigo: '002',
           	 factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 0.16 }}, {label: 'Exento', options: {isSelect: false}}]
            },
            {
           	 impuesto: 'IEPS',
           	 codigo: '003',
           	 factor: [{label: 'Tasa', options: {isSelect: true, values: [0.06,0.07,0.08,0.09,0.25,0.265,0.3,0.304,0.50,0.53,1.60] }}, {label: 'Cuota', options: {isSelect: false, min: 0, max: 43.77}}, {label: 'Exento', options: {isSelect: false}}]
            },
            {
           	 impuesto: 'ISR',
           	 codigo: '001',
           	 factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 0.35 }}, {label: 'Cuota', options: {isSelect: false, min: 0, max: 43.77}}, {label: 'Exento', options: {isSelect: false}}]
            },
            {
              impuesto: 'CEDULAR',
              codigo: 'XXX',
              factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 100 }}]
            },
            {
             impuesto: 'ISH',
             codigo: 'XXX',
             factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 100 }}]
            },
            {
             impuesto: 'Amortización por devolución de anticipo',
             codigo: 'XXX',
             factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 100 }}]
            },
            {
             impuesto: 'Por garantía de obra',
             codigo: 'XXX',
             factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 100 }}]
            },
            {
                impuesto: 'RTP',
                codigo: 'XXX',
                factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 100 }}]
            }];

    		for(var x = 0; x < $scope.concepto.impuestosRetenidos.length; x++){
    			for(var y = 0; y < $scope.impRetenidos.length; y++){
    				if($scope.concepto.impuestosRetenidos[x].impuesto == $scope.impRetenidos[y].codigo){
    					$scope.impRetenidos.splice(y, 1);
    					break;
    				}
    			}
    		}

    		for(var x = 0; x < $scope.concepto.impuestosTrasladados.length; x++){
    			for(var y = 0; y < $scope.impTrasladados.length; y++){
    				if($scope.concepto.impuestosTrasladados[x].impuesto == $scope.impTrasladados[y].codigo){
    					$scope.impTrasladados.splice(y, 1);
    					break;
    				}
    			}
    		}

    	}

    	$scope.borrarImpuesto = function(index, tipoImp){

    		if(tipoImp == 1){
    			$scope.concepto.impuestosTrasladados.splice(index, 1);
    		}else{
    			$scope.concepto.impuestosRetenidos.splice(index, 1);
    		}

    		$scope.validarImpuestosActuales();
    	};

    	$scope.aplicarCambios = function(){
    		$scope.closeThisDialog($scope.concepto);
    	};


    }
})();


(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('NuevaFacturaGasolinaController', NuevaFacturaGasolinaController);

    NuevaFacturaGasolinaController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder', 'ngDialog'];

    function NuevaFacturaGasolinaController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder, ngDialog) {
        var vm = this;

        vm.clientes = [];
        vm.formasDePago = [];
        vm.productos = [];
        vm.unidadesMedida = [];
		vm.clavesProducto = [];
		vm.usosCFDI = [];
		vm.usosCFDITmp = [];
		vm.searchTextCustomer = '';
		vm.series = [];
        vm.factura = {
        		tipoDocumento: 'I',
        		id_cliente: '',
            	decimales: '2',
        		guardarProd: false,
        		moneda: 'MXN',
        		tipoCambio: 1.0,
        		detalles: [],
        		descuento: 0,
        		facturasRelacionadas: {
            		tipoRelacion: '',
            		noFactura: '',
            		uuids: []

            	},
        		cuentaPredial: '',
        		formaPago: '',
        		lugarExpedicion: '',
        		serie: 'A',
        		metodoDePago: 'PUE'
        }
        vm.productoAgregar = '';
        vm.tipoRelaciones = [
                             {value: '01', label: 'Nota de crédito de los documentos relacionados'},
                             {value: '02', label: 'Nota de débito de los documentos relacionados'},
                             {value: '03', label: 'Devolución de mercancía sobre facturas o traslados previos'},
                             {value: '04', label: 'Sustitución de los CFDI previos'},
                             {value: '05', label: 'Traslados de mercancias facturados previamente'},
                             {value: '06', label: 'Factura generada por los traslados previos'},
                             {value: '07', label: 'CFDI por aplicación de anticipo'}
                            ];
        vm.productos = [{clave: '15101506', codigo: '01', descripcion: 'Gasolina magna', nombre: 'Gasolina magna', precioU: 15800.66207, unidad: 'MTQ', id_producto: 0,
        					impuestosTrasladados: [{base: 0, factor: 'Tasa', impuesto: '002', label: 'IVA', total: 0, valor: "0.160000"}]},
                        {clave: '15101506', codigo: '02', descripcion: 'Gasolina premium', nombre: 'Gasolina premium', precioU: 17070.51624, unidad: 'MTQ', id_producto: 0,
                        	impuestosTrasladados: [{base: 0, factor: 'Tasa', impuesto: '002', label: 'IVA', total: 0, valor: "0.160000"}]},
                        {clave: '15101505', codigo: '03', descripcion: 'Diesel', nombre: 'Diesel', precioU: 16456.875, unidad: 'MTQ', id_producto: 0,
                        	impuestosTrasladados: [{base: 0, factor: 'Tasa', impuesto: '002', label: 'IVA', total: 0, valor: "0.160000"}]},
                        {clave: '78121603', codigo: '04', descripcion: 'Flete', nombre: 'Flete', precioU: 1000, unidad: 'E48', id_producto: 0,
                        	impuestosTrasladados: [{base: 0, factor: 'Tasa', impuesto: '002', label: 'IVA', total: 0, valor: "0.160000"}]}];
        vm.metodosDePago = [{codigo: 'PUE', descripcion: 'Pago en una sola exhibición'}, {codigo: 'PPD', descripcion: 'Pago en parcialidades o diferido'}];

        vm.cambiarTipoDocumento = function(tipo){
        	vm.factura.tipoDocumento = tipo;
        	if(vm.factura.tipoDocumento == 'P')
        		$state.transitionTo('app.nuevoPago');
        };

        activate();

        ////////////////

        function activate() {

        	vm.obtenerNombreTipoRelacion = function(){
        		for(var x = 0; x < vm.tipoRelaciones.length; x++){
        			if(vm.tipoRelaciones[x].value == vm.factura.facturasRelacionadas.tipoRelacion){
        				return vm.tipoRelaciones[x].label;
        			}
        		}
        	};


        	vm.obtenerDatos = function(){

        		if($stateParams.tipoDocumento != undefined && $stateParams.tipoDocumento != ''){
        			vm.factura.tipoDocumento = $stateParams.tipoDocumento;
        		}

	        	vm.loading = "whirl double-up";

	        	$http.post('/api/admin/facturacion/datosFacturar', {
					user : $rootScope.user
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						vm.loading = "";
						vm.clientes = response.clientes;
						vm.formasDePago = response.formasDePago;
						vm.unidadesMedida = response.unidadesMedida;
						vm.clavesProducto = response.clavesProducto;
						vm.usosCFDI = response.usosCFDI;
						vm.series = response.series;
						vm.factura.lugarExpedicion = response.proveedor.domicilio.codigoPostal;
						vm.usosCFDITmp = response.usosCFDI;

					}

				}, function errorCallback(response) {
					vm.obtenerDatos();
				  });
        	};


        	vm.opcionesFactura = function(){

                ngDialog.openConfirm({
                    template: 'opcionesFactura',
                    className: 'ngdialog-theme-default large-ngDialog',
                    controller: 'OpcionesFacturaController',
                    data: {factura: vm.factura}
                }).then(function (buscar) {

                }, function (factura) {

                	if(factura.tipoDocumento != undefined){
                		vm.factura.impuestosTrasladados = factura.impuestosTrasladados;
                		vm.factura.impuestosRetenidos = factura.impuestosRetenidos;
                		vm.factura.cuentaPredial = factura.cuentaPredial;
                		vm.factura.moneda = factura.moneda;
                		vm.factura.tipoCambio = factura.tipoCambio;
                	}

                	vm.calcularTotales();
                });

            };



            vm.facturaRelacionada = function(){

            	vm.factura.facturasRelacionadas.noFactura = '';

                ngDialog.openConfirm({
                    template: 'facturasRelacionadas',
                    className: 'ngdialog-theme-default',
                    controller: 'FacturasRelacionadasController',
                    data: {tipoRelaciones: vm.tipoRelaciones, facturasRelacionadas: vm.factura.facturasRelacionadas}
                }).then(function (documento) {

                }, function (documento) {
                	if(documento.tipoRelacion != undefined){
                		vm.factura.facturasRelacionadas = documento;
                	}
                });

            };


            vm.impuestosConcepto = function(index){

            	var concepto = vm.factura.detalles[index];

                ngDialog.openConfirm({
                    template: 'impuestosConcepto',
                    className: 'ngdialog-theme-default large-ngDialog',
                    controller: 'ImpuestoConceptoController',
                    data: {concepto: concepto}
                }).then(function (concepto) {

                }, function (concepto) {
                	if(concepto.qty != undefined && concepto.qty > 0){
                		vm.factura.detalles[index] = concepto;
                		vm.calcularTotales();
                	}
                });

            };

            vm.agregrProdExistente = function(){
            	if(vm.productoAgregar.id_producto != undefined){
            		vm.productoAgregar.precioU = Number(vm.productoAgregar.precioU);
            		vm.productoAgregar.qty = 1;
            		vm.productoAgregar.descuento = 0;
            		vm.productoAgregar.impuestosTrasladados = vm.productoAgregar.impuestosTrasladados;
            		vm.productoAgregar.impuestosRetenidos = [];
            		vm.factura.detalles.push(angular.copy(vm.productoAgregar));
            		vm.productoAgregar = '';
            	}

            	vm.calcularTotales();
            };


            vm.agregrProdNuevo = function(){
            		var productoNuevo = {
            			codigo: '1',
            			clave: '',
            			nombre: '',
            			unidad: '',
            			qty: 1,
            			precioU: 1.00,
            			descuento: 0,
            			impuestosTrasladados: [],
            			impuestosRetenidos : []
            		};
            		vm.factura.detalles.push(productoNuevo);
            		vm.productoAgregar = '';

            	vm.calcularTotales();
            };

            vm.calcularTotales = function(){

            	vm.factura.subtotal = 0;
            	vm.factura.total = 0;
            	vm.factura.base = 0;
            	vm.factura.descuento = 0;
            	vm.factura.totalTraslados = 0;
            	vm.factura.totalRetenciones = 0;
            	vm.factura.impuestosTrasladados = [];
            	vm.factura.impuestosRetenidos = [];


            	for(var x = 0; x < vm.factura.detalles.length; x++){

            		for(var y = 0; y < vm.factura.detalles[x].impuestosTrasladados.length; y++){
            			vm.factura.detalles[x].impuestosTrasladados[y].total = 0;
                	}

                	for(var y = 0; y < vm.factura.detalles[x].impuestosRetenidos.length; y++){
                		vm.factura.detalles[x].impuestosRetenidos[y].total = 0;
                	}

            		vm.factura.detalles[x].precioU = $rootScope.toFixedNumber(vm.factura.detalles[x].precioU,5);
            		vm.factura.detalles[x].descuento = $rootScope.toFixedNumber(vm.factura.detalles[x].descuento);

            		vm.factura.subtotal += $rootScope.toFixedNumber((vm.factura.detalles[x].qty * vm.factura.detalles[x].precioU));
            		vm.factura.detalles[x].base = (vm.factura.detalles[x].qty * vm.factura.detalles[x].precioU - vm.factura.detalles[x].descuento);
            		vm.factura.descuento += Number(vm.factura.detalles[x].descuento);

            		var litros = vm.factura.detalles[x].qty * 1000;
            		var baseCalcIva = vm.factura.detalles[x].base;
            		if(vm.factura.detalles[x].codigo == '01'){
            			baseCalcIva = baseCalcIva - (litros * 0.4052);
            		}else if(vm.factura.detalles[x].codigo == '02'){
            			baseCalcIva = baseCalcIva - (litros * 0.4944);
            		}else if(vm.factura.detalles[x].codigo == '03'){
            			baseCalcIva = baseCalcIva - (litros * 0.3363);
            		}


            		for(var y = 0; y < vm.factura.detalles[x].impuestosTrasladados.length; y++){

            			var tmp1 = vm.factura.detalles[x].impuestosTrasladados[y];
            			vm.factura.detalles[x].impuestosTrasladados[y].base = baseCalcIva;

            			var valorImpuesto = 0;
                		if(vm.factura.detalles[x].impuestosTrasladados[y].factor == 'Tasa'){
                			valorImpuesto = $rootScope.toFixedNumber(vm.factura.detalles[x].impuestosTrasladados[y].valor * vm.factura.detalles[x].impuestosTrasladados[y].base);
                		}else{
                			valorImpuesto = $rootScope.toFixedNumber(vm.factura.detalles[x].impuestosTrasladados[y].valor);
                		}
                		vm.factura.detalles[x].impuestosTrasladados[y].total = valorImpuesto;
                		vm.factura.totalTraslados += valorImpuesto ;

                		var addNewTax = true;

                		for(var z = 0; z < vm.factura.impuestosTrasladados.length; z++){

                			var tmp2 = vm.factura.impuestosTrasladados[z];

                			if(vm.factura.impuestosTrasladados[z].impuesto == vm.factura.detalles[x].impuestosTrasladados[y].impuesto
                					&& vm.factura.impuestosTrasladados[z].factor == vm.factura.detalles[x].impuestosTrasladados[y].factor
                						&& vm.factura.impuestosTrasladados[z].valor == vm.factura.detalles[x].impuestosTrasladados[y].valor){

                				vm.factura.impuestosTrasladados[z].total += valorImpuesto;
                				addNewTax = false;
                			}
                		}

                		if(addNewTax){
                			vm.factura.impuestosTrasladados.push(angular.copy(vm.factura.detalles[x].impuestosTrasladados[y]));
                		}

                	}


            		for(var y = 0; y < vm.factura.detalles[x].impuestosRetenidos.length; y++){

            			var valorImpuesto = 0;
            			vm.factura.detalles[x].impuestosRetenidos[y].base = vm.factura.detalles[x].base;

                		if(vm.factura.detalles[x].impuestosRetenidos[y].factor == 'Tasa'){
                			valorImpuesto = $rootScope.toFixedNumber(vm.factura.detalles[x].impuestosRetenidos[y].valor * vm.factura.detalles[x].impuestosRetenidos[y].base);
                		}else{
                			valorImpuesto = $rootScope.toFixedNumber(vm.factura.detalles[x].impuestosRetenidos[y].valor);
                		}
                		vm.factura.detalles[x].impuestosRetenidos[y].total += valorImpuesto;
                		vm.factura.totalRetenciones += valorImpuesto;

                		var addNewTax = true;

                		for(var z = 0; z < vm.factura.impuestosRetenidos.length; z++){
                			if(vm.factura.impuestosRetenidos[z].impuesto == vm.factura.detalles[x].impuestosRetenidos[y].impuesto
                					&& vm.factura.impuestosRetenidos[z].factor == vm.factura.detalles[x].impuestosRetenidos[y].factor
                						&& vm.factura.impuestosRetenidos[z].valor == vm.factura.detalles[x].impuestosRetenidos[y].valor){

                				vm.factura.impuestosRetenidos[z].total += valorImpuesto;
                				addNewTax = false;
                			}
                		}

                		if(addNewTax){
                			vm.factura.impuestosRetenidos.push(angular.copy(vm.factura.detalles[x].impuestosRetenidos[y]));
                		}
                	}

            	}

            	vm.factura.total = vm.factura.base = vm.factura.subtotal - vm.factura.descuento;
            	vm.factura.total += (vm.factura.totalTraslados - vm.factura.totalRetenciones);
            	vm.factura.total = $rootScope.toFixedNumber(vm.factura.total);

            };

            vm.borrarConcepto = function(index){
            	vm.factura.detalles.splice(index, 1);
            	vm.calcularTotales();
            };


            /////Funcionalidad select de mobile para customer
            vm.getMatchesCustomer = function(searchText) {
				if(searchText == "" || searchText == null)
					return vm.clientes;
		            var states = vm.clientes.filter(function(customer) {
		            	var pordChane = customer.nmbRecep + " " + customer.rFCRecep;
		                return (pordChane.toUpperCase().match(searchText.toUpperCase()));
		            });

		        return states;
		    }

            vm.selectedCustomer = function(cliente){
				if(typeof(cliente) != 'undefined' && typeof(cliente.id_cliente) != 'undefined'){
					vm.factura.id_cliente = cliente;
					vm.obtenerPaises();
				}else{
					vm.factura.id_cliente = 0;
				}
			};
			////////////////////////////

			vm.obtenerPaises = function(){

				vm.usosCFDITmp = [];

				if(isNaN(Number(vm.factura.id_cliente.rFCRecep.charAt(3)))){

					vm.usosCFDITmp = vm.usosCFDI;

				}else{
					for(var x = 0; x < vm.usosCFDI.length; x++){
						if(vm.usosCFDI[x].validMoral == 1){
							vm.usosCFDITmp.push(vm.usosCFDI[x]);
						}
					}
				}

				vm.factura.formaPago = vm.factura.id_cliente.metodoPago;
				vm.factura.usoCFDI = vm.factura.id_cliente.usoCFDI

				if( vm.factura.id_cliente!= null && vm.factura.id_cliente.rFCRecep == 'XEXX010101000'){

					$http.post('/api/admin/facturacion/obtenerPaises', {
						user : $rootScope.user
					}).then(function(res) {
						var response = res['data'];
						if (response['success']) {

							vm.loading = "";
							vm.paises = response.paises;
						}

					}, function errorCallback(response) {
						vm.obtenerDatos();
					  });

				}
			};

			vm.borrarFacturaRelacionada = function(index){
				vm.factura.facturasRelacionadas.uuids.splice(index, 1);
			};


			vm.seleccionarMetodoPago = function(){
				if(vm.factura.metodoDePago == 'PPD'){
					vm.factura.formaPago = '99';
					$("#formaPago").trigger("chosen:updated");
				}
			};


			vm.facturar = function(){

				if(vm.factura.id_cliente == '' || vm.factura.id_cliente == null){
					Notify.alert('Debe seleccionar un cliente.', {status: 'danger'});
					$('#id_cliente').trigger('chosen:activate');
					return;
				}

				if(vm.factura.formaPago == '' || vm.factura.formaPago == null){
					Notify.alert('Debe seleccionar una forma de pago.', {status: 'danger'});
					$('#formaPago').trigger('chosen:activate');
					$('#formaPago').focus();
					return;
				}


				if(vm.factura.lugarExpedicion == '' || vm.factura.lugarExpedicion == null || vm.factura.lugarExpedicion.length < 5 ){
					Notify.alert('Debe ingresar un lugar de expedición correcto (C.P.)', {status: 'danger'});
					$('#lugarExpedicion').focus();
					return;
				}


				if(vm.factura.usoCFDI == '' || vm.factura.usoCFDI == null){
					Notify.alert('Debe seleccionar el uso del CFDI.', {status: 'danger'});
					$('#usoCFDI').trigger('chosen:activate');
					$('#usoCFDI').focus();
					return;
				}

				if(vm.factura.detalles.length == 0){
					Notify.alert('Debe agregar al menos un producto.', {status: 'danger'});
					return;
				}

				for(var x = 0; x < vm.factura.detalles.length; x++){

					var concepto = vm.factura.detalles[x];

					if(concepto.clave == ''){
						Notify.alert('Debe seleccionar una clave para cada concepto.', {status: 'danger'});
						$('#clave' + x).focus();
						$('#clave' + x).trigger('chosen:activate');
						return;
					}

					if(concepto.nombre == ''){
						Notify.alert('Debe agregar una descripción para cada concepto.', {status: 'danger'});
						$('#nombre' + x).focus();
						return;
					}

					if(concepto.qty == null || concepto.qty < 0.00001){
						Notify.alert('La cantidad por concepto debe ser al mayor a 0.', {status: 'danger'});
						$('#qty' + x).focus();
						return;
					}

					if(concepto.precioU == null){
						Notify.alert('Debe ingresar un precio unitario.', {status: 'danger'});
						$('#precioU' + x).focus();
						return;
					}

				}

				vm.loading = "whirl double-up";

				var urlFacturar = '/api/admin/facturacion/facturarPorConcepto';
				$http.post(urlFacturar, {
					user : $rootScope.user,
					factura: vm.factura
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						SweetAlert.swal('Éxito!', 'Se generó su factura de forma correcta con el No. ' + response.facturaResult, 'success');
						$state.transitionTo('app.listadoFacturas');

					}else{
						SweetAlert.swal('Error!', response.errorCode + ' - ' + response.errortext + ' <br>' + response.nombreArchivo, 'error');
					}

					vm.loading = "";

				}, function errorCallback(response) {
					vm.loading = "";
				});



			};



        	vm.obtenerDatos();



        }
    }
})();
