(function() {
    'use strict';

    angular
        .module('app.forms')
        .controller('ConfiguracionesController', ConfiguracionesController);

    ConfiguracionesController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'ngDialog'];

    function ConfiguracionesController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, ngDialog) {
        var vm = this;
        vm.proveedor = {};
        vm.series = [];
        vm.clavesProductoServicio = [];
        vm.unidadesMedida = [];
        vm.disenoFactura = '';
        vm.files = [];
        
        
        activate();

        ////////////////
        
        function activate() {

        	
        	vm.obtenerDatos = function(){
        	
	        	vm.loading = "whirl double-up";
	        	
	        	$http.post('/api/admin/configuraciones/obtenerDatos', {
					user : $rootScope.user
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {
						
						vm.loading = "";
                        vm.proveedor = response.proveedor;
                        vm.series = response.series;
                        vm.clavesProductoServicio = response.clavesProductoServicio;
                        vm.unidadesMedida = response.unidadesMedida;
                        console.log(vm.series);
						
					}
					
				}, function errorCallback(response) {
					vm.obtenerDatos();
				  });
        	}
        	
        	vm.guardarDatos = function(){
            	
	        	vm.loading = "whirl double-up";
	        	
	        	$http.post('/api/admin/proveedores/guardarMisDatos', {
					user : $rootScope.user,
					proveedor: vm.proveedor
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {
						
						vm.loading = "";
						SweetAlert.swal('Datos guardados', 'Sus datos se han guardado de forma correcta', 'success');
					}
					
				}, function errorCallback(response) {
					Notify.alert('Ocurrió un error.', {status: 'danger'});
					vm.loadingWare = "";
				  });
        	}

            vm.agregarProdudctosServicios = function(){
                
                ngDialog.openConfirm({
                    template: 'agregarProdServicios',
                    className: 'ngdialog-theme-default large-ngDialog',
                    controller: 'AgregarProductoServicioController',
                    data: {clavesProductoServicio: vm.clavesProductoServicio}
                }).then(function (buscar) {
                    
                }, function (state) {
                    
                });
                
            };


            vm.agregarUnidadesMedida = function(){
                
                ngDialog.openConfirm({
                    template: 'agregarUnidadMedida',
                    className: 'ngdialog-theme-default large-ngDialog',
                    controller: 'AgregarUnidadesMedidaController',
                    data: {unidadesMedida: vm.unidadesMedida}
                }).then(function (buscar) {
                    
                }, function (state) {
                    
                });
                
            };


            vm.agregarSerie = function(){
                
                ngDialog.openConfirm({
                    template: 'agregarSerie',
                    className: 'ngdialog-theme-default',
                    controller: 'AgregarSerieController',
                    data: {series: vm.series}
                }).then(function (buscar) {
                    
                }, function (state) {
                    
                });
                
            };

            vm.borrarClaveProductoServicio = function(id, index){

                $http.post('/api/admin/configuraciones/agregarProdServicio', {
                    user : $rootScope.user,
                    id: id,
                    isAgregar: false
                }).then(function(res) {
                    var response = res['data'];
                    if (response['success']) {
                        
                        $scope.loadingWare = "";

                        vm.clavesProductoServicio.splice(index, 1);

                        Notify.alert('La clave se eliminó de forma correcta.', {status: 'success'});
                        
                    }
                    
                }, function errorCallback(response) {
                    Notify.alert('Ocurrió un error.', {status: 'danger'});
                    $scope.loadingWare = "";
                  });

            };


            vm.borrarUnidadMedida = function(id, index){

                $http.post('/api/admin/configuraciones/agregarUnidadMedida', {
                    user : $rootScope.user,
                    id: id,
                    isAgregar: false
                }).then(function(res) {
                    var response = res['data'];
                    if (response['success']) {
                        
                        $scope.loadingWare = "";

                        vm.unidadesMedida.splice(index, 1);

                        Notify.alert('La unidad de medida se eliminó de forma correcta.', {status: 'success'});
                        
                    }
                    
                }, function errorCallback(response) {
                    Notify.alert('Ocurrió un error.', {status: 'danger'});
                    $scope.loadingWare = "";
                  });

            };
            
            
            vm.borrarSerie = function(id, index){

                $http.post('/api/admin/configuraciones/borrarSerie', {
                    user : $rootScope.user,
                    id: id,
                    isAgregar: false
                }).then(function(res) {
                    var response = res['data'];
                    if (response['success']) {
                        
                        $scope.loadingWare = "";

                        vm.series.splice(index, 1);

                        Notify.alert('La serie se eliminó de forma correcta.', {status: 'success'});
                        
                    }
                    
                }, function errorCallback(response) {
                    Notify.alert('Ocurrió un error.', {status: 'danger'});
                    $scope.loadingWare = "";
                  });

            };
        	
        	vm.obtenerDatos();

        }
        
        //Actualizar certificados
        $('#logotipo').on('change', prepareLogoUpload);
        
        function prepareLogoUpload(event) {
        	
        	if(event.target.files[0].size > 1024000){
        		Notify.alert('El tamaño máximo de imágen debe ser de 1MB', {status: 'danger'});
        		vm.files = [];
        		return false;
        	}
        	
        	vm.files[0] = event.target.files[0];
        }
        
        vm.actualizarLogotipo = function()
        {
        	
        	if(vm.proveedor.template33 == ''){
        		Notify.alert('Debe seleccionar un diseño de factura.', {status: 'danger'});
        		return;
        	}
        	
        	vm.loadingLogo = "whirl double-up";
        	
        	
            // Create a formdata object and add the files
        	var data = new FormData();
        	if(vm.files.length > 0){
	            $.each(vm.files, function(key, value)
	            {
	                data.append('logotipoFile', value);
	            });
        	}
            
            data.append('id_proveedor', $rootScope.user.id_proveedor);
            data.append('token', $rootScope.user.token);
            data.append('color', vm.proveedor.color);
            

            $.ajax({
                url: '/api/admin/configuraciones/actualizarLogotipo',
                type: 'POST',
                data: data,
                cache: false,
                dataType: 'json',
                processData: false, // Don't process the files
                contentType: false, // Set content type to false as jQuery will tell the server its a query string request
                success: function(data, textStatus, jqXHR)
                {
                	
                	if(data.success == true){
                		
                		$("#logotipo").val('');
                		if(data.newImage != ''){
                			vm.proveedor.imagen = data.newImage; 
                		}
                		SweetAlert.swal('Datos actualizados', 'Su logotipo y diseño de factura se actualizaron de forma correcta.', 'success');
                		
                	}else{
                		Notify.alert(data.errorText, {status: 'danger'});
                	}
                	
                	vm.loadingLogo = "";
                },
                error: function(jqXHR, textStatus, errorThrown)
                {
                	Notify.alert('Ocurrió un error al cargar tu certificado. Vuelve a intentarlo nuevamente.', {status: 'danger'});
                	vm.loadingLogo = "";
                }
            });
        }
        
    }
})();


(function() {
    'use strict';

    angular
        .module('app.forms')
        .controller('AgregarProductoServicioController', AgregarProductoServicioController);

    AgregarProductoServicioController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                            'Notify', '$rootScope', 'SweetAlert', 'ngDialog', 'DTOptionsBuilder', 'DTColumnDefBuilder'];

    function AgregarProductoServicioController($scope, $http, $state, $stateParams, Notify,
            $rootScope, SweetAlert, ngDialog, DTOptionsBuilder, DTColumnDefBuilder) {
        

        $scope.tipoProdServicioLista = [{label: 'Producto', value: 1}, {label: 'Servicio', value: 2}];
        $scope.filtroProdServ = {
            tipoProdServicio: 0,
            tipoFiltro: 1
        };
        $scope.divisiones = [];
        $scope.grupos = [];
        $scope.listadoDivisionesBack = [];

        $scope.dtOptions = DTOptionsBuilder.newOptions()
        .withOption('order', [0, 'desc'])
        .withDisplayLength(25);


        $scope.obtenerDivisiones = function(){

            $scope.loadingWare = "whirl double-up";
            $scope.filtroProdServ.claveDescripcion = '';

            $http.post('/api/admin/configuraciones/obtenerDivisiones', {
                    user : $rootScope.user,
                    tipoProdServicio: $scope.filtroProdServ.tipoProdServicio
                }).then(function(res) {
                    var response = res['data'];
                    if (response['success']) {
                        
                        $scope.loadingWare = "";
                        $scope.divisiones = response.divisiones;
                        
                    }
                    
                }, function errorCallback(response) {
                    Notify.alert('Ocurrió un error.', {status: 'danger'});
                    $scope.loadingWare = "";
                  });
        }



        $scope.obtenerGrupos = function(){

            $scope.loadingWare = "whirl double-up";
            $scope.filtroProdServ.claveDescripcion = '';

            $http.post('/api/admin/configuraciones/obtenerGrupos', {
                    user : $rootScope.user,
                    id_division: $scope.filtroProdServ.id_division
                }).then(function(res) {
                    var response = res['data'];
                    if (response['success']) {
                        
                        $scope.loadingWare = "";
                        $scope.grupos = response.grupos;
                        
                    }
                    
                }, function errorCallback(response) {
                    Notify.alert('Ocurrió un error.', {status: 'danger'});
                    $scope.loadingWare = "";
                  });
        };


        $scope.obtenerClavesProdServ = function(){

            if($scope.filtroProdServ.tipoFiltro == 2){
                if($scope.filtroProdServ.claveDescripcion == undefined || $scope.filtroProdServ.claveDescripcion.length < 4){
                    Notify.alert('Debe ingresar al menos 4 caractéres.', {status: 'danger'});
                    return;
                }

            }

            $scope.loadingWare = "whirl double-up";

            $http.post('/api/admin/configuraciones/obtenerClavesProdServ', {
                    user : $rootScope.user,
                    filtroProdServ: $scope.filtroProdServ
                }).then(function(res) {
                    var response = res['data'];
                    if (response['success']) {
                        
                        $scope.loadingWare = "";
                        $scope.listadoDivisiones = response.listadoDivisiones;

                        if($scope.filtroProdServ.codigo_clase == undefined || $scope.filtroProdServ.codigo_clase < 0){
                            $scope.listadoDivisionesBack = angular.copy(response.listadoDivisiones);
                        }
                        
                        setTimeout(function(){ 

                            $(".radioProdServ").on( "change", function() {
                              $scope.agregarProdServicio($(this).val(), $(this).prop('checked'));
                            });

                        }, 500);

                    }
                    
                }, function errorCallback(response) {
                    Notify.alert('Ocurrió un error.', {status: 'danger'});
                    $scope.loadingWare = "";
                  });

        };

        $scope.filtrarPorClase = function(){
            $scope.listadoDivisionesBack = angular.copy($scope.listadoDivisiones);
            $scope.obtenerClavesProdServ();
        };

        $scope.agregarProdServicio = function(id, isAgregar){

            $scope.loadingWare = "whirl double-up";

            $http.post('/api/admin/configuraciones/agregarProdServicio', {
                    user : $rootScope.user,
                    id: id,
                    isAgregar: isAgregar
                }).then(function(res) {
                    var response = res['data'];
                    if (response['success']) {
                        
                        $scope.loadingWare = "";

                        var status = 'eliminó';
                        var statusMsg = "info";

                        if(isAgregar == true){
                            status = 'agregó';
                            statusMsg = "success";
                            var agregarAListado = true;

                            if(response.productoServicioProveedor.id_prodServicio == undefined){
                                agregarAListado = false;
                            }else{
                                for(var x = 0; x < $scope.ngDialogData.clavesProductoServicio.length; x++){
                                    if($scope.ngDialogData.clavesProductoServicio[x].id_prodServicio == response.productoServicioProveedor.id_prodServicio){
                                        agregarAListado = false;
                                        break;
                                    }
                                }
                            }
                            if(agregarAListado){
                                $scope.ngDialogData.clavesProductoServicio.push(response.productoServicioProveedor);
                            }
                            
                        }else{

                            for(var x = 0; x < $scope.ngDialogData.clavesProductoServicio.length; x++){
                                    if($scope.ngDialogData.clavesProductoServicio[x].id_prodServicio == id){
                                        $scope.ngDialogData.clavesProductoServicio.splice(x, 1);
                                        break;
                                    }
                            }

                        }

                        Notify.alert('Se '+ status +' de forma correcta.', {status: statusMsg});

                        
                    }
                    
                }, function errorCallback(response) {
                    Notify.alert('Ocurrió un error.', {status: 'danger'});
                    $scope.loadingWare = "";
                  });

        };

        $scope.focusDescripcion = function(){
            $scope.filtroProdServ.tipoProdServicio = 0;
            $scope.filtroProdServ.claveDescripcion = '';
            $scope.divisiones = [];
            $scope.listadoDivisionesBack = [];
            $scope.grupos = [];
            $scope.listadoDivisiones = [];
            if($scope.filtroProdServ.tipoFiltro == 2)
                $("#claveDescripcion").focus();
        };

        $("#tipoProdServicioLista").focus();


    }
})();



(function() {
    'use strict';

    angular
        .module('app.forms')
        .controller('AgregarUnidadesMedidaController', AgregarUnidadesMedidaController);

    AgregarUnidadesMedidaController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                            'Notify', '$rootScope', 'SweetAlert', 'ngDialog', 'DTOptionsBuilder', 'DTColumnDefBuilder'];

    function AgregarUnidadesMedidaController($scope, $http, $state, $stateParams, Notify,
            $rootScope, SweetAlert, ngDialog, DTOptionsBuilder, DTColumnDefBuilder) {
        

        $scope.filtroTextoUnidadMedida = '';
        $scope.unidadesMedida = [];

        $scope.obtenerUnidadesMedida = function(){

            if($scope.filtroTextoUnidadMedida == undefined || $scope.filtroTextoUnidadMedida == ''){
                $scope.unidadesMedida = [];
                return;
            }else if($scope.filtroTextoUnidadMedida.length == 1){
                Notify.alert('Debe ingresar al menos 2 caractéres.', {status: 'danger'});
                return;
            }


            $scope.loadingWare = "whirl double-up";

            $http.post('/api/admin/configuraciones/obtenerUnidadesMedida', {
                    user : $rootScope.user,
                    filtroTextoUnidadMedida: $scope.filtroTextoUnidadMedida,
                    tipoFiltroAdicional: $scope.tipoFiltroAdicional
                }).then(function(res) {
                    var response = res['data'];
                    if (response['success']) {
                        
                        $scope.loadingWare = "";
                        $scope.unidadesMedida = response.unidadesMedida;

                        
                        setTimeout(function(){
                            $(".radioUnidadMedida").on( "change", function() {
                              $scope.agregarUnidadMedida($(this).val(), $(this).prop('checked'));
                            });
                        }, 500);
                        

                    }
                    
                }, function errorCallback(response) {
                    Notify.alert('Ocurrió un error.', {status: 'danger'});
                    $scope.loadingWare = "";
                  });

        };

        $scope.seleccionarRadioUnidad = function(id){
            if($("#unidadMedida" + id).prop('checked') == true){
                $("#unidadMedida" + id).prop('checked', false);
                $scope.agregarUnidadMedida(id, false);
            }else{
                $("#unidadMedida" + id).prop('checked', true);
                $scope.agregarUnidadMedida(id, true);
            }
        }

        

        $scope.agregarUnidadMedida = function(id, isAgregar){

            $scope.loadingWare = "whirl double-up";

            $http.post('/api/admin/configuraciones/agregarUnidadMedida', {
                    user : $rootScope.user,
                    id: id,
                    isAgregar: isAgregar
                }).then(function(res) {
                    var response = res['data'];
                    if (response['success']) {
                        
                        $scope.loadingWare = "";

                        var status = 'eliminó';
                        var statusMsg = "info";

                        if(isAgregar == true){
                            status = 'agregó';
                            statusMsg = "success";
                            var agregarAListado = true;

                            if(response.unidadMedidaProveedor.id_unidadMedida == undefined){
                                agregarAListado = false;
                            }else{
                                for(var x = 0; x < $scope.ngDialogData.unidadesMedida.length; x++){
                                    if($scope.ngDialogData.unidadesMedida[x].id_unidadMedida == response.unidadMedidaProveedor.id_unidadMedida){
                                        agregarAListado = false;
                                        break;
                                    }
                                }
                            }
                            if(agregarAListado){
                                $scope.ngDialogData.unidadesMedida.push(response.unidadMedidaProveedor);
                            }
                            
                        }else{

                            for(var x = 0; x < $scope.ngDialogData.unidadesMedida.length; x++){
                                    if($scope.ngDialogData.unidadesMedida[x].id_unidadMedida == id){
                                        $scope.ngDialogData.unidadesMedida.splice(x, 1);
                                        break;
                                    }
                            }

                        }

                        Notify.alert('Se '+ status +' de forma correcta.', {status: statusMsg});

                        
                    }
                    
                }, function errorCallback(response) {
                    Notify.alert('Ocurrió un error.', {status: 'danger'});
                    $scope.loadingWare = "";
                  });

        };

    }
})();




(function() {
    'use strict';

    angular
        .module('app.forms')
        .controller('AgregarSerieController', AgregarSerieController);

    AgregarSerieController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                            'Notify', '$rootScope', 'SweetAlert', 'ngDialog', 'DTOptionsBuilder', 'DTColumnDefBuilder'];

    function AgregarSerieController($scope, $http, $state, $stateParams, Notify,
            $rootScope, SweetAlert, ngDialog, DTOptionsBuilder, DTColumnDefBuilder) {
        

        $scope.nuevaSerie = '';

        $scope.agregarSerie = function(){

            if($scope.nuevaSerie == undefined || $scope.nuevaSerie == ''){
                Notify.alert('Debe ingresar al menos 1 caractér como serie.', {status: 'danger'});
                return;
            }


            $scope.loadingWare = "whirl double-up";

            $http.post('/api/admin/configuraciones/guardarSerie', {
                    user : $rootScope.user,
                    nuevaSerie: $scope.nuevaSerie
                }).then(function(res) {
                    var response = res['data'];
                    if (response['success']) {
                        
                        $scope.loadingWare = "";
                        $scope.ngDialogData.series.push(response.serie);
                        $scope.closeThisDialog(0);
                        Notify.alert('Se creó la serie de forma correcta.', {status: 'success'});

                    }
                    
                }, function errorCallback(response) {
                    Notify.alert('Ocurrió un error.', {status: 'danger'});
                    $scope.loadingWare = "";
                  });

        };


    }
})();