(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('ClientesController', ClientesController);

    ClientesController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert'];

    function ClientesController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert) {
        var vm = this;
        vm.clientes = [];

        activate();

        ////////////////

        function activate() {


        	vm.obtenerDatos = function(){

	        	vm.loading = "whirl double-up";

	        	$http.post('/api/admin/clientes/obtenerClientes', {
					user : $rootScope.user
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						vm.loading = "";
						vm.clientes = response.clientes;

					}

				}, function errorCallback(response) {
					Notify.alert('Ocurrió un error.', {status: 'danger'});
					vm.loadingWare = "";
				  });
        	}

        	vm.obtenerCliente = function(id_cliente){

        		$state.transitionTo('app.clienteDetalle', {id: id_cliente});

        	};

        	vm.borrarCliente = function(cliente){

        		SweetAlert.swal({
                    title: 'Eliminar cliente',
                    text: 'Estás seguro de eliminar a ' + cliente.nmbRecep,
                    type: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#DD6B55',
                    confirmButtonText: 'Sí, elimínalo!',
                    cancelButtonText: 'No, cancelar!',
                    closeOnConfirm: false,
                    closeOnCancel: false
                }, function (isConfirm) {
                    if (isConfirm) {


                        $http.post('/api/admin/clientes/borrarCliente', {
                        	id_cliente: cliente.id_cliente,
                            user: $rootScope.user
                        }).then(function (res) {
                            var response = res['data'];
                            if (response['success']) {

                            	for(var x = 0; x < vm.clientes.length; x++){
                            		if(vm.clientes[x].id_cliente == cliente.id_cliente){
                            			vm.clientes.splice(x, 1);
                            		}
                            	}

                                SweetAlert.swal('Deleted!', 'El cliente fue eliminado correctamente.', 'success');
                            }
                        });

                    } else {
                        SweetAlert.swal('Cancelado', 'El cliente NO fue eliminado :)', 'error');
                    }
                });

        	};


        	vm.obtenerDatos();

        }

    }
})();


(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('ClienteDetalleController', ClienteDetalleController);

    ClienteDetalleController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert'];

    function ClienteDetalleController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert) {
        var vm = this;
        vm.cliente = {
        	rFCRecep: '',
        	nmbRecep: '',
        	id_cliente: 0,
        	usoCFDI: 0,
            metodoPago: 0,
            cp: '',
            tipoPersona: '1',
            regimenFiscalReceptor: '621',
            contacto:{email: '', telefono: ''}
        };
        vm.catalogoregimenfiscal = [];

        activate();

        ////////////////

        function activate() {


        	vm.obtenerDatos = function(){

	        	vm.loading = "whirl double-up";

	        	var id_cliente = $stateParams.id;

	        	$http.post('/api/admin/clientes/obtenerCliente', {
					user : $rootScope.user,
					id_cliente: id_cliente
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						vm.loading = "";
						if(id_cliente > 0){
							vm.cliente = response.cliente;
						}

						vm.formaPago = response.formaPago;
						vm.usosCFDI = response.usosCFDI;
                        vm.regimenesFiscales = response.regimenesFiscales;

                        vm.obtenerRegimenesFiscales();

					}

				}, function errorCallback(response) {
					Notify.alert('Ocurrió un error.', {status: 'danger'});
					vm.loadingWare = "";
				  });
        	}

        	vm.obtenerCliente = function(id_cliente){

        		$state.transitionTo('app.cliente', {id: id_cliente});

        	};

        	vm.guardarDatos = function(){

        		vm.cliente.rFCRecep = vm.cliente.rFCRecep.trim().toUpperCase();

        		var isValidRFC = rfcValido(vm.cliente.rFCRecep, true);

        		if(isValidRFC){

        			vm.loading = "whirl double-up";

	        		$http.post('/api/admin/clientes/guardar', {
						user : $rootScope.user,
						cliente: vm.cliente
					}).then(function(res) {
						var response = res['data'];
						if (response['success']) {

							vm.loading = "";

							SweetAlert.swal('Cliente guardado', 'El cliente ha sido guardado correctamente.', 'success');

							$state.transitionTo('app.clientes');

						}

					}, function errorCallback(response) {
						Notify.alert('Ocurrió un error.', {status: 'danger'});
						vm.loadingWare = "";
					  });

	        	}else{
	        		Notify.alert('El RFC ingresado es inválido.', {status: 'danger'});
	        		$("#rFCRecep").focus();
	        	}

        	}

            vm.obtenerRegimenesFiscales = function (){
                vm.regimenesFiscalesList = [];
                for(let x = 0; x < vm.regimenesFiscales.length; x++){
                    if(vm.regimenesFiscales[x].tipo == vm.cliente.tipoPersona || vm.regimenesFiscales[x].tipo == 3){
                        vm.regimenesFiscalesList.push(vm.regimenesFiscales[x]);
                    }
                }
            };


        	vm.obtenerDatos();

        }



        function rfcValido(rfc, aceptarGenerico = true) {

            var   validado = /^[A-Z&Ñ]{3,4}[0-9]{2}(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])[A-Z0-9]{2}[0-9A]$/.test(rfc)

            return validado;
        }

    }
})();
