# Complementos CFDI

## Complementos Implementados

### 1. Pagos 2.0

Complemento para recepción de pagos (complementos de pago).

#### Namespace
`http://www.sat.gob.mx/Pagos20`

#### Cuándo se usa
- Cuando se emite un CFDI de tipo "P" (Pago)
- Para relacionar pagos con facturas emitidas con método "PPD"

#### Estructura de Datos

```php
pagos: [
    {
        FechaPago: "2024-01-15T10:30:00",
        FormaDePagoP: "03",              // Transferencia
        MonedaP: "MXN",
        Monto: 1000.00,
        TipoCambioP: 1.00,               // Si MonedaP != MXN
        banco: "012",                     // RFC banco ordenante
        cuenta: "1234567890",             // Últimos 4 dígitos
        rfcEmisorCtaBen: "012",           // RFC banco beneficiario
        ctaBeneficiario: "0987654321",    // Últimos 4 dígitos
        noOperacion: "OP123456",          // Número de operación
        documentosRelacionado: [
            {
                IdDocumento: "UUID-DE-FACTURA",
                MonedaDR: "MXN",
                MetodoDePagoDR: "PPD",
                NumParcialidad: 1,
                ImpSaldoAnt: 1160.00,
                ImpPagado: 1000.00,
                ImpSaldoInsoluto: 160.00,
                TipoCambioDR: null,      // Si MonedaDR != MonedaP
                ObjetoImpDR: "02",
                traslados: [...],        // Impuestos del DR
                retenciones: [...]       // Impuestos del DR
            }
        ]
    }
]

totalesPagos: {
    totalRetencionesIVA: 0.00,
    totalRetencionesISR: 0.00,
    totalRetencionesIEPS: 0.00,
    totalTrasladosBaseIVA16: 1000.00,
    totalTrasladosImpuestoIVA16: 160.00,
    totalTrasladosBaseIVA8: 0.00,
    totalTrasladosImpuestoIVA8: 0.00,
    totalTrasladosBaseIVA0: 0.00,
    totalTrasladosImpuestoIVA0: 0.00,
    totalTrasladosBaseIVAExento: 0.00,
    montoTotalPagos: 1000.00
}
```

#### XML Generado

```xml
<pago20:Pagos Version="2.0">
    <pago20:Totales 
        MontoTotalPagos="1000.00"
        TotalRetencionesIVA="0.00"
        TotalRetencionesISR="0.00"
        TotalTrasladosBaseIVA16="1000.00"
        TotalTrasladosImpuestoIVA16="160.00"/>
    
    <pago20:Pago 
        FechaPago="2024-01-15T10:30:00"
        FormaDePagoP="03"
        MonedaP="MXN"
        Monto="1000.00">
        
        <pago20:DoctoRelacionado
            IdDocumento="UUID-FACTURA"
            MonedaDR="MXN"
            ObjetoImpDR="02"
            MetodoDePagoDR="PPD"
            NumParcialidad="1"
            ImpSaldoAnt="1160.00"
            ImpPagado="1000.00"
            ImpSaldoInsoluto="160.00">
            
            <pago20:ImpuestosDR>
                <pago20:TrasladosDR>
                    <pago20:TrasladoDR 
                        BaseDR="1000.00"
                        ImpuestoDR="002"
                        TipoFactorDR="Tasa"
                        TasaOCuotaDR="0.160000"
                        ImporteDR="160.00"/>
                </pago20:TrasladosDR>
            </pago20:ImpuestosDR>
        </pago20:DoctoRelacionado>
    </pago20:Pago>
</pago20:Pagos>
```

---

### 2. Carta Porte 3.1

Complemento para el transporte de mercancías.

#### Namespace
`http://www.sat.gob.mx/CartaPorte31`

#### Versiones
- CartaPorte 2.0 (hasta 31-mar-2024)
- CartaPorte 3.0 (01-abr-2024 al 16-jul-2024)
- CartaPorte 3.1 (desde 17-jul-2024) **ACTUAL**

#### Cuándo se usa
- CFDI tipo "I" con complemento
- CFDI tipo "T" (Traslado) - Obligatorio

#### Estructura de Datos

```php
cartaPorte: {
    transpInternac: "No",                    // Sí/No
    entradaSalidaMerc: "",                   // Entrada/Salida (si transpInternac=Sí)
    paisOrigenDestino: "",                   // País (si transpInternac=Sí)
    viaEntradaSalida: "01",                  // 01=Autotransporte, 02=Marítimo, etc.
    pesoBrutoTotal: 1000.50,
    unidadPeso: "KGM",
    idccp: "CCC20240115001",                 // ID del CCP
    totalDistanciaRecorrida: 250.75,
    
    ubicaciones: [
        {
            tipoUbicacion: "Origen",
            idUbicacion: "OR123456",         // Opcional
            rFCRemitenteDestinatario: "RFC123456789",
            nombreDestinatario: "EMPRESA SA",
            numRegIdTrib: "",                // Para extranjeros
            fechaHoraSalidaLlegada: "2024-01-15T08:00:00",
            calle: "Av. Principal",
            numeroExterior: "123",
            numeroInterior: "",
            colonia: "Centro",
            municipio: "Guadalajara",
            estado: "JAL",
            pais: "MEX",
            codigoPostal: "44100",
            totalDistRec: 0.00
        },
        {
            tipoUbicacion: "Destino",
            // ... campos similares
            totalDistRec: 250.75
        }
    ],
    
    mercancias: [
        {
            bienesTransp: "10101500",        // Clave SAT
            claveUnidad: "KGM",
            cantidad: 100,
            peso: 1000.50,
            descripcion: "Descripción de la mercancía",
            moneda: "MXN",
            valorMercancia: 10000.00,
            fraccionArancelaria: "12345678",  // Opcional
            pedimento: "24  47  3807  1234567" // Opcional
        }
    ],
    
    autotransporte: {                        // Solo si viaEntradaSalida = 01
        tipoPermiso: "TPAF01",
        noPermiso: "PERM123456",
        configTransporte: "VL",
        anioModeloVM: "2020",
        placaVM: "ABC1234",
        aseguraRespCivil: "ASEGURADORA SA",
        polizaRespCivil: "POL123456",
        pesoBrutoVehicular: "1000.50",
        remolques: [
            {
                subTipoRem: "CTR001",
                placa: "REM123"
            }
        ]
    },
    
    figurasTransporte: [
        {
            tipoFigura: "01",                // 01=Operador
            rFCFigura: "OABC123456XYZ",
            numLicencia: "LIC123456",
            nombreFigura: "OPERADOR NOMBRE",
            numRegIdTribFigura: "",
            parteTransporte: "PT01",         // Opcional
            pais: "MEX",
            estado: "JAL",
            codigoPostal: "44100"
        }
    ]
}
```

---

### 3. Nómina 1.2

Complemento para recibos de nómina.

#### Namespace
`http://www.sat.gob.mx/nomina12`

#### Cuándo se usa
- CFDI tipo "N" (Nómina)

#### Estructura de Datos

```php
nomina: {
    Version: "1.2",
    FechaPago: "2024-01-15",
    FechaInicialPago: "2024-01-01",
    FechaFinalPago: "2024-01-15",
    NumDiasPagados: 15,
    TipoNomina: "O",                         // O=Ordinaria, E=Extraordinaria
    TotalPercepciones: 10000.00,
    TotalDeducciones: 2000.00,
    TotalOtrosPagos: 500.00,
    
    Emisor: {
        RegistroPatronal: "B1234567890",    // No obligatorio para tipo 09, 10, 99
        Curp: ""                             // Solo persona física
    },
    
    Receptor: {
        Curp: "AAAA000101HDFXXX00",
        TipoContrato: "01",                  // Catálogo SAT
        TipoRegimen: "02",                   // Catálogo SAT
        NumEmpleado: "EMP001",
        PeriodicidadPago: "02",              // Catálogo SAT
        ClaveEntFed: "JAL",
        NumSeguridadSocial: "12345678901",
        FechaInicioRelLaboral: "2020-01-01",
        Antigüedad: "P208W",                 // Formato ISO 8601
        Puesto: "GERENTE",
        SalarioBaseCotApor: 500.00,
        SalarioDiarioIntegrado: 600.00,
        RiesgoPuesto: "1"                    // Catálogo SAT
    },
    
    Percepciones: {
        totalPercepcionGravado: 8000.00,
        totalPercepcionExcento: 2000.00,
        totalSueldos: 10000.00,
        totalSeparacionIndemnizacion: 0.00,
        totalJubilacionPension: 0.00,
        listadoPercepciones: [
            {
                TipoPercepcion: "001",       // Catálogo SAT
                Clave: "001",
                Concepto: "SUELDO",
                ImporteGravado: 8000.00,
                ImporteExento: 2000.00,
                // Para horas extra (TipoPercepcion = 019)
                Dias: 0,
                TipoHoras: "",
                HorasExtra: 0,
                ImportePagado: 0.00
            }
        ]
    },
    
    Deducciones: {
        totalDeduccion: 2000.00,
        totalImpuestosRetenidos: 1500.00,
        totalOtrasDeducciones: 500.00,
        listadoDeducciones: [
            {
                TipoDeduccion: "002",        // ISR
                Clave: "002",
                Concepto: "ISR",
                Importe: 1500.00
            }
        ]
    },
    
    OtrosPagos: {
        listadoOtrosPagos: [
            {
                TipoOtroPago: "002",         // Subsidio al empleo
                Clave: "002",
                Concepto: "SUBSIDIO AL EMPLEO",
                Importe: 500.00
            }
        ]
    },
    
    Incapacidades: {
        listadoIncapacidades: [
            {
                DiasIncapacidad: 3,
                TipoIncapacidad: "01",       // Catálogo SAT
                ImporteMonetario: 300.00
            }
        ]
    }
}
```

---

### 4. Comercio Exterior 2.0

Complemento para operaciones de comercio exterior.

#### Namespace
`http://www.sat.gob.mx/ComercioExterior20`

#### Versiones
- ComercioExterior 1.1 (hasta 07-mar-2024)
- ComercioExterior 2.0 (desde 08-mar-2024) **ACTUAL**

#### Cuándo se usa
- Exportación de mercancías
- Importación de mercancías

#### Estructura de Datos

```php
comercio: {
    datos: {
        Incoterm: "CFR",                     // Catálogo SAT
        clavePedimento: "A1",
        tipoOperacion: "2",                  // 2=Exportación definitiva
        rfcExtranjero: "XEXX010101000",
        totalUSD: 1000.00,
        motivoTraslado: "01",                // v2.0
        curp: ""                             // Emisor persona física
    },
    
    emisor: {
        calle: "Av. Principal",
        nroExterior: "123",
        nroInterior: "",
        colonia: "Centro",
        municipio: "Guadalajara",
        estado: "JAL",
        pais: "MEX",
        codigoPostal: "44100"
    },
    
    receptor: {
        calle: "Main Street",
        nroExterior: "456",
        nroInterior: "",
        colonia: "Downtown",
        municipio: "Los Angeles",
        estado: "California",
        pais: "USA",
        codigoPostal: "90001"
    }
}

mercanciasComercio: [
    {
        NoIdentificacion: "PROD001",
        FraccionArancelaria: "12345678",
        CantidadAduana: 100,
        UnidadAduana: "01",                  // Catálogo SAT
        ValorUnitarioAduana: 10.00,
        ValorDolares: 1000.00
    }
]
```

---

### 5. Impuestos Locales 1.0

Complemento para impuestos estatales o municipales.

#### Namespace
`http://www.sat.gob.mx/implocal`

#### Cuándo se usa
- Cuando se aplican impuestos locales (no federales)

#### Estructura de Datos

```php
impuestosRetenidosLcl: [
    {
        tipoImp: "ISH",                      // Nombre del impuesto
        tasaImp: 3.00,                       // Porcentaje
        montoImp: 30.00
    }
],

impuestosTrasladadosLcl: [
    {
        tipoImp: "CEDULAR",
        tasaImp: 2.00,
        montoImp: 20.00
    }
],

impuestosRetenidosLclTotal: 30.00,
impuestosTrasladadosLclTotal: 20.00
```

---

### 6. INE 1.1

Complemento para aportaciones a partidos políticos.

#### Namespace
`http://www.sat.gob.mx/ine`

#### Cuándo se usa
- Donaciones o aportaciones al INE o partidos políticos

#### Estructura de Datos

```php
ine: {
    tipoProceso: "Ordinario",                // Ordinario, Precampaña, Campaña
    version: "1.1",
    comite: "Ejecutivo Nacional",            // Solo si tipoProceso=Ordinario
    claveEntidad: "09",                      // CDMX
    ambito: "Federal",                       // Federal, Local
    idContabilidad: 123
}
```

---

### 7. Instituciones Educativas (IEDU)

Complemento para colegiaturas y pagos educativos.

#### Namespace
`http://www.sat.gob.mx/iedu`

#### Cuándo se usa
- Colegiaturas
- Servicios educativos

#### Estructura de Datos

```php
// Por concepto
concepto: {
    // ... datos del concepto
    alumno: {
        curp: "AAAA000101HDFXXX00",
        nombreAlumno: "ALUMNO NOMBRE APELLIDOS",
        nivelEducativo: "Preescolar",        // Catálogo SAT
        autRVOE: "RVOE123456",
        rfcPago: "XAXX010101000"             // RFC de quien paga (opcional)
    }
}
```

---

### 8. Leyendas Fiscales

Complemento para leyendas especiales requeridas por el SAT.

#### Namespace
`http://www.sat.gob.mx/leyendasFiscales`

#### Cuándo se usa
- Cuando se requiere incluir una leyenda fiscal específica

#### Estructura de Datos

```php
norma: "Art. 29-A fracción VII inciso a CFF",
leyenda: "Efectos fiscales al pago"
```

---

### 9. Addenda Fondo de Garantía

Addenda personalizada (no es complemento oficial SAT).

#### Namespace
`http://201.148.157.232:81/Content/FondoGarantia`

#### Estructura de Datos

```php
addenda: {
    Importe: 1000.00,
    PeriodoEnMeses: 12,
    Descripcion: "Descripción del fondo"
}
```

---

## Notas Importantes

### Versionamiento
- Los complementos tienen versiones específicas
- El sistema detecta automáticamente qué versión usar según la fecha
- CartaPorte: Cambia según timestamp de la factura
- ComercioExterior: Cambia según fecha actual del sistema

### Namespaces Dinámicos
El sistema registra namespaces dinámicamente solo si el complemento está presente:

```php
if(isset($dataFactura->cartaPorte) && $dataFactura->cartaPorte != null){
    $xml->namespace($cartaNS, $cfdiNS);
}
```

### Orden de Complementos en el XML
1. Impuestos Locales
2. Leyendas Fiscales
3. INE
4. Carta Porte
5. Nómina
6. Pagos
7. Comercio Exterior
8. TimbreFiscalDigital

### Validaciones Críticas

**Pagos 2.0**:
- Requiere CFDI tipo "P"
- Los impuestos deben calcularse desde los documentos relacionados
- MontoTotalPagos debe coincidir con suma de Monto de todos los pagos

**Carta Porte**:
- Obligatorio para CFDI tipo "T"
- IdCCP debe ser único y formatearse correctamente
- TotalDistanciaRecorrida = suma de distancias de ubicaciones

**Nómina**:
- Requiere CFDI tipo "N"
- Total factura debe ser TotalPercepciones - TotalDeducciones + TotalOtrosPagos
- Antigüedad debe calcularse en formato ISO 8601 (semanas)

**Comercio Exterior**:
- Si moneda es USD, debe incluirse TipoCambioUSD y TotalUSD
- Fracciones arancelarias deben validarse en catálogo

**INE**:
- Solo ciertos campos según TipoProceso y TipoComite
- IdContabilidad es opcional según configuración

### Catálogos SAT Relacionados
- c_ClaveProdServ (Carta Porte - BienesTransp)
- c_TipoPermiso (Carta Porte)
- c_ConfigAutotransporte (Carta Porte)
- c_SubTipoRem (Carta Porte)
- c_TipoFigura (Carta Porte)
- c_TipoNomina (Nómina)
- c_TipoContrato (Nómina)
- c_TipoRegimen (Nómina)
- c_Incoterm (Comercio Exterior)
- c_ClavePedimento (Comercio Exterior)
- c_TipoProceso (INE)
- c_Ambito (INE)
