# Modelos de Base de Datos

## Ubicación
`app/Models/` (104 modelos Eloquent)

## Modelos Principales

### Facturación Core

#### Factura
Tabla principal que almacena información general de la factura.

**Campos principales**:
- `id_factura` (PK)
- `id_proveedor` (FK) - Emisor
- `id_cliente` (FK) - Receptor
- `id_certificadoProveedor` (FK)
- `nmbEmisor` - Nombre del emisor
- `rFCEmisor` - RFC del emisor
- `nmbRecep` - Nombre del receptor
- `rFCRecep` - RFC del receptor
- `regimenFiscal` - Régimen fiscal del emisor
- `regimenFiscalReceptor` - **Nuevo en 4.0**
- `exportacion` - **Nuevo en 4.0**
- `domicilioFiscalReceptor` - **Nuevo en 4.0** (CP)
- `timeStamp` - Fecha/hora de emisión
- `noFactura` - Número de factura
- `version` - Versión CFDI (3.2, 3.3, 4.0)
- `tipoDeComprobante` - I, E, P, N, T
- `precission` - Decimales
- `status` - 1=Activa, 0=Cancelada
- `isPagado` - 0=No pagado, 1=Pagado
- `numRegIdTrib` - Registro fiscal extranjero
- `pais` - País de residencia fiscal
- `nota` - Comentarios internos
- `generadoPor` - 4=Web, otros valores para otros orígenes

**Relaciones**:
- `proveedor()` - BelongsTo Proveedor
- `cliente()` - BelongsTo Cliente
- `certificado()` - BelongsTo CertificadoProveedor
- `idDoc()` - HasOne IdDoc
- `totales()` - HasOne Totales
- `conceptos()` - HasMany Concepto
- `facturasRelacionadas()` - HasMany FacturasRelacionadas
- `comercio()` - HasOne ComercioE
- `cartaPorte()` - HasOne CartaPorte
- `ine()` - HasOne Ine
- `leyenda()` - HasOne LeyendaFiscal
- `addenda()` - HasOne AddendaFondoGarantia
- `informacionGlobal()` - HasOne InformacionGlobal

#### IdDoc
Información del documento fiscal (serie, folio, UUID, timbrado).

**Campos principales**:
- `id` (PK)
- `id_factura` (FK)
- `serie` - Serie del comprobante
- `folio` - Folio del comprobante
- `formaPago` - Código catálogo SAT
- `metodoDePago` - PUE, PPD
- `condicionesDePago` - Texto libre
- `lugarExpedicion` - Código postal
- `usoCFDI` - Uso del CFDI
- `sello` - Sello digital del emisor
- `fechaTimbrado` - Fecha del timbrado SAT
- `uUID` - Folio fiscal (UUID)
- `version` - Versión del timbre (1.1)
- `selloCFD` - Sello del CFDI
- `noCertificadoSAT` - Número de certificado del SAT
- `selloSAT` - Sello del SAT
- `rfcProvCertif` - RFC del PAC (FIN930514P87)
- `milisegundos` - Milisegundos del timbrado
- `tipoFacturasRelacionadas` - Tipo de relación

#### Totales
Totales monetarios de la factura.

**Campos principales**:
- `id` (PK)
- `id_factura` (FK)
- `moneda` - MXN, USD, EUR, XXX
- `tipoCambio` - Tipo de cambio
- `subTotal` - Subtotal
- `mntBase` - Monto base gravable
- `vlrPagar` - Total a pagar
- `descuento` - Descuento total
- `mntDcto` - Monto descuento
- `pctDcto` - Porcentaje descuento
- `mntImp` - Monto impuestos
- `pesoTotal` - Peso total (carta porte)

#### Concepto
Conceptos/productos/servicios de la factura.

**Campos principales**:
- `id_detalle` (PK)
- `id_factura` (FK)
- `clave` - ClaveProdServ SAT
- `cdgItem` - NoIdentificacion (código interno)
- `dscItem` - Descripción
- `unmdItem` - ClaveUnidad SAT
- `unmdItemDesc` - Descripción de la unidad (opcional)
- `qtyItem` - Cantidad
- `montoNetoItem` - Valor unitario
- `prcNetoItem` - Importe
- `descuento` - Descuento
- `objetoImp` - **Nuevo en 4.0** (01, 02, 03, 04)
- `peso` - Peso del producto
- `fracArancelaria` - Fracción arancelaria

**Relaciones**:
- `factura()` - BelongsTo Factura
- `impuestos()` - HasMany ExImpuestos
- `alumno()` - HasOne AlumnoDetalle
- `unidadc()` - BelongsTo UnidadMedida
- `clavec()` - BelongsTo ClaveProdServ

#### ExImpuestos
Impuestos por concepto y generales.

**Campos principales**:
- `id` (PK)
- `id_detalle` (FK) - Si es impuesto de concepto
- `id_factura` (FK) - Si es impuesto local
- `base` - Base gravable
- `tipoImp` - 001=ISR, 002=IVA, 003=IEPS
- `factor` - Tasa, Cuota, Exento
- `tasaImp` - Tasa o cuota (6 decimales)
- `montoImp` - Importe del impuesto
- `tipo` - 0=Retenido, 1=Trasladado

#### FacturasRelacionadas
UUIDs de facturas relacionadas.

**Campos principales**:
- `id` (PK)
- `id_factura` (FK)
- `uuid` - UUID de la factura relacionada
- `tipoRelacion` - Tipo de relación (catálogo SAT)

### Catálogos y Maestros

#### Proveedor (Emisor)
Información del emisor de facturas.

**Campos principales**:
- `id_proveedor` (PK)
- `nmbEmisor` - Nombre o razón social
- `rFCEmisor` - RFC
- `regimenFiscal32` - Régimen fiscal 3.2
- `regimenFiscal33` - Régimen fiscal 3.3/4.0
- `tipoPersona` - 1=Moral, 2=Física
- `keypem` - Ruta al archivo .pem de la llave
- `status` - 1=Activo

**Relaciones**:
- `domicilio()` - HasOne DomFiscal
- `certificados()` - HasMany CertificadoProveedor

#### Cliente (Receptor)
Información del receptor de facturas.

**Campos principales**:
- `id_cliente` (PK)
- `nmbRecep` - Nombre o razón social
- `rFCRecep` - RFC
- `tipoPersona` - 1=Moral, 2=Física
- `regimenFiscalReceptor` - Régimen fiscal
- `metodoPago` - Método de pago preferido
- `status` - 1=Activo

**Relaciones**:
- `domicilio()` - HasOne DomFiscalRcp

#### CertificadoProveedor
Certificados CSD de los proveedores.

**Campos principales**:
- `id` (PK)
- `id_proveedor` (FK)
- `noCertificado` - Número de certificado
- `certificado` - Certificado en base64
- `fechaInicio` - Vigencia desde
- `fechaFin` - Vigencia hasta
- `status` - 1=Activo

#### Producto
Catálogo de productos/servicios.

**Campos principales**:
- `id_producto` (PK)
- `id_proveedor` (FK)
- `clave` - ClaveProdServ SAT
- `nombre` - Descripción
- `codigo` - Código interno
- `unidad` - ClaveUnidad
- `precioU` - Precio unitario
- `objetoImp` - Objeto de impuesto (4.0)
- `status` - 1=Activo

### Complementos

#### ComercioE
Complemento de Comercio Exterior.

**Campos principales**:
- `id_factura` (PK/FK)
- `Incoterm` - Término de comercio
- `clavePedimento` - Clave de pedimento
- `tipoOperacion` - 1=Exportación, 2=Importación
- `rfcExtranjero` - RFC del extranjero
- `motivoTraslado` - Motivo del traslado
- `curp` - CURP del emisor
- `totalUSD` - Total en USD

**Tablas relacionadas**:
- `DomFiscalFact` - Domicilio del emisor
- `DomFiscalRcpFact` - Domicilio del receptor
- `MercanciaComercio` - Mercancías

#### CartaPorte
Complemento de Carta Porte.

**Campos principales**:
- `id` (PK)
- `id_factura` (FK)
- `transpInternac` - Sí/No
- `entradaSalidaMerc` - Entrada o salida
- `paisOrigenDestino` - País
- `viaEntradaSalida` - 01=Autotransporte, etc.
- `pesoBrutoTotal` - Peso bruto total
- `unidadPeso` - Unidad de peso
- `idccp` - ID del complemento Carta Porte

**Tablas relacionadas**:
- `Ubicacion` - Ubicaciones de origen/destino
- `Mercancia` - Mercancías transportadas
- `Autotransporte` - Datos del autotransporte
- `Remolque` - Remolques
- `FigurasTransporte` - Operador, propietario, etc.

#### Pago
Complemento de Pagos 2.0.

**Campos principales**:
- `id` (PK)
- `id_factura` (FK)
- `FechaPago` - Fecha del pago
- `FormaDePagoP` - Forma de pago
- `MonedaP` - Moneda del pago
- `Monto` - Monto pagado
- `TipoCambioP` - Tipo de cambio
- `banco` - RFC del banco
- `cuenta` - Cuenta ordenante
- `rfcEmisorCtaBen` - Banco beneficiario
- `ctaBeneficiario` - Cuenta beneficiario
- `noOperacion` - Número de operación

**Tablas relacionadas**:
- `DoctoRelacionado` - Documentos relacionados al pago
- `ImpuestosDR` - Impuestos por documento relacionado
- `TotalesP` - Totales del complemento pago

#### EmpleadoFac
Datos del empleado para nómina.

**Campos principales**:
- `id` (PK)
- `id_factura` (FK)
- `id_empleado` (FK)
- `id_periodoNomina` (FK)
- `curp` - CURP del empleado
- `nss` - Número de seguro social
- `tipoContrato` - Tipo de contrato
- `periodicidadPago` - Periodicidad
- `salarioBase` - Salario base
- `salarioDiarioIntegrado` - SDI
- `noDiasPagados` - Días pagados
- `registroPatronal` - Registro patronal

**Tablas relacionadas**:
- `PercepcionDeduccionFac` - Percepciones y deducciones
- `LiquidacionFac` - Datos de liquidación
- `PeriodoNomina` - Periodo de pago

#### Ine
Complemento INE.

**Campos principales**:
- `id` (PK)
- `id_factura` (FK)
- `tipoProceso` - Ordinario, Precampaña, etc.
- `version` - 1.1
- `comite` - Tipo de comité
- `ambito` - Federal, Local, etc.
- `claveEntidad` - Clave de la entidad
- `idContabilidad` - ID de contabilidad

#### LeyendaFiscal
Leyendas fiscales.

**Campos principales**:
- `id` (PK)
- `id_factura` (FK)
- `norma` - Norma aplicable
- `leyenda` - Texto de la leyenda

#### InformacionGlobal
Información global (público en general).

**Campos principales**:
- `id` (PK)
- `id_factura` (FK)
- `periodicidad` - 01, 02, etc.
- `meses` - 01, 02, etc.
- `anio` - Año

#### AlumnoDetalle
Complemento de Instituciones Educativas.

**Campos principales**:
- `id` (PK)
- `id_detalle` (FK)
- `curp` - CURP del alumno
- `nombreAlumno` - Nombre del alumno
- `nivelEducativo` - Nivel educativo
- `autRVOE` - Autorización RVOE
- `rfcPago` - RFC de quien paga

#### AddendaFondoGarantia
Addenda personalizada.

**Campos principales**:
- `id` (PK)
- `id_factura` (FK)
- `Importe` - Importe
- `PeriodoEnMeses` - Periodo en meses
- `Descripcion` - Descripción

### Catálogos SAT

#### ClaveProdServ
Catálogo de productos y servicios del SAT.

**Campos**: `id`, `codigo`, `descripcion`, `incluirIVA`, `incluirIEPS`, `complemento`, `fraccionArancelaria`

#### UnidadMedida
Catálogo de unidades de medida del SAT.

**Campos**: `id`, `codigo`, `descripcion`, `nota`

#### FormaPago
Catálogo de formas de pago.

**Campos**: `id`, `codigo`, `descripcion`

#### UsoCFDI
Catálogo de usos del CFDI.

**Campos**: `id`, `codigo`, `descripcion`, `regimenFiscal`, `tipoPersona`

#### CatalogoRegimenFiscal
Regímenes fiscales del SAT.

**Campos**: `id`, `clave`, `descripcion`, `fisica`, `moral`

#### CatalogoExportacion
Claves de exportación (4.0).

**Campos**: `id`, `codigo`, `descripcion`

#### CatalogoObjImpuesto
Objeto de impuesto (4.0).

**Campos**: `id`, `codigo`, `descripcion`

#### FraccionArancelaria
Fracciones arancelarias.

**Campos**: `codigo`, `descripcion`, `unidad`

### Otros Modelos Importantes

#### Estado
Estados de México y otros países.

**Campos**: `id`, `codigo`, `descripcion`, `pais`

#### Municipio
Municipios de México.

**Campos**: `id`, `Estado`, `codigo`, `descripcion`

#### Pais
Catálogo de países.

**Campos**: `id`, `codigo`, `descripcion`

#### CatalogoBancos
Bancos de México.

**Campos**: `id`, `codigo`, `nombre`

## Relaciones Importantes

### Factura Principal
```
Factura (1) ←→ (1) IdDoc
Factura (1) ←→ (1) Totales
Factura (1) ←→ (n) Concepto
Factura (1) ←→ (n) FacturasRelacionadas
Factura (n) ←→ (1) Proveedor
Factura (n) ←→ (1) Cliente
Factura (n) ←→ (1) CertificadoProveedor
```

### Conceptos e Impuestos
```
Concepto (1) ←→ (n) ExImpuestos
Concepto (1) ←→ (1) AlumnoDetalle
```

### Complementos
```
Factura (1) ←→ (1) ComercioE
Factura (1) ←→ (1) CartaPorte
Factura (1) ←→ (n) Pago
Factura (1) ←→ (1) EmpleadoFac
Factura (1) ←→ (1) Ine
Factura (1) ←→ (1) LeyendaFiscal
Factura (1) ←→ (1) InformacionGlobal
Factura (1) ←→ (1) AddendaFondoGarantia
```

### Carta Porte
```
CartaPorte (1) ←→ (n) Ubicacion
CartaPorte (1) ←→ (n) Mercancia
CartaPorte (1) ←→ (1) Autotransporte
CartaPorte (1) ←→ (n) Remolque
CartaPorte (1) ←→ (n) FigurasTransporte
```

### Pagos
```
Pago (1) ←→ (n) DoctoRelacionado
DoctoRelacionado (1) ←→ (n) ImpuestosDR
Factura (1) ←→ (1) TotalesP
```

### Nómina
```
EmpleadoFac (n) ←→ (1) Empleado
EmpleadoFac (n) ←→ (1) PeriodoNomina
EmpleadoFac (1) ←→ (n) PercepcionDeduccionFac
EmpleadoFac (1) ←→ (1) LiquidacionFac
```

## Convenciones de Nomenclatura

- **Tablas**: PascalCase (Factura, IdDoc, ExImpuestos)
- **Campos**: camelCase (id_factura, rFCEmisor, nmbRecep)
- **Primary Keys**: Generalmente `id` o `id_nombreTabla`
- **Foreign Keys**: `id_nombreTablaRelacionada`
- **Status**: 1=Activo, 0=Inactivo

## Índices Recomendados

- `Factura`: id_proveedor, id_cliente, noFactura, status
- `IdDoc`: id_factura, serie, folio, uUID
- `Concepto`: id_factura
- `ExImpuestos`: id_detalle, id_factura
- `Cliente`: rFCRecep
- `Proveedor`: rFCEmisor
