<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;

use App\Models\Abogados;
use App\Models\Cliente;
use App\Models\Juicio;
use App\Models\Juzgado;
use App\Models\Escrito;
use App\Models\Asesoria;

class Tarea extends Model {
	
	protected $table = 'Tarea';

	public $timestamps = false;

	protected $primaryKey = 'id_tarea';

	public function abogado() {
		return $this->hasOne('App\Models\Abogados', 'id_abogado', 'id_abogado');
	}

	public function abogadoGenera() {
		return $this->hasOne('App\Models\Abogados', 'id_abogado', 'id_abogadoGenera');
	}

	public function abogadoConfirma() {
		return $this->hasOne('App\Models\Abogados', 'id_abogado', 'id_abogadoConfirmacion');
	}

	public function cliente() {
		return $this->hasOne('App\Models\Cliente', 'id_cliente', 'id_cliente');
	}

	public function juicio() {
		return $this->hasOne('App\Models\Juicio', 'id_juicio', 'id_juicio');
	}

	public function juzgado() {
		return $this->hasOne('App\Models\Juzgado', 'id_juzgado', 'id_juzgado');
	}

	public function escrito() {
		return $this->hasOne('App\Models\Escrito', 'id_tarea', 'id_tarea')->where('status', '=', 1);
	}

	public function asesoria() {
		return $this->hasOne('App\Models\Asesoria', 'id_asesoria', 'id_asesoria');
	}

}
?>