<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class Factura extends Model {

	protected $table = 'Factura';

	public $timestamps = false;

	protected $primaryKey = 'id_factura';

	public function iddoc(){
		return $this->hasOne('App\Models\IdDoc', 'id_factura', 'id_factura');
	}

	public function totales(){
		return $this->hasOne('App\Models\Totales', 'id_factura', 'id_factura');
	}

	public function pagos(){
		return $this->hasMany('App\Models\Pago', 'id_factura', 'id_factura');
	}

	public function facturasRelacionadas(){
	    return $this->hasMany('App\Models\FacturasRelacionadas', 'id_factura', 'id_factura');
	}

	public function comercio(){
		return $this->hasOne('App\Models\ComercioE', 'id_factura', 'id_factura');
	}

    public function mercanciasComercio(){
        return $this->hasMany('App\Models\MercanciaComercio', 'id_factura', 'id_factura');
    }

    public function totalesp(){
        return $this->hasOne('App\Models\TotalesP', 'id_factura', 'id_factura');
    }

}
?>
