<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class EmpleadoFac extends Model {

	protected $table = 'EmpleadoFac';

	public $timestamps = false;

	protected $primaryKey = 'id_empleadoFac';

	public function empleado(){
		return $this->hasOne('App\Models\Empleado', 'id_empleado', 'id_empleado');
	}

	public function percepciones(){
		return $this->hasMany('App\Models\PercepcionDeduccionFac', 'id_empleadoFac', 'id_empleadoFac')->where('status', '=', 1)->where('tipo', '=', 1);
	}

	public function deducciones(){
		return $this->hasMany('App\Models\PercepcionDeduccionFac', 'id_empleadoFac', 'id_empleadoFac')->where('status', '=', 1)->where('tipo', '=', 2);
	}

	public function cliente(){
		return $this->hasOne('App\Models\Cliente', 'id_cliente', 'id_cliente');
	}

    public function liquidacion(){
        return $this->hasOne('App\Models\LiquidacionFac', 'id_empleadoFac', 'id_empleadoFac');
    }
}
?>
