<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class DoctoRelacionado extends Model {

	protected $table = 'DoctoRelacionado';

	public $timestamps = false;

	protected $primaryKey = 'id';

	public function pago(){
	    return $this->hasOne('App\Models\Pago', 'id', 'id_pago');
	}

    public function traslados() {
        return $this->hasMany('App\Models\ImpuestosDR', 'id_doctoRelacionado', 'id')->where('tipo', '=', 1);
    }
    public function retenciones() {
        return $this->hasMany('App\Models\ImpuestosDR', 'id_doctoRelacionado', 'id')->where('tipo', '=', 0);
    }

}
?>
