<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class Bill extends Model {

	protected $table = 'Bills';

	public $timestamps = false;

	protected $primaryKey = 'id';
	
	public function employee(){
		return $this->hasOne('App\Models\Employee', 'id', 'id_employee');
	}
	
	public function customer(){
		return $this->hasOne('App\Models\Customer', 'id', 'id_customer');
	}
	
	public function quotation(){
		return $this->hasOne('App\Models\Quotation', 'id', 'id_quotation');
	}
	
	public function payments() {
		return $this->hasMany('App\Models\Payment', 'id_bill', 'id');
	}
	

}
?>