<?php

namespace App\Http\Controllers;

use App\Commands\AES;
use App\Models\Addenda;
use App\Models\Autotransporte;
use App\Models\AutotransporteBase;
use App\Models\CatalogoConfigTransporte;
use App\Models\CatalogoEstado;
use App\Models\CatalogoMunicipio;
use App\Models\CatalogoSubTipoRem;
use App\Models\CatalogoTipoPermiso;
use App\Models\Cliente;
use App\Models\DomFiscalRcp;
use App\Models\Inbursa;
use App\Models\FigurasTransporte;
use App\Models\FigurasTransporteBase;
use App\Models\ImpuestosDR;
use App\Models\LicenciaCarta;
use App\Models\LicenciaEscuelas;
use App\Models\LicenciaINE;
use App\Models\LicenciaInbursa;
use App\Models\Mercancia;
use App\Models\MercanciaComercio;
use App\Models\Product;
use App\Models\Remolque;
use App\Models\TotalesP;
use App\Models\Ubicacion;
use App\Models\UbicacionBase;
use chillerlan\QRCode\QRCode;
use FluidXml\FluidNamespace;
use FluidXml\FluidXml;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Response;
use SoapClient;

use App\Commands\XMLUtils;
use App\Models\Concepto;
use App\Models\ExImpuestos;
use App\Models\Factura;
use App\Models\FormaPago;
use App\Models\Producto;
use App\Models\UnidadMedida;
use App\Models\UnidadMedidaProveedor;
use App\Models\ClaveProdServProveedor;
use App\Models\Proveedor;
use Illuminate\Support\Facades\DB;
use App\Models\UsoCFDI;
use App\Models\Pais;
use App\Models\Serie;
use App\Commands\Utils;
use App\Models\CertificadoProveedor;
use App\Models\IdDoc;
use App\Models\Totales;
use App\Models\FacturasRelacionadas;
use App\Models\CatalogoRegimenFiscal;
use App\Commands\NumeroLetra;
use App\Models\ContactoReceptor;
use Illuminate\Support\Facades\Mail;
use App\Models\DoctoRelacionado;
use App\Models\Pago;
use App\Models\Arrendamiento;
use PHPExcel_IOFactory;
use PHPExcel;
use App\Models\PaqueteAsignado;
use App\Models\Incoterm;
use App\Models\Estado;
use App\Models\Municipio;
use App\Models\ComercioE;
use App\Models\DomFiscalFact;
use App\Models\DomFiscalRcpFact;
use Dompdf\Dompdf;
use App\Models\Bancop;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;


class FacturacionController extends BaseController
{


    public function listadoFacturas(Request $request)
    {

        $user = $request->input('user');
        $filtro = $request->input('filtro');
        $fechaInicial = $filtro['initialS'] . ' 00:00:00';
        $fechaFinal = $filtro['endS'] . ' 23:59:59';
        $rfc = $filtro['rfc'];
        $estatusDocumento = $filtro['estatusDocumento'];
        $id_proveedorPrincipal = $request->input('id_proveedorPrincipal');

        $query = "SELECT d.folio, d.serie, f.rFCRecep, f.nmbRecep, f.timeStamp, f.id_factura, f.noFactura, "
            . "f.tipoDeComprobante, f.isPagado, f.version, t.VlrPagar, f.id_cliente, d.uUID, f.generadoPor "
            . "FROM Factura f "
            . "JOIN IdDoc d ON f.id_factura = d.id_factura "
            . "JOIN Totales t ON f.id_factura = t.id_factura "
            . "WHERE f.id_proveedor = " . $user['id_proveedor'] . " "
            . "AND f.status = '$estatusDocumento' "
            . "AND f.timeStamp BETWEEN '$fechaInicial' AND '$fechaFinal' ";

        if ($filtro['tipoDocumento'] != '')
            $query .= "AND tipoDeComprobante = '" . $filtro['tipoDocumento'] . "'";

        $facturas = DB::select($query);


        if (is_object($facturas)) {

            foreach ($facturas as $factura) {
                $sumaPago = 0;

                $pagosObj = Pago::with('factura')->where('id_factura')->get();

                if (count($pagosObj) > 0)
                    foreach ($pagosObj as $pago) {
                        if ($pago->factura->status == 1)
                            $sumaPago += $pago->Monto;
                    }

                $factura->sumaPago = $sumaPago;
            }
        }

        $noFacturasContratadas = PaqueteAsignado::where('id_proveedor', '=', $id_proveedorPrincipal)->where('status', '=', 1)->where('tipo', '=', 1)->sum('noFolios');

        $proveedoresRelacionados = DB::select("SELECT p.id_proveedor, p.rFCEmisor FROM Proveedor p
				JOIN `Multiusuario` m ON p.id_proveedor = m.`id_proveedorRel` AND m.status = 1 WHERE m.id_proveedor = " . $id_proveedorPrincipal . " ORDER BY p.rFCEmisor");

        $idProveedores = [];
        $idProveedores[] = $id_proveedorPrincipal;
        if (count($proveedoresRelacionados) > 0) {
            foreach ($proveedoresRelacionados as $proveedoreRelacionado) {
                $idProveedores[] = $proveedoreRelacionado->id_proveedor;
            }
        }

        $noFacturasUsadas = Factura::whereIn('id_proveedor', $idProveedores)->count();
        $puedeFacturar = (($noFacturasContratadas - $noFacturasUsadas) <= 0) ? false : true;


        return Response::json(array(
            'success' => true,
            'facturas' => $facturas,
            'proveedoresRelacionados' => $proveedoresRelacionados,
            'noFacturasContratadas' => $noFacturasContratadas,
            'noFacturasUsadas' => $noFacturasUsadas,
            'puedeFacturar' => $puedeFacturar
        ));

    }

    public function test()
    {

        $proveedor = Proveedor::with('domicilio')->find ( 2 );
        $result = Utils::getIDCCP($proveedor);
        echo $result->get_idccpResult->idccp;

        /*
        DB::beginTransaction();

        $xml = '';

        $xmlTimbrado = new \DOMDocument ( "1.0", "uft-8" );
        $xmlTimbrado->loadXML ( $xml );

        $idDoc = new IdDoc ();

        $timbreFiscal = $xmlTimbrado->getElementsByTagName ( 'TimbreFiscalDigital' );
        $sello = $xmlTimbrado->getElementsByTagName ( 'Comprobante' ) [0]->getAttribute ( 'Sello' );

        foreach ( $timbreFiscal as $timbreFiscal ) {

            $idDoc->version = $timbreFiscal->getAttribute ( 'Version' );
            $idDoc->fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );
            $idDoc->selloCFD = $timbreFiscal->getAttribute ( 'SelloCFD' );
            $idDoc->noCertificadoSAT = $timbreFiscal->getAttribute ( 'NoCertificadoSAT' );
            $idDoc->selloSAT = $timbreFiscal->getAttribute ( 'SelloSAT' );
            $idDoc->uUID = $timbreFiscal->getAttribute ( 'UUID' );
            $idDoc->sello = $sello;
            $idDoc->rfcProvCertif = $timbreFiscal->getAttribute ( 'RfcProvCertif' );

        }

        $emisor = $xmlTimbrado->getElementsByTagName ( 'Emisor' )[0];
        $receptor = $xmlTimbrado->getElementsByTagName ( 'Receptor' )[0];
        $comprobante = $xmlTimbrado->getElementsByTagName ( 'Comprobante' )[0];


        $proveedorObj = Proveedor::where('rFCEmisor', '=', $emisor->getAttribute ( 'Rfc' ))->first();
        $certificadoHaUsar = CertificadoProveedor::where('id_proveedor', '=', $proveedorObj->id_proveedor)->where('status', '=', 1)->first();

        $facturaObj = new Factura ();
        $facturaObj->id_proveedor = $proveedorObj->id_proveedor;
        $facturaObj->id_cliente = 0;
        $facturaObj->id_certificadoProveedor = $certificadoHaUsar->id;
        $facturaObj->nmbEmisor = $emisor->getAttribute ( 'Nombre' );
        $facturaObj->rFCEmisor = $emisor->getAttribute ( 'Rfc' );
        $facturaObj->nmbRecep = $receptor->getAttribute ( 'Nombre' );
        $facturaObj->rFCRecep = $receptor->getAttribute ( 'Rfc' );
        $facturaObj->regimenFiscal = $emisor->getAttribute ( 'RegimenFiscal' );
        $facturaObj->timeStamp = $comprobante->getAttribute ( 'Fecha' );
        $facturaObj->noFactura = $comprobante->getAttribute ( 'Folio' );
        $facturaObj->version = "4.0";
        $facturaObj->generadoPor = 4;
        $facturaObj->nota = '';
        $facturaObj->tipoDeComprobante = $comprobante->getAttribute ( 'TipoDeComprobante' );
        $facturaObj->precission =2;
        $facturaObj->status = 1;
        $facturaObj->regimenFiscalReceptor = $receptor->getAttribute ( 'RegimenFiscalReceptor' );
        $facturaObj->exportacion = $comprobante->getAttribute ( 'Exportacion' );
        $facturaObj->domicilioFiscalReceptor = $receptor->getAttribute ( 'DomicilioFiscalReceptor' );
        $facturaObj->save ();

        $idDoc->id_factura = $facturaObj->id_factura;
        $idDoc->serie = $comprobante->getAttribute ( 'Serie' );
        $idDoc->folio = $comprobante->getAttribute ( 'Folio' );
        $idDoc->formaPago = '';
        $idDoc->condicionesDePago = '';
        $idDoc->lugarExpedicion = $comprobante->getAttribute ( 'LugarExpedicion' );
        $idDoc->usoCFDI = 'CP01';
        $idDoc->metodoDePago = '';
        $idDoc->sello = $sello;
        $idDoc->tipoFacturasRelacionadas = '';
        $idDoc->save ();

        $totales = new Totales ();
        $totales->id_factura = $facturaObj->id_factura;
        $totales->moneda = 'XXX';
        $totales->tipoCambio = 0;
        $totales->subTotal = 0;
        $totales->mntBase = 0;
        $totales->vlrPagar = 0;
        $totales->descuento = 0;
        $totales->save ();

        $conceptos = $xmlTimbrado->getElementsByTagName ( 'Conceptos' )[0];

        $concepto = $conceptos->getElementsByTagName ( 'Concepto' )[0];

        $conceptoObj = new Concepto ();
        $conceptoObj->clave = $concepto->getAttribute ( 'ClaveProdServ' );
        $conceptoObj->cdgItem = $concepto->getAttribute ( 'NoIdentificacion' );
        $conceptoObj->dscItem = $concepto->getAttribute ( 'Descripcion' );
        $conceptoObj->unmdItem = $concepto->getAttribute ( 'ClaveUnidad' );
        $conceptoObj->qtyItem = $concepto->getAttribute ( 'Cantidad' );
        $conceptoObj->montoNetoItem = $concepto->getAttribute ( 'ValorUnitario' );
        $conceptoObj->prcNetoItem = $concepto->getAttribute ( 'Importe' );
        $conceptoObj->descuento = 0;
        $conceptoObj->objetoImp = $concepto->getAttribute ( 'ObjetoImp' );
        $conceptoObj->id_factura = $facturaObj->id_factura;
        $conceptoObj->save ();

        $totales = $xmlTimbrado->getElementsByTagName ( 'Totales' )[0];


        $totalesPObj = new TotalesP();
        $totalesPObj->id_factura = 585308;
        $totalesPObj->totalRetencionesIVA = $totales->getAttribute ( 'TotalRetencionesIVA' ) > 0 ? $totales->getAttribute ( 'TotalRetencionesIVA' ) : 0;
        $totalesPObj->totalRetencionesISR = $totales->getAttribute ( 'TotalRetencionesISR' ) > 0 ? $totales->getAttribute ( 'TotalRetencionesISR' ) : 0;
        $totalesPObj->totalRetencionesIEPS = $totales->getAttribute ( 'TotalRetencionesIEPS' )  > 0 ? $totales->getAttribute ( 'TotalRetencionesIEPS' ) : 0;
        $totalesPObj->totalTrasladosBaseIVA16 = $totales->getAttribute ( 'TotalTrasladosBaseIVA16' )  > 0 ? $totales->getAttribute ( 'TotalTrasladosBaseIVA16' ) : 0;
        $totalesPObj->totalTrasladosImpuestoIVA16 = $totales->getAttribute ( 'TotalTrasladosImpuestoIVA16' )  > 0 ? $totales->getAttribute ( 'TotalTrasladosImpuestoIVA16' ) : 0;
        $totalesPObj->totalTrasladosBaseIVA8 = $totales->getAttribute ( 'TotalTrasladosBaseIVA8' )  > 0 ? $totales->getAttribute ( 'TotalTrasladosBaseIVA8' ) : 0;
        $totalesPObj->totalTrasladosImpuestoIVA8 = $totales->getAttribute ( 'TotalTrasladosImpuestoIVA8' )  > 0 ? $totales->getAttribute ( 'TotalTrasladosImpuestoIVA8' ) : 0;
        $totalesPObj->totalTrasladosBaseIVA0 = $totales->getAttribute ( 'TotalTrasladosBaseIVA0' )  > 0 ? $totales->getAttribute ( 'TotalTrasladosBaseIVA0' ) : 0;
        $totalesPObj->totalTrasladosImpuestoIVA0 = $totales->getAttribute ( 'TotalTrasladosImpuestoIVA0' )  > 0 ? $totales->getAttribute ( 'TotalTrasladosImpuestoIVA0' ) : 0;
        $totalesPObj->totalTrasladosBaseIVAExento = 0;
        $totalesPObj->montoTotalPagos = $totales->getAttribute ( 'MontoTotalPagos' )  > 0 ? $totales->getAttribute ( 'MontoTotalPagos' ) : 0;
        $totalesPObj->save();

        $pagos = $xmlTimbrado->getElementsByTagName ( 'Pago' );

        foreach ( $pagos as $pago ) {

            $fechaPago = str_replace ('T', ' ', $pago->getAttribute ( 'FechaPago' ));
            $fechaPago = substr($fechaPago, 0, 19);

            $pagoObj = new Pago ();
            $pagoObj->FechaPago = $fechaPago;
            $pagoObj->FormaDePagoP = $pago->getAttribute ( 'FormaDePagoP' );
            $pagoObj->MonedaP = $pago->getAttribute ( 'MonedaP' );
            $pagoObj->TipoCambioP = $pago->getAttribute ( 'TipoCambioP' );
            $pagoObj->Monto = $pago->getAttribute ( 'Monto' );
            $pagoObj->banco = $pago->getAttribute ( 'RfcEmisorCtaOrd' );
            $pagoObj->cuenta = $pago->getAttribute ( 'CtaOrdenante' );
            $pagoObj->rfcEmisorCtaBen = $pago->getAttribute ( 'RfcEmisorCtaBen' );
            $pagoObj->ctaBeneficiario = $pago->getAttribute ( 'CtaBeneficiario' );
            $pagoObj->noOperacion = $pago->getAttribute ( 'NumOperacion' );
            $pagoObj->id_factura = $facturaObj->id_factura;
            $pagoObj->save ();

            $documentoRelacionados = $pago->getElementsByTagName('DoctoRelacionado');

            foreach ( $documentoRelacionados as $doctoRelacionado ) {

                $doctoRelacionadoObj = new DoctoRelacionado ();
                $doctoRelacionadoObj->IdDocumento = $doctoRelacionado->getAttribute ( 'IdDocumento' );
                $doctoRelacionadoObj->MonedaDR = $doctoRelacionado->getAttribute ( 'MonedaDR' );
                $doctoRelacionadoObj->TipoCambioDR = $doctoRelacionado->getAttribute ( 'TipoCambioDR' )   > 0 ? $doctoRelacionado->getAttribute ( 'TipoCambioDR' ) : 0;
                $doctoRelacionadoObj->MetodoDePagoDR = empty($doctoRelacionado->getAttribute ( 'MetodoDePagoDR' )) ? '' : $doctoRelacionado->getAttribute ( 'MetodoDePagoDR' );
                $doctoRelacionadoObj->NumParcialidad = empty($doctoRelacionado->getAttribute ( 'NumParcialidad' )) ? '' : $doctoRelacionado->getAttribute ( 'NumParcialidad' );
                $doctoRelacionadoObj->ImpSaldoAnt = empty($doctoRelacionado->getAttribute ( 'ImpSaldoAnt' )) ? '' : $doctoRelacionado->getAttribute ( 'ImpSaldoAnt' );
                $doctoRelacionadoObj->ImpPagado = empty($doctoRelacionado->getAttribute ( 'ImpPagado' )) ? 0 : $doctoRelacionado->getAttribute ( 'ImpPagado' );
                $doctoRelacionadoObj->ImpSaldoInsoluto = empty($doctoRelacionado->getAttribute ( 'ImpSaldoInsoluto' )) ? 0 : $doctoRelacionado->getAttribute ( 'ImpSaldoInsoluto' );
                $doctoRelacionadoObj->ObjetoImpDR = empty($doctoRelacionado->getAttribute ( 'ObjetoImpDR' )) ? '' : $doctoRelacionado->getAttribute ( 'ObjetoImpDR' );
                $doctoRelacionadoObj->MontoPagoMoneda = empty($doctoRelacionado->getAttribute ( 'ImpPagado' )) ? 0 : $doctoRelacionado->getAttribute ( 'ImpPagado' );
                $doctoRelacionadoObj->id_pago = 20990;
                $doctoRelacionadoObj->save ();

                if ($doctoRelacionadoObj->ImpSaldoInsoluto <= 0) {

                    $idDocObj = IdDoc::where ( 'uUID', '=', $doctoRelacionado->IdDocumento )->with ( 'factura' )->first ();
                    $facturaIdDoc = $idDocObj->factura;
                    $facturaIdDoc->isPagado = 1;
                    $facturaIdDoc->save ();
                }

                $impuestosDR = $doctoRelacionado->getElementsByTagName('ImpuestosDR');

                if($impuestosDR != null){

                    $retencionesDR = $impuestosDR[0]->getElementsByTagName('RetencionesDR');

                    if($retencionesDR != null && count($retencionesDR) > 0){

                        $RetencionDR = $retencionesDR[0]->getElementsByTagName('RetencionDR');

                        foreach ($RetencionDR as $impuesto){
                            $impuestoDrObj = new ImpuestosDR();
                            $impuestoDrObj->id_doctoRelacionado = $doctoRelacionadoObj->id;
                            $impuestoDrObj->tipo = 0;
                            $impuestoDrObj->base = $impuesto->getAttribute('BaseDR');
                            $impuestoDrObj->importe = $impuesto->getAttribute('ImporteDR');
                            $impuestoDrObj->impuesto = $impuesto->getAttribute('ImpuestoDR');
                            $impuestoDrObj->tasaCuota = $impuesto->getAttribute('TasaOCuotaDR');
                            $impuestoDrObj->tipoFactor = $impuesto->getAttribute('TipoFactorDR');
                            $impuestoDrObj->save();
                        }

                    }

                    $trasladosDR = $impuestosDR[0]->getElementsByTagName('TrasladosDR');

                    if($trasladosDR != null && count($trasladosDR) > 0){

                        $TrasladoDR = $trasladosDR[0]->getElementsByTagName('TrasladoDR');

                        foreach ($TrasladoDR as $impuesto){

                            $impuestoDrObj = new ImpuestosDR();
                            $impuestoDrObj->id_doctoRelacionado = $doctoRelacionadoObj->id;
                            $impuestoDrObj->tipo = 1;
                            $impuestoDrObj->base = $impuesto->getAttribute('BaseDR');
                            $impuestoDrObj->importe = $impuesto->getAttribute('ImporteDR');
                            $impuestoDrObj->impuesto = $impuesto->getAttribute('ImpuestoDR');
                            $impuestoDrObj->tasaCuota = $impuesto->getAttribute('TasaOCuotaDR');
                            $impuestoDrObj->tipoFactor = $impuesto->getAttribute('TipoFactorDR');
                            $impuestoDrObj->save();

                        }
                    }

                }

            }
        }

        DB::commit();


        */

    }


    public function getXML(Request $request)
    {

        $user = $request->input('user');
        $id_factura = $request->input('id_factura');
        $id_proveedor = $user['id_proveedor'];

        $query = "
		SELECT
		f.id_factura AS id_factura,
		f.nmbEmisor AS nmbEmisor,
		f.rFCEmisor AS rFCEmisor,
		f.nmbRecep AS nmbRecep,
		f.rFCRecep AS rFCRecep,
		f.regimenFiscal AS regimenFiscal,
		f.timeStamp AS timeStamp,
		f.noFactura AS noFactura,
		f.comentario AS comentario,
		f.version AS version,
		f.tipo AS tipo,
		f.precission AS precission,
		f.nota AS nota,
		f.domicilio AS domicilio,

		idoc.anoAprob AS anoAprob,
		idoc.nroAprob AS nroAprob,
		idoc.serie AS serie,
		idoc.folio AS folio,
		idoc.numeroInterno AS numeroInterno,
		idoc.fechaEmis AS fechaEmis,
		idoc.formaPago AS formaPago,
		idoc.condicionesDePago AS condicionesDePago,
		idoc.cuenta AS cuenta,
		idoc.lugarExpedicion AS lugarExpedicion,
		idoc.metodoDePago AS metodoDePago,
		idoc.fechaTimbrado AS fechaTimbrado,
		idoc.selloCFD AS selloCFD,
		idoc.noCertificadoSAT AS noCertificadoSAT,
		idoc.selloSAT AS selloSAT,
		idoc.uUID AS uUID,
		idoc.sello AS sello,
		idoc.unidadMedida AS unidadMedida,
		idoc.milisegundos AS milisegundos,
		idoc.version AS version2,

		df.calle AS calle,
		df.nroExterior AS nroExterior,
		df.nroInterior AS nroInterior,
		df.colonia AS colonia,
		df.localidad AS localidad,
		df.municipio AS municipio,
		df.estado AS estado,
		df.pais AS pais,
		df.codigoPostal AS codigoPostal,

		dfr.calle AS calleR,
		dfr.nroExterior AS nroExteriorR,
		dfr.nroInterior AS nroInteriorR,
		dfr.colonia AS coloniaR,
		dfr.localidad AS localidadR,
		dfr.municipio AS municipioR,
		dfr.estado AS estadoR,
		dfr.pais AS paisR,
		dfr.codigoPostal AS codigoPostalR,
		dfr.referencia AS referencia,

		dfs.calle AS calleS,
		dfs.nroExterior AS nroExteriorS,
		dfs.nroInterior AS nroInteriorS,
		dfs.colonia AS coloniaS,
		dfs.localidad AS localidadS,
		dfs.municipio AS municipioS,
		dfs.estado AS estadoS,
		dfs.pais AS paisS,
		dfs.codigoPostal AS codigoPostalS,

		t.moneda AS moneda,
		t.subTotal AS subTotal,
		t.mntDcto AS mntDcto,
		t.pctDcto AS pctDcto,
		t.mntBase AS mntBase,
		t.mntImp AS mntImp,
		t.descuento AS descuento,
		t.vlrPagar AS total,
		t.vlrPalabras AS vlrPalabras,
		t.motivoDescuento,

		cp.certificado AS certificado,
		cp.noCertificado AS noCertificado,

		arr.cuentaPredial,

		ce.Incoterm,

		cpo.transpInternac,
		cpo.entradaSalidaMerc,
		cpo.paisOrigenDestino,
		cpo.viaEntradaSalida,
		cpo.pesoBrutoTotal,
		cpo.unidadPeso,
		cpo.id as id_cartaPorte

		FROM Factura f
		JOIN DomFiscalFact df ON f.id_factura = df.id_factura
		JOIN DomFiscalRcpFact dfr ON f.id_factura = dfr.id_factura
		JOIN IdDoc idoc ON f.id_factura = idoc.id_factura
		JOIN Totales t ON f.id_factura = t.id_factura
		JOIN ComercioE ce ON f.id_factura = ce.id_factura
		JOIN CertificadosProveedor cp ON f.id_certificadoProveedor = cp.id
		LEFT JOIN DomFiscalSucursalFac dfs ON f.id_factura = dfs.id_factura
		LEFT JOIN CartaPorte cpo ON f.id_factura = cpo.id_factura
		LEFT JOIN Arrendamiento arr ON f.id_factura = arr.id_factura
		WHERE f.id_factura = $id_factura AND f.id_proveedor = $id_proveedor";

        $dataFactura = DB::select($query)[0];

        $dataFactura->impuestos = ExImpuestos::where('id_factura', '=', $id_factura)->orderBy('tipo')->get();
        $dataFactura->conceptos = Concepto::where('id_factura', '=', $id_factura)->get();

        $dataFactura->cartaPorte = null;

        if (!empty($dataFactura->id_cartaPorte) && $dataFactura->id_cartaPorte > 0) {
            $cartaPorte = new \stdClass();
            $cartaPorte->transpInternac = $dataFactura->transpInternac;
            $cartaPorte->entradaSalidaMerc = $dataFactura->entradaSalidaMerc;
            $cartaPorte->paisOrigenDestino = $dataFactura->paisOrigenDestino;
            $cartaPorte->viaEntradaSalida = $dataFactura->viaEntradaSalida;
            $cartaPorte->pesoBrutoTotal = $dataFactura->pesoBrutoTotal;
            $cartaPorte->unidadPeso = $dataFactura->unidadPeso;

            $cartaPorte->ubicaciones = Ubicacion::where('id_cartaPorte', '=', $dataFactura->id_cartaPorte)->get();
            $cartaPorte->mercancias = Mercancia::where('id_cartaPorte', '=', $dataFactura->id_cartaPorte)->get();
            $cartaPorte->autotransporte = Autotransporte::where('id_cartaPorte', '=', $dataFactura->id_cartaPorte)->first();

            if (is_object($cartaPorte->autotransporte)) {
                $cartaPorte->autotransporte->remolques = Remolque::where('id_cartaPorte', '=', $dataFactura->id_cartaPorte)->get();
            }

            $cartaPorte->figurasTransporte = FigurasTransporte::where('id_cartaPorte', '=', $dataFactura->id_cartaPorte)->get();
        }

        $dataFactura->comercio = null;

        if (!empty($dataFactura->Incoterm)) {

            $dataFactura->comercio = new \stdClass();
            $dataFactura->comercio->datos = ComercioE::find($dataFactura);
            $dataFactura->comercio->emisor = DomFiscalFact::find($dataFactura);
            $dataFactura->comercio->receptor = DomFiscalRcpFact::find($dataFactura);
        }


        $xml = XMLUtils::createXML32($dataFactura);

        $xmlName = "$dataFactura->rFCEmisor-$dataFactura->uUID.xml";

        //return response()->attachment($xml, $xmlName);

        return response($xml, 200)
            ->header('Content-Type', 'text/xml');


    }

    public function datosFacturar(Request $request)
    {

        $user = $request->input('user');
        $isCartaPorte = $request->input('cartaPorte');

        $proveedor = Proveedor::with('domicilio')->find($user ['id_proveedor']);

        $clientes = DB::table('Cliente')
            ->leftJoin('DomFiscalRcp', 'DomFiscalRcp.id_cliente', '=', 'Cliente.id_cliente')
            ->select('Cliente.id_cliente', 'rFCRecep', 'nmbRecep', 'usoCFDI', 'metodoPago', 'tipoPersona', 'regimenFiscalReceptor', 'DomFiscalRcp.codigoPostal')
            ->where('status', '=', 1)->where('id_proveedor', '=', $user['id_proveedor'])->orderBy('nmbRecep')->get();
        $formasDePago = FormaPago::orderBy('codigo')->get();
        $bancos = Bancop::get();
        $productos = Producto::where('status', '=', 1)->where('id_proveedor', '=', $user['id_proveedor'])->orderBy('nombre')->get();

        $unidadesMedida = UnidadMedidaProveedor::where('id_proveedor', '=', $user['id_proveedor'])->with('unidad')->get();
        $clavesProducto = ClaveProdServProveedor::where('id_proveedor', '=', $user['id_proveedor'])->with('clave')->get();
        $series = Serie::where('id_proveedor', '=', $user['id_proveedor'])->get();
        $usosCFDI = UsoCFDI::where('status', '=', 1)->get();
        $incoterms = Incoterm::get();
        $regimenesFiscales = CatalogoRegimenFiscal::where('status', '=', 1)->get();
        $catTipoPermisos = CatalogoTipoPermiso::where('status', '=', 1)->get();
        $catConfigTransporte = CatalogoConfigTransporte::where('status', '=', 1)->get();
        $catsubTipoRem = CatalogoSubTipoRem::where('status', '=', 1)->get();

        $addendas = Addenda::where('id_proveedor', '=', $user ['id_proveedor'])->get();
        if (count($addendas) > 0)
            $addendas = $addendas->toArray();

        $licenciaObj = LicenciaCarta::where('id_proveedor', '=', $user['id_proveedor'])->first();
        $tieneCartaPorte = false;
        if (is_object($licenciaObj)) {
            if ($licenciaObj->expiration > date('Y-m-d H:i:s')) {
                $tieneCartaPorte = true;
            }
        }

        $licenciaIneObj = LicenciaINE::where('id_proveedor', '=', $user['id_proveedor'])->
        where('status', '=', 1)->first();
        $tieneIne = false;
        if (is_object($licenciaIneObj)) {
            if ($licenciaIneObj->expiration > date('Y-m-d H:i:s')) {
                $tieneIne = true;
            }
        }

        $licenciaInbursaObj = LicenciaInbursa::where('id_proveedor', '=', $user['id_proveedor'])->
        where('status', '=', 1)->first();
        $tieneInbursa = false;
        if (is_object($licenciaInbursaObj)) {
            if ($licenciaInbursaObj->expiration > date('Y-m-d H:i:s')) {
                $tieneInbursa = true;
            }
        }

        $licenciaObj = LicenciaEscuelas::where('id_proveedor', '=', $user['id_proveedor'])->first();
        $tieneEscuelas = false;
        if (is_object($licenciaObj)) {
            if ($licenciaObj->expiration > date('Y-m-d H:i:s')) {
                $tieneEscuelas = true;
            }
        }

        $figurasTransporte = [];
        $ubicacionesBase = [];
        $autotransportesBase = [];
        if($isCartaPorte == 1){
            $figurasTransporte = FigurasTransporteBase::where('id_proveedor', '=', $user ['id_proveedor'])->get();
            if (is_countable($figurasTransporte) && count($figurasTransporte) > 0)
                $figurasTransporte = $figurasTransporte->toArray();
            $ubicacionesBase = UbicacionBase::where('id_proveedor', '=', $user ['id_proveedor'])->get();
            if (is_countable($ubicacionesBase) && count($ubicacionesBase) > 0)
                $ubicacionesBase = $ubicacionesBase->toArray();
            $autotransportesBase = AutotransporteBase::where('id_proveedor', '=', $user ['id_proveedor'])->get();
            if (is_countable($autotransportesBase) && count($autotransportesBase) > 0)
                $autotransportesBase = $autotransportesBase->toArray();
        }

        return Response::json(array(
            'success' => true,
            'clientes' => $clientes,
            'formasDePago' => $formasDePago->toArray(),
            'unidadesMedida' => $unidadesMedida->toArray(),
            'clavesProducto' => $clavesProducto->toArray(),
            'usosCFDI' => $usosCFDI->toArray(),
            'proveedor' => $proveedor->toArray(),
            'series' => $series->toArray(),
            'incoterms' => $incoterms->toArray(),
            'productos' => $productos->toArray(),
            'bancos' => $bancos->toArray(),
            'addendas' => $addendas,
            'regimenesFiscales' => $regimenesFiscales,
            'tipoPermisos' => $catTipoPermisos->toArray(),
            'configTransportes' => $catConfigTransporte->toArray(),
            'subTiposRem' => $catsubTipoRem->toArray(),
            'tieneCartaPorte' => $tieneCartaPorte,
            'tieneEscuelas' => $tieneEscuelas,
            'tieneIne' => $tieneIne,
            'tieneInbursa' => $tieneInbursa,
            'figurasTransporteBase' => $figurasTransporte,
            'ubicacionesBase' => $ubicacionesBase,
            'autotransportesBase' => $autotransportesBase
        ));

    }


    public function datosFacturarTest(Request $request)
    {

        $user = $request->input('user');
        $isCartaPorte = $request->input('cartaPorte');

        $proveedor = Proveedor::with('domicilio')->find($user ['id_proveedor']);


        $clientes = DB::table('Cliente')
            ->leftJoin('DomFiscalRcp', 'DomFiscalRcp.id_cliente', '=', 'Cliente.id_cliente')
            ->select('Cliente.id_cliente', 'rFCRecep', 'nmbRecep', 'usoCFDI', 'metodoPago', 'tipoPersona', 'regimenFiscalReceptor', 'DomFiscalRcp.codigoPostal')
            ->where('status', '=', 1)->where('id_proveedor', '=', $user['id_proveedor'])->orderBy('nmbRecep')->get();

        $formasDePago = FormaPago::orderBy('codigo')->get();
        $bancos = Bancop::get();

        $productos = Producto::where('status', '=', 1)->where('id_proveedor', '=', $user['id_proveedor'])->orderBy('nombre')->get();

        /*
        $unidadesMedida = UnidadMedidaProveedor::where('id_proveedor', '=', $user['id_proveedor'])->with('unidad')->get();
        $clavesProducto = ClaveProdServProveedor::where('id_proveedor', '=', $user['id_proveedor'])->with('clave')->get();
        $series = Serie::where('id_proveedor', '=', $user['id_proveedor'])->get();
        $usosCFDI = UsoCFDI::where('status', '=', 1)->get();
        $incoterms = Incoterm::get();
        $regimenesFiscales = CatalogoRegimenFiscal::where('status', '=', 1)->get();
        $catTipoPermisos = CatalogoTipoPermiso::where('status', '=', 1)->get();
        $catConfigTransporte = CatalogoConfigTransporte::where('status', '=', 1)->get();
        $catsubTipoRem = CatalogoSubTipoRem::where('status', '=', 1)->get();


        $addendas = Addenda::where('id_proveedor', '=', $user ['id_proveedor'])->get();
        if (count($addendas) > 0)
            $addendas = $addendas->toArray();

        $licenciaObj = LicenciaCarta::where('id_proveedor', '=', $user['id_proveedor'])->first();
        $tieneCartaPorte = false;
        if (is_object($licenciaObj)) {
            if ($licenciaObj->expiration > date('Y-m-d H:i:s')) {
                $tieneCartaPorte = true;
            }
        }

        $licenciaIneObj = LicenciaINE::where('id_proveedor', '=', $user['id_proveedor'])->
        where('status', '=', 1)->first();
        $tieneIne = false;
        if (is_object($licenciaIneObj)) {
            if ($licenciaIneObj->expiration > date('Y-m-d H:i:s')) {
                $tieneIne = true;
            }
        }

        $licenciaInbursaObj = LicenciaInbursa::where('id_proveedor', '=', $user['id_proveedor'])->
        where('status', '=', 1)->first();
        $tieneInbursa = false;
        if (is_object($licenciaInbursaObj)) {
            if ($licenciaInbursaObj->expiration > date('Y-m-d H:i:s')) {
                $tieneInbursa = true;
            }
        }

        $licenciaObj = LicenciaEscuelas::where('id_proveedor', '=', $user['id_proveedor'])->first();
        $tieneEscuelas = false;
        if (is_object($licenciaObj)) {
            if ($licenciaObj->expiration > date('Y-m-d H:i:s')) {
                $tieneEscuelas = true;
            }
        }

        $figurasTransporte = [];
        $ubicacionesBase = [];
        $autotransportesBase = [];
        if($isCartaPorte == 1){
            $figurasTransporte = FigurasTransporteBase::where('id_proveedor', '=', $user ['id_proveedor'])->get();
            if (is_countable($figurasTransporte) && count($figurasTransporte) > 0)
                $figurasTransporte = $figurasTransporte->toArray();
            $ubicacionesBase = UbicacionBase::where('id_proveedor', '=', $user ['id_proveedor'])->get();
            if (is_countable($ubicacionesBase) && count($ubicacionesBase) > 0)
                $ubicacionesBase = $ubicacionesBase->toArray();
            $autotransportesBase = AutotransporteBase::where('id_proveedor', '=', $user ['id_proveedor'])->get();
            if (is_countable($autotransportesBase) && count($autotransportesBase) > 0)
                $autotransportesBase = $autotransportesBase->toArray();
        }
        */

        return Response::json(array(
            'success' => true,
            'clientes' => $clientes,
            'formasDePago' => $formasDePago->toArray(),
            //'unidadesMedida' => $unidadesMedida->toArray(),
            //'clavesProducto' => $clavesProducto->toArray(),
            //'usosCFDI' => $usosCFDI->toArray(),
            'proveedor' => $proveedor->toArray(),
            //'series' => $series->toArray(),
            //'incoterms' => $incoterms->toArray(),
            'productos' => $productos->toArray(),
            'bancos' => $bancos->toArray(),
            //'addendas' => $addendas,
            //'regimenesFiscales' => $regimenesFiscales,
            //'tipoPermisos' => $catTipoPermisos->toArray(),
            //'configTransportes' => $catConfigTransporte->toArray(),
            //'subTiposRem' => $catsubTipoRem->toArray(),
            //'tieneCartaPorte' => $tieneCartaPorte,
            //'tieneEscuelas' => $tieneEscuelas,
            //'tieneIne' => $tieneIne,
            //'figurasTransporteBase' => $figurasTransporte,
            //'ubicacionesBase' => $ubicacionesBase,
            //'autotransportesBase' => $autotransportesBase
        ));

    }


    public function obtenerFacturasRel(Request $request)
    {

        $user = $request->input('user');
        $noFactura = $request->input('noFactura');

        $facturas = DB::table('Factura')
            ->join('IdDoc', 'IdDoc.id_factura', '=', 'Factura.id_factura')
            ->where('Factura.id_proveedor', '=', $user['id_proveedor'])
            ->where('noFactura', 'like', "%$noFactura%")
            ->select(DB::raw('Factura.id_factura, IdDoc.serie, Factura.noFactura, IdDoc.uUID, Factura.rFCRecep'))->get();


        return Response::json(array(
            'success' => true,
            'facturas' => $facturas
        ));
    }


    public function obtenerPaises()
    {

        $paises = Pais::where('status', '=', 1)->get();

        return Response::json(array(
            'success' => true,
            'paises' => $paises->toArray()
        ));
    }


    public function facturar(Request $request)
    {

        ini_set('default_socket_timeout', 300);
        ini_set('max_execution_time', 300);
        set_time_limit(300);

        $factura = $request->input('factura');
        $user = $request->input('user');
        $proveedor = Proveedor::find($user['id_proveedor']);
        $nombreArchivo = '';


        $rfcHoraAntes = array(592, 589);
        $textLess = '-2 minutes';
        if (in_array($user['id_proveedor'], $rfcHoraAntes))
            $textLess = '-70 hours';

        $timeStamp = date("Y-m-d H:i:s", strtotime($textLess));
        $noFactura = DB::select("SELECT MAX(noFactura) as noFactura FROM Factura f JOIN IdDoc i ON f.id_factura = i.id_factura WHERE id_proveedor = " . $user['id_proveedor'] . " AND i.serie = '" . $factura['serie'] . "'")[0];
        $noFactura->noFactura++;
        $certificadoHaUsar = CertificadoProveedor::where('id_proveedor', '=', $user['id_proveedor'])->where('status', '=', 1)->first();

        $datosFactura = new \stdClass();
        $datosFactura->timeStamp = $timeStamp;
        $datosFactura->tipoDeComprobante = $factura['tipoDocumento'];
        $datosFactura->serie = $factura['serie'];
        $datosFactura->folio = $noFactura->noFactura;
        $datosFactura->noCertificado = $certificadoHaUsar->noCertificado;
        $datosFactura->certificado = $certificadoHaUsar->certificado;
        $datosFactura->mntBase = $factura['base'];
        $datosFactura->subtotal = $factura['subtotal'];
        $datosFactura->moneda = $factura['moneda'];
        $datosFactura->total = $factura['total'];
        $datosFactura->formaPago = $factura['formaPago'];
        $datosFactura->descuento = $factura['descuento'];
        $datosFactura->precission = $factura['decimales'];
        $datosFactura->tipoCambio = $factura['tipoCambio'];
        $datosFactura->lugarExpedicion = Utils::deleteExtraSpaces($factura['lugarExpedicion']);
        $datosFactura->usoCFDI = $factura['usoCFDI'];
        $datosFactura->metodoDePago = $factura['metodoDePago'];
        $datosFactura->condicionesDePago = (isset($factura['condicionesPago'])) ? Utils::deleteExtraSpaces($factura['condicionesPago']) : '';
        $datosFactura->cuentaPredial = (isset($factura['cuentaPredial'])) ? Utils::deleteExtraSpaces($factura['cuentaPredial']) : '';
        $datosFactura->tipoFacturasRelacionadas = $factura['facturasRelacionadas']['tipoRelacion'];
        $datosFactura->rFCEmisor = $proveedor->rFCEmisor;
        $datosFactura->nmbEmisor = $proveedor->nmbEmisor;
        $datosFactura->rFCRecep = $factura['id_cliente']['rFCRecep'];
        $datosFactura->nmbRecep = $factura ['id_cliente'] ['nmbRecep'];
        $datosFactura->regimenFiscal = $proveedor->regimenFiscal33;
        $datosFactura->numRegIdTrib = isset($factura['numRegIdTrib']) ? $factura['numRegIdTrib'] : '';
        $datosFactura->pais = isset($factura['pais']) ? $factura['pais'] : '';
        $datosFactura->tipoPersona = $proveedor->tipoPersona;


        $datosFactura->conceptos = [];
        $datosFactura->impuestosTrasladados = [];
        $datosFactura->impuestosRetenidos = [];
        $datosFactura->impuestosTrasladadosLcl = [];
        $datosFactura->impuestosTrasladadosLclTotal = 0;
        $datosFactura->impuestosRetenidosLcl = [];
        $datosFactura->impuestosRetenidosLclTotal = 0;
        $totalImpRetenidos = 0;
        $totalImpTrasladados = 0;

        foreach ($factura ['detalles'] as $detalle) {

            $concepto = new \stdClass ();
            $concepto->clave = $detalle ['clave'];
            $concepto->id_producto = isset($detalle ['id_producto']) ? $detalle ['id_producto'] : 0;
            $concepto->cdgItem = Utils::deleteExtraSpaces($detalle ['codigo']);
            $concepto->dscItem = Utils::deleteExtraSpaces($detalle ['nombre']);
            $concepto->unmdItem = (isset ($detalle ['unidad'])) ? $detalle ['unidad'] : '';
            $concepto->qtyItem = $detalle ['qty'];
            $concepto->montoNetoItem = $detalle ['precioU'];
            $concepto->prcNetoItem = $detalle ['qty'] * $detalle ['precioU'];
            $concepto->descuento = $detalle ['descuento'];

            $concepto->impuestosTrasladados = [];

            $base = Utils::formatNumber((($detalle ['qty'] * $detalle ['precioU']) - $detalle ['descuento']), $factura['decimales']);
            foreach ($factura ['impuestosTrasladados'] as $traslado) {

                if ($traslado ['impuesto'] == 'XXX') {

                    $impuestoLcl = new \stdClass ();
                    $impuestoLcl->tipoImp = $traslado ['label'];
                    $impuestoLcl->tasaImp = $traslado ['valor'];
                    $impuestoLcl->tipo = 1;

                    $importeImp = 0;
                    if ($traslado ['factor'] == 'Tasa') {
                        $importeImp = $traslado ['valor'] * $base;
                    } else if ($traslado ['factor'] == 'Cuota') {
                        $importeImp = $traslado ['valor'];
                    }

                    $importeImp = Utils::formatNumber($importeImp, $factura['decimales']);

                    $impuestoLcl->montoImp = $importeImp;


                    $datosFactura->impuestosTrasladadosLclTotal += $importeImp;
                    $datosFactura->impuestosTrasladadosLcl[] = $impuestoLcl;

                } else {

                    $impuesto = new \stdClass ();
                    $impuesto->base = $base;
                    $impuesto->factor = $traslado ['factor'];
                    $impuesto->tipoImp = $traslado ['impuesto'];
                    $impuesto->tasaImp = $traslado ['valor'];
                    $impuesto->tipo = 1;

                    $importeImp = 0;
                    if ($traslado ['factor'] == 'Tasa') {
                        $importeImp = $traslado ['valor'] * $impuesto->base;
                    } else if ($traslado ['factor'] == 'Cuota') {
                        $importeImp = $traslado ['valor'];
                    }

                    $importeImp = Utils::formatNumber($importeImp, $factura['decimales']);

                    $impuesto->montoImp = $importeImp;

                    $totalImpTrasladados += $importeImp;

                    $concepto->impuestosTrasladados[] = $impuesto;

                    $isNuevo = true;
                    if (count($datosFactura->impuestosTrasladados))
                        foreach ($datosFactura->impuestosTrasladados as $impuestoGeneral) {


                            if ($impuesto->tipoImp == $impuestoGeneral->impuesto && $impuesto->factor == $impuestoGeneral->tipoFactor && $impuesto->tasaImp == $impuestoGeneral->tasaOCuota) {
                                $isNuevo = false;
                                $impuestoGeneral->importe += $impuesto->montoImp;
                                break;
                            }
                        }

                    if ($isNuevo && $traslado['factor'] != 'Exento') {
                        $impuestoGeneral = new \stdClass();
                        $impuestoGeneral->importe = $impuesto->montoImp;
                        $impuestoGeneral->impuesto = $impuesto->tipoImp;
                        $impuestoGeneral->tipoFactor = $traslado['factor'];
                        $impuestoGeneral->tasaOCuota = $traslado['valor'];
                        $datosFactura->impuestosTrasladados[] = $impuestoGeneral;
                    }

                }
            }

            $concepto->impuestosRetenidos = [];

            foreach ($factura['impuestosRetenidos'] as $retencion) {


                if ($retencion ['impuesto'] == 'XXX') {

                    $impuestoLcl = new \stdClass ();
                    $impuestoLcl->tipoImp = $retencion ['label'];
                    $impuestoLcl->tasaImp = $retencion ['valor'];
                    $impuestoLcl->tipo = 0;

                    $importeImp = 0;
                    if ($retencion ['factor'] == 'Tasa') {
                        $importeImp = $retencion ['valor'] * $base;
                    } else if ($retencion ['factor'] == 'Cuota') {
                        $importeImp = $retencion ['valor'];
                    }

                    $importeImp = Utils::formatNumber($importeImp, $factura['decimales']);

                    $impuestoLcl->montoImp = $importeImp;

                    $datosFactura->impuestosRetenidosLclTotal += $importeImp;
                    $datosFactura->impuestosRetenidosLcl[] = $impuestoLcl;

                } else {

                    $impuesto = new \stdClass();
                    $impuesto->base = $base;
                    $impuesto->factor = $retencion['factor'];
                    $impuesto->tipoImp = $retencion['impuesto'];
                    $impuesto->tasaImp = $retencion['valor'];
                    $impuesto->tipo = 0;

                    $importeImp = 0;
                    if ($retencion['factor'] == 'Tasa') {
                        $importeImp = $retencion['valor'] * $impuesto->base;
                    } else if ($retencion['factor'] == 'Cuota') {
                        $importeImp = $retencion['valor'];
                    }

                    $importeImp = Utils::formatNumber($importeImp, $factura['decimales']);

                    $impuesto->montoImp = $importeImp;

                    $totalImpRetenidos += $importeImp;

                    $concepto->impuestosRetenidos[] = $impuesto;

                    $isNuevo = true;
                    if (count($datosFactura->impuestosRetenidos))
                        foreach ($datosFactura->impuestosRetenidos as $impuestoGeneral) {
                            if ($impuesto->tipoImp == $impuestoGeneral->impuesto) {
                                $isNuevo = false;
                                $impuestoGeneral->importe += $impuesto->montoImp;
                                break;
                            }
                        }

                    if ($isNuevo && $retencion['factor'] != 'Exento') {
                        $impuestoGeneral = new \stdClass();
                        $impuestoGeneral->importe = $impuesto->montoImp;
                        $impuestoGeneral->impuesto = $impuesto->tipoImp;
                        $datosFactura->impuestosRetenidos[] = $impuestoGeneral;
                    }

                }


            }

            $datosFactura->conceptos[] = $concepto;
        }


        $datosFactura->totalImpRetenidos = $totalImpRetenidos;
        $datosFactura->totalImpTrasladados = $totalImpTrasladados;

        $datosFactura->facturasRelacionadas = [];

        if (count($factura['facturasRelacionadas']['uuids']))
            foreach ($factura['facturasRelacionadas']['uuids'] as $facturaRelacionada) {

                $relacionObj = new \stdClass();
                $relacionObj->uuid = $facturaRelacionada['uUID'];
                $datosFactura->facturasRelacionadas[] = $relacionObj;

            }


        $datosFactura->comercio = null;

        if (isset($factura['isComercio']) && $factura['isComercio'] == 1) {

            $datosFactura->comercio = new \stdClass();

            $comercio = $factura['comercio'];

            $comercioEObj = new \stdClass();
            $comercioEObj->incoterm = $comercio['incoterm'];
            $comercioEObj->clavePedimento = $comercio['pedimento'];
            $comercioEObj->tipoOperacion = $comercio['tipoOperacion'];
            $comercioEObj->rfcExtranjero = $comercio['rfcExtranjero'];

            $emisor = $comercio['emisor'];

            $domicilioEmisor = new \stdClass();
            $domicilioEmisor->calle = $emisor['calle'];
            $domicilioEmisor->nroExterior = $emisor['nroExterior'];
            $domicilioEmisor->nroInterior = $emisor['nroInterior'];
            $domicilioEmisor->colonia = $emisor['colonia'];
            $domicilioEmisor->municipio = $emisor['municipio'];
            $domicilioEmisor->estado = $emisor['estado'];
            $domicilioEmisor->pais = $emisor['pais'];
            $domicilioEmisor->codigoPostal = $emisor['codigoPostal'];

            $receptor = $comercio['receptor'];

            $domicilioReceptor = new \stdClass();
            $domicilioReceptor->calle = $receptor['calle'];
            $domicilioReceptor->nroExterior = $receptor['nroExterior'];
            $domicilioReceptor->nroInterior = $receptor['nroInterior'];
            $domicilioReceptor->colonia = $receptor['colonia'];
            $domicilioReceptor->municipio = $receptor['municipio'];
            $domicilioReceptor->estado = $receptor['estado'];
            $domicilioReceptor->pais = $receptor['pais'];
            $domicilioReceptor->codigoPostal = $receptor['codigoPostal'];


            $datosFactura->comercio->datos = $comercioEObj;
            $datosFactura->comercio->emisor = $domicilioEmisor;
            $datosFactura->comercio->receptor = $domicilioReceptor;

        }


        $xml = XMLUtils::createXML33($datosFactura, $proveedor);

        $sello = $xml->query('//cfdi:Comprobante')[0]->getAttribute('Sello');

        $nombreArchivo = "$proveedor->rFCEmisor-" . date('YmdHis');

        file_put_contents("tmp/$nombreArchivo.xml", $xml);

        $base64Comprobante = base64_encode($xml);

        $urlTimbrado = "https://timbracfdi33.mx:1443/Timbrado.asmx?wsdl";
        $usuarioIntegrador = "vb9+kzunCtCXL+WQEvBsCQ==";

        if ($proveedor->id_proveedor == 17) {

            $urlTimbrado = "https://cfdi33-pruebas.buzoncfdi.mx:1443/Timbrado.asmx?wsdl";
            $usuarioIntegrador = "mvpNUXmQfK8=";

        }

        $params = array();
        $params['usuarioIntegrador'] = $usuarioIntegrador;
        $params['xmlComprobanteBase64'] = $base64Comprobante;
        $params['idComprobante'] = rand(5, 999999);


        $client = new SoapClient($urlTimbrado, array('encoding' => 'UTF-8', "connection_timeout" => 250));
        $client->soap_defencoding = "UTF-8";
        $result = $client->__soapCall('TimbraCFDI', array('parameters' => $params));

        $resultado = $result->TimbraCFDIResult->anyType;


        $logToSave = print_r($resultado, true);

        $log = env('DIR_LOGS') . "/" . date("Y-m-d") . ".log";
        $fp = fopen($log, "a");
        fwrite($fp, "\n\n===" . date("Y-m-d:H:i:s") . "\n\n");
        fwrite($fp, "\n\n$nombreArchivo\n\n");
        fwrite($fp, $logToSave);
        fwrite($fp, "\n\n===");
        fclose($fp);

        $success = false;
        $errorCode = 0;
        $errortext = '';
        $facturaResult = '';

        if ($resultado[1] == '0') {
            $success = true;


            $xmlTimbrado = new \DOMDocument("1.0", "uft-8");
            $xmlTimbrado->loadXML($resultado[3]);

            $idDoc = new IdDoc();

            $timbreFiscal = $xmlTimbrado->getElementsByTagName('TimbreFiscalDigital');

            foreach ($timbreFiscal as $timbreFiscal) {

                $fechaTimbrado = $timbreFiscal->getAttribute('FechaTimbrado');
                $fechaTimbradoArray = explode(".", $fechaTimbrado);

                $idDoc->version = $timbreFiscal->getAttribute('Version');
                $idDoc->fechaTimbrado = $timbreFiscal->getAttribute('FechaTimbrado');
                $idDoc->selloCFD = $timbreFiscal->getAttribute('SelloCFD');
                $idDoc->noCertificadoSAT = $timbreFiscal->getAttribute('NoCertificadoSAT');
                $idDoc->selloSAT = $timbreFiscal->getAttribute('SelloSAT');
                $idDoc->uUID = $timbreFiscal->getAttribute('UUID');
                $idDoc->sello = $sello;
                $idDoc->rfcProvCertif = $timbreFiscal->getAttribute('RfcProvCertif');
            }

            $isPagado = 0;
            if ($factura['metodoDePago'] == 'PUE')
                $isPagado = 1;

            $facturaObj = new Factura();
            $facturaObj->id_proveedor = $user['id_proveedor'];
            $facturaObj->id_cliente = $factura['id_cliente']['id_cliente'];
            $facturaObj->id_certificadoProveedor = $certificadoHaUsar->id;
            $facturaObj->nmbEmisor = $proveedor->nmbEmisor;
            $facturaObj->rFCEmisor = $proveedor->rFCEmisor;
            $facturaObj->nmbRecep = $factura['id_cliente']['nmbRecep'];
            $facturaObj->rFCRecep = $factura['id_cliente']['rFCRecep'];
            $facturaObj->regimenFiscal = $proveedor->regimenFiscal33;
            $facturaObj->timeStamp = $timeStamp;
            $facturaObj->noFactura = $noFactura->noFactura;
            $facturaObj->version = "3.3";
            $facturaObj->generadoPor = 3;
            $facturaObj->nota = (isset($factura['comentario'])) ? Utils::deleteExtraSpaces($factura['comentario']) : '';
            $facturaObj->tipoDeComprobante = $factura['tipoDocumento'];
            $facturaObj->precission = $factura['decimales'];
            $facturaObj->status = 1;
            $facturaObj->isPagado = $isPagado;
            $facturaObj->numRegIdTrib = $datosFactura->numRegIdTrib;
            $facturaObj->pais = $datosFactura->pais;
            $facturaObj->save();


            $idDoc->id_factura = $facturaObj->id_factura;
            $idDoc->serie = $factura['serie'];
            $idDoc->folio = $noFactura->noFactura;
            $idDoc->formaPago = $factura['formaPago'];
            $idDoc->condicionesDePago = (isset($factura['condicionesPago'])) ? Utils::deleteExtraSpaces($factura['condicionesPago']) : '';
            $idDoc->lugarExpedicion = Utils::deleteExtraSpaces($factura['lugarExpedicion']);
            $idDoc->usoCFDI = $factura['usoCFDI'];
            $idDoc->metodoDePago = $factura['metodoDePago'];
            $idDoc->sello = $sello;
            $idDoc->tipoFacturasRelacionadas = $datosFactura->tipoFacturasRelacionadas;
            $idDoc->save();


            $totales = new Totales();
            $totales->id_factura = $facturaObj->id_factura;
            $totales->moneda = $factura['moneda'];
            $totales->tipoCambio = $factura['tipoCambio'];
            $totales->subTotal = $factura['subtotal'];
            $totales->mntBase = $factura['base'];
            $totales->vlrPagar = $factura['total'];
            $totales->descuento = $factura['descuento'];
            $totales->save();

            $detalles = array();

            foreach ($datosFactura->conceptos as $concepto) {

                $conceptoObj = new Concepto();
                $conceptoObj->clave = $concepto->clave;
                $conceptoObj->cdgItem = $concepto->cdgItem;
                $conceptoObj->dscItem = $concepto->dscItem;
                $conceptoObj->unmdItem = $concepto->unmdItem;
                $conceptoObj->qtyItem = $concepto->qtyItem;
                $conceptoObj->montoNetoItem = $concepto->montoNetoItem;
                $conceptoObj->prcNetoItem = $concepto->prcNetoItem;
                $conceptoObj->descuento = $concepto->descuento;
                $conceptoObj->id_factura = $facturaObj->id_factura;
                $conceptoObj->save();

                if (isset($factura['guardarProd']) && $factura['guardarProd'] == true) {

                    if ($concepto->id_producto > 0) {
                        $concepto2Obj = Producto::find($concepto->id_producto);
                    } else {
                        $concepto2Obj = new Producto();
                    }

                    $concepto2Obj->id_proveedor = $user['id_proveedor'];
                    $concepto2Obj->clave = $concepto->clave;
                    $concepto2Obj->nombre = $concepto->dscItem;
                    $concepto2Obj->precioU = $concepto->montoNetoItem;
                    $concepto2Obj->unidad = $concepto->unmdItem;
                    $concepto2Obj->codigo = $concepto->cdgItem;
                    $concepto2Obj->status = 1;
                    $concepto2Obj->save();

                }


                foreach ($concepto->impuestosTrasladados as $impuesto) {

                    $impuestoObj = new ExImpuestos();
                    $impuestoObj->base = $impuesto->base;
                    $impuestoObj->factor = $impuesto->factor;
                    $impuestoObj->tipoImp = $impuesto->tipoImp;
                    $impuestoObj->tasaImp = $impuesto->tasaImp;
                    $impuestoObj->tipo = $impuesto->tipo;
                    $impuestoObj->montoImp = $impuesto->montoImp;
                    $impuestoObj->id_detalle = $conceptoObj->id_detalle;
                    $impuestoObj->save();
                }

                foreach ($concepto->impuestosRetenidos as $impuesto) {

                    $impuestoObj = new ExImpuestos();
                    $impuestoObj->base = $impuesto->base;
                    $impuestoObj->factor = $impuesto->factor;
                    $impuestoObj->tipoImp = $impuesto->tipoImp;
                    $impuestoObj->tasaImp = $impuesto->tasaImp;
                    $impuestoObj->tipo = $impuesto->tipo;
                    $impuestoObj->montoImp = $impuesto->montoImp;
                    $impuestoObj->id_detalle = $conceptoObj->id_detalle;
                    $impuestoObj->save();
                }
            }

            foreach ($datosFactura->facturasRelacionadas as $facturaRelacionada) {

                $facturaRelacionadaObj = new FacturasRelacionadas();
                $facturaRelacionadaObj->id_factura = $facturaObj->id_factura;
                $facturaRelacionadaObj->uuid = $facturaRelacionada->uuid;
                $facturaRelacionadaObj->save();

            }


            if (count($datosFactura->impuestosRetenidosLcl) > 0)
                foreach ($datosFactura->impuestosRetenidosLcl as $impuesto) {

                    $impuestoObj = new ExImpuestos();
                    $impuestoObj->tipoImp = $impuesto->tipoImp;
                    $impuestoObj->tasaImp = $impuesto->tasaImp;
                    $impuestoObj->tipo = $impuesto->tipo;
                    $impuestoObj->montoImp = $impuesto->montoImp;
                    $impuestoObj->id_factura = $facturaObj->id_factura;
                    $impuestoObj->save();
                }

            if (count($datosFactura->impuestosTrasladadosLcl) > 0)
                foreach ($datosFactura->impuestosTrasladadosLcl as $impuesto) {

                    $impuestoObj = new ExImpuestos();
                    $impuestoObj->tipoImp = $impuesto->tipoImp;
                    $impuestoObj->tasaImp = $impuesto->tasaImp;
                    $impuestoObj->tipo = $impuesto->tipo;
                    $impuestoObj->montoImp = $impuesto->montoImp;
                    $impuestoObj->id_factura = $facturaObj->id_factura;
                    $impuestoObj->save();
                }

            if ($datosFactura->cuentaPredial != '') {

                $arrendamiento = new Arrendamiento();
                $arrendamiento->id_factura = $facturaObj->id_factura;
                $arrendamiento->cuentaPredial = $datosFactura->cuentaPredial;
                $arrendamiento->save();

            }


            $facturaResult = $datosFactura->serie . $datosFactura->folio;


        } else {


            $errorCode = 10001;
            $errorMsg = 'Hubo un error al crear su factura. Vuelva a intentarlo.';

            if (isset($resultado[6])) {

                $errorCode = $resultado[6];
                switch ($resultado[6]) {
                    case 330037:
                        $errorMsg = "Este RFC del receptor no existe en la lista de RFC inscritos no cancelados del SAT. Puede que su cliente tenga algún bloqueo.";
                        break;
                    case 330007:
                        $errorMsg = "Es necesario que agregue vaya a la sección de Mis Datos y actualice su régimen fiscal.";
                        break;
                    case 330171:
                        $errorMsg = "Se debe seleccionar un Uso de CFDI para realizar la factura.";
                        break;
                    case 305:
                        $errorMsg = "Su certificado de sellos digitales ha vencido, es necesario que genere uno nuevo en el portal del SAT.";
                        break;
                    default:
                        $errorMsg = $resultado[7];
                }
            }

            $errortext = $errorMsg;
        }


        return Response::json(array(
            'success' => $success,
            'errorCode' => $errorCode,
            'errortext' => $errortext,
            'facturaResult' => $facturaResult,
            'nombreArchivo' => $nombreArchivo
        ));

    }


    public function facturarFinkok(Request $request)
    {

        ini_set('default_socket_timeout', 300);
        ini_set('max_execution_time', 300);
        set_time_limit(300);

        $factura = $request->input('factura');
        $user = $request->input('user');
        $proveedor = Proveedor::find($user['id_proveedor']);
        $nombreArchivo = '';


        $rfcHoraAntes = array(592, 589);
        $textLess = '-2 minutes';
        if (in_array($user['id_proveedor'], $rfcHoraAntes))
            $textLess = '-70 hours';

        $timeStamp = date("Y-m-d H:i:s", strtotime($textLess));
        $noFactura = DB::select("SELECT MAX(noFactura) as noFactura FROM Factura f JOIN IdDoc i ON f.id_factura = i.id_factura WHERE id_proveedor = " . $user['id_proveedor'] . " AND i.serie = '" . $factura['serie'] . "'")[0];
        $noFactura->noFactura++;
        $certificadoHaUsar = CertificadoProveedor::where('id_proveedor', '=', $user['id_proveedor'])->where('status', '=', 1)->first();

        $datosFactura = new \stdClass();
        $datosFactura->timeStamp = $timeStamp;
        $datosFactura->tipoDeComprobante = $factura['tipoDocumento'];
        $datosFactura->serie = $factura['serie'];
        $datosFactura->folio = $noFactura->noFactura;
        $datosFactura->noCertificado = $certificadoHaUsar->noCertificado;
        $datosFactura->certificado = $certificadoHaUsar->certificado;
        $datosFactura->mntBase = $factura['base'];
        $datosFactura->subtotal = $factura['subtotal'];
        $datosFactura->moneda = $factura['moneda'];
        $datosFactura->total = $factura['total'];
        $datosFactura->formaPago = $factura['formaPago'];
        $datosFactura->descuento = $factura['descuento'];
        $datosFactura->precission = $factura['decimales'];
        $datosFactura->tipoCambio = $factura['tipoCambio'];
        $datosFactura->lugarExpedicion = Utils::deleteExtraSpaces($factura['lugarExpedicion']);
        $datosFactura->usoCFDI = $factura['usoCFDI'];
        $datosFactura->metodoDePago = $factura['metodoDePago'];
        $datosFactura->condicionesDePago = (isset($factura['condicionesPago'])) ? Utils::deleteExtraSpaces($factura['condicionesPago']) : '';
        $datosFactura->cuentaPredial = (isset($factura['cuentaPredial'])) ? Utils::deleteExtraSpaces($factura['cuentaPredial']) : '';
        $datosFactura->tipoFacturasRelacionadas = $factura['facturasRelacionadas']['tipoRelacion'];
        $datosFactura->rFCEmisor = $proveedor->rFCEmisor;
        $datosFactura->nmbEmisor = $proveedor->nmbEmisor;
        $datosFactura->rFCRecep = $factura['id_cliente']['rFCRecep'];
        $datosFactura->nmbRecep = $factura ['id_cliente'] ['nmbRecep'];
        $datosFactura->regimenFiscal = $proveedor->regimenFiscal33;
        $datosFactura->numRegIdTrib = isset($factura['numRegIdTrib']) ? $factura['numRegIdTrib'] : '';
        $datosFactura->pais = isset($factura['pais']) ? $factura['pais'] : '';
        $datosFactura->tipoPersona = $proveedor->tipoPersona;


        $datosFactura->conceptos = [];
        $datosFactura->impuestosTrasladados = [];
        $datosFactura->impuestosRetenidos = [];
        $datosFactura->impuestosTrasladadosLcl = [];
        $datosFactura->impuestosTrasladadosLclTotal = 0;
        $datosFactura->impuestosRetenidosLcl = [];
        $datosFactura->impuestosRetenidosLclTotal = 0;
        $totalImpRetenidos = 0;
        $totalImpTrasladados = 0;

        foreach ($factura ['detalles'] as $detalle) {

            $concepto = new \stdClass ();
            $concepto->clave = $detalle ['clave'];
            $concepto->id_producto = isset($detalle ['id_producto']) ? $detalle ['id_producto'] : 0;
            $concepto->cdgItem = Utils::deleteExtraSpaces($detalle ['codigo']);
            $concepto->dscItem = Utils::deleteExtraSpaces($detalle ['nombre']);
            $concepto->unmdItem = (isset ($detalle ['unidad'])) ? $detalle ['unidad'] : '';
            $concepto->qtyItem = $detalle ['qty'];
            $concepto->montoNetoItem = $detalle ['precioU'];
            $concepto->prcNetoItem = $detalle ['qty'] * $detalle ['precioU'];
            $concepto->descuento = $detalle ['descuento'];

            $concepto->impuestosTrasladados = [];

            $base = Utils::formatNumber((($detalle ['qty'] * $detalle ['precioU']) - $detalle ['descuento']), $factura['decimales']);
            foreach ($factura ['impuestosTrasladados'] as $traslado) {

                if ($traslado ['impuesto'] == 'XXX') {

                    $impuestoLcl = new \stdClass ();
                    $impuestoLcl->tipoImp = $traslado ['label'];
                    $impuestoLcl->tasaImp = $traslado ['valor'];
                    $impuestoLcl->tipo = 1;

                    $importeImp = 0;
                    if ($traslado ['factor'] == 'Tasa') {
                        $importeImp = $traslado ['valor'] * $base;
                    } else if ($traslado ['factor'] == 'Cuota') {
                        $importeImp = $traslado ['valor'];
                    }

                    $importeImp = Utils::formatNumber($importeImp, $factura['decimales']);

                    $impuestoLcl->montoImp = $importeImp;


                    $datosFactura->impuestosTrasladadosLclTotal += $importeImp;
                    $datosFactura->impuestosTrasladadosLcl[] = $impuestoLcl;

                } else {

                    $impuesto = new \stdClass ();
                    $impuesto->base = $base;
                    $impuesto->factor = $traslado ['factor'];
                    $impuesto->tipoImp = $traslado ['impuesto'];
                    $impuesto->tasaImp = $traslado ['valor'];
                    $impuesto->tipo = 1;

                    $importeImp = 0;
                    if ($traslado ['factor'] == 'Tasa') {
                        $importeImp = $traslado ['valor'] * $impuesto->base;
                    } else if ($traslado ['factor'] == 'Cuota') {
                        $importeImp = $traslado ['valor'];
                    }

                    $importeImp = Utils::formatNumber($importeImp, $factura['decimales']);

                    $impuesto->montoImp = $importeImp;

                    $totalImpTrasladados += $importeImp;

                    $concepto->impuestosTrasladados[] = $impuesto;

                    $isNuevo = true;
                    if (count($datosFactura->impuestosTrasladados))
                        foreach ($datosFactura->impuestosTrasladados as $impuestoGeneral) {


                            if ($impuesto->tipoImp == $impuestoGeneral->impuesto && $impuesto->factor == $impuestoGeneral->tipoFactor && $impuesto->tasaImp == $impuestoGeneral->tasaOCuota) {
                                $isNuevo = false;
                                $impuestoGeneral->importe += $impuesto->montoImp;
                                break;
                            }
                        }

                    if ($isNuevo && $traslado['factor'] != 'Exento') {
                        $impuestoGeneral = new \stdClass();
                        $impuestoGeneral->importe = $impuesto->montoImp;
                        $impuestoGeneral->impuesto = $impuesto->tipoImp;
                        $impuestoGeneral->tipoFactor = $traslado['factor'];
                        $impuestoGeneral->tasaOCuota = $traslado['valor'];
                        $datosFactura->impuestosTrasladados[] = $impuestoGeneral;
                    }

                }
            }

            $concepto->impuestosRetenidos = [];

            foreach ($factura['impuestosRetenidos'] as $retencion) {


                if ($retencion ['impuesto'] == 'XXX') {

                    $impuestoLcl = new \stdClass ();
                    $impuestoLcl->tipoImp = $retencion ['label'];
                    $impuestoLcl->tasaImp = $retencion ['valor'];
                    $impuestoLcl->tipo = 0;

                    $importeImp = 0;
                    if ($retencion ['factor'] == 'Tasa') {
                        $importeImp = $retencion ['valor'] * $base;
                    } else if ($retencion ['factor'] == 'Cuota') {
                        $importeImp = $retencion ['valor'];
                    }

                    $importeImp = Utils::formatNumber($importeImp, $factura['decimales']);

                    $impuestoLcl->montoImp = $importeImp;

                    $datosFactura->impuestosRetenidosLclTotal += $importeImp;
                    $datosFactura->impuestosRetenidosLcl[] = $impuestoLcl;

                } else {

                    $impuesto = new \stdClass();
                    $impuesto->base = $base;
                    $impuesto->factor = $retencion['factor'];
                    $impuesto->tipoImp = $retencion['impuesto'];
                    $impuesto->tasaImp = $retencion['valor'];
                    $impuesto->tipo = 0;

                    $importeImp = 0;
                    if ($retencion['factor'] == 'Tasa') {
                        $importeImp = $retencion['valor'] * $impuesto->base;
                    } else if ($retencion['factor'] == 'Cuota') {
                        $importeImp = $retencion['valor'];
                    }

                    $importeImp = Utils::formatNumber($importeImp, $factura['decimales']);

                    $impuesto->montoImp = $importeImp;

                    $totalImpRetenidos += $importeImp;

                    $concepto->impuestosRetenidos[] = $impuesto;

                    $isNuevo = true;
                    if (count($datosFactura->impuestosRetenidos))
                        foreach ($datosFactura->impuestosRetenidos as $impuestoGeneral) {
                            if ($impuesto->tipoImp == $impuestoGeneral->impuesto) {
                                $isNuevo = false;
                                $impuestoGeneral->importe += $impuesto->montoImp;
                                break;
                            }
                        }

                    if ($isNuevo && $retencion['factor'] != 'Exento') {
                        $impuestoGeneral = new \stdClass();
                        $impuestoGeneral->importe = $impuesto->montoImp;
                        $impuestoGeneral->impuesto = $impuesto->tipoImp;
                        $datosFactura->impuestosRetenidos[] = $impuestoGeneral;
                    }

                }


            }

            $datosFactura->conceptos[] = $concepto;
        }


        $datosFactura->totalImpRetenidos = $totalImpRetenidos;
        $datosFactura->totalImpTrasladados = $totalImpTrasladados;

        $datosFactura->facturasRelacionadas = [];

        if (count($factura['facturasRelacionadas']['uuids']))
            foreach ($factura['facturasRelacionadas']['uuids'] as $facturaRelacionada) {

                $relacionObj = new \stdClass();
                $relacionObj->uuid = $facturaRelacionada['uUID'];
                $datosFactura->facturasRelacionadas[] = $relacionObj;

            }

        $xml = XMLUtils::createXML33($datosFactura, $proveedor);

        $sello = $xml->query('//cfdi:Comprobante')[0]->getAttribute('Sello');

        $nombreArchivo = "$proveedor->rFCEmisor-" . date('YmdHis');

        file_put_contents("tmp/$nombreArchivo.xml", $xml);

        $base64Comprobante = base64_encode($xml);

        $urlTimbrado = "https://demo-facturacion.finkok.com/servicios/soap/stamp.wsdl";
        $usuarioIntegrador = "vb9+kzunCtCXL+WQEvBsCQ==";

        if ($proveedor->id_proveedor == 17) {

            $urlTimbrado = "https://demo-facturacion.finkok.com/servicios/soap/stamp.wsdl";
            $usuarioIntegrador = "mvpNUXmQfK8=";

        }

        $params = array();
        $params['xml'] = $xml;
        $params['username'] = "saul.flores@soliat.com";
        $params['password'] = "S3rgio.Fl0res";


        $client = new SoapClient($urlTimbrado, array('encoding' => 'UTF-8', "connection_timeout" => 250));
        $client->soap_defencoding = "UTF-8";
        $resultado = $client->__soapCall('stamp', array($params));

        $logToSave = print_r($resultado, true);

        $log = env('DIR_LOGS') . "/" . date("Y-m-d") . ".log";
        $fp = fopen($log, "a");
        fwrite($fp, "\n\n===" . date("Y-m-d:H:i:s") . "\n\n");
        fwrite($fp, "\n\n$nombreArchivo\n\n");
        fwrite($fp, $logToSave);
        fwrite($fp, "\n\n===");
        fclose($fp);

        $success = false;
        $errorCode = 0;
        $errortext = '';
        $facturaResult = '';

        if (is_object($resultado) && isset($resultado->stampResult) && isset($resultado->stampResult->xml)) {
            $success = true;


            $xmlTimbrado = new \DOMDocument("1.0", "uft-8");
            $xmlTimbrado->loadXML($resultado->stampResult->xml);

            $idDoc = new IdDoc();

            $timbreFiscal = $xmlTimbrado->getElementsByTagName('TimbreFiscalDigital');

            foreach ($timbreFiscal as $timbreFiscal) {

                $fechaTimbrado = $timbreFiscal->getAttribute('FechaTimbrado');
                $fechaTimbradoArray = explode(".", $fechaTimbrado);

                $idDoc->version = $timbreFiscal->getAttribute('Version');
                $idDoc->fechaTimbrado = $timbreFiscal->getAttribute('FechaTimbrado');
                $idDoc->selloCFD = $timbreFiscal->getAttribute('SelloCFD');
                $idDoc->noCertificadoSAT = $timbreFiscal->getAttribute('NoCertificadoSAT');
                $idDoc->selloSAT = $timbreFiscal->getAttribute('SelloSAT');
                $idDoc->uUID = $timbreFiscal->getAttribute('UUID');
                $idDoc->sello = $sello;
                $idDoc->rfcProvCertif = $timbreFiscal->getAttribute('RfcProvCertif');
            }

            $isPagado = 0;
            if ($factura['metodoDePago'] == 'PUE')
                $isPagado = 1;

            $facturaObj = new Factura();
            $facturaObj->id_proveedor = $user['id_proveedor'];
            $facturaObj->id_cliente = $factura['id_cliente']['id_cliente'];
            $facturaObj->id_certificadoProveedor = $certificadoHaUsar->id;
            $facturaObj->nmbEmisor = $proveedor->nmbEmisor;
            $facturaObj->rFCEmisor = $proveedor->rFCEmisor;
            $facturaObj->nmbRecep = $factura['id_cliente']['nmbRecep'];
            $facturaObj->rFCRecep = $factura['id_cliente']['rFCRecep'];
            $facturaObj->regimenFiscal = $proveedor->regimenFiscal33;
            $facturaObj->timeStamp = $timeStamp;
            $facturaObj->noFactura = $noFactura->noFactura;
            $facturaObj->version = "3.3";
            $facturaObj->generadoPor = 3;
            $facturaObj->nota = (isset($factura['comentario'])) ? Utils::deleteExtraSpaces($factura['comentario']) : '';
            $facturaObj->tipoDeComprobante = $factura['tipoDocumento'];
            $facturaObj->precission = $factura['decimales'];
            $facturaObj->status = 1;
            $facturaObj->isPagado = $isPagado;
            $facturaObj->numRegIdTrib = $datosFactura->numRegIdTrib;
            $facturaObj->pais = $datosFactura->pais;
            $facturaObj->save();


            $idDoc->id_factura = $facturaObj->id_factura;
            $idDoc->serie = $factura['serie'];
            $idDoc->folio = $noFactura->noFactura;
            $idDoc->formaPago = $factura['formaPago'];
            $idDoc->condicionesDePago = (isset($factura['condicionesPago'])) ? Utils::deleteExtraSpaces($factura['condicionesPago']) : '';
            $idDoc->lugarExpedicion = Utils::deleteExtraSpaces($factura['lugarExpedicion']);
            $idDoc->usoCFDI = $factura['usoCFDI'];
            $idDoc->metodoDePago = $factura['metodoDePago'];
            $idDoc->sello = $sello;
            $idDoc->tipoFacturasRelacionadas = $datosFactura->tipoFacturasRelacionadas;
            $idDoc->save();


            $totales = new Totales();
            $totales->id_factura = $facturaObj->id_factura;
            $totales->moneda = $factura['moneda'];
            $totales->tipoCambio = $factura['tipoCambio'];
            $totales->subTotal = $factura['subtotal'];
            $totales->mntBase = $factura['base'];
            $totales->vlrPagar = $factura['total'];
            $totales->descuento = $factura['descuento'];
            $totales->save();

            $detalles = array();

            foreach ($datosFactura->conceptos as $concepto) {

                $conceptoObj = new Concepto();
                $conceptoObj->clave = $concepto->clave;
                $conceptoObj->cdgItem = $concepto->cdgItem;
                $conceptoObj->dscItem = $concepto->dscItem;
                $conceptoObj->unmdItem = $concepto->unmdItem;
                $conceptoObj->qtyItem = $concepto->qtyItem;
                $conceptoObj->montoNetoItem = $concepto->montoNetoItem;
                $conceptoObj->prcNetoItem = $concepto->prcNetoItem;
                $conceptoObj->descuento = $concepto->descuento;
                $conceptoObj->id_factura = $facturaObj->id_factura;
                $conceptoObj->save();

                if (isset($factura['guardarProd']) && $factura['guardarProd'] == true) {

                    if ($concepto->id_producto > 0) {
                        $concepto2Obj = Producto::find($concepto->id_producto);
                    } else {
                        $concepto2Obj = new Producto();
                    }

                    $concepto2Obj->id_proveedor = $user['id_proveedor'];
                    $concepto2Obj->clave = $concepto->clave;
                    $concepto2Obj->nombre = $concepto->dscItem;
                    $concepto2Obj->precioU = $concepto->montoNetoItem;
                    $concepto2Obj->unidad = $concepto->unmdItem;
                    $concepto2Obj->codigo = $concepto->cdgItem;
                    $concepto2Obj->status = 1;
                    $concepto2Obj->save();

                }


                foreach ($concepto->impuestosTrasladados as $impuesto) {

                    $impuestoObj = new ExImpuestos();
                    $impuestoObj->base = $impuesto->base;
                    $impuestoObj->factor = $impuesto->factor;
                    $impuestoObj->tipoImp = $impuesto->tipoImp;
                    $impuestoObj->tasaImp = $impuesto->tasaImp;
                    $impuestoObj->tipo = $impuesto->tipo;
                    $impuestoObj->montoImp = $impuesto->montoImp;
                    $impuestoObj->id_detalle = $conceptoObj->id_detalle;
                    $impuestoObj->save();
                }

                foreach ($concepto->impuestosRetenidos as $impuesto) {

                    $impuestoObj = new ExImpuestos();
                    $impuestoObj->base = $impuesto->base;
                    $impuestoObj->factor = $impuesto->factor;
                    $impuestoObj->tipoImp = $impuesto->tipoImp;
                    $impuestoObj->tasaImp = $impuesto->tasaImp;
                    $impuestoObj->tipo = $impuesto->tipo;
                    $impuestoObj->montoImp = $impuesto->montoImp;
                    $impuestoObj->id_detalle = $conceptoObj->id_detalle;
                    $impuestoObj->save();
                }
            }

            foreach ($datosFactura->facturasRelacionadas as $facturaRelacionada) {

                $facturaRelacionadaObj = new FacturasRelacionadas();
                $facturaRelacionadaObj->id_factura = $facturaObj->id_factura;
                $facturaRelacionadaObj->uuid = $facturaRelacionada->uuid;
                $facturaRelacionadaObj->save();

            }


            if (count($datosFactura->impuestosRetenidosLcl) > 0)
                foreach ($datosFactura->impuestosRetenidosLcl as $impuesto) {

                    $impuestoObj = new ExImpuestos();
                    $impuestoObj->tipoImp = $impuesto->tipoImp;
                    $impuestoObj->tasaImp = $impuesto->tasaImp;
                    $impuestoObj->tipo = $impuesto->tipo;
                    $impuestoObj->montoImp = $impuesto->montoImp;
                    $impuestoObj->id_factura = $facturaObj->id_factura;
                    $impuestoObj->save();
                }

            if (count($datosFactura->impuestosTrasladadosLcl) > 0)
                foreach ($datosFactura->impuestosTrasladadosLcl as $impuesto) {

                    $impuestoObj = new ExImpuestos();
                    $impuestoObj->tipoImp = $impuesto->tipoImp;
                    $impuestoObj->tasaImp = $impuesto->tasaImp;
                    $impuestoObj->tipo = $impuesto->tipo;
                    $impuestoObj->montoImp = $impuesto->montoImp;
                    $impuestoObj->id_factura = $facturaObj->id_factura;
                    $impuestoObj->save();
                }

            if ($datosFactura->cuentaPredial != '') {

                $arrendamiento = new Arrendamiento();
                $arrendamiento->id_factura = $facturaObj->id_factura;
                $arrendamiento->cuentaPredial = $datosFactura->cuentaPredial;
                $arrendamiento->save();

            }


            $facturaResult = $datosFactura->serie . $datosFactura->folio;


        } else {


            $errorCode = 10001;
            $errorMsg = 'Hubo un error al crear su factura. Vuelva a intentarlo.';

            if (isset($resultado[6])) {

                $errorCode = $resultado[6];
                switch ($resultado[6]) {
                    case 330037:
                        $errorMsg = "Este RFC del receptor no existe en la lista de RFC inscritos no cancelados del SAT. Puede que su cliente tenga algún bloqueo.";
                        break;
                    case 330007:
                        $errorMsg = "Es necesario que agregue vaya a la sección de Mis Datos y actualice su régimen fiscal.";
                        break;
                    case 330171:
                        $errorMsg = "Se debe seleccionar un Uso de CFDI para realizar la factura.";
                        break;
                    case 305:
                        $errorMsg = "Su certificado de sellos digitales ha vencido, es necesario que genere uno nuevo en el portal del SAT.";
                        break;
                    default:
                        $errorMsg = $resultado[7];
                }
            }

            $errortext = $errorMsg;
        }


        return Response::json(array(
            'success' => $success,
            'errorCode' => $errorCode,
            'errortext' => $errortext,
            'facturaResult' => $facturaResult,
            'nombreArchivo' => $nombreArchivo
        ));

    }


    public function facturarPorConcepto(Request $request)
    {

        ini_set('default_socket_timeout', 250);

        $factura = $request->input('factura');
        $user = $request->input('user');
        $proveedor = Proveedor::find($user['id_proveedor']);
        $nombreArchivo = '';


        $timeStamp = date("Y-m-d H:i:s", strtotime("-2 minutes"));
        $noFactura = DB::select("SELECT MAX(noFactura) as noFactura FROM Factura f JOIN IdDoc i ON f.id_factura = i.id_factura WHERE id_proveedor = " . $user['id_proveedor'] . " AND i.serie = '" . $factura['serie'] . "'")[0];
        $noFactura->noFactura++;
        $certificadoHaUsar = CertificadoProveedor::where('id_proveedor', '=', $user['id_proveedor'])->where('status', '=', 1)->first();

        $datosFactura = new \stdClass();
        $datosFactura->timeStamp = $timeStamp;
        $datosFactura->tipoDeComprobante = $factura['tipoDocumento'];
        $datosFactura->serie = $factura['serie'];
        $datosFactura->folio = $noFactura->noFactura;
        $datosFactura->noCertificado = $certificadoHaUsar->noCertificado;
        $datosFactura->certificado = $certificadoHaUsar->certificado;
        $datosFactura->mntBase = $factura['base'];
        $datosFactura->subtotal = $factura['subtotal'];
        $datosFactura->moneda = $factura['moneda'];
        $datosFactura->total = $factura['total'];
        $datosFactura->formaPago = $factura['formaPago'];
        $datosFactura->descuento = $factura['descuento'];
        $datosFactura->precission = $factura['decimales'];
        $datosFactura->tipoCambio = $factura['tipoCambio'];
        $datosFactura->lugarExpedicion = Utils::deleteExtraSpaces($factura['lugarExpedicion']);
        $datosFactura->usoCFDI = $factura['usoCFDI'];
        $datosFactura->metodoDePago = $factura['metodoDePago'];
        $datosFactura->condicionesDePago = (isset($factura['condicionesPago'])) ? Utils::deleteExtraSpaces($factura['condicionesPago']) : '';
        $datosFactura->cuentaPredial = (isset($factura['cuentaPredial'])) ? Utils::deleteExtraSpaces($factura['cuentaPredial']) : '';
        $datosFactura->tipoFacturasRelacionadas = $factura['facturasRelacionadas']['tipoRelacion'];
        $datosFactura->rFCEmisor = $proveedor->rFCEmisor;
        $datosFactura->nmbEmisor = $proveedor->nmbEmisor;
        $datosFactura->rFCRecep = $factura['id_cliente']['rFCRecep'];
        $datosFactura->nmbRecep = $factura ['id_cliente'] ['nmbRecep'];
        $datosFactura->regimenFiscal = $proveedor->regimenFiscal33;
        $datosFactura->numRegIdTrib = isset($factura['numRegIdTrib']) ? $factura['numRegIdTrib'] : '';
        $datosFactura->pais = isset($factura['pais']) ? $factura['pais'] : '';
        $datosFactura->tipoPersona = $proveedor->tipoPersona;

        $datosFactura->conceptos = [];
        $datosFactura->impuestosTrasladados = [];
        $datosFactura->impuestosRetenidos = [];
        $datosFactura->impuestosTrasladadosLcl = [];
        $datosFactura->impuestosTrasladadosLclTotal = 0;
        $datosFactura->impuestosRetenidosLcl = [];
        $datosFactura->impuestosRetenidosLclTotal = 0;
        $totalImpRetenidos = 0;
        $totalImpTrasladados = 0;

        foreach ($factura ['detalles'] as $detalle) {

            $concepto = new \stdClass ();
            $concepto->clave = $detalle ['clave'];
            $concepto->id_producto = isset($detalle ['id_producto']) ? $detalle ['id_producto'] : 0;
            $concepto->cdgItem = Utils::deleteExtraSpaces($detalle ['codigo']);
            $concepto->dscItem = Utils::deleteExtraSpaces($detalle ['nombre']);
            $concepto->unmdItem = (isset ($detalle ['unidad'])) ? $detalle ['unidad'] : '';
            $concepto->qtyItem = $detalle ['qty'];
            $concepto->montoNetoItem = $detalle ['precioU'];
            $concepto->prcNetoItem = $detalle ['qty'] * $detalle ['precioU'];
            $concepto->descuento = $detalle ['descuento'];

            $concepto->impuestosTrasladados = [];

            $base = Utils::formatNumber((($detalle ['qty'] * $detalle ['precioU']) - $detalle ['descuento']), $factura['decimales']);
            foreach ($detalle ['impuestosTrasladados'] as $traslado) {

                if ($traslado ['impuesto'] == 'XXX') {

                    $impuestoLcl = new \stdClass ();
                    $impuestoLcl->tipoImp = $traslado ['label'];
                    $impuestoLcl->tasaImp = $traslado ['valor'];
                    $impuestoLcl->tipo = 1;


                    $importeImp = Utils::formatNumber($traslado['total'], $factura['decimales']);

                    $impuestoLcl->montoImp = $importeImp;

                    $datosFactura->impuestosTrasladadosLclTotal += $importeImp;
                    $datosFactura->impuestosTrasladadosLcl[] = $impuestoLcl;

                } else {

                    $impuesto = new \stdClass ();
                    $impuesto->base = $traslado ['base'];
                    $impuesto->factor = $traslado ['factor'];
                    $impuesto->tipoImp = $traslado ['impuesto'];
                    $impuesto->tasaImp = $traslado ['valor'];
                    $impuesto->tipo = 1;

                    $importeImp = Utils::formatNumber($traslado['total'], $factura['decimales']);

                    $impuesto->montoImp = $importeImp;

                    $totalImpTrasladados += $importeImp;

                    $concepto->impuestosTrasladados[] = $impuesto;

                    $isNuevo = true;
                    if (count($datosFactura->impuestosTrasladados))
                        foreach ($datosFactura->impuestosTrasladados as $impuestoGeneral) {


                            if ($impuesto->tipoImp == $impuestoGeneral->impuesto && $impuesto->factor == $impuestoGeneral->tipoFactor && $impuesto->tasaImp == $impuestoGeneral->tasaOCuota) {
                                $isNuevo = false;
                                $impuestoGeneral->importe += $impuesto->montoImp;
                                break;
                            }
                        }

                    if ($isNuevo && $traslado['factor'] != 'Exento') {
                        $impuestoGeneral = new \stdClass();
                        $impuestoGeneral->importe = $impuesto->montoImp;
                        $impuestoGeneral->impuesto = $impuesto->tipoImp;
                        $impuestoGeneral->tipoFactor = $traslado['factor'];
                        $impuestoGeneral->tasaOCuota = $traslado['valor'];
                        $datosFactura->impuestosTrasladados[] = $impuestoGeneral;
                    }

                }
            }

            $concepto->impuestosRetenidos = [];

            foreach ($detalle['impuestosRetenidos'] as $retencion) {


                if ($retencion ['impuesto'] == 'XXX') {

                    $impuestoLcl = new \stdClass ();
                    $impuestoLcl->tipoImp = $retencion ['label'];
                    $impuestoLcl->tasaImp = $retencion ['valor'];
                    $impuestoLcl->tipo = 0;

                    $importeImp = Utils::formatNumber($retencion ['total'], $factura['decimales']);

                    $impuestoLcl->montoImp = $importeImp;

                    $datosFactura->impuestosRetenidosLclTotal += $importeImp;
                    $datosFactura->impuestosRetenidosLcl[] = $impuestoLcl;

                } else {

                    $impuesto = new \stdClass();
                    $impuesto->base = $retencion ['base'];
                    $impuesto->factor = $retencion['factor'];
                    $impuesto->tipoImp = $retencion['impuesto'];
                    $impuesto->tasaImp = $retencion['valor'];
                    $impuesto->tipo = 0;

                    $importeImp = Utils::formatNumber($retencion ['total'], $factura['decimales']);

                    $impuesto->montoImp = $importeImp;

                    $totalImpRetenidos += $importeImp;

                    $concepto->impuestosRetenidos[] = $impuesto;

                    $isNuevo = true;
                    if (count($datosFactura->impuestosRetenidos))
                        foreach ($datosFactura->impuestosRetenidos as $impuestoGeneral) {
                            if ($impuesto->tipoImp == $impuestoGeneral->impuesto) {
                                $isNuevo = false;
                                $impuestoGeneral->importe += $impuesto->montoImp;
                                break;
                            }
                        }

                    if ($isNuevo && $retencion['factor'] != 'Exento') {
                        $impuestoGeneral = new \stdClass();
                        $impuestoGeneral->importe = $impuesto->montoImp;
                        $impuestoGeneral->impuesto = $impuesto->tipoImp;
                        $datosFactura->impuestosRetenidos[] = $impuestoGeneral;
                    }

                }


            }

            $datosFactura->conceptos[] = $concepto;
        }


        $datosFactura->totalImpRetenidos = $totalImpRetenidos;
        $datosFactura->totalImpTrasladados = $totalImpTrasladados;

        $datosFactura->facturasRelacionadas = [];

        if (count($factura['facturasRelacionadas']['uuids']))
            foreach ($factura['facturasRelacionadas']['uuids'] as $facturaRelacionada) {

                $relacionObj = new \stdClass();
                $relacionObj->uuid = $facturaRelacionada['uUID'];
                $datosFactura->facturasRelacionadas[] = $relacionObj;

            }

        $xml = XMLUtils::createXML33($datosFactura, $proveedor);

        $sello = $xml->query('//cfdi:Comprobante')[0]->getAttribute('Sello');

        $nombreArchivo = "$proveedor->rFCEmisor-" . date('YmdHis');

        file_put_contents("tmp/$nombreArchivo.xml", $xml);

        $base64Comprobante = base64_encode($xml);

        $urlTimbrado = "https://timbracfdi33.mx:1443/Timbrado.asmx?wsdl";
        $usuarioIntegrador = "vb9+kzunCtCXL+WQEvBsCQ==";

        if ($proveedor->id_proveedor == 17) {

            $urlTimbrado = "https://cfdi33-pruebas.buzoncfdi.mx:1443/Timbrado.asmx?wsdl";
            $usuarioIntegrador = "mvpNUXmQfK8=";

        }

        $params = array();
        $params['usuarioIntegrador'] = $usuarioIntegrador;
        $params['xmlComprobanteBase64'] = $base64Comprobante;
        $params['idComprobante'] = rand(5, 999999);


        $client = new SoapClient($urlTimbrado, array('encoding' => 'UTF-8', "connection_timeout" => 250));
        $client->soap_defencoding = "UTF-8";
        $result = $client->__soapCall('TimbraCFDI', array('parameters' => $params));

        $resultado = $result->TimbraCFDIResult->anyType;


        $logToSave = print_r($resultado, true);

        $log = env('DIR_LOGS') . "/" . date("Y-m-d") . ".log";
        $fp = fopen($log, "a");
        fwrite($fp, "\n\n===" . date("Y-m-d:H:i:s") . "\n\n");
        fwrite($fp, "\n\n$nombreArchivo\n\n");
        fwrite($fp, $logToSave);
        fwrite($fp, "\n\n===");
        fclose($fp);

        $success = false;
        $errorCode = 0;
        $errortext = '';
        $facturaResult = '';

        if ($resultado[1] == '0') {
            $success = true;


            $xmlTimbrado = new \DOMDocument("1.0", "uft-8");
            $xmlTimbrado->loadXML($resultado[3]);

            $idDoc = new IdDoc();

            $timbreFiscal = $xmlTimbrado->getElementsByTagName('TimbreFiscalDigital');

            foreach ($timbreFiscal as $timbreFiscal) {

                $fechaTimbrado = $timbreFiscal->getAttribute('FechaTimbrado');
                $fechaTimbradoArray = explode(".", $fechaTimbrado);

                $idDoc->version = $timbreFiscal->getAttribute('Version');
                $idDoc->fechaTimbrado = $timbreFiscal->getAttribute('FechaTimbrado');
                $idDoc->selloCFD = $timbreFiscal->getAttribute('SelloCFD');
                $idDoc->noCertificadoSAT = $timbreFiscal->getAttribute('NoCertificadoSAT');
                $idDoc->selloSAT = $timbreFiscal->getAttribute('SelloSAT');
                $idDoc->uUID = $timbreFiscal->getAttribute('UUID');
                $idDoc->sello = $sello;
                $idDoc->rfcProvCertif = $timbreFiscal->getAttribute('RfcProvCertif');
            }

            $isPagado = 0;
            if ($factura['metodoDePago'] == 'PUE')
                $isPagado = 1;

            $facturaObj = new Factura();
            $facturaObj->id_proveedor = $user['id_proveedor'];
            $facturaObj->id_cliente = $factura['id_cliente']['id_cliente'];
            $facturaObj->id_certificadoProveedor = $certificadoHaUsar->id;
            $facturaObj->nmbEmisor = $proveedor->nmbEmisor;
            $facturaObj->rFCEmisor = $proveedor->rFCEmisor;
            $facturaObj->nmbRecep = $factura['id_cliente']['nmbRecep'];
            $facturaObj->rFCRecep = $factura['id_cliente']['rFCRecep'];
            $facturaObj->regimenFiscal = $proveedor->regimenFiscal33;
            $facturaObj->timeStamp = $timeStamp;
            $facturaObj->noFactura = $noFactura->noFactura;
            $facturaObj->version = "3.3";
            $facturaObj->generadoPor = 3;
            $facturaObj->nota = (isset($factura['comentario'])) ? Utils::deleteExtraSpaces($factura['comentario']) : '';
            $facturaObj->tipoDeComprobante = $factura['tipoDocumento'];
            $facturaObj->precission = $factura['decimales'];
            $facturaObj->status = 1;
            $facturaObj->isPagado = $isPagado;
            $facturaObj->save();


            $idDoc->id_factura = $facturaObj->id_factura;
            $idDoc->serie = $factura['serie'];
            $idDoc->folio = $noFactura->noFactura;
            $idDoc->formaPago = $factura['formaPago'];
            $idDoc->condicionesDePago = (isset($factura['condicionesPago'])) ? Utils::deleteExtraSpaces($factura['condicionesPago']) : '';
            $idDoc->lugarExpedicion = Utils::deleteExtraSpaces($factura['lugarExpedicion']);
            $idDoc->usoCFDI = $factura['usoCFDI'];
            $idDoc->metodoDePago = $factura['metodoDePago'];
            $idDoc->sello = $sello;
            $idDoc->tipoFacturasRelacionadas = $datosFactura->tipoFacturasRelacionadas;
            $idDoc->save();


            $totales = new Totales();
            $totales->id_factura = $facturaObj->id_factura;
            $totales->moneda = $factura['moneda'];
            $totales->tipoCambio = $factura['tipoCambio'];
            $totales->subTotal = $factura['subtotal'];
            $totales->mntBase = $factura['base'];
            $totales->vlrPagar = $factura['total'];
            $totales->descuento = $factura['descuento'];
            $totales->save();

            $detalles = array();

            foreach ($datosFactura->conceptos as $concepto) {

                $conceptoObj = new Concepto();
                $conceptoObj->clave = $concepto->clave;
                $conceptoObj->cdgItem = $concepto->cdgItem;
                $conceptoObj->dscItem = $concepto->dscItem;
                $conceptoObj->unmdItem = $concepto->unmdItem;
                $conceptoObj->qtyItem = $concepto->qtyItem;
                $conceptoObj->montoNetoItem = $concepto->montoNetoItem;
                $conceptoObj->prcNetoItem = $concepto->prcNetoItem;
                $conceptoObj->descuento = $concepto->descuento;
                $conceptoObj->id_factura = $facturaObj->id_factura;
                $conceptoObj->save();

                if (isset($factura['guardarProd']) && $factura['guardarProd'] == true) {

                    if ($concepto->id_producto > 0) {
                        $concepto2Obj = Producto::find($concepto->id_producto);
                    } else {
                        $concepto2Obj = new Producto();
                    }

                    $concepto2Obj->id_proveedor = $user['id_proveedor'];
                    $concepto2Obj->clave = $concepto->clave;
                    $concepto2Obj->nombre = $concepto->dscItem;
                    $concepto2Obj->precioU = $concepto->montoNetoItem;
                    $concepto2Obj->unidad = $concepto->unmdItem;
                    $concepto2Obj->codigo = $concepto->cdgItem;
                    $concepto2Obj->status = 1;
                    $concepto2Obj->save();

                }


                foreach ($concepto->impuestosTrasladados as $impuesto) {

                    $impuestoObj = new ExImpuestos();
                    $impuestoObj->base = $impuesto->base;
                    $impuestoObj->factor = $impuesto->factor;
                    $impuestoObj->tipoImp = $impuesto->tipoImp;
                    $impuestoObj->tasaImp = $impuesto->tasaImp;
                    $impuestoObj->tipo = $impuesto->tipo;
                    $impuestoObj->montoImp = $impuesto->montoImp;
                    $impuestoObj->id_detalle = $conceptoObj->id_detalle;
                    $impuestoObj->save();
                }

                foreach ($concepto->impuestosRetenidos as $impuesto) {

                    $impuestoObj = new ExImpuestos();
                    $impuestoObj->base = $impuesto->base;
                    $impuestoObj->factor = $impuesto->factor;
                    $impuestoObj->tipoImp = $impuesto->tipoImp;
                    $impuestoObj->tasaImp = $impuesto->tasaImp;
                    $impuestoObj->tipo = $impuesto->tipo;
                    $impuestoObj->montoImp = $impuesto->montoImp;
                    $impuestoObj->id_detalle = $conceptoObj->id_detalle;
                    $impuestoObj->save();
                }
            }

            foreach ($datosFactura->facturasRelacionadas as $facturaRelacionada) {

                $facturaRelacionadaObj = new FacturasRelacionadas();
                $facturaRelacionadaObj->id_factura = $facturaObj->id_factura;
                $facturaRelacionadaObj->uuid = $facturaRelacionada->uuid;
                $facturaRelacionadaObj->save();

            }


            if (count($datosFactura->impuestosRetenidosLcl) > 0)
                foreach ($datosFactura->impuestosRetenidosLcl as $impuesto) {

                    $impuestoObj = new ExImpuestos();
                    $impuestoObj->tipoImp = $impuesto->tipoImp;
                    $impuestoObj->tasaImp = $impuesto->tasaImp;
                    $impuestoObj->tipo = $impuesto->tipo;
                    $impuestoObj->montoImp = $impuesto->montoImp;
                    $impuestoObj->id_factura = $facturaObj->id_factura;
                    $impuestoObj->save();
                }

            if (count($datosFactura->impuestosTrasladadosLcl) > 0)
                foreach ($datosFactura->impuestosTrasladadosLcl as $impuesto) {

                    $impuestoObj = new ExImpuestos();
                    $impuestoObj->tipoImp = $impuesto->tipoImp;
                    $impuestoObj->tasaImp = $impuesto->tasaImp;
                    $impuestoObj->tipo = $impuesto->tipo;
                    $impuestoObj->montoImp = $impuesto->montoImp;
                    $impuestoObj->id_factura = $facturaObj->id_factura;
                    $impuestoObj->save();
                }

            if ($datosFactura->cuentaPredial != '') {

                $arrendamiento = new Arrendamiento();
                $arrendamiento->id_factura = $facturaObj->id_factura;
                $arrendamiento->cuentaPredial = $datosFactura->cuentaPredial;
                $arrendamiento->save();

            }


            $facturaResult = $datosFactura->serie . $datosFactura->folio;


        } else {
            $errorCode = $resultado[6];
            $errortext = $resultado[7];
        }


        return Response::json(array(
            'success' => $success,
            'errorCode' => $errorCode,
            'errortext' => $errortext,
            'facturaResult' => $facturaResult,
            'nombreArchivo' => $nombreArchivo
        ));

    }


    public function facturarPago(Request $request)
    {


        ini_set('default_socket_timeout', 300);
        ini_set('max_execution_time', 300);
        set_time_limit(300);

        $factura = $request->input('factura');
        $user = $request->input('user');
        $proveedor = Proveedor::find($user['id_proveedor']);


        $timeStamp = date("Y-m-d H:i:s", strtotime("-2 minutes"));
        $noFactura = DB::select("SELECT MAX(noFactura) as noFactura FROM Factura f JOIN IdDoc i ON f.id_factura = i.id_factura WHERE id_proveedor = " . $user['id_proveedor'] . " AND i.serie = '" . $factura['serie'] . "'")[0];
        $noFactura->noFactura++;
        $certificadoHaUsar = CertificadoProveedor::where('id_proveedor', '=', $user['id_proveedor'])->where('status', '=', 1)->first();

        $datosFactura = new \stdClass();
        $datosFactura->timeStamp = $timeStamp;
        $datosFactura->tipoDeComprobante = 'P';
        $datosFactura->serie = $factura['serie'];
        $datosFactura->folio = $noFactura->noFactura;
        $datosFactura->noCertificado = $certificadoHaUsar->noCertificado;
        $datosFactura->certificado = $certificadoHaUsar->certificado;
        $datosFactura->mntBase = 0;
        $datosFactura->subtotal = 0;
        $datosFactura->moneda = 'XXX';
        $datosFactura->total = 0;
        $datosFactura->formaPago = '';
        $datosFactura->condicionesDePago = '';
        $datosFactura->descuento = 0;
        $datosFactura->precission = 0;
        $datosFactura->tipoCambio = 1;
        $datosFactura->lugarExpedicion = Utils::deleteExtraSpaces($factura['lugarExpedicion']);
        $datosFactura->usoCFDI = 'P01';
        $datosFactura->metodoDePago = '';
        $datosFactura->condicionesDePago = '';
        $datosFactura->tipoFacturasRelacionadas = $factura['facturasRelacionadas']['tipoRelacion'];
        $datosFactura->rFCEmisor = $proveedor->rFCEmisor;
        $datosFactura->nmbEmisor = $proveedor->nmbEmisor;
        $datosFactura->rFCRecep = $factura['id_cliente']['rFCRecep'];
        $datosFactura->nmbRecep = $factura['id_cliente']['nmbRecep'];
        $datosFactura->regimenFiscal = $proveedor->regimenFiscal33;
        $datosFactura->numRegIdTrib = isset($factura['numRegIdTrib']) ? $factura['numRegIdTrib'] : '';
        $datosFactura->pais = isset($factura['pais']) ? $factura['pais'] : '';
        $datosFactura->tipoPersona = $proveedor->tipoPersona;


        $datosFactura->conceptos = [];
        $datosFactura->impuestosTrasladados = [];
        $datosFactura->impuestosRetenidos = [];
        $totalImpRetenidos = 0;
        $totalImpTrasladados = 0;

        $detalle = array('clave' => '84111506', 'codigo' => '', 'nombre' => 'Pago', 'unidad' => 'ACT', 'qty' => 1, 'precioU' => 0, 'descuento' => 0);
        $factura['detalles'] = [];
        $factura['detalles'][] = $detalle;

        foreach ($factura['detalles'] as $detalle) {

            $concepto = new \stdClass();
            $concepto->clave = $detalle['clave'];
            $concepto->cdgItem = Utils::deleteExtraSpaces($detalle['codigo']);
            $concepto->dscItem = Utils::deleteExtraSpaces($detalle['nombre']);
            $concepto->unmdItem = (isset($detalle['unidad'])) ? $detalle['unidad'] : '';
            $concepto->qtyItem = $detalle['qty'];
            $concepto->montoNetoItem = $detalle['precioU'];
            $concepto->prcNetoItem = $detalle['qty'] * $detalle['precioU'];
            $concepto->descuento = $detalle['descuento'];

            $concepto->impuestosTrasladados = [];
            $concepto->impuestosRetenidos = [];
            $datosFactura->conceptos[] = $concepto;
        }

        $datosFactura->pagos = [];
        foreach ($factura['pagos'] as $pago) {

            $pagoObj = new \stdClass();
            $pagoObj->FechaPago = $pago['fechaPago'];
            $pagoObj->FormaDePagoP = $pago['formaPago'];
            $pagoObj->MonedaP = $pago['moneda'];
            $pagoObj->TipoCambioP = $pago['tipoCambio'];
            $pagoObj->Monto = $pago['totalPago'];

            $pagoObj->documentosRelacionado = [];

            foreach ($pago['documentoRelacionado'] as $documentoRelacionado) {

                $doctoRelacionado = new \stdClass();
                $doctoRelacionado->IdDocumento = $documentoRelacionado['uuid'];
                $doctoRelacionado->MonedaDR = $documentoRelacionado['moneda'];
                $doctoRelacionado->TipoCambioDR = $documentoRelacionado['tipoCambio'];
                $doctoRelacionado->MetodoDePagoDR = 'PPD';
                $doctoRelacionado->NumParcialidad = $documentoRelacionado['parcialidad'];
                $doctoRelacionado->ImpSaldoAnt = $documentoRelacionado['saldoAnterior'];
                $doctoRelacionado->ImpPagado = $documentoRelacionado['pago'];
                $doctoRelacionado->ImpSaldoInsoluto = $documentoRelacionado['saldoInsoluto'];

                $pagoObj->documentosRelacionado[] = $doctoRelacionado;

            }

            $datosFactura->pagos[] = $pagoObj;
        }


        $datosFactura->totalImpRetenidos = $totalImpRetenidos;
        $datosFactura->totalImpTrasladados = $totalImpTrasladados;

        $datosFactura->facturasRelacionadas = [];

        if (count($factura['facturasRelacionadas']['uuids']))
            foreach ($factura['facturasRelacionadas']['uuids'] as $facturaRelacionada) {

                $relacionObj = new \stdClass();
                $relacionObj->uuid = $facturaRelacionada['uUID'];
                $datosFactura->facturasRelacionadas[] = $relacionObj;

            }

        $xml = XMLUtils::createXML33($datosFactura, $proveedor);


        $sello = $xml->query('//cfdi:Comprobante')[0]->getAttribute('Sello');

        $nombreArchivo = "$proveedor->rFCEmisor-" . date('YmdHis');

        file_put_contents("tmp/$nombreArchivo.xml", $xml);

        $base64Comprobante = base64_encode($xml);

        $urlTimbrado = "https://timbracfdi33.mx:1443/Timbrado.asmx?wsdl";
        $usuarioIntegrador = "vb9+kzunCtCXL+WQEvBsCQ==";

        if ($proveedor->id_proveedor == 17) {

            $urlTimbrado = "https://cfdi33-pruebas.buzoncfdi.mx:1443/Timbrado.asmx?wsdl";
            $usuarioIntegrador = "mvpNUXmQfK8=";

        }

        $params = array();
        $params['usuarioIntegrador'] = $usuarioIntegrador;
        $params['xmlComprobanteBase64'] = $base64Comprobante;
        $params['idComprobante'] = rand(5, 999999);


        $client = new SoapClient($urlTimbrado, array('encoding' => 'UTF-8', "connection_timeout" => 250));
        $client->soap_defencoding = "UTF-8";
        $result = $client->__soapCall('TimbraCFDI', array('parameters' => $params));

        $resultado = $result->TimbraCFDIResult->anyType;


        $logToSave = print_r($resultado, true);

        $log = env('DIR_LOGS') . "/" . date("Y-m-d") . ".log";
        $fp = fopen($log, "a");
        fwrite($fp, "\n\n===" . date("Y-m-d:H:i:s") . "\n\n");
        fwrite($fp, "\n\n$nombreArchivo\n\n");
        fwrite($fp, $logToSave);
        fwrite($fp, "\n\n===");
        fclose($fp);

        $success = false;
        $errorCode = 0;
        $errortext = '';
        $facturaResult = '';

        if ($resultado[1] == '0') {
            $success = true;


            $xmlTimbrado = new \DOMDocument("1.0", "uft-8");
            $xmlTimbrado->loadXML($resultado[3]);

            $idDoc = new IdDoc();

            $timbreFiscal = $xmlTimbrado->getElementsByTagName('TimbreFiscalDigital');

            foreach ($timbreFiscal as $timbreFiscal) {

                $fechaTimbrado = $timbreFiscal->getAttribute('FechaTimbrado');
                $fechaTimbradoArray = explode(".", $fechaTimbrado);

                $idDoc->version = $timbreFiscal->getAttribute('Version');
                $idDoc->fechaTimbrado = $timbreFiscal->getAttribute('FechaTimbrado');
                $idDoc->selloCFD = $timbreFiscal->getAttribute('SelloCFD');
                $idDoc->noCertificadoSAT = $timbreFiscal->getAttribute('NoCertificadoSAT');
                $idDoc->selloSAT = $timbreFiscal->getAttribute('SelloSAT');
                $idDoc->uUID = $timbreFiscal->getAttribute('UUID');
                $idDoc->sello = $sello;
                $idDoc->rfcProvCertif = $timbreFiscal->getAttribute('RfcProvCertif');
            }

            $facturaObj = new Factura();
            $facturaObj->id_proveedor = $user['id_proveedor'];
            $facturaObj->id_cliente = $factura['id_cliente']['id_cliente'];
            $facturaObj->id_certificadoProveedor = $certificadoHaUsar->id;
            $facturaObj->nmbEmisor = $proveedor->nmbEmisor;
            $facturaObj->rFCEmisor = $proveedor->rFCEmisor;
            $facturaObj->nmbRecep = $factura['id_cliente']['nmbRecep'];
            $facturaObj->rFCRecep = $factura['id_cliente']['rFCRecep'];
            $facturaObj->regimenFiscal = $proveedor->regimenFiscal33;
            $facturaObj->timeStamp = $timeStamp;
            $facturaObj->noFactura = $noFactura->noFactura;
            $facturaObj->version = "3.3";
            $facturaObj->generadoPor = 3;
            $facturaObj->nota = (isset($factura['comentario'])) ? Utils::deleteExtraSpaces($factura['comentario']) : '';
            $facturaObj->tipoDeComprobante = $factura['tipoDocumento'];
            $facturaObj->precission = $factura['decimales'];
            $facturaObj->status = 1;
            $facturaObj->save();


            $idDoc->id_factura = $facturaObj->id_factura;
            $idDoc->serie = $factura['serie'];
            $idDoc->folio = $noFactura->noFactura;
            $idDoc->formaPago = '';
            $idDoc->condicionesDePago = (isset($factura['condicionesPago'])) ? Utils::deleteExtraSpaces($factura['condicionesPago']) : '';
            $idDoc->lugarExpedicion = Utils::deleteExtraSpaces($factura['lugarExpedicion']);
            $idDoc->usoCFDI = 'P01';
            $idDoc->metodoDePago = '';
            $idDoc->sello = $sello;
            $idDoc->tipoFacturasRelacionadas = $datosFactura->tipoFacturasRelacionadas;
            $idDoc->save();


            $totales = new Totales();
            $totales->id_factura = $facturaObj->id_factura;
            $totales->moneda = 'XXX';
            $totales->tipoCambio = 0;
            $totales->subTotal = 0;
            $totales->mntBase = 0;
            $totales->vlrPagar = 0;
            $totales->descuento = 0;
            $totales->save();

            $detalles = array();

            foreach ($datosFactura->conceptos as $concepto) {

                $conceptoObj = new Concepto();
                $conceptoObj->clave = $concepto->clave;
                $conceptoObj->cdgItem = $concepto->cdgItem;
                $conceptoObj->dscItem = $concepto->dscItem;
                $conceptoObj->unmdItem = $concepto->unmdItem;
                $conceptoObj->qtyItem = $concepto->qtyItem;
                $conceptoObj->montoNetoItem = $concepto->montoNetoItem;
                $conceptoObj->prcNetoItem = $concepto->prcNetoItem;
                $conceptoObj->descuento = $concepto->descuento;
                $conceptoObj->id_factura = $facturaObj->id_factura;
                $conceptoObj->save();

                foreach ($concepto->impuestosTrasladados as $impuesto) {

                    $impuestoObj = new ExImpuestos();
                    $impuestoObj->base = $impuesto->base;
                    $impuestoObj->factor = $impuesto->factor;
                    $impuestoObj->tipoImp = $impuesto->tipoImp;
                    $impuestoObj->tasaImp = $impuesto->tasaImp;
                    $impuestoObj->tipo = $impuesto->tipo;
                    $impuestoObj->montoImp = $impuesto->montoImp;
                    $impuestoObj->id_detalle = $conceptoObj->id_detalle;
                    $impuestoObj->save();
                }

                foreach ($concepto->impuestosRetenidos as $impuesto) {

                    $impuestoObj = new ExImpuestos();
                    $impuestoObj->base = $impuesto->base;
                    $impuestoObj->factor = $impuesto->factor;
                    $impuestoObj->tipoImp = $impuesto->tipoImp;
                    $impuestoObj->tasaImp = $impuesto->tasaImp;
                    $impuestoObj->tipo = $impuesto->tipo;
                    $impuestoObj->montoImp = $impuesto->montoImp;
                    $impuestoObj->id_detalle = $conceptoObj->id_detalle;
                    $impuestoObj->save();
                }
            }

            foreach ($datosFactura->facturasRelacionadas as $facturaRelacionada) {

                $facturaRelacionadaObj = new FacturasRelacionadas();
                $facturaRelacionadaObj->id_factura = $facturaObj->id_factura;
                $facturaRelacionadaObj->uuid = $facturaRelacionada->uuid;
                $facturaRelacionadaObj->save();

            }

            foreach ($datosFactura->pagos as $pago) {

                $pagoObj = new Pago();
                $pagoObj->FechaPago = $pago->FechaPago;
                $pagoObj->FormaDePagoP = $pago->FormaDePagoP;
                $pagoObj->MonedaP = $pago->MonedaP;
                $pagoObj->TipoCambioP = $pago->TipoCambioP;
                $pagoObj->Monto = $pago->Monto;
                $pagoObj->id_factura = $facturaObj->id_factura;
                $pagoObj->save();

                foreach ($pago->documentosRelacionado as $doctoRelacionado) {

                    $doctoRelacionadoObj = new DoctoRelacionado();
                    $doctoRelacionadoObj->IdDocumento = $doctoRelacionado->IdDocumento;
                    $doctoRelacionadoObj->MonedaDR = $doctoRelacionado->MonedaDR;
                    $doctoRelacionadoObj->TipoCambioDR = $doctoRelacionado->TipoCambioDR;
                    $doctoRelacionadoObj->MetodoDePagoDR = $doctoRelacionado->MetodoDePagoDR;
                    $doctoRelacionadoObj->NumParcialidad = $doctoRelacionado->NumParcialidad;
                    $doctoRelacionadoObj->ImpSaldoAnt = $doctoRelacionado->ImpSaldoAnt;
                    $doctoRelacionadoObj->ImpPagado = $doctoRelacionado->ImpPagado;
                    $doctoRelacionadoObj->ImpSaldoInsoluto = $doctoRelacionado->ImpSaldoInsoluto;
                    $doctoRelacionadoObj->id_pago = $pagoObj->id;
                    $doctoRelacionadoObj->save();


                    if ($doctoRelacionadoObj->ImpSaldoInsoluto <= 0) {

                        $idDocObj = IdDoc::where('uUID', '=', $doctoRelacionado->IdDocumento)->with('factura')->first();
                        $facturaIdDoc = $idDocObj->factura;
                        $facturaIdDoc->isPagado = 1;
                        $facturaIdDoc->save();

                    }
                }
            }


            $facturaResult = $datosFactura->serie . $datosFactura->folio;


        } else {

            $errorCode = 10001;
            $errorMsg = 'Hubo un error al crear su factura. Vuelva a intentarlo.';

            if (isset($resultado[6])) {

                $errorCode = $resultado[6];
                switch ($resultado[6]) {
                    case 330037:
                        $errorMsg = "Este RFC del receptor no existe en la lista de RFC inscritos no cancelados del SAT. Puede que su cliente tenga algún bloqueo.";
                        break;
                    case 330007:
                        $errorMsg = "Es necesario que agregue vaya a la sección de Mis Datos y actualice su régimen fiscal.";
                        break;
                    case 330171:
                        $errorMsg = "Se debe seleccionar un Uso de CFDI para realizar la factura.";
                        break;
                    case 305:
                        $errorMsg = "Su certificado de sellos digitales ha vencido, es necesario que genere uno nuevo en el portal del SAT.";
                        break;
                    default:
                        $errorMsg = $resultado[7];
                }
            }

            $errortext = $errorMsg;
        }


        return Response::json(array(
            'success' => $success,
            'errorCode' => $errorCode,
            'errortext' => $errortext,
            'facturaResult' => $facturaResult
        ));

    }


    public function getXML33(Request $request)
    {

        header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
        header("Cache-Control: post-check=0, pre-check=0", false);
        header("Pragma: no-cache");

        $id_proveedor = $request->input('id_proveedor');
        $id_factura = $request->input('id_factura');
        $token = $request->input('token');

        $proveedor = Proveedor::where('token', "=", $token)->where('id_proveedor', "=", $id_proveedor)->first();

        if (!is_object($proveedor) || empty ($token)) {
            return Response::json(array(
                'success' => false,
                'errorText' => 'Token incorrecto'
            ));
        }


        $datosFactura = Utils::obtenerDatosFactura($id_factura, $id_proveedor);

        $xml = null;
        if ($datosFactura->version == "4.0") {
            $xml = XMLUtils::createXML40($datosFactura, $proveedor);
        } else {
            $xml = XMLUtils::createXML33($datosFactura, null);
        }


        $fileName = $proveedor->rFCEmisor . date('YmdHis') . '.xml';

        file_put_contents("tmp/$fileName", $xml);

        return Response::download("tmp/$fileName", $fileName, ['Content-Type: text/xml']);

    }

    public function getPDF(Request $request)
    {

        $id_proveedor = $request->input('id_proveedor');
        $id_factura = $request->input('id_factura');
        $token = $request->input('token');

        $proveedor = Proveedor::with('domicilio')->where('token', "=", $token)->where('id_proveedor', "=", $id_proveedor)->first();

        if (!is_object($proveedor) || empty ($token)) {
            return Response::json(array(
                'success' => false,
                'errorText' => 'Token incorrecto'
            ));
        }

        $metodosDePago = array('' => '', 'PUE' => 'PUE - Pago en una sola exhibición', 'PPD' => 'PPD - Pago en parcialidades o diferido');
        $impuestos = array('001' => 'ISR', '002' => 'IVA', '003' => 'IEPS');
        $exportacion = array('01' => '01 No aplica', '02' => '02 Definitiva', '03' => '03 Temporal');


        $datosFactura = Utils::obtenerDatosFactura($id_factura, $id_proveedor);
        //print_r($datosFactura);

        if (trim($datosFactura->tipoFacturasRelacionadas) != '' || count($datosFactura->facturasRelacionadas) > 0) {

            $tipoRelaciones = array(
                '01' => 'Nota de crédito de los documentos relacionados',
                '02' => 'Nota de débito de los documentos relacionados',
                '03' => 'Devolución de mercancía sobre facturas o traslados previos',
                '04' => 'Sustitución de los CFDI previos',
                '05' => 'Traslados de mercancias facturados previamente',
                '06' => 'Factura generada por los traslados previos',
                '07' => 'CFDI por aplicación de anticipo'
            );

            if(trim($datosFactura->tipoFacturasRelacionadas) == ''){
                if(count($datosFactura->facturasRelacionadas) > 0){
                    foreach ($datosFactura->facturasRelacionadas as $facturasRelacionada){
                        $facturasRelacionada->label = $tipoRelaciones[$facturasRelacionada->tipoRelacion];
                    }
                }
            }else{
                $datosFactura->labelFacturasRelacionadas = $tipoRelaciones[$datosFactura->tipoFacturasRelacionadas];
            }
        }

        $clienteObj = Cliente::find($datosFactura->id_cliente);
        if (is_object($clienteObj))
            $datosFactura->direccionCliente = trim($clienteObj->direccion);

        if (isset($proveedor->domicilio)) {
            $datosFactura->direccionProveedor = trim($proveedor->domicilio->direccion);
        }


        $datosFactura->noFactura = str_pad($datosFactura->noFactura, 5, "0", STR_PAD_LEFT);
        $datosFactura->timeStamp = date_format(new \DateTime ($datosFactura->timeStamp), 'Y-m-d\TH:i:s');

        $datosFactura->usoCFDI = $datosFactura->usoCFDI;
        $usoCFDI = UsoCFDI::where('codigo', '=', $datosFactura->usoCFDI)->first();
        if (is_object($usoCFDI))
            $datosFactura->usoCFDI = "$usoCFDI->codigo - $usoCFDI->descripcion";

        if ($datosFactura->regimenFiscalReceptor != null && !empty($datosFactura->regimenFiscalReceptor)) {
            $regimenReceptor = CatalogoRegimenFiscal::where('code', '=', $datosFactura->regimenFiscalReceptor)->first();
            $datosFactura->regimenFiscalReceptor = "$regimenReceptor->code - $regimenReceptor->descripcion";
        }

        if ($datosFactura->exportacion != null && !empty($datosFactura->exportacion)) {
            $datosFactura->exportacion = $exportacion[$datosFactura->exportacion];
        }


        $regimenFiscal = CatalogoRegimenFiscal::where('code', '=', $datosFactura->regimenFiscal)->first();
        $datosFactura->regimenFiscal = $regimenFiscal->code . ' - ' . $regimenFiscal->descripcion;

        if ($datosFactura->formaPago != '') {
            $formaDePago = FormaPago::where('codigo', '=', $datosFactura->formaPago)->first();
            $datosFactura->formaPago = $formaDePago->codigo . ' - ' . $formaDePago->descripcion;
        }

        if ($datosFactura->metodoDePago != '') {
            $datosFactura->metodoDePago = $metodosDePago[$datosFactura->metodoDePago];
        }

        $datosFactura->total = Utils::formatNumber($datosFactura->total, $datosFactura->precission);

        $datosFactura->cantidadLetra = NumeroLetra::num2letras($datosFactura->total, false, false);

        $whole = floor($datosFactura->total);
        $datosFactura->decimales = $datosFactura->total - $whole;
        $datosFactura->decimales = ($datosFactura->decimales * 100);

        $datosFactura->decimales = number_format($datosFactura->decimales, 0, '.', ',');

        if ($datosFactura->decimales > 0 && $datosFactura->decimales < 10)
            $datosFactura->decimales = '0' . $datosFactura->decimales;


        $datosFactura->decimales = ($datosFactura->decimales < 10) ? '0' . $datosFactura->decimales : $datosFactura->decimales;

        $tiposDocumentos = [];
        $tiposDocumentos['I'] = 'I - Ingreso';
        $tiposDocumentos['E'] = 'E - Egreso';
        $tiposDocumentos['T'] = 'T - Traslado';
        $tiposDocumentos['P'] = 'P - Pago';
        $tiposDocumentos['N'] = 'N - Nómina';

        $tiposPDF = array('I' => 'FACTURA', 'E' => 'NOTA DE CRÉDITO');


        $adicionales = ['tipoDocumento' => $tiposDocumentos, 'impuestos' => $impuestos,
            'tipoHoras' => array('01' => 'Dobles', '02' => 'Triples', '03' => 'Simples'),
            'tiposPDF' => $tiposPDF,
            'tipoIncapacidad' => array('01' => 'Riesgo de trabajo', '02' => 'Enfermedad en general', '03' => 'Maternidad')
        ];

        $datosFactura->subtotal = Utils::formatNumber($datosFactura->subtotal, $datosFactura->precission);
        $datosFactura->imagen = env('DIR_LOGOS') . $proveedor->imagen;

        if (!file_exists($datosFactura->imagen) || is_dir($datosFactura->imagen)) {
            $datosFactura->base64 = '';
        } else {
            $type = pathinfo($datosFactura->imagen, PATHINFO_EXTENSION);
            $data = file_get_contents($datosFactura->imagen);
            $base64 = 'data:image/' . $type . ';base64,' . base64_encode($data);
            $datosFactura->base64 = $base64;
        }

        if ($id_proveedor == 1080 || $id_proveedor == 1089 || $id_proveedor == 1175) {
            $logoRecycling = env('DIR_LOGOS') . "recycling-sitma.png";
            $type = pathinfo($logoRecycling, PATHINFO_EXTENSION);
            $data2 = file_get_contents($logoRecycling);
            $base642 = 'data:image/' . $type . ';base64,' . base64_encode($data2);
            $datosFactura->base64Rec = $base642;
        }

        $datosFactura->color = $proveedor->color;

        if (count($datosFactura->pagos)) {
            $datosFactura->totalPagos = 0;
            foreach ($datosFactura->pagos as $pago) {
                $datosFactura->totalPagos += $pago->Monto;
                $pago->bancoName = '';
                $pago->emisorCtaBenName = '';

                $pago->FechaPago = new \DateTime ($pago->FechaPago);
                $pago->FechaPago = date_format($pago->FechaPago, 'Y-m-d\TH:i:s');

                if (!empty($pago->banco)) {
                    $bancop = Bancop::where('rfc', '=', $pago->banco)->first();
                    $pago->bancoName = $bancop->nombre;
                }

                if (!empty($pago->rfcEmisorCtaBen)) {
                    $bancop = Bancop::where('rfc', '=', $pago->rfcEmisorCtaBen)->first();
                    $pago->emisorCtaBenName = $bancop->nombre;
                }
            }
        }


        $total_factura = number_format($datosFactura->total, 6);
        $total_factura = str_replace(",", "", $total_factura);
        $total_factura = str_pad($total_factura, 17, "0", STR_PAD_LEFT);


        $datosFactura->qr = "https://verificacfdi.facturaelectronica.sat.gob.mx/default.aspx?id=$datosFactura->uUID&re=$datosFactura->rFCEmisor&rr=$datosFactura->rFCRecep&tt=$total_factura&fe=" . substr($datosFactura->sello, -8);

        $disenoFactura = 'pdf.diseno2';

        if (!empty($datosFactura->id_cartaPorte) && $datosFactura->id_cartaPorte > 0) {
            if ($proveedor->template33 != '') {
                $disenoFactura = 'pdf.carta' . $proveedor->template33;
            } else {
                $disenoFactura = 'pdf.cartaporte';
            }

        } else if ($datosFactura->tipoDeComprobante == 'P') {
            $disenoFactura = 'pdf.pago';
        } else if ($datosFactura->tipoDeComprobante == 'N') {
            $disenoFactura = 'pdf.nomina';
        } else if ($datosFactura->comercio != null) {
            $disenoFactura = 'pdf.comercio';
        } else if ($proveedor->template33 != '') {
            $disenoFactura = 'pdf.' . $proveedor->template33;
        }


        $html = view($disenoFactura, ['factura' => $datosFactura, 'adicionales' => $adicionales])->render();
        $fileName = $datosFactura->rFCEmisor . "-$datosFactura->serie$datosFactura->noFactura.pdf";
        $fullPath = 'tmp/' . $fileName;

        $domPDF = new Dompdf();
        $domPDF->loadHtml($html);
        $domPDF->render();
        $domPDF->stream($fullPath);

        /*header('Content-type: application/pdf');
		header('Content-Disposition: inline; filename="file.pdf"');
		header('Content-Transfer-Encoding: binary');
		header('Content-Length: ' . filesize($fullPath));
		header('Accept-Ranges: bytes');*/
        //readfile($fullPath);


    }

    public function obtenerEmailPorCliente(Request $request)
    {

        $id_cliente = $request->input('id_cliente');

        $email = '';
        $contacto = ContactoReceptor::find($id_cliente);
        if (is_object($contacto))
            $email = $contacto->email;

        return Response::json(array(
            'success' => true,
            'email' => $email
        ));

    }


    public function enviarFactura(Request $request)
    {

        $factura = $request->input('factura');
        $nota = $factura['nota'];
        $user = $request->input('user');
        $id_proveedor = $user['id_proveedor'];
        $id_factura = $factura['id_factura'];
        $email = $factura['email'];

        $metodosDePago = array('' => '', 'PUE' => 'PUE - Pago en una sola exhibición', 'PPD' => 'PPD - Pago en parcialidades o diferido');
        $impuestos = array('001' => 'ISR', '002' => 'IVA', '003' => 'IEPS');

        $proveedor = Proveedor::where('id_proveedor', "=", $id_proveedor)->first();

        $datosFactura = Utils::obtenerDatosFactura($id_factura, $id_proveedor);

        $xml = null;
        if ($datosFactura->version == "4.0") {
            $xml = XMLUtils::createXML40($datosFactura, $proveedor);
        } else {
            $xml = XMLUtils::createXML33($datosFactura, null);
        }

        $datosFactura->noFactura = str_pad($datosFactura->noFactura, 5, "0", STR_PAD_LEFT);
        $datosFactura->timeStamp = date_format(new \DateTime ($datosFactura->timeStamp), 'Y-m-d\TH:i:s');

        $usoCFDI = UsoCFDI::where('codigo', '=', $datosFactura->usoCFDI)->first();
        $datosFactura->usoCFDI = "$usoCFDI->codigo - $usoCFDI->descripcion";

        $regimenFiscal = CatalogoRegimenFiscal::where('code', '=', $datosFactura->regimenFiscal)->first();
        $datosFactura->regimenFiscal = $regimenFiscal->descripcion;

        if ($datosFactura->formaPago != '') {
            $formaDePago = FormaPago::where('codigo', '=', $datosFactura->formaPago)->first();
            $datosFactura->formaPago = $formaDePago->codigo . ' - ' . $formaDePago->descripcion;
        }

        $datosFactura->metodoDePago = $metodosDePago[$datosFactura->metodoDePago];
        $datosFactura->total = Utils::formatNumber($datosFactura->total, $datosFactura->precission);
        $datosFactura->cantidadLetra = NumeroLetra::num2letras($datosFactura->total, false, false);

        $whole = floor($datosFactura->total);
        $datosFactura->decimales = $datosFactura->total - $whole;
        $datosFactura->decimales = ($datosFactura->decimales < 10) ? '0' . $datosFactura->decimales : $datosFactura->decimales;

        $tiposDocumentos = [];
        $tiposDocumentos['I'] = 'Ingreso';
        $tiposDocumentos['E'] = 'Egreso';
        $tiposDocumentos['T'] = 'Traslado';
        $tiposDocumentos['P'] = 'Pago';
        $tiposDocumentos['N'] = 'Nómina';

        $adicionales = ['tipoDocumento' => $tiposDocumentos, 'impuestos' => $impuestos,
            'tipoHoras' => array('01' => 'Dobles', '02' => 'Triples', '03' => 'Simples'),
            'tipoIncapacidad' => array('01' => 'Riesgo de trabajo', '02' => 'Enfermedad en general', '03' => 'Maternidad')
        ];

        if (trim($datosFactura->tipoFacturasRelacionadas) != '' || count($datosFactura->facturasRelacionadas) > 0) {

            $tipoRelaciones = array(
                '01' => 'Nota de crédito de los documentos relacionados',
                '02' => 'Nota de débito de los documentos relacionados',
                '03' => 'Devolución de mercancía sobre facturas o traslados previos',
                '04' => 'Sustitución de los CFDI previos',
                '05' => 'Traslados de mercancias facturados previamente',
                '06' => 'Factura generada por los traslados previos',
                '07' => 'CFDI por aplicación de anticipo'
            );

            if(trim($datosFactura->tipoFacturasRelacionadas) == ''){
                if(count($datosFactura->facturasRelacionadas) > 0){
                    foreach ($datosFactura->facturasRelacionadas as $facturasRelacionada){
                        $facturasRelacionada->label = $tipoRelaciones[$facturasRelacionada->tipoRelacion];
                    }
                }
            }else{
                $datosFactura->labelFacturasRelacionadas = $tipoRelaciones[$datosFactura->tipoFacturasRelacionadas];
            }
        }

        $datosFactura->subtotal = Utils::formatNumber($datosFactura->subtotal, $datosFactura->precission);
        $datosFactura->total = Utils::formatNumber($datosFactura->total, $datosFactura->precission);
        $datosFactura->imagen = env('DIR_LOGOS') . $proveedor->imagen;
        $datosFactura->color = $proveedor->color;

        if (!file_exists($datosFactura->imagen) || is_dir($datosFactura->imagen)) {
            $datosFactura->base64 = '';
        } else {
            $type = pathinfo($datosFactura->imagen, PATHINFO_EXTENSION);
            $data = file_get_contents($datosFactura->imagen);
            $base64 = 'data:image/' . $type . ';base64,' . base64_encode($data);
            $datosFactura->base64 = $base64;
        }

        $total_factura = number_format($datosFactura->total, 6);
        $total_factura = str_replace(",", "", $total_factura);
        $total_factura = str_pad($total_factura, 17, "0", STR_PAD_LEFT);

        $datosFactura->qr = '?re=' . $datosFactura->rFCEmisor . '&rr=' . $datosFactura->rFCRecep . '&tt=' . $total_factura . '&id=' . $datosFactura->uUID;

        if (count($datosFactura->pagos)) {
            $datosFactura->totalPagos = 0;
            foreach ($datosFactura->pagos as $pago) {
                $datosFactura->totalPagos += $pago->Monto;
                $pago->bancoName = '';
                $pago->emisorCtaBenName = '';

                $pago->FechaPago = new \DateTime ($pago->FechaPago);
                $pago->FechaPago = date_format($pago->FechaPago, 'Y-m-d\TH:i:s');

                if (!empty($pago->banco)) {
                    $bancop = Bancop::where('rfc', '=', $pago->banco)->first();
                    $pago->bancoName = $bancop->nombre;
                }

                if (!empty($pago->rfcEmisorCtaBen)) {
                    $bancop = Bancop::where('rfc', '=', $pago->rfcEmisorCtaBen)->first();
                    $pago->emisorCtaBenName = $bancop->nombre;
                }
            }
            $datosFactura->totalPagos = $datosFactura->totalPagos;
        }

        $disenoFactura = 'pdf.diseno2';
        if (!empty($datosFactura->id_cartaPorte) && $datosFactura->id_cartaPorte > 0) {
            if ($proveedor->template33 != '') {
                $disenoFactura = 'pdf.carta' . $proveedor->template33;
            } else {
                $disenoFactura = 'pdf.cartaporte';
            }
        } else if ($datosFactura->tipoDeComprobante == 'P') {
            $disenoFactura = 'pdf.pago';
        } else if ($datosFactura->tipoDeComprobante == 'N') {
            $disenoFactura = 'pdf.nomina';
        } else if ($proveedor->template33 != '') {
            $disenoFactura = 'pdf.' . $proveedor->template33;
        }

        $html = view($disenoFactura, ['factura' => $datosFactura, 'adicionales' => $adicionales])->render();

        $fileName = $datosFactura->rFCEmisor . date('YmdHis') . "-$datosFactura->serie$datosFactura->noFactura";

        $domPDF = new Dompdf();
        $domPDF->loadHtml($html);
        $domPDF->render();
        $outputPDF = $domPDF->output();

        file_put_contents("tmp/$fileName.pdf", $outputPDF);
        file_put_contents("tmp/$fileName.xml", $xml);

        $dataEmail = array(
            'nombreEmisor' => $datosFactura->nmbEmisor,
            'rFCEmisor' => $datosFactura->rFCEmisor,
            'imagen' => $datosFactura->imagen,
            'email' => $email,
            'fecha' => $datosFactura->fechaEmis,
            'pdfFile' => "tmp/$fileName.pdf",
            'xmlFile' => "tmp/$fileName.xml",
            'nota' => $nota
        );


        Mail::send('emails.factura', $dataEmail, function ($message) use ($dataEmail) {
            $message->from('noreply@soliat.com', $dataEmail['nombreEmisor']);
            $message->to($dataEmail['email']);
            $message->subject("Envío de comprobante CFDI");
            $message->attach($dataEmail['pdfFile']);
            $message->attach($dataEmail['xmlFile']);
        });


        return Response::json(array(
            'success' => true
        ));

    }

    public function cancelarFactura(Request $request)
    {

        $factura = $request->input('factura');
        $user = $request->input('user');

        $proveedor = Proveedor::where('password', '=', $factura['password'])->where('rFCEmisor', '=', $user['rfc'])->first();

        $passCorrecto = false;
        $seraCancelado = false;

        if (is_object($proveedor)) {

            $urlTimbrado = "https://timbracfdi33.mx:1443/Timbrado.asmx?wsdl";
            $usuarioIntegrador = "vb9+kzunCtCXL+WQEvBsCQ==";

            if ($proveedor->id_proveedor == 17) {

                $urlTimbrado = "https://cfdi33-pruebas.buzoncfdi.mx:1443/Timbrado.asmx?wsdl";
                $usuarioIntegrador = "mvpNUXmQfK8=";

            }

            $params = array();
            $params['usuarioIntegrador'] = $usuarioIntegrador;
            $params['rfcEmisor'] = $proveedor->rFCEmisor;
            $params['folioUUID'] = $factura['uUID'];


            $client = new SoapClient($urlTimbrado, array('encoding' => 'UTF-8', "connection_timeout" => 250));
            $client->soap_defencoding = "UTF-8";
            $result = $client->__soapCall('CancelaCFDI', array('parameters' => $params));

            $resultado = $result->CancelaCFDIResult->anyType;

            $seraCancelado = false;
            if ($resultado[1] == 0) {
                $seraCancelado = true;
                Factura::where('id_factura', '=', $factura['id_factura'])->update(['status' => 0]);
            }

            $passCorrecto = true;

        }

        return Response::json(array(
            'success' => true,
            'passCorrecto' => $passCorrecto,
            'seraCancelado' => $seraCancelado,
            'result' => $result
        ));
    }


    public function verVistaPreviaFactura(Request $request)
    {

        $user = $request->input('user');
        $id_proveedor = $user['id_proveedor'];
        $id_factura = $request->input('id_factura');

        $metodosDePago = array('' => '', 'PUE' => 'PUE - Pago en una sola exhibición', 'PPD' => 'PPD - Pago en parcialidades o diferido');
        $impuestos = array('001' => 'ISR', '002' => 'IVA', '003' => 'IEPS');

        $proveedor = Proveedor::where('id_proveedor', "=", $id_proveedor)->first();

        $datosFactura = Utils::obtenerDatosFactura($id_factura, $id_proveedor);

        $datosFactura->noFactura = str_pad($datosFactura->noFactura, 5, "0", STR_PAD_LEFT);
        $datosFactura->timeStamp = date_format(new \DateTime ($datosFactura->timeStamp), 'Y-m-d\TH:i:s');

        $usoCFDI = UsoCFDI::where('codigo', '=', $datosFactura->usoCFDI)->first();
        $datosFactura->usoCFDI = "$usoCFDI->codigo - $usoCFDI->descripcion";

        $regimenFiscal = CatalogoRegimenFiscal::where('code', '=', $datosFactura->regimenFiscal)->first();
        $datosFactura->regimenFiscal = $regimenFiscal->descripcion;

        if ($datosFactura->formaPago != '') {
            $formaDePago = FormaPago::where('codigo', '=', $datosFactura->formaPago)->first();
            $datosFactura->formaPago = $formaDePago->codigo . ' - ' . $formaDePago->descripcion;
        }

        if ($datosFactura->metodoDePago != '') {
            $datosFactura->metodoDePago = $metodosDePago[$datosFactura->metodoDePago];
        }

        $datosFactura->total = Utils::formatNumber($datosFactura->total, $datosFactura->precission);

        $datosFactura->cantidadLetra = NumeroLetra::num2letras($datosFactura->total, false, false);

        $whole = floor($datosFactura->total);
        $datosFactura->decimales = $datosFactura->total - $whole;
        $datosFactura->decimales = ($datosFactura->decimales < 10) ? '0' . $datosFactura->decimales : $datosFactura->decimales;

        $tiposDocumentos = [];
        $tiposDocumentos['I'] = 'Ingreso';
        $tiposDocumentos['E'] = 'Egreso';
        $tiposDocumentos['T'] = 'Traslado';
        $tiposDocumentos['P'] = 'Pago';

        $adicionales = ['tipoDocumento' => $tiposDocumentos, 'impuestos' => $impuestos];

        $datosFactura->subtotal = Utils::formatNumber($datosFactura->subtotal, $datosFactura->precission);
        $datosFactura->total = Utils::formatNumber($datosFactura->total, $datosFactura->precission);
        $datosFactura->imagen = env('DIR_LOGOS') . $proveedor->imagen;
        $datosFactura->color = $proveedor->color;

        if (!file_exists($datosFactura->imagen) || is_dir($datosFactura->imagen)) {
            $datosFactura->base64 = '';
        } else {
            $type = pathinfo($datosFactura->imagen, PATHINFO_EXTENSION);
            $data = file_get_contents($datosFactura->imagen);
            $base64 = 'data:image/' . $type . ';base64,' . base64_encode($data);
            $datosFactura->base64 = $base64;
        }

        if (count($datosFactura->pagos)) {
            $datosFactura->totalPagos = 0;
            foreach ($datosFactura->pagos as $pago) {
                $datosFactura->totalPagos += $pago->Monto;

                $pago->FechaPago = new \DateTime ($pago->FechaPago);
                $pago->FechaPago = date_format($pago->FechaPago, 'Y-m-d\TH:i:s');
            }
            $datosFactura->totalPagos = $datosFactura->totalPagos;
        }

        $template = 'pdf.preview';
        if ($datosFactura->tipoDeComprobante == 'P')
            $template = 'pdf.previewpago';


        $total_factura = number_format($datosFactura->total, 6);
        $total_factura = str_replace(",", "", $total_factura);
        $total_factura = str_pad($total_factura, 17, "0", STR_PAD_LEFT);

        $datosFactura->qr = '?re=' . $datosFactura->rFCEmisor . '&rr=' . $datosFactura->rFCRecep . '&tt=' . $total_factura . '&id=' . $datosFactura->uUID;

        $html = view($template, ['factura' => $datosFactura, 'adicionales' => $adicionales])->render();

        return Response::json(array(
            'success' => true,
            'html' => $html
        ));

    }


    public function obtenerFacturasPorCliente(Request $request)
    {

        $rFCRecep = $request->input('rFCRecep');
        $user = $request->input('user');

        $facturas = Factura::with('iddoc', 'totales')
            ->where('id_proveedor', '=', $user['id_proveedor'])
            ->where('rFCRecep', $rFCRecep)->where('status', '=', 1)
            ->where('isPagado', '=', 0)->where('tipoDeComprobante', '=', 'I')->get();

        if (is_object($facturas))
            $facturas = $facturas->toArray();

        return Response::json(array(
            'success' => true,
            'facturas' => $facturas
        ));
    }

    public function obtenerAbonosFactura(Request $request)
    {

        $uuid = $request->input('uuid');

        $pagosADocumentos = DoctoRelacionado::with('pago')->where('IdDocumento', '=', $uuid)->get();
        $idDocObj = IdDoc::where('uUID', '=', $uuid)->first();

        $importePagado = 0;
        $noPago = 0;
        if (count($pagosADocumentos) > 0)
            foreach ($pagosADocumentos as $documento) {

                $importePagado += $documento->ImpPagado;
                $noPago++;

            }

        $noPago++;


        $conceptosObj = Concepto::with('impuestos')->where('id_factura', '=', $idDocObj->id_factura)->get();

        $impuestosEnFactura = array();
        $impuestosTrasladados = array();
        $impuestosRetenidos = array();

        $tieneImpuestos = !(count($conceptosObj[0]->impuestos) == 0);
        if ($tieneImpuestos) {

            foreach ($conceptosObj as $conceptoObj) {
                if (count($conceptoObj->impuestos) > 0)
                    foreach ($conceptoObj->impuestos as $impuestoObj) {

                        if($impuestoObj->tipoImp == '001' || $impuestoObj->tipoImp == '002' || $impuestoObj->tipoImp == '003') {

                            $existImpuesto = false;

                            if (count($impuestosEnFactura) > 0){
                                for($i = 0; $i < count($impuestosEnFactura); $i++){
                                    if ($impuestosEnFactura[$i]['factor'] == $impuestoObj->factor &&
                                        $impuestosEnFactura[$i]['tipoImp'] == $impuestoObj->tipoImp &&
                                        $impuestosEnFactura[$i]['tasaImp'] == $impuestoObj->tasaImp &&
                                        $impuestosEnFactura[$i]['tipo'] == $impuestoObj->tipo) {
                                        $impuestosEnFactura[$i]['base'] += $impuestoObj->base;
                                        $impuestosEnFactura[$i]['montoImp'] += $impuestoObj->montoImp;
                                        $existImpuesto = true;
                                        break;
                                    }
                                }
                            }

                            if(!$existImpuesto){
                                $impuestosEnFactura[] = array(
                                    'factor' => $impuestoObj->factor,
                                    'tipoImp' => $impuestoObj->tipoImp,
                                    'tasaImp' => $impuestoObj->tasaImp,
                                    'tipo' => $impuestoObj->tipo,
                                    'base' =>  $impuestoObj->base,
                                    'montoImp' =>  $impuestoObj->montoImp,
                                );;
                            }
                        }
                    }
            }

            foreach ($impuestosEnFactura as $impuesto){
                if($impuesto['tipo'] == 0){
                    $impuestosRetenidos[] = $impuesto;
                }else{
                    $impuestosTrasladados [] = $impuesto;
                }
            }
        }


        return Response::json(array(
            'success' => true,
            'importePagado' => $importePagado,
            'noPago' => $noPago,
            'tieneImpuestos' => $tieneImpuestos,
            'conceptosObj' => $conceptosObj,
            'impuestosEnFactura' => array('impuestosRetenidos' => $impuestosRetenidos, 'impuestosTrasladados' => $impuestosTrasladados)
        ));

    }

    public function obtenerFacturaPago(Request $request)
    {

        $id_factura = $request->input('id_factura');

        $factura = Factura::with('iddoc', 'totales')->where('id_factura', '=', $id_factura)->first();
        $conceptosObj = Concepto::with('impuestos')->where('id_factura', '=', $id_factura)->get();

        $pagosADocumentos = DoctoRelacionado::with('pago.factura')->where('IdDocumento', '=', $factura->iddoc->uUID)->get();

        $importePagado = 0;
        $noPago = 0;
        $arrayDoctosRelacionados = array();
        if (count($pagosADocumentos) > 0)
            foreach ($pagosADocumentos as $documento) {
                if ($documento->pago->factura->status == 1) {
                    $arrayDoctosRelacionados [] = $documento->id;
                    $importePagado += $documento->ImpPagado;
                    $noPago++;
                }
            }

        $noPago++;

        $factura->importePagado = $importePagado;
        $factura->noPago = $noPago;

        $impuestosEnFactura = array();
        $impuestosTrasladados = array();
        $impuestosRetenidos = array();

        $tieneImpuestos = !(count($conceptosObj[0]->impuestos) == 0);
        if ($tieneImpuestos) {

            foreach ($conceptosObj as $conceptoObj) {
                if (count($conceptoObj->impuestos) > 0)
                    foreach ($conceptoObj->impuestos as $impuestoObj) {

                        if($impuestoObj->tipoImp == '001' || $impuestoObj->tipoImp == '002' || $impuestoObj->tipoImp == '003') {

                            $existImpuesto = false;

                            if (count($impuestosEnFactura) > 0){
                                for($i = 0; $i < count($impuestosEnFactura); $i++){
                                    if ($impuestosEnFactura[$i]['factor'] == $impuestoObj->factor &&
                                        $impuestosEnFactura[$i]['tipoImp'] == $impuestoObj->tipoImp &&
                                        $impuestosEnFactura[$i]['tasaImp'] == $impuestoObj->tasaImp &&
                                        $impuestosEnFactura[$i]['tipo'] == $impuestoObj->tipo) {

                                        $impuestosEnFactura[$i]['base'] += $impuestoObj->base;

                                        if($impuestosEnFactura[$i]['factor'] == 'Tasa'){
                                            $impuestosEnFactura[$i]['montoImp'] = Utils::formatNumber($impuestosEnFactura[$i]['base'] * $impuestosEnFactura[$i]['tasaImp']);
                                        }else{
                                            $impuestosEnFactura[$i]['montoImp'] += $impuestoObj->montoImp;
                                        }

                                        $existImpuesto = true;
                                        break;
                                    }
                                }
                            }

                            if(!$existImpuesto){



                                $impuestosDROthers = ImpuestosDR::where('impuesto', '=', $impuestoObj->tipoImp)
                                    ->where('tipoFactor', '=', $impuestoObj->factor)
                                    ->whereIn('id_doctoRelacionado', $arrayDoctosRelacionados)
                                    ->get();

                                $sumBase = 0;
                                $sumImporte = 0;
                                //print_r($impuestosDROthers->toArray());
                                foreach ($impuestosDROthers as $impuestoDROther) {
                                    if((float)$impuestoDROther->tasaCuota == (float)$impuestoObj->tasaImp){
                                        $sumBase += $impuestoDROther->base;
                                        $sumImporte += $impuestoDROther->importe;
                                    }
                                }

                                $impuestoObj->base -= $sumBase;
                                $impuestoObj->montoImp -= $sumImporte;

                                //echo "Base: $sumBase - Importe: $sumImporte <br>";

                                $impuestosEnFactura[] = array(
                                    'factor' => $impuestoObj->factor,
                                    'tipoImp' => $impuestoObj->tipoImp,
                                    'tasaImp' => $impuestoObj->tasaImp,
                                    'tipo' => $impuestoObj->tipo,
                                    'base' =>  $impuestoObj->base,
                                    'montoImp' =>  $impuestoObj->montoImp,
                                );;
                            }
                        }
                    }
            }

            foreach ($impuestosEnFactura as $impuesto){
                if($impuesto['tipo'] == 0){
                    $impuestosRetenidos[] = $impuesto;
                }else{
                    $impuestosTrasladados [] = $impuesto;
                }
            }
        }



        return Response::json(array(
            'success' => true,
            'factura' => $factura->toArray(),
            'tieneImpuestos' => $tieneImpuestos,
            'impuestosEnFactura' => array('impuestosRetenidos' => $impuestosRetenidos, 'impuestosTrasladados' => $impuestosTrasladados)
        ));

    }


    public function exportToExcelReport(Request $request)
    {


        $fechaInicial = $request->input('fechaInicial') . ' 00:00:00';
        $fechaFinal = $request->input('fechaFinal') . ' 23:59:59';
        $rfc = $request->input('rfcExc');
        $estatusDocumento = $request->input('estatusDocumento');
        $id_proveedor = $request->input('id_proveedorExc');
        $token = $request->input('tokenExc');
        $tipoDocumento = $request->input('tipoDocumento');
        $rfcBusquedaExc = $request->input('rfcBusquedaExc');


        $proveedor = Proveedor::where('token', "=", $token)->where('id_proveedor', "=", $id_proveedor)->first();

        if (!is_object($proveedor) || empty ($token)) {
            return Response::json(array(
                'success' => false,
                'errorText' => 'Token incorrecto'
            ));
        }

        $nombreMeses = array('', 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');


        $query = "SELECT f.id_factura AS id_factura, f.timeStamp AS timeStamp, f.nmbRecep AS nmbRecep, f.noFactura AS noFactura, f.generadoPor AS generadoPor, f.tipo AS tipo, t.vlrPagar AS vlrPagar, i.serie AS serie, t.descuento,
	i.uUID AS uUID, f.nmbEmisor AS nmbEmisor, f.rFCEmisor AS rFCEmisor, f.nmbRecep AS nmbRecep, f.rFCRecep AS rFCRecep, f.noFactura AS noFactura, i.fechaTimbrado as fechaTimbrado, t.subTotal AS subTotal, i.metodoDePago AS metodoDePago
	FROM Factura f
		LEFT JOIN Totales t ON t.id_factura = f.id_factura
		LEFT JOIN IdDoc i ON i.id_factura = f.id_factura
		WHERE f.status = $estatusDocumento AND f.id_proveedor = $id_proveedor AND timeStamp BETWEEN '$fechaInicial' AND '$fechaFinal' AND f.rFCRecep LIKE '%$rfcBusquedaExc%'
		ORDER BY id_factura DESC";
        $listaFactura = DB::select($query);

        // Create new PHPExcel object
        $objPHPExcel = new Spreadsheet();

        // Set document properties

        $newSheet = 0;
        $sheetNo = 0;
        $row = 3;
        $anio = "";
        $mes = "";
        $ivaRetTotal = $isrRetTotal = $ivaTrasTotal = $iepsTotal = $retLocalTotal = $trasLocalTotal = $subTotalGral = $totalTotal = $descuento = 0;

        if (count($listaFactura) > 0)
            foreach ($listaFactura as $index => $factura) {

                $conceptoPrint = "";

                $conceptos = Concepto::with('impuestos')->where('id_factura', '=', $factura->id_factura)->get();

                $ivaRet = $isrRet = $ivaTras = $ieps = $retLocal = $trasLocal = 0;
                foreach ($conceptos as $concepto) {

                    $conceptoPrint .= $concepto->dscItem . "|";

                    $impuestos = $concepto->impuestos;
                    if (count($impuestos) > 0)
                        foreach ($impuestos as $impuesto) {
                            //Retenciones
                            if ($impuesto->tipo == 0) {
                                if ($impuesto->tipoImp == "002") {
                                    $ivaRet += $impuesto->montoImp;
                                } else if ($impuesto->tipoImp == "001") {
                                    $isrRet += $impuesto->montoImp;
                                } else {
                                    $retLocal += $impuesto->montoImp;
                                }
                            } else {
                                //Traslados
                                if ($impuesto->tipoImp == "002") {
                                    $ivaTras += $impuesto->montoImp;
                                } else if ($impuesto->tipoImp == "003") {
                                    $ieps += $impuesto->montoImp;
                                } else {
                                    $trasLocal += $impuesto->montoImp;
                                }
                            }
                        }
                }


                //SUMA de totales
                $ivaRetTotal += $ivaRet;
                $isrRetTotal += $isrRet;
                $retLocalTotal += $retLocal;
                $ivaTrasTotal += $ivaTras;
                $iepsTotal += $ieps;
                $trasLocalTotal += $trasLocal;
                $subTotalGral += $factura->subTotal;
                $totalTotal += $factura->vlrPagar;
                $descuento += $factura->descuento;

                $fechaArray = explode("-", $factura->timeStamp);

                if ($fechaArray[1] != $mes) {

                    $sheetNo = $newSheet;

                    $anio = $fechaArray[0];
                    $mes = $fechaArray[1];
                    $row = 3;

                    //Creating new sheets
                    $objPHPExcel->createSheet($newSheet);
                    $objPHPExcel->setActiveSheetIndex($newSheet);

                    // Adding headers to sheet
                    $objPHPExcel->setActiveSheetIndex($sheetNo)
                        ->setCellValue('A1', $nombreMeses[intval($mes)] . " $anio")
                        ->setCellValue('A2', 'Serie')
                        ->setCellValue('B2', 'No. Factura')
                        ->setCellValue('C2', 'RFC Emisor')
                        ->setCellValue('D2', 'Nombre Emisor')
                        ->setCellValue('E2', 'Fecha emisión')
                        ->setCellValue('F2', 'Fecha timbrado')
                        ->setCellValue('G2', 'Tipo')
                        ->setCellValue('H2', 'Folios fiscal')
                        ->setCellValue('I2', 'Subtotal')
                        ->setCellValue('J2', 'Descuento')
                        ->setCellValue('K2', 'IVA retenido')
                        ->setCellValue('L2', 'IVA trasladado')
                        ->setCellValue('M2', 'ISR')
                        ->setCellValue('N2', 'IEPS')
                        ->setCellValue('O2', 'Ret. Loc.')
                        ->setCellValue('P2', 'Tras. Loc.')
                        ->setCellValue('Q2', 'Total')
                        ->setCellValue('R2', 'Método de pago')
                        ->setCellValue('S2', 'Conceptos');

                    $objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setBold(true)->setSize(15);
                    $objPHPExcel->getActiveSheet()->getStyle('A2:S2')->getFont()->setBold(true);
                    $objPHPExcel->getActiveSheet()->setTitle($nombreMeses[intval($mes)] . " $anio");

                    for ($col = 'A'; $col !== 'S'; $col++) {
                        $objPHPExcel->getActiveSheet()
                            ->getColumnDimension($col)
                            ->setAutoSize(true);
                    }

                    $newSheet++;
                }

                $objPHPExcel->setActiveSheetIndex($sheetNo)
                    ->setCellValue("A$row", $factura->serie)
                    ->setCellValue("B$row", $factura->noFactura)
                    ->setCellValue("C$row", $factura->rFCRecep)
                    ->setCellValue("D$row", $factura->nmbRecep)
                    ->setCellValue("E$row", $factura->timeStamp)
                    ->setCellValue("F$row", $factura->fechaTimbrado)
                    ->setCellValue("G$row", $factura->tipo)
                    ->setCellValue("H$row", $factura->uUID)
                    ->setCellValue("I$row", $factura->subTotal)
                    ->setCellValue("J$row", $factura->descuento)
                    ->setCellValue("K$row", Utils::formatNumber($ivaRet))
                    ->setCellValue("L$row", Utils::formatNumber($ivaTras))
                    ->setCellValue("M$row", Utils::formatNumber($isrRet))
                    ->setCellValue("N$row", Utils::formatNumber($ieps))
                    ->setCellValue("O$row", Utils::formatNumber($retLocal))
                    ->setCellValue("P$row", Utils::formatNumber($trasLocal))
                    ->setCellValue("Q$row", $factura->vlrPagar)
                    ->setCellValue("R$row", $factura->metodoDePago)
                    ->setCellValue("S$row", $conceptoPrint);

                $row++;

                if (isset($listaFactura[$index + 1]))
                    $fechaArrayTemp = explode("-", $listaFactura[$index + 1]->timeStamp);
                else
                    $fechaArrayTemp = '';

                if ($fechaArrayTemp != '' && $fechaArrayTemp[1] != $mes) {

                    $objPHPExcel->setActiveSheetIndex($sheetNo)
                        ->setCellValue("I$row", $subTotalGral)
                        ->setCellValue("J$row", $descuento)
                        ->setCellValue("K$row", Utils::formatNumber($ivaRetTotal))
                        ->setCellValue("L$row", Utils::formatNumber($ivaTrasTotal))
                        ->setCellValue("M$row", Utils::formatNumber($isrRetTotal))
                        ->setCellValue("N$row", Utils::formatNumber($iepsTotal))
                        ->setCellValue("O$row", Utils::formatNumber($retLocalTotal))
                        ->setCellValue("P$row", Utils::formatNumber($trasLocalTotal))
                        ->setCellValue("Q$row", $totalTotal);
                    $objPHPExcel->getActiveSheet()->getStyle("A$row:R$row")->getFont()->setBold(true);

                    $ivaRetTotal = $isrRetTotal = $ivaTrasTotal = $iepsTotal = $retLocalTotal = $trasLocalTotal = $subTotalGral = $totalTotal = 0;

                }

            }


        $fileName = $rfc . "-reporte.xlsx";

        $writer = new Xlsx($objPHPExcel);
        $writer->save(public_path('tmp2') . "/$fileName");

        return response()->download(public_path('tmp2') . "/$fileName");
    }


    public function cancelarFacturaTest()
    {

        $urlTimbrado = "https://www.timbracfdi.mx/servicioIntegracion/Timbrado.asmx?wsdl";
        $usuarioIntegrador = "vb9+kzunCtCXL+WQEvBsCQ==";

        $params = array();
        $params['usuarioIntegrador'] = $usuarioIntegrador;
        $params['rfcEmisor'] = 'SIN061003E25';
        $params['folioUUID'] = '70431966-6fa8-4b84-8b1f-fe9842690e1a';


        $client = new SoapClient($urlTimbrado, array('encoding' => 'UTF-8', "connection_timeout" => 250));
        $client->soap_defencoding = "UTF-8";
        $result = $client->__soapCall('CancelaCFDI', array('parameters' => $params));

        $resultado = $result->CancelaCFDIResult->anyType;

        print_r($result);

    }


    public function obtenerEstados(Request $request)
    {

        $pais = $request->input('pais');

        $estados = Estado::where('pais', '=', $pais)->get();

        return Response::json(array(
            'success' => true,
            'estados' => $estados->toArray()
        ));

    }

    public function obtenerMunicipios(Request $request)
    {

        $estado = $request->input('estado');

        $municipios = Municipio::where('estado', '=', $estado)->get();

        return Response::json(array(
            'success' => true,
            'municipios' => $municipios->toArray()
        ));

    }

    public function facturasPorRelacionar(Request $request)
    {

        $user = $request->input('user');

        $fromDate = date('Y-m-d H:i:s', strtotime('-10 month'));
        $toDate = date('Y-m-d 23:00:00');

        $facturas = DB::select("SELECT i.serie, i.uUID, f.noFactura, f.rFCRecep
                        FROM Factura f JOIN IdDoc i ON f.id_factura = i.id_factura
                        WHERE timeStamp BETWEEN '$fromDate' AND '$toDate' AND id_proveedor = " . $user['id_proveedor']);


        return Response::json(array(
            'success' => true,
            'facturasPorRelacionar' => $facturas
        ));

    }

    public function getEstados(Request $request)
    {

        $country = $request->input('country');
        $catEstados = CatalogoEstado::where('status', '=', 1)->where('country', '=', $country)->get();

        return Response::json(array(
            'success' => true,
            'estados' => $catEstados
        ));
    }

    public function getMunicipio(Request $request)
    {

        DB::statement("SET NAMES 'utf8'");

        $estado = $request->input('estado');
        $catMunicipio = CatalogoMunicipio::where('status', '=', 1)->where('estado', '=', $estado)->get();

        return Response::json(array(
            'success' => true,
            'municipios' => $catMunicipio
        ));
    }

    public function getProducts(Request $request)
    {

        $user = $request->input('user');
        $searchText = $request->input('searchText');

        $productosObj = Producto::where('id_proveedor', '=', $user['id_proveedor'])
            ->where('status', '=', 1)
            ->get();

        return Response::json(array(
            'success' => true,
            'productos' => $productosObj->toArray()
        ));
    }


    public function importarXML()
    {

        $xmlFilePath = public_path('tempXML.xml');
        // Cargar el XML
        $xml = \simplexml_load_file(
            $xmlFilePath,
            'SimpleXMLElement',
            LIBXML_NSCLEAN | LIBXML_NOERROR | LIBXML_NOWARNING
        );
        if (! $xml) {
            throw new \Exception("No se pudo parsear el XML: " . implode(", ", libxml_get_errors()));
        }

        // Registrar namespaces para poder usar xpath con prefijos
        $xml->registerXPathNamespace('cfdi', 'http://www.sat.gob.mx/cfd/4.0');
        $xml->registerXPathNamespace('tfd',  'http://www.sat.gob.mx/TimbreFiscalDigital');
        $xml->registerXPathNamespace('cce20','http://www.sat.gob.mx/ComercioExterior20');

        try {
            DB::beginTransaction();

            // 1) Proveedor
            $emisorNode = $xml->xpath('//cfdi:Emisor')[0];
            $rfcEmisor   = (string) $emisorNode['Rfc'];
            $proveedor   = Proveedor::where('rFCEmisor', $rfcEmisor)->firstOrFail();

            // 2) CertificadoProveedor
            $noCertificado = (string) $xml['NoCertificado'];
            $certificado   = CertificadoProveedor::where('id_proveedor', $proveedor->id_proveedor)
                ->where('noCertificado', $noCertificado)
                ->where('status', 1)
                ->firstOrFail();

            // 3) Factura
            $factura = new Factura();
            $factura->id_proveedor            = $proveedor->id_proveedor;
            $factura->id_cliente              = 0;
            $factura->id_certificadoProveedor = $certificado->id;
            $factura->nmbEmisor               = (string) $emisorNode['Nombre'];
            $factura->rFCEmisor               = $rfcEmisor;

            $receptorNode = $xml->xpath('//cfdi:Receptor')[0];
            $factura->nmbRecep                = (string) $receptorNode['Nombre'];
            $factura->rFCRecep                = (string) $receptorNode['Rfc'];
            $factura->pais                    = (string) ($receptorNode['ResidenciaFiscal'] ?? $receptorNode['Pais']);
            $factura->regimenFiscal           = $proveedor->regimenFiscal33;

            // Fecha emisión
            $fechaAttr = (string) $xml['Fecha'];
            $factura->timeStamp = $fechaAttr;

            $factura->noFactura           = (string) $xml['Folio'];
            $factura->version             = (string) $xml['Version'];
            $factura->generadoPor         = 4;
            $factura->tipoDeComprobante   = (string) $xml['TipoDeComprobante'];

            // Precisión de decimales
            $sub = (string) $xml['SubTotal'];
            $factura->precission = strpos($sub, '.') !== false
                ? strlen(explode('.', $sub)[1])
                : 0;

            $factura->exportacion             = (string) $xml['Exportacion'];
            $factura->status                  = 1;
            $factura->isPagado                = ((string) $xml['MetodoPago'] === 'PUE') ? 1 : 0;
            $factura->regimenFiscalReceptor   = (string) $receptorNode['RegimenFiscalReceptor'];
            $factura->domicilioFiscalReceptor = (string) $receptorNode['DomicilioFiscalReceptor'];
            $factura->numRegIdTrib            = (string) $receptorNode['NumRegIdTrib'];
            $factura->save();

            // 4) IdDoc (TimbreFiscalDigital)
            $idDoc = new IdDoc();
            $idDoc->id_factura           = $factura->id_factura;
            $idDoc->serie                = (string) $xml['Serie'];
            $idDoc->folio                = (string) $xml['Folio'];
            $idDoc->formaPago            = (string) $xml['FormaPago'];
            $idDoc->condicionesDePago    = (string) ($xml['CondicionesDePago'] ?? '');
            $idDoc->lugarExpedicion      = (string) $xml['LugarExpedicion'];
            $idDoc->usoCFDI              = (string) $xml['UsoCFDI'];
            $idDoc->metodoDePago         = (string) $xml['MetodoPago'];
            $idDoc->sello                = (string) $xml['Sello'];

            $tfdNode = $xml->xpath('//tfd:TimbreFiscalDigital')[0];
            $idDoc->version         = (string) $tfdNode['Version'];
            $idDoc->fechaTimbrado   = (string) $tfdNode['FechaTimbrado'];
            $idDoc->selloCFD        = (string) $tfdNode['SelloCFD'];
            $idDoc->noCertificadoSAT= (string) $tfdNode['NoCertificadoSAT'];
            $idDoc->selloSAT        = (string) $tfdNode['SelloSAT'];
            $idDoc->uUID            = (string) $tfdNode['UUID'];
            $idDoc->rfcProvCertif   = (string) $tfdNode['RfcProvCertif'];
            $idDoc->save();

            // 5) Totales
            $totales = new Totales();
            $totales->id_factura = $factura->id_factura;
            $totales->moneda     = (string) $xml['Moneda'];
            $totales->tipoCambio = (string) $xml['TipoCambio'];
            $totales->subTotal   = (string) $xml['SubTotal'];
            $totales->mntBase    = (string) $xml['SubTotal'];
            $totales->vlrPagar   = (string) $xml['Total'];
            $totales->descuento  = (string) ($xml['Descuento'] ?? 0);
            $totales->pesoTotal  = 0;
            $totales->save();

            // 6) Conceptos
            foreach ($xml->xpath('//cfdi:Conceptos/cfdi:Concepto') as $n) {
                $c = new Concepto();
                $c->id_factura    = $factura->id_factura;
                $c->clave         = (string) $n['ClaveProdServ'];
                $c->cdgItem       = (string) $n['NoIdentificacion'];
                $c->dscItem       = (string) $n['Descripcion'];
                $c->unmdItem      = (string) $n['ClaveUnidad'];
                $c->qtyItem       = (string) $n['Cantidad'];
                $c->montoNetoItem = (string) $n['ValorUnitario'];
                $c->prcNetoItem   = (string) $n['Importe'];
                $c->descuento     = (string) ($n['Descuento'] ?? 0);
                $c->objetoImp     = (string) $n['ObjetoImp'];
                $c->save();
            }

            // 7) Impuestos globales
            if ($xml->xpath('//cfdi:Impuestos')) {
                foreach ($xml->xpath('//cfdi:Impuestos/cfdi:Traslados/cfdi:Traslado') as $i) {
                    $imp = new ExImpuestos();
                    $imp->id_factura = $factura->id_factura;
                    $imp->base       = (string) $i['Base'];
                    $imp->factor     = (string) $i['TipoFactor'];
                    $imp->tipoImp    = (string) $i['Impuesto'];
                    $imp->tasaImp    = (string) $i['TasaOCuota'];
                    $imp->tipo       = 1;
                    $imp->montoImp   = (string) $i['Importe'];
                    $imp->save();
                }
                foreach ($xml->xpath('//cfdi:Impuestos/cfdi:Retenciones/cfdi:Retencion') as $i) {
                    $imp = new ExImpuestos();
                    $imp->id_factura = $factura->id_factura;
                    $imp->base       = null;
                    $imp->factor     = (string) $i['TipoFactor'];
                    $imp->tipoImp    = (string) $i['Impuesto'];
                    $imp->tasaImp    = (string) $i['TasaOCuota'];
                    $imp->tipo       = 0;
                    $imp->montoImp   = (string) $i['Importe'];
                    $imp->save();
                }
            }

            // 8) FacturasRelacionadas
            foreach ($xml->xpath('//cfdi:Relacionados/cfdi:Relacionado') as $rel) {
                $fr = new FacturasRelacionadas();
                $fr->id_factura = $factura->id_factura;
                $fr->uuid       = (string) $rel['UUID'];
                $fr->save();
            }

            // 9) Comercio Exterior
            if ($xml->xpath('//cce20:ComercioExterior')) {
                $com = $xml->xpath('//cce20:ComercioExterior')[0];
                $cx = new ComercioE();
                $cx->id_factura       = $factura->id_factura;
                $cx->Incoterm         = (string) $com['Incoterm'];
                $cx->clavePedimento   = (string) $com['ClaveDePedimento'];
                $cx->motivoTraslado   = (string) ($com['MotivoTraslado'] ?? '');
                $cx->tipoOperacion    = 2;
                $cx->rfcExtranjero    = '713616886';
                $cx->totalUSD         = (string) $com['TotalUSD'];
                $cx->save();

                // domicilio emisor
                if ($com->xpath('cce20:Emisor/cce20:Domicilio')) {
                    $d = $com->xpath('cce20:Emisor/cce20:Domicilio')[0];
                    $e = new DomFiscalFact();
                    $e->id_factura   = $factura->id_factura;
                    $e->calle        = (string) $d['Calle'];
                    $e->nroExterior  = (string) $d['NumeroExterior'];
                    $e->nroInterior  = (string) ($d['NumeroInterior'] ?: '');
                    $e->colonia      = (string) ($d['Colonia'] ?: '');
                    $e->municipio    = (string) ($d['Municipio'] ?: '');
                    $e->estado       = (string) $d['Estado'];
                    $e->pais         = (string) $d['Pais'];
                    $e->codigoPostal = (string) $d['CodigoPostal'];
                    $e->save();
                }

                // domicilio receptor
                if ($com->xpath('cce20:Receptor/cce20:Domicilio')) {
                    $d = $com->xpath('cce20:Receptor/cce20:Domicilio')[0];
                    $r = new DomFiscalRcpFact();
                    $r->id_factura   = $factura->id_factura;
                    $r->calle        = (string) $d['Calle'];
                    $r->nroExterior  = (string) $d['NumeroExterior'];
                    $r->nroInterior  = (string) ($d['NumeroInterior'] ?: '');
                    $r->colonia      = (string) ($d['Colonia'] ?: '');
                    $r->municipio    = (string) ($d['Municipio'] ?: '');
                    $r->estado       = (string) $d['Estado'];
                    $r->pais         = (string) $d['Pais'];
                    $r->codigoPostal = (string) $d['CodigoPostal'];
                    $r->save();
                }

                // mercancias
                foreach ($com->xpath('cce20:Mercancias/cce20:Mercancia') as $mc) {
                    $m = new MercanciaComercio();
                    $m->id_factura          = $factura->id_factura;
                    $m->noIdentificacion    = (string) $mc['NoIdentificacion'];
                    $m->fraccionArancelaria = (string) $mc['FraccionArancelaria'];
                    $m->cantidadAduana      = (string) $mc['CantidadAduana'];
                    $m->unidadAduana        = (string) $mc['UnidadAduana'];
                    $m->valorUnitarioAduana = (string) $mc['ValorUnitarioAduana'];
                    $m->valorDolares        = (string) $mc['ValorDolares'];
                    $m->save();
                }
            }

            DB::commit();

        } catch (\Exception $e) {
            DB::rollBack();
            throw $e;
        }

        return ['success' => true];

    }

}


