<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Response;
use App\Commands\Utils;
use App\Models\ClaveProdServ;
use App\Models\ClaveProdServProveedor;
use App\Models\Division;
use App\Models\Grupo;
use App\Models\Serie;
use App\Models\PaqueteAsignado;
use App\Models\Proveedor;
use App\Models\UnidadMedida;
use App\Models\UnidadMedidaProveedor;

use Illuminate\Support\Facades\DB;

class ConfiguracionesController extends BaseController {

	public function obtenerDatos(Request $request){

		$user = $request->input('user');

		$series = Serie::where('id_proveedor', '=', $user['id_proveedor'])->get();

		$proveedor = DB::table('Proveedor')->where('id_proveedor', '=', $user['id_proveedor'])->select('id_proveedor', 'color', 'imagen')->first();

		$clavesProductoServicio = ClaveProdServProveedor::with('clave')->where('id_proveedor', '=', $user['id_proveedor'])->get();
		$unidadesMedida = UnidadMedidaProveedor::with('unidad')->where('id_proveedor', '=', $user['id_proveedor'])->get();

		return Response::json ( array (
			'success' => true,
			'series' => $series->toArray(),
			'proveedor' => $proveedor,
			'clavesProductoServicio' => $clavesProductoServicio->toArray(),
			'unidadesMedida' => $unidadesMedida->toArray()
		));
	}


	public function obtenerDivisiones(Request $request){

		$tipoProdServicio = $request->input('tipoProdServicio');

		$divisiones = Division::where('status', '=', 1)->where('tipo', '=', $tipoProdServicio)->orderBy('descripcion')->get();

		return Response::json ( array (
			'success' => true,
			'divisiones' => $divisiones->toArray()
		));
	}


	public function obtenerGrupos(Request $request){

		$id_division = $request->input('id_division');

		$grupos = Grupo::where('status', '=', 1)->where('id_division', '=', $id_division)->orderBy('descripcion')->get();

		return Response::json ( array (
			'success' => true,
			'grupos' => $grupos->toArray()
		));
	}


	public function obtenerClavesProdServ(Request $request){

		DB::enableQueryLog();

		$filtroProdServ = $request->input('filtroProdServ');

		if($filtroProdServ['tipoFiltro'] == 1){
			//Por división
			$productos = DB::table('Division')->select('Division.descripcion as division', 'Grupo.descripcion as grupo', 'ClaveProdServ.*')->
				join('Grupo', 'Grupo.id_division', '=', 'Division.id')->
				join('ClaveProdServ', 'ClaveProdServ.id_grupo', '=', 'Grupo.id')->
				where('Division.tipo', '=', $filtroProdServ['tipoProdServicio'])->
				where('Grupo.id', '=', $filtroProdServ['id_grupo']);

				if(isset($filtroProdServ['codigo_clase']) && $filtroProdServ['codigo_clase'] > 0){
					$hastaVal = (ceil( ($filtroProdServ['codigo_clase']+1) / 100 ) * 100) - 1;
					$productos->where('ClaveProdServ.codigo', '>=', $filtroProdServ['codigo_clase'])->where('ClaveProdServ.codigo', '<=', $hastaVal);
				}

				$productos = $productos->orderBy('Division.descripcion')->orderBy('Grupo.descripcion')->orderBy('ClaveProdServ.codigo')->get();

		}else{
			$productos = DB::table('Division')->select('Division.descripcion as division', 'Grupo.descripcion as grupo', 'ClaveProdServ.*')->
				join('Grupo', 'Grupo.id_division', '=', 'Division.id')->
				join('ClaveProdServ', 'ClaveProdServ.id_grupo', '=', 'Grupo.id')->
				orWhere('ClaveProdServ.descripcion', 'like', "%".trim($filtroProdServ['claveDescripcion'])."%")->
				orWhere('ClaveProdServ.codigo', 'like', "%".trim($filtroProdServ['claveDescripcion'])."%")->
				orderBy('Division.descripcion')->orderBy('Grupo.descripcion')->orderBy('ClaveProdServ.codigo')->get();
		}

		/*
		$query = DB::getQueryLog();
		$query = end($query);
		print_r($query);
		*/

		$divisiones = [];
		$x = -1;
		$y = -1;
		$z = -1;
		$currentDivision = '';
		$currentGrupo = '';
		$currentClase = '';

		foreach ($productos as $producto) {

			if($currentDivision != $producto->division){
				$x++;
				$y = -1;
				$z = -1;
				$currentDivision = $producto->division;
				$divisiones[$x]['nombre'] = $producto->division;
				$divisiones[$x]['grupos'] = [];
			}

			if($currentGrupo != $producto->grupo){
				$y++;
				$z = -1;
				$currentGrupo = $producto->grupo;
				$divisiones[$x]['grupos'][$y]['nombre'] = $producto->grupo;
				$divisiones[$x]['grupos'][$y]['clases'] = [];
			}

			if($producto->codigo % 100 == 0){
				$z++;
				$divisiones[$x]['grupos'][$y]['clases'][$z] = ['id' => $producto->id, 'codigo' => $producto->codigo, 'descripcion' => $producto->descripcion];
				$divisiones[$x]['grupos'][$y]['clases'][$z]['claves'] = [];
			}else{

				if($z == -1){
					$z++;
					$clase = ClaveProdServ::where('codigo', '=', (floor($producto->codigo / 100)) * 100)->first();
					if(is_object($clase)){
						$divisiones[$x]['grupos'][$y]['clases'][$z] = ['id' => $clase->id, 'codigo' => $clase->codigo, 'descripcion' => $clase->descripcion];
						$divisiones[$x]['grupos'][$y]['clases'][$z]['claves'] = [];
					}
				}

				$divisiones[$x]['grupos'][$y]['clases'][$z]['claves'][] = ['id' => $producto->id, 'codigo' => $producto->codigo, 'descripcion' => $producto->descripcion];
			}



		}

		return Response::json ( array (
			'success' => true,
			'listadoDivisiones' => $divisiones
		));


	}

	public function agregarProdServicio(Request $request){

		$user = $request->input('user');
		$id = $request->input('id');
		$isAgregar = $request->input('isAgregar');

		$claveObj = [];

		if($isAgregar){

			$clave = ClaveProdServProveedor::where('id_proveedor', '=', $user['id_proveedor'])->where('id_prodServicio', '=', $id)->first();

			if(!is_object($clave)){
				$clave = new ClaveProdServProveedor();
				$clave->id_prodServicio = $id;
				$clave->id_proveedor = $user['id_proveedor'];
				$clave->status = 1;
				$clave->save();

				$claveObj = ClaveProdServProveedor::with('clave')->find($clave->id);
				$claveObj = $claveObj->toArray();
			}
		}else{
			ClaveProdServProveedor::where('id_proveedor', '=', $user['id_proveedor'])->where('id_prodServicio', '=', $id)->delete();
		}

		return Response::json ( array (
			'success' => true,
			'productoServicioProveedor' => $claveObj
		));


	}


	public function obtenerUnidadesMedida(Request $request){

		$filtroTextoUnidadMedida = $request->input('filtroTextoUnidadMedida');
		$tipoFiltroAdicional = $request->input('tipoFiltroAdicional');

		//Comienza con
		if($tipoFiltroAdicional == 1){
			$unidadesMedida = UnidadMedida::orWhere('descripcion', 'like', trim("$filtroTextoUnidadMedida%"))->orWhere('codigo', 'like', "%$filtroTextoUnidadMedida%")->orderBy('descripcion')->get();
		}else if($tipoFiltroAdicional == 2){
			//Termina con
			$unidadesMedida = UnidadMedida::orWhere('descripcion', 'like', "%$filtroTextoUnidadMedida")->orWhere('codigo', 'like', "%$filtroTextoUnidadMedida%")->orderBy('descripcion')->get();
		}else{
			$unidadesMedida = UnidadMedida::orWhere('descripcion', 'like', "%$filtroTextoUnidadMedida%")->orWhere('codigo', 'like', "%$filtroTextoUnidadMedida%")->orderBy('descripcion')->get();
		}

		return Response::json ( array (
			'success' => true,
			'unidadesMedida' => $unidadesMedida->toArray()
		));
	}



	public function agregarUnidadMedida(Request $request){

		$user = $request->input('user');
		$id = $request->input('id');
		$isAgregar = $request->input('isAgregar');

		$unidadObj = [];

		if($isAgregar){

			$unidad = UnidadMedidaProveedor::where('id_proveedor', '=', $user['id_proveedor'])->where('id_unidadMedida', '=', $id)->first();

			if(!is_object($unidad)){
				$unidad = new UnidadMedidaProveedor();
				$unidad->id_unidadMedida = $id;
				$unidad->id_proveedor = $user['id_proveedor'];
				$unidad->save();

				$unidadObj = UnidadMedidaProveedor::with('unidad')->find($unidad->id);
				$unidadObj = $unidadObj->toArray();
			}
		}else{
			UnidadMedidaProveedor::where('id_proveedor', '=', $user['id_proveedor'])->where('id_unidadMedida', '=', $id)->delete();
		}

		return Response::json ( array (
			'success' => true,
			'unidadMedidaProveedor' => $unidadObj
		));

	}

	public function guardarSerie(Request $request){

		$user = $request->input('user');
		$nuevaSerie = $request->input('nuevaSerie');


		$serie = new Serie();
		$serie->id_proveedor = $user['id_proveedor'];
		$serie->serie = trim($nuevaSerie);
		$serie->fechaCreacion = date('Y-m-d');
		$serie->iniciaEn = 1;
		$serie->status = 1;
		$serie->save();

		return Response::json ( array (
			'success' => true,
			'serie' => $serie->toArray()
		));

	}

	public function borrarSerie(Request $request){

		$id_serie = $request->input('id');

		Serie::destroy($id_serie);

		return Response::json ( array (
			'success' => true
		));
	}


	public function actualizarLogotipo(Request $request){


		$id_proveedor = $request->input ( 'id_proveedor' );
		$token = $request->input ( 'token' );
		$color = $request->input ( 'color' );

		$proveedor = Proveedor::where ( 'token', "=", $token )->where ( 'id_proveedor', "=", $id_proveedor )->first ();

		if (! is_object ( $proveedor ) || empty ( $token )) {
			return Response::json ( array (
					'success' => false,
					'errorText' => 'Token incorrecto'
			) );
		}

		$logotipoFile = $request->file('logotipoFile');

		;

		$newImage = '';

		if(isset($logotipoFile)){

			$extensionesDisponibles = array('jpg', 'png', 'gif');
			$extension = strtolower($logotipoFile->extension()  );

			if(in_array ($extension, $extensionesDisponibles)){

				$fileName = $proveedor->rFCEmisor . date('YmdHis');
				$up1Success = $logotipoFile->move ( env('DIR_LOGOS'), "$fileName.$extension" );
				$newImage = $proveedor->imagen = "$fileName.$extension";

			}else{
				return Response::json ( array (
						'success' => false,
						'errorText' => 'El archivo logotipo no es de un tipo válido'
				));
			}
		}

		$proveedor->color = $color;
		$proveedor->save();

		return Response::json ( array (
				'success' => true,
				'newImage' => $newImage
		));

	}


	public function menu(Request $request){

		$id_proveedor = $request->input('id');

		$proveedor = Proveedor::find($id_proveedor);

		$menu = array(
				array('text' => 'Bienvenido', 'sref' => 'app.home', 'icon' => 'icon-home'),
				array('text' => 'Listado facturas', 'sref' => 'app.listadoFacturas', 'icon' => 'icon-speedometer'),
				array('text' => 'Mis datos', 'sref' => 'app.misDatos', 'icon' => 'icon-grid'),
				array('text' => 'Clientes', 'sref' => 'app.clientes', 'icon' => 'icon-layers'),
				array('text' => 'Conceptos', 'sref' => 'app.conceptos', 'icon' => 'icon-layers'),
				array('text' => 'Nomina', 'sref' => 'app.nomina', 'icon' => 'fa fa-shield'),
				array('text' => 'Configuración', 'sref' => 'app.configuraciones', 'icon' => 'icon-settings'),
				array('text' => 'Salir', 'sref' => 'page.login', 'icon' => 'icon-cup')
		);

		if($proveedor->asociado == 1){
			array_splice($menu, 7,0, [array('text' => 'Zona asociado', 'sref' => 'app.asociados', 'icon' => 'icon-paper-plane')]);
		}

		echo json_encode($menu);

	}
}

