<?php

namespace App\Commands;

use App\Models\CatalogoRegimenFiscal;
use App\Models\CertificadoProveedor;
use App\Models\Cliente;
use App\Models\ComercioE;
use App\Models\Concepto;
use App\Models\ContactoReceptor;
use App\Models\DoctoRelacionado;
use App\Models\DomFiscalFact;
use App\Models\DomFiscalRcp;
use App\Models\DomFiscalRcpFact;
use App\Models\ExImpuestos;
use App\Models\Factura;
use App\Models\FacturasRelacionadas;
use App\Models\FormaPago;
use App\Models\IdDoc;
use App\Models\ImpuestosDR;
use App\Models\MercanciaComercio;
use App\Models\Pago;
use App\Models\Proveedor;
use App\Models\Totales;
use App\Models\TotalesP;
use App\Models\UsoCFDI;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Response;
use SoapClient;
use App\Models\DatosEspeciales;
use Illuminate\Support\Facades\Log;
use Dompdf\Dompdf;

class FacturacionApiFunctions {

    public function facturar($factura){

        $factura = $factura['factura'];
        $response = array();

	    ini_set('default_socket_timeout', 250);

	    $proveedor = Proveedor::find($factura['idProveedor']);
	    $nombreArchivo = '';

	    $comprobante = $factura['comprobante'];
	    $receptor = $factura['receptor'];

	    $timeStamp = date("Y-m-d H:i:s" , strtotime("-2 minutes"));
	    $noFactura = DB::select("SELECT MAX(noFactura) as noFactura FROM Factura f JOIN IdDoc i ON f.id_factura = i.id_factura WHERE id_proveedor = " . $factura['idProveedor'] . " AND i.serie = '" . $comprobante['serie'] ."'")[0];
	    $noFactura->noFactura++;
	    $certificadoHaUsar = CertificadoProveedor::where('id_proveedor', '=', $factura['idProveedor'])->where('status', '=', 1)->first();


	    $datosFactura = new \stdClass();
	    $datosFactura->timeStamp = $timeStamp;
	    $datosFactura->tipoDeComprobante = $comprobante['tipoDeComprobante'];
	    $datosFactura->serie = $comprobante['serie'];
	    $datosFactura->folio = $noFactura->noFactura;
	    $datosFactura->noCertificado = $certificadoHaUsar->noCertificado;
	    $datosFactura->certificado = $certificadoHaUsar->certificado;
	    $datosFactura->mntBase = $comprobante['base'];
	    $datosFactura->subtotal = $comprobante['subTotal'];
	    $datosFactura->moneda = $comprobante['Moneda'];
	    $datosFactura->total = $comprobante['total'];
	    $datosFactura->formaPago = $comprobante['formaPago'];
	    $datosFactura->descuento = $comprobante['descuento'];
	    $datosFactura->precission = $comprobante['decimales'];
	    $datosFactura->tipoCambio = $comprobante['TipoCambio'];
	    $datosFactura->lugarExpedicion = Utils::deleteExtraSpaces($comprobante['LugarExpedicion']);
	    $datosFactura->usoCFDI = $comprobante['usoCFDI'];
	    $datosFactura->metodoDePago = $comprobante['metodoDePago'];
	    $datosFactura->condicionesDePago = (isset($comprobante['condicionesDePago']) && $comprobante['condicionesDePago'] != "")? Utils::deleteExtraSpaces($comprobante['condicionesDePago']) : '';
	    $datosFactura->tipoFacturasRelacionadas = $comprobante['facturasRelacionadas']['tipoRelacion'];
	    $datosFactura->rFCEmisor = $proveedor->rFCEmisor;
	    $datosFactura->nmbEmisor = $proveedor->nmbEmisor;
	    $datosFactura->rFCRecep = $receptor['rfc'];
	    $datosFactura->nmbRecep = $receptor['nombre'];
	    $datosFactura->regimenFiscal = $proveedor->regimenFiscal33;
	    $datosFactura->numRegIdTrib = isset($receptor['rfcExtranjero'])? $receptor['rfcExtranjero'] : '';
	    $datosFactura->pais = isset($receptor['pais'])? $receptor['pais'] : '';
	    $datosFactura->tipoPersona = $proveedor->tipoPersona;

	    $datosFactura->conceptos = [ ];
	    $datosFactura->impuestosTrasladados = [ ];
	    $datosFactura->impuestosRetenidos = [ ];
	    $datosFactura->impuestosTrasladadosLcl = [ ];
	    $datosFactura->impuestosTrasladadosLclTotal = 0;
	    $datosFactura->impuestosRetenidosLcl = [ ];
	    $datosFactura->impuestosRetenidosLclTotal = 0;
	    $totalImpRetenidos = 0;
	    $totalImpTrasladados = 0;

	    $noConceptos = count($factura ['conceptos']);
	    $z = 0;
	    $arraySumas = [];

	    foreach ( $factura ['conceptos'] as $detalle ) {

	        $z++;

	        if($comprobante['total'] == 0){
	        	$factura ['traslados'] = [];
	        	$factura ['retenciones'] = [];
	        }

	        $concepto = new \stdClass ();
	        $concepto->clave = $detalle ['claveSAT'];
	        $concepto->cdgItem = Utils::deleteExtraSpaces ( $detalle ['noIdentificacion'] );
	        $concepto->dscItem = Utils::deleteExtraSpaces ( $detalle ['descripcion'] );
	        $concepto->unmdItem = (isset ( $detalle ['unidadSAT'] )) ? $detalle ['unidadSAT'] : '';
            $concepto->fracArancelaria = (isset ( $detalle ['fracArancelaria'] )) ? $detalle ['fracArancelaria'] : '';
	        $concepto->qtyItem = $detalle ['cantidad'];
	        $concepto->montoNetoItem = $detalle ['valorUnitario'];
	        $concepto->prcNetoItem = $detalle ['cantidad'] * $detalle ['valorUnitario'];
	        $concepto->descuento = $detalle ['descuento'];

	        $concepto->impuestosTrasladados = [ ];

	        $base = Utils::formatNumber((($detalle ['cantidad'] * $detalle ['valorUnitario']) - $detalle ['descuento']), $comprobante['decimales']);
	        foreach ( $factura ['traslados'] as $traslado ) {

	            if ($traslado ['impuesto'] == 'XXX') {

	                $impuestoLcl = new \stdClass ();
	                $impuestoLcl->tipoImp = $traslado ['label'];
	                $impuestoLcl->tasaImp = $traslado ['valor'];
	                $impuestoLcl->tipo = 1;

	                $importeImp = 0;
	                if ($traslado ['factor'] == 'Tasa') {
	                    $importeImp = $traslado ['valor'] * $base;
	                } else if ($traslado ['factor'] == 'Cuota') {
	                    $importeImp = $traslado ['valor'];
	                }

	                $importeImp = Utils::formatNumber($importeImp, $comprobante['decimales']);

	                $impuestoLcl->montoImp = $importeImp;


	                $datosFactura->impuestosTrasladadosLclTotal += $importeImp;
	                $datosFactura->impuestosTrasladadosLcl[] = $impuestoLcl;

	            } else {

	                $impuesto = new \stdClass ();
	                $impuesto->base = $base;
	                $impuesto->factor = $traslado ['factor'];
	                $impuesto->tipoImp = $traslado ['impuesto'];
	                $impuesto->tasaImp = $traslado ['valor'];
	                $impuesto->tipo = 1;

	                $importeImp = 0;
	                if ($traslado ['factor'] == 'Tasa') {
	                    $importeImp = $traslado ['valor'] * $impuesto->base;
	                } else if ($traslado ['factor'] == 'Cuota') {
	                    $importeImp = $traslado ['valor'];
	                }

	                $importeImp = Utils::formatNumber($importeImp, $comprobante['decimales']);

	                $impuesto->montoImp = $importeImp;

	                $totalImpTrasladados += $importeImp;

	                $concepto->impuestosTrasladados[] = $impuesto;

	                $isNuevo = true;
	                if(count($datosFactura->impuestosTrasladados))
	                    foreach($datosFactura->impuestosTrasladados as $impuestoGeneral){


	                        if($impuesto->tipoImp == $impuestoGeneral->impuesto && $impuesto->factor == $impuestoGeneral->tipoFactor && $impuesto->tasaImp == $impuestoGeneral->tasaOCuota){
	                            $isNuevo = false;
	                            $impuestoGeneral->importe += $impuesto->montoImp;
	                            break;
	                        }
	                }

	                if($isNuevo && $traslado['factor'] != 'Exento'){
	                    $impuestoGeneral = new \stdClass();
	                    $impuestoGeneral->importe = $impuesto->montoImp;
	                    $impuestoGeneral->impuesto = $impuesto->tipoImp;
	                    $impuestoGeneral->tipoFactor = $traslado['factor'];
	                    $impuestoGeneral->tasaOCuota = $traslado['valor'];
	                    $datosFactura->impuestosTrasladados[] = $impuestoGeneral;
	                }

	            }
	        }

	        $concepto->impuestosRetenidos = [];

	        if(isset($factura['retenciones']) && count($factura['retenciones']) > 0)
	        foreach ($factura['retenciones'] as $retencion){


	            if ($retencion ['impuesto'] == 'XXX') {

	                $impuestoLcl = new \stdClass ();
	                $impuestoLcl->tipoImp = $retencion ['label'];
	                $impuestoLcl->tasaImp = $retencion ['valor'];
	                $impuestoLcl->tipo = 0;

	                $importeImp = 0;
	                if ($retencion ['factor'] == 'Tasa') {
	                    $importeImp = $retencion ['valor'] * $base;
	                } else if ($retencion ['factor'] == 'Cuota') {
	                    $importeImp = $retencion ['valor'];
	                }

	                $importeImp = Utils::formatNumber($importeImp, $comprobante['decimales']);

	                $impuesto->montoImp = $importeImp;

	                $datosFactura->impuestosRetenidosLclTotal += $importeImp;
	                $datosFactura->impuestosRetenidosLcl[] = $impuestoLcl;

	            }else{

	                $impuesto = new \stdClass();
	                $impuesto->base = $base;
	                $impuesto->factor = $retencion['factor'];
	                $impuesto->tipoImp = $retencion['impuesto'];
	                $impuesto->tasaImp = $retencion['valor'];
	                $impuesto->tipo = 0;

	                $importeImp = 0;
	                if($retencion['factor'] == 'Tasa'){
	                    $importeImp = $retencion['valor'] * $impuesto->base;
	                }else if($retencion['factor'] == 'Cuota'){
	                    $importeImp = $retencion['valor'];
	                }

	                $importeImp = Utils::formatNumber($importeImp, $comprobante['decimales']);

	                $impuesto->montoImp = $importeImp;

	                $totalImpRetenidos += $importeImp;

	                $concepto->impuestosRetenidos[] = $impuesto;

	                $isNuevo = true;
	                if(count($datosFactura->impuestosRetenidos))
	                    foreach($datosFactura->impuestosRetenidos as $impuestoGeneral){
	                        if($impuesto->tipoImp == $impuestoGeneral->impuesto){
	                            $isNuevo = false;
	                            $impuestoGeneral->importe += $impuesto->montoImp;
	                            break;
	                        }
	                }

	                if($isNuevo && $retencion['factor'] != 'Exento'){
	                    $impuestoGeneral = new \stdClass();
	                    $impuestoGeneral->importe = $impuesto->montoImp;
	                    $impuestoGeneral->impuesto = $impuesto->tipoImp;
	                    $datosFactura->impuestosRetenidos[] = $impuestoGeneral;
	                }

	            }


	        }

	        $datosFactura->conceptos[] = $concepto;
	    }


	    $datosFactura->totalImpRetenidos = $totalImpRetenidos;
	    $datosFactura->totalImpTrasladados = $totalImpTrasladados;

	    $datosFactura->facturasRelacionadas = [];

	    if(count($comprobante['facturasRelacionadas']['uuids']))
	        foreach ($comprobante['facturasRelacionadas']['uuids'] as $facturaRelacionada){

	            $relacionObj = new \stdClass();
	            $relacionObj->uuid = $facturaRelacionada['uuid'];
	            $datosFactura->facturasRelacionadas[] = $relacionObj;
	    }

        if(isset($comprobante['comercioExterior'])){

            $datosFactura->comercio = array();


            $comercio = $comprobante['comercioExterior'];

            $comercioEObj = new \stdClass();
            $comercioEObj->Incoterm = $comercio['incoterm'];
            $comercioEObj->clavePedimento = $comercio['pedimento'];
            $comercioEObj->tipoOperacion = $comercio['tipoOperacion'];
            $comercioEObj->rfcExtranjero = $comercio['rfcExtranjero'];
            $comercioEObj->curp = $comercio['curp'] ?? '';
            $comercioEObj->motivoTraslado = $comercio['motivoTraslado'] ?? '';
            $comercioEObj->totalUSD = $comercio['totalUSD'] ?? '';


            if(is_object($proveedor->domicilio)){
                $comercioEObj->curp = $proveedor->domicilio->curp;
            }else{
                $comercioEObj->curp = '';
            }

            $emisor = $comercio['emisor'];

            $domicilioEmisor = new \stdClass();
            $domicilioEmisor->calle = $emisor['calle'];
            $domicilioEmisor->nroExterior = $proveedor->domicilio->nroExterior;
            $domicilioEmisor->nroInterior = !empty($proveedor->domicilio->nroInterior) ? $proveedor->domicilio->nroInterior :'';
            $domicilioEmisor->colonia = !empty($proveedor->domicilio->colonia) ? $proveedor->domicilio->colonia :'';
            $domicilioEmisor->municipio = !empty($proveedor->domicilio->municipio) ? $proveedor->domicilio->municipio :'';
            $domicilioEmisor->estado = $proveedor->domicilio->estado;
            $domicilioEmisor->pais = $proveedor->domicilio->pais;
            $domicilioEmisor->codigoPostal = $proveedor->domicilio->codigoPostal;

            $receptor = $comercio['receptor'];

            $domicilioReceptor = new \stdClass();
            $domicilioReceptor->calle = $receptor['calle'];
            $domicilioReceptor->nroExterior = isset($receptor['nroExterior'])? $receptor['nroExterior'] : '';
            $domicilioReceptor->nroInterior = isset($receptor['nroInterior'])? $receptor['nroInterior'] : '';
            $domicilioReceptor->colonia = isset($receptor['colonia'])? $receptor['colonia'] : '';
            $domicilioReceptor->municipio = isset($receptor['municipio'])? trim($receptor['municipio']) : '';
            $domicilioReceptor->estado = $receptor['estado'];
            $domicilioReceptor->pais = $receptor['pais'];
            $domicilioReceptor->codigoPostal = $receptor['codigoPostal'];


            $datosFactura->comercio->datos = $comercioEObj;
            $datosFactura->comercio->emisor = $domicilioEmisor;
            $datosFactura->comercio->receptor = $domicilioReceptor;


        }

	    $xml = XMLUtils::createXML33($datosFactura, $proveedor);

	    $sello = $xml->query('//cfdi:Comprobante')[0]->getAttribute('Sello');

	    $nombreArchivo = "$proveedor->rFCEmisor-" .date('YmdHis');

	    file_put_contents("tmp/$nombreArchivo.xml", $xml);

	    $urlTimbrado = "https://facturacion.finkok.com/servicios/soap/stamp.wsdl";
		$usuarioInt = "saul.flores@soliat.com";
		$passwordInt = "S3rgio.Fl0res";

		if ($proveedor->id_proveedor == 1089) {

			$urlTimbrado = "https://demo-facturacion.finkok.com/servicios/soap/stamp.wsdl";
			$usuarioInt = "saul.flores@soliat.com";
			$passwordInt = "S3rgio.Fl0res";
		}

		$params = array ();
		$params ['xml'] = $xml;
		$params ['username'] = $usuarioInt;
		$params ['password'] = $passwordInt;


		$client = new SoapClient ( $urlTimbrado, array (
				'encoding' => 'UTF-8',
				"connection_timeout" => 250
		) );
		$client->soap_defencoding = "UTF-8";
		$resultado = $client->__soapCall ( 'stamp', array (
				$params
		) );

		$logToSave = print_r ( $resultado, true );

		$log = env ( 'DIR_LOGS' ) . "/" . date ( "Y-m-d" ) . ".log";
		$log2 = env ( 'DIR_LOGS' ) . "/serch.log";

		file_put_contents($log2, $logToSave, FILE_APPEND);

		$fp = fopen ( $log, "a" );
		fwrite ( $fp, "\n\n===" . date ( "Y-m-d:H:i:s" ) . "\n\n" );
		fwrite ( $fp, "\n\n$nombreArchivo\n\n" );
		fwrite ( $fp, $logToSave );
		fwrite ( $fp, "\n\n===" );
		fclose ( $fp );

		$success = false;
		$errorCode = 0;
		$errortext = '';
		$facturaResult = '';

		if (is_object ( $resultado ) && isset ( $resultado->stampResult ) && isset ( $resultado->stampResult->xml ) && !empty($resultado->stampResult->xml)) {
			$success = true;

			$xmlTimbrado = new \DOMDocument ( "1.0", "uft-8" );
			$xmlTimbrado->loadXML ( $resultado->stampResult->xml );

	        $idDoc = new IdDoc();

	        $timbreFiscal = $xmlTimbrado->getElementsByTagName ( 'TimbreFiscalDigital' );

	        foreach ( $timbreFiscal as $timbreFiscal ) {

	            $fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );
	            $fechaTimbradoArray = explode(".",$fechaTimbrado);

	            $idDoc->version = $timbreFiscal->getAttribute ( 'Version' );
	            $idDoc->fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );
	            $idDoc->selloCFD = $timbreFiscal->getAttribute ( 'SelloCFD' );
	            $idDoc->noCertificadoSAT = $timbreFiscal->getAttribute ( 'NoCertificadoSAT' );
	            $idDoc->selloSAT = $timbreFiscal->getAttribute ( 'SelloSAT' );
	            $idDoc->uUID = $timbreFiscal->getAttribute ( 'UUID' );
	            $idDoc->sello = $sello;
	            $idDoc->rfcProvCertif = $timbreFiscal->getAttribute ( 'RfcProvCertif' );
	        }

	        $isPagado = 0;
	        if($datosFactura->metodoDePago == 'PUE')
	            $isPagado = 1;

	            $facturaObj = new Factura();
	            $facturaObj->id_proveedor = $factura['idProveedor'];
	            $facturaObj->id_cliente = 0;
	            $facturaObj->id_certificadoProveedor = $certificadoHaUsar->id;
	            $facturaObj->nmbEmisor = $proveedor->nmbEmisor;
	            $facturaObj->rFCEmisor = $proveedor->rFCEmisor;
	            $facturaObj->nmbRecep = $datosFactura->nmbRecep;
	            $facturaObj->rFCRecep = $datosFactura->rFCRecep;
	            $facturaObj->regimenFiscal = $proveedor->regimenFiscal33;
	            $facturaObj->timeStamp = $timeStamp;
	            $facturaObj->noFactura = $noFactura->noFactura;
	            $facturaObj->version = "3.3";
	            $facturaObj->generadoPor = 4;
	            $facturaObj->nota = (isset($comprobante['comentario']))? Utils::deleteExtraSpaces($comprobante['comentario']) : '';
	            $facturaObj->tipoDeComprobante = $datosFactura->tipoDeComprobante;
	            $facturaObj->precission = $datosFactura->precission;
	            $facturaObj->status = 1;
	            $facturaObj->isPagado = $isPagado;
	            $facturaObj->save();


	            $idDoc->id_factura = $facturaObj->id_factura;
	            $idDoc->serie = $datosFactura->serie;
	            $idDoc->folio = $noFactura->noFactura;
	            $idDoc->formaPago = $datosFactura->formaPago;
	            $idDoc->condicionesDePago = $datosFactura->condicionesDePago;
	            $idDoc->lugarExpedicion = $datosFactura->lugarExpedicion;
	            $idDoc->usoCFDI = $datosFactura->usoCFDI;
	            $idDoc->metodoDePago = $datosFactura->metodoDePago;
	            $idDoc->sello = $sello;
	            $idDoc->tipoFacturasRelacionadas = $datosFactura->tipoFacturasRelacionadas;
	            $idDoc->save();


	            $totales = new Totales();
	            $totales->id_factura = $facturaObj->id_factura;
	            $totales->moneda = $datosFactura->moneda;
	            $totales->tipoCambio = $datosFactura->tipoCambio;
	            $totales->subTotal = $datosFactura->subtotal;
	            $totales->mntBase = $datosFactura->mntBase;
	            $totales->vlrPagar = $datosFactura->total;
	            $totales->descuento = $datosFactura->descuento;
	            $totales->pesoTotal = (isset($factura['totalWeight'])? $factura['totalWeight'] : 0);
	            $totales->save();

	            $detalles = array();

	            foreach ($datosFactura->conceptos as $concepto){

	                $conceptoObj = new Concepto();
	                $conceptoObj->clave = $concepto->clave;
	                $conceptoObj->cdgItem = $concepto->cdgItem;
	                $conceptoObj->dscItem = $concepto->dscItem;
	                $conceptoObj->unmdItem = $concepto->unmdItem;
	                $conceptoObj->qtyItem = $concepto->qtyItem;
	                $conceptoObj->montoNetoItem = $concepto->montoNetoItem;
	                $conceptoObj->prcNetoItem = $concepto->prcNetoItem;
	                $conceptoObj->descuento = $concepto->descuento;
	                $conceptoObj->id_factura = $facturaObj->id_factura;
	                $conceptoObj->save();

	                foreach ($concepto->impuestosTrasladados as $impuesto){

	                    $impuestoObj = new ExImpuestos();
	                    $impuestoObj->base = $impuesto->base;
	                    $impuestoObj->factor = $impuesto->factor;
	                    $impuestoObj->tipoImp = $impuesto->tipoImp;
	                    $impuestoObj->tasaImp = $impuesto->tasaImp;
	                    $impuestoObj->tipo = $impuesto->tipo;
	                    $impuestoObj->montoImp = $impuesto->montoImp;
	                    $impuestoObj->id_detalle = $conceptoObj->id_detalle;
	                    $impuestoObj->save();
	                }

	                foreach ($concepto->impuestosRetenidos as $impuesto){

	                    $impuestoObj = new ExImpuestos();
	                    $impuestoObj->base = $impuesto->base;
	                    $impuestoObj->factor = $impuesto->factor;
	                    $impuestoObj->tipoImp = $impuesto->tipoImp;
	                    $impuestoObj->tasaImp = $impuesto->tasaImp;
	                    $impuestoObj->tipo = $impuesto->tipo;
	                    $impuestoObj->montoImp = $impuesto->montoImp;
	                    $impuestoObj->id_detalle = $conceptoObj->id_detalle;
	                    $impuestoObj->save();
	                }
	            }

	            foreach ($datosFactura->facturasRelacionadas as $facturaRelacionada){

	                $facturaRelacionadaObj = new FacturasRelacionadas();
	                $facturaRelacionadaObj->id_factura = $facturaObj->id_factura;
	                $facturaRelacionadaObj->uuid = $facturaRelacionada->uuid;
	                $facturaRelacionadaObj->save();

	            }


	            if(count($datosFactura->impuestosRetenidosLcl) > 0)
	                foreach ($datosFactura->impuestosRetenidosLcl as $impuesto){

	                    $impuestoObj = new ExImpuestos();
	                    $impuestoObj->tipoImp = $impuesto->tipoImp;
	                    $impuestoObj->tasaImp = $impuesto->tasaImp;
	                    $impuestoObj->tipo = $impuesto->tipo;
	                    $impuestoObj->montoImp = $impuesto->montoImp;
	                    $impuestoObj->id_factura = $facturaObj->id_factura;
	                    $impuestoObj->save();
	            }

	            if(count($datosFactura->impuestosTrasladadosLcl) > 0)
	                foreach ($datosFactura->impuestosTrasladadosLcl as $impuesto){

	                    $impuestoObj = new ExImpuestos();
	                    $impuestoObj->tipoImp = $impuesto->tipoImp;
	                    $impuestoObj->tasaImp = $impuesto->tasaImp;
	                    $impuestoObj->tipo = $impuesto->tipo;
	                    $impuestoObj->montoImp = $impuesto->montoImp;
	                    $impuestoObj->id_factura = $facturaObj->id_factura;
	                    $impuestoObj->save();
	            }


	            $response['idFactura'] = $facturaObj->id_factura;
	            $response['resultCode'] = '1';
	            $response['noFactura'] = $noFactura->noFactura;
	            $response['fecha'] = $timeStamp;
	            $response['errortext'] = '';
	            $response['uuid'] = $idDoc->uUID;
	            $response['nombreArchivo'] = $nombreArchivo;


	            if(isset($factura['noOP']) && $factura['noOP'] != ""){

	                $datosEspeciales = new DatosEspeciales();
	                $datosEspeciales->id_factura = $facturaObj->id_factura;
	                $datosEspeciales->noOP = $factura['noOP'];
	                $datosEspeciales->save();
	            }


	    }else{

		    if(is_object($resultado)){
                $errorCode = $resultado->stampResult->Incidencias->Incidencia->CodigoError;
                $errortext = $resultado->stampResult->Incidencias->Incidencia->MensajeIncidencia;
            }else{
                $errorCode = $resultado[6];
                $errortext = $resultado[7];
            }


	        $response['idFactura'] = '';
	        $response['resultCode'] = $errorCode;
	        $response['errortext'] = $errortext;
	        $response['noFactura'] = '';
	        $response['nombreArchivo'] = $nombreArchivo;
	        $response['fecha'] = '';
	    }


	    return $response;


	}


    public function facturar40($factura){

        $factura = $factura['factura'];
        $response = array();

        ini_set('default_socket_timeout', 250);

        $proveedor = Proveedor::find($factura['idProveedor']);
        $nombreArchivo = '';

        $comprobante = $factura['comprobante'];
        $receptor = $factura['receptor'];

        $rfcHoraAntes = array ();
        $textLess = '-125 minutes';
        if (in_array ( $factura['idProveedor'], $rfcHoraAntes ))
            $textLess = '-24 hours';

        $timeStamp = date ( "Y-m-d H:i:s", strtotime ( $textLess ) );

        $noFactura = DB::select("SELECT MAX(noFactura) as noFactura FROM Factura f JOIN IdDoc i ON f.id_factura = i.id_factura WHERE id_proveedor = " . $factura['idProveedor'] . " AND i.serie = '" . $comprobante['serie'] ."'")[0];
        $noFactura->noFactura++;
        $certificadoHaUsar = CertificadoProveedor::where('id_proveedor', '=', $factura['idProveedor'])->where('status', '=', 1)->first();


        $datosFactura = new \stdClass();
        $datosFactura->timeStamp = $timeStamp;
        $datosFactura->tipoDeComprobante = $comprobante['tipoDeComprobante'];
        $datosFactura->serie = $comprobante['serie'];
        $datosFactura->folio = $noFactura->noFactura;
        $datosFactura->noCertificado = $certificadoHaUsar->noCertificado;
        $datosFactura->certificado = $certificadoHaUsar->certificado;
        $datosFactura->mntBase = $comprobante['base'];
        $datosFactura->subtotal = $comprobante['subTotal'];
        $datosFactura->moneda = $comprobante['Moneda'];
        $datosFactura->total = $comprobante['total'];
        $datosFactura->formaPago = $comprobante['formaPago'];
        $datosFactura->descuento = $comprobante['descuento'];
        $datosFactura->precission = $comprobante['decimales'];
        $datosFactura->tipoCambio = $comprobante['TipoCambio'];
        $datosFactura->lugarExpedicion = Utils::deleteExtraSpaces($comprobante['LugarExpedicion']);
        $datosFactura->usoCFDI = $comprobante['usoCFDI'];
        $datosFactura->metodoDePago = $comprobante['metodoDePago'];
        $datosFactura->condicionesDePago = (isset($comprobante['condicionesDePago']) && $comprobante['condicionesDePago'] != "")? Utils::deleteExtraSpaces($comprobante['condicionesDePago']) : '';
        $datosFactura->tipoFacturasRelacionadas = $comprobante['facturasRelacionadas']['tipoRelacion'];
        $datosFactura->regimenFiscalReceptor = $receptor ['regimenFiscalReceptor'];
        $datosFactura->domicilioFiscalReceptor = $receptor ['codigoPostal'];
        $datosFactura->rFCEmisor = $proveedor->rFCEmisor;
        $datosFactura->nmbEmisor = $proveedor->nmbEmisor;
        $datosFactura->rFCRecep = $receptor['rfc'];
        $datosFactura->nmbRecep = $receptor['nombre'];
        $datosFactura->exportacion = $comprobante['exportacion'];
        $datosFactura->regimenFiscal = $proveedor->regimenFiscal33;
        $datosFactura->numRegIdTrib = isset($receptor['rfcExtranjero'])? $receptor['rfcExtranjero'] : '';
        $datosFactura->pais = isset($receptor['pais'])? $receptor['pais'] : '';
        $datosFactura->tipoPersona = $proveedor->tipoPersona;

        $datosFactura->conceptos = [ ];
        $datosFactura->impuestosTrasladados = [ ];
        $datosFactura->impuestosRetenidos = [ ];
        $datosFactura->impuestosTrasladadosLcl = [ ];
        $datosFactura->impuestosTrasladadosLclTotal = 0;
        $datosFactura->impuestosRetenidosLcl = [ ];
        $datosFactura->impuestosRetenidosLclTotal = 0;
        $totalImpRetenidos = 0;
        $totalImpTrasladados = 0;

        $noConceptos = count($factura ['conceptos']);
        $z = 0;
        $arraySumas = [];

        foreach ( $factura ['conceptos'] as $detalle ) {

            $z++;

            if($comprobante['total'] == 0){
                $factura ['traslados'] = [];
                $factura ['retenciones'] = [];
            }

            $concepto = new \stdClass ();
            $concepto->clave = $detalle ['claveSAT'];
            $concepto->cdgItem = Utils::deleteExtraSpaces ( $detalle ['noIdentificacion'] );
            $concepto->dscItem = Utils::deleteExtraSpaces ( $detalle ['descripcion'] );
            $concepto->unmdItem = (isset ( $detalle ['unidadSAT'] )) ? $detalle ['unidadSAT'] : '';
            $concepto->fracArancelaria = (isset ( $detalle ['fracArancelaria'] )) ? $detalle ['fracArancelaria'] : '';
            $concepto->qtyItem = $detalle ['cantidad'];
            $concepto->montoNetoItem = $detalle ['valorUnitario'];
            $concepto->prcNetoItem = $detalle ['cantidad'] * $detalle ['valorUnitario'];
            $concepto->descuento = $detalle ['descuento'];
            $concepto->objetoImp = $detalle ['objetoImp'];

            $concepto->impuestosTrasladados = [ ];

            $base = Utils::formatNumber((($detalle ['cantidad'] * $detalle ['valorUnitario']) - $detalle ['descuento']), $comprobante['decimales']);
            foreach ( $factura ['traslados'] as $traslado ) {

                if ($traslado ['impuesto'] == 'XXX') {

                    $impuestoLcl = new \stdClass ();
                    $impuestoLcl->tipoImp = $traslado ['label'];
                    $impuestoLcl->tasaImp = $traslado ['valor'];
                    $impuestoLcl->tipo = 1;

                    $importeImp = 0;
                    if ($traslado ['factor'] == 'Tasa') {
                        $importeImp = $traslado ['valor'] * $base;
                    } else if ($traslado ['factor'] == 'Cuota') {
                        $importeImp = $traslado ['valor'];
                    }

                    $importeImp = Utils::formatNumber($importeImp, $comprobante['decimales']);

                    $impuestoLcl->montoImp = $importeImp;


                    $datosFactura->impuestosTrasladadosLclTotal += $importeImp;
                    $datosFactura->impuestosTrasladadosLcl[] = $impuestoLcl;

                } else {

                    $impuesto = new \stdClass ();
                    $impuesto->base = $base;
                    $impuesto->factor = $traslado ['factor'];
                    $impuesto->tipoImp = $traslado ['impuesto'];
                    $impuesto->tasaImp = $traslado ['valor'];
                    $impuesto->tipo = 1;

                    $importeImp = 0;
                    if ($traslado ['factor'] == 'Tasa') {
                        $importeImp = $traslado ['valor'] * $impuesto->base;
                    } else if ($traslado ['factor'] == 'Cuota') {
                        $importeImp = $traslado ['valor'];
                    }

                    $importeImp = Utils::formatNumber($importeImp, $comprobante['decimales']);

                    $impuesto->montoImp = $importeImp;

                    $totalImpTrasladados += $importeImp;

                    $concepto->impuestosTrasladados[] = $impuesto;

                    $isNuevo = true;
                    if(count($datosFactura->impuestosTrasladados))
                        foreach($datosFactura->impuestosTrasladados as $impuestoGeneral){


                            if($impuesto->tipoImp == $impuestoGeneral->impuesto && $impuesto->factor == $impuestoGeneral->tipoFactor && $impuesto->tasaImp == $impuestoGeneral->tasaOCuota){
                                $isNuevo = false;
                                $impuestoGeneral->importe += $impuesto->montoImp;
                                $impuestoGeneral->base += $impuesto->base;
                                break;
                            }
                        }

                    if($isNuevo && $traslado['factor'] != 'Exento'){
                        $impuestoGeneral = new \stdClass();
                        $impuestoGeneral->base = $impuesto->base;
                        $impuestoGeneral->importe = $impuesto->montoImp;
                        $impuestoGeneral->impuesto = $impuesto->tipoImp;
                        $impuestoGeneral->tipoFactor = $traslado['factor'];
                        $impuestoGeneral->tasaOCuota = $traslado['valor'];
                        $datosFactura->impuestosTrasladados[] = $impuestoGeneral;
                    }

                }
            }

            $concepto->impuestosRetenidos = [];

            if(isset($factura['retenciones']) && count($factura['retenciones']) > 0)
                foreach ($factura['retenciones'] as $retencion){


                    if ($retencion ['impuesto'] == 'XXX') {

                        $impuestoLcl = new \stdClass ();
                        $impuestoLcl->tipoImp = $retencion ['label'];
                        $impuestoLcl->tasaImp = $retencion ['valor'];
                        $impuestoLcl->tipo = 0;

                        $importeImp = 0;
                        if ($retencion ['factor'] == 'Tasa') {
                            $importeImp = $retencion ['valor'] * $base;
                        } else if ($retencion ['factor'] == 'Cuota') {
                            $importeImp = $retencion ['valor'];
                        }

                        $importeImp = Utils::formatNumber($importeImp, $comprobante['decimales']);

                        $impuesto->montoImp = $importeImp;

                        $datosFactura->impuestosRetenidosLclTotal += $importeImp;
                        $datosFactura->impuestosRetenidosLcl[] = $impuestoLcl;

                    }else{

                        $impuesto = new \stdClass();
                        $impuesto->base = $base;
                        $impuesto->factor = $retencion['factor'];
                        $impuesto->tipoImp = $retencion['impuesto'];
                        $impuesto->tasaImp = $retencion['valor'];
                        $impuesto->tipo = 0;

                        $importeImp = 0;
                        if($retencion['factor'] == 'Tasa'){
                            $importeImp = $retencion['valor'] * $impuesto->base;
                        }else if($retencion['factor'] == 'Cuota'){
                            $importeImp = $retencion['valor'];
                        }

                        $importeImp = Utils::formatNumber($importeImp, $comprobante['decimales']);

                        $impuesto->montoImp = $importeImp;

                        $totalImpRetenidos += $importeImp;

                        $concepto->impuestosRetenidos[] = $impuesto;

                        $isNuevo = true;
                        if(count($datosFactura->impuestosRetenidos))
                            foreach($datosFactura->impuestosRetenidos as $impuestoGeneral){
                                if($impuesto->tipoImp == $impuestoGeneral->impuesto){
                                    $isNuevo = false;
                                    $impuestoGeneral->importe += $impuesto->montoImp;
                                    break;
                                }
                            }

                        if($isNuevo && $retencion['factor'] != 'Exento'){
                            $impuestoGeneral = new \stdClass();
                            $impuestoGeneral->importe = $impuesto->montoImp;
                            $impuestoGeneral->impuesto = $impuesto->tipoImp;
                            $datosFactura->impuestosRetenidos[] = $impuestoGeneral;
                        }

                    }


                }

            $datosFactura->conceptos[] = $concepto;
        }


        $datosFactura->totalImpRetenidos = $totalImpRetenidos;
        $datosFactura->totalImpTrasladados = $totalImpTrasladados;
        $datosFactura->totalImpTrasladados = isset($factura['traslados']) && count($factura['traslados']) > 0 ?
            Utils::formatNumber($factura['traslados'][0]['importe'])
            : $totalImpTrasladados;

        $datosFactura->facturasRelacionadas = [];

        if(count($comprobante['facturasRelacionadas']['uuids']))
            foreach ($comprobante['facturasRelacionadas']['uuids'] as $facturaRelacionada){

                $relacionObj = new \stdClass();
                $relacionObj->uuid = $facturaRelacionada['uuid'];
                $datosFactura->facturasRelacionadas[] = $relacionObj;
            }


        if(isset($factura['comercioExterior'])){

            $datosFactura->comercio = new \stdClass();

            $comercio = $factura['comercioExterior'];

            $comercioEObj = new \stdClass();
            $comercioEObj->Incoterm = $comercio['incoterm'];
            $comercioEObj->clavePedimento = $comercio['pedimento'];
            $comercioEObj->tipoOperacion = $comercio['tipoOperacion'];
            $comercioEObj->rfcExtranjero = $comercio['rfcExtranjero'];
            $comercioEObj->totalUSD = $comercio['totalUSD'];
            $comercioEObj->motivoTraslado = $comercio['motivoTraslado'];

            if(is_object($proveedor->domicilio)){
                $comercioEObj->curp = $proveedor->domicilio->curp;
            }else{
                $comercioEObj->curp = '';
            }

            $domicilioEmisor = new \stdClass();
            $domicilioEmisor->calle = $proveedor->domicilio->calle;
            $domicilioEmisor->nroExterior = $proveedor->domicilio->nroExterior;
            $domicilioEmisor->nroInterior = !empty($proveedor->domicilio->nroInterior) ? $proveedor->domicilio->nroInterior :'';
            $domicilioEmisor->colonia = !empty($proveedor->domicilio->colonia) ? $proveedor->domicilio->colonia :'';
            $domicilioEmisor->municipio = !empty($proveedor->domicilio->municipio) ? $proveedor->domicilio->municipio :'';
            $domicilioEmisor->estado = $proveedor->domicilio->estado;
            $domicilioEmisor->pais = $proveedor->domicilio->pais;
            $domicilioEmisor->codigoPostal = $proveedor->domicilio->codigoPostal;

            $receptor = $comercio['receptor'];

            $domicilioReceptor = new \stdClass();
            $domicilioReceptor->calle = $receptor['calle'];
            $domicilioReceptor->nroExterior = $receptor['nroExterior'] ?? '';
            $domicilioReceptor->nroInterior = $receptor['nroInterior'] ?? '';
            $domicilioReceptor->colonia = $receptor['colonia'] ?? '';
            $domicilioReceptor->municipio = isset($receptor['municipio'])? trim($receptor['municipio']) : '';
            $domicilioReceptor->estado = $receptor['estado'];
            $domicilioReceptor->pais = $receptor['pais'];
            $domicilioReceptor->codigoPostal = $receptor['codigoPostalReceptor'];

            $datosFactura->mercanciasComercio = array();
            foreach ($comercio['mercancias'] as $mercancia){
                $mercanciaObj = new \stdClass();
                $mercanciaObj->valorDolares = $mercancia['valorDolares'] ?? '';
                $mercanciaObj->noIdentificacion = $mercancia['noIdentificacion']  ?? '';
                $mercanciaObj->fraccionArancelaria = $mercancia['fraccionArancelaria']  ?? '';
                $mercanciaObj->cantidadAduana = $mercancia['cantidadAduana']  ?? '';
                $mercanciaObj->unidadAduana = $mercancia['unidadAduana']  ?? '';
                $mercanciaObj->valorUnitarioAduana = Utils::formatNumber($mercancia['valorUnitarioAduana'], $comprobante['decimales']);

                $datosFactura->mercanciasComercio [] = $mercanciaObj;
            }

            $datosFactura->comercio->datos = $comercioEObj;
            $datosFactura->comercio->emisor = $domicilioEmisor;
            $datosFactura->comercio->receptor = $domicilioReceptor;
        }

        $log = print_r($datosFactura, true);
        Log::error($log);

        $xml = XMLUtils::createXML40($datosFactura, $proveedor);

        $sello = $xml->query('//cfdi:Comprobante')[0]->getAttribute('Sello');

        $nombreArchivo = "$proveedor->rFCEmisor-" .date('YmdHis');

        file_put_contents("tmp/$nombreArchivo.xml", $xml);

        $urlTimbrado = "https://facturacion.finkok.com/servicios/soap/stamp.wsdl";
        $usuarioInt = "saul.flores@soliat.com";
        $passwordInt = "S3rgio.Fl0res";

        if ($proveedor->id_proveedor == 1089) {

            $urlTimbrado = "https://demo-facturacion.finkok.com/servicios/soap/stamp.wsdl";
            $usuarioInt = "saul.flores@soliat.com";
            $passwordInt = "S3rgio.Fl0res";
        }

        $params = array ();
        $params ['xml'] = $xml;
        $params ['username'] = $usuarioInt;
        $params ['password'] = $passwordInt;


        $client = new SoapClient ( $urlTimbrado, array (
            'encoding' => 'UTF-8',
            "connection_timeout" => 250
        ) );
        $client->soap_defencoding = "UTF-8";
        $resultado = $client->__soapCall ( 'stamp', array (
            $params
        ) );

        $logToSave = print_r ( $resultado, true );

        $log = env ( 'DIR_LOGS' ) . "/" . date ( "Y-m-d" ) . ".log";
        $log2 = env ( 'DIR_LOGS' ) . "/serch.log";

        file_put_contents($log2, $logToSave, FILE_APPEND);

        $fp = fopen ( $log, "a" );
        fwrite ( $fp, "\n\n===" . date ( "Y-m-d:H:i:s" ) . "\n\n" );
        fwrite ( $fp, "\n\n$nombreArchivo\n\n" );
        fwrite ( $fp, $logToSave );
        fwrite ( $fp, "\n\n===" );
        fclose ( $fp );

        $success = false;
        $errorCode = 0;
        $errortext = '';

        if (is_object ( $resultado ) && isset ( $resultado->stampResult ) && isset ( $resultado->stampResult->xml ) && !empty($resultado->stampResult->xml)) {
            $success = true;

            $xmlTimbrado = new \DOMDocument ( "1.0", "uft-8" );
            $xmlTimbrado->loadXML ( $resultado->stampResult->xml );

            $idDoc = new IdDoc();

            $timbreFiscal = $xmlTimbrado->getElementsByTagName ( 'TimbreFiscalDigital' );

            foreach ( $timbreFiscal as $timbreFiscal ) {

                $fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );
                $fechaTimbradoArray = explode(".",$fechaTimbrado);

                $idDoc->version = $timbreFiscal->getAttribute ( 'Version' );
                $idDoc->fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );
                $idDoc->selloCFD = $timbreFiscal->getAttribute ( 'SelloCFD' );
                $idDoc->noCertificadoSAT = $timbreFiscal->getAttribute ( 'NoCertificadoSAT' );
                $idDoc->selloSAT = $timbreFiscal->getAttribute ( 'SelloSAT' );
                $idDoc->uUID = $timbreFiscal->getAttribute ( 'UUID' );
                $idDoc->sello = $sello;
                $idDoc->rfcProvCertif = $timbreFiscal->getAttribute ( 'RfcProvCertif' );
            }

            $isPagado = 0;
            if($datosFactura->metodoDePago == 'PUE')
                $isPagado = 1;

            $facturaObj = new Factura();
            $facturaObj->id_proveedor = $factura['idProveedor'];
            $facturaObj->id_cliente = 0;
            $facturaObj->id_certificadoProveedor = $certificadoHaUsar->id;
            $facturaObj->nmbEmisor = $proveedor->nmbEmisor;
            $facturaObj->rFCEmisor = $proveedor->rFCEmisor;
            $facturaObj->nmbRecep = $datosFactura->nmbRecep;
            $facturaObj->rFCRecep = $datosFactura->rFCRecep;
            $facturaObj->pais = $datosFactura->pais;
            $facturaObj->regimenFiscal = $proveedor->regimenFiscal33;
            $facturaObj->timeStamp = $timeStamp;
            $facturaObj->noFactura = $noFactura->noFactura;
            $facturaObj->version = "4.0";
            $facturaObj->generadoPor = 4;
            $facturaObj->nota = (isset($comprobante['comentario']))? Utils::deleteExtraSpaces($comprobante['comentario']) : '';
            $facturaObj->tipoDeComprobante = $datosFactura->tipoDeComprobante;
            $facturaObj->precission = $datosFactura->precission;
            $facturaObj->exportacion = $datosFactura->exportacion;
            $facturaObj->status = 1;
            $facturaObj->isPagado = $isPagado;
            $facturaObj->regimenFiscalReceptor = $datosFactura->regimenFiscalReceptor;
            $facturaObj->domicilioFiscalReceptor = $datosFactura->domicilioFiscalReceptor;
            $facturaObj->numRegIdTrib = $datosFactura->numRegIdTrib;
            $facturaObj->save();


            $idDoc->id_factura = $facturaObj->id_factura;
            $idDoc->serie = $datosFactura->serie;
            $idDoc->folio = $noFactura->noFactura;
            $idDoc->formaPago = $datosFactura->formaPago;
            $idDoc->condicionesDePago = $datosFactura->condicionesDePago;
            $idDoc->lugarExpedicion = $datosFactura->lugarExpedicion;
            $idDoc->usoCFDI = $datosFactura->usoCFDI;
            $idDoc->metodoDePago = $datosFactura->metodoDePago;
            $idDoc->sello = $sello;
            $idDoc->tipoFacturasRelacionadas = $datosFactura->tipoFacturasRelacionadas;
            $idDoc->save();


            $totales = new Totales();
            $totales->id_factura = $facturaObj->id_factura;
            $totales->moneda = $datosFactura->moneda;
            $totales->tipoCambio = $datosFactura->tipoCambio;
            $totales->subTotal = $datosFactura->subtotal;
            $totales->mntBase = $datosFactura->mntBase;
            $totales->vlrPagar = $datosFactura->total;
            $totales->descuento = $datosFactura->descuento;
            $totales->pesoTotal = (isset($factura['totalWeight'])? $factura['totalWeight'] : 0);
            $totales->save();

            $detalles = array();

            foreach ($datosFactura->conceptos as $concepto){

                $conceptoObj = new Concepto();
                $conceptoObj->clave = $concepto->clave;
                $conceptoObj->cdgItem = $concepto->cdgItem;
                $conceptoObj->dscItem = $concepto->dscItem;
                $conceptoObj->unmdItem = $concepto->unmdItem;
                $conceptoObj->qtyItem = $concepto->qtyItem;
                $conceptoObj->montoNetoItem = $concepto->montoNetoItem;
                $conceptoObj->prcNetoItem = $concepto->prcNetoItem;
                $conceptoObj->descuento = $concepto->descuento;
                $conceptoObj->objetoImp = $concepto->objetoImp;
                $conceptoObj->id_factura = $facturaObj->id_factura;
                $conceptoObj->save();

                foreach ($concepto->impuestosTrasladados as $impuesto){

                    $impuestoObj = new ExImpuestos();
                    $impuestoObj->base = $impuesto->base;
                    $impuestoObj->factor = $impuesto->factor;
                    $impuestoObj->tipoImp = $impuesto->tipoImp;
                    $impuestoObj->tasaImp = $impuesto->tasaImp;
                    $impuestoObj->tipo = $impuesto->tipo;
                    $impuestoObj->montoImp = $impuesto->montoImp;
                    $impuestoObj->id_detalle = $conceptoObj->id_detalle;
                    $impuestoObj->save();
                }

                foreach ($concepto->impuestosRetenidos as $impuesto){

                    $impuestoObj = new ExImpuestos();
                    $impuestoObj->base = $impuesto->base;
                    $impuestoObj->factor = $impuesto->factor;
                    $impuestoObj->tipoImp = $impuesto->tipoImp;
                    $impuestoObj->tasaImp = $impuesto->tasaImp;
                    $impuestoObj->tipo = $impuesto->tipo;
                    $impuestoObj->montoImp = $impuesto->montoImp;
                    $impuestoObj->id_detalle = $conceptoObj->id_detalle;
                    $impuestoObj->save();
                }
            }

            foreach ($datosFactura->facturasRelacionadas as $facturaRelacionada){

                $facturaRelacionadaObj = new FacturasRelacionadas();
                $facturaRelacionadaObj->id_factura = $facturaObj->id_factura;
                $facturaRelacionadaObj->uuid = $facturaRelacionada->uuid;
                $facturaRelacionadaObj->save();

            }


            if(count($datosFactura->impuestosRetenidosLcl) > 0)
                foreach ($datosFactura->impuestosRetenidosLcl as $impuesto){

                    $impuestoObj = new ExImpuestos();
                    $impuestoObj->tipoImp = $impuesto->tipoImp;
                    $impuestoObj->tasaImp = $impuesto->tasaImp;
                    $impuestoObj->tipo = $impuesto->tipo;
                    $impuestoObj->montoImp = $impuesto->montoImp;
                    $impuestoObj->id_factura = $facturaObj->id_factura;
                    $impuestoObj->save();
                }

            if(count($datosFactura->impuestosTrasladadosLcl) > 0)
                foreach ($datosFactura->impuestosTrasladadosLcl as $impuesto){

                    $impuestoObj = new ExImpuestos();
                    $impuestoObj->tipoImp = $impuesto->tipoImp;
                    $impuestoObj->tasaImp = $impuesto->tasaImp;
                    $impuestoObj->tipo = $impuesto->tipo;
                    $impuestoObj->montoImp = $impuesto->montoImp;
                    $impuestoObj->id_factura = $facturaObj->id_factura;
                    $impuestoObj->save();
                }



            if(isset($datosFactura->comercio) && $datosFactura->comercio != null){

                $comercioEObjS = new ComercioE();
                $comercioEObjS->id_factura = $facturaObj->id_factura;
                $comercioEObjS->Incoterm = $datosFactura->comercio->datos->Incoterm;
                $comercioEObjS->clavePedimento = $datosFactura->comercio->datos->clavePedimento;
                $comercioEObjS->tipoOperacion = $datosFactura->comercio->datos->tipoOperacion;
                $comercioEObjS->rfcExtranjero = $datosFactura->comercio->datos->rfcExtranjero;
                $comercioEObjS->curp = $datosFactura->comercio->datos->curp;
                $comercioEObjS->motivoTraslado = $datosFactura->comercio->datos->motivoTraslado;
                $comercioEObjS->totalUSD = $datosFactura->comercio->datos->totalUSD;
                $comercioEObjS->save();

                $domicilioEmisorObjS = new DomFiscalFact();
                $domicilioEmisorObjS->id_factura = $facturaObj->id_factura;
                $domicilioEmisorObjS->calle = $datosFactura->comercio->emisor->calle;
                $domicilioEmisorObjS->nroExterior = $datosFactura->comercio->emisor->nroExterior;
                $domicilioEmisorObjS->nroInterior = $datosFactura->comercio->emisor->nroInterior;
                $domicilioEmisorObjS->colonia = $datosFactura->comercio->emisor->colonia;
                $domicilioEmisorObjS->municipio = $datosFactura->comercio->emisor->municipio;
                $domicilioEmisorObjS->estado = $datosFactura->comercio->emisor->estado;
                $domicilioEmisorObjS->pais = $datosFactura->comercio->emisor->pais;
                $domicilioEmisorObjS->codigoPostal = $datosFactura->comercio->emisor->codigoPostal;
                $domicilioEmisorObjS->save();


                $domicilioReceptorObjS = new DomFiscalRcpFact();
                $domicilioReceptorObjS->id_factura = $facturaObj->id_factura;
                $domicilioReceptorObjS->calle = $datosFactura->comercio->receptor->calle;
                $domicilioReceptorObjS->nroExterior = $datosFactura->comercio->receptor->nroExterior;
                $domicilioReceptorObjS->nroInterior = $datosFactura->comercio->receptor->nroInterior;
                $domicilioReceptorObjS->colonia = $datosFactura->comercio->receptor->colonia;
                $domicilioReceptorObjS->municipio = $datosFactura->comercio->receptor->municipio;
                $domicilioReceptorObjS->estado = $datosFactura->comercio->receptor->estado;
                $domicilioReceptorObjS->pais = $datosFactura->comercio->receptor->pais;
                $domicilioReceptorObjS->codigoPostal = $datosFactura->comercio->receptor->codigoPostal;
                $domicilioReceptorObjS->save();

                foreach ($datosFactura->mercanciasComercio as $marcancia){

                    $mercanciaObj = new MercanciaComercio();
                    $mercanciaObj->id_factura = $facturaObj->id_factura;
                    $mercanciaObj->noIdentificacion = $marcancia->noIdentificacion;
                    $mercanciaObj->fraccionArancelaria = $marcancia->fraccionArancelaria;
                    $mercanciaObj->cantidadAduana = $marcancia->cantidadAduana;
                    $mercanciaObj->unidadAduana = $marcancia->unidadAduana;
                    $mercanciaObj->valorUnitarioAduana = $marcancia->valorUnitarioAduana;
                    $mercanciaObj->valorDolares = $marcancia->valorDolares;
                    $mercanciaObj->save();

                }



            }


            $facturaResult = $datosFactura->serie . $datosFactura->folio;

            $response['idFactura'] = $facturaObj->id_factura;
            $response['resultCode'] = '1';
            $response['noFactura'] = $noFactura->noFactura;
            $response['fecha'] = $timeStamp;
            $response['errortext'] = '';
            $response['uuid'] = $idDoc->uUID;
            $response['nombreArchivo'] = $nombreArchivo;


            if(isset($factura['noOP']) && $factura['noOP'] != ""){

                $datosEspeciales = new DatosEspeciales();
                $datosEspeciales->id_factura = $facturaObj->id_factura;
                $datosEspeciales->noOP = $factura['noOP'];
                $datosEspeciales->save();
            }


        }else{

            if(is_object($resultado)){
                $errorCode = $resultado->stampResult->Incidencias->Incidencia->CodigoError;
                $errortext = $resultado->stampResult->Incidencias->Incidencia->MensajeIncidencia;
            }else{
                $errorCode = $resultado[6];
                $errortext = $resultado[7];
            }


            $response['idFactura'] = '';
            $response['resultCode'] = $errorCode;
            $response['errortext'] = $errortext;
            $response['noFactura'] = '';
            $response['nombreArchivo'] = $nombreArchivo;
            $response['fecha'] = '';
        }


        return $response;


    }


	public function enviarFactura($factura){

	    $factura = $factura['correo'];

	    $nota = $factura['nota'];
	    $id_proveedor = $factura['id_proveedor'];
	    $id_factura = $factura['id_factura'];
	    $otrosIngresos = isset($factura['otrosIngresos']) ? $factura['otrosIngresos'] : 0 ;
	    $email = $factura['email'];

	    $toLog = print_r($factura, true);
        Log::error($toLog);

	    $response = [];

	    $metodosDePago = array('' => '', 'PUE' => 'PUE - Pago en una sola exhibición', 'PPD' => 'PPD - Pago en parcialidades o diferido');
	    $impuestos = array('001' => 'ISR', '002' => 'IVA', '003' => 'IEPS');

	    $proveedor = Proveedor::where ( 'id_proveedor', "=", $id_proveedor )->first ();

	    $datosFactura = Utils::obtenerDatosFactura($id_factura, $id_proveedor);
	    if(trim($datosFactura->tipoFacturasRelacionadas) != ''){

	        $tipoRelaciones = array(
	            '01' => 'Nota de crédito de los documentos relacionados',
	            '02' => 'Nota de débito de los documentos relacionados',
	            '03' => 'Devolución de mercancía sobre facturas o traslados previos',
	            '04' => 'Sustitución de los CFDI previos',
	            '05' => 'Traslados de mercancias facturados previamente',
	            '06' => 'Factura generada por los traslados previos',
	            '07' => 'CFDI por aplicación de anticipo'
	        );

	        $datosFactura->labelFacturasRelacionadas = $tipoRelaciones[$datosFactura->tipoFacturasRelacionadas];

	    }

	    $xml = XMLUtils::createXML33($datosFactura, null);

	    $datosFactura->noFactura = str_pad ( $datosFactura->noFactura, 5, "0", STR_PAD_LEFT );
	    $datosFactura->timeStamp = date_format ( new \DateTime ( $datosFactura->timeStamp ), 'Y-m-d\TH:i:s' );

	    $usoCFDI = UsoCFDI::where('codigo', '=', $datosFactura->usoCFDI)->first();
	    $datosFactura->usoCFDI = "$usoCFDI->codigo - $usoCFDI->descripcion";

	    $regimenFiscal = CatalogoRegimenFiscal::where('code', '=', $datosFactura->regimenFiscal)->first();
	    $datosFactura->regimenFiscal = $regimenFiscal->descripcion;

	    if($datosFactura->formaPago != ''){
	        $formaDePago = FormaPago::where('codigo', '=', $datosFactura->formaPago)->first();
	        $datosFactura->formaPago = $formaDePago->codigo . ' - ' . $formaDePago->descripcion;
	    }

	    $datosFactura->metodoDePago = $metodosDePago[$datosFactura->metodoDePago];
	    $datosFactura->total = Utils::formatNumber ( $datosFactura->total, $datosFactura->precission );
	    $datosFactura->cantidadLetra = NumeroLetra::num2letras($datosFactura->total, false, false);

	    $whole = floor($datosFactura->total);
	    $datosFactura->decimales = $datosFactura->total - $whole;
	    $datosFactura->decimales = ($datosFactura->decimales < 10)? '0' . $datosFactura->decimales : $datosFactura->decimales;

        $datosFactura->unidadesMedidaAduana = array('01' => 'KILO', '02' => 'GRAMO', '06' => 'PIEZA', '14' => 'TONELADA', '20' => 'CAJA', '99' => 'SERVICIO');

	    $tiposDocumentos = [];
	    $tiposDocumentos['I'] = 'Ingreso';
	    $tiposDocumentos['E'] = 'Egreso';
	    $tiposDocumentos['T'] = 'Traslado';
	    $tiposDocumentos['P'] = 'Pago';

	    $adicionales = ['tipoDocumento' => $tiposDocumentos, 'impuestos' => $impuestos];

	    $datosFactura->subtotal = Utils::formatNumber ( $datosFactura->subtotal, $datosFactura->precission );
	    $datosFactura->total = Utils::formatNumber ( $datosFactura->total, $datosFactura->precission );
	    $datosFactura->imagen = env('DIR_LOGOS'). $proveedor->imagen;
	    $datosFactura->color = $proveedor->color;

        if( !file_exists($datosFactura->imagen) || is_dir($datosFactura->imagen)){
            $datosFactura->base64 = '';
        }else{
            $type = pathinfo($datosFactura->imagen, PATHINFO_EXTENSION);
            $data = file_get_contents($datosFactura->imagen);
            $base64 = 'data:image/' . $type . ';base64,' . base64_encode($data);
            $datosFactura->base64 = $base64;
        }

        $logoRecycling = env('DIR_LOGOS')."recycling-sitma.png";
        $type = pathinfo($logoRecycling, PATHINFO_EXTENSION);
        $data2 = file_get_contents($logoRecycling);
        $base642 = 'data:image/' . $type . ';base64,' . base64_encode($data2);
        $datosFactura->base64Rec = $base642;

	    $total_factura = number_format($datosFactura->total,6);
	    $total_factura = str_replace(",", "", $total_factura);
	    $total_factura = str_pad($total_factura, 17, "0", STR_PAD_LEFT);

	    $datosFactura->qr = '?re='.$datosFactura->rFCEmisor.'&rr='.$datosFactura->rFCRecep.'&tt='.$total_factura.'&id='.$datosFactura->uUID;

	    if(count($datosFactura->pagos)){
	        $datosFactura->totalPagos = 0;
	        foreach ($datosFactura->pagos as $pago){
	            $datosFactura->totalPagos += $pago->Monto;

	            $pago->FechaPago = new \DateTime ( $pago->FechaPago );
	            $pago->FechaPago = date_format ( $pago->FechaPago, 'Y-m-d\TH:i:s' );
	        }
	        $datosFactura->totalPagos = $datosFactura->totalPagos;
	    }

	    $disenoFactura = 'pdf.diseno2';
	    if($proveedor->template33 != ''){
	        $disenoFactura = 'pdf.'.$proveedor->template33;
	    }

	    $datosFactura->otrosIngresos = $otrosIngresos;

	    if($datosFactura->tipoDeComprobante == 'P')
	        $disenoFactura = 'pdf.pago';

	        $html = view($disenoFactura, ['factura' => $datosFactura, 'adicionales' => $adicionales])->render();

	        $fileName = $datosFactura->rFCEmisor . date('YmdHis') . "-$datosFactura->serie$datosFactura->noFactura";

	        $domPDF = new Dompdf();
	        $domPDF->loadHtml($html);
	        $domPDF->render();
	        $outputPDF = $domPDF->output();

	        file_put_contents("tmp/$fileName.pdf", $outputPDF);
	        file_put_contents("tmp/$fileName.xml", $xml);

	        $dataEmail = array(
	            'nombreEmisor' => $datosFactura->nmbEmisor,
	            'rFCEmisor' => $datosFactura->rFCEmisor,
	            'imagen' => $datosFactura->imagen,
	            'email' => $email,
	            'fecha' => $datosFactura->fechaEmis,
	            'pdfFile' => "tmp/$fileName.pdf",
	            'xmlFile' => "tmp/$fileName.xml",
	            'nota' => $nota
	        );

	        try{


    	        Mail::send('emails.factura', $dataEmail, function ($message) use ($dataEmail) {
    	            $message->from('noreply@soliat.com', $dataEmail['nombreEmisor']);
    	            $message->to($dataEmail['email']);
    	            $message->subject("Envío de comprobante CFDI");
    	            $message->attach($dataEmail['pdfFile']);
    	            $message->attach($dataEmail['xmlFile']);
    	        });

    	            $response['resultCode'] = 1;
    	            $response['errortext'] = '';

	        }catch (\Exception $e){
	            $response['resultCode'] = 1000;
	            $response['errortext'] = 'Error al enviar el email';
	        }

	            return $response;

	}

	public function facturarPago($data){

	    ini_set('default_socket_timeout', 250);

        Log::error("Sergio Flores");
        Log::error($data);

	    $factura = $data['factura'];

	    $proveedor = Proveedor::find($factura['id_proveedor']);

	    $comprobante = $factura['comprobante'];
	    $receptor = $factura['receptor'];
	    $nombreArchivo = '';
	    $response = [];


	    $timeStamp = date("Y-m-d H:i:s" , strtotime("-2 minutes"));
	    $noFactura = DB::select("SELECT MAX(noFactura) as noFactura FROM Factura f JOIN IdDoc i ON f.id_factura = i.id_factura WHERE id_proveedor = " . $factura['id_proveedor'] . " AND i.serie = '" . $comprobante['serie'] ."'")[0];
	    $noFactura->noFactura++;
	    $certificadoHaUsar = CertificadoProveedor::where('id_proveedor', '=', $factura['id_proveedor'])->where('status', '=', 1)->first();

	    $datosFactura = new \stdClass();
	    $datosFactura->timeStamp = $timeStamp;
	    $datosFactura->tipoDeComprobante = 'P';
	    $datosFactura->serie = $comprobante['serie'];
	    $datosFactura->folio = $noFactura->noFactura;
	    $datosFactura->noCertificado = $certificadoHaUsar->noCertificado;
	    $datosFactura->certificado = $certificadoHaUsar->certificado;
	    $datosFactura->mntBase = 0;
	    $datosFactura->subtotal = 0;
	    $datosFactura->moneda = 'XXX';
	    $datosFactura->total = 0;
	    $datosFactura->formaPago = '';
	    $datosFactura->condicionesDePago = '';
	    $datosFactura->descuento = 0;
	    $datosFactura->precission = 0;
	    $datosFactura->tipoCambio = 1;
	    $datosFactura->lugarExpedicion = Utils::deleteExtraSpaces($comprobante['LugarExpedicion']);
	    $datosFactura->usoCFDI = 'CP01';
	    $datosFactura->metodoDePago = '';
	    $datosFactura->condicionesDePago = '';
	    $datosFactura->tipoFacturasRelacionadas = $comprobante['facturasRelacionadas']['tipoRelacion'];
	    $datosFactura->rFCEmisor = $proveedor->rFCEmisor;
	    $datosFactura->nmbEmisor = $proveedor->nmbEmisor;
	    $datosFactura->rFCRecep = $receptor['rfc'];
	    $datosFactura->nmbRecep = $receptor['nombre'];
	    $datosFactura->regimenFiscal = $proveedor->regimenFiscal33;
        $datosFactura->regimenFiscalReceptor = $receptor ['regimenFiscalReceptor'];
        $datosFactura->domicilioFiscalReceptor = $receptor ['codigoPostal'];
	    $datosFactura->numRegIdTrib = isset($receptor['rfcExtranjero'])? $receptor['rfcExtranjero'] : '';
	    $datosFactura->pais = '';
        $datosFactura->exportacion = '01';


	    $datosFactura->conceptos = [];
	    $datosFactura->impuestosTrasladados = [];
	    $datosFactura->impuestosRetenidos = [];
	    $totalImpRetenidos = 0;
	    $totalImpTrasladados = 0;

	    $detalle =  array('clave' => '84111506', 'codigo' => '', 'nombre' => 'Pago', 'unidad' => 'ACT', 'qty' => 1, 'precioU' => 0, 'descuento' => 0);
	    $factura['detalles'] = [];
	    $factura['detalles'][] = $detalle;

        $totalesP = new \stdClass ();
        $totalesP->totalRetencionesIVA = 0;
        $totalesP->totalRetencionesISR = 0;
        $totalesP->totalRetencionesIEPS = 0;
        $totalesP->totalTrasladosBaseIVA16 = 0;
        $totalesP->totalTrasladosImpuestoIVA16 = 0;
        $totalesP->totalTrasladosBaseIVA8 = 0;
        $totalesP->totalTrasladosImpuestoIVA8 = 0;
        $totalesP->totalTrasladosBaseIVA0 = 0;
        $totalesP->totalTrasladosImpuestoIVA0 = 0;
        $totalesP->totalTrasladosBaseIVAExento = 0;
        $totalesP->montoTotalPagos = 0;

	    foreach ($factura['detalles'] as $detalle){

	        $concepto = new \stdClass();
	        $concepto->clave = $detalle['clave'];
	        $concepto->cdgItem = Utils::deleteExtraSpaces($detalle['codigo']);
	        $concepto->dscItem = Utils::deleteExtraSpaces($detalle['nombre']);
	        $concepto->unmdItem = (isset($detalle['unidad']))? $detalle['unidad'] : '';
	        $concepto->qtyItem = $detalle['qty'];
	        $concepto->montoNetoItem = $detalle['precioU'];
	        $concepto->prcNetoItem = $detalle['qty'] * $detalle['precioU'];
	        $concepto->descuento = $detalle['descuento'];
            $concepto->objetoImp = '01';

	        $concepto->impuestosTrasladados = [];
	        $concepto->impuestosRetenidos = [];
	        $datosFactura->conceptos[] = $concepto;
	    }

	    $datosFactura->pagos = [];
        $montoTotalPagos = 0;
	    foreach ($factura['pagos'] as $pago){

	        $pagoObj = new \stdClass();
	        $pagoObj->FechaPago = $pago['fechaPago'];
	        $pagoObj->FormaDePagoP = $pago['formaPago'];
	        $pagoObj->MonedaP = $pago['moneda'];
	        $pagoObj->TipoCambioP = isset($pago['tipoCambio']) ? trim($pago['tipoCambio']) : '';
            if($pagoObj->TipoCambioP == '')
                $pagoObj->TipoCambioP = 0;
            $montoTotalPagos += $pagoObj->Monto = $pago ['totalPago'];
	        $pagoObj->banco = isset($pago ['banco']) ? $pago ['banco'] : '';
	        $pagoObj->cuenta = isset($pago ['cuenta']) ? $pago ['cuenta'] : '';
            $pagoObj->rfcEmisorCtaBen = isset($pago ['rfcEmisorCtaBen']) ? trim($pago ['rfcEmisorCtaBen']) : '';
            $pagoObj->ctaBeneficiario = isset($pago ['ctaBeneficiario']) ? trim($pago ['ctaBeneficiario']) : '';
            $pagoObj->noOperacion = $pago ['noOperacion'] ?? '';

	        $pagoObj->documentosRelacionado = [];

	        foreach ($pago['documentoRelacionado'] as $documentoRelacionado){

	            $doctoRelacionado = new \stdClass();
	            $doctoRelacionado->IdDocumento = $documentoRelacionado['uuid'];
	            $doctoRelacionado->MonedaDR = $documentoRelacionado['moneda'];
                $doctoRelacionado->TipoCambioDR = (isset($documentoRelacionado ['tipoCambioDR']) && $documentoRelacionado ['tipoCambioDR'] > 1) ? $documentoRelacionado ['tipoCambioDR'] : null;
	            $doctoRelacionado->MetodoDePagoDR = 'PPD';
	            $doctoRelacionado->NumParcialidad = $documentoRelacionado['parcialidad'];
	            $doctoRelacionado->ImpSaldoAnt = $documentoRelacionado['saldoAnterior'];
	            $doctoRelacionado->ImpPagado = $documentoRelacionado['pago'];
	            $doctoRelacionado->ImpSaldoInsoluto = $documentoRelacionado['saldoInsoluto'];
                $doctoRelacionado->ObjetoImpDR = $documentoRelacionado ['objetoImp'];
                $doctoRelacionado->MontoPagoMoneda = $documentoRelacionado ['montoPagoMoneda'] ?? 0;

                $equivalenciaDR = 1;
                if($doctoRelacionado->MonedaDR == 'USD' && $pagoObj->MonedaP == 'MXN' ){
                    $equivalenciaDR = Utils::formatNumber ($doctoRelacionado->ImpPagado / $doctoRelacionado->MontoPagoMoneda, 6);
                    while($doctoRelacionado->ImpPagado / $equivalenciaDR > $doctoRelacionado->MontoPagoMoneda) {
                        $equivalenciaDR += 0.000001;
                    }
                }
                $doctoRelacionado->EquivalenciaDR = $equivalenciaDR;

                if(isset($documentoRelacionado['impuestos'])){

                    $impuestos = new \stdClass ();
                    $impuestos->impuestosRetenidos = [];
                    $impuestos->impuestosTrasladados = [];

                    foreach ($documentoRelacionado['impuestos']['impuestosRetenidos'] as $impuestoRetenido ){
                        $retencionesDR = new \stdClass ();
                        $retencionesDR->base = $impuestoRetenido['base'];
                        $retencionesDR->tipoFactor = $impuestoRetenido['factor'];
                        $retencionesDR->importe = $impuestoRetenido['montoImp'];
                        $retencionesDR->tasaCuota = $impuestoRetenido['tasaImp'];
                        $retencionesDR->impuesto = $impuestoRetenido['tipoImp'];
                        $retencionesDR->tipo = 0;

                        $impuestos->impuestosRetenidos [] = $retencionesDR;
                    }

                    foreach ($documentoRelacionado['impuestos']['impuestosTrasladados'] as $impuestoTrasladado ){
                        $trasladoDR = new \stdClass ();
                        $trasladoDR->base = $impuestoTrasladado['base'];
                        $trasladoDR->tipoFactor = $impuestoTrasladado['factor'];
                        $trasladoDR->importe = $impuestoTrasladado['montoImp'];
                        $trasladoDR->tasaCuota = $impuestoTrasladado['tasaImp'];
                        $trasladoDR->impuesto = $impuestoTrasladado['tipoImp'];
                        $trasladoDR->tipo = 1;

                        $impuestos->impuestosTrasladados [] = $trasladoDR;
                    }

                    $doctoRelacionado->impuestos = $impuestos;
                }

	            $pagoObj->documentosRelacionado[] = $doctoRelacionado;
	        }



            if((isset($pago ['impuestosRetenidos']) && count($pago ['impuestosRetenidos']) > 0)
                || (isset($pago ['impuestosTrasladados']) && count($pago ['impuestosTrasladados']) > 0)){

                $impuestos = new \stdClass ();
                $impuestos->impuestosRetenidos = [];
                $impuestos->impuestosTrasladados = [];

                if(isset($pago ['impuestosRetenidos']))
                    foreach ($pago ['impuestosRetenidos'] as $impuestosRetenido){
                        $retencionesDR = new \stdClass ();
                        $retencionesDR->importe = $impuestosRetenido['montoImp'];
                        $retencionesDR->impuesto = $impuestosRetenido['tipoImp'];

                        if($retencionesDR->impuesto == '001'){
                            $totalesP->totalRetencionesISR += $retencionesDR->importe;
                        } else if($retencionesDR->impuesto == '002'){
                            $totalesP->totalRetencionesIVA += $retencionesDR->importe;
                        } else if($retencionesDR->impuesto == '003'){
                            $totalesP->totalRetencionesIEPS += $retencionesDR->importe;
                        }


                        $impuestos->impuestosRetenidos [] = $retencionesDR;
                    }

                if(isset($pago ['impuestosTrasladados']))
                    foreach ($pago ['impuestosTrasladados'] as $impuestoTrasladado){
                        $trasladoDR = new \stdClass ();
                        $trasladoDR->base = $impuestoTrasladado['base'];
                        $trasladoDR->tipoFactor = $impuestoTrasladado['factor'];
                        $trasladoDR->importe = $impuestoTrasladado['montoImp'];
                        $trasladoDR->tasaCuota = $impuestoTrasladado['tasaImp'];
                        $trasladoDR->impuesto = $impuestoTrasladado['tipoImp'];
                        $impuestos->impuestosTrasladados [] = $trasladoDR;

                        if($trasladoDR->impuesto == '002'){
                            if($trasladoDR->tipoFactor == 'Exento'){
                                $totalesP->totalTrasladosBaseIVAExento += $trasladoDR->base;
                            } else if($trasladoDR->tasaCuota == 0.16){
                                $totalesP->totalTrasladosBaseIVA16 += $trasladoDR->base;
                                $totalesP->totalTrasladosImpuestoIVA16 += $trasladoDR->importe;
                            }else if($trasladoDR->tasaCuota == 0.08){
                                $totalesP->totalTrasladosBaseIVA8 += $trasladoDR->base;
                                $totalesP->totalTrasladosImpuestoIVA8 += $trasladoDR->importe;
                            }else if($trasladoDR->tasaCuota == 0){
                                $totalesP->totalTrasladosBaseIVA0 += $trasladoDR->base;
                                $totalesP->totalTrasladosImpuestoIVA0 += $trasladoDR->importe;
                            }
                        }

                    }

                $pagoObj->impuestos = $impuestos;
            }

	        $datosFactura->pagos[] = $pagoObj;
	    }


        $datosFactura->montoTotalPagos = $montoTotalPagos;
        $datosFactura->totalImpRetenidos = $totalImpRetenidos;
        $datosFactura->totalImpTrasladados = $totalImpTrasladados;

	    $datosFactura->facturasRelacionadas = [];

	    if(count($factura['facturasRelacionadas']['uuids']))
	        foreach ($factura['facturasRelacionadas']['uuids'] as $facturaRelacionada){

	            $relacionObj = new \stdClass();
	            $relacionObj->uuid = $facturaRelacionada['uuid'];
	            $datosFactura->facturasRelacionadas[] = $relacionObj;

	    }

        $totalesP->montoTotalPagos = $montoTotalPagos;
        $datosFactura->totalesPagos = $totalesP;

	    $xml = XMLUtils::createXML40($datosFactura, $proveedor);

	    $sello = $xml->query('//cfdi:Comprobante')[0]->getAttribute('Sello');

        Log::error('llega acá 1');

	    $nombreArchivo = "$proveedor->rFCEmisor-" .date('YmdHis');
	    file_put_contents("tmp/$nombreArchivo.xml", $xml);

        Log::error('llega acá 2');

	    $urlTimbrado = "https://facturacion.finkok.com/servicios/soap/stamp.wsdl";
		$usuarioInt = "saul.flores@soliat.com";
		$passwordInt = "S3rgio.Fl0res";

        Log::error('llega acá 3');

		if ($proveedor->id_proveedor == 1089) {

			$urlTimbrado = "https://demo-facturacion.finkok.com/servicios/soap/stamp.wsdl";
			$usuarioInt = "saul.flores@soliat.com";
			$passwordInt = "S3rgio.Fl0res";

		}

		$params = array ();
		$params ['xml'] = $xml;
		$params ['username'] = $usuarioInt;
		$params ['password'] = $passwordInt;

        Log::error('llega acá 4');

        $client = new SoapClient ( $urlTimbrado, array (
            'encoding' => 'UTF-8',
            "connection_timeout" => 250
        ) );
        $client->soap_defencoding = "UTF-8";
        $resultado = $client->__soapCall ( 'stamp', array (
            $params
        ) );

		$logToSave = print_r ( $resultado, true );

		$log = env ( 'DIR_LOGS' ) . "/" . date ( "Y-m-d" ) . ".log";
		$fp = fopen ( $log, "a" );
		fwrite ( $fp, "\n\n===" . date ( "Y-m-d:H:i:s" ) . "\n\n" );
		fwrite ( $fp, "\n\n$nombreArchivo\n\n" );
		fwrite ( $fp, $logToSave );
		fwrite ( $fp, "\n\n===" );
		fclose ( $fp );

        Log::error('llega acá 6');

		$success = false;
		$errorCode = 0;
		$errortext = '';
		$facturaResult = '';


        if (is_object ( $resultado ) && isset ( $resultado->stampResult ) && isset ( $resultado->stampResult->xml ) && !empty($resultado->stampResult->xml)) {
            $success = true;

            $xmlTimbrado = new \DOMDocument ( "1.0", "uft-8" );
            $xmlTimbrado->loadXML ( $resultado->stampResult->xml );

            $idDoc = new IdDoc();

            $timbreFiscal = $xmlTimbrado->getElementsByTagName ( 'TimbreFiscalDigital' );

            foreach ( $timbreFiscal as $timbreFiscal ) {

                $fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );

                $idDoc->version = $timbreFiscal->getAttribute ( 'Version' );
                $idDoc->fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );
                $idDoc->selloCFD = $timbreFiscal->getAttribute ( 'SelloCFD' );
                $idDoc->noCertificadoSAT = $timbreFiscal->getAttribute ( 'NoCertificadoSAT' );
                $idDoc->selloSAT = $timbreFiscal->getAttribute ( 'SelloSAT' );
                $idDoc->uUID = $timbreFiscal->getAttribute ( 'UUID' );
                $idDoc->sello = $sello;
                $idDoc->rfcProvCertif = $timbreFiscal->getAttribute ( 'RfcProvCertif' );
            }

	        $facturaObj = new Factura();
	        $facturaObj->id_proveedor = $factura['id_proveedor'];
	        $facturaObj->id_cliente = 0;
	        $facturaObj->id_certificadoProveedor = $certificadoHaUsar->id;
	        $facturaObj->nmbEmisor = $proveedor->nmbEmisor;
	        $facturaObj->rFCEmisor = $proveedor->rFCEmisor;
	        $facturaObj->nmbRecep = $receptor['nombre'];
	        $facturaObj->rFCRecep = $receptor['rfc'];
	        $facturaObj->regimenFiscal = $proveedor->regimenFiscal33;
	        $facturaObj->timeStamp = $timeStamp;
	        $facturaObj->noFactura = $noFactura->noFactura;
	        $facturaObj->version = "4.0";
	        $facturaObj->generadoPor = 4;
	        $facturaObj->nota = (isset($comprobante['comentario']))? Utils::deleteExtraSpaces($comprobante['comentario']) : '';
	        $facturaObj->tipoDeComprobante = 'P';
	        $facturaObj->precission = $comprobante['decimales'];
	        $facturaObj->status = 1;
            $facturaObj->regimenFiscalReceptor = $datosFactura->regimenFiscalReceptor;
            $facturaObj->exportacion = $datosFactura->exportacion;
            $facturaObj->domicilioFiscalReceptor = $datosFactura->domicilioFiscalReceptor;
	        $facturaObj->save();


	        $idDoc->id_factura = $facturaObj->id_factura;
	        $idDoc->serie = $comprobante['serie'];
	        $idDoc->folio = $noFactura->noFactura;
	        $idDoc->formaPago = '';
	        $idDoc->condicionesDePago = (isset($comprobante['condicionesPago']))? Utils::deleteExtraSpaces($comprobante['condicionesPago']) : '';
	        $idDoc->lugarExpedicion = Utils::deleteExtraSpaces($comprobante['LugarExpedicion']);
	        $idDoc->usoCFDI = 'CP01';
	        $idDoc->metodoDePago = '';
	        $idDoc->sello = $sello;
	        $idDoc->tipoFacturasRelacionadas = $datosFactura->tipoFacturasRelacionadas;
	        $idDoc->save();


	        $totales = new Totales();
	        $totales->id_factura = $facturaObj->id_factura;
	        $totales->moneda = 'XXX';
	        $totales->tipoCambio = 0;
	        $totales->subTotal = 0;
	        $totales->mntBase = 0;
	        $totales->vlrPagar = 0;
	        $totales->descuento = 0;
	        $totales->save();

	        $detalles = array();

	        foreach ($datosFactura->conceptos as $concepto){

	            $conceptoObj = new Concepto();
	            $conceptoObj->clave = $concepto->clave;
	            $conceptoObj->cdgItem = $concepto->cdgItem;
	            $conceptoObj->dscItem = $concepto->dscItem;
	            $conceptoObj->unmdItem = $concepto->unmdItem;
	            $conceptoObj->qtyItem = $concepto->qtyItem;
	            $conceptoObj->montoNetoItem = $concepto->montoNetoItem;
	            $conceptoObj->prcNetoItem = $concepto->prcNetoItem;
	            $conceptoObj->descuento = $concepto->descuento;
                $conceptoObj->objetoImp = $concepto->objetoImp;
	            $conceptoObj->id_factura = $facturaObj->id_factura;
	            $conceptoObj->save();

	            foreach ($concepto->impuestosTrasladados as $impuesto){

	                $impuestoObj = new ExImpuestos();
	                $impuestoObj->base = $impuesto->base;
	                $impuestoObj->factor = $impuesto->factor;
	                $impuestoObj->tipoImp = $impuesto->tipoImp;
	                $impuestoObj->tasaImp = $impuesto->tasaImp;
	                $impuestoObj->tipo = $impuesto->tipo;
	                $impuestoObj->montoImp = $impuesto->montoImp;
	                $impuestoObj->id_detalle = $conceptoObj->id_detalle;
	                $impuestoObj->save();
	            }

	            foreach ($concepto->impuestosRetenidos as $impuesto){

	                $impuestoObj = new ExImpuestos();
	                $impuestoObj->base = $impuesto->base;
	                $impuestoObj->factor = $impuesto->factor;
	                $impuestoObj->tipoImp = $impuesto->tipoImp;
	                $impuestoObj->tasaImp = $impuesto->tasaImp;
	                $impuestoObj->tipo = $impuesto->tipo;
	                $impuestoObj->montoImp = $impuesto->montoImp;
	                $impuestoObj->id_detalle = $conceptoObj->id_detalle;
	                $impuestoObj->save();
	            }
	        }

	        foreach ($datosFactura->facturasRelacionadas as $facturaRelacionada){

	            $facturaRelacionadaObj = new FacturasRelacionadas();
	            $facturaRelacionadaObj->id_factura = $facturaObj->id_factura;
	            $facturaRelacionadaObj->uuid = $facturaRelacionada->uuid;
	            $facturaRelacionadaObj->save();

	        }

            $totalesPObj = new TotalesP();
            $totalesPObj->id_factura = $facturaObj->id_factura;
            $totalesPObj->totalRetencionesIVA = $totalesP->totalRetencionesIVA;
            $totalesPObj->totalRetencionesISR = $totalesP->totalRetencionesISR;
            $totalesPObj->totalRetencionesIEPS = $totalesP->totalRetencionesIEPS;
            $totalesPObj->totalTrasladosBaseIVA16 = $totalesP->totalTrasladosBaseIVA16;
            $totalesPObj->totalTrasladosImpuestoIVA16 = $totalesP->totalTrasladosImpuestoIVA16;
            $totalesPObj->totalTrasladosBaseIVA8 = $totalesP->totalTrasladosBaseIVA8;
            $totalesPObj->totalTrasladosImpuestoIVA8 = $totalesP->totalTrasladosImpuestoIVA8;
            $totalesPObj->totalTrasladosBaseIVA0 = $totalesP->totalTrasladosBaseIVA0;
            $totalesPObj->totalTrasladosImpuestoIVA0 = $totalesP->totalTrasladosImpuestoIVA0;
            $totalesPObj->totalTrasladosBaseIVAExento = $totalesP->totalTrasladosBaseIVAExento;
            $totalesPObj->montoTotalPagos = $totalesP->montoTotalPagos;
            $totalesPObj->save();

	        foreach ($datosFactura->pagos as $pago){

                $pago->FechaPago = str_replace ('T', ' ', $pago->FechaPago);
                $pago->FechaPago = substr($pago->FechaPago, 0, 19);

	            $pagoObj = new Pago();
	            $pagoObj->FechaPago = $pago->FechaPago;
	            $pagoObj->FormaDePagoP = $pago->FormaDePagoP;
	            $pagoObj->MonedaP = $pago->MonedaP;
	            $pagoObj->TipoCambioP = $pago->TipoCambioP;
	            $pagoObj->Monto = $pago->Monto;
                $pagoObj->banco = $pago->banco;
                $pagoObj->cuenta = $pago->cuenta;
                $pagoObj->rfcEmisorCtaBen = $pago->rfcEmisorCtaBen;
                $pagoObj->ctaBeneficiario = $pago->ctaBeneficiario;
                $pagoObj->noOperacion = $pago->noOperacion;
                $pagoObj->id_factura = $facturaObj->id_factura;
	            $pagoObj->save();

	            foreach ($pago->documentosRelacionado as $doctoRelacionado ){

                    $doctoRelacionadoObj = new DoctoRelacionado ();
                    $doctoRelacionadoObj->IdDocumento = $doctoRelacionado->IdDocumento;
                    $doctoRelacionadoObj->MonedaDR = $doctoRelacionado->MonedaDR;
                    $doctoRelacionadoObj->TipoCambioDR = $doctoRelacionado->TipoCambioDR;
                    $doctoRelacionadoObj->MetodoDePagoDR = $doctoRelacionado->MetodoDePagoDR;
                    $doctoRelacionadoObj->NumParcialidad = $doctoRelacionado->NumParcialidad;
                    $doctoRelacionadoObj->ImpSaldoAnt = $doctoRelacionado->ImpSaldoAnt;
                    $doctoRelacionadoObj->ImpPagado = $doctoRelacionado->ImpPagado;
                    $doctoRelacionadoObj->ImpSaldoInsoluto = $doctoRelacionado->ImpSaldoInsoluto;
                    $doctoRelacionadoObj->ObjetoImpDR = $doctoRelacionado->ObjetoImpDR;
                    $doctoRelacionadoObj->MontoPagoMoneda = $doctoRelacionado->MontoPagoMoneda;
                    $doctoRelacionadoObj->id_pago = $pagoObj->id;
                    $doctoRelacionadoObj->save ();


	                if($doctoRelacionadoObj->ImpSaldoInsoluto <= 0){

	                    $idDocObj = IdDoc::where('uUID', '=', $doctoRelacionado->IdDocumento)->with('factura')->first();
	                    $facturaIdDoc = $idDocObj->factura;
	                    $facturaIdDoc->isPagado = 1;
	                    $facturaIdDoc->save();

	                }


                    if(isset($doctoRelacionado->impuestos)){

                        if(count($doctoRelacionado->impuestos->impuestosRetenidos) > 0){
                            foreach ($doctoRelacionado->impuestos->impuestosRetenidos as $impuesto){
                                $impuestoDrObj = new ImpuestosDR();
                                $impuestoDrObj->id_doctoRelacionado = $doctoRelacionadoObj->id;
                                $impuestoDrObj->tipo = 0;
                                $impuestoDrObj->base = $impuesto->base;
                                $impuestoDrObj->importe = $impuesto->importe;
                                $impuestoDrObj->impuesto = $impuesto->impuesto;
                                $impuestoDrObj->tasaCuota = $impuesto->tasaCuota;
                                $impuestoDrObj->tipoFactor = $impuesto->tipoFactor;
                                $impuestoDrObj->save();
                            }

                        }

                        if(count($doctoRelacionado->impuestos->impuestosTrasladados) > 0){
                            foreach ($doctoRelacionado->impuestos->impuestosTrasladados as $impuesto){

                                $impuestoDrObj = new ImpuestosDR();
                                $impuestoDrObj->id_doctoRelacionado = $doctoRelacionadoObj->id;
                                $impuestoDrObj->tipo = 1;
                                $impuestoDrObj->base = $impuesto->base;
                                $impuestoDrObj->importe = $impuesto->importe;
                                $impuestoDrObj->impuesto = $impuesto->impuesto;
                                $impuestoDrObj->tasaCuota = $impuesto->tasaCuota;
                                $impuestoDrObj->tipoFactor = $impuesto->tipoFactor;
                                $impuestoDrObj->save();

                            }
                        }

                    }


	            }
	        }


	        $facturaResult = $datosFactura->serie . $datosFactura->folio;

	        $response['idFactura'] = $facturaObj->id_factura;
	        $response['resultCode'] = '1';
	        $response['noFactura'] = $noFactura->noFactura;
	        $response['fecha'] = $timeStamp;
	        $response['errortext'] = '';
	        $response['uuid'] = $idDoc->uUID;
	        $response['nombreArchivo'] = $nombreArchivo;


	    }else{

            if(is_object($resultado)){
                $errorCode = $resultado->stampResult->Incidencias->Incidencia->CodigoError;
                $errortext = $resultado->stampResult->Incidencias->Incidencia->MensajeIncidencia;
            }else{
                $errorCode = $resultado[6];
                $errortext = $resultado[7];
            }


            $response['idFactura'] = '';
            $response['resultCode'] = $errorCode;
            $response['errortext'] = $errortext;
            $response['noFactura'] = '';
            $response['nombreArchivo'] = $nombreArchivo;
            $response['fecha'] = '';

	    }

	    return $response;

	}

    public function crearCliente($cliente){

        $cliente = $cliente['cliente'];

        $toLog = print_r($cliente, true);
        Log::error($toLog);

        $clienteObj = Cliente::with('domicilio')->where('rFCRecep', '=', $cliente['rFCRecep'])->where('id_proveedor', '=', $cliente['id_proveedor'])->first();
        $domicilioObj = new DomFiscalRcp();
        if( !is_object($clienteObj) || !isset($clienteObj->id_cliente)){
            $clienteObj = new Cliente();
        }else{
            $domicilioObj = $clienteObj->domicilio;
        }

        $clienteObj->id_proveedor = $cliente['id_proveedor'];
        $clienteObj->rFCRecep = Utils::deleteExtraSpaces($cliente['rFCRecep']);
        $clienteObj->nmbRecep = Utils::deleteExtraSpaces($cliente['nmbRecep']);
        $clienteObj->metodoPago = Utils::deleteExtraSpaces($cliente['metodoPago']);
        $clienteObj->usoCFDI = Utils::deleteExtraSpaces($cliente['usoCFDI']);
        $clienteObj->tipoPersona = $cliente['tipoPersona'] ?? '0';
        $clienteObj->direccion = $cliente['direccion'] ?? '0';
        $clienteObj->regimenFiscalReceptor = $cliente['regimenFiscalReceptor'] ?? '';
        $clienteObj->save();

        $domicilioObj->id_cliente = $clienteObj->id_cliente;
        $domicilioObj->codigoPostal = $cliente['cp'] ?? '';
        $domicilioObj->save();


        $contacto = ContactoReceptor::find($clienteObj->id_cliente);
        if( !is_object($contacto) && !isset($contacto->id_cliente)){
            $contacto = new ContactoReceptor();
            $contacto->id_cliente = $clienteObj->id_cliente;
        }

        $contacto->email = $cliente['email'];
        $contacto->save();

        if($clienteObj->id_cliente > 0 && $cliente['id_proveedor'] > 0 ){
            Factura::where('rFCRecep', '=', $clienteObj->rFCRecep)
                ->where('id_proveedor', '=', $cliente['id_proveedor'])
                ->update(['id_cliente' => $clienteObj->id_cliente]);
        }

        return array('response' => 0, 'savedFacturas' => $cliente['id_proveedor'] . ' - ' . $clienteObj->id_cliente);

    }

}
