<style type="text/css">

#previewFactura{
	font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
	font-size: 14px;
	margin: 0;
	padding: 0;
	margin-bottom: 0;
	padding-bottom: 0;
	color: {{$factura->color}};
}

#previewFactura td{
	font-size: 14px;
}
#previewFactura h3{
	color: #666666;
	font-size: 18px;
}


#previewFactura .maxWidth {
	width: 100%;
	margin: 0;
	padding: 0;
}


#previewFactura .text-center{
	text-align: center;
}
#previewFactura .text-right{
	text-align: right;
}
#previewFactura .float{
	display: inline-block;
}

#previewFactura .header{
	width: 100%;
	background: #EFF3F6;
}

#previewFactura .logo{
	display: inline-block;
	width: 40%;
	text-align: center;
}

#previewFactura .receptor{
	width: 100%;
	padding-top: 2mm;
}

#previewFactura .receptor .h2{
	font-weight: bold;
	font-size: 16px;
}
#previewFactura .receptor .h3{
	font-weight: bold;
	font-size: 14px;
}
#previewFactura .float{
	display: inline-block;
}
#previewFactura #total{
	background: #006807;
    width: 160px;
    font-size: 16px;
    color: #FFFFFF;
    text-align: center;
    padding: 8px;
    font-weight: bold;
}
#previewFactura .f13{
	font-size: 13px;
}
#previewFactura .borderedTotales{
	border-bottom: 1px solid #E6E6E6;
}
#previewFactura .lastElements .title{
	background: #EFF3F6;
	padding-bottom: 2mm;
	padding-top: 2mm;
	text-align: center;
	font-weight: bold;
}

#previewFactura .lastElements .content{
	word-wrap: break-word; 
	overflow-wrap: break-word;
	background: #FFFFFF;
}
#previewFactura .infoCFDI {
	text-align: left;
}
#previewFactura .infoCFDI td, #previewFactura .infoCFDI th{
	padding-bottom: 1mm;
	padding-top: 1mm;
}
#previewFactura .tableProducts thead tr{
	padding: 0;
	margin: 0;
	background: #EFF3F6;
}

#previewFactura .tableProducts thead th, #previewFactura .tableProducts td{
	padding: 5px;
}

#previewFactura .tableProducts tbody td{
	border-bottom: 1px solid #E6E6E6;
}
#previewFactura .infoCFDIMobile{
	display: none;
}

#previewFactura .infoCFDI{
	display: block;
}

@media only screen and (max-width: 767px) {

	#previewFactura #total {
	        width: 100% !important;
		    margin-bottom: 10px !important;
		    float: none !important;
		    padding-left: 0px !important;
		    padding-right: 0px !important;
	}
	
	#previewFactura .header {
	    padding: 0 !important;
	}
	#previewFactura .datosInformativos{
		padding-bottom: 20px;
    	padding-left: 10px;
	}
	#previewFactura .infoCFDIMobile{
		display: block !important;
	}
	
	#previewFactura .infoCFDI{
		display: none;
	}
}

#previewFactura .datosInformativos {
    padding-left: 10px;
    padding-bottom: 15px;
}
#previewFactura .noFactura{
    font-size: 16px;
    font-weight: bold;
    color: red;
    padding-bottom: 10px;
}
.colorBlack{
	color: #333333;
}
</style>

<div id="previewFactura">
	<div class="header">
	
	
		<div class="datosInformativos">
		<div class="receptor">
			<div style="font-size: 20px; padding-top: 14px; font-weight: bold;">{{$factura->rFCRecep}} - {{$factura->nmbRecep}}</div>
		</div>
		
		<div style="padding-top: 10px;">
		<table cellspacing="0" cellpadding="0">
				<tr>
					<td colspan="2" class="noFactura">PAGO {{$factura->serie}}{{$factura->noFactura}}</td>
				</tr>
				<tr>
					<td><strong>FECHA EMISIÓN: </strong></td>
					<td>{{$factura->timeStamp}}</td>
				</tr>
				<tr>
					<td><strong>TIPO DOCUMENTO: </strong></td>
					<td>{{$adicionales['tipoDocumento'][$factura->tipoDeComprobante]}}</td>
				</tr>
			</table>
		</div>
		</div>
	</div>
	<div>
	@foreach($factura->pagos as $key => $pago)
		<div class="col-sm-12" style="padding-top: 10px; background: #FFFFFF;">
		<h4 class="mt0 colorBlack">Pago #{{($key + 1)}}</h4> 
		<hr class="mt0" />
			<div class="col-sm-4">
				<label>Forma de pago:</label>
				{{$pago->formaPago->codigo}} - {{$pago->formaPago->descripcion}}
			</div>
			<div class="col-sm-4">
				<label>Fecha de pago:</label>
				{{$pago->FechaPago}}
			</div>
			<div class="col-sm-4">
				<label>Total del pago:</label>
				${{number_format ($pago->Monto, 2, '.', ',')}} {{$pago->MonedaP}}
			</div>



			<div class="table-responsive col-sm-12 pl0 pr0">
				<table
					class="table table-striped table-bordered table-hover pl0 pr0">
					<thead style="font-size: 12px;">
						<tr>
							<th>UUID</th>
							<th>Moneda</th>
							<th>No. pago</th>
							<th>Saldo anterior</th>
							<th>Pago realizado</th>
							<th>Saldo actual</th>
						</tr>
					</thead>
					<tbody>
					@foreach($pago->documentosRelacionado as $documento)
						<tr>
							<td>{{$documento->IdDocumento}}</td>
							<td>{{$documento->MonedaDR}}</td>
							<td>{{$documento->NumParcialidad}}</td>
							<td>${{number_format($documento->ImpSaldoAnt, 2, '.', ',')}}</td>
							<td>${{number_format($documento->ImpPagado, 2, '.', ',')}}</td>
							<td>${{number_format($documento->ImpSaldoInsoluto, 2, '.', ',')}}</td>
						</tr>
					@endforeach
					</tbody>
				</table>
			</div>



		</div>
	@endforeach
	</div>
	
	<div style="width: 100%; padding-top: 5mm;">
	
		<div class="lastElements" style="padding-bottom: 5mm;">
				<div class="title">Información del CFDI</div>
				<div class="content"  style="padding-left: 2mm;">
				
				<table class="infoCFDI">
						<tr>
							<td><strong>Folio fiscal:</strong></td>
							<td>{{$factura->uUID}}</td>
							<td><strong>Forma de pago:</strong></td>
							<td>{{$factura->formaPago}}</td>
						</tr>
						<tr>
							<td><strong>No. de certificado:</strong></td>
							<td>{{$factura->noCertificado}}</td>
							<td><strong>Método de pago:</strong></td>
							<td>{{$factura->metodoDePago}}</td>
						</tr>
						<tr>
							<td><strong>Fecha certificación:</strong></td>
							<td>{{$factura->fechaTimbrado}}</td>
							<td><strong>Condiciones de pago:</strong></td>
							<td>{{$factura->metodoDePago}}</td>
						</tr>
						<tr>
							<td><strong>Importe con letra:</strong></td>
							<td colspan="2">{{$factura->cantidadLetra}} {{$factura->decimales}} /100 MN</td>
						</tr>
					</table>
					
					
					
					<table class="infoCFDIMobile">
						<tr>
							<td><strong>Folio fiscal:</strong></td>
							<td>{{$factura->uUID}}</td>
						</tr>
						<tr>
							<td><strong>Forma de pago:</strong></td>
							<td>{{$factura->formaPago}}</td>
						</tr>
						<tr>
							<td><strong>No. de certificado:</strong></td>
							<td>{{$factura->noCertificado}}</td>
						</tr>
						<tr>
							<td><strong>Método de pago:</strong></td>
							<td>{{$factura->metodoDePago}}</td>
						</tr>
						<tr>
							<td><strong>Fecha certificación:</strong></td>
							<td>{{$factura->fechaTimbrado}}</td>
						</tr>
						<tr>
							<td><strong>Condiciones de pago:</strong></td>
							<td>{{$factura->metodoDePago}}</td>
						</tr>
						<tr>
							<td><strong>Importe con letra:</strong></td>
							<td>{{$factura->cantidadLetra}} {{$factura->decimales}} /100 MN</td>
						</tr>
					</table>
					
				</div>
			</div>
	
	
			
	</div>
</div>
