<!DOCTYPE html>
<html>
<head>
<style type="text/css">
@page *{
	margin: 0;
	padding: 0;
	margin-bottom: 0;
	padding-bottom: 0;
}

html, .nopadding {
	margin: 0;
	padding: 0;
}

body {
	font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
	font-size: 12px;
	margin: 0;
	padding: 0;
	margin-bottom: 0;
	padding-bottom: 0;
	color: {{$factura->color}};
}

h3{
	color: #666666;
	font-size: 18px;
}

.panelLeft {
	color: #FFF;
}

.maxWidth {
	width: 200mm;
	margin: 0;
	padding: 0;
}

.panelLeft {
	width: 50mm;
	display: inline-block;
}

.panelContent {
	width: 158mm;
	display: inline-block;
	padding-top: 5mm;
	padding-left: 1mm;
	padding-right: 2mm;
}

.rowData {
	text-align: center;
	vertical-align: middle;
	padding: 10px;
	height: 53mm;
}

.text-center{
	text-align: center;
}
.text-left{
	text-align: left;
}
.text-right{
	text-align: right;
}
#contenidoFactura{
	padding-bottom: 5mm;
	line-height: 5mm;
}
.float{
	display: inline-block;
}
.width50{
	width: 49%;
}
.noBorder{
	border: none;
}
.title3{
	font-weight: bold;
	font-size: 22px;
	padding-top: 5px;
	padding-bottom: 15px;
}
.lineHeight{
	line-height: 5mm;
}

.header{
	width: 100%;
	height: 65mm;
	background: #EFF3F6;
	padding: 5mm;
}

.logo{
	display: inline-block;
	width: 40%;
	text-align: center;
}
.logo img{
	width: 100%;
	display: inline-block;
	max-height: 28mm;
	max-width: 70mm;
}
.datosFacturas{
	display: inline-block;;
	width: 60%;
	height: 32mm;
}
.datosFacturas tr td{
	border-bottom: 1px solid #999999;
	padding-bottom: 1mm;
}
.datosFacturas tr th{
	padding-top: 1mm;
}
.datosFacturas tr th, .datosFacturas tr td{
	padding: 1mm;
}
.datosFacturas h3{
	padding-top: 0;
	padding-bottom: 0px;
	margin-bottom: 0px;
}
.receptor{
	width: 200mm;
	padding-top: 2mm;
}

.receptor .h2{
	font-weight: bold;
	font-size: 16px;
}
.receptor .h3{
	font-weight: bold;
	font-size: 14px;
}
.float{
	display: inline-block;
}
#total{
	background: {{$factura->color}};
	width: 50mm;
	font-size: 18px;
	color: #FFFFFF;
	text-align: center;
	padding: 4mm;
	font-weight: bold;
}
.rowProd{
	padding-top: 3mm;
	border-bottom: 1px solid #E6E6E6;
	padding-bottom: 3mm;
	font-size: 12px;
}
.rowProd small{
	font-size: 11px;
}
.f13{
	font-size: 13px;
	font-weight: bold;

}
.tableTotales{
	padding-top: 2mm;
}

.tableTotales td, .tableTotales th{
	padding-bottom: 2mm;
	padding-top: 2mm;
	margin: 0;
}
.borderedTotales{
	border-bottom: 1px solid #E6E6E6;
}
.lastElements .title{
	background: #EFF3F6;
	padding-bottom: 2mm;
	padding-top: 2mm;
	text-align: center;
	font-weight: bold;
}

.lastElements .content{
	word-wrap: break-word;
	overflow-wrap: break-word;
	background: #FFFFFF;
}
.infoCFDI {
	text-align: left;
}
.infoCFDI td, .infoCFDI th{
	padding-bottom: 1mm;
	padding-top: 1mm;
}
.rowHead{
    text-align: center;
    font-weight: bold;
    border: 1px solid #E6E6E6;
    padding: 0;
    margin: 0;
}
.tableProdD tr td{
	height: 5mm;
	border: 1px solid #E6E6E6;
	font-size: 10px;
}
</style>
</head>
<body>
	<div class="header">
		<div class="logo">
            @if($factura->base64 != '')
                <img src="{{$factura->base64}}" />
            @endif
		</div>
		<div class="datosFacturas">
			<table cellspacing="0" cellpadding="0" class="text-center" style="width: 100%;">
				<tr>
					<th>FACTURA</th>
					<th>FECHA EMISIÓN</th>
				</tr>
				<tr>
					<td>{{$factura->serie}}{{$factura->noFactura}}</td>
					<td>{{$factura->timeStamp}}</td>
				</tr>
				<tr>
					<th style="padding-top: 3mm;">TIPO DOCUMENTO</th>
					<th style="padding-top: 3mm;">USO DOCUMENTO</th>
				</tr>
				<tr>
					<td>{{$adicionales['tipoDocumento'][$factura->tipoDeComprobante]}}</td>
					<td>{{$factura->usoCFDI}}</td>
				</tr>
			</table>
		</div>
		<div class="receptor">
			<table cellspacing="0" cellpadding="0">
				<tr>
					<td style="width: 150mm;">
						<div class="h2">(E) {{$factura->nmbEmisor}} <br> {{$factura->rFCEmisor}}</div>
						{{$factura->regimenFiscal}}<br />
						Lugar de expedición: {{$factura->lugarExpedicion}}

						<div class="h3" style="padding-top: 5mm;">(R) {{$factura->nmbRecep}} <br /> {{$factura->rFCRecep}}</div>
					</td>
					<td style="width: 50mm;">
						<div id="total">
							${{number_format ($factura->total, 2, '.', ',')}} {{$factura->moneda}}
						</div>
					</td>
				</tr>
			</table>
		</div>
	</div>


	<div>

	<div class="float rowHead" style="width: 15mm;">CANT.</div>
	<div class="float rowHead" style="width: 30mm;">C. PRODUCTO</div>
	<div class="float rowHead" style="width: 60mm;">DESCRIPCION</div>
	<div class="float rowHead" style="width: 20mm;">C. UNIDAD</div>
	<div class="float rowHead" style="width: 25mm;">P. UNITARIO</div>
	<div class="float rowHead" style="width: 25mm;">DESCUENTO</div>
	<div class="float rowHead" style="width: 25mm;">IMPORTE</div><br />
	@foreach($factura->conceptos as $concepto)

		<div class="float rowHead" style="width: 15mm;">{{$concepto->qtyItem}}</div>
		<div class="float rowHead" style="width: 30mm;">{{$concepto->clave}}</div>
		<div class="float rowHead" style="width: 60mm;">{{$concepto->dscItem}}</div>
		<div class="float rowHead" style="width: 20mm;">{{$concepto->unmdItem}}</div>
		<div class="float rowHead" style="width: 25mm;">${{number_format ($concepto->montoNetoItem, 2, '.', ',')}}</div>
		<div class="float rowHead" style="width: 25mm;">${{number_format ($concepto->descuento, 2, '.', ',')}}</div>
		<div class="float rowHead" style="width: 25mm;">${{number_format ($concepto->prcNetoItem, 2, '.', ',')}}</div>
		<br />

	@endforeach



	<table cellspacing="0" cellpadding="0" class="tableTotales">
		<tr>
			<td style="width: 150mm; padding: 0; margin: 0; vertical-align: top;" rowspan="6">

				<div style="padding-left: 5mm;">
					@if(isset($factura->cuentaPredial) && $factura->cuentaPredial != '')
					<strong>Cuenta Predial: {{$factura->cuentaPredial}}</strong>
					@endif
				</div>


			</td>
			<th style="width: 30mm;" class="text-right f13 borderedTotales" colspan="2">Subtotal:</th>
			<td style="width: 30mm;" class="text-center f13 borderedTotales">${{number_format ($factura->subtotal, 2, '.', ',')}}</td>
		</tr>
		@if($factura->descuento > 0)
		<tr>
			<th style="width: 30mm;" class="text-right f13 borderedTotales" colspan="2">Descuento:</th>
			<td style="width: 30mm;" class="text-center f13 borderedTotales">${{number_format ($factura->descuento, 2, '.', ',')}}</td>
		</tr>
		@endif
		@foreach($factura->impuestosTrasladados as $impuesto)
		<tr>
			<th style="width: 30mm;" class="text-right f13 borderedTotales" colspan="2">{{$adicionales['impuestos'][$impuesto->impuesto]}} {{$impuesto->tasaOCuota * 100}}% trasladado:</th>
			<td style="width: 30mm;" class="text-center f13 borderedTotales">${{number_format ($impuesto->importe, 2, '.', ',')}}</td>
		</tr>
		@endforeach
		@foreach($factura->impuestosRetenidos as $impuesto)
		<tr>
			<th style="width: 30mm;" class="text-right f13 borderedTotales" colspan="2">{{$adicionales['impuestos'][$impuesto->impuesto]}} retenido:</th>
			<td style="width: 30mm;" class="text-center f13 borderedTotales">${{number_format ($impuesto->importe, 2, '.', ',')}}</td>
		</tr>
		@endforeach


		@if(isset($factura->impuestosTrasladadosLcl) && count($factura->impuestosTrasladadosLcl) > 0)
		@foreach($factura->impuestosTrasladadosLcl as $impuesto)
		<tr>
			<th style="width: 30mm;" class="text-right f13 borderedTotales" colspan="2">{{$impuesto->tipoImp}} trasladado:</th>
			<td style="width: 30mm;" class="text-center f13 borderedTotales">${{number_format ($impuesto->montoImp, 2, '.', ',')}}</td>
		</tr>
		@endforeach
		@endif

		@if(isset($factura->impuestosRetenidosLcl) && count($factura->impuestosRetenidosLcl) > 0)
		@foreach($factura->impuestosRetenidosLcl as $impuesto)
		<tr>
			<th style="width: 30mm;" class="text-right f13 borderedTotales" colspan="2">{{$impuesto->tipoImp}} retenido:</th>
			<td style="width: 30mm;" class="text-center f13 borderedTotales">${{number_format ($impuesto->montoImp, 2, '.', ',')}}</td>
		</tr>
		@endforeach
		@endif
		<tr>
			<th style="width: 30mm;" class="text-right f13 borderedTotales" colspan="2">Total:</th>
			<td style="width: 30mm;" class="text-center f13 borderedTotales">${{number_format ($factura->total, 2, '.', ',')}}</td>
		</tr>
	</table>

	</div>

	<div class="row" style="width: 100%; padding-top: 5mm;">

		<div class="lastElements" style="padding-bottom: 5mm;">
				<div class="title">Información del CFDI</div>
				<div class="content"  style="padding-left: 2mm;">

				<table class="infoCFDI">
						<tr>
							<td><strong>Folio fiscal:</strong></td>
							<td style="width: 60mm;">{{$factura->uUID}}</td>
							@if($factura->formaPago != '')
							<td style="width: 40mm;"><strong>Forma de pago:</strong></td>
							<td>{{$factura->formaPago}}</td>
							@endif
						</tr>
						<tr>
							<td><strong>No. de certificado:</strong></td>
							<td>{{$factura->noCertificado}}</td>
							<td><strong>No. de certificado SAT:</strong></td>
							<td>{{$factura->noCertificadoSAT}}</td>
						</tr>
						<tr>
							<td style="width: 40mm;"><strong>Método de pago:</strong></td>
							<td>{{$factura->metodoDePago}}</td>
							<td><strong>Fecha certificación:</strong></td>
							<td>{{$factura->fechaTimbrado}}</td>
						</tr>
						@if($factura->condicionesDePago != '' || $factura->nota != '')
						<tr>
							@if($factura->condicionesDePago != '')
							<td style="width: 40mm;"><strong>Condiciones de pago:</strong></td>
							<td>{{$factura->condicionesDePago}}</td>
							@endif
							@if($factura->nota != '')
							<td><strong>Nota:</strong></td>
							<td colspan="3">{{$factura->nota}}</td>
							@endif
						</tr>
						@endif

						<tr>
							<td><strong>Importe con letra:</strong></td>
							<td colspan="2">{{$factura->cantidadLetra}} @if($factura->moneda == 'MXN')  Pesos @endif {{number_format (($factura->decimales*100), 0, '.', ',')}} /100
								@if($factura->moneda == 'MXN')  M.N. @endif
								@if($factura->moneda == 'USD') USD @endif</td>
						</tr>
						@if($factura->moneda == 'USD' && $factura->tipoCambio > 1)
						<tr>
							<td><strong>Tipo de cambio:</strong></td>
							<td>{{number_format (($factura->tipoCambio), 2, '.', ',')}}</td>
							@endif
						</tr>
					</table>

				</div>
			</div>


		<div class="lastElements" style="padding-bottom: 5mm;">
				<div class="title">Sello digital del CFDI</div>
				<div class="content"  style="padding-left: 2mm; padding-right: 2mm;">{{$factura->sello}}</div>
			</div>

		<div class="float" style="padding-left: 2mm; width: 40mm;">
			<img src="data:image/png;base64, {{ base64_encode(QrCode::format('png')->color(47,54,64)->backgroundColor(255,255,255)->margin(0)->size(150)->generate($factura->qr)) }} ">
		</div>
		<div class="float" style="width: 167mm;">
			<div class="lastElements">
				<div class="title">Cadena original del complemento de certificacion digital del SAT</div>
				<div class="content" style="padding-right: 1mm;">||1.1|{{$factura->uUID}}|{{$factura->timeStamp}}|{{$factura->selloSAT}}|{{$factura->noCertificadoSAT}}||</div>
			</div>

			<div class="lastElements">
				<div class="title">Sello digital del SAT</div>
				<div class="content" style="padding-right: 1mm;">{{$factura->selloSAT}}</div>
			</div>

		</div>
	</div>
	<div style="padding-left: 3mm; padding-top: 3mm;">**Este documento es una representación impresa de un CFDI.</div>

</body>
</html>
