<?php use chillerlan\QRCode\QRCode;?>
<!DOCTYPE html>
<html>
<head>
<style type="text/css">
@page *{
	margin: 0;
	padding: 0;
	margin-bottom: 0;
	padding-bottom: 0;
}

html, .nopadding {
	margin: 0;
	padding: 0;
}

body {
	font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
	font-size: 12px;
	margin: 0;
	padding: 0;
	margin-bottom: 0;
	padding-bottom: 0;
	color: {{$factura->color}};
}

h3{
	color: #666666;
	font-size: 18px;
}

.panelLeft {
	color: #FFF;
}

.maxWidth {
	width: 200mm;
	margin: 0;
	padding: 0;
}

.panelLeft {
	width: 50mm;
	display: inline-block;
}

.panelContent {
	width: 158mm;
	display: inline-block;
	padding-top: 5mm;
	padding-left: 1mm;
	padding-right: 2mm;
}

.rowData {
	text-align: center;
	vertical-align: middle;
	padding: 10px;
	height: 53mm;
}

.text-center{
	text-align: center;
}
.text-left{
	text-align: left;
}
.text-right{
	text-align: right;
}
#contenidoFactura{
	padding-bottom: 5mm;
	line-height: 5mm;
}
.float{
	float: left;
}
.width50{
	width: 49%;
}
.noBorder{
	border: none;
}
.title3{
	font-weight: bold;
	font-size: 22px;
	padding-top: 5px;
	padding-bottom: 15px;
}
.lineHeight{
	line-height: 5mm;
}

.header{
	width: 100%;
	background: #EFF3F6;
	padding-left: 3mm;
    padding-right: 3mm;
    padding-top: 10mm;
    height: 35mm;
}

.w-50{
    width: 50%;
}

.datosFacturas{
	display: inline-block;;
	padding-top: 10px;
}

.datosFacturas h3{
	padding-top: 0;
	padding-bottom: 0px;
	margin-bottom: 0px;
}
.receptor{
	width: 200mm;
	padding-top: 2mm;
}

.receptor .h2{
	font-weight: bold;
	font-size: 16px;
}
.receptor .h3{
	font-weight: bold;
	font-size: 14px;
}
.float{
	display: inline-block;
}
#total{
	background: {{$factura->color}};
	width: 50mm;
	font-size: 18px;
	color: #FFFFFF;
	text-align: center;
	padding: 4mm;
	font-weight: bold;
}
.rowProd{
	padding-top: 3mm;
	border-bottom: 1px solid #E6E6E6;
	padding-bottom: 3mm;
	font-size: 12px;
}
.rowProd small{
	font-size: 11px;
}
.f13{
	font-size: 13px;
	font-weight: bold;

}

.tableTotales td, .tableTotales th{
	padding-bottom: 2mm;
	padding-top: 2mm;
	margin: 0;
}
.borderedTotales{
	border-bottom: 1px solid #E6E6E6;
}
.lastElements .title{
	background: #EFF3F6;
	padding-bottom: 2mm;
	padding-top: 2mm;
	text-align: center;
	font-weight: bold;
}

.break-word{
    word-wrap: break-word;
    overflow-wrap: break-word;
}

.lastElements .content{
	word-wrap: break-word;
	overflow-wrap: break-word;
	background: #FFFFFF;
}
.infoCFDI {
	text-align: left;
}
.infoCFDI td, .infoCFDI th{
	padding-bottom: 1mm;
	padding-top: 1mm;
}
.rowHead{
    text-align: center;
    font-weight: bold;
    border: 1px solid #E6E6E6;
}
.tableProdD tr td{
	height: 5mm;
	border: 1px solid #E6E6E6;
	font-size: 10px;
}
.tableProdD tr td.final{
    height: 5mm;
    border: 1px solid #E6E6E6;
    border-bottom: 1px solid #8b8b8b !important;
    font-size: 10px;
}
.small{
    font-size: 10px;
}
.tableData{
    width: 100%;
}
.tableData .head{
    background: #EFF3F6;
    text-align: center;
}
.tableData .row{
    word-wrap: break-word;
    overflow-wrap: break-word;
    padding: 2mm;
}
</style>
</head>
<body>
	<div class="header">
        <div class="datosFacturas w-50">
            <table cellspacing="0" cellpadding="0">
                <tr>
                    <td>
                        <div class="h2"><strong>(E) {{$factura->nmbEmisor}} <br> {{$factura->rFCEmisor}}</strong></div>
                        {{$factura->regimenFiscal}}<br />
                        Lugar de expedición: {{$factura->lugarExpedicion}}

                        <div class="h3" style="padding-top: 5mm;"><strong>(R)
                                @if($factura->rFCRecep == 'BPR1410151J5')
                                    BEST PRODUCE S DE RL DE CV <br /> {{$factura->rFCRecep}}
                                @else
                                    {{$factura->nmbRecep}} <br /> {{$factura->rFCRecep}}
                                @endif
                                </strong>
                        </div>
                        @if($factura->domicilioFiscalReceptor != '')
                            Domicilio: {{$factura->domicilioFiscalReceptor}}
                        @endif

                        @if(!empty($factura->regimenFiscalReceptor))
                            <br />Regimen fiscal: {{$factura->regimenFiscalReceptor}}
                        @endif

                        @if($factura->tipoFacturasRelacionadas != '')
                            <strong>Facturas relacionadas</strong><br />
                            {{$factura->tipoFacturasRelacionadas}} - {{$factura->labelFacturasRelacionadas}}<br />
                            @foreach($factura->facturasRelacionadas as $relacionada)
                                {{$relacionada->uuid}}<br />
                            @endforeach
                        @endif
                    </td>
                </tr>
            </table>

        </div>
		<div class="datosFacturas w-50">
			<table cellspacing="0" cellpadding="0" class="text-center" style="width: 100%;">
				<tr>
					<th>FACTURA</th>
					<th>FECHA EMISIÓN</th>
				</tr>
				<tr>
					<td>{{$factura->serie}}{{$factura->noFactura}}</td>
					<td>{{$factura->timeStamp}}</td>
				</tr>
				<tr>
					<th style="padding-top: 1mm;">TIPO DOCUMENTO</th>
					<th style="padding-top: 1mm;">USO DOCUMENTO</th>
				</tr>
				<tr>
					<td>{{$adicionales['tipoDocumento'][$factura->tipoDeComprobante]}}</td>
					<td>{{$factura->usoCFDI}}</td>
				</tr>
                <tr>
                    <th style="padding-top: 1mm;">FORMA PAGO</th>
                    <th style="padding-top: 1mm;">EXPORTACIÓN</th>
                </tr>
                <tr>
                    <td>{{$factura->formaPago}}</td>
                    <td>{{$factura->exportacion}}</td>
                </tr>
                <tr>
                    <th style="padding-top: 1mm;">NO CERTIFICADO</th>
                    <th style="padding-top: 1mm;">CERTIFICADO SAT</th>
                </tr>
                <tr>
                    <td>{{$factura->noCertificado}}</td>
                    <td>{{$factura->noCertificadoSAT}}</td>
                </tr>
			</table>
		</div>
	</div>



	<table cellspacing="0" cellpadding="0" style="width: 100%;" class="tableProdD">
		<tr>
			<td class="rowHead" style="width: 15mm;">CANT.</td>
			<td class="rowHead" style="width: 30mm;">C. PRODUCTO</td>
			<td class="rowHead">DESCRIPCION</td>
			<td class="rowHead" style="width: 20mm;">C. UNIDAD</td>
            @if($factura->version == '4.0')
            <td class="rowHead" style="width: 20mm;">OBJ. IMP</td>
            @endif
			<td class="rowHead" style="width: 25mm;">P. UNITARIO</td>
			<td class="rowHead" style="width: 25mm;">DESCUENTO</td>
			<td class="rowHead" style="width: 25mm;">IMPORTE</td>
		</tr>
	</table>
	@foreach($factura->conceptos as $concepto)
	<table cellspacing="0" cellpadding="0" style="width: 100%;" class="tableProdD">
		<tr>
			<td class="text-center" style="width: 15mm;">{{$concepto->qtyItem}}</td>
			<td class="text-center" style="width: 30mm;">{{$concepto->clave}}</td>
			<td>{{$concepto->dscItem}}</td>
			<td class="text-center" style="width: 20mm;">{{$concepto->unmdItem}}</td>
            @if($factura->version == '4.0')
            <td class="text-center" style="width: 20mm;">{{$concepto->objetoImp}}</td>
            @endif
			<td class="text-center" style="width: 25mm;">${{number_format ($concepto->montoNetoItem, 2, '.', ',')}}</td>
			<td class="text-center" style="width: 25mm;">${{number_format ($concepto->descuento, 2, '.', ',')}}</td>
			<td class="text-center" style="width: 25mm;">${{number_format ($concepto->prcNetoItem, 2, '.', ',')}}</td>
		</tr>
	</table>
	@endforeach

	<div style="padding-top: 2mm;">
	<table>
		<tr>
			<td style="width: 135mm; padding: 0; margin: 0; vertical-align: top;">
					@if(isset($factura->cuentaPredial) && $factura->cuentaPredial != '')
					<strong>Cuenta Predial: {{$factura->cuentaPredial}}</strong>
					@endif
			</td>
			<th style="width: 50mm;" class="text-right f13 borderedTotales" >Subtotal:</th>
			<td style="width: 30mm;" class="text-center f13 borderedTotales">${{number_format ($factura->subtotal, 2, '.', ',')}}</td>
		</tr>
		@if($factura->descuento > 0)
		<tr>
			<td></td>
			<th style="width: 50mm;" class="text-right f13 borderedTotales" >Descuento:</th>
			<td style="width: 30mm;" class="text-center f13 borderedTotales">${{number_format ($factura->descuento, 2, '.', ',')}}</td>
		</tr>
		@endif
		@foreach($factura->impuestosTrasladados as $impuesto)
		<tr>
			<td></td>
			<th style="width: 50mm;" class="text-right f13 borderedTotales" >{{$adicionales['impuestos'][$impuesto->impuesto]}} {{$impuesto->tasaOCuota * 100}}% trasladado:</th>
			<td style="width: 30mm;" class="text-center f13 borderedTotales">${{number_format ($impuesto->importe, 2, '.', ',')}}</td>
		</tr>
		@endforeach
		@foreach($factura->impuestosRetenidos as $impuesto)
		<tr>
			<td></td>
			<th style="width: 50mm;" class="text-right f13 borderedTotales" >{{$adicionales['impuestos'][$impuesto->impuesto]}} retenido:</th>
			<td style="width: 30mm;" class="text-center f13 borderedTotales">${{number_format ($impuesto->importe, 2, '.', ',')}}</td>
		</tr>
		@endforeach


		@if(isset($factura->impuestosTrasladadosLcl) && count($factura->impuestosTrasladadosLcl) > 0)
		@foreach($factura->impuestosTrasladadosLcl as $impuesto)
		<tr>
			<td></td>
			<th style="width: 50mm;" class="text-right f13 borderedTotales" >{{$impuesto->tipoImp}} trasladado:</th>
			<td style="width: 30mm;" class="text-center f13 borderedTotales">${{number_format ($impuesto->montoImp, 2, '.', ',')}}</td>
		</tr>
		@endforeach
		@endif

		@if(isset($factura->impuestosRetenidosLcl) && count($factura->impuestosRetenidosLcl) > 0)
		@foreach($factura->impuestosRetenidosLcl as $impuesto)
		<tr>
			<td></td>
			<th style="width: 50mm;" class="text-right f13 borderedTotales" >{{$impuesto->tipoImp}} retenido:</th>
			<td style="width: 30mm;" class="text-center f13 borderedTotales">${{number_format ($impuesto->montoImp, 2, '.', ',')}}</td>
		</tr>
		@endforeach
		@endif
		<tr>
			<td></td>
			<th style="width: 50mm;" class="text-right f13 borderedTotales" >Total:</th>
			<td style="width: 30mm;" class="text-center f13 borderedTotales">${{number_format ($factura->total, 2, '.', ',')}}</td>
		</tr>
	</table>
	</div>


	<div class="row" style="width: 100%; padding-top: 2mm;">

		<div class="lastElements" style="padding-bottom: 5mm;">
				<div class="title">Información del CFDI</div>
				<div class="content"  style="padding-left: 2mm;">

				<table class="infoCFDI">
						<tr>
							<td><strong>Folio fiscal:</strong></td>
							<td style="width: 60mm;">{{$factura->uUID}}</td>
							<td style="width: 40mm;"><strong>Fecha certificación:</strong></td>
							<td>{{$factura->fechaTimbrado}}</td>

						</tr>
						<tr>
							<td><strong>Método de pago:</strong></td>
							<td>{{$factura->metodoDePago}}</td>
                            <td><strong>Importe con letra:</strong></td>
                            <td>{{$factura->cantidadLetra}} @if($factura->moneda == 'MXN')  Pesos @endif {{$factura->decimales}} /100
                                @if($factura->moneda == 'MXN')  M.N. @endif
                                @if($factura->moneda == 'USD') USD @endif</td>
						</tr>
						@if($factura->condicionesDePago != '' || $factura->nota != '')
						<tr>
							@if($factura->condicionesDePago != '')
							<td style="width: 40mm;"><strong>Condiciones de pago:</strong></td>
							<td>{{$factura->condicionesDePago}}</td>
							@endif
							@if($factura->nota != '')
							<td><strong>Nota:</strong></td>
							<td colspan="3">{{$factura->nota}}</td>
							@endif
						</tr>
						@endif
                    @if($factura->moneda == 'USD' && $factura->tipoCambio > 1)
						<tr>
							<td><strong>Tipo de cambio:</strong></td>
							<td>{{number_format (($factura->tipoCambio), 2, '.', ',')}}</td>
						</tr>
                    @endif
					</table>

				</div>
			</div>


        <table cellspacing="0" cellpadding="0" class="tableData">
            <tr>
                <td class="head"><strong>CARTA PORTE</strong></td>
            </tr>
            <tr>
                <td>
                    <table cellspacing="0" cellpadding="0" class="tableProdD" style="width: 100%;">
                        <tr>
                            <td class="text-center"><strong>Transporte internacional</strong></td>
                            <td class="text-center"><strong>Entrada/salida del país</strong></td>
                            <td class="text-center"><strong>País origen/destino</strong></td>
                            <td class="text-center"><strong>Vía de entrada/salida</strong></td>
                            <td class="text-center"><strong>Peso bruto total</strong></td>
                            <td class="text-center"><strong>Unidad de peso</strong></td>
                        </tr>
                        <tr>
                            <td>{{$factura->cartaPorte->transpInternac}}</td>
                            <td>{{$factura->cartaPorte->entradaSalidaMerc}}</td>
                            <td>{{$factura->cartaPorte->paisOrigenDestino}}</td>
                            <td>{{$factura->cartaPorte->viaEntradaSalida}}</td>
                            <td>{{$factura->cartaPorte->pesoBrutoTotal}}</td>
                            <td>{{$factura->cartaPorte->unidadPeso}}</td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>

        <table cellspacing="0" cellpadding="0" class="tableData">
            <tr>
                <td class="head"><strong>Mercancías</strong></td>
            </tr>
            <tr>
                <td>
                    <table cellspacing="0" cellpadding="0" class="tableProdD" style="width: 100%;">
                        <tr>
                            <td class="text-center"><strong>Cantidad</strong></td>
                            <td class="text-center"><strong>Peso Kg.</strong></td>
                            <td class="text-center"><strong>Clave Unidad</strong></td>
                            <td class="text-center"><strong>Concepto</strong></td>
                            <td class="text-center"><strong>Clave prod</strong></td>
                            <td class="text-center"><strong>Moneda</strong></td>
                            <td class="text-center"><strong>Valor mercancía</strong></td>
                        </tr>
                        @foreach($factura->cartaPorte->mercancias as $mercancias)
                        <tr>
                            <td>{{$mercancias->cantidad}}</td>
                            <td>{{$mercancias->peso}}</td>
                            <td>{{$mercancias->claveUnidad}}</td>
                            <td>{{$mercancias->descripcion}}</td>
                            <td>{{$mercancias->bienesTransp}}</td>
                            <td>{{$mercancias->moneda}}</td>
                            <td>{{number_format ($mercancias->valorMercancia, 2, '.', ',')}}</td>
                        </tr>
                        @endforeach
                    </table>

                </td>
            </tr>
        </table>


        <table cellspacing="0" cellpadding="0" class="tableData">
            <tr>
                <td class="head"><strong>Ubicaciones</strong></td>
            </tr>

            @foreach($factura->cartaPorte->ubicaciones as $ubicaciones)
                <tr>
                <td>

                    <table cellspacing="0" cellpadding="0" class="tableProdD" style="width: 100%;">
                        <tr>
                            <td class="text-center"><strong>Tipo ubicación</strong></td>
                            <td class="text-center"><strong>RFC</strong></td>
                            <td class="text-center"><strong>ID extranjero</strong></td>
                            <td class="text-center"><strong>Fecha</strong></td>
                            <td class="text-center"><strong>Calle</strong></td>
                            <td class="text-center"><strong>No. exterior</strong></td>
                        </tr>
                        <tr>
                            <td>{{$ubicaciones->tipoUbicacion}}</td>
                            <td>{{$ubicaciones->rFCRemitenteDestinatario}}</td>
                            <td>{{$ubicaciones->numRegIdTrib}}</td>
                            <td>{{$ubicaciones->fechaHoraSalidaLlegada}}</td>
                            <td>{{$ubicaciones->calle}}</td>
                            <td>{{$ubicaciones->numeroExterior}}</td>
                        </tr>
                        <tr>
                            <td class="text-center"><strong>No. interior</strong></td>
                            <td class="text-center"><strong>Colonia</strong></td>
                            <td class="text-center"><strong>Estado</strong></td>
                            <td class="text-center"><strong>País</strong></td>
                            <td class="text-center"><strong>Codigo postal</strong></td>
                            <td class="text-center"><strong>Distancia recorrida</strong></td>
                        </tr>
                        <tr>
                            <td class="final">{{$ubicaciones->numeroInterior}}</td>
                            <td class="final">{{$ubicaciones->colonia}}</td>
                            <td class="final">{{$ubicaciones->estado}}</td>
                            <td class="final">{{$ubicaciones->pais}}</td>
                            <td class="final">{{$ubicaciones->codigoPostal}}</td>
                            <td class="final">{{$ubicaciones->totalDistRec}}</td>
                        </tr>
                    </table>
                </td>
                </tr>
            @endforeach
        </table>

        @if($factura->cartaPorte->autotransporte != null && is_object($factura->cartaPorte->autotransporte))
        <table cellspacing="0" cellpadding="0" class="tableData">
            <tr>
                <td class="head"><strong>Autotransporte</strong></td>
            </tr>

                <tr>
                    <td>

                        <table cellspacing="0" cellpadding="0" class="tableProdD" style="width: 100%;">
                            <tr>
                                <td class="text-center"><strong>Tipo permiso</strong></td>
                                <td class="text-center"><strong>No. permiso</strong></td>
                                <td class="text-center"><strong>Config. transporte</strong></td>
                                <td class="text-center"><strong>Modelo</strong></td>
                                <td class="text-center"><strong>Aseguradora</strong></td>
                                <td class="text-center"><strong>Póliza</strong></td>
                                <td class="text-center"><strong>Placa</strong></td>
                            </tr>
                            <tr>
                                <td>{{$factura->cartaPorte->autotransporte->tipoPermiso}}</td>
                                <td>{{$factura->cartaPorte->autotransporte->noPermiso}}</td>
                                <td>{{$factura->cartaPorte->autotransporte->configTransporte}}</td>
                                <td>{{$factura->cartaPorte->autotransporte->anioModeloVM}}</td>
                                <td>{{$factura->cartaPorte->autotransporte->aseguraRespCivil}}</td>
                                <td>{{$factura->cartaPorte->autotransporte->polizaRespCivil}}</td>
                                <td>{{$factura->cartaPorte->autotransporte->placaVM}}</td>
                            </tr>
                        </table>
                    </td>
                </tr>
        </table>
        @endif

        @if(count($factura->cartaPorte->figurasTransporte) > 0)
        <table cellspacing="0" cellpadding="0" class="tableData">
            <tr>
                <td class="head"><strong>Figuras de transporte</strong></td>
            </tr>
                <tr>
                    <td>
                        <table cellspacing="0" cellpadding="0" class="tableProdD" style="width: 100%;">
                            <tr>
                                <td class="text-center"><strong>Tipo figura</strong></td>
                                <td class="text-center"><strong>RFC</strong></td>
                                <td class="text-center"><strong>No. licencia</strong></td>
                                <td class="text-center"><strong>Nombre</strong></td>
                                <td class="text-center"><strong>ID extranjero</strong></td>
                            </tr>
                            @foreach($factura->cartaPorte->figurasTransporte as $figuraTransporte)
                            <tr>
                                <td>{{$figuraTransporte->tipoFigura}}</td>
                                <td>{{$figuraTransporte->rFCFigura}}</td>
                                <td>{{$figuraTransporte->numLicencia}}</td>
                                <td>{{$figuraTransporte->nombreFigura}}</td>
                                <td>{{$figuraTransporte->calle}}</td>
                                <td>{{$figuraTransporte->numRegIdTribFigura}}</td>
                            </tr>
                            @endforeach
                        </table>
                    </td>
                </tr>
        </table>
        @endif

        <table cellspacing="0" cellpadding="0" class="tableData">
            <tr>
                <td class="head"><strong>Sello digital del CFDI</strong></td>
                <td class="head"><strong>Sello digital del SAT</strong></td>
            </tr>
            <tr>
                <td class="row small">{{$factura->sello}}</td>
                <td class="row small">{{$factura->selloSAT}}</td>
            </tr>
        </table>

        @if(isset($factura->addenda))
        <div class="lastElements" style="padding-bottom: 2mm;">
            <div class="title">Addenda</div>
            <div class="content small"  style="padding-left: 2mm; padding-right: 2mm;">
                <table class="infoCFDI">
                    <tr>
                        <td><strong>Importe:</strong></td>
                        <td>{{$factura->addenda->Importe}}</td>
                        <td><strong>Periodo meses:</strong></td>
                        <td>{{$factura->addenda->PeriodoEnMeses}}</td>
                        <td><strong>Importe:</strong></td>
                        <td>{{$factura->addenda->Descripcion}}</td>
                    </tr>
                </table>
            </div>
        </div>
        @endif

		<div class="float" style="padding-left: 2mm; width: 30mm;">
            <img style="height: 40mm;" src="{{(new QRCode)->render($factura->qr)}}" alt="QR Code" />
		</div>
		<div class="float" style="width: 190mm;">
			<div class="lastElements">
				<div class="title">Cadena original del complemento de certificacion digital del SAT</div>
				<div class="content small" style="padding-right: 1mm;">||1.1|{{$factura->uUID}}|{{$factura->timeStamp}}|{{$factura->selloSAT}}|{{$factura->noCertificadoSAT}}||</div>
			</div>

		</div>
	</div>
	<div style="padding-left: 3mm; padding-top: 3mm;">
        Version: {{$factura->version}}<br />
        **Este documento es una representación impresa de un CFDI.</div>

</body>
</html>
