<?php use chillerlan\QRCode\QRCode;?>
<!DOCTYPE html>
<html>
<head>
<style type="text/css">
@page *{
	margin: 0;
	padding: 0;
	margin-bottom: 0;
	padding-bottom: 0;
}

html, .nopadding {
	margin: 0;
	padding: 0;
}

body {
	font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
	font-size: 12px;
	margin: 0;
	padding: 0;
	margin-bottom: 0;
	padding-bottom: 0;
	color: {{$factura->color}};
}

h3{
	color: #666666;
	font-size: 18px;
}

.text-center{
	text-align: center;
}
.text-right{
	text-align: right;
}
#contenidoFactura{
	padding-bottom: 5mm;
	line-height: 5mm;
}
.float{
	float: left;
}
.width50{
	width: 49%;
}
.noBorder{
	border: none;
}
.title3{
	font-weight: bold;
	font-size: 22px;
	padding-top: 5px;
	padding-bottom: 15px;
}
.lineHeight{
	line-height: 5mm;
}

.header{
	width: 100%;
	background: #EFF3F6;
	padding: 1mm;
}

.logo{
	width: 40%;
	text-align: center;
}

.logo img{
	height: 35mm;
	width: 35mm;
}
.datosFacturas{
	width: 60%;
}
.datosFacturas tr td{
	border-bottom: 1px solid #999999;
	padding-bottom: 1mm;
}
.datosFacturas tr th{
	padding-top: 1mm;
}
.datosFacturas tr th, .datosFacturas tr td{
	padding: 1mm;
}
.datosFacturas h3{
	padding-top: 0;
	padding-bottom: 0px;
	margin-bottom: 0px;
}
.receptor{
	width: 200mm;
	padding-top: 2mm;
}

.receptor .h2{
	font-weight: bold;
	font-size: 16px;
}
.receptor .h3{
	font-weight: bold;
	font-size: 14px;
}
.float{
	display: inline-block;
}
#total{
	background: {{$factura->color}};
	width: 50mm;
	font-size: 18px;
	color: #FFFFFF;
	text-align: center;
	padding: 4mm;
	font-weight: bold;
}
.rowProd{
	padding-top: 3mm;
	border-bottom: 1px solid #E6E6E6;
	padding-bottom: 3mm;
	font-size: 12px;
}
.rowProd small{
	font-size: 11px;
}
.f13{
	font-size: 13px;
	font-weight: bold;

}

.tableTotales td, .tableTotales th{
	padding-bottom: 2mm;
	padding-top: 2mm;
	margin: 0;
}
.borderedTotales{
	border-bottom: 1px solid #E6E6E6;
}
.lastElements .title{
	background: #EFF3F6;
	padding-bottom: 2mm;
	padding-top: 2mm;
	text-align: center;
	font-weight: bold;
}

.lastElements .content{
	word-wrap: break-word;
	overflow-wrap: break-word;
	background: #FFFFFF;
}
.infoCFDI {
	text-align: left;
}
.infoCFDI td, .infoCFDI th{
	padding-bottom: 1mm;
	padding-top: 1mm;
}
.rowHead{
    text-align: center;
    font-weight: bold;
    border: 1px solid #E6E6E6;
}
.tableProdD tr td{
	height: 5mm;
	border: 1px solid #E6E6E6;
	font-size: 10px;
}
.small{
    font-size: 10px;
}
.pl33{
    padding-left: 3mm;
    padding-bottom: 3mm;
}
</style>
</head>
<body>
	<div class="header">
		<table style="width: 100%;">
			<tr>
				<td class="logo">
                    @if($factura->base64 != '')
                        <img src="{{$factura->base64}}" />
                    @endif
				</td>
				<td class="datosFacturas">

					<table class="text-center" style="width: 100%;">
        				<tr>
        					<th>FACTURA</th>
        					<th>FECHA EMISIÓN</th>
        				</tr>
        				<tr>
        					<td>{{$factura->serie}}{{$factura->noFactura}}</td>
        					<td>{{$factura->timeStamp}}</td>
        				</tr>
        				<tr>
        					<th>TIPO DOCUMENTO</th>
        					<th>USO DOCUMENTO</th>
        				</tr>
        				<tr>
        					<td>{{$adicionales['tipoDocumento'][$factura->tipoDeComprobante]}}</td>
        					<td>{{$factura->usoCFDI}}</td>
        				</tr>
        				<tr>
        					<td><strong>NO. DE OP</strong></td>
        					<td>{{$factura->noOp}}</td>
        				</tr>
        			</table>

				</td>
			</tr>
		</table>
		<div class="receptor">
			<table cellspacing="0" cellpadding="0">
				<tr>
					<td style="width: 150mm; padding-left: 1mm;">
                        <div class="h2">{{$factura->nmbEmisor}} <br> {{$factura->rFCEmisor}}</div>
                        {{$factura->regimenFiscal}}<br />
                        Lugar de expedición: {{$factura->lugarExpedicion}}
                        @if(!empty($factura->direccionProveedor))
                            - {{$factura->direccionProveedor}}
                        @endif

                        <div class="h3" style="padding-top: 5mm;">{{$factura->nmbRecep}} <br />

                            @if(isset($factura->comercio) && isset($factura->comercio->datos) && !empty($factura->comercio->datos->rfcExtranjero))
                                {{$factura->comercio->datos->rfcExtranjero}}
                            @else
                                {{$factura->rFCRecep}}
                            @endif
                            </div>
                        @if($factura->domicilioFiscalReceptor != '')
                            Domicilio: {{$factura->domicilioFiscalReceptor}}
                        @endif
                        @if(isset($factura->direccionCliente) && $factura->direccionCliente != '')
                            {{$factura->direccionCliente}}
                        @endif

                        @if(!empty($factura->regimenFiscalReceptor))
                            <br />Regimen fiscal: {{$factura->regimenFiscalReceptor}}
                        @endif

						@if($factura->tipoFacturasRelacionadas != '')
							<strong>Facturas relacionadas</strong><br />
							{{$factura->tipoFacturasRelacionadas}} - {{$factura->labelFacturasRelacionadas}}<br />
							@foreach($factura->facturasRelacionadas as $relacionada)
								{{$relacionada->uuid}}<br />
							@endforeach
						@endif
					</td>
					<td style="width: 50mm;">
						<div id="total">
						 	{{$adicionales['signoMoneda'][$factura->moneda]}}{{number_format ($factura->total, 2, '.', ',')}} {{$factura->moneda}}
						</div>
					</td>
				</tr>
			</table>
		</div>
	</div>



	<table cellspacing="0" cellpadding="0" style="width: 100%;" class="tableProdD">
		<tr>
			<td class="rowHead" style="width: 15mm;">CANT.</td>
			<td class="rowHead" style="width: 30mm;">C. PRODUCTO</td>
			<td class="rowHead">DESCRIPCION</td>
			<td class="rowHead" style="width: 20mm;">C. UNIDAD</td>
			<td class="rowHead" style="width: 25mm;">P. UNITARIO</td>
			<td class="rowHead" style="width: 25mm;">DESCUENTO</td>
			<td class="rowHead" style="width: 25mm;">IMPORTE</td>
		</tr>
	</table>
	@foreach($factura->conceptos as $concepto)
	<table cellspacing="0" cellpadding="0" style="width: 100%;" class="tableProdD">
		<tr>
			<td class="text-center" style="width: 15mm;">{{$concepto->qtyItem}}</td>
			<td class="text-center" style="width: 30mm;">{{$concepto->clave}}</td>
			<td>{{$concepto->dscItem}}</td>
			<td class="text-center" style="width: 20mm;">{{$concepto->unmdItem}}</td>
			<td class="text-center" style="width: 25mm;">${{number_format ($concepto->montoNetoItem, 2, '.', ',')}}</td>
			<td class="text-center" style="width: 25mm;">${{number_format ($concepto->descuento, 2, '.', ',')}}</td>
			<td class="text-center" style="width: 25mm;">${{number_format ($concepto->prcNetoItem, 2, '.', ',')}}</td>
		</tr>
	</table>
	@endforeach

	<div style="padding-top: 2mm;">
	<table>
		<tr>
			<td style="width: 135mm; padding: 0; margin: 0; vertical-align: top;">
					@if(isset($factura->cuentaPredial) && $factura->cuentaPredial != '')
					<strong>Cuenta Predial: {{$factura->cuentaPredial}}</strong>
					@endif
			</td>
			<th style="width: 50mm;" class="text-right f13 borderedTotales" >Subtotal @if(isset($factura->comercio) && isset($factura->comercio->datos)) {{$factura->comercio->datos->incoterm->codigo}} @endif:</th>
			<td style="width: 30mm;" class="text-center f13 borderedTotales">${{number_format ($factura->subtotal, 2, '.', ',')}}</td>
		</tr>
		@if($factura->descuento > 0)
		<tr>
			<td></td>
			<th style="width: 50mm;" class="text-right f13 borderedTotales" >Descuento:</th>
			<td style="width: 30mm;" class="text-center f13 borderedTotales">${{number_format ($factura->descuento, 2, '.', ',')}}</td>
		</tr>
		@endif
		@foreach($factura->impuestosTrasladados as $impuesto)
		<tr>
			<td></td>
			<th style="width: 50mm;" class="text-right f13 borderedTotales" >{{$adicionales['impuestos'][$impuesto->impuesto]}} {{$impuesto->tasaOCuota * 100}}% trasladado:</th>
			<td style="width: 30mm;" class="text-center f13 borderedTotales">${{number_format ($impuesto->importe, 2, '.', ',')}}</td>
		</tr>
		@endforeach
		@foreach($factura->impuestosRetenidos as $impuesto)
		<tr>
			<td></td>
			<th style="width: 50mm;" class="text-right f13 borderedTotales" >{{$adicionales['impuestos'][$impuesto->impuesto]}} retenido:</th>
			<td style="width: 30mm;" class="text-center f13 borderedTotales">${{number_format ($impuesto->importe, 2, '.', ',')}}</td>
		</tr>
		@endforeach


		@if(isset($factura->impuestosTrasladadosLcl) && count($factura->impuestosTrasladadosLcl) > 0)
		@foreach($factura->impuestosTrasladadosLcl as $impuesto)
		<tr>
			<td></td>
			<th style="width: 50mm;" class="text-right f13 borderedTotales" >{{$impuesto->tipoImp}} trasladado:</th>
			<td style="width: 30mm;" class="text-center f13 borderedTotales">${{number_format ($impuesto->montoImp, 2, '.', ',')}}</td>
		</tr>
		@endforeach
		@endif

		@if(isset($factura->impuestosRetenidosLcl) && count($factura->impuestosRetenidosLcl) > 0)
		@foreach($factura->impuestosRetenidosLcl as $impuesto)
		<tr>
			<td></td>
			<th style="width: 50mm;" class="text-right f13 borderedTotales" >{{$impuesto->tipoImp}} retenido:</th>
			<td style="width: 30mm;" class="text-center f13 borderedTotales">${{number_format ($impuesto->montoImp, 2, '.', ',')}}</td>
		</tr>
		@endforeach
		@endif
		<tr>
			<td></td>
			<th style="width: 50mm;" class="text-right f13 borderedTotales" >Total @if(isset($factura->comercio) && isset($factura->comercio->datos)) {{$factura->comercio->datos->incoterm->codigo}} @endif:</th>
			<td style="width: 30mm;" class="text-center f13 borderedTotales">${{number_format ($factura->total, 2, '.', ',')}}</td>
		</tr>
	</table>
	</div>


	<div class="row" style="width: 100%; padding-top: 2mm;">

	<div class="lastElements" style="padding-bottom: 5mm;">
				<div class="title">DECLARACIONES AMBIENTAL Y DE CALIDAD</div>
				<div class="content"  style="padding-left: 2mm; padding-right: 2mm;">

					<table>
						<tr>
							<td>
                                <img src="{{$factura->base64Rec}}" style="height: 80px;" />
                            </td>
							<td style="font-size: 10px;">

							<strong>CONSTANCIA AMBIENTAL</strong><br />
	CON TU COMPRA CONTRIBUISTE A RECICLAR  <strong><?php echo $factura->pesoTotal?>  KG DE BASURA</strong> PLASTICA, GENERADOS POR  <strong><?php echo number_format($factura->pesoTotal*0.52, 2)?>   FAMILIAS</strong> AL MES QUE CONTAMINARIAN  <strong><?php echo number_format($factura->pesoTotal*13.15,2)?>   LTS  DE AGUA</strong> <br />
	<strong>¡FELICIDADES! ERES AMIGO DEL PLANETA!</strong>


							</td>
							<td style="font-size: 10px;">

							<strong>CALIDAD</strong><br />
	LOS PRODUCTOS INCLUIDOS EN LA PRESENTE FACTURA HAN SIDO VERIFICADOS CONFORME A ESTRICTAS NORMAS DE CALIDAD ESTABLECIDAS POR SITMA, PRODUCTOS A LOS QUE RECAE EL O LOS CERTIFICADOS DE CALIDAD ANEXOS

							</td>
						</tr>
					</table>

				</div>
			</div>

		<div class="lastElements" style="padding-bottom: 5mm;">
				<div class="title">Información del CFDI</div>
				<div class="content"  style="padding-left: 2mm;">

				<table class="infoCFDI">
						<tr>
							<td><strong>Folio fiscal:</strong></td>
							<td style="width: 60mm;">{{$factura->uUID}}</td>
							@if($factura->formaPago != '')
							<td style="width: 40mm;"><strong>Forma de pago:</strong></td>
							<td>{{$factura->formaPago}}</td>
							@endif
						</tr>
						<tr>
							<td><strong>No. de certificado:</strong></td>
							<td>{{$factura->noCertificado}}</td>
							<td><strong>No. de certificado SAT:</strong></td>
							<td>{{$factura->noCertificadoSAT}}</td>
						</tr>
						<tr>
							<td style="width: 40mm;"><strong>Método de pago:</strong></td>
							<td>{{$factura->metodoDePago}}</td>
							<td><strong>Fecha certificación:</strong></td>
							<td>{{$factura->fechaTimbrado}}</td>
						</tr>
						<tr>
							<td><strong>Importe con letra:</strong></td>
							<td colspan="2">{{$factura->cantidadLetra}} @if($factura->moneda == 'MXN')  Pesos @endif {{number_format (($factura->decimales*100), 0, '.', ',')}} /100
								@if($factura->moneda == 'MXN')  M.N. @endif
								@if($factura->moneda == 'USD') USD @endif</td>
						</tr>
						<tr>
							@if($factura->tipoDeComprobante == 'I' && isset($factura->otrosIngresos) && $factura->otrosIngresos == 1)
							<td><strong>Tipo de ingreso:</strong></td>
							<td>Otros ingresos</td>
							@endif
							@if($factura->moneda == 'USD' && $factura->tipoCambio > 1)
							<td><strong>Tipo de cambio:</strong></td>
							<td>{{number_format (($factura->tipoCambio), 2, '.', ',')}}</td>
							@endif
						</tr>
                    @if($factura->numRegIdTrib != '')
                        <tr>
                            <td><strong>RFC receptor:</strong></td>
                            <td>{{$factura->rFCRecep}}</td>
                        </tr>
                    @endif
                    @if($factura->comentario != '')
                        <tr>
                            <td><strong>Información de cliente:</strong></td>
                            <td>{{$factura->comentario}}</td>
                        </tr>
                    @endif
					</table>

				</div>
			</div>


        @if($factura->nota != '')
            <div class="pl33">
                <strong>Nota para el cliente:</strong> {{$factura->nota}}
            </div>
        @endif

        @if(isset($factura->comercio) && isset($factura->comercio->datos))
            <div class="lastElements" style="padding-bottom: 5mm;">
                <div class="title">Comercio exterior</div>
                <div class="content"  style="padding-left: 2mm; padding-right: 2mm;">

                    <table cellspacing="0" cellpadding="0" class="text-center" style="width: 100%;">
                        <tr>
                            <td style="padding-top: 1mm; text-align: left; vertical-align: top;">
                                <strong>Emisor</strong><br/>
                                @if($factura->comercio->datos->curp != '')
                                    <strong>CURP:</strong> {{$factura->comercio->datos->curp}}<br />
                                @endif
                                Domicilio: {{$factura->comercio->emisor->calle}}
                                {{$factura->comercio->emisor->nroExterior}}
                                {{$factura->comercio->emisor->nroInterior}},
                                {{$factura->comercio->emisor->municipioLbl}},
                                {{$factura->comercio->emisor->estadoLbl}},
                                {{$factura->comercio->emisor->pais}},
                                {{$factura->comercio->emisor->codigoPostal}}.

                                <br/><br/>
                                <strong>Incoterm:</strong> {{$factura->comercio->datos->incoterm->codigo}} - {{$factura->comercio->datos->incoterm->descripcion}}<br />
                                <strong>Pedimento:</strong> IMPORTACION O EXPORTACION DEFINITIVA ({{$factura->comercio->datos->clavePedimento}})<br />
                                <strong>Tipo Operacion:</strong> Exportación (2)<br />
                                <strong>Certificado Origen:</strong>  No funge como certificado de origen (0)<br />
                                <strong>División:</strong>  Sin división (0)
								@if($factura->moneda == 'EUR')
									<br /><strong>No. exportador confiable:</strong>  {{$factura->comercio->datos->numeroExportadorConfiable}}
								@endif

                            </td>
                            <td style="padding-top: 1mm; text-align: left; vertical-align: top;">

                                <strong>Receptor</strong><br/>
                                Domicilio: {{$factura->comercio->receptor->calle}}
                                {{$factura->comercio->receptor->nroExterior}}
                                {{$factura->comercio->receptor->nroInterior}},
                                {{$factura->comercio->receptor->municipio}},
                                {{$factura->comercio->receptor->estadoLbl}},
                                {{$factura->comercio->receptor->pais}},
                                {{$factura->comercio->receptor->codigoPostal}}.
                                <br/><br/>
                                <strong>Destinatario</strong><br/>
                                <strong>Id Fiscal extranjero:</strong> {{$factura->comercio->datos->rfcExtranjero}}<br />
                                Domicilio: {{$factura->comercio->receptor->calle}}
                                {{$factura->comercio->receptor->nroExterior}}
                                {{$factura->comercio->receptor->nroInterior}},
                                {{$factura->comercio->receptor->municipio}},
                                {{$factura->comercio->receptor->estadoLbl}},
                                {{$factura->comercio->receptor->pais}},
                                {{$factura->comercio->receptor->codigoPostal}}.
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                <br />
                                <table cellspacing="0" cellpadding="0" style="width: 100%;" class="tableProdD">
                                    <tr>
                                        <td class="rowHead">No. identificación</td>
                                        <td class="rowHead">Fracc. Arancelaria</td>
                                        <td class="rowHead">Unidad aduana</td>
                                        <td class="rowHead">Cantidad</td>
                                        <td class="rowHead">Valor unitario aduana</td>
                                        <td class="rowHead">Valor dólares</td>
                                    </tr>
                                    @foreach($factura->mercanciasComercio as $mercancia)
                                    <tr>
                                        <td class="text-center">{{$mercancia->noIdentificacion}}</td>
                                        <td class="text-center">{{$mercancia->fraccionArancelaria}}</td>
                                        <td class="text-center">{{$mercancia->unidadAduana}} - {{$factura->unidadesMedidaAduana[$mercancia->unidadAduana]}}</td>
                                        <td class="text-center">{{$mercancia->cantidadAduana}}</td>
                                        <td class="text-center">
                                            ${{number_format ($mercancia->valorUnitarioAduana, 2, '.', ',')}}
                                        </td>
                                        <td class="text-center">
                                            ${{number_format ($mercancia->valorDolares, 2, '.', ',')}}
                                        </td>
                                    </tr>
                                    @endforeach
                                </table>
                            </td>
                        </tr>
                    </table>

                </div>
            </div>

        @endif



		<div class="lastElements" style="padding-bottom: 2mm;">
				<div class="title">Sello digital del CFDI</div>
				<div class="content small"  style="padding-left: 2mm; padding-right: 2mm;">{{$factura->sello}}</div>
			</div>
		<div class="lastElements" style="padding-bottom: 2mm;">
				<div class="title">Sello digital del SAT</div>
				<div class="content small"  style="padding-left: 2mm; padding-right: 2mm;">{{$factura->selloSAT}}</div>
			</div>

		<div class="float" style="padding-left: 2mm; width: 40mm;">
            <img style="height: 40mm;" src="{{(new QRCode)->render($factura->qr)}}" alt="QR Code" />
		</div>
		<div class="float" style="width: 174mm;">
			<div class="lastElements">
				<div class="title">Cadena original del complemento de certificacion digital del SAT</div>
				<div class="content small" style="padding-right: 1mm;">||1.1|{{$factura->uUID}}|{{$factura->timeStamp}}|{{$factura->selloSAT}}|{{$factura->noCertificadoSAT}}||</div>
			</div>

		</div>
	</div>
	<div style="padding-left: 3mm; padding-top: 3mm;">**Este documento es una representación impresa de un CFDI.</div>


</body>
</html>
