(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('HomeController', HomeController);

    HomeController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert'];

    function HomeController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert) {
        var vm = this;
        
        vm.resultados = {
        	foliosAsignados: 0,
        	noFacturasEmitidas: 0,
        	noFacturasRestantes: 0,
        	resultadosMesActual: {
        		facturasActivas: 0,
        		facturasCanceladas: 0,
        		totalFacturado: 0
        	}
        };

        activate();

        ////////////////

        function activate() {
        	
        	
        	vm.loading = "whirl double-up";
        	
        	
        	$http.post('/api/admin/proveedores/home', {
				user : $rootScope.user 
			}).then(function(res) {
				var response = res['data'];
				if (response['success']) {
					
					vm.loading = "";
					vm.resultados.foliosAsignados = response.foliosAsignados;
					vm.resultados.noFacturasEmitidas = response.noFacturasEmitidas;
					vm.resultados.noFacturasRestantes = response.noFacturasRestantes;
					vm.resultados.resultadosMesActual = response.resultadosMesActual;
					vm.resultados.sumaAnioFacturacion = response.sumaAnioFacturacion;
					console.log(vm.resultados.resultadosMesActual);
					
					vm.pieData = [vm.resultados.noFacturasRestantes, vm.resultados.noFacturasEmitidas];
					
					var datosFacturacionAnual = [];
					for(var x = 0; x < vm.resultados.sumaAnioFacturacion.length; x++){
						vm.lineLabels.push($rootScope.mesesLbl[vm.resultados.sumaAnioFacturacion[x].mes]);
						datosFacturacionAnual.push(vm.resultados.sumaAnioFacturacion[x].total);
					}
					
					vm.lineData.push(datosFacturacionAnual);
					
				}
				
				
			}, function errorCallback(response) {
				Notify.alert('Ocurrió un error.', {status: 'danger'});
				vm.loadingWare = "";
			  });

        	
        	 // Line chart
            // -----------------------------------
            vm.lineLabels = [];
            vm.lineData = [];
            vm.lineOnClick = function(points, evt) {
                console.log(points, evt);
            };
            vm.lineDatasetOverride = [{
                yAxisID: 'y-axis-1'
            }];
            vm.lineOptions = {
                scales: {
                    yAxes: [{
                        id: 'y-axis-1',
                        type: 'linear',
                        display: true,
                        position: 'left'
                    }]
                }
            };
            vm.lineColors = ['#36C282'];
            
            
         // Pie Chart
            // ------------------
            vm.pieLabels = ["Folios restantes", "Folios consumidos"];
            vm.pieData = [1, 1];
            vm.pieColors = ['#36C282', '#CCCCCC'];



        }
    }
})();