(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('CancelacionesController', CancelacionesController);

    CancelacionesController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'ngDialog'];

    function CancelacionesController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, ngDialog) {
        var vm = this;
        vm.asociados = [];
        
        activate();

        ////////////////
        
        function activate() {

        	
        	vm.obtenerDatos = function(){
        	
	        	vm.loading = "whirl double-up";
	        	
	        	$http.post('/api/admin/asociados/getAsociados', {
					user : $rootScope.user
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {
						
						vm.loading = "";
						vm.asociados = response.asociados;
						vm.paqueteAsignado = response.paqueteAsignado;
						vm.paqueteAsignado.foliosRestantes = vm.paqueteAsignado.folios - vm.paqueteAsignado.foliosAsignados;
						
					}
					
				}, function errorCallback(response) {
					Notify.alert('Ocurrió un error.', {status: 'danger'});
					vm.loadingWare = "";
				  });
        	}
        	
        	vm.obtenerAsociado = function(id_asociado){
        		
        		$state.transitionTo('app.asociadoDetalle', {id: id_asociado});
        	
        	};
        	
        	vm.borrarAsociado = function(asociado){
        		
        		SweetAlert.swal({
                    title: 'Eliminar asociado',
                    text: 'Estás seguro de eliminar a ' + asociado.proveedor.rFCEmisor,
                    type: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#DD6B55',
                    confirmButtonText: 'Sí, elimínalo!',
                    cancelButtonText: 'No, cancelar!',
                    closeOnConfirm: false,
                    closeOnCancel: false
                }, function (isConfirm) {
                    if (isConfirm) {


                        $http.post('/api/admin/asociados/borrarAsociado', {
                        	id_asociado: asociado.id_asociadosProveedor,
                            user: $rootScope.user
                        }).then(function (res) {
                            var response = res['data'];
                            if (response['success']) {
                            	
                            	for(var x = 0; x < vm.asociados.length; x++){
                            		if(vm.asociados[x].id_asociadosProveedor == asociado.id_asociadosProveedor){
                            			vm.asociados.splice(x, 1);
                            		}
                            	}
                            	
                                SweetAlert.swal('Deleted!', 'El asociado fue eliminado correctamente.', 'success');
                            }
                        });

                    } else {
                        SweetAlert.swal('Cancelado', 'El asociado NO fue eliminado :)', 'error');
                    }
                });
        		
        	};
        	
        	
        	vm.agregarPaquete = function(asociado){
        		
        		ngDialog.openConfirm({
                    template: 'addPaquete',
                    className: 'ngdialog-theme-default',
                    data: {asociado: asociado},
                    controller: 'AddPaquetesController',
                }).then(function (buscar) {
                }, function (state) {
                    if(state > 1){
                    	
                    	for(var x = 0; x < vm.asociados.length; x++){
                    		if(vm.asociados[x].id_asociadosProveedor == asociado.id_asociadosProveedor){
                    			vm.asociados[x].paquete = Number(vm.asociados[x].paquete) + Number(state);
                    			vm.asociados[x].restantes = vm.asociados[x].restantes + Number(state);
                    			
                    			vm.paqueteAsignado.foliosAsignados = Number(vm.paqueteAsignado.foliosAsignados) + Number(state);
                    			vm.paqueteAsignado.foliosRestantes = vm.paqueteAsignado.folios - vm.paqueteAsignado.foliosAsignados;
                    			break;
                    		}
                    	}
                    	Notify.alert('El paquete se agregó de forma correcta.', {status: 'success'});
                    }
                });
        		
        	};
        	
        	vm.revisarCancelaciones = function(){
        		vm.loading = "whirl double-up";
        		setTimeout(function(){ Notify.alert('No se han encontrado cancelaciones pendientes.', {status: 'success'}); vm.loading = ""; }, 3000);
        	};
        	
        	
        	vm.obtenerDatos();

        }
        
    }
})();


