<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class Pago extends Model {

	protected $table = 'Pago';

	public $timestamps = false;

	protected $primaryKey = 'id';
	
	public function documentosRelacionado() {
		return $this->hasMany('App\Models\DoctoRelacionado', 'id_pago', 'id');
	}
	
	public function formaPago(){
		return $this->hasOne('App\Models\FormaPago', 'codigo', 'FormaDePagoP');
	}
	
	public function factura(){
	    return $this->hasOne('App\Models\Factura', 'id_factura', 'id_factura');
	}
	
}
?>