<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class Empleado extends Model {

	protected $table = 'Empleado';

	public $timestamps = false;

	protected $primaryKey = 'id_empleado';
	

	public function cliente(){
		return $this->hasOne('App\Models\Cliente', 'id_cliente', 'id_cliente');
	}
	
	public function percepciones(){
		return $this->hasMany('App\Models\PercepcionDeduccion', 'id_empleado', 'id_empleado')->where('status', '=', 1)->where('tipo', '=', 1);
	}
	
	public function deducciones(){
		return $this->hasMany('App\Models\PercepcionDeduccion', 'id_empleado', 'id_empleado')->where('status', '=', 1)->where('tipo', '=', 2);
	}
}
?>