<?php

namespace App\Http\Controllers;

use App\Commands\NumeroLetra;
use App\Commands\Utils;
use App\Commands\XMLUtils;
use App\Models\CatalogoRegimenFiscal;
use App\Models\FormaPago;
use App\Models\Proveedor;
use App\Models\UsoCFDI;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Input;
use Dompdf\Dompdf;

class WebServiceController extends BaseController {




    public function getXML33External(Request $request){

        date_default_timezone_set("America/Mexico_City");

        $token = $request->input('token');
        $tokenDecoded64 = base64_decode ( $token );
        $tokenDecoded = Utils::decryptData ( $tokenDecoded64 );

        $datos = array ();
        $arrayDeToken = explode ( "&", $tokenDecoded );
        foreach ( $arrayDeToken as $itemtoken ) {
            $datosSplit = explode ( "=", $itemtoken );
            $datos [$datosSplit [0]] = $datosSplit [1];
        }

        if (! empty ( $datos ['id_factura'] )) {

            $tipo = $datos ['tipo'];
            $id_factura = $datos ['id_factura'];
            $id_proveedor = $datos ['id_proveedor'];

            if ($tipo == "xml") {

                $datosFactura = Utils::obtenerDatosFactura($id_factura, $id_proveedor);

                if($datosFactura->version == '4.0'){
                    $xml = XMLUtils::createXML40($datosFactura, null);
                }else{
                    $xml = XMLUtils::createXML33($datosFactura, null);
                }

                $nombreXML = $datosFactura->rFCEmisor . "-" . $datosFactura->serie . $datosFactura->noFactura.".xml";

                // use headers in order to generate the download
                $headers = [
                    'Content-type' => 'text/xml',
                    'Content-Disposition' => sprintf('attachment; filename="%s"', $nombreXML)
                ];

                // make a response, with the content, a 200 response code and the headers
                return Response::make($xml, 200, $headers);


            }

        }
    }


    public function getPDFExternal(Request $request){

        date_default_timezone_set("America/Mexico_City");

        $token = $request->input('token');

        $tokenDecoded64 = base64_decode($token);
        $tokenDecoded = Utils::decryptData($tokenDecoded64);

        $toLog = print_r($tokenDecoded, true);
        Log::error($toLog);

        $datos = array();
        $arrayDeToken = explode("&", $tokenDecoded);

        foreach ($arrayDeToken as $itemtoken) {
            $datosSplit = explode("=", $itemtoken);
            $datos[$datosSplit[0]] = $datosSplit[1];
        }

        if (! empty($datos['id_factura'])) {

            $tipo = $datos['tipo'];
            $id_factura = $datos['id_factura'];
            $id_proveedor = $datos ['id_proveedor'];
            $template = $datos ['template'];
            $otrosIngresos = isset($datos ['otrosIngresos']) ? $datos ['otrosIngresos'] : 0;



            if ($tipo == "pdf") {

                $proveedor = Proveedor::where('id_proveedor', "=", $id_proveedor)->first();

                $metodosDePago = array(
                    '' => '',
                    'PUE' => 'PUE - Pago en una sola exhibición',
                    'PPD' => 'PPD - Pago en parcialidades o diferido'
                );
                $impuestos = array(
                    '001' => 'ISR',
                    '002' => 'IVA',
                    '003' => 'IEPS'
                );

                $datosFactura = Utils::obtenerDatosFactura($id_factura, $id_proveedor);

                if(trim($datosFactura->tipoFacturasRelacionadas) != ''){

                	$tipoRelaciones = array(
                			'01' => 'Nota de crédito de los documentos relacionados',
                			'02' => 'Nota de débito de los documentos relacionados',
                			'03' => 'Devolución de mercancía sobre facturas o traslados previos',
                			'04' => 'Sustitución de los CFDI previos',
                			'05' => 'Traslados de mercancias facturados previamente',
                			'06' => 'Factura generada por los traslados previos',
                			'07' => 'CFDI por aplicación de anticipo'
                	);

                	$datosFactura->labelFacturasRelacionadas = $tipoRelaciones[$datosFactura->tipoFacturasRelacionadas];

                }

                $datosFactura->noFactura = str_pad($datosFactura->noFactura, 5, "0", STR_PAD_LEFT);
                $datosFactura->timeStamp = date_format(new \DateTime($datosFactura->timeStamp), 'Y-m-d\TH:i:s');

                $usoCFDI = UsoCFDI::where('codigo', '=', $datosFactura->usoCFDI)->first();
                $datosFactura->usoCFDI = "$usoCFDI->codigo - $usoCFDI->descripcion";

                $regimenFiscal = CatalogoRegimenFiscal::where('code', '=', $datosFactura->regimenFiscal)->first();
                $datosFactura->regimenFiscal = $regimenFiscal->descripcion;

                if ($datosFactura->regimenFiscalReceptor != null && !empty($datosFactura->regimenFiscalReceptor)) {
                    $regimenReceptor = CatalogoRegimenFiscal::where('code', '=', $datosFactura->regimenFiscalReceptor)->first();
                    $datosFactura->regimenFiscalReceptor = "$regimenReceptor->code - $regimenReceptor->descripcion";
                }

                if ($datosFactura->formaPago != '') {
                    $formaDePago = FormaPago::where('codigo', '=', $datosFactura->formaPago)->first();
                    $datosFactura->formaPago = $formaDePago->codigo . ' - ' . $formaDePago->descripcion;
                }

                if ($datosFactura->metodoDePago != '') {
                    $datosFactura->metodoDePago = $metodosDePago[$datosFactura->metodoDePago];
                }

                $datosFactura->total = Utils::formatNumber($datosFactura->total, $datosFactura->precission);

                $datosFactura->cantidadLetra = NumeroLetra::num2letras($datosFactura->total, false, false);

                $whole = floor($datosFactura->total);
                $datosFactura->decimales = $datosFactura->total - $whole;
                $datosFactura->decimales = ($datosFactura->decimales < 10) ? '0' . $datosFactura->decimales : $datosFactura->decimales;

                $tiposDocumentos = array();
                $tiposDocumentos['I'] = 'Ingreso';
                $tiposDocumentos['E'] = 'Egreso';
                $tiposDocumentos['T'] = 'Traslado';
                $tiposDocumentos['P'] = 'Pago';

                $datosFactura->unidadesMedidaAduana = array('01' => 'KILO', '02' => 'GRAMO', '06' => 'PIEZA', '14' => 'TONELADA', '20' => 'CAJA', '99' => 'SERVICIO');
                $signoMoneda = array('MXN' => '$', 'USD' => '$', 'EUR' => '€');

                $adicionales = [
                    'tipoDocumento' => $tiposDocumentos,
                    'impuestos' => $impuestos,
                    'signoMoneda' => $signoMoneda
                ];

                $datosFactura->subtotal = Utils::formatNumber($datosFactura->subtotal, $datosFactura->precission);
                $datosFactura->imagen = env('DIR_LOGOS') . $proveedor->imagen;

                if( !file_exists($datosFactura->imagen) || is_dir($datosFactura->imagen)){
                    $datosFactura->base64 = '';
                }else{
                    $type = pathinfo($datosFactura->imagen, PATHINFO_EXTENSION);
                    $data = file_get_contents($datosFactura->imagen);
                    $base64 = 'data:image/' . $type . ';base64,' . base64_encode($data);
                    $datosFactura->base64 = $base64;
                }

                $logoRecycling = env('DIR_LOGOS')."recycling-sitma.png";
                $type = pathinfo($logoRecycling, PATHINFO_EXTENSION);
                $data2 = file_get_contents($logoRecycling);
                $base642 = 'data:image/' . $type . ';base64,' . base64_encode($data2);
                $datosFactura->base64Rec = $base642;

                $datosFactura->color = $proveedor->color;

                if (count($datosFactura->pagos)) {
                    $datosFactura->totalPagos = 0;
                    foreach ($datosFactura->pagos as $pago) {
                        $datosFactura->totalPagos += $pago->Monto;

                        $pago->FechaPago = new \DateTime($pago->FechaPago);
                        $pago->FechaPago = date_format($pago->FechaPago, 'Y-m-d\TH:i:s');
                    }
                }

                $total_factura = number_format($datosFactura->total, 6);
                $total_factura = str_replace(",", "", $total_factura);
                $total_factura = str_pad($total_factura, 17, "0", STR_PAD_LEFT);

                $datosFactura->qr = "https://verificacfdi.facturaelectronica.sat.gob.mx/default.aspx?id=$datosFactura->uUID&re=$datosFactura->rFCEmisor&rr=$datosFactura->rFCRecep&tt=$total_factura&fe=".substr($datosFactura->sello, -8);

                $datosFactura->otrosIngresos = $otrosIngresos;

                $disenoFactura = 'pdf.' . $template;
                if ($datosFactura->tipoDeComprobante == 'P')
                    $disenoFactura = 'pdf.pago';

                $html = view($disenoFactura, [
                    'factura' => $datosFactura,
                    'adicionales' => $adicionales
                ])->render();

                $fileName = $datosFactura->rFCEmisor . "-$datosFactura->serie$datosFactura->noFactura.pdf";

                $fullPath = 'tmp/'. $fileName;

                $domPDF = new Dompdf();
                $domPDF->loadHtml($html);
                $domPDF->render();
                $domPDF->stream($fullPath);

            }
        }

    }


}

