<?php
namespace App\Http\Controllers;

use App\Models\CatalogoRegimenFiscal;
use App\Models\ContactoReceptor;
use App\Models\DomFiscal;
use App\Models\DomFiscalRcp;
use App\Models\LiquidacionFac;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Response;

use App\Models\Empleado;
use App\Models\CatalogoRegimenContratacion;
use App\Models\CatalogoBancos;
use App\Models\CatalogoRiesgoPuesto;
use App\Models\PercepcionDeduccion;
use App\Models\TipoPercepcionDeduccion;
use App\Models\Cliente;
use App\Models\AdicionalNomina;
use App\Models\Serie;
use App\Models\FormaPago;
use App\Models\PeriodoNomina;
use App\Models\EmpleadoFac;
use App\Models\PercepcionDeduccionFac;
use App\Commands\Utils;
use App\Models\Proveedor;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use App\Models\CertificadoProveedor;
use App\Commands\XMLUtils;
use PhpOffice\PhpSpreadsheet\IOFactory;
use SoapClient;
use App\Models\IdDoc;
use App\Models\Totales;
use App\Models\Concepto;
use App\Models\Factura;



class NominaController extends BaseController {


	public function listadoEmpleados(Request $request){

		$user = $request->input('user');

		$empleados = Empleado::with('cliente')->where('status', '=', 1)->where('id_proveedor', '=', $user['id_proveedor'])->get();
		if(is_object($empleados)){

			foreach ($empleados as $index => $empleado){
				if(!is_object($empleado->cliente)){
					unset($empleados[$index]);
				}
			}

			$empleados = $empleados->toArray();
		}



		return Response::json ( array (
			'success' => true,
			'empleados' => $empleados
		));

	}


	public function borrarEmpleado(Request $request){

		$id_empleado = $request->input('id_empleado');

		$empleado = Empleado::where('id_empleado', '=', $id_empleado)->update(['status' => 0]);

		return Response::json ( array (
				'success' => true
		));

	}



	public function obtenerDatosEmpleado(Request $request){

		$id_empleado = $request->input('id_empleado');
		$user = $request->input('user');

		$regimenesContratacion = CatalogoRegimenContratacion::where('status', '=', 1)->get();

		$bancos = CatalogoBancos::where('status', '=', 1)->get();

		$riesgosPuesto = CatalogoRiesgoPuesto::where('status', '=', 1)->get();

		$tipoPercepciones = TipoPercepcionDeduccion::where('status', '=', 1)->where('tipo', '=', 1)->get();

        $regimenesFiscales = CatalogoRegimenFiscal::where('status', '=', 1)->get();

		$tipoPercepcionesDividido = array(
				'Percepciones' => array('label' => 'Percepciones', 'listado' => array()),
				'OtrosPagos' => array('label' => 'Otros Pagos', 'listado' => array()));

		foreach ($tipoPercepciones as $percepcion){
			if($percepcion->subTipo == 1){
				$tipoPercepcionesDividido['Percepciones']['listado'][] = $percepcion->toArray();
			}else{
				$tipoPercepcionesDividido['OtrosPagos']['listado'][] = $percepcion->toArray();
			}
		}

		$tipoDeducciones = TipoPercepcionDeduccion::where('status', '=', 1)->where('tipo', '=', 2)->get();

		$empleado = '';
		$percepciones = '';
		$deducciones = '';

		if($id_empleado > 0){

			$empleado = Empleado::with('cliente.domicilio', 'percepciones.tipopd', 'deducciones.tipopd')->where('status', '=', 1)->where('id_proveedor', '=', $user['id_proveedor'])->where('id_empleado', '=', $id_empleado)->first();

			if(is_object($empleado)){
                if(is_object($empleado->cliente->domicilio)){
                    $empleado->cp = $empleado->cliente->domicilio->codigoPostal;
                    $empleado->regimenFiscalReceptor = $empleado->cliente->regimenFiscalReceptor;
                }
                $empleado = $empleado->toArray();
            }
		}


		return Response::json ( array (
				'success' => true,
				'regimenesContratacion' => $regimenesContratacion->toArray(),
				'bancos' => $bancos->toArray(),
				'riesgosPuesto' => $riesgosPuesto->toArray(),
				'tipoPercepciones' => $tipoPercepciones->toArray(),
				'tipoDeducciones' => $tipoDeducciones->toArray(),
				'empleado' => $empleado,
				'tipoPercepcionesDividido' => $tipoPercepcionesDividido,
            'regimenesFiscalesList' => $regimenesFiscales->toArray(),

		));

	}


	public function obtenerDatosEmpleadoRecibo(Request $request){

		$id_empleadoFac = $request->input('id_empleadoFac');
		$user = $request->input('user');

		$regimenesContratacion = CatalogoRegimenContratacion::where('status', '=', 1)->get();

		$bancos = CatalogoBancos::where('status', '=', 1)->get();

		$riesgosPuesto = CatalogoRiesgoPuesto::where('status', '=', 1)->get();

		$tipoPercepciones = TipoPercepcionDeduccion::where('status', '=', 1)->where('tipo', '=', 1)->get();

        $regimenesFiscales = CatalogoRegimenFiscal::where('status', '=', 1)->get();

		$tipoPercepcionesDividido = array(
				'Percepciones' => array('label' => 'Percepciones', 'listado' => array()),
				'OtrosPagos' => array('label' => 'Otros Pagos', 'listado' => array()));

		foreach ($tipoPercepciones as $percepcion){
			if($percepcion->subTipo == 1){
				$tipoPercepcionesDividido['Percepciones']['listado'][] = $percepcion->toArray();
			}else{
				$tipoPercepcionesDividido['OtrosPagos']['listado'][] = $percepcion->toArray();
			}
		}

		$tipoDeducciones = TipoPercepcionDeduccion::where('status', '=', 1)->where('tipo', '=', 2)->get();

        $empleadoObj = EmpleadoFac::with('cliente.domicilio', 'percepciones.tipopd', 'deducciones.tipopd', 'liquidacion')->find($id_empleadoFac);

        $empleadoObj->regimenFiscalReceptor = $empleadoObj->cliente->regimenFiscalReceptor;
        if(is_object($empleadoObj->cliente->domicilio)){
            $empleadoObj->cp = $empleadoObj->cliente->domicilio->codigoPostal;
        }
        if(is_object($empleadoObj->cliente->contacto)){
            $empleadoObj->email = $empleadoObj->cliente->contacto->email;
        }
        $empleadoObj = $empleadoObj->toArray();



		return Response::json ( array (
				'success' => true,
				'regimenesContratacion' => $regimenesContratacion->toArray(),
				'bancos' => $bancos->toArray(),
				'riesgosPuesto' => $riesgosPuesto->toArray(),
				'tipoPercepciones' => $tipoPercepciones->toArray(),
				'tipoDeducciones' => $tipoDeducciones->toArray(),
				'empleado' => $empleadoObj,
				'tipoPercepcionesDividido' => $tipoPercepcionesDividido,
            'regimenesFiscalesList' => $regimenesFiscales->toArray(),

		));

	}


	public function borrarPercepcion(Request $request){

		$id = $request->input('id_percepcionDeduccion');

		PercepcionDeduccion::destroy($id);

		return Response::json ( array (
				'success' => true
		));
	}


	public function borrarPercepcionRecibo(Request $request){

		$id = $request->input('id_percepcionDeduccionFac');

		PercepcionDeduccionFac::destroy($id);

		return Response::json ( array (
				'success' => true
		));
	}

	public function guardarPercepcionDeduccion(Request $request){

		$percepcionDeduccion = $request->input('percepcionDeduccion');
		$user = $request->input('user');

		if(isset($percepcionDeduccion['id_percepcionDeduccion']) && $percepcionDeduccion['id_percepcionDeduccion'] > 0){

			$percepcionDeduccionObj = PercepcionDeduccion::find($percepcionDeduccion['id_percepcionDeduccion']);

		}else{
			$percepcionDeduccionObj = new PercepcionDeduccion();
		}

		$percepcionDeduccionObj->id_empleado = $percepcionDeduccion['id_empleado'];
		$percepcionDeduccionObj->id_tipoPercepcionDeduccion = $percepcionDeduccion['id_tipoPercepcionDeduccion'];
		$percepcionDeduccionObj->importeGravado = ($percepcionDeduccion['importeGravado'] == '') ? 0 : $percepcionDeduccion['importeGravado'];
		$percepcionDeduccionObj->importeExcento = ($percepcionDeduccion['importeExcento'] == '') ? 0 : $percepcionDeduccion['importeExcento'];
		$percepcionDeduccionObj->tipo = $percepcionDeduccion['tipo'];
		$percepcionDeduccionObj->status = 1;
		$percepcionDeduccionObj->noDiasHoras = isset($percepcionDeduccion['noDiasHoras'])?$percepcionDeduccion['noDiasHoras'] : 0;
		$percepcionDeduccionObj->noHoras = isset($percepcionDeduccion['noHoras'])?$percepcionDeduccion['noHoras'] : 0;
		$percepcionDeduccionObj->tipoHoras = isset($percepcionDeduccion['tipoHoras'])?$percepcionDeduccion['tipoHoras'] : 0;

		$percepcionDeduccionObj->save();

		$percepcionDeduccionObj = PercepcionDeduccion::with('tipopd')->find($percepcionDeduccionObj->id_percepcionDeduccion);


		return Response::json ( array (
			'success' => true,
			'percepcionDeduccion' => $percepcionDeduccionObj->toArray()
		));
	}


	public function guardarPercepcionDeduccionRecibo(Request $request){

		$percepcionDeduccion = $request->input('percepcionDeduccion');
		$user = $request->input('user');

		if(isset($percepcionDeduccion['id_percepcionDeduccionFac']) && $percepcionDeduccion['id_percepcionDeduccionFac'] > 0){

			$percepcionDeduccionObj = PercepcionDeduccionFac::find($percepcionDeduccion['id_percepcionDeduccionFac']);

		}else{
			$percepcionDeduccionObj = new PercepcionDeduccionFac();
		}

		$percepcionDeduccionObj->id_empleadoFac = $percepcionDeduccion['id_empleadoFac'];
		$percepcionDeduccionObj->id_tipoPercepcionDeduccion = $percepcionDeduccion['id_tipoPercepcionDeduccion'];
        $percepcionDeduccionObj->importeGravado = ($percepcionDeduccion['importeGravado'] == '') ? 0 : $percepcionDeduccion['importeGravado'];
        $percepcionDeduccionObj->importeExcento = ($percepcionDeduccion['importeExcento'] == '') ? 0 : $percepcionDeduccion['importeExcento'];
		$percepcionDeduccionObj->tipo = $percepcionDeduccion['tipo'];
		$percepcionDeduccionObj->status = 1;
		$percepcionDeduccionObj->noDiasHoras = isset($percepcionDeduccion['noDiasHoras'])?$percepcionDeduccion['noDiasHoras'] : 0;
		$percepcionDeduccionObj->noHoras = isset($percepcionDeduccion['noHoras'])?$percepcionDeduccion['noHoras'] : 0;
		$percepcionDeduccionObj->tipoHoras = isset($percepcionDeduccion['tipoHoras'])?$percepcionDeduccion['tipoHoras'] : '';
		$percepcionDeduccionObj->save();

		$percepcionDeduccionObj = PercepcionDeduccionFac::with('tipopd')->find($percepcionDeduccionObj->id_percepcionDeduccionFac);


		return Response::json ( array (
				'success' => true,
				'percepcionDeduccion' => $percepcionDeduccionObj->toArray()
		));
	}

	public function guardarEmpleado(Request $request){

		$empleado = $request->input('empleado');
		$user = $request->input('user');

		if(isset($empleado['id_empleado']) && $empleado['id_empleado'] > 0){

			$empleadoObj = Empleado::with('cliente.contacto')->find($empleado['id_empleado']);
			$clienteObj = $empleadoObj->cliente;

            $domicilioObj = DomFiscalRcp::find($clienteObj->id_cliente);
            if(!is_object($domicilioObj))
                $domicilioObj = new DomFiscalRcp();

            $contactoObj = $empleadoObj->cliente->contacto;
            if(!is_object($contactoObj)){
                $contactoObj = new ContactoReceptor();
            }

		}else{
			$clienteObj = new Cliente();
			$empleadoObj = new Empleado();
            $domicilioObj = new DomFiscalRcp();
            $contactoObj = new ContactoReceptor();
		}

		$clienteObj->id_proveedor = $user['id_proveedor'];
		$clienteObj->rFCRecep = $empleado['cliente']['rFCRecep'];
		$clienteObj->nmbRecep = $empleado['cliente']['nmbRecep'];
        if(isset($empleado['regimenFiscalReceptor']))
            $clienteObj->regimenFiscalReceptor = $empleado['regimenFiscalReceptor'];
		$clienteObj->status = 1;
		$clienteObj->save();

        $domicilioObj->id_cliente = $clienteObj->id_cliente;
        $domicilioObj->codigoPostal = $empleado['cp'] ?? '';
        $domicilioObj->save();

        $contactoObj->id_cliente = $clienteObj->id_cliente;
        $contactoObj->email = $empleado['email'];
        $contactoObj->save();

		if($empleado['fechaInicioRelLaboral'] == '0000-00-00')
            $empleado['fechaInicioRelLaboral'] = null;

		$empleadoObj->id_proveedor  = $user['id_proveedor'];
		$empleadoObj->id_cliente  = $clienteObj->id_cliente;
		$empleadoObj->id_catalogoRegimenContratacion  = isset($empleado['id_catalogoRegimenContratacion']) ? $empleado['id_catalogoRegimenContratacion'] : null;
		$empleadoObj->id_catalogoRiesgoPuesto  = isset($empleado['id_catalogoRiesgoPuesto']) ? $empleado['id_catalogoRiesgoPuesto'] : null;
		$empleadoObj->noEmpleado  = isset($empleado['noEmpleado']) ? $empleado['noEmpleado'] : '';
		$empleadoObj->curp  = isset($empleado['curp']) ? $empleado['curp'] : '';
		$empleadoObj->nss  = isset($empleado['nss']) ? $empleado['nss'] : '';
		$empleadoObj->departamento  = isset($empleado['departamento']) ? $empleado['departamento'] : '';
		$empleadoObj->id_catalogoBancos  = isset($empleado['id_catalogoBancos']) ? ($empleado['id_catalogoBancos'] == '' ? null : $empleado['id_catalogoBancos']) : null;
		$empleadoObj->puesto  = isset($empleado['puesto']) ? $empleado['puesto'] : '';
		$empleadoObj->tipoJornada  = isset($empleado['tipoJornada']) ? $empleado['tipoJornada'] : '';
		$empleadoObj->periodicidadPago  = isset($empleado['periodicidadPago']) ? $empleado['periodicidadPago'] : '';
        $empleadoObj->salarioBase  = isset($empleado['salarioBase']) ?
            (($empleado['salarioBase'] == '') ? 0 : $empleado['salarioBase']) : '';
        $empleadoObj->salarioDiarioIntegrado  =
            isset($empleado['salarioDiarioIntegrado']) ?
                (($empleado['salarioDiarioIntegrado'] == '') ? 0 : $empleado['salarioDiarioIntegrado']) : '';
        $empleadoObj->fechaInicioRelLaboral  = isset($empleado['fechaInicioRelLaboral']) ? ($empleado['fechaInicioRelLaboral'] == '0000-00-00' ? null : $empleado['fechaInicioRelLaboral']) : null;
		$empleadoObj->tipoContrato  = isset($empleado['tipoContrato']) ? $empleado['tipoContrato'] : '';
		$empleadoObj->noDiasPagados  = isset($empleado['noDiasPagados']) ? $empleado['noDiasPagados'] : '';
		$empleadoObj->ClaveEntFed  = isset($empleado['ClaveEntFed']) ? $empleado['ClaveEntFed'] : '';
		$empleadoObj->email  = isset($empleado['email']) ? $empleado['email'] : '';
		$empleadoObj->status  = 1;
		$empleadoObj->save();


		$empleadoObj = Empleado::with('cliente.domicilio', 'cliente.contacto', 'percepciones.tipopd', 'deducciones.tipopd')->find($empleadoObj->id_empleado);
        $empleadoObj->regimenFiscalReceptor = $empleadoObj->cliente->regimenFiscalReceptor;

        if(is_object($empleadoObj->cliente->domicilio)){
            $empleadoObj->cp = $empleadoObj->cliente->domicilio->codigoPostal;
        }
        if(is_object($empleadoObj->cliente->contacto)){
            $empleadoObj->email = $empleadoObj->cliente->contacto->email;
        }

		return Response::json ( array (
				'success' => true,
				'empleado' => $empleadoObj->toArray()
		));

	}


	public function guardarReciboNomina(Request $request){

		$empleado = $request->input('empleado');
		$user = $request->input('user');


		$empleadoObj = EmpleadoFac::with('cliente.domicilio', 'cliente.contacto', 'liquidacion')->find($empleado['id_empleadoFac']);
		$empleadoObj->id_proveedor  = $user['id_proveedor'];
		$empleadoObj->id_cliente  = $empleado['id_cliente'];
		$empleadoObj->id_catalogoRegimenContratacion  = isset($empleado['id_catalogoRegimenContratacion']) ? $empleado['id_catalogoRegimenContratacion'] : '';
		$empleadoObj->id_catalogoRiesgoPuesto  = isset($empleado['id_catalogoRiesgoPuesto']) ? $empleado['id_catalogoRiesgoPuesto'] : '';
		$empleadoObj->noEmpleado  = isset($empleado['noEmpleado']) ? $empleado['noEmpleado'] : '';
		$empleadoObj->curp  = isset($empleado['curp']) ? $empleado['curp'] : '';
		$empleadoObj->nss  = isset($empleado['nss']) ? $empleado['nss'] : '';
		$empleadoObj->departamento  = isset($empleado['departamento']) ? $empleado['departamento'] : '';
		$empleadoObj->id_catalogoBancos  = isset($empleado['id_catalogoBancos']) ? $empleado['id_catalogoBancos'] : NULL;
		$empleadoObj->puesto  = isset($empleado['puesto']) ? $empleado['puesto'] : '';
		$empleadoObj->tipoJornada  = isset($empleado['tipoJornada']) ? $empleado['tipoJornada'] : '';
		$empleadoObj->periodicidadPago  = isset($empleado['periodicidadPago']) ? $empleado['periodicidadPago'] : '';
		$empleadoObj->salarioBase  = isset($empleado['salarioBase']) ?
            (($empleado['salarioBase'] == '') ? 0 : $empleado['salarioBase']) : '';
		$empleadoObj->salarioDiarioIntegrado  =
            isset($empleado['salarioDiarioIntegrado']) ?
                (($empleado['salarioDiarioIntegrado'] == '') ? 0 : $empleado['salarioDiarioIntegrado']) : '';
		$empleadoObj->fechaInicioRelLaboral  = isset($empleado['fechaInicioRelLaboral']) ? ($empleado['fechaInicioRelLaboral'] == '0000-00-00' ? null : $empleado['fechaInicioRelLaboral']) : null;
		$empleadoObj->tipoContrato  = isset($empleado['tipoContrato']) ? $empleado['tipoContrato'] : '';
		$empleadoObj->noDiasPagados  = isset($empleado['noDiasPagados']) ? $empleado['noDiasPagados'] : '';
		$empleadoObj->ClaveEntFed  = isset($empleado['ClaveEntFed']) ? $empleado['ClaveEntFed'] : '';
		$empleadoObj->status  = 1;
		$empleadoObj->save();

        $clienteObj = $empleadoObj->cliente;
        $clienteObj->regimenFiscalReceptor = $empleado['regimenFiscalReceptor'];
        $clienteObj->save();

        if(is_object($empleadoObj->cliente->domicilio)){
            $domicilioObj = $empleadoObj->cliente->domicilio;
            $domicilioObj->codigoPostal = $empleado['cp'];
            $domicilioObj->save();
        }else{
            $domicilioObj = new DomFiscalRcp();
            $domicilioObj->id_cliente = $empleadoObj->cliente->id_cliente;
            $domicilioObj->codigoPostal = $empleado['cp'];
            $domicilioObj->save();
        }

        if(!is_object($empleadoObj->cliente->contacto)){
            $contactoObj = new ContactoReceptor();
            $contactoObj->id_cliente = $clienteObj->id_cliente;
        }else{
            $contactoObj = $empleadoObj->cliente->contacto;
        }
        $contactoObj->email = isset($empleado['email']) ? trim($empleado['email']) : '';
        $contactoObj->save();


        if($empleado['isLiquidacion']){

            $liquidacionObj = null;
            if(is_object($empleadoObj->liquidacion)){
                $liquidacionObj = $empleadoObj->liquidacion;
            }else{
                $liquidacionObj = new LiquidacionFac();
                $liquidacionObj->id_empleadoFac = $empleadoObj->id_empleadoFac;
            }

            $liquidacionObj->totalPagado = isset($empleado['liquidacion']['totalPagado']) ? $empleado['liquidacion']['totalPagado'] : 0;
            $liquidacionObj->ultimoSueldoMensOrd = isset($empleado['liquidacion']['ultimoSueldoMensOrd']) ? $empleado['liquidacion']['ultimoSueldoMensOrd'] : 0;
            $liquidacionObj->numAniosServicio = isset($empleado['liquidacion']['numAniosServicio']) ? $empleado['liquidacion']['numAniosServicio'] : 0;
            $liquidacionObj->ingresoAcumulable = isset($empleado['liquidacion']['ingresoAcumulable']) ? $empleado['liquidacion']['ingresoAcumulable'] : 0;
            $liquidacionObj->ingresoNoAcumulable = isset($empleado['liquidacion']['ingresoNoAcumulable']) ? $empleado['liquidacion']['ingresoNoAcumulable'] : 0;
            $liquidacionObj->save();

        }else{
            if(is_object($empleadoObj->liquidacion) && is_object($empleadoObj->liquidacion))
                $empleadoObj->liquidacion->delete();
        }


		$empleadoObj = EmpleadoFac::with('cliente.domicilio', 'cliente.contacto', 'percepciones.tipopd', 'deducciones.tipopd', 'liquidacion')->find($empleadoObj->id_empleadoFac);

        $empleadoObj->regimenFiscalReceptor = $empleadoObj->cliente->regimenFiscalReceptor;
        if(is_object($empleadoObj->cliente->domicilio)){
            $empleadoObj->cp = $empleadoObj->cliente->domicilio->codigoPostal;
        }
        if(is_object($empleadoObj->cliente->contacto)){
            $empleadoObj->email = $empleadoObj->cliente->contacto->email;
        }
		$empleadoObj = $empleadoObj->toArray();

		return Response::json ( array (
				'success' => true,
				'empleado' => $empleadoObj
		));

	}

	public function datosNomina(Request $request){

		$user = $request->input('user');

		$datosNomina = AdicionalNomina::find($user['id_proveedor']);
		if(is_object($datosNomina)){
			$datosNomina = $datosNomina->toArray();
		}else{
			$datosNomina = new AdicionalNomina();
			$datosNomina->id_proveedor = $user['id_proveedor'];
			$datosNomina->serie = 'A';
			$datosNomina->metodoPago = '';
			$datosNomina->registroPatronal = '';
			$datosNomina->status = 1;
			$datosNomina->save();

			$datosNomina = $datosNomina->toArray();
		}


		$series = Serie::where('id_proveedor', '=', $user['id_proveedor'])->where('status', '=', 1)->get();
		if(is_object($series) && count($series) > 0)
			$series = $series->toArray();

		$formasPago = FormaPago::where('status', '=', 1)->get();

		return Response::json ( array (
				'success' => true,
				'datosNomina' => $datosNomina,
				'series' => $series,
				'formasPago' => $formasPago->toArray()
		));
	}


	public function guardarDatosNomina(Request $request){

		$user = $request->input('user');
		$datosNomina = $request->input('datosNomina');

		$datosNominaObj = AdicionalNomina::find($user['id_proveedor']);
		$datosNominaObj->registroPatronal = $datosNomina['registroPatronal'];
		$datosNominaObj->metodoPago = $datosNomina['metodoPago'];
		$datosNominaObj->serie = $datosNomina['serie'];
		$datosNominaObj->save();

		return Response::json ( array (
			'success' => true
		));
	}

	public function listaPeriodos(Request $request){

		$user = $request->input('user');

		$periodosNomina = PeriodoNomina::with('empleados')->where('status', '=', 1)->where('id_proveedor', '=', $user['id_proveedor'])->get();
		if(count($periodosNomina) > 0){

			foreach ($periodosNomina as $periodo){
				$noTimbrados = 0;
				$periodo->statusTimbrado = 0;
				$noEmpleadosPeriodo = count($periodo->empleados);
				if($noEmpleadosPeriodo > 0)
				foreach ($periodo->empleados as $empleado){
					if($empleado->id_factura > 0){
						$noTimbrados++;
					}
				}

				if($noEmpleadosPeriodo == $noTimbrados){
					$periodo->statusTimbrado = 2;
				}else if($noTimbrados > 0){
					$periodo->statusTimbrado = 1;
				}

			}

			$periodosNomina = $periodosNomina->toArray();
		}


		return Response::json ( array (
			'success' => true,
			'periodos' => $periodosNomina
		));

	}

	public function obtenerPeriodo(Request $request){

		$user = $request->input('user');
		$id_periodo = $request->input('id_periodo');


		$formasPago = FormaPago::where('status', '=', 1)->get();
		$datosNominaObj = AdicionalNomina::find($user['id_proveedor']);
		$periodo = '';
		$listaEmpleados = [];

		if($id_periodo > 0){

			$periodo = PeriodoNomina::with('empleados.empleado.cliente', 'empleados.percepciones.tipopd', 'empleados.deducciones.tipopd')->find($id_periodo);
            $periodo->totalNomina = 0;

			$orderedEmpleadosList = [];

				if(count($periodo->empleados) > 0)
				foreach($periodo->empleados as $empleado){

					if(isset($empleado->empleado->cliente) && is_object($empleado->empleado->cliente)){

					$totalPercepcionGravado = 0;
					$totalPercepcionExcento = 0;

					$totalDeduccionGravado = 0;
					$totalDeduccionExcento = 0;


					if(count($empleado->percepciones) > 0)
					foreach ($empleado->percepciones as $percepcion){
						$totalPercepcionExcento += $percepcion->importeExcento;
						$totalPercepcionGravado += $percepcion->importeGravado;
					}

					if(count($empleado->deducciones) > 0)
						foreach ($empleado->deducciones as $deduccion){
							$totalDeduccionExcento += $deduccion->importeExcento;
							$totalDeduccionGravado += $deduccion->importeGravado;
					}

					$empleado->totalAPercibir = ($totalPercepcionGravado + $totalPercepcionExcento) - ($totalDeduccionExcento + $totalDeduccionGravado);
                        $periodo->totalNomina += $empleado->totalAPercibir;

					$orderedEmpleadosList [] = $empleado;
				}

			}

			$periodo->empleados2 = $orderedEmpleadosList;

			$periodo = $periodo->toArray();
		}else{

			$empleados = Empleado::with(['cliente' => function ($query)  {
                $query->orderBy('nmbRecep', 'desc');
            }])->where('status', '=', 1)->where('id_proveedor', '=', $user['id_proveedor'])->orderBy('curp')->get();
			if(is_object($empleados)){

				foreach ($empleados as $empleado){
					if(is_object($empleado->cliente)){
						$empleado->addNew = true;
						$listaEmpleados [] = $empleado->toArray();
					}
				}
			}

		}

		return Response::json ( array (
			'success' => true,
			'periodo' => $periodo,
			'formasPago' => $formasPago->toArray(),
			'datosNomina' => $datosNominaObj->toArray(),
			'listaEmpleados' => $listaEmpleados
		));

	}

	public function obtenerEmpleadosNoEnPeriodo(Request $request){

		$user = $request->input('user');
		$id_periodo = $request->input('id_periodo');

		$empleadosFac = EmpleadoFac::where('id_periodoNomina', '=', $id_periodo)->where('status', '=', 1)->get();

		$id_empleados = [];
		if(count($empleadosFac) > 0)
		foreach ($empleadosFac as $empleadoFac){
			$id_empleados[] = $empleadoFac->id_empleado;
		}


		$listadoEmpleados =[];
		$empleados = Empleado::with('cliente')->where('status', '=', 1)->where('id_proveedor', '=', $user['id_proveedor'])->whereNotIn('id_empleado', $id_empleados)->orderBy('curp')->get();
		if(is_object($empleados) && count($empleados) > 0){
			foreach ($empleados as $empleado){
				if(is_object($empleado->cliente)){
					$listadoEmpleados[] = $empleado->toArray();
				}
			}
		}

		return Response::json ( array (
			'success' => true,
			'empleados' => $listadoEmpleados,
				'id_empleados' => $id_empleados
		));

	}



	public function agregarEmpleadosPeriodo(Request $request){

		$user = $request->input('user');
		$id_periodo = $request->input('id_periodo');
		$empleados = $request->input('empleados');
		$countEmpleado = 0;

		if(count($empleados) > 0)
		foreach ($empleados as $empleado){
			if(isset($empleado['addNew']) && $empleado['addNew'] == true){


				$empleadoFac = EmpleadoFac::where('id_empleado', '=', $empleado['id_empleado'])->where('id_periodoNomina', '=', $id_periodo)->first();

				if ( !is_object($empleadoFac)) {

					$empleadoFac = new EmpleadoFac();
					$empleadoFac->status = 1;

				}

				$empleadoFac->id_proveedor = $user['id_proveedor'];
				$empleadoFac->id_cliente = $empleado['id_cliente'];
				$empleadoFac->id_periodoNomina = $id_periodo;
				$empleadoFac->id_empleado = $empleado['id_empleado'];
				$empleadoFac->curp = $empleado['curp'];
				$empleadoFac->departamento = $empleado['departamento'];
				$empleadoFac->fechaInicioRelLaboral = ($empleado['fechaInicioRelLaboral'] == '0000-00-00') ? null : $empleado['fechaInicioRelLaboral'];
				$empleadoFac->id_catalogoBancos = $empleado['id_catalogoBancos'];
				$empleadoFac->id_catalogoRegimenContratacion = $empleado['id_catalogoRegimenContratacion'];
				$empleadoFac->id_catalogoRiesgoPuesto = $empleado['id_catalogoRiesgoPuesto'];
				$empleadoFac->noDiasPagados = $empleado['noDiasPagados'];
				$empleadoFac->noEmpleado = $empleado['noEmpleado'];
				$empleadoFac->nss = $empleado['nss'];
				$empleadoFac->periodicidadPago = $empleado['periodicidadPago'];
				$empleadoFac->puesto = $empleado['puesto'];
				$empleadoFac->salarioBase = $empleado['salarioBase'];
				$empleadoFac->salarioDiarioIntegrado = $empleado['salarioDiarioIntegrado'];
				$empleadoFac->status = 1;
				$empleadoFac->tipoContrato = $empleado['tipoContrato'];
				$empleadoFac->tipoJornada = $empleado['tipoJornada'];
				$empleadoFac->save();

				PercepcionDeduccionFac::where('id_empleadoFac', '=', $empleadoFac->id_empleadoFac)->delete();


				$percepcionDeducciones = PercepcionDeduccion::where('id_empleado', '=', $empleado['id_empleado'])->where('status', '=', 1)->get();


				if (count ( $percepcionDeducciones ) > 0)
				foreach ( $percepcionDeducciones as $percepcionDeduccion ) {

					$percepcionDeduccionFac = new PercepcionDeduccionFac ();
					$percepcionDeduccionFac->id_empleadoFac = $empleadoFac->id_empleadoFac;
					$percepcionDeduccionFac->id_tipoPercepcionDeduccion = $percepcionDeduccion->id_tipoPercepcionDeduccion;
					$percepcionDeduccionFac->importeExcento = $percepcionDeduccion->importeExcento;
					$percepcionDeduccionFac->importeGravado = $percepcionDeduccion->importeGravado;
					$percepcionDeduccionFac->tipo = $percepcionDeduccion->tipo;
					$percepcionDeduccionFac->noDiasHoras = $percepcionDeduccion->noDiasHoras;
					$percepcionDeduccionFac->tipoHoras = $percepcionDeduccion->tipoHoras;
					$percepcionDeduccionFac->noHoras = $percepcionDeduccion->noHoras;
					$percepcionDeduccionFac->importeHoras = $percepcionDeduccion->importeHoras;
					$percepcionDeduccionFac->status = 1;
					$percepcionDeduccionFac->save();
				}


				$countEmpleado++;
			}
		}

		return Response::json ( array (
				'success' => true,
				'noEmpleados' => $countEmpleado,
				'empleadoFac' => $empleadoFac->toArray()
		));

	}

	public function eliminarEmpleadoPeriodo(Request $request){

		$id_empleadoFac = $request->input('id_empleadoFac');

 		PercepcionDeduccionFac::where('id_empleadoFac', '=', $id_empleadoFac)->delete();
 		EmpleadoFac::where('id_empleadoFac', '=', $id_empleadoFac)->delete();

		return Response::json ( array (
			'success' => true
		));
	}


	public function guardarPeriodo(Request $request){

		$periodo = $request->input('periodo');
		$user = $request->input('user');

		$periodoObj = new PeriodoNomina();

		$addEmpleados = true;

		if(isset($periodo['id_periodoNomina']) && $periodo['id_periodoNomina'] > 0){
			$periodoObj = PeriodoNomina::find($periodo['id_periodoNomina']);
			$addEmpleados = false;
		}

		$periodoObj->id_proveedor = $user['id_proveedor'];
		$periodoObj->nombre = $periodo['nombre'];
		$periodoObj->fechaInicio = $periodo['fechaInicio'];
		$periodoObj->fechaFin = $periodo['fechaFin'];
		$periodoObj->metodoPago = $periodo['metodoPago'];
		$periodoObj->fechaPago = $periodo['fechaPago'];
		$periodoObj->lugarExpedicion = $periodo['lugarExpedicion'];
		$periodoObj->TipoNomina = $periodo['TipoNomina'];
		$periodoObj->version = '1.2';
		$periodoObj->status = 1;
		$periodoObj->save();

		$countEmpleados = 0;
		if($addEmpleados){

			if(count($periodo['empleadosN']) > 0)
			foreach ($periodo['empleadosN'] as $empleado){
				if($empleado['addNew']){



					$empleadoFac = new EmpleadoFac();
					$empleadoFac->status = 1;
					$empleadoFac->id_proveedor = $user['id_proveedor'];
					$empleadoFac->id_cliente = $empleado['id_cliente'];
					$empleadoFac->id_periodoNomina = $periodoObj->id_periodoNomina;
					$empleadoFac->id_empleado = $empleado['id_empleado'];
					$empleadoFac->curp = $empleado['curp'];
					$empleadoFac->departamento = $empleado['departamento'];
					$empleadoFac->fechaInicioRelLaboral = ($empleado['fechaInicioRelLaboral'] == '0000-00-00') ? null : $empleado['fechaInicioRelLaboral'];
					$empleadoFac->id_catalogoBancos = $empleado['id_catalogoBancos'];
					$empleadoFac->id_catalogoRegimenContratacion = $empleado['id_catalogoRegimenContratacion'];
					$empleadoFac->id_catalogoRiesgoPuesto = $empleado['id_catalogoRiesgoPuesto'];
					$empleadoFac->noDiasPagados = $empleado['noDiasPagados'];
					$empleadoFac->noEmpleado = $empleado['noEmpleado'];
					$empleadoFac->nss = $empleado['nss'];
					$empleadoFac->periodicidadPago = $empleado['periodicidadPago'];
					$empleadoFac->puesto = $empleado['puesto'];
					$empleadoFac->salarioBase = $empleado['salarioBase'];
					$empleadoFac->salarioDiarioIntegrado = $empleado['salarioDiarioIntegrado'];
					$empleadoFac->status = 1;
					$empleadoFac->tipoContrato = $empleado['tipoContrato'];
					$empleadoFac->tipoJornada = $empleado['tipoJornada'];
					$empleadoFac->ClaveEntFed = $empleado['ClaveEntFed'];
					$empleadoFac->save();


					$percepcionDeducciones = PercepcionDeduccion::where('id_empleado', '=', $empleado['id_empleado'])->where('status', '=', 1)->get();

					if (count ( $percepcionDeducciones ) > 0)
						foreach ( $percepcionDeducciones as $percepcionDeduccion ) {

							$percepcionDeduccionFac = new PercepcionDeduccionFac ();
							$percepcionDeduccionFac->id_empleadoFac = $empleadoFac->id_empleadoFac;
							$percepcionDeduccionFac->id_tipoPercepcionDeduccion = $percepcionDeduccion->id_tipoPercepcionDeduccion;
							$percepcionDeduccionFac->importeExcento = $percepcionDeduccion->importeExcento;
							$percepcionDeduccionFac->importeGravado = $percepcionDeduccion->importeGravado;
							$percepcionDeduccionFac->tipo = $percepcionDeduccion->tipo;
							$percepcionDeduccionFac->noDiasHoras = $percepcionDeduccion->noDiasHoras;
							$percepcionDeduccionFac->tipoHoras = $percepcionDeduccion->tipoHoras;
							$percepcionDeduccionFac->noHoras = $percepcionDeduccion->noHoras;
							$percepcionDeduccionFac->importeHoras = $percepcionDeduccion->importeHoras;
							$percepcionDeduccionFac->status = 1;
							$percepcionDeduccionFac->save();
						}


					$countEmpleados++;
				}
			}
		}


		return Response::json ( array (
			'success' => true,
			'id_periodo' => $periodoObj->id_periodoNomina
		));

	}

	public function timbrarNomina(Request $request){

		ini_set('default_socket_timeout', 300);
		ini_set('max_execution_time', 300);
		set_time_limit(300);

		$id_empleadoFac = $request->input('id_empleadoFac');
		$id_periodo = $request->input('id_periodo');
		$user = $request->input('user');

		$periodo = PeriodoNomina::find($id_periodo);
		$empleado = EmpleadoFac::with('empleado.cliente', 'percepciones.tipopd', 'deducciones.tipopd')->find($id_empleadoFac);
		$proveedor = Proveedor::find($user['id_proveedor']);
		$adicionalNomina = AdicionalNomina::find($user['id_proveedor']);

		$cliente = $empleado->empleado->cliente;

		$curp = '';
		if(is_object($proveedor->domicilio)){
			$domicilio = $proveedor->domicilio;
			$curp = $domicilio->curp;

		}

		$rfcHoraAntes = array(17, 592, 732);
		$textLess = '-2 minutes';
		if(in_array($user['id_proveedor'], $rfcHoraAntes))
			$textLess = '-24 hours';

		$timeStamp = date("Y-m-d H:i:s" , strtotime($textLess));
		$noFactura = DB::select("SELECT MAX(noFactura) as noFactura FROM Factura f JOIN IdDoc i ON f.id_factura = i.id_factura WHERE id_proveedor = " . $user['id_proveedor'] . " AND i.serie = '" . $adicionalNomina->serie ."'")[0];
		$noFactura->noFactura++;
		$certificadoHaUsar = CertificadoProveedor::where('id_proveedor', '=', $user['id_proveedor'])->where('status', '=', 1)->first();


		$totalDeduccion = 0;
		$totalImpuestosRetenidos = 0;
		$totalOtrasDeducciones = 0;

		$totalPercepcionGravado = 0;
		$totalPercepcionExcento = 0;
		$totalPercepciones = 0;
		$totalOtrosPagos = 0;
		$totalSueldos = 0;
		$totalSeparacionIndemnizacion = 0;
		$totalJubilacionPension = 0;

		$listadoPercepciones = [];
		$listadoDeducciones = [];
		$listadoOtrosPagos = [];
		$listadoIncapacidades = [];

		if(count($empleado->percepciones) > 0)
			foreach ($empleado->percepciones as $percepcion){

				if($percepcion->tipopd->subTipo == 1){

					$totalPercepcionExcento += $percepcion->importeExcento;
					$totalPercepcionGravado += $percepcion->importeGravado;

					if($percepcion->tipopd->clave == '022' || $percepcion->tipopd->clave == '023' ||
							$percepcion->tipopd->clave == '025'){
						$totalSeparacionIndemnizacion += $percepcion->importeExcento + $percepcion->importeGravado;
					}else if( $percepcion->tipopd->clave == '039' || $percepcion->tipopd->clave == '044'){
						$totalJubilacionPension += $percepcion->importeExcento + $percepcion->importeGravado;
					}else{
						$totalSueldos += $percepcion->importeExcento + $percepcion->importeGravado;
					}

					$listadoPercepciones[] = array('TipoPercepcion' => $percepcion->tipopd->clave, 'Clave' => $percepcion->tipopd->clave,
							'Concepto' => $percepcion->tipopd->descripcion, 'ImporteGravado' => Utils::formatNumber($percepcion->importeGravado),
							'ImporteExento' => Utils::formatNumber($percepcion->importeExcento), 'Dias' => $percepcion->noDiasHoras,
							'TipoHoras' => $percepcion->tipoHoras, 'HorasExtra' => $percepcion->noHoras, 'ImportePagado' => Utils::formatNumber($percepcion->importeExcento + $percepcion->importeGravado)
					);

				}else{

					$totalOtrosPagos += $percepcion->importeExcento + $percepcion->importeGravado;

					$listadoOtrosPagos[] = array('TipoOtroPago' => $percepcion->tipopd->clave, 'Clave' => $percepcion->tipopd->clave,
							'Concepto' => $percepcion->tipopd->descripcion, 'Importe' => Utils::formatNumber($percepcion->importeGravado + $percepcion->importeExcento));

				}
		}

		if(count($empleado->deducciones) > 0)
			foreach ($empleado->deducciones as $deduccion){

				if($deduccion->id_tipoPercepcionDeduccion == 34){
					//Incapacidades
					$listadoIncapacidades[] = array('DiasIncapacidad' => $deduccion->noDiasHoras, 'TipoIncapacidad' => $deduccion->tipoHoras,
							'ImporteMonetario' => Utils::formatNumber($deduccion->importeExcento + $deduccion->importeGravado));

				}

				$totalDeduccion += $deduccion->importeExcento + $deduccion->importeGravado;

				if($deduccion->tipopd->clave == '002'){
					$totalImpuestosRetenidos += $deduccion->importeExcento + $deduccion->importeGravado;
				}else{
					$totalOtrasDeducciones += $deduccion->importeExcento + $deduccion->importeGravado;
				}

				$listadoDeducciones[] = array('TipoDeduccion' => $deduccion->tipopd->clave, 'Clave' => $deduccion->tipopd->clave,
						'Concepto' => $deduccion->tipopd->descripcion, 'Importe' => Utils::formatNumber($deduccion->importeExcento + $deduccion->importeGravado));

		}

		$totalPercepciones = Utils::formatNumber($totalPercepcionGravado + $totalPercepcionExcento);
		$subTotal = $empleado->totalPercepciones =  Utils::formatNumber($totalPercepciones + $totalOtrosPagos);
		$empleado->totalAPercibir = $subTotal - $totalDeduccion;



		$datosFactura = new \stdClass();
		$datosFactura->timeStamp = $timeStamp;
		$datosFactura->tipoDeComprobante = 'N';
		$datosFactura->serie = $adicionalNomina->serie;
		$datosFactura->folio = $noFactura->noFactura;
		$datosFactura->noCertificado = $certificadoHaUsar->noCertificado;
		$datosFactura->certificado = $certificadoHaUsar->certificado;
		$datosFactura->mntBase = $subTotal;
		$datosFactura->subtotal = $subTotal;
		$datosFactura->moneda = 'MXN';
		$datosFactura->total = $empleado->totalAPercibir;
		$datosFactura->formaPago = '99';
		$datosFactura->condicionesDePago = '';
		$datosFactura->descuento = $totalDeduccion;
		$datosFactura->precission = 2;
		$datosFactura->tipoCambio = 1;
		$datosFactura->lugarExpedicion = $periodo->lugarExpedicion;
		$datosFactura->usoCFDI = 'G03';
		$datosFactura->metodoDePago = 'PUE';
		$datosFactura->condicionesDePago = '';
		$datosFactura->tipoFacturasRelacionadas = '';
		$datosFactura->rFCEmisor = $proveedor->rFCEmisor;
		$datosFactura->nmbEmisor = $proveedor->nmbEmisor;
		$datosFactura->rFCRecep = $empleado->empleado->cliente->rFCRecep;
		$datosFactura->nmbRecep = $empleado->empleado->cliente->nmbRecep;
		$datosFactura->regimenFiscal = $proveedor->regimenFiscal33;
		$datosFactura->numRegIdTrib = '';
		$datosFactura->pais = '';
		$datosFactura->curp = $curp;
		$datosFactura->tipoPersona = $proveedor->tipoPersona;


		$datosFactura->facturasRelacionadas = [];
		$datosFactura->conceptos = [ ];
		$datosFactura->impuestosTrasladados = [ ];
		$datosFactura->impuestosRetenidos = [ ];
		$datosFactura->impuestosTrasladadosLcl = [ ];
		$datosFactura->impuestosTrasladadosLclTotal = 0;
		$datosFactura->impuestosRetenidosLcl = [ ];
		$datosFactura->impuestosRetenidosLclTotal = 0;

		$totalImpRetenidos = 0;
		$totalImpTrasladados = 0;


		$detalle =  array('clave' => '84111505', 'codigo' => '', 'nombre' => 'Pago de nómina', 'unidad' => 'ACT', 'qty' => 1, 'precioU' => $subTotal, 'descuento' => $totalDeduccion);
		$factura['detalles'] = [];
		$factura['detalles'][] = $detalle;

		foreach ($factura['detalles'] as $detalle){

			$concepto = new \stdClass();
			$concepto->clave = $detalle['clave'];
			$concepto->cdgItem = Utils::deleteExtraSpaces($detalle['codigo']);
			$concepto->dscItem = Utils::deleteExtraSpaces($detalle['nombre']);
			$concepto->unmdItem = (isset($detalle['unidad']))? $detalle['unidad'] : '';
			$concepto->qtyItem = $detalle['qty'];
			$concepto->montoNetoItem = $detalle['precioU'];
			$concepto->prcNetoItem = $detalle['qty'] * $detalle['precioU'];
			$concepto->descuento = $detalle['descuento'];

			$concepto->impuestosTrasladados = [];
			$concepto->impuestosRetenidos = [];
			$datosFactura->conceptos[] = $concepto;
		}


		$nomina = array(
				'Version' => '1.2',
				'FechaPago' => $periodo->fechaPago,
				'FechaInicialPago' => $periodo->fechaInicio,
				'FechaFinalPago' => $periodo->fechaFin,
				'NumDiasPagados' => $empleado->noDiasPagados,
				'TipoNomina' => $periodo->TipoNomina,
				'TotalDeducciones' => Utils::formatNumber($totalDeduccion),
				'TotalOtrosPagos' => Utils::formatNumber($totalOtrosPagos),
				'TotalPercepciones' => $totalPercepciones,
				'Emisor' => array('RegistroPatronal' => $adicionalNomina->registroPatronal),
				'Percepciones' => array(
					'totalPercepcion' => Utils::formatNumber($totalPercepcionGravado + $totalPercepcionExcento),
					'totalPercepcionGravado' => $totalPercepcionGravado,
					'totalPercepcionExcento' => $totalPercepcionExcento,
					'totalSueldos' => $totalSueldos,
					'totalSeparacionIndemnizacion' => $totalSeparacionIndemnizacion,
					'totalJubilacionPension' => $totalJubilacionPension,
					'listadoPercepciones' => $listadoPercepciones),
				'Deducciones' => array(
						'totalDeduccion' => $totalDeduccion,
						'totalImpuestosRetenidos' => $totalImpuestosRetenidos,
						'totalOtrasDeducciones' => $totalOtrasDeducciones,
						'listadoDeducciones' => $listadoDeducciones
				),
				'OtrosPagos' => array('listadoOtrosPagos' => $listadoOtrosPagos),
				'Incapacidades' => array('listadoIncapacidades' => $listadoIncapacidades)
		);

		$receptorN = [];

		if(!empty($empleado->curp))
			$receptorN['Curp'] = trim($empleado->curp);

		if(!empty($empleado->tipoContrato))
			$receptorN['TipoContrato'] = trim($empleado->tipoContrato);

		if(!empty($empleado->id_catalogoRegimenContratacion)){
			$rg = CatalogoRegimenContratacion::find($empleado->id_catalogoRegimenContratacion);
			$receptorN['TipoRegimen'] = trim($rg->clave);
		}

		if(!empty($empleado->noEmpleado))
			$receptorN['NumEmpleado'] = trim($empleado->noEmpleado);

		if(!empty($empleado->periodicidadPago))
			$receptorN['PeriodicidadPago'] = trim($empleado->periodicidadPago);

		if(!empty($empleado->ClaveEntFed))
			$receptorN['ClaveEntFed'] = trim($empleado->ClaveEntFed);

		if(!empty($empleado->nss))
			$receptorN['NumSeguridadSocial'] = preg_replace('/\D/', '', trim($empleado->nss));

		if(!empty($empleado->fechaInicioRelLaboral) && $empleado->fechaInicioRelLaboral != '0000-00-00')
			$receptorN['FechaInicioRelLaboral'] = trim($empleado->fechaInicioRelLaboral);

		$datetime1 = new \DateTime($empleado->fechaInicioRelLaboral);
		$datetime2 = new \DateTime($periodo->fechaFin);
		$interval = $datetime1->diff($datetime2);
		$antiguedad = $interval->format('%R%a días');
		$antiguedad = str_replace('+', '', $antiguedad);
		$antiguedad = $antiguedad / 7;
		$antiguedad = floor($antiguedad);

		if($empleado->fechaInicioRelLaboral != '0000-00-00')
			$receptorN['Antigüedad'] = "P".$antiguedad."W";

		if(!empty($empleado->puesto))
			$receptorN['Puesto'] = trim($empleado->puesto);

		if(!empty($empleado->salarioBase))
			$receptorN['SalarioBaseCotApor'] = Utils::formatNumber($empleado->salarioBase);

		if(!empty($empleado->salarioDiarioIntegrado))
			$receptorN['SalarioDiarioIntegrado'] = Utils::formatNumber($empleado->salarioDiarioIntegrado);

		if(!empty($empleado->id_catalogoRiesgoPuesto)){
			$rg = CatalogoRiesgoPuesto::find($empleado->id_catalogoRiesgoPuesto);
			$receptorN['RiesgoPuesto'] = trim($rg->clave);
		}

		$nomina['Receptor'] = $receptorN;

		$datosFactura->nomina = $nomina;

		$xml = XMLUtils::createXML33($datosFactura, $proveedor);

		$sello = $xml->query('//cfdi:Comprobante')[0]->getAttribute('Sello');

		$nombreArchivo = "$proveedor->rFCEmisor-" .date('YmdHis');

		file_put_contents("tmp/$nombreArchivo.xml", $xml);

		$base64Comprobante = base64_encode($xml);

		$urlTimbrado = "https://timbracfdi33.mx:1443/Timbrado.asmx?wsdl";
		$usuarioIntegrador = "vb9+kzunCtCXL+WQEvBsCQ==";

		if($proveedor->id_proveedor == 17){

			$urlTimbrado = "https://cfdi33-pruebas.buzoncfdi.mx:1443/Timbrado.asmx?wsdl";
			$usuarioIntegrador = "mvpNUXmQfK8=";

		}

		$params = array();
		$params['usuarioIntegrador'] = $usuarioIntegrador;
		$params['xmlComprobanteBase64'] = $base64Comprobante;
		$params['idComprobante'] = rand(5, 999999);


		$client = new SoapClient($urlTimbrado, array('encoding'=>'UTF-8', "connection_timeout" => 300));
		$client->soap_defencoding = "UTF-8";
		$result = $client->__soapCall ( 'TimbraCFDI',array('parameters' => $params) );

	$resultado = $result->TimbraCFDIResult->anyType;


		$logToSave = print_r($resultado, true);

		$log = env('DIR_LOGS')."/" . date ( "Y-m-d" ) . ".log";
		$fp = fopen ( $log, "a" );
		fwrite ( $fp, "\n\n===".date("Y-m-d:H:i:s"). "\n\n" );
		fwrite ( $fp, "\n\n$nombreArchivo\n\n" );
		fwrite ( $fp, $logToSave );
		fwrite ( $fp, "\n\n===" );
		fclose ( $fp );

		$success = false;
		$errorCode = 0;
		$errortext = '';
		$facturaResult = '';

		if($resultado[1] == '0'){
			$success = true;


			$xmlTimbrado = new \DOMDocument("1.0", "uft-8");
			$xmlTimbrado->loadXML($resultado[3]);

			$idDoc = new IdDoc();

			$timbreFiscal = $xmlTimbrado->getElementsByTagName ( 'TimbreFiscalDigital' );

			foreach ( $timbreFiscal as $timbreFiscal ) {

				$fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );
				$fechaTimbradoArray = explode(".",$fechaTimbrado);

				$idDoc->version = $timbreFiscal->getAttribute ( 'Version' );
				$idDoc->fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );
				$idDoc->selloCFD = $timbreFiscal->getAttribute ( 'SelloCFD' );
				$idDoc->noCertificadoSAT = $timbreFiscal->getAttribute ( 'NoCertificadoSAT' );
				$idDoc->selloSAT = $timbreFiscal->getAttribute ( 'SelloSAT' );
				$idDoc->uUID = $timbreFiscal->getAttribute ( 'UUID' );
				$idDoc->sello = $sello;
				$idDoc->rfcProvCertif = $timbreFiscal->getAttribute ( 'RfcProvCertif' );
			}


			$facturaObj = new Factura();
			$facturaObj->id_proveedor = $user['id_proveedor'];
			$facturaObj->id_cliente = $empleado->id_cliente;
			$facturaObj->id_certificadoProveedor = $certificadoHaUsar->id;
			$facturaObj->nmbEmisor = $proveedor->nmbEmisor;
			$facturaObj->rFCEmisor = $proveedor->rFCEmisor;
			$facturaObj->nmbRecep = $datosFactura->nmbRecep;
			$facturaObj->rFCRecep = $datosFactura->rFCRecep;
			$facturaObj->regimenFiscal = $proveedor->regimenFiscal33;
			$facturaObj->timeStamp = $timeStamp;
			$facturaObj->noFactura = $noFactura->noFactura;
			$facturaObj->version = "3.3";
			$facturaObj->generadoPor = 3;
			$facturaObj->nota = '';
			$facturaObj->tipoDeComprobante = 'N';
			$facturaObj->precission = 2;
			$facturaObj->status = 1;
			$facturaObj->isPagado = 1;
			$facturaObj->numRegIdTrib = '';
			$facturaObj->pais = '';
			$facturaObj->save();

			$empleado = EmpleadoFac::find($id_empleadoFac);
			$empleado->id_factura = $facturaObj->id_factura;
			$empleado->registroPatronal = $adicionalNomina->registroPatronal;
			$empleado->save();


			$idDoc->id_factura = $facturaObj->id_factura;
			$idDoc->serie = $datosFactura->serie;
			$idDoc->folio = $noFactura->noFactura;
			$idDoc->formaPago = $datosFactura->formaPago;
			$idDoc->condicionesDePago = '';
			$idDoc->lugarExpedicion = $datosFactura->lugarExpedicion;
			$idDoc->usoCFDI = $datosFactura->usoCFDI;
			$idDoc->metodoDePago = $datosFactura->metodoDePago;
			$idDoc->sello = $sello;
			$idDoc->tipoFacturasRelacionadas = '';
			$idDoc->save();


			$totales = new Totales();
			$totales->id_factura = $facturaObj->id_factura;
			$totales->moneda = $datosFactura->moneda;
			$totales->tipoCambio = 1;
			$totales->subTotal = $datosFactura->subtotal;
			$totales->mntBase = $datosFactura->mntBase;
			$totales->vlrPagar = $datosFactura->total;
			$totales->descuento = $datosFactura->descuento;
			$totales->save();


			$detalles = array();

			foreach ($datosFactura->conceptos as $concepto){

				$conceptoObj = new Concepto();
				$conceptoObj->clave = $concepto->clave;
				$conceptoObj->cdgItem = $concepto->cdgItem;
				$conceptoObj->dscItem = $concepto->dscItem;
				$conceptoObj->unmdItem = $concepto->unmdItem;
				$conceptoObj->qtyItem = $concepto->qtyItem;
				$conceptoObj->montoNetoItem = $concepto->montoNetoItem;
				$conceptoObj->prcNetoItem = $concepto->prcNetoItem;
				$conceptoObj->descuento = $concepto->descuento;
				$conceptoObj->id_factura = $facturaObj->id_factura;
				$conceptoObj->save();

			}


			$facturaResult = $datosFactura->serie . $datosFactura->folio;


		}else{


			$errorCode = 10001;
			$errorMsg = 'Hubo un error al crear su factura. Vuelva a intentarlo.';

			if(isset($resultado[6])){

					$errorCode = $resultado[6];
					switch ($resultado[6]){
						case 330037:
							$errorMsg = "Este RFC del receptor no existe en la lista de RFC inscritos no cancelados del SAT. Puede que su cliente tenga algún bloqueo.";
							break;
						case 330007:
							$errorMsg = "Es necesario que agregue vaya a la sección de Mis Datos y actualice su régimen fiscal.";
							break;
						case 330171:
							$errorMsg = "Se debe seleccionar un Uso de CFDI para realizar la factura.";
							break;
						case 305:
							$errorMsg = "Su certificado de sellos digitales ha vencido, es necesario que genere uno nuevo en el portal del SAT.";
							break;
						default:
							$errorMsg = $resultado[7];
				}
			}

			$errortext = $errorMsg;
		}


		return Response::json ( array (
			'success' => true,
			'errorCode' => $errorCode,
			'errortext' => $errortext,
			'facturaResult' => $facturaResult,
		    'nombreArchivo' => $nombreArchivo
		));
	}


    public function uploadFile(Request $request){

        $id_proveedor = $request->input('id_proveedor');
        $rfc = $request->input('rfc');

        $excelFile = $request->file( 'file' );
        $ext = $excelFile->getClientOriginalExtension();
        $excelFileName = date('YmdHis') . ".$ext";

        $excelFile->move ( env('DIR_TMP') .'/',  $excelFileName);

        $spreadsheet = IOFactory::load(env('DIR_TMP') .'/'.  $excelFileName);

        $xls_data = $spreadsheet->getActiveSheet()->toArray(null, true, true, true);


        $error = 0;
        if($xls_data[1]['B'] == $rfc) {

            foreach ($xls_data as $key => $row) {

                //Saltar la primera fila
                if ($key == 1 || $row['A'] == 'P' || $row['A'] == 'D' || $row['A'] == 'FINAL_EMPLEADO' )
                    continue;

                if($row['A'] == 'FINAL_DOCUMENTO')
                    break;

                $clienteObj = Cliente::with('empleado')->where('rFCRecep', '=', $row['A'])
                    ->where('id_proveedor', '=', $id_proveedor)->first();

                if(!is_object($clienteObj)){
                    $clienteObj = new Cliente();
                    $clienteObj->id_proveedor = $id_proveedor;
                    $clienteObj->metodoPago = $row['AC'];
                    $clienteObj->rFCRecep = $row['A'];
                    $clienteObj->nmbRecep = $row['B'];
                    $clienteObj->status = 1;
                    $clienteObj->save();

                    $domFiscalRcpObj = new DomFiscalRcp();
                    $domFiscalRcpObj->id_cliente = $clienteObj->id_cliente;

                    $empleadoObj = new Empleado();
                    $empleadoObj->id_cliente = $clienteObj->id_cliente;


                }else{

                    $empleadoObj = $clienteObj->empleado;
                    if(!is_object($empleadoObj)){
                        $empleadoObj = new Empleado();
                        $empleadoObj->id_cliente = $clienteObj->id_cliente;
                    }

                    $domFiscalRcpObj = $clienteObj->domicilio;
                    if(!is_object($domFiscalRcpObj)){
                        $domFiscalRcpObj = new DomFiscalRcp();
                        $domFiscalRcpObj->id_cliente = $clienteObj->id_cliente;
                    }
                }

                $clienteObj->rFCRecep = $row['A'];
                $clienteObj->metodoPago = $row['AC'];
                $clienteObj->nmbRecep = $row['B'];
                $clienteObj->status = 1;
                $clienteObj->save();

                $domFiscalRcpObj->calle = $row['C'];;
                $domFiscalRcpObj->nroExterior = $row['D'];;
                $domFiscalRcpObj->nroInterior = $row['E'];;
                $domFiscalRcpObj->colonia = $row['F'];
                $domFiscalRcpObj->municipio = $row['G'];;
                $domFiscalRcpObj->localidad = $row['H'];
                $domFiscalRcpObj->estado = $row['I'];
                $domFiscalRcpObj->pais = $row['J'];
                $domFiscalRcpObj->codigoPostal = $row['K'];
                $domFiscalRcpObj->save();

                $empleadoObj->id_proveedor = $id_proveedor;
                $empleadoObj->noEmpleado = $row['N'];
                $empleadoObj->curp = $row['L'];
                $empleadoObj->departamento = $row['Q'];
                $empleadoObj->email = $row['M'];
                $empleadoObj->fechaInicioRelLaboral = $row['U'];
                $empleadoObj->noDiasPagados = $row['Z'];
                $empleadoObj->nss = $row['O'];
                $empleadoObj->periodicidadPago = $row['Y'];
                $empleadoObj->puesto = $row['P'];
                $empleadoObj->salarioBase = $row['W'];
                $empleadoObj->salarioDiarioIntegrado = $row['X'];
                $empleadoObj->tipoContrato = $row['S'];
                $empleadoObj->tipoJornada = $row['R'];
                $empleadoObj->ClaveEntFed = $row['AB'];
                $empleadoObj->status = 1;
                $empleadoObj->save();


            }

        }else{
            //no le pertenece al RFC
            $error = 1001;
        }



        return Response::json ( array (
            'success' => true,
            'fileName' => $excelFileName,
            'content' => $xls_data,
            'error' => $error
        ));

    }

}


