<?php

namespace App\Http\Controllers;

use App\Commands\Utils;
use App\Commands\XMLUtils;
use App\Models\AddendaFondoGarantia;
use App\Models\AlumnoDetalle;
use App\Models\Arrendamiento;
use App\Models\Autotransporte;
use App\Models\AutotransporteBase;
use App\Models\CartaPorte;
use App\Models\CatalogoRegimenContratacion;
use App\Models\CatalogoRiesgoPuesto;
use App\Models\CertificadoProveedor;
use App\Models\AdicionalNomina;
use App\Models\ClaveProdServ;
use App\Models\Cliente;
use App\Models\Concepto;
use App\Models\DoctoRelacionado;
use App\Models\DomFiscalRcp;
use App\Models\EmpleadoFac;
use App\Models\ExImpuestos;
use App\Models\Factura;
use App\Models\FacturasRelacionadas;
use App\Models\FigurasTransporte;
use App\Models\FigurasTransporteBase;
use App\Models\IdDoc;
use App\Models\ImpuestosDR;
use App\Models\Inbursa;
use App\Models\Ine;
use App\Models\InformacionGlobal;
use App\Models\LeyendaFiscal;
use App\Models\LiquidacionFac;
use App\Models\Mercancia;
use App\Models\MercanciaComercio;
use App\Models\Pago;
use App\Models\PeriodoNomina;
use App\Models\Producto;
use App\Models\Proveedor;
use App\Models\Remolque;
use App\Models\Totales;
use App\Models\TotalesP;
use App\Models\Ubicacion;
use App\Models\UbicacionBase;
use App\Models\UnidadMedida;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Response;
use SoapClient;
use App\Models\ComercioE;
use App\Models\DomFiscalFact;
use App\Models\DomFiscalRcpFact;

class FacturacionFinKokController extends BaseController {

    var $rfcHorasAntes = array (330, 951, 603, 713);

    /**
     * @throws \SoapFault
     */
    public function facturar(Request $request) {
		ini_set ( 'default_socket_timeout', 300 );
		ini_set ( 'max_execution_time', 300 );
		set_time_limit ( 300 );

		$factura = $request->input ( 'factura' );
		$user = $request->input ( 'user' );
		$proveedor = Proveedor::with('domicilio')->find ( $user ['id_proveedor'] );

        $textLess = '-125 minutes';
        if (in_array ( $user ['id_proveedor'], $this->rfcHorasAntes ))
            $textLess = '-70 hours';

		$timeStamp = date ( "Y-m-d H:i:s", strtotime ( $textLess ) );
		$noFactura = DB::select ( "SELECT MAX(noFactura) as noFactura FROM Factura f JOIN IdDoc i ON f.id_factura = i.id_factura WHERE id_proveedor = " . $user ['id_proveedor'] . " AND i.serie = '" . $factura ['serie'] . "'" ) [0];
		$noFactura->noFactura ++;
		$certificadoHaUsar = CertificadoProveedor::where ( 'id_proveedor', '=', $user ['id_proveedor'] )->where ( 'status', '=', 1 )->first ();

		if(!is_object($certificadoHaUsar)){
            return Response::json ( array (
                'success' => false,
                'errorCode' => 1009,
                'errortext' => "El certificado CSD no fue configurado de forma correcta",
                'facturaResult' => "El certificado CSD no fue configurado de forma correcta",
                'nombreArchivo' => ""
            ) );
        }

		$datosFactura = new \stdClass ();
		$datosFactura->timeStamp = $timeStamp;
		$datosFactura->tipoDeComprobante = $factura ['tipoDocumento'];
		$datosFactura->serie = $factura ['serie'];
		$datosFactura->folio = $noFactura->noFactura;
		$datosFactura->noCertificado = $certificadoHaUsar->noCertificado;
		$datosFactura->certificado = $certificadoHaUsar->certificado;
		$datosFactura->mntBase = $factura ['base'];
		$datosFactura->subtotal = $factura ['subtotal'];
		$datosFactura->moneda = $factura ['moneda'];
		$datosFactura->total = $factura ['total'];
		$datosFactura->formaPago = $factura ['formaPago'];
		$datosFactura->descuento = $factura ['descuento'];
		$datosFactura->precission = $factura ['decimales'];
		$datosFactura->tipoCambio = $factura ['tipoCambio'];
		$datosFactura->lugarExpedicion = Utils::deleteExtraSpaces ( $factura ['lugarExpedicion'] );
		$datosFactura->usoCFDI = $factura ['usoCFDI'];
		$datosFactura->metodoDePago = $factura ['metodoDePago'];
		$datosFactura->condicionesDePago = (isset ( $factura ['condicionesPago'] )) ? Utils::deleteExtraSpaces ( $factura ['condicionesPago'] ) : '';
		$datosFactura->cuentaPredial = (isset ( $factura ['cuentaPredial'] )) ? Utils::deleteExtraSpaces ( $factura ['cuentaPredial'] ) : '';
		$datosFactura->tipoFacturasRelacionadas = $factura ['facturasRelacionadas'] ['tipoRelacion'];
		$datosFactura->rFCEmisor = $proveedor->rFCEmisor;
		$datosFactura->nmbEmisor = $proveedor->nmbEmisor;
		$datosFactura->rFCRecep = $factura ['id_cliente'] ['rFCRecep'];
		$datosFactura->nmbRecep = $factura ['id_cliente'] ['nmbRecep'];
		$datosFactura->regimenFiscal = $proveedor->regimenFiscal33;
		$datosFactura->numRegIdTrib = isset ( $factura ['numRegIdTrib'] ) ? $factura ['numRegIdTrib'] : '';
		$datosFactura->pais = isset ( $factura ['pais'] ) ? $factura ['pais'] : '';
		$datosFactura->tipoPersona = $proveedor->tipoPersona;

		$datosFactura->conceptos = [ ];
		$datosFactura->impuestosTrasladados = [ ];
		$datosFactura->impuestosRetenidos = [ ];
		$datosFactura->impuestosTrasladadosLcl = [ ];
		$datosFactura->impuestosTrasladadosLclTotal = 0;
		$datosFactura->impuestosRetenidosLcl = [ ];
		$datosFactura->impuestosRetenidosLclTotal = 0;
		$totalImpRetenidos = 0;
		$totalImpTrasladados = 0;

		foreach ( $factura ['detalles'] as $detalle ) {

			$concepto = new \stdClass ();
			$concepto->clave = $detalle ['clave'];
			$concepto->id_producto = isset ( $detalle ['id_producto'] ) ? $detalle ['id_producto'] : 0;
			$concepto->cdgItem = Utils::deleteExtraSpaces ( $detalle ['codigo'] );
			$concepto->dscItem = Utils::deleteExtraSpaces ( $detalle ['nombre'] );
			$concepto->unmdItem = (isset ( $detalle ['unidad'] )) ? $detalle ['unidad'] : '';
			if($user ['id_proveedor'] == 1266){
                $unidadMedidaObj = UnidadMedida::where('codigo', '=', $concepto->unmdItem)->first();
                $concepto->unmdItemDesc = $unidadMedidaObj->descripcion;
            }
			$concepto->fracArancelaria = (isset ( $detalle ['fracArancelaria'] )) ? $detalle ['fracArancelaria'] : '';
			$concepto->qtyItem = $detalle ['qty'];
			$concepto->montoNetoItem = $detalle ['precioU'];
			$concepto->prcNetoItem = $detalle ['qty'] * $detalle ['precioU'];
			$concepto->descuento = $detalle ['descuento'];

			$concepto->impuestosTrasladados = [ ];

			$base = Utils::formatNumber ( (($detalle ['qty'] * $detalle ['precioU']) - $detalle ['descuento']), $factura ['decimales'] );
			foreach ( $factura ['impuestosTrasladados'] as $traslado ) {

				if ($traslado ['impuesto'] == 'XXX') {

					$impuestoLcl = new \stdClass ();
					$impuestoLcl->tipoImp = $traslado ['label'];
					$impuestoLcl->tasaImp = $traslado ['valor'];
					$impuestoLcl->tipo = 1;

					$importeImp = 0;
					if ($traslado ['factor'] == 'Tasa') {
						$importeImp = $traslado ['total'];
					} else if ($traslado ['factor'] == 'Cuota') {
						$importeImp = $traslado ['valor'];
					}

					$importeImp = Utils::formatNumber ( $importeImp, $factura ['decimales'] );

					$impuestoLcl->montoImp = $importeImp;

					$datosFactura->impuestosTrasladadosLclTotal += $importeImp;
					$datosFactura->impuestosTrasladadosLcl [] = $impuestoLcl;
				} else {

					$impuesto = new \stdClass ();
					$impuesto->base = $base;
					$impuesto->factor = $traslado ['factor'];
					$impuesto->tipoImp = $traslado ['impuesto'];
					$impuesto->tasaImp = $traslado ['valor'];
					$impuesto->tipo = 1;

					$importeImp = 0;
					if ($traslado ['factor'] == 'Tasa') {
						$importeImp = $traslado ['valor'] * $base;
					} else if ($traslado ['factor'] == 'Cuota') {
						$importeImp = $traslado ['valor'];
					}

                    $roundDown = $factura ['truncar'] == 1 ? true : false;

					$importeImp = Utils::formatNumber ( $importeImp, $factura ['decimales'], $roundDown );

					$impuesto->montoImp = $importeImp;

					$totalImpTrasladados += $importeImp;

					$concepto->impuestosTrasladados [] = $impuesto;

					$isNuevo = true;
					if (count ( $datosFactura->impuestosTrasladados ))
						foreach ( $datosFactura->impuestosTrasladados as $impuestoGeneral ) {

							if ($impuesto->tipoImp == $impuestoGeneral->impuesto && $impuesto->factor == $impuestoGeneral->tipoFactor && $impuesto->tasaImp == $impuestoGeneral->tasaOCuota) {
								$isNuevo = false;
								$impuestoGeneral->importe += $impuesto->montoImp;
								break;
							}
						}

					if ($isNuevo && $traslado ['factor'] != 'Exento') {
						$impuestoGeneral = new \stdClass ();
						$impuestoGeneral->importe = $impuesto->montoImp;
						$impuestoGeneral->impuesto = $impuesto->tipoImp;
						$impuestoGeneral->tipoFactor = $traslado ['factor'];
						$impuestoGeneral->tasaOCuota = $traslado ['valor'];
						$datosFactura->impuestosTrasladados [] = $impuestoGeneral;
					}
				}
			}

			$concepto->impuestosRetenidos = [ ];

			foreach ( $factura ['impuestosRetenidos'] as $retencion ) {

				if ($retencion ['impuesto'] == 'XXX') {

					$impuestoLcl = new \stdClass ();
					$impuestoLcl->tipoImp = $retencion ['label'];

					if ($retencion ['factor'] == 'Cuota') {
						$impuestoLcl->tasaImp = 0.00;
					}else{
						$impuestoLcl->tasaImp = $retencion ['valor'];
					}

					$impuestoLcl->tipo = 0;

					$importeImp = 0;
					if ($retencion ['factor'] == 'Tasa') {
						$importeImp = $retencion ['valor'] * $base;
					} else if ($retencion ['factor'] == 'Cuota') {
						$importeImp = $retencion ['total'];
					}

					$importeImp = Utils::formatNumber ( $importeImp, $factura ['decimales'] );

					$impuestoLcl->montoImp = $importeImp;

					$datosFactura->impuestosRetenidosLclTotal += $importeImp;
					$datosFactura->impuestosRetenidosLcl [] = $impuestoLcl;
				} else {

					$impuesto = new \stdClass ();
					$impuesto->base = $base;
					$impuesto->factor = $retencion ['factor'];
					$impuesto->tipoImp = $retencion ['impuesto'];
					$impuesto->tasaImp = $retencion ['valor'];
					$impuesto->tipo = 0;

					$importeImp = 0;
					if ($retencion ['factor'] == 'Tasa') {
						$importeImp = $retencion ['valor'] * $impuesto->base;
					} else if ($retencion ['factor'] == 'Cuota') {
						$importeImp = $retencion ['valor'];
					}

                    $roundDown = $factura ['truncar'] == 1;

					$importeImp = Utils::formatNumber ( $importeImp, $factura ['decimales'], $roundDown );

					$impuesto->montoImp = $importeImp;

					$totalImpRetenidos += $importeImp;

					$concepto->impuestosRetenidos [] = $impuesto;

					$isNuevo = true;
					if (count ( $datosFactura->impuestosRetenidos ))
						foreach ( $datosFactura->impuestosRetenidos as $impuestoGeneral ) {
							if ($impuesto->tipoImp == $impuestoGeneral->impuesto) {
								$isNuevo = false;
								$impuestoGeneral->importe += $impuesto->montoImp;
								break;
							}
						}

					if ($isNuevo && $retencion ['factor'] != 'Exento') {
						$impuestoGeneral = new \stdClass ();
						$impuestoGeneral->importe = $impuesto->montoImp;
						$impuestoGeneral->impuesto = $impuesto->tipoImp;
						$datosFactura->impuestosRetenidos [] = $impuestoGeneral;
					}
				}
			}

			$datosFactura->conceptos [] = $concepto;
		}

		$datosFactura->totalImpRetenidos = $totalImpRetenidos;
		$datosFactura->totalImpTrasladados = $totalImpTrasladados;

		$datosFactura->facturasRelacionadas = [ ];

		if (count ( $factura ['facturasRelacionadas'] ['uuids'] ))
			foreach ( $factura ['facturasRelacionadas'] ['uuids'] as $facturaRelacionada ) {

				$relacionObj = new \stdClass ();
				$relacionObj->uuid = $facturaRelacionada ['uUID'];
				$datosFactura->facturasRelacionadas [] = $relacionObj;
			}


		$datosFactura->comercio = null;

		if(isset($factura['isComercio']) && $factura['isComercio'] == 1){

			$datosFactura->comercio = new \stdClass();

			$comercio = $factura['comercio'];

			$comercioEObj = new \stdClass();
			$comercioEObj->Incoterm = $comercio['incoterm'];
			$comercioEObj->clavePedimento = $comercio['pedimento'];
			$comercioEObj->tipoOperacion = $comercio['tipoOperacion'];
			$comercioEObj->rfcExtranjero = $comercio['rfcExtranjero'];
            $comercioEObj->motivoTraslado = $comercio['motivoTraslado'] ?? '';
			if(is_object($proveedor->domicilio)){
				$comercioEObj->curp = $proveedor->domicilio->curp;
			}else{
				$comercioEObj->curp = '';
			}

			$emisor = $comercio['emisor'];

			$domicilioEmisor = new \stdClass();
			$domicilioEmisor->calle = $emisor['calle'];
			$domicilioEmisor->nroExterior = isset($emisor['nroExterior'])?$emisor['nroExterior']:'';
			$domicilioEmisor->nroInterior = isset($emisor['nroInterior'])?$emisor['nroInterior']:'';
			$domicilioEmisor->colonia = isset($emisor['colonia'])?$emisor['colonia']:'';
			$domicilioEmisor->municipio = isset($emisor['municipio'])?$emisor['municipio'] : '';
			$domicilioEmisor->estado = $emisor['estado'];
			$domicilioEmisor->pais = $emisor['pais'];
			$domicilioEmisor->codigoPostal = $emisor['codigoPostal'];

			$receptor = $comercio['receptor'];

			$domicilioReceptor = new \stdClass();
			$domicilioReceptor->calle = $receptor['calle'];
			$domicilioReceptor->nroExterior = isset($receptor['nroExterior'])? $receptor['nroExterior'] : '';
			$domicilioReceptor->nroInterior = isset($receptor['nroInterior'])? $receptor['nroInterior'] : '';
			$domicilioReceptor->colonia = isset($receptor['colonia'])? $receptor['colonia'] : '';
			$domicilioReceptor->municipio = isset($receptor['municipio'])? trim($receptor['municipio']) : '';
			$domicilioReceptor->estado = $receptor['estado'];
			$domicilioReceptor->pais = $receptor['pais'];
			$domicilioReceptor->codigoPostal = $receptor['codigoPostal'];


			$datosFactura->comercio->datos = $comercioEObj;
			$datosFactura->comercio->emisor = $domicilioEmisor;
			$datosFactura->comercio->receptor = $domicilioReceptor;

		}

        $datosFactura->addenda = null;
        if(isset($factura['addenda']) && isset($factura['id_addenda']['id_addenda'])){

            $addenda = new \stdClass();
            $addenda->Importe = $factura['addenda']['importe'];
            $addenda->PeriodoEnMeses = $factura['addenda']['period'];
            $addenda->Descripcion = $factura['addenda']['description'];

            $datosFactura->addenda = $addenda;
        }

		$xml = XMLUtils::createXML33 ( $datosFactura, $proveedor );

		$sello = $xml->query ( '//cfdi:Comprobante' ) [0]->getAttribute ( 'Sello' );

		$nombreArchivo = "$proveedor->rFCEmisor-" . date ( 'YmdHis' );

		file_put_contents ( "tmp/$nombreArchivo.xml", $xml );

		$urlTimbrado = "https://facturacion.finkok.com/servicios/soap/stamp.wsdl";
		$usuarioInt = "saul.flores@soliat.com";
		$passwordInt = "S3rgio.Fl0res";

		if ($proveedor->id_proveedor == 1089) {
			$urlTimbrado = "https://demo-facturacion.finkok.com/servicios/soap/stamp.wsdl";
		}

		$params = array ();
		$params ['xml'] = $xml;
		$params ['username'] = $usuarioInt;
		$params ['password'] = $passwordInt;

		$client = new \SoapClient ( $urlTimbrado, array (
            'encoding' => 'UTF-8',
            "connection_timeout" => 250
        ) );
        $client->soap_defencoding = "UTF-8";
        $resultado = $client->__soapCall ( 'stamp', array (
            $params
        ) );

        $logToSave = print_r ( $resultado, true );

        $log = env ( 'DIR_LOGS' ) . "/" . date ( "Y-m-d" ) . ".log";
        $fp = fopen ( $log, "a" );
        fwrite ( $fp, "\n\n===" . date ( "Y-m-d:H:i:s" ) . "\n\n" );
        fwrite ( $fp, "\n\n$nombreArchivo\n\n" );
        fwrite ( $fp, $logToSave );
        fwrite ( $fp, "\n\n===" );
        fclose ( $fp );

		$success = false;
		$errorCode = 0;
		$errortext = '';
		$facturaResult = '';

		if (is_object ( $resultado ) && isset ( $resultado->stampResult ) && isset ( $resultado->stampResult->UUID ) && !empty($resultado->stampResult->xml)) {
			$success = true;

			$xmlTimbrado = new \DOMDocument ( "1.0", "uft-8" );
			$xmlTimbrado->loadXML ( $resultado->stampResult->xml );

			$idDoc = new IdDoc ();

			$timbreFiscal = $xmlTimbrado->getElementsByTagName ( 'TimbreFiscalDigital' );

			foreach ( $timbreFiscal as $timbreFiscal ) {

				$fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );
				$fechaTimbradoArray = explode ( ".", $fechaTimbrado );

				$idDoc->version = $timbreFiscal->getAttribute ( 'Version' );
				$idDoc->fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );
				$idDoc->selloCFD = $timbreFiscal->getAttribute ( 'SelloCFD' );
				$idDoc->noCertificadoSAT = $timbreFiscal->getAttribute ( 'NoCertificadoSAT' );
				$idDoc->selloSAT = $timbreFiscal->getAttribute ( 'SelloSAT' );
				$idDoc->uUID = $timbreFiscal->getAttribute ( 'UUID' );
				$idDoc->sello = $sello;
				$idDoc->rfcProvCertif = $timbreFiscal->getAttribute ( 'RfcProvCertif' );
			}

			$isPagado = 0;
			if ($factura ['metodoDePago'] == 'PUE')
				$isPagado = 1;

            $clienteObj = Cliente::with('domicilio')->find($factura ['id_cliente'] ['id_cliente']);
            $domicilioObj = $clienteObj->domicilio;
            if(!is_object($domicilioObj)){
                $domicilioObj = new DomFiscalRcp();
                $domicilioObj->id_cliente = $factura ['id_cliente'] ['id_cliente'];
            }
            $clienteObj->tipoPersona = $factura ['id_cliente'] ['tipoPersona'] ?? 0;
            $clienteObj->regimenFiscalReceptor = $factura ['id_cliente'] ['regimenFiscalReceptor'];
            $clienteObj->save();

            $domicilioObj->codigoPostal = $factura ['id_cliente'] ['codigoPostal'] ?? '';
            $domicilioObj->save();

			$facturaObj = new Factura ();
			$facturaObj->id_proveedor = $user ['id_proveedor'];
			$facturaObj->id_cliente = $factura ['id_cliente'] ['id_cliente'];
			$facturaObj->id_certificadoProveedor = $certificadoHaUsar->id;
			$facturaObj->nmbEmisor = $proveedor->nmbEmisor;
			$facturaObj->rFCEmisor = $proveedor->rFCEmisor;
			$facturaObj->nmbRecep = $factura ['id_cliente'] ['nmbRecep'];
			$facturaObj->rFCRecep = $factura ['id_cliente'] ['rFCRecep'];
			$facturaObj->regimenFiscal = $proveedor->regimenFiscal33;
			$facturaObj->timeStamp = $timeStamp;
			$facturaObj->noFactura = $noFactura->noFactura;
			$facturaObj->version = "3.3";
			$facturaObj->generadoPor = 4;
			$facturaObj->nota = (isset ( $factura ['comentario'] )) ? Utils::deleteExtraSpaces ( $factura ['comentario'] ) : '';
			$facturaObj->tipoDeComprobante = $factura ['tipoDocumento'];
			$facturaObj->precission = $factura ['decimales'];
			$facturaObj->status = 1;
			$facturaObj->isPagado = $isPagado;
			$facturaObj->numRegIdTrib = $datosFactura->numRegIdTrib;
			$facturaObj->pais = $datosFactura->pais;
			$facturaObj->save ();

			$idDoc->id_factura = $facturaObj->id_factura;
			$idDoc->serie = $factura ['serie'];
			$idDoc->folio = $noFactura->noFactura;
			$idDoc->formaPago = $factura ['formaPago'];
			$idDoc->condicionesDePago = (isset ( $factura ['condicionesPago'] )) ? Utils::deleteExtraSpaces ( $factura ['condicionesPago'] ) : '';
			$idDoc->lugarExpedicion = Utils::deleteExtraSpaces ( $factura ['lugarExpedicion'] );
			$idDoc->usoCFDI = $factura ['usoCFDI'];
			$idDoc->metodoDePago = $factura ['metodoDePago'];
			$idDoc->sello = $sello;
			$idDoc->tipoFacturasRelacionadas = $datosFactura->tipoFacturasRelacionadas;
			$idDoc->save ();

			$totales = new Totales ();
			$totales->id_factura = $facturaObj->id_factura;
			$totales->moneda = $factura ['moneda'];
			$totales->tipoCambio = $factura ['tipoCambio'];
			$totales->subTotal = $factura ['subtotal'];
			$totales->mntBase = $factura ['base'];
			$totales->vlrPagar = $factura ['total'];
			$totales->descuento = $factura ['descuento'];
			$totales->save ();

			$detalles = array ();

			foreach ( $datosFactura->conceptos as $concepto ) {

				$conceptoObj = new Concepto ();
				$conceptoObj->clave = $concepto->clave;
				$conceptoObj->cdgItem = $concepto->cdgItem;
				$conceptoObj->dscItem = $concepto->dscItem;
				$conceptoObj->unmdItem = $concepto->unmdItem;
				if(isset($concepto->unmdItemDesc))
                    $conceptoObj->unmdItemDesc = $concepto->unmdItemDesc;
				$conceptoObj->qtyItem = $concepto->qtyItem;
				$conceptoObj->montoNetoItem = $concepto->montoNetoItem;
				$conceptoObj->prcNetoItem = $concepto->prcNetoItem;
				$conceptoObj->descuento = $concepto->descuento;
				$conceptoObj->fracArancelaria = $concepto->fracArancelaria;
				$conceptoObj->id_factura = $facturaObj->id_factura;
				$conceptoObj->save ();

				if (isset ( $factura ['guardarProd'] ) && $factura ['guardarProd'] == true) {

					if ($concepto->id_producto > 0) {
						$concepto2Obj = Producto::find ( $concepto->id_producto );
					} else {
						$concepto2Obj = new Producto ();
					}

					$concepto2Obj->id_proveedor = $user ['id_proveedor'];
					$concepto2Obj->clave = $concepto->clave;
					$concepto2Obj->nombre = $concepto->dscItem;
					$concepto2Obj->precioU = $concepto->montoNetoItem;
					$concepto2Obj->unidad = $concepto->unmdItem;
					$concepto2Obj->codigo = $concepto->cdgItem;
					$concepto2Obj->status = 1;
					$concepto2Obj->save ();
				}

				foreach ( $concepto->impuestosTrasladados as $impuesto ) {

					$impuestoObj = new ExImpuestos ();
					$impuestoObj->base = $impuesto->base;
					$impuestoObj->factor = $impuesto->factor;
					$impuestoObj->tipoImp = $impuesto->tipoImp;
					$impuestoObj->tasaImp = $impuesto->tasaImp;
					$impuestoObj->tipo = $impuesto->tipo;
					$impuestoObj->montoImp = $impuesto->montoImp;
					$impuestoObj->id_detalle = $conceptoObj->id_detalle;
					$impuestoObj->save ();
				}

				foreach ( $concepto->impuestosRetenidos as $impuesto ) {

					$impuestoObj = new ExImpuestos ();
					$impuestoObj->base = $impuesto->base;
					$impuestoObj->factor = $impuesto->factor;
					$impuestoObj->tipoImp = $impuesto->tipoImp;
					$impuestoObj->tasaImp = $impuesto->tasaImp;
					$impuestoObj->tipo = $impuesto->tipo;
					$impuestoObj->montoImp = $impuesto->montoImp;
					$impuestoObj->id_detalle = $conceptoObj->id_detalle;
					$impuestoObj->save ();
				}
			}

			foreach ( $datosFactura->facturasRelacionadas as $facturaRelacionada ) {

				$facturaRelacionadaObj = new FacturasRelacionadas ();
				$facturaRelacionadaObj->id_factura = $facturaObj->id_factura;
				$facturaRelacionadaObj->uuid = $facturaRelacionada->uuid;
				$facturaRelacionadaObj->save ();
			}

			if (count ( $datosFactura->impuestosRetenidosLcl ) > 0)
				foreach ( $datosFactura->impuestosRetenidosLcl as $impuesto ) {

					$impuestoObj = new ExImpuestos ();
					$impuestoObj->tipoImp = $impuesto->tipoImp;
					$impuestoObj->tasaImp = $impuesto->tasaImp;
					$impuestoObj->tipo = $impuesto->tipo;
					$impuestoObj->montoImp = $impuesto->montoImp;
					$impuestoObj->id_factura = $facturaObj->id_factura;
					$impuestoObj->save ();
				}

			if (count ( $datosFactura->impuestosTrasladadosLcl ) > 0)
				foreach ( $datosFactura->impuestosTrasladadosLcl as $impuesto ) {

					$impuestoObj = new ExImpuestos ();
					$impuestoObj->tipoImp = $impuesto->tipoImp;
					$impuestoObj->tasaImp = $impuesto->tasaImp;
					$impuestoObj->tipo = $impuesto->tipo;
					$impuestoObj->montoImp = $impuesto->montoImp;
					$impuestoObj->id_factura = $facturaObj->id_factura;
					$impuestoObj->save ();
				}

			if ($datosFactura->cuentaPredial != '') {

				$arrendamiento = new Arrendamiento ();
				$arrendamiento->id_factura = $facturaObj->id_factura;
				$arrendamiento->cuentaPredial = $datosFactura->cuentaPredial;
				$arrendamiento->save ();
			}


			if($datosFactura->comercio != null){

				$comercioEObjS = new ComercioE();
				$comercioEObjS->id_factura = $facturaObj->id_factura;
				$comercioEObjS->Incoterm = $datosFactura->comercio->datos->Incoterm;
				$comercioEObjS->clavePedimento = $datosFactura->comercio->datos->clavePedimento;
				$comercioEObjS->tipoOperacion = $datosFactura->comercio->datos->tipoOperacion;
				$comercioEObjS->rfcExtranjero = $datosFactura->comercio->datos->rfcExtranjero;
                $comercioEObjS->motivoTraslado = $datosFactura->comercio->datos->motivoTraslado;
				$comercioEObjS->curp = $datosFactura->comercio->datos->curp;
				$comercioEObjS->save();

				$emisor = $comercio['emisor'];

				$domicilioEmisorObjS = new DomFiscalFact();
				$domicilioEmisorObjS->id_factura = $facturaObj->id_factura;
				$domicilioEmisorObjS->calle = $datosFactura->comercio->emisor->calle;
				$domicilioEmisorObjS->nroExterior = $datosFactura->comercio->emisor->nroExterior;
				$domicilioEmisorObjS->nroInterior = $datosFactura->comercio->emisor->nroInterior;
				$domicilioEmisorObjS->colonia = $datosFactura->comercio->emisor->colonia;
				$domicilioEmisorObjS->municipio = $datosFactura->comercio->emisor->municipio;
				$domicilioEmisorObjS->estado = $datosFactura->comercio->emisor->estado;
				$domicilioEmisorObjS->pais = $datosFactura->comercio->emisor->pais;
				$domicilioEmisorObjS->codigoPostal = $datosFactura->comercio->emisor->codigoPostal;
				$domicilioEmisorObjS->save();


				$domicilioReceptorObjS = new DomFiscalRcpFact();
				$domicilioReceptorObjS->id_factura = $facturaObj->id_factura;
				$domicilioReceptorObjS->calle = $datosFactura->comercio->receptor->calle;
				$domicilioReceptorObjS->nroExterior = $datosFactura->comercio->receptor->nroExterior;
				$domicilioReceptorObjS->nroInterior = $datosFactura->comercio->receptor->nroInterior;
				$domicilioReceptorObjS->colonia = $datosFactura->comercio->receptor->colonia;
				$domicilioReceptorObjS->municipio = $datosFactura->comercio->receptor->municipio;
				$domicilioReceptorObjS->estado = $datosFactura->comercio->receptor->estado;
				$domicilioReceptorObjS->pais = $datosFactura->comercio->receptor->pais;
				$domicilioReceptorObjS->codigoPostal = $datosFactura->comercio->receptor->codigoPostal;
				$domicilioReceptorObjS->save();


			}

            if($datosFactura->addenda != null){

                $addendaObj = new AddendaFondoGarantia();
                $addendaObj->id_factura = $facturaObj->id_factura;
                $addendaObj->Importe = $datosFactura->addenda->Importe;
                $addendaObj->PeriodoEnMeses = $datosFactura->addenda->PeriodoEnMeses;
                $addendaObj->Descripcion = $datosFactura->addenda->Descripcion;
                $addendaObj->save();

            }

			$facturaResult = $datosFactura->serie . $datosFactura->folio;
		} else {

			$errorCode = 10001;
			$errorMsg = 'Hubo un error al crear su factura. Vuelva a intentarlo.';

			if (is_object ( $resultado ) && isset ( $resultado->stampResult ) && isset ( $resultado->stampResult->Incidencias )
					&& isset ( $resultado->stampResult->Incidencias->Incidencia )) {

						$errorMsg = $resultado->stampResult->Incidencias->Incidencia->MensajeIncidencia;
			}

			$errortext = $errorMsg;
		}

		return Response::json ( array (
				'success' => $success,
				'errorCode' => $errorCode,
				'errortext' => $errortext,
				'facturaResult' => $facturaResult,
				'nombreArchivo' => $nombreArchivo
		) );
	}


	public function facturarPorConcepto(Request $request) {
		ini_set ( 'default_socket_timeout', 250 );

		$factura = $request->input ( 'factura' );
		$user = $request->input ( 'user' );
		$proveedor = Proveedor::find ( $user ['id_proveedor'] );
		$nombreArchivo = '';

		$timeStamp = date ( "Y-m-d H:i:s", strtotime ( "-2 minutes" ) );
		$noFactura = DB::select ( "SELECT MAX(noFactura) as noFactura FROM Factura f JOIN IdDoc i ON f.id_factura = i.id_factura WHERE id_proveedor = " . $user ['id_proveedor'] . " AND i.serie = '" . $factura ['serie'] . "'" ) [0];
		$noFactura->noFactura ++;
		$certificadoHaUsar = CertificadoProveedor::where ( 'id_proveedor', '=', $user ['id_proveedor'] )->where ( 'status', '=', 1 )->first ();

        if(!is_object($certificadoHaUsar)){
            return Response::json ( array (
                'success' => true,
                'errorCode' => 1015,
                'errortext' => "No se ha cargado ningún CSD, por favor vaya a la sección de Mis datos y cárguelo nuevamente.",
                'facturaResult' => date('Y-m-d H:i:s'),
                'nombreArchivo' => 'TMP'
            ) );
        }

		$datosFactura = new \stdClass ();
		$datosFactura->timeStamp = $timeStamp;
		$datosFactura->tipoDeComprobante = $factura ['tipoDocumento'];
		$datosFactura->serie = $factura ['serie'];
		$datosFactura->folio = $noFactura->noFactura;
		$datosFactura->noCertificado = $certificadoHaUsar->noCertificado;
		$datosFactura->certificado = $certificadoHaUsar->certificado;
		$datosFactura->mntBase = $factura ['base'];
		$datosFactura->subtotal = $factura ['subtotal'];
		$datosFactura->moneda = $factura ['moneda'];
		$datosFactura->total = $factura ['total'];
		$datosFactura->formaPago = $factura ['formaPago'];
		$datosFactura->descuento = $factura ['descuento'];
		$datosFactura->precission = $factura ['decimales'];
		$datosFactura->tipoCambio = $factura ['tipoCambio'];
		$datosFactura->lugarExpedicion = Utils::deleteExtraSpaces ( $factura ['lugarExpedicion'] );
		$datosFactura->usoCFDI = $factura ['usoCFDI'];
		$datosFactura->metodoDePago = $factura ['metodoDePago'];
		$datosFactura->condicionesDePago = (isset ( $factura ['condicionesPago'] )) ? Utils::deleteExtraSpaces ( $factura ['condicionesPago'] ) : '';
		$datosFactura->cuentaPredial = (isset ( $factura ['cuentaPredial'] )) ? Utils::deleteExtraSpaces ( $factura ['cuentaPredial'] ) : '';
		$datosFactura->tipoFacturasRelacionadas = $factura ['facturasRelacionadas'] ['tipoRelacion'];
		$datosFactura->rFCEmisor = $proveedor->rFCEmisor;
		$datosFactura->nmbEmisor = $proveedor->nmbEmisor;
		$datosFactura->rFCRecep = $factura ['id_cliente'] ['rFCRecep'];
		$datosFactura->nmbRecep = $factura ['id_cliente'] ['nmbRecep'];
		$datosFactura->regimenFiscal = $proveedor->regimenFiscal33;
		$datosFactura->numRegIdTrib = isset ( $factura ['numRegIdTrib'] ) ? $factura ['numRegIdTrib'] : '';
		$datosFactura->pais = isset ( $factura ['pais'] ) ? $factura ['pais'] : '';
		$datosFactura->tipoPersona = $proveedor->tipoPersona;

		$datosFactura->conceptos = [ ];
		$datosFactura->impuestosTrasladados = [ ];
		$datosFactura->impuestosRetenidos = [ ];
		$datosFactura->impuestosTrasladadosLcl = [ ];
		$datosFactura->impuestosTrasladadosLclTotal = 0;
		$datosFactura->impuestosRetenidosLcl = [ ];
		$datosFactura->impuestosRetenidosLclTotal = 0;
		$totalImpRetenidos = 0;
		$totalImpTrasladados = 0;

		foreach ( $factura ['detalles'] as $detalle ) {

			$concepto = new \stdClass ();
			$concepto->clave = $detalle ['clave'];
			$concepto->id_producto = isset ( $detalle ['id_producto'] ) ? $detalle ['id_producto'] : 0;
			$concepto->cdgItem = Utils::deleteExtraSpaces ( $detalle ['codigo'] );
			$concepto->dscItem = Utils::deleteExtraSpaces ( $detalle ['nombre'] );
			$concepto->unmdItem = (isset ( $detalle ['unidad'] )) ? $detalle ['unidad'] : '';
			$concepto->qtyItem = $detalle ['qty'];
			$concepto->montoNetoItem = $detalle ['precioU'];
			$concepto->prcNetoItem = $detalle ['qty'] * $detalle ['precioU'];
			$concepto->descuento = $detalle ['descuento'];

			$concepto->impuestosTrasladados = [ ];

			$base = Utils::formatNumber ( (($detalle ['qty'] * $detalle ['precioU']) - $detalle ['descuento']), $factura ['decimales'] );
			foreach ( $detalle ['impuestosTrasladados'] as $traslado ) {

				if ($traslado ['impuesto'] == 'XXX') {

					$impuestoLcl = new \stdClass ();
					$impuestoLcl->tipoImp = $traslado ['label'];
					$impuestoLcl->tasaImp = $traslado ['valor'];
					$impuestoLcl->tipo = 1;

					$importeImp = Utils::formatNumber ( $traslado ['total'], $factura ['decimales'] );

					$impuestoLcl->montoImp = $importeImp;

					$datosFactura->impuestosTrasladadosLclTotal += $importeImp;
					$datosFactura->impuestosTrasladadosLcl [] = $impuestoLcl;
				} else {

					$impuesto = new \stdClass ();
					$impuesto->base = $traslado ['base'];
					$impuesto->factor = $traslado ['factor'];
					$impuesto->tipoImp = $traslado ['impuesto'];
					$impuesto->tasaImp = $traslado ['valor'];
					$impuesto->tipo = 1;

					$importeImp = Utils::formatNumber ( $traslado ['total'], $factura ['decimales'] );

					$impuesto->montoImp = $importeImp;

					$totalImpTrasladados += $importeImp;

					$concepto->impuestosTrasladados [] = $impuesto;

					$isNuevo = true;
					if (count ( $datosFactura->impuestosTrasladados ))
						foreach ( $datosFactura->impuestosTrasladados as $impuestoGeneral ) {

							if ($impuesto->tipoImp == $impuestoGeneral->impuesto && $impuesto->factor == $impuestoGeneral->tipoFactor && $impuesto->tasaImp == $impuestoGeneral->tasaOCuota) {
								$isNuevo = false;
								$impuestoGeneral->importe += $impuesto->montoImp;
								break;
							}
						}

					if ($isNuevo && $traslado ['factor'] != 'Exento') {
						$impuestoGeneral = new \stdClass ();
						$impuestoGeneral->importe = $impuesto->montoImp;
						$impuestoGeneral->impuesto = $impuesto->tipoImp;
						$impuestoGeneral->tipoFactor = $traslado ['factor'];
						$impuestoGeneral->tasaOCuota = $traslado ['valor'];
						$datosFactura->impuestosTrasladados [] = $impuestoGeneral;
					}
				}
			}

			$concepto->impuestosRetenidos = array();

			foreach ( $detalle ['impuestosRetenidos'] as $retencion ) {

				if ($retencion ['impuesto'] == 'XXX') {

					$impuestoLcl = new \stdClass ();
					$impuestoLcl->tipoImp = $retencion ['label'];
					$impuestoLcl->tasaImp = $retencion ['valor'];
					$impuestoLcl->tipo = 0;

					$importeImp = Utils::formatNumber ( $retencion ['total'], $factura ['decimales'] );

					$impuestoLcl->montoImp = $importeImp;

					$datosFactura->impuestosRetenidosLclTotal += $importeImp;
					$datosFactura->impuestosRetenidosLcl [] = $impuestoLcl;
				} else {

					$impuesto = new \stdClass ();
					$impuesto->base = $retencion ['base'];
					$impuesto->factor = $retencion ['factor'];
					$impuesto->tipoImp = $retencion ['impuesto'];
					$impuesto->tasaImp = $retencion ['valor'];
					$impuesto->tipo = 0;

					$importeImp = Utils::formatNumber ( $retencion ['total'], $factura ['decimales'] );

					$impuesto->montoImp = $importeImp;

					$totalImpRetenidos += $importeImp;

					$concepto->impuestosRetenidos [] = $impuesto;

					$isNuevo = true;
					if (count ( $datosFactura->impuestosRetenidos ))
						foreach ( $datosFactura->impuestosRetenidos as $impuestoGeneral ) {
							if ($impuesto->tipoImp == $impuestoGeneral->impuesto) {
								$isNuevo = false;
								$impuestoGeneral->importe += $impuesto->montoImp;
								break;
							}
						}

					if ($isNuevo && $retencion ['factor'] != 'Exento') {
						$impuestoGeneral = new \stdClass ();
						$impuestoGeneral->importe = $impuesto->montoImp;
						$impuestoGeneral->impuesto = $impuesto->tipoImp;
						$datosFactura->impuestosRetenidos [] = $impuestoGeneral;
					}
				}
			}

			$datosFactura->conceptos [] = $concepto;
		}

		$datosFactura->totalImpRetenidos = $totalImpRetenidos;
		$datosFactura->totalImpTrasladados = $totalImpTrasladados;

		$datosFactura->facturasRelacionadas = [ ];

		if (count ( $factura ['facturasRelacionadas'] ['uuids'] ))
			foreach ( $factura ['facturasRelacionadas'] ['uuids'] as $facturaRelacionada ) {

				$relacionObj = new \stdClass ();
				$relacionObj->uuid = $facturaRelacionada ['uUID'];
				$datosFactura->facturasRelacionadas [] = $relacionObj;
			}

		$xml = XMLUtils::createXML33 ( $datosFactura, $proveedor );

		$sello = $xml->query ( '//cfdi:Comprobante' ) [0]->getAttribute ( 'Sello' );

		$nombreArchivo = "$proveedor->rFCEmisor-" . date ( 'YmdHis' );

		file_put_contents ( "tmp/$nombreArchivo.xml", $xml );

		$urlTimbrado = "https://facturacion.finkok.com/servicios/soap/stamp.wsdl";
		$usuarioInt = "saul.flores@soliat.com";
		$passwordInt = "S3rgio.Fl0res";

		if ($proveedor->id_proveedor == 1089) {

			$urlTimbrado = "https://demo-facturacion.finkok.com/servicios/soap/stamp.wsdl";
			$usuarioInt = "saul.flores@soliat.com";
			$passwordInt = "S3rgio.Fl0res";
		}

		$params = array ();
		$params ['xml'] = $xml;
		$params ['username'] = $usuarioInt;
		$params ['password'] = $passwordInt;

		$client = new SoapClient ( $urlTimbrado, array (
				'encoding' => 'UTF-8',
				"connection_timeout" => 250
		) );
		$client->soap_defencoding = "UTF-8";
		$resultado = $client->__soapCall ( 'stamp', array (
				$params
		) );

		$logToSave = print_r ( $resultado, true );

		$log = env ( 'DIR_LOGS' ) . "/" . date ( "Y-m-d" ) . ".log";
		$fp = fopen ( $log, "a" );
		fwrite ( $fp, "\n\n===" . date ( "Y-m-d:H:i:s" ) . "\n\n" );
		fwrite ( $fp, "\n\n$nombreArchivo\n\n" );
		fwrite ( $fp, $logToSave );
		fwrite ( $fp, "\n\n===" );
		fclose ( $fp );

		$success = false;
		$errorCode = 0;
		$errortext = '';
		$facturaResult = '';

		if (is_object ( $resultado ) && isset ( $resultado->stampResult ) && isset ( $resultado->stampResult->xml)
            && isset($resultado->stampResult->UUID) ) {
			$success = true;

			$xmlTimbrado = new \DOMDocument ( "1.0", "uft-8" );
			$xmlTimbrado->loadXML ( $resultado->stampResult->xml );

			$idDoc = new IdDoc ();

			$timbreFiscal = $xmlTimbrado->getElementsByTagName ( 'TimbreFiscalDigital' );

			foreach ( $timbreFiscal as $timbreFiscal ) {

				$fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );
				$fechaTimbradoArray = explode ( ".", $fechaTimbrado );

				$idDoc->version = $timbreFiscal->getAttribute ( 'Version' );
				$idDoc->fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );
				$idDoc->selloCFD = $timbreFiscal->getAttribute ( 'SelloCFD' );
				$idDoc->noCertificadoSAT = $timbreFiscal->getAttribute ( 'NoCertificadoSAT' );
				$idDoc->selloSAT = $timbreFiscal->getAttribute ( 'SelloSAT' );
				$idDoc->uUID = $timbreFiscal->getAttribute ( 'UUID' );
				$idDoc->sello = $sello;
				$idDoc->rfcProvCertif = $timbreFiscal->getAttribute ( 'RfcProvCertif' );
			}

			$isPagado = 0;
			if ($factura ['metodoDePago'] == 'PUE')
				$isPagado = 1;

            $clienteObj = Cliente::with('domicilio')->find($factura ['id_cliente'] ['id_cliente']);
            $domicilioObj = $clienteObj->domicilio;
            if(!is_object($domicilioObj)){
                $domicilioObj = new DomFiscalRcp();
                $domicilioObj->id_cliente = $factura ['id_cliente'] ['id_cliente'];
            }
            $clienteObj->tipoPersona = $factura ['id_cliente'] ['tipoPersona'] ?? 0;
            $clienteObj->regimenFiscalReceptor = $factura ['id_cliente'] ['regimenFiscalReceptor'] ?? '';
            $clienteObj->save();

            $domicilioObj->codigoPostal = $factura ['id_cliente'] ['codigoPostal'] ?? '';
            $domicilioObj->save();

			$facturaObj = new Factura ();
			$facturaObj->id_proveedor = $user ['id_proveedor'];
			$facturaObj->id_cliente = $factura ['id_cliente'] ['id_cliente'];
			$facturaObj->id_certificadoProveedor = $certificadoHaUsar->id;
			$facturaObj->nmbEmisor = $proveedor->nmbEmisor;
			$facturaObj->rFCEmisor = $proveedor->rFCEmisor;
			$facturaObj->nmbRecep = $factura ['id_cliente'] ['nmbRecep'];
			$facturaObj->rFCRecep = $factura ['id_cliente'] ['rFCRecep'];
			$facturaObj->regimenFiscal = $proveedor->regimenFiscal33;
			$facturaObj->timeStamp = $timeStamp;
			$facturaObj->noFactura = $noFactura->noFactura;
			$facturaObj->version = "3.3";
			$facturaObj->generadoPor = 4;
			$facturaObj->nota = (isset ( $factura ['comentario'] )) ? Utils::deleteExtraSpaces ( $factura ['comentario'] ) : '';
			$facturaObj->tipoDeComprobante = $factura ['tipoDocumento'];
			$facturaObj->precission = $factura ['decimales'];
			$facturaObj->status = 1;
			$facturaObj->isPagado = $isPagado;
			$facturaObj->save ();

			$idDoc->id_factura = $facturaObj->id_factura;
			$idDoc->serie = $factura ['serie'];
			$idDoc->folio = $noFactura->noFactura;
			$idDoc->formaPago = $factura ['formaPago'];
			$idDoc->condicionesDePago = (isset ( $factura ['condicionesPago'] )) ? Utils::deleteExtraSpaces ( $factura ['condicionesPago'] ) : '';
			$idDoc->lugarExpedicion = Utils::deleteExtraSpaces ( $factura ['lugarExpedicion'] );
			$idDoc->usoCFDI = $factura ['usoCFDI'];
			$idDoc->metodoDePago = $factura ['metodoDePago'];
			$idDoc->sello = $sello;
			$idDoc->tipoFacturasRelacionadas = $datosFactura->tipoFacturasRelacionadas;
			$idDoc->save ();

			$totales = new Totales ();
			$totales->id_factura = $facturaObj->id_factura;
			$totales->moneda = $factura ['moneda'];
			$totales->tipoCambio = $factura ['tipoCambio'];
			$totales->subTotal = $factura ['subtotal'];
			$totales->mntBase = $factura ['base'];
			$totales->vlrPagar = $factura ['total'];
			$totales->descuento = $factura ['descuento'];
			$totales->save ();

			$detalles = array ();

			foreach ( $datosFactura->conceptos as $concepto ) {

				$conceptoObj = new Concepto ();
				$conceptoObj->clave = $concepto->clave;
				$conceptoObj->cdgItem = $concepto->cdgItem;
				$conceptoObj->dscItem = $concepto->dscItem;
				$conceptoObj->unmdItem = $concepto->unmdItem;
				$conceptoObj->qtyItem = $concepto->qtyItem;
				$conceptoObj->montoNetoItem = $concepto->montoNetoItem;
				$conceptoObj->prcNetoItem = $concepto->prcNetoItem;
				$conceptoObj->descuento = $concepto->descuento;
				$conceptoObj->id_factura = $facturaObj->id_factura;
				$conceptoObj->save ();

				if (isset ( $factura ['guardarProd'] ) && $factura ['guardarProd'] == true) {

					if ($concepto->id_producto > 0) {
						$concepto2Obj = Producto::find ( $concepto->id_producto );
					} else {
						$concepto2Obj = new Producto ();
					}

					$concepto2Obj->id_proveedor = $user ['id_proveedor'];
					$concepto2Obj->clave = $concepto->clave;
					$concepto2Obj->nombre = $concepto->dscItem;
					$concepto2Obj->precioU = $concepto->montoNetoItem;
					$concepto2Obj->unidad = $concepto->unmdItem;
					$concepto2Obj->codigo = $concepto->cdgItem;
					$concepto2Obj->status = 1;
					$concepto2Obj->save ();
				}

				foreach ( $concepto->impuestosTrasladados as $impuesto ) {

					$impuestoObj = new ExImpuestos ();
					$impuestoObj->base = $impuesto->base;
					$impuestoObj->factor = $impuesto->factor;
					$impuestoObj->tipoImp = $impuesto->tipoImp;
					$impuestoObj->tasaImp = $impuesto->tasaImp;
					$impuestoObj->tipo = $impuesto->tipo;
					$impuestoObj->montoImp = $impuesto->montoImp;
					$impuestoObj->id_detalle = $conceptoObj->id_detalle;
					$impuestoObj->save ();
				}

				foreach ( $concepto->impuestosRetenidos as $impuesto ) {

					$impuestoObj = new ExImpuestos ();
					$impuestoObj->base = $impuesto->base;
					$impuestoObj->factor = $impuesto->factor;
					$impuestoObj->tipoImp = $impuesto->tipoImp;
					$impuestoObj->tasaImp = $impuesto->tasaImp;
					$impuestoObj->tipo = $impuesto->tipo;
					$impuestoObj->montoImp = $impuesto->montoImp;
					$impuestoObj->id_detalle = $conceptoObj->id_detalle;
					$impuestoObj->save ();
				}
			}

			foreach ( $datosFactura->facturasRelacionadas as $facturaRelacionada ) {

				$facturaRelacionadaObj = new FacturasRelacionadas ();
				$facturaRelacionadaObj->id_factura = $facturaObj->id_factura;
				$facturaRelacionadaObj->uuid = $facturaRelacionada->uuid;
				$facturaRelacionadaObj->save ();
			}

			if (count ( $datosFactura->impuestosRetenidosLcl ) > 0)
				foreach ( $datosFactura->impuestosRetenidosLcl as $impuesto ) {

					$impuestoObj = new ExImpuestos ();
					$impuestoObj->tipoImp = $impuesto->tipoImp;
					$impuestoObj->tasaImp = $impuesto->tasaImp;
					$impuestoObj->tipo = $impuesto->tipo;
					$impuestoObj->montoImp = $impuesto->montoImp;
					$impuestoObj->id_factura = $facturaObj->id_factura;
					$impuestoObj->save ();
				}

			if (count ( $datosFactura->impuestosTrasladadosLcl ) > 0)
				foreach ( $datosFactura->impuestosTrasladadosLcl as $impuesto ) {

					$impuestoObj = new ExImpuestos ();
					$impuestoObj->tipoImp = $impuesto->tipoImp;
					$impuestoObj->tasaImp = $impuesto->tasaImp;
					$impuestoObj->tipo = $impuesto->tipo;
					$impuestoObj->montoImp = $impuesto->montoImp;
					$impuestoObj->id_factura = $facturaObj->id_factura;
					$impuestoObj->save ();
				}

			if ($datosFactura->cuentaPredial != '') {

				$arrendamiento = new Arrendamiento ();
				$arrendamiento->id_factura = $facturaObj->id_factura;
				$arrendamiento->cuentaPredial = $datosFactura->cuentaPredial;
				$arrendamiento->save ();
			}

			$facturaResult = $datosFactura->serie . $datosFactura->folio;
		} else {
            $errorCode = 10001;
            $errorMsg = 'Hubo un error al crear su factura. Vuelva a intentarlo.';

            if (is_object ( $resultado ) && isset ( $resultado->stampResult ) && isset ( $resultado->stampResult->Incidencias )
                && isset ( $resultado->stampResult->Incidencias->Incidencia )) {

                $errorMsg = $resultado->stampResult->Incidencias->Incidencia->MensajeIncidencia;
            }

            $errortext = $errorMsg;
		}

		return Response::json ( array (
				'success' => $success,
				'errorCode' => $errorCode,
				'errortext' => $errortext,
				'facturaResult' => $facturaResult,
				'nombreArchivo' => $nombreArchivo
		) );
	}


	public function facturarPago(Request $request) {
		ini_set ( 'default_socket_timeout', 300 );
		ini_set ( 'max_execution_time', 300 );
		set_time_limit ( 300 );

		$factura = $request->input ( 'factura' );
		$user = $request->input ( 'user' );
		$proveedor = Proveedor::find ( $user ['id_proveedor'] );

        $textLess = '-125 minutes';
        if (in_array ( $user ['id_proveedor'], $this->rfcHorasAntes ))
            $textLess = '-70 hours';

        $timeStamp = date ( "Y-m-d H:i:s", strtotime ( $textLess ) );

		$noFactura = DB::select ( "SELECT MAX(noFactura) as noFactura FROM Factura f JOIN IdDoc i ON f.id_factura = i.id_factura WHERE id_proveedor = " . $user ['id_proveedor'] . " AND i.serie = '" . $factura ['serie'] . "'" ) [0];
		$noFactura->noFactura ++;
		$certificadoHaUsar = CertificadoProveedor::where ( 'id_proveedor', '=', $user ['id_proveedor'] )->where ( 'status', '=', 1 )->first ();

        if(!is_object($certificadoHaUsar)){
            return Response::json ( array (
                'success' => true,
                'errorCode' => 1015,
                'errortext' => "No se ha cargado ningún CSD, por favor vaya a la sección de Mis datos y cárguelo nuevamente.",
                'facturaResult' => date('Y-m-d H:i:s'),
                'nombreArchivo' => 'TMP'
            ) );
        }

		$datosFactura = new \stdClass ();
		$datosFactura->timeStamp = $timeStamp;
		$datosFactura->tipoDeComprobante = 'P';
		$datosFactura->serie = $factura ['serie'];
		$datosFactura->folio = $noFactura->noFactura;
		$datosFactura->noCertificado = $certificadoHaUsar->noCertificado;
		$datosFactura->certificado = $certificadoHaUsar->certificado;
		$datosFactura->mntBase = 0;
		$datosFactura->subtotal = 0;
		$datosFactura->moneda = 'XXX';
		$datosFactura->total = 0;
		$datosFactura->formaPago = '';
		$datosFactura->condicionesDePago = '';
		$datosFactura->descuento = 0;
		$datosFactura->precission = 0;
		$datosFactura->tipoCambio = 1;
		$datosFactura->lugarExpedicion = Utils::deleteExtraSpaces ( $factura ['lugarExpedicion'] );
		$datosFactura->usoCFDI = 'P01';
		$datosFactura->metodoDePago = '';
		$datosFactura->condicionesDePago = '';
		$datosFactura->tipoFacturasRelacionadas = $factura ['facturasRelacionadas'] ['tipoRelacion'];
		$datosFactura->rFCEmisor = $proveedor->rFCEmisor;
		$datosFactura->nmbEmisor = $proveedor->nmbEmisor;
		$datosFactura->rFCRecep = $factura ['id_cliente'] ['rFCRecep'];
		$datosFactura->nmbRecep = $factura ['id_cliente'] ['nmbRecep'];
		$datosFactura->regimenFiscal = $proveedor->regimenFiscal33;
		$datosFactura->numRegIdTrib = isset ( $factura ['numRegIdTrib'] ) ? $factura ['numRegIdTrib'] : '';
		$datosFactura->pais = isset ( $factura ['pais'] ) ? $factura ['pais'] : '';
		$datosFactura->tipoPersona = $proveedor->tipoPersona;

		$datosFactura->conceptos = [ ];
		$datosFactura->impuestosTrasladados = [ ];
		$datosFactura->impuestosRetenidos = [ ];
		$totalImpRetenidos = 0;
		$totalImpTrasladados = 0;

		$detalle = array (
				'clave' => '84111506',
				'codigo' => '',
				'nombre' => 'Pago',
				'unidad' => 'ACT',
				'qty' => 1,
				'precioU' => 0,
				'descuento' => 0
		);
		$factura ['detalles'] = [ ];
		$factura ['detalles'] [] = $detalle;

		foreach ( $factura ['detalles'] as $detalle ) {

			$concepto = new \stdClass ();
			$concepto->clave = $detalle ['clave'];
			$concepto->cdgItem = Utils::deleteExtraSpaces ( $detalle ['codigo'] );
			$concepto->dscItem = Utils::deleteExtraSpaces ( $detalle ['nombre'] );
			$concepto->unmdItem = (isset ( $detalle ['unidad'] )) ? $detalle ['unidad'] : '';
			$concepto->qtyItem = $detalle ['qty'];
			$concepto->montoNetoItem = $detalle ['precioU'];
			$concepto->prcNetoItem = $detalle ['qty'] * $detalle ['precioU'];
			$concepto->descuento = $detalle ['descuento'];

			$concepto->impuestosTrasladados = [ ];
			$concepto->impuestosRetenidos = [ ];
			$datosFactura->conceptos [] = $concepto;
		}

		$datosFactura->pagos = [ ];
		foreach ( $factura ['pagos'] as $pago ) {

			$pagoObj = new \stdClass ();
			$pagoObj->FechaPago = $pago ['fechaPago'];
			$pagoObj->FormaDePagoP = $pago ['formaPago'];
			$pagoObj->MonedaP = $pago ['moneda'];
            $pagoObj->TipoCambioP = ($pago ['tipoCambio'] > 1) ? $pago ['tipoCambio'] : 0;
			$pagoObj->Monto = $pago ['totalPago'];
			$pagoObj->banco = $pago ['banco'] ?? '';
			$pagoObj->cuenta = $pago ['cuenta'] ?? '';
            $pagoObj->rfcEmisorCtaBen = isset($pago ['rfcEmisorCtaBen']) ? trim($pago ['rfcEmisorCtaBen']) : '';
            $pagoObj->ctaBeneficiario = isset($pago ['ctaBeneficiario']) ? trim($pago ['ctaBeneficiario']) : '';
            $pagoObj->noOperacion = $pago ['noOperacion'] ?? '';
			$pagoObj->documentosRelacionado = [ ];

			foreach ( $pago ['documentoRelacionado'] as $documentoRelacionado ) {

                $toPrints = print_r($documentoRelacionado, true);
                Log::error($toPrints);

				$doctoRelacionado = new \stdClass ();
				$doctoRelacionado->IdDocumento = $documentoRelacionado ['uuid'];
				$doctoRelacionado->MonedaDR = $documentoRelacionado ['moneda'];
				$doctoRelacionado->TipoCambioDR = (isset($documentoRelacionado ['tipoCambioDR']) && $documentoRelacionado ['tipoCambioDR'] > 1) ? $documentoRelacionado ['tipoCambioDR'] : null;
				$doctoRelacionado->MetodoDePagoDR = 'PPD';
				$doctoRelacionado->NumParcialidad = $documentoRelacionado ['parcialidad'];
				$doctoRelacionado->ImpSaldoAnt = $documentoRelacionado ['saldoAnterior'];
				$doctoRelacionado->ImpPagado = $documentoRelacionado ['pago'];
				$doctoRelacionado->ImpSaldoInsoluto = $documentoRelacionado ['saldoInsoluto'];

				$pagoObj->documentosRelacionado [] = $doctoRelacionado;
			}

			$datosFactura->pagos [] = $pagoObj;
		}

		$datosFactura->totalImpRetenidos = $totalImpRetenidos;
		$datosFactura->totalImpTrasladados = $totalImpTrasladados;

		$datosFactura->facturasRelacionadas = [ ];

		if (count ( $factura ['facturasRelacionadas'] ['uuids'] ))
			foreach ( $factura ['facturasRelacionadas'] ['uuids'] as $facturaRelacionada ) {

				$relacionObj = new \stdClass ();
				$relacionObj->uuid = $facturaRelacionada ['uUID'];
				$datosFactura->facturasRelacionadas [] = $relacionObj;
			}

		$xml = XMLUtils::createXML33 ( $datosFactura, $proveedor );

		$sello = $xml->query ( '//cfdi:Comprobante' ) [0]->getAttribute ( 'Sello' );

		$nombreArchivo = "$proveedor->rFCEmisor-" . date ( 'YmdHis' );

		file_put_contents ( "tmp/$nombreArchivo.xml", $xml );

		$urlTimbrado = "https://facturacion.finkok.com/servicios/soap/stamp.wsdl";
		$usuarioInt = "saul.flores@soliat.com";
		$passwordInt = "S3rgio.Fl0res";

		if ($proveedor->id_proveedor == 1089) {

			$urlTimbrado = "https://demo-facturacion.finkok.com/servicios/soap/stamp.wsdl";
			$usuarioInt = "saul.flores@soliat.com";
			$passwordInt = "S3rgio.Fl0res";
		}

		$params = array ();
		$params ['xml'] = $xml;
		$params ['username'] = $usuarioInt;
		$params ['password'] = $passwordInt;

		$client = new SoapClient ( $urlTimbrado, array (
				'encoding' => 'UTF-8',
				"connection_timeout" => 250
		) );
		$client->soap_defencoding = "UTF-8";
		$resultado = $client->__soapCall ( 'stamp', array (
				$params
		) );

		$logToSave = print_r ( $resultado, true );

		$log = env ( 'DIR_LOGS' ) . "/" . date ( "Y-m-d" ) . ".log";
		$fp = fopen ( $log, "a" );
		fwrite ( $fp, "\n\n===" . date ( "Y-m-d:H:i:s" ) . "\n\n" );
		fwrite ( $fp, "\n\n$nombreArchivo\n\n" );
		fwrite ( $fp, $logToSave );
		fwrite ( $fp, "\n\n===" );
		fclose ( $fp );

		$success = false;
		$errorCode = 0;
		$errortext = '';
		$facturaResult = '';

        if (is_object ( $resultado ) && isset ( $resultado->stampResult ) && isset ( $resultado->stampResult->xml ) && trim($resultado->stampResult->xml) != '' ) {

			$success = true;

			$xmlTimbrado = new \DOMDocument ( "1.0", "uft-8" );
			$xmlTimbrado->loadXML ( $resultado->stampResult->xml );

			$idDoc = new IdDoc ();

			$timbreFiscal = $xmlTimbrado->getElementsByTagName ( 'TimbreFiscalDigital' );

			foreach ( $timbreFiscal as $timbreFiscal ) {

				$fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );
				$fechaTimbradoArray = explode ( ".", $fechaTimbrado );

				$idDoc->version = $timbreFiscal->getAttribute ( 'Version' );
				$idDoc->fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );
				$idDoc->selloCFD = $timbreFiscal->getAttribute ( 'SelloCFD' );
				$idDoc->noCertificadoSAT = $timbreFiscal->getAttribute ( 'NoCertificadoSAT' );
				$idDoc->selloSAT = $timbreFiscal->getAttribute ( 'SelloSAT' );
				$idDoc->uUID = $timbreFiscal->getAttribute ( 'UUID' );
				$idDoc->sello = $sello;
				$idDoc->rfcProvCertif = $timbreFiscal->getAttribute ( 'RfcProvCertif' );
			}

			$facturaObj = new Factura ();
			$facturaObj->id_proveedor = $user ['id_proveedor'];
			$facturaObj->id_cliente = $factura ['id_cliente'] ['id_cliente'];
			$facturaObj->id_certificadoProveedor = $certificadoHaUsar->id;
			$facturaObj->nmbEmisor = $proveedor->nmbEmisor;
			$facturaObj->rFCEmisor = $proveedor->rFCEmisor;
			$facturaObj->nmbRecep = $factura ['id_cliente'] ['nmbRecep'];
			$facturaObj->rFCRecep = $factura ['id_cliente'] ['rFCRecep'];
			$facturaObj->regimenFiscal = $proveedor->regimenFiscal33;
			$facturaObj->timeStamp = $timeStamp;
			$facturaObj->noFactura = $noFactura->noFactura;
			$facturaObj->version = "3.3";
			$facturaObj->generadoPor = 4;
			$facturaObj->nota = (isset ( $factura ['comentario'] )) ? Utils::deleteExtraSpaces ( $factura ['comentario'] ) : '';
			$facturaObj->tipoDeComprobante = $factura ['tipoDocumento'];
			$facturaObj->precission = $factura ['decimales'];
			$facturaObj->status = 1;
			$facturaObj->save ();

			$idDoc->id_factura = $facturaObj->id_factura;
			$idDoc->serie = $factura ['serie'];
			$idDoc->folio = $noFactura->noFactura;
			$idDoc->formaPago = '';
			$idDoc->condicionesDePago = (isset ( $factura ['condicionesPago'] )) ? Utils::deleteExtraSpaces ( $factura ['condicionesPago'] ) : '';
			$idDoc->lugarExpedicion = Utils::deleteExtraSpaces ( $factura ['lugarExpedicion'] );
			$idDoc->usoCFDI = 'P01';
			$idDoc->metodoDePago = '';
			$idDoc->sello = $sello;
			$idDoc->tipoFacturasRelacionadas = $datosFactura->tipoFacturasRelacionadas;
			$idDoc->save ();

			$totales = new Totales ();
			$totales->id_factura = $facturaObj->id_factura;
			$totales->moneda = 'XXX';
			$totales->tipoCambio = 0;
			$totales->subTotal = 0;
			$totales->mntBase = 0;
			$totales->vlrPagar = 0;
			$totales->descuento = 0;
			$totales->save ();

			$detalles = array ();

			foreach ( $datosFactura->conceptos as $concepto ) {

				$conceptoObj = new Concepto ();
				$conceptoObj->clave = $concepto->clave;
				$conceptoObj->cdgItem = $concepto->cdgItem;
				$conceptoObj->dscItem = $concepto->dscItem;
				$conceptoObj->unmdItem = $concepto->unmdItem;
				$conceptoObj->qtyItem = $concepto->qtyItem;
				$conceptoObj->montoNetoItem = $concepto->montoNetoItem;
				$conceptoObj->prcNetoItem = $concepto->prcNetoItem;
				$conceptoObj->descuento = $concepto->descuento;
				$conceptoObj->id_factura = $facturaObj->id_factura;
				$conceptoObj->save ();

				foreach ( $concepto->impuestosTrasladados as $impuesto ) {

					$impuestoObj = new ExImpuestos ();
					$impuestoObj->base = $impuesto->base;
					$impuestoObj->factor = $impuesto->factor;
					$impuestoObj->tipoImp = $impuesto->tipoImp;
					$impuestoObj->tasaImp = $impuesto->tasaImp;
					$impuestoObj->tipo = $impuesto->tipo;
					$impuestoObj->montoImp = $impuesto->montoImp;
					$impuestoObj->id_detalle = $conceptoObj->id_detalle;
					$impuestoObj->save ();
				}

				foreach ( $concepto->impuestosRetenidos as $impuesto ) {

					$impuestoObj = new ExImpuestos ();
					$impuestoObj->base = $impuesto->base;
					$impuestoObj->factor = $impuesto->factor;
					$impuestoObj->tipoImp = $impuesto->tipoImp;
					$impuestoObj->tasaImp = $impuesto->tasaImp;
					$impuestoObj->tipo = $impuesto->tipo;
					$impuestoObj->montoImp = $impuesto->montoImp;
					$impuestoObj->id_detalle = $conceptoObj->id_detalle;
					$impuestoObj->save ();
				}
			}

			foreach ( $datosFactura->facturasRelacionadas as $facturaRelacionada ) {

				$facturaRelacionadaObj = new FacturasRelacionadas ();
				$facturaRelacionadaObj->id_factura = $facturaObj->id_factura;
				$facturaRelacionadaObj->uuid = $facturaRelacionada->uuid;
				$facturaRelacionadaObj->save ();
			}

			foreach ( $datosFactura->pagos as $pago ) {

                $pago->FechaPago = str_replace ('T', ' ', $pago->FechaPago);
                $pago->FechaPago = substr($pago->FechaPago, 0, 19);

				$pagoObj = new Pago ();
				$pagoObj->FechaPago = $pago->FechaPago;
				$pagoObj->FormaDePagoP = $pago->FormaDePagoP;
				$pagoObj->MonedaP = $pago->MonedaP;
				$pagoObj->TipoCambioP = $pago->TipoCambioP;
				$pagoObj->Monto = $pago->Monto;
				$pagoObj->banco = $pago->banco;
				$pagoObj->cuenta = $pago->cuenta;
                $pagoObj->rfcEmisorCtaBen = $pago->rfcEmisorCtaBen;
                $pagoObj->ctaBeneficiario = $pago->ctaBeneficiario;
                $pagoObj->noOperacion = $pago->noOperacion;
				$pagoObj->id_factura = $facturaObj->id_factura;
				$pagoObj->save ();

				foreach ( $pago->documentosRelacionado as $doctoRelacionado ) {

					$doctoRelacionadoObj = new DoctoRelacionado ();
					$doctoRelacionadoObj->IdDocumento = $doctoRelacionado->IdDocumento;
					$doctoRelacionadoObj->MonedaDR = $doctoRelacionado->MonedaDR;
					$doctoRelacionadoObj->TipoCambioDR = $doctoRelacionado->TipoCambioDR;
					$doctoRelacionadoObj->MetodoDePagoDR = $doctoRelacionado->MetodoDePagoDR;
					$doctoRelacionadoObj->NumParcialidad = $doctoRelacionado->NumParcialidad;
					$doctoRelacionadoObj->ImpSaldoAnt = $doctoRelacionado->ImpSaldoAnt;
					$doctoRelacionadoObj->ImpPagado = $doctoRelacionado->ImpPagado;
					$doctoRelacionadoObj->ImpSaldoInsoluto = $doctoRelacionado->ImpSaldoInsoluto;
					$doctoRelacionadoObj->id_pago = $pagoObj->id;
					$doctoRelacionadoObj->save ();

					if ($doctoRelacionadoObj->ImpSaldoInsoluto <= 0) {

						$idDocObj = IdDoc::where ( 'uUID', '=', $doctoRelacionado->IdDocumento )->with ( 'factura' )->first ();
						$facturaIdDoc = $idDocObj->factura;
						$facturaIdDoc->isPagado = 1;
						$facturaIdDoc->save ();
					}
				}
			}

			$facturaResult = $datosFactura->serie . $datosFactura->folio;
		} else {

            $errorCode = 10001;
            $errorMsg = 'Hubo un error al crear su factura. Vuelva a intentarlo.';

            if (is_object ( $resultado ) && isset ( $resultado->stampResult ) && isset ( $resultado->stampResult->Incidencias )
                && isset ( $resultado->stampResult->Incidencias->Incidencia )) {

                $errorMsg = $resultado->stampResult->Incidencias->Incidencia->MensajeIncidencia;
            }

			$errortext = $errorMsg;
		}

		return Response::json ( array (
				'success' => $success,
				'errorCode' => $errorCode,
				'errortext' => $errortext,
				'facturaResult' => $facturaResult
		) );
	}
	public function cancelarFacturaFinkok(Request $request) {
		$factura = $request->input ( 'factura' );
		$user = $request->input ( 'user' );

        $proveedor = Proveedor::with ( 'certificados' )
            ->where ( 'password', '=', $factura ['password'] )
            ->find ($user['id_proveedor']);

		$passCorrecto = false;
		$seraCancelado = false;
        $response = null;

		if (is_object ( $proveedor )) {

			$key_content = file_get_contents ( env ( 'DIR_CERTS' ) . "/" . $proveedor->certificados->keyPem );
			$cer_content = file_get_contents ( env ( 'DIR_CERTS' ) . "/" . $proveedor->certificados->cerPem );

			$username = 'saul.flores@soliat.com';
			$password = 'S3rgio.Fl0res';
			$taxpayer_id = $proveedor->rFCEmisor; // The RFC of the Emisor

			$url = "https://facturacion.finkok.com/servicios/soap/cancel.wsdl";
			if ($proveedor->id_proveedor == 1089) {
				$url = "https://demo-facturacion.finkok.com/servicios/soap/cancel.wsdl";
			}

            $client = new SoapClient ( $url, array('trace' => 1) );
            //$client = new SoapClient ( $url );

            $uuid = array(
                'UUID' => $factura ['uUID'],
                'Motivo' => $factura['motivo']);

            if($factura['motivo'] == '01')
                $uuid['FolioSustitucion'] = $factura['uuidReplace'];

            $uuids = array ( 'UUID' => $uuid
            );

            $params = array (
                "UUIDS" => $uuids,
                "username" => $username,
                "password" => $password,
                "taxpayer_id" => $taxpayer_id,
                "cer" => $cer_content,
                "key" => $key_content
            );


			$response = $client->__soapCall ( "cancel", array (
					$params
			) );




            //echo "REQUEST:\n" . $client->__getLastRequest() . "\n";

            /*
            echo "RESPONSE:\n" . $client->__getLastResponse() . "\n";
			*/

			$seraCancelado = false;

			if (is_object ( $response ) && isset ( $response->cancelResult ) && isset ( $response->cancelResult->Folios )
                && isset ( $response->cancelResult->Folios->Folio )
                && $response->cancelResult->Folios->Folio->UUID == $factura ['uUID']
                    && ($response->cancelResult->Folios->Folio->EstatusUUID == 201 || $response->cancelResult->Folios->Folio->EstatusUUID == 202 || $response->cancelResult->Folios->Folio->EstatusUUID == 798)) {
				$seraCancelado = true;

				$facturaObj = Factura::with('pagos.documentosRelacionado')->find($factura ['id_factura']);
				$facturaObj->status = 0;
				$facturaObj->save();

				if(count($facturaObj->pagos) > 0)
				foreach($facturaObj->pagos as $pago){
				    if(count($pago->documentosRelacionado) > 0)
				    foreach($pago->documentosRelacionado as $documentoRel){
				        $idDocObj = IdDoc::with('factura')->where('uUID','=',$documentoRel->IdDocumento)->first();
				        $tmpFactura = $idDocObj->factura;
				        $tmpFactura->isPagado = 0;
				        $tmpFactura->save();
				    }
				}
			}

			$passCorrecto = true;
		}

		return Response::json ( array (
			'success' => true,
			'passCorrecto' => $passCorrecto,
            'seraCancelado' => $seraCancelado,
            'response' => $response
		) );
	}
	public function cancelarFactura(Request $request) {
		$factura = $request->input ( 'factura' );
		$user = $request->input ( 'user' );

		$proveedor = Proveedor::with ( 'certificados' )->where ( 'password', '=', $factura ['password'] )->where ( 'rFCEmisor', '=', $user ['rfc'] )->first ();

		$passCorrecto = false;
		$seraCancelado = false;

		if (is_object ( $proveedor )) {

			$key_content = file_get_contents ( env ( 'DIR_CERTS' ) . "/" . $proveedor->certificados->keyPem );
			$cer_content = file_get_contents ( env ( 'DIR_CERTS' ) . "/" . $proveedor->certificados->cerPem );

			$username = 'saul.flores@soliat.com';
			$password = 'S3rgio.Fl0res';
			$taxpayer_id = $proveedor->rFCEmisor; // The RFC of the Emisor
			$invoices = array (
					$factura ['uUID']
			); // A list of UUIDs

			$url = "https://demo-facturacion.finkok.com/servicios/soap/cancel.wsdl";
			$client = new SoapClient ( $url );

			$uuids = array (
                'UUID' => $invoices,
                'Motivo' => $factura['motivo']
            );

			if($factura['motivo'] == '01')
			    $uuids['FolioSustitucion'] = $factura['uuid'];

			$params = array (
					"UUIDS" => $uuids,
					"username" => $username,
					"password" => $password,
					"taxpayer_id" => $taxpayer_id,
					"cer" => $cer_content,
					"key" => $key_content
			);
			$response = $client->__soapCall ( "cancel", array (
					$params
			) );

			echo "sergio";
			print_r($response);

			$seraCancelado = false;

			if (is_object ( $response ) && isset ( $response->cancelResult ) && isset ( $response->cancelResult->Folios ) && $response->cancelResult->Folios->Folio->UUID == $factura ['uUID']) {
				$seraCancelado = true;
				Factura::where ( 'id_factura', '=', $factura ['id_factura'] )->update ( [
						'status' => 0
				] );
			}

			$passCorrecto = true;
		}

		return Response::json ( array (
				'success' => true,
				'passCorrecto' => $passCorrecto,
				'seraCancelado' => $seraCancelado
		) );
	}
	public function timbrarNomina(Request $request) {
		ini_set ( 'default_socket_timeout', 300 );
		ini_set ( 'max_execution_time', 300 );
		set_time_limit ( 300 );

		$id_empleadoFac = $request->input ( 'id_empleadoFac' );
		$id_periodo = $request->input ( 'id_periodo' );
		$user = $request->input ( 'user' );

		$periodo = PeriodoNomina::find ( $id_periodo );
		$empleado = EmpleadoFac::with ( 'empleado.cliente', 'percepciones.tipopd', 'deducciones.tipopd', 'liquidacion' )->find ( $id_empleadoFac );
		$proveedor = Proveedor::find ( $user ['id_proveedor'] );
		$adicionalNomina = AdicionalNomina::find ( $user ['id_proveedor'] );

		$cliente = $empleado->empleado->cliente;

		$curp = '';
		if (is_object ( $proveedor->domicilio )) {
			$domicilio = $proveedor->domicilio;
			$curp = $domicilio->curp;
		}

        $textLess = '-65 minutes';
		if (in_array ( $user ['id_proveedor'], $this->rfcHorasAntes ))
			$textLess = '-70 hours';

		$timeStamp = date ( "Y-m-d H:i:s", strtotime ( $textLess ) );
		$noFactura = DB::select ( "SELECT MAX(noFactura) as noFactura FROM Factura f JOIN IdDoc i ON f.id_factura = i.id_factura WHERE id_proveedor = " . $user ['id_proveedor'] . " AND i.serie = '" . $adicionalNomina->serie . "'" ) [0];
		$noFactura->noFactura ++;
		$certificadoHaUsar = CertificadoProveedor::where ( 'id_proveedor', '=', $user ['id_proveedor'] )->where ( 'status', '=', 1 )->first ();

		if(!is_object($certificadoHaUsar)){
            return Response::json ( array (
                'success' => true,
                'errorCode' => 1015,
                'errortext' => "No se ha cargado ningún CSD, por favor vaya a la sección de Mis datos y cárguelo nuevamente.",
                'facturaResult' => date('Y-m-d H:i:s'),
                'nombreArchivo' => 'TMP'
            ) );
        }

        if(!is_object($empleado->cliente->domicilio) || empty($empleado->cliente->domicilio->codigoPostal)){

            return Response::json ( array (
                'success' => true,
                'errorCode' => 1016,
                'errortext' => "Es necesario dar de alta los datos fiscales del empleado como código postal y regimen fiscal.",
                'facturaResult' => date('Y-m-d H:i:s'),
                'nombreArchivo' => 'TMP'
            ) );

        }

		$totalDeduccion = 0;
		$totalImpuestosRetenidos = 0;
		$totalOtrasDeducciones = 0;

		$totalPercepcionGravado = 0;
		$totalPercepcionExcento = 0;
		$totalPercepciones = 0;
		$totalOtrosPagos = 0;
		$totalSueldos = 0;
		$totalSeparacionIndemnizacion = 0;
		$totalJubilacionPension = 0;

		$listadoPercepciones = [ ];
		$listadoDeducciones = [ ];
		$listadoOtrosPagos = [ ];
		$listadoIncapacidades = [ ];

		if (count ( $empleado->percepciones ) > 0)
			foreach ( $empleado->percepciones as $percepcion ) {

				if ($percepcion->tipopd->subTipo == 1) {

					$totalPercepcionExcento += $percepcion->importeExcento;
					$totalPercepcionGravado += $percepcion->importeGravado;

					if ($percepcion->tipopd->clave == '022' || $percepcion->tipopd->clave == '023' || $percepcion->tipopd->clave == '025') {
						$totalSeparacionIndemnizacion += $percepcion->importeExcento + $percepcion->importeGravado;
					} else if ($percepcion->tipopd->clave == '039' || $percepcion->tipopd->clave == '044') {
						$totalJubilacionPension += $percepcion->importeExcento + $percepcion->importeGravado;
					} else {
						$totalSueldos += $percepcion->importeExcento + $percepcion->importeGravado;
					}

					$listadoPercepciones [] = array (
							'TipoPercepcion' => $percepcion->tipopd->clave,
							'Clave' => $percepcion->tipopd->clave,
							'Concepto' => $percepcion->tipopd->descripcion,
							'ImporteGravado' => Utils::formatNumber ( $percepcion->importeGravado ),
							'ImporteExento' => Utils::formatNumber ( $percepcion->importeExcento ),
							'Dias' => $percepcion->noDiasHoras,
							'TipoHoras' => $percepcion->tipoHoras,
							'HorasExtra' => $percepcion->noHoras,
							'ImportePagado' => Utils::formatNumber ( $percepcion->importeExcento + $percepcion->importeGravado )
					);
				} else {

					$totalOtrosPagos += $percepcion->importeExcento + $percepcion->importeGravado;

					$listadoOtrosPagos [] = array (
							'TipoOtroPago' => $percepcion->tipopd->clave,
							'Clave' => $percepcion->tipopd->clave,
							'Concepto' => $percepcion->tipopd->descripcion,
							'Importe' => Utils::formatNumber ( $percepcion->importeGravado + $percepcion->importeExcento )
					);
				}
			}

		if (count ( $empleado->deducciones ) > 0)
			foreach ( $empleado->deducciones as $deduccion ) {

				if ($deduccion->id_tipoPercepcionDeduccion == 34) {
					// Incapacidades
					$listadoIncapacidades [] = array (
							'DiasIncapacidad' => $deduccion->noDiasHoras,
							'TipoIncapacidad' => $deduccion->tipoHoras,
							'ImporteMonetario' => Utils::formatNumber ( $deduccion->importeExcento + $deduccion->importeGravado )
					);
				}

				$totalDeduccion += $deduccion->importeExcento + $deduccion->importeGravado;

				if ($deduccion->tipopd->clave == '002') {
					$totalImpuestosRetenidos += $deduccion->importeExcento + $deduccion->importeGravado;
				} else {
					$totalOtrasDeducciones += $deduccion->importeExcento + $deduccion->importeGravado;
				}

				$listadoDeducciones [] = array (
						'TipoDeduccion' => $deduccion->tipopd->clave,
						'Clave' => $deduccion->tipopd->clave,
						'Concepto' => $deduccion->tipopd->descripcion,
						'Importe' => Utils::formatNumber ( $deduccion->importeExcento + $deduccion->importeGravado )
				);
			}

        $datosFactura = new \stdClass ();

        $datosFactura->liquidacion = null;
        if(is_object($empleado->liquidacion)){

            $liquidacionObj = $empleado->liquidacion;
            $liquidacionObj->totalPagado = isset($empleado['liquidacion']['totalPagado']) ? $empleado['liquidacion']['totalPagado'] : 0;
            $liquidacionObj->ultimoSueldoMensOrd = isset($empleado['liquidacion']['ultimoSueldoMensOrd']) ? $empleado['liquidacion']['ultimoSueldoMensOrd'] : 0;
            $liquidacionObj->numAniosServicio = isset($empleado['liquidacion']['numAniosServicio']) ? $empleado['liquidacion']['numAniosServicio'] : 0;
            $liquidacionObj->ingresoAcumulable = isset($empleado['liquidacion']['ingresoAcumulable']) ? $empleado['liquidacion']['ingresoAcumulable'] : 0;
            $liquidacionObj->ingresoNoAcumulable = isset($empleado['liquidacion']['ingresoNoAcumulable']) ? $empleado['liquidacion']['ingresoNoAcumulable'] : 0;
            $liquidacionObj->save();

            $datosFactura->liquidacion = $liquidacionObj;

        }

		$totalPercepciones = Utils::formatNumber ( $totalPercepcionGravado + $totalPercepcionExcento );
		$subTotal = $empleado->totalPercepciones = Utils::formatNumber ( $totalPercepciones + $totalOtrosPagos );
		$empleado->totalAPercibir = $subTotal - $totalDeduccion;


		$datosFactura->timeStamp = $timeStamp;
		$datosFactura->tipoDeComprobante = 'N';
		$datosFactura->serie = $adicionalNomina->serie;
		$datosFactura->folio = $noFactura->noFactura;
		$datosFactura->noCertificado = $certificadoHaUsar->noCertificado;
		$datosFactura->certificado = $certificadoHaUsar->certificado;
		$datosFactura->mntBase = $subTotal;
		$datosFactura->subtotal = $subTotal;
		$datosFactura->moneda = 'MXN';
		$datosFactura->total = $empleado->totalAPercibir;
		$datosFactura->formaPago = '';
		$datosFactura->condicionesDePago = '';
		$datosFactura->descuento = $totalDeduccion;
		$datosFactura->precission = 2;
		$datosFactura->tipoCambio = 1;
		$datosFactura->lugarExpedicion = $periodo->lugarExpedicion;
		$datosFactura->usoCFDI = 'CN01';
		$datosFactura->metodoDePago = 'PUE';
		$datosFactura->condicionesDePago = '';
		$datosFactura->tipoFacturasRelacionadas = '';
		$datosFactura->rFCEmisor = $proveedor->rFCEmisor;
		$datosFactura->nmbEmisor = $proveedor->nmbEmisor;
		$datosFactura->rFCRecep = $empleado->cliente->rFCRecep;
		$datosFactura->nmbRecep = $empleado->cliente->nmbRecep;
		$datosFactura->regimenFiscal = $proveedor->regimenFiscal33;
		$datosFactura->numRegIdTrib = '';
		$datosFactura->pais = '';
		$datosFactura->curp = $curp;
		$datosFactura->tipoPersona = $proveedor->tipoPersona;

        $datosFactura->regimenFiscal = $proveedor->regimenFiscal33;
        $datosFactura->regimenFiscalReceptor = $empleado->cliente->regimenFiscalReceptor;
        $datosFactura->domicilioFiscalReceptor = $empleado->cliente->domicilio->codigoPostal;
        $datosFactura->exportacion = '01';

		$datosFactura->facturasRelacionadas = [ ];
		$datosFactura->conceptos = [ ];
		$datosFactura->impuestosTrasladados = [ ];
		$datosFactura->impuestosRetenidos = [ ];
		$datosFactura->impuestosTrasladadosLcl = [ ];
		$datosFactura->impuestosTrasladadosLclTotal = 0;
		$datosFactura->impuestosRetenidosLcl = [ ];
		$datosFactura->impuestosRetenidosLclTotal = 0;

		$totalImpRetenidos = 0;
		$totalImpTrasladados = 0;

		$detalle = array (
				'clave' => '84111505',
				'codigo' => '',
				'nombre' => 'Pago de nómina',
				'unidad' => 'ACT',
				'qty' => 1,
				'precioU' => $subTotal,
				'descuento' => $totalDeduccion,
                'objetoImp' => '01'
		);
		$factura ['detalles'] = [ ];
		$factura ['detalles'] [] = $detalle;

		foreach ( $factura ['detalles'] as $detalle ) {

			$concepto = new \stdClass ();
			$concepto->clave = $detalle ['clave'];
			$concepto->cdgItem = Utils::deleteExtraSpaces ( $detalle ['codigo'] );
			$concepto->dscItem = Utils::deleteExtraSpaces ( $detalle ['nombre'] );
			$concepto->unmdItem = (isset ( $detalle ['unidad'] )) ? $detalle ['unidad'] : '';
			$concepto->qtyItem = $detalle ['qty'];
			$concepto->montoNetoItem = $detalle ['precioU'];
			$concepto->prcNetoItem = $detalle ['qty'] * $detalle ['precioU'];
			$concepto->descuento = $detalle ['descuento'];
            $concepto->objetoImp = $detalle ['objetoImp'];

			$concepto->impuestosTrasladados = [ ];
			$concepto->impuestosRetenidos = [ ];
			$datosFactura->conceptos [] = $concepto;
		}

		$nomina = array (
				'Version' => '1.2',
				'FechaPago' => $periodo->fechaPago,
				'FechaInicialPago' => $periodo->fechaInicio,
				'FechaFinalPago' => $periodo->fechaFin,
				'NumDiasPagados' => $empleado->noDiasPagados,
				'TipoNomina' => $periodo->TipoNomina,
				'TotalDeducciones' => Utils::formatNumber ( $totalDeduccion ),
				'TotalOtrosPagos' => Utils::formatNumber ( $totalOtrosPagos ),
				'TotalPercepciones' => $totalPercepciones,
				'Emisor' => array (
						'RegistroPatronal' => $adicionalNomina->registroPatronal
				),
				'Percepciones' => array (
						'totalPercepcion' => Utils::formatNumber ( $totalPercepcionGravado + $totalPercepcionExcento ),
						'totalPercepcionGravado' => $totalPercepcionGravado,
						'totalPercepcionExcento' => $totalPercepcionExcento,
						'totalSueldos' => $totalSueldos,
						'totalSeparacionIndemnizacion' => $totalSeparacionIndemnizacion,
						'totalJubilacionPension' => $totalJubilacionPension,
						'listadoPercepciones' => $listadoPercepciones
				),
				'Deducciones' => array (
						'totalDeduccion' => $totalDeduccion,
						'totalImpuestosRetenidos' => $totalImpuestosRetenidos,
						'totalOtrasDeducciones' => $totalOtrasDeducciones,
						'listadoDeducciones' => $listadoDeducciones
				),
				'OtrosPagos' => array (
						'listadoOtrosPagos' => $listadoOtrosPagos
				),
				'Incapacidades' => array (
						'listadoIncapacidades' => $listadoIncapacidades
				)
		);

		$receptorN = [ ];

		if (! empty ( $empleado->curp ))
			$receptorN ['Curp'] = trim ( $empleado->curp );

		if (! empty ( $empleado->tipoContrato ))
			$receptorN ['TipoContrato'] = trim ( $empleado->tipoContrato );

		if (! empty ( $empleado->id_catalogoRegimenContratacion )) {
			$rg = CatalogoRegimenContratacion::find ( $empleado->id_catalogoRegimenContratacion );
			$receptorN ['TipoRegimen'] = trim ( $rg->clave );
		}

		if (! empty ( $empleado->noEmpleado ))
			$receptorN ['NumEmpleado'] = trim ( $empleado->noEmpleado );

		if (! empty ( $empleado->periodicidadPago ))
			$receptorN ['PeriodicidadPago'] = trim ( $empleado->periodicidadPago );

		if (! empty ( $empleado->ClaveEntFed ))
			$receptorN ['ClaveEntFed'] = trim ( $empleado->ClaveEntFed );

		if (! empty ( $empleado->nss ))
			$receptorN ['NumSeguridadSocial'] = preg_replace ( '/\D/', '', trim ( $empleado->nss ) );

		if (! empty ( $empleado->fechaInicioRelLaboral ) && $empleado->fechaInicioRelLaboral != '0000-00-00')
			$receptorN ['FechaInicioRelLaboral'] = trim ( $empleado->fechaInicioRelLaboral );

		$datetime1 = new \DateTime ( $empleado->fechaInicioRelLaboral );
		$datetime2 = new \DateTime ( $periodo->fechaFin );
		$interval = $datetime1->diff ( $datetime2 );
		$antiguedad = $interval->format ( '%R%a' );
		$antiguedad = str_replace ( '+', '', $antiguedad );
		$antiguedad = $antiguedad / 7;
		$antiguedad = floor ( $antiguedad );

		if ($empleado->fechaInicioRelLaboral != null && $empleado->fechaInicioRelLaboral != "" && $empleado->fechaInicioRelLaboral != '0000-00-00' )
			$receptorN ['Antigüedad'] = "P" . $antiguedad . "W";

		if (! empty ( $empleado->puesto ))
			$receptorN ['Puesto'] = trim ( $empleado->puesto );

		if (! empty ( $empleado->salarioBase ))
			$receptorN ['SalarioBaseCotApor'] = Utils::formatNumber ( $empleado->salarioBase );

		if (! empty ( $empleado->salarioDiarioIntegrado ))
			$receptorN ['SalarioDiarioIntegrado'] = Utils::formatNumber ( $empleado->salarioDiarioIntegrado );

		if (! empty ( $empleado->id_catalogoRiesgoPuesto )) {
			$rg = CatalogoRiesgoPuesto::find ( $empleado->id_catalogoRiesgoPuesto );
			$receptorN ['RiesgoPuesto'] = trim ( $rg->clave );
		}

		$nomina ['Receptor'] = $receptorN;

		$datosFactura->nomina = $nomina;

		$xml = XMLUtils::createXML40 ( $datosFactura, $proveedor );

		$sello = $xml->query ( '//cfdi:Comprobante' ) [0]->getAttribute ( 'Sello' );

		$nombreArchivo = "$proveedor->rFCEmisor-" . date ( 'YmdHis' );

		file_put_contents ( "tmp/$nombreArchivo.xml", $xml );

		$urlTimbrado = "https://facturacion.finkok.com/servicios/soap/stamp.wsdl";
		$usuarioInt = "saul.flores@soliat.com";
		$passwordInt = "S3rgio.Fl0res";

		if ($proveedor->id_proveedor == 1089) {

			$urlTimbrado = "https://demo-facturacion.finkok.com/servicios/soap/stamp.wsdl";
			$usuarioInt = "saul.flores@soliat.com";
			$passwordInt = "S3rgio.Fl0res";
		}

		$params = array ();
		$params ['xml'] = $xml;
		$params ['username'] = $usuarioInt;
		$params ['password'] = $passwordInt;


        $client = new SoapClient ( $urlTimbrado, array (
            'encoding' => 'UTF-8',
            "connection_timeout" => 250
        ) );
        $client->soap_defencoding = "UTF-8";
        $resultado = $client->__soapCall ( 'stamp', array (
            $params
        ) );

        $logToSave = print_r ( $resultado, true );

        $log = env ( 'DIR_LOGS' ) . "/" . date ( "Y-m-d" ) . ".log";
        $fp = fopen ( $log, "a" );
        fwrite ( $fp, "\n\n===" . date ( "Y-m-d:H:i:s" ) . "\n\n" );
        fwrite ( $fp, "\n\n$nombreArchivo\n\n" );
        fwrite ( $fp, $logToSave );
        fwrite ( $fp, "\n\n===" );
        fclose ( $fp );


		$success = false;
		$errorCode = 0;
		$errortext = '';
		$facturaResult = '';

		if (is_object ( $resultado ) && isset ( $resultado->stampResult ) && isset ( $resultado->stampResult->xml ) && trim($resultado->stampResult->xml) != '' ) {
			$success = true;

			$xmlTimbrado = new \DOMDocument ( "1.0", "uft-8" );
			$xmlTimbrado->loadXML ( $resultado->stampResult->xml );

			$idDoc = new IdDoc ();

			$timbreFiscal = $xmlTimbrado->getElementsByTagName ( 'TimbreFiscalDigital' );

			foreach ( $timbreFiscal as $timbreFiscal ) {

				$fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );
				$fechaTimbradoArray = explode ( ".", $fechaTimbrado );

				$idDoc->version = $timbreFiscal->getAttribute ( 'Version' );
				$idDoc->fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );
				$idDoc->selloCFD = $timbreFiscal->getAttribute ( 'SelloCFD' );
				$idDoc->noCertificadoSAT = $timbreFiscal->getAttribute ( 'NoCertificadoSAT' );
				$idDoc->selloSAT = $timbreFiscal->getAttribute ( 'SelloSAT' );
				$idDoc->uUID = $timbreFiscal->getAttribute ( 'UUID' );
				$idDoc->sello = $sello;
				$idDoc->rfcProvCertif = $timbreFiscal->getAttribute ( 'RfcProvCertif' );
			}

			$facturaObj = new Factura ();
			$facturaObj->id_proveedor = $user ['id_proveedor'];
			$facturaObj->id_cliente = $empleado->id_cliente;
			$facturaObj->id_certificadoProveedor = $certificadoHaUsar->id;
			$facturaObj->nmbEmisor = $proveedor->nmbEmisor;
			$facturaObj->rFCEmisor = $proveedor->rFCEmisor;
			$facturaObj->nmbRecep = $datosFactura->nmbRecep;
			$facturaObj->rFCRecep = $datosFactura->rFCRecep;
			$facturaObj->regimenFiscal = $proveedor->regimenFiscal33;
			$facturaObj->timeStamp = $timeStamp;
			$facturaObj->noFactura = $noFactura->noFactura;
			$facturaObj->version = "4.0";
			$facturaObj->generadoPor = 4;
			$facturaObj->nota = '';
			$facturaObj->tipoDeComprobante = 'N';
			$facturaObj->precission = 2;
			$facturaObj->status = 1;
			$facturaObj->isPagado = 1;
			$facturaObj->numRegIdTrib = '';
			$facturaObj->pais = '';
            $facturaObj->regimenFiscalReceptor = $datosFactura->regimenFiscalReceptor;
            $facturaObj->exportacion = $datosFactura->exportacion;
            $facturaObj->domicilioFiscalReceptor = $datosFactura->domicilioFiscalReceptor;
			$facturaObj->save ();

			$empleado = EmpleadoFac::find ( $id_empleadoFac );
			$empleado->id_factura = $facturaObj->id_factura;
			$empleado->registroPatronal = $adicionalNomina->registroPatronal;
			$empleado->save ();

			$idDoc->id_factura = $facturaObj->id_factura;
			$idDoc->serie = $datosFactura->serie;
			$idDoc->folio = $noFactura->noFactura;
			$idDoc->formaPago = $datosFactura->formaPago;
			$idDoc->condicionesDePago = '';
			$idDoc->lugarExpedicion = $datosFactura->lugarExpedicion;
			$idDoc->usoCFDI = $datosFactura->usoCFDI;
			$idDoc->metodoDePago = $datosFactura->metodoDePago;
			$idDoc->sello = $sello;
			$idDoc->tipoFacturasRelacionadas = '';
			$idDoc->save ();

			$totales = new Totales ();
			$totales->id_factura = $facturaObj->id_factura;
			$totales->moneda = $datosFactura->moneda;
			$totales->tipoCambio = 1;
			$totales->subTotal = $datosFactura->subtotal;
			$totales->mntBase = $datosFactura->mntBase;
			$totales->vlrPagar = $datosFactura->total;
			$totales->descuento = $datosFactura->descuento;
			$totales->save ();

			$detalles = array ();

			foreach ( $datosFactura->conceptos as $concepto ) {

				$conceptoObj = new Concepto ();
				$conceptoObj->clave = $concepto->clave;
				$conceptoObj->cdgItem = $concepto->cdgItem;
				$conceptoObj->dscItem = $concepto->dscItem;
				$conceptoObj->unmdItem = $concepto->unmdItem;
				$conceptoObj->qtyItem = $concepto->qtyItem;
				$conceptoObj->montoNetoItem = $concepto->montoNetoItem;
				$conceptoObj->prcNetoItem = $concepto->prcNetoItem;
				$conceptoObj->descuento = $concepto->descuento;
                $conceptoObj->objetoImp = $concepto->objetoImp;
				$conceptoObj->id_factura = $facturaObj->id_factura;
				$conceptoObj->save ();
			}

			$facturaResult = $datosFactura->serie . $datosFactura->folio;
		} else {

			$errorCode = 10001;
			$errorMsg = 'Hubo un error al crear su factura. Vuelva a intentarlo.';

            $errorMsg = $resultado->stampResult->Incidencias->Incidencia->MensajeIncidencia;
            if($resultado->stampResult->Incidencias->Incidencia->CodigoError == 'CFDI40144'){
                $errorMsg = "El nombre de su cliente no corresponde al listado del SAT. Es necesario validarlo con su cliente o directamente en el SAT.";
                $errorCode = 10011;
            }else if($resultado->stampResult->Incidencias->Incidencia->CodigoError == 'CFDI33132' ||
                $resultado->stampResult->Incidencias->Incidencia->CodigoError == 'CFDI40143' ){
                $errorMsg = "El RFC de su cliente no existe en el SAT, favor de verificarlo";
            }else if($resultado->stampResult->Incidencias->Incidencia->CodigoError == '305' ){
                $errorMsg = "Su CSD (Certificado de sellos digitales) ha caducado, es necesario generar uno nuevo en el portal del SAT.
                    Una vez generado, vaya a la sección de Mis datos y cargue este nuevo CSD";
            }else if($resultado->stampResult->Incidencias->Incidencia->CodigoError == 'CFDI40138'){
                $errorMsg = "Hemos detectado que su nombre no se encontraba actualizado de acuerdo con los registros del SAT. Es necesario que vaya a la sección de Mis datos y lo actualice tal cual aparece en su constancia de situación fiscal";
                $errorCode = 10012;
            }else if($resultado->stampResult->Incidencias->Incidencia->CodigoError == 'CFDI40161'){
                $errorMsg = "El regimen fiscal del empleado debe ser siempre 605.";
                $errorCode = 10013;
            }else if($resultado->stampResult->Incidencias->Incidencia->CodigoError == 'CFDI40147'){
                $errorMsg = "El código postal de su cliente no es correcto, debebe pedir a su cliente le confirme el correcto o validarlo en el SAT ";
                $errorCode = 10013;
            }

			$errortext = $errorMsg;
		}

		return Response::json ( array (
				'success' => true,
				'errorCode' => $errorCode,
				'errortext' => $errortext,
				'facturaResult' => $facturaResult,
				'nombreArchivo' => $nombreArchivo
		) );
	}
	public function registrarUsuario(Request $request) {
		//$proveedores = Proveedor::where ( 'status', '=', 1 )->skip ( 900 )->take ( 200 )->get ();

		$id_proveedor = $request->input("id_proveedor");
		$proveedor = Proveedor::find($id_proveedor);


		echo "<pre>";
		//foreach ( $proveedores as $proveedor ) {

			// Username and Password, assigned by FINKOK
			$usuarioInt = "saul.flores@soliat.com";
			$passwordInt = "S3rgio.Fl0res";
			$taxpayer_id = $proveedor->rFCEmisor;

			$url = "https://facturacion.finkok.com/servicios/soap/registration.wsdl";
			$client = new SoapClient ( $url, array (
					'trace' => 1
			) );

			$params = array (
					"reseller_username" => $usuarioInt,
					"reseller_password" => $passwordInt,
					"taxpayer_id" => $taxpayer_id
			);
			$response = $client->__soapCall ( "add", array (
					$params
			) );
			print_r ( $response );
		//}
	}

	public function checkarStatusFactura(Request $request){

	    /*
	    $id_factura = $request->input ( 'id_factura' );
	    $user = $request->input ( 'user' );
	    */

	    $rfc = 'LAN7008173R5';
	    $id_factura = 269790;


	    $proveedor = Proveedor::where ( 'rFCEmisor', '=', $rfc )->first ();
	    $facturaObj = Factura::with('totales', 'iddoc')->find($id_factura);



	    $url = "https://demo-facturacion.finkok.com/servicios/soap/cancel.wsdl";
	    if ($proveedor->id_proveedor == 1089) {
	        $url = "https://demo-facturacion.finkok.com/servicios/soap/cancel.wsdl";
	    }

	    $username = 'saul.flores@soliat.com';
	    $password = 'S3rgio.Fl0res';

	    $client = new SoapClient ( $url );
	    $params = array (
	        "username" => $username,
	        "password" => $password,
	        "taxpayer_id" => $facturaObj->rFCEmisor,
	        "rtaxpayer_id" => $facturaObj->rFCRecep,
	        "uuid" => $facturaObj->iddoc->uUID,
	        "total" => Utils::formatNumber($facturaObj->totales->VlrPagar, 2),
	    );
	    $response = $client->__soapCall ( "get_sat_status", array (
	        $params

	    ) );

	}

    public function cancelarFacturaFinkokTmp(Request $request) {

        $proveedor = Proveedor::with ( 'certificados' )->find(1084);
        $uuid = "479A27C5-718E-4EA5-8247-C6CBEA61184D";

        $passCorrecto = false;
        $seraCancelado = false;

        if (is_object ( $proveedor )) {

            $key_content = file_get_contents ( env ( 'DIR_CERTS' ) . "/" . $proveedor->certificados->keyPem );
            $cer_content = file_get_contents ( env ( 'DIR_CERTS' ) . "/" . $proveedor->certificados->cerPem );

            $username = 'saul.flores@soliat.com';
            $password = 'S3rgio.Fl0res';
            $taxpayer_id = $proveedor->rFCEmisor; // The RFC of the Emisor
            $invoices = array (
                $uuid
            ); // A list of UUIDs

            $url = "https://facturacion.finkok.com/servicios/soap/cancel.wsdl";
            if ($proveedor->id_proveedor == 1089) {
                $url = "https://demo-facturacion.finkok.com/servicios/soap/cancel.wsdl";
            }

            $client = new SoapClient ( $url );
            $params = array (
                "UUIDS" => array (
                    'uuids' => $invoices
                ),
                "username" => $username,
                "password" => $password,
                "taxpayer_id" => $taxpayer_id,
                "cer" => $cer_content,
                "key" => $key_content
            );
            echo "<pre>";
            print_r($params);
            $response = $client->__soapCall ( "cancel", array (
                $params
            ) );

            print_r($response);

            $seraCancelado = false;

            if (is_object ( $response ) && isset ( $response->cancelResult ) && isset ( $response->cancelResult->Folios ) && $response->cancelResult->Folios->Folio->UUID == $uuid) {
                $seraCancelado = true;

                echo "si se canceló";
            }

            $passCorrecto = true;
        }

        return Response::json ( array (
            'success' => true,
            'passCorrecto' => $passCorrecto,
            'seraCancelado' => $seraCancelado
        ) );
    }




    public function facturar40(Request $request) {

        ini_set ( 'default_socket_timeout', 300 );
        ini_set ( 'max_execution_time', 300 );
        set_time_limit ( 300 );

        $factura = $request->input ( 'factura' );
        $user = $request->input ( 'user' );
        $proveedor = Proveedor::with('domicilio')->find ( $user ['id_proveedor'] );
        $nombreArchivo = '';

        $textLess = '-125 minutes';
        if (in_array ( $user ['id_proveedor'], $this->rfcHorasAntes ))
            $textLess = '-70 hours';

        $timeStamp = date ( "Y-m-d H:i:s", strtotime ( $textLess ) );
        $noFactura = DB::select ( "SELECT MAX(noFactura) as noFactura FROM Factura f JOIN IdDoc i ON f.id_factura = i.id_factura WHERE id_proveedor = " . $user ['id_proveedor'] . " AND i.serie = '" . $factura ['serie'] . "'" ) [0];
        $noFactura->noFactura ++;
        $certificadoHaUsar = CertificadoProveedor::where ( 'id_proveedor', '=', $user ['id_proveedor'] )->where ( 'status', '=', 1 )->first ();

        if(!is_object($certificadoHaUsar)){
            return Response::json ( array (
                'success' => false,
                'errorCode' => 1009,
                'errortext' => "El certificado CSD no fue configurado de forma correcta",
                'facturaResult' => "El certificado CSD no fue configurado de forma correcta",
                'nombreArchivo' => ""
            ) );
        }

        if($factura ['tipoDocumento'] == 'T'){
            $factura ['id_cliente'] ['rFCRecep'] = $proveedor->rFCEmisor;
            $factura ['id_cliente'] ['nmbRecep'] = $proveedor->nmbEmisor;
            $factura ['id_cliente'] ['regimenFiscalReceptor'] = $proveedor->regimenFiscal33;
            $factura ['id_cliente'] ['codigoPostal'] = Utils::deleteExtraSpaces ( $factura ['lugarExpedicion'] );
        }

        $datosFactura = new \stdClass ();
        $datosFactura->timeStamp = $timeStamp;
        $datosFactura->tipoDeComprobante = $factura ['tipoDocumento'];
        $datosFactura->serie = $factura ['serie'];
        $datosFactura->folio = $noFactura->noFactura;
        $datosFactura->noCertificado = $certificadoHaUsar->noCertificado;
        $datosFactura->certificado = $certificadoHaUsar->certificado;
        $datosFactura->mntBase = $factura ['base'];
        $datosFactura->subtotal = $factura ['subtotal'];
        $datosFactura->moneda = $factura ['moneda'];
        $datosFactura->total = $factura ['total'];
        $datosFactura->formaPago = $factura ['formaPago'];
        $datosFactura->descuento = $factura ['descuento'];
        $datosFactura->precission = $factura ['decimales'];
        $datosFactura->tipoCambio = $factura ['tipoCambio'];
        $datosFactura->lugarExpedicion = Utils::deleteExtraSpaces ( $factura ['lugarExpedicion'] );
        $datosFactura->usoCFDI = $factura ['usoCFDI'];
        $datosFactura->metodoDePago = $factura ['metodoDePago'];
        $datosFactura->condicionesDePago = (isset ( $factura ['condicionesPago'] )) ? Utils::deleteExtraSpaces ( $factura ['condicionesPago'] ) : '';
        $datosFactura->cuentaPredial = (isset ( $factura ['cuentaPredial'] )) ? Utils::deleteExtraSpaces ( $factura ['cuentaPredial'] ) : '';
        $datosFactura->tipoFacturasRelacionadas = $factura ['facturasRelacionadas'] ['tipoRelacion'];
        $datosFactura->rFCEmisor = $proveedor->rFCEmisor;
        $datosFactura->nmbEmisor = $proveedor->nmbEmisor;
        $datosFactura->rFCRecep = $factura ['id_cliente'] ['rFCRecep'];
        $datosFactura->nmbRecep = $factura ['id_cliente'] ['nmbRecep'];
        $datosFactura->regimenFiscalReceptor = $factura ['id_cliente'] ['regimenFiscalReceptor'];
        $datosFactura->domicilioFiscalReceptor = $factura ['id_cliente'] ['codigoPostal'];
        $datosFactura->exportacion = isset($factura ['isComercio']) && $factura ['isComercio'] == 1 ? '02' : '01';
        $datosFactura->regimenFiscal = $proveedor->regimenFiscal33;
        $datosFactura->numRegIdTrib = isset ( $factura ['numRegIdTrib'] ) ? $factura ['numRegIdTrib'] : '';
        $datosFactura->pais = isset ( $factura ['pais'] ) ? $factura ['pais'] : '';
        $datosFactura->tipoPersona = $proveedor->tipoPersona;

        $datosFactura->conceptos = [ ];
        $datosFactura->impuestosTrasladados = [ ];
        $datosFactura->impuestosRetenidos = [ ];
        $datosFactura->impuestosTrasladadosLcl = [ ];
        $datosFactura->impuestosTrasladadosLclTotal = 0;
        $datosFactura->impuestosRetenidosLcl = [ ];
        $datosFactura->impuestosRetenidosLclTotal = 0;
        $totalImpRetenidos = 0;
        $totalImpTrasladados = 0;
        $mercanciasComercio = array();
        $totalUSDComercio = 0;

        foreach ( $factura ['detalles'] as $detalle ) {

            $concepto = new \stdClass ();
            $concepto->clave = $detalle ['clave'];
            $concepto->id_producto = isset ( $detalle ['id_producto'] ) ? $detalle ['id_producto'] : 0;
            $concepto->cdgItem = Utils::deleteExtraSpaces ( $detalle ['codigo'] );
            $concepto->dscItem = Utils::deleteExtraSpaces ( $detalle ['nombre'] );
            $concepto->unmdItem = (isset ( $detalle ['unidad'] )) ? $detalle ['unidad'] : '';
            $concepto->fracArancelaria = (isset ( $detalle ['fracArancelaria'] )) ? $detalle ['fracArancelaria'] : '';
            $concepto->qtyItem = $detalle ['qty'];
            $concepto->peso = $detalle ['peso'] ?? 0;
            $concepto->montoNetoItem = $detalle ['precioU'];
            $concepto->prcNetoItem = $detalle ['qty'] * $detalle ['precioU'];
            $concepto->descuento = $detalle ['descuento'];
            $concepto->objetoImp = $detalle ['objetoImp'];


            if(isset($factura['isComercio']) && $factura['isComercio'] == 1) {

                $mercanciaObj = new \stdClass();
                $mercanciaObj->valorDolares = Utils::formatNumber($detalle['montoUSD']);
                $mercanciaObj->noIdentificacion = Utils::deleteExtraSpaces ( $detalle ['codigo'] );
                $mercanciaObj->fraccionArancelaria = $detalle['fraccionArancelaria'] ?? '';
                $mercanciaObj->cantidadAduana = $detalle['cantidadAduana'] ?? '';
                $mercanciaObj->unidadAduana = $detalle['unidadAduana'] ?? '';
                $mercanciaObj->valorUnitarioAduana = Utils::formatNumber($detalle['valorUnitarioAduana']);

                $totalUSDComercio += $mercanciaObj->valorDolares;

                $mercanciasComercio [] = $mercanciaObj;
            }

            $concepto->impuestosTrasladados = [ ];

            $base = Utils::formatNumber ( $detalle ['base'], $factura ['decimales'] );
            $baseTraslados = 0;
            foreach ( $factura ['impuestosTrasladados'] as $traslado ) {

                if ($traslado ['impuesto'] == 'XXX') {

                    $impuestoLcl = new \stdClass ();
                    $impuestoLcl->tipoImp = $traslado ['label'];
                    $impuestoLcl->tasaImp = $traslado ['valor'] * 100;
                    $impuestoLcl->tipo = 1;

                    $importeImp = 0;
                    if ($traslado ['factor'] == 'Tasa') {
                        $importeImp = $traslado ['total'];
                    } else if ($traslado ['factor'] == 'Cuota') {
                        $importeImp = $traslado ['valor'];
                    }

                    $importeImp = Utils::formatNumber ( $importeImp, 2 );

                    $impuestoLcl->montoImp = $importeImp;

                    $datosFactura->impuestosTrasladadosLclTotal += $importeImp;
                    $datosFactura->impuestosTrasladadosLcl [] = $impuestoLcl;
                } else {

                    $impuesto = new \stdClass ();
                    $impuesto->base = $base;
                    $impuesto->factor = $traslado ['factor'];
                    $impuesto->tipoImp = $traslado ['impuesto'];
                    $impuesto->tasaImp = $traslado ['valor'];
                    $impuesto->peso = $traslado ['peso'] ?? 0;
                    $impuesto->tipo = 1;

                    $importeImp = 0;
                    if ($traslado ['factor'] == 'Tasa') {
                        $importeImp = $traslado ['valor'] * $base;
                    } else if ($traslado ['factor'] == 'Cuota') {
                        $importeImp = $traslado ['valor'];
                    }

                    $roundDown = isset($factura ['truncar']) && $factura ['truncar'] == 1;

                    $importeImp = Utils::formatNumber ( $importeImp, 2, $roundDown );

                    $impuesto->montoImp = $importeImp;

                    $totalImpTrasladados += $importeImp;

                    $concepto->impuestosTrasladados [] = $impuesto;

                    $isNuevo = true;
                    if (count ( $datosFactura->impuestosTrasladados ) > 0)
                        foreach ( $datosFactura->impuestosTrasladados as $impuestoGeneral ) {

                            if ($impuesto->tipoImp == $impuestoGeneral->impuesto && $impuesto->factor == $impuestoGeneral->tipoFactor && $impuesto->tasaImp == $impuestoGeneral->tasaOCuota) {
                                $isNuevo = false;
                                $impuestoGeneral->importe += $impuesto->montoImp;
                                $impuestoGeneral->base += $impuesto->base;
                                break;
                            }
                        }

                    if ($isNuevo) {
                        $impuestoGeneral = new \stdClass ();
                        $impuestoGeneral->base = $impuesto->base;
                        $impuestoGeneral->importe = $impuesto->montoImp;
                        $impuestoGeneral->impuesto = $impuesto->tipoImp;
                        $impuestoGeneral->tipoFactor = $traslado ['factor'];
                        $impuestoGeneral->tasaOCuota = $traslado ['valor'];
                        $datosFactura->impuestosTrasladados [] = $impuestoGeneral;
                    }

                }
            }

            $concepto->impuestosRetenidos = [ ];

            foreach ( $factura ['impuestosRetenidos'] as $retencion ) {

                if ($retencion ['impuesto'] == 'XXX') {

                    $impuestoLcl = new \stdClass ();
                    $impuestoLcl->tipoImp = $retencion ['label'];

                    if ($retencion ['factor'] == 'Cuota') {
                        $impuestoLcl->tasaImp = 0.00;
                    }else{
                        $impuestoLcl->tasaImp = $retencion ['valor'] * 100;
                    }

                    $impuestoLcl->tipo = 0;

                    $importeImp = 0;
                    if ($retencion ['factor'] == 'Tasa') {
                        $importeImp = $retencion ['valor'] * $base;
                    } else if ($retencion ['factor'] == 'Cuota') {
                        $importeImp = $retencion ['total'];
                    }

                    $importeImp = Utils::formatNumber ( $importeImp, 2 );

                    $impuestoLcl->montoImp = $importeImp;

                    $datosFactura->impuestosRetenidosLclTotal += $importeImp;
                    $datosFactura->impuestosRetenidosLcl [] = $impuestoLcl;
                } else {

                    $impuesto = new \stdClass ();
                    $impuesto->base = $base;
                    $impuesto->factor = $retencion ['factor'];
                    $impuesto->tipoImp = $retencion ['impuesto'];
                    $impuesto->tasaImp = $retencion ['valor'];
                    $impuesto->tipo = 0;

                    $importeImp = 0;
                    if ($retencion ['factor'] == 'Tasa') {
                        $importeImp = $retencion ['valor'] * $impuesto->base;
                    } else if ($retencion ['factor'] == 'Cuota') {
                        $importeImp = $retencion ['valor'];
                    }

                    $roundDown = $factura ['truncar'] == 1;

                    $importeImp = Utils::formatNumber ( $importeImp, 2, $roundDown );

                    $impuesto->montoImp = $importeImp;

                    $totalImpRetenidos += $importeImp;

                    $concepto->impuestosRetenidos [] = $impuesto;

                    $isNuevo = true;
                    if (count ( $datosFactura->impuestosRetenidos ))
                        foreach ( $datosFactura->impuestosRetenidos as $impuestoGeneral ) {
                            if ($impuesto->tipoImp == $impuestoGeneral->impuesto) {
                                $isNuevo = false;
                                $impuestoGeneral->importe += $impuesto->montoImp;
                                break;
                            }
                        }

                    if ($isNuevo && $retencion ['factor'] != 'Exento') {
                        $impuestoGeneral = new \stdClass ();
                        $impuestoGeneral->importe = $impuesto->montoImp;
                        $impuestoGeneral->impuesto = $impuesto->tipoImp;
                        $datosFactura->impuestosRetenidos [] = $impuestoGeneral;
                    }
                }
            }

            if(isset($detalle['alumno']) && $detalle['alumno'] != null){
                $alumnoObj = new \stdClass ();
                $alumnoObj->curp = $detalle['alumno'] ['curp'];
                $alumnoObj->nombreAlumno = $detalle['alumno'] ['nombreAlumno'];
                $alumnoObj->autRVOE = $detalle['alumno'] ['autRVOE'];
                $alumnoObj->nivelEducativo = $detalle['alumno'] ['nivelEducativo'];
                $alumnoObj->rfcPago = $detalle['alumno'] ['rfcPago'];

                $concepto->alumno = $alumnoObj;
            }

            $datosFactura->conceptos [] = $concepto;
        }

        $datosFactura->totalImpRetenidos = $totalImpRetenidos;
        $datosFactura->totalImpTrasladados = $totalImpTrasladados;

        $datosFactura->facturasRelacionadas = [ ];

        if (count ( $factura ['facturasRelacionadas'] ['uuids'] ))
            foreach ( $factura ['facturasRelacionadas'] ['uuids'] as $facturaRelacionada ) {

                $relacionObj = new \stdClass ();
                $relacionObj->uuid = $facturaRelacionada ['uUID'];
                $relacionObj->tipoRelacion = $facturaRelacionada ['tipoRelacion'] ?? null;
                $datosFactura->facturasRelacionadas [] = $relacionObj;
            }

        $datosFactura->infGlobal = null;
            if($datosFactura->rFCRecep == "XAXX010101000" && $datosFactura->nmbRecep == 'PUBLICO EN GENERAL'){
                $informacionGlobal = new \stdClass ();
                $informacionGlobal->anio = $factura ['publico'] ['anio'];
                $informacionGlobal->meses = $factura ['publico'] ['meses'];
                $informacionGlobal->periodicidad = $factura ['publico'] ['periodicidad'];
                $datosFactura->infGlobal = $informacionGlobal;
            }


        $datosFactura->comercio = null;

        if(isset($factura['isComercio']) && $factura['isComercio'] == 1){

            $datosFactura->comercio = new \stdClass();

            $datosFactura->mercanciasComercio = $mercanciasComercio;

            $comercio = $factura['comercio'];

            $datosFactura->numRegIdTrib = Utils::deleteExtraSpaces($comercio['rfcExtranjero']);

            $comercioEObj = new \stdClass();
            $comercioEObj->Incoterm = $comercio['incoterm'];
            $comercioEObj->clavePedimento = $comercio['pedimento'];
            $comercioEObj->tipoOperacion = $comercio['tipoOperacion'];
            $comercioEObj->rfcExtranjero = $comercio['rfcExtranjero'];

            $comercioEObj->totalUSD = $totalUSDComercio;
            $comercioEObj->motivoTraslado = $comercio['motivoTraslado'];
            if(is_object($proveedor->domicilio)){
                $comercioEObj->curp = $proveedor->domicilio->curp;
            }else{
                $comercioEObj->curp = '';
            }

            $emisor = $comercio['emisor'];

            $domicilioEmisor = new \stdClass();
            $domicilioEmisor->calle = $emisor['calle'];
            $domicilioEmisor->nroExterior = isset($emisor['nroExterior'])?$emisor['nroExterior']:'';
            $domicilioEmisor->nroInterior = isset($emisor['nroInterior'])?$emisor['nroInterior']:'';
            $domicilioEmisor->colonia = isset($emisor['colonia'])?$emisor['colonia']:'';
            $domicilioEmisor->municipio = isset($emisor['municipio'])?$emisor['municipio'] : '';
            $domicilioEmisor->estado = $emisor['estado'];
            $domicilioEmisor->pais = $emisor['pais'];
            $domicilioEmisor->codigoPostal = $emisor['codigoPostal'];

            $receptor = $comercio['receptor'];

            $domicilioReceptor = new \stdClass();
            $domicilioReceptor->calle = $receptor['calle'];
            $domicilioReceptor->nroExterior = isset($receptor['nroExterior'])? $receptor['nroExterior'] : '';
            $domicilioReceptor->nroInterior = isset($receptor['nroInterior'])? $receptor['nroInterior'] : '';
            $domicilioReceptor->colonia = isset($receptor['colonia'])? $receptor['colonia'] : '';
            $domicilioReceptor->municipio = isset($receptor['municipio'])? trim($receptor['municipio']) : '';
            $domicilioReceptor->estado = $receptor['estado'];
            $domicilioReceptor->pais = $receptor['pais'];
            $domicilioReceptor->codigoPostal = $receptor['codigoPostal'];


            $datosFactura->comercio->datos = $comercioEObj;
            $datosFactura->comercio->emisor = $domicilioEmisor;
            $datosFactura->comercio->receptor = $domicilioReceptor;

        }

        $datosFactura->cartaPorte = null;

        if(isset($factura['cartaPorte']) || !empty($factura['cartaPorte']['transpInternac'])){


            $idccp = Utils::getIDCCP($proveedor);


            $cartaPorteData = $factura['cartaPorte'];

            $cartaPorte = new \stdClass();
            $cartaPorte->transpInternac = $cartaPorteData['transpInternac'] ?? '';
            $cartaPorte->entradaSalidaMerc = $cartaPorteData['entradaSalidaMerc'] ?? '';
            $cartaPorte->paisOrigenDestino = $cartaPorteData['paisOrigenDestino'] ?? '';
            $cartaPorte->viaEntradaSalida = $cartaPorteData['viaEntradaSalida'] ?? '';
            $cartaPorte->pesoBrutoTotal = $cartaPorteData['pesoBrutoTotal'] ?? 0;
            $cartaPorte->unidadPeso = $cartaPorteData['unidadPeso'] ?? 0;
            $cartaPorte->idccp = $idccp;


            $cartaPorte->mercancias = array();
            foreach ($cartaPorteData['mercancias'] as $mercanciaData){

                $mercancia = new \stdClass();
                $mercancia->claveUnidad = $mercanciaData['claveUnidad'] ?? '';
                $mercancia->bienesTransp = $mercanciaData['bienesTransp'] ?? '';
                $mercancia->cantidad = $mercanciaData['cantidad'] ?? 0;
                $mercancia->peso = $mercanciaData['peso'] ?? 0;
                $mercancia->descripcion = Utils::deleteExtraSpaces($mercanciaData['descripcion']);
                $mercancia->moneda = $mercanciaData['moneda'] ?? '';
                $mercancia->valorMercancia = $mercanciaData['valorMercancia'] ?? 0;
                $mercancia->fraccionArancelaria = $mercanciaData['fraccionArancelaria'] ?? '';
                $mercancia->pedimento = $mercanciaData['pedimento'] ?? '';

                $cartaPorte->mercancias[] = $mercancia;
            }

            $cartaPorte->autotransporte = null;

            if(isset($cartaPorteData['autotransporte']) && $cartaPorteData['viaEntradaSalida'] == '01'){


                $autotransporteData = $cartaPorteData['autotransporte'];
                $autotransporte = new \stdClass();
                $autotransporte->tipoPermiso = $autotransporteData['tipoPermiso'] ?? '';
                $autotransporte->noPermiso = $autotransporteData['noPermiso'] ?? '';
                $autotransporte->configTransporte = $autotransporteData['configTransporte'] ?? '';
                $autotransporte->anioModeloVM = $autotransporteData['anioModeloVM'] ?? '';
                $autotransporte->placaVM = $autotransporteData['placaVM'] ?? '';
                $autotransporte->aseguraRespCivil = $autotransporteData['aseguraRespCivil'] ?? '';
                $autotransporte->polizaRespCivil = $autotransporteData['polizaRespCivil'] ?? '';
                $autotransporte->pesoBrutoVehicular = $autotransporteData['pesoBrutoVehicular'] ?? '0.01';

                $cartaPorte->autotransporte = $autotransporte;


                $cartaPorte->autotransporte->remolques = null;

                if(isset($cartaPorteData['autotransporte']['remolques'])){

                    $remolques = array();
                    foreach ($cartaPorteData['autotransporte']['remolques'] as $remolquesData){
                        $remolque = new \stdClass();
                        $remolque->subTipoRem = $remolquesData['subTipoRem'] ?? '';
                        $remolque->placa = $remolquesData['placa'] ?? '';
                        $remolques [] = $remolque;
                    }

                    $cartaPorte->autotransporte->remolques = $remolques;
                }

            }

            $cartaPorte->ubicaciones = null;

            if(isset($cartaPorteData['ubicaciones'])){

                $totalDistanciaRecorrida = 0;

                $ubicaciones = array();
                foreach ($cartaPorteData['ubicaciones'] as $ubicacionData){


                    $ubicacionData['fechaHoraSalidaLlegada'] = date('Y-m-d\TH:i:s', strtotime($ubicacionData['fechaHoraSalidaLlegada']));

                    $ubicacion = new \stdClass();
                    $ubicacion->tipoUbicacion = $ubicacionData['tipoUbicacion'] ?? '';
                    $ubicacion->rFCRemitenteDestinatario = $ubicacionData['rFCRemitenteDestinatario'] ?? '';
                    $ubicacion->nombreDestinatario = $ubicacionData['nombreDestinatario'] ?? '';
                    $ubicacion->numRegIdTrib = $ubicacionData['numRegIdTrib'] ?? '';
                    $ubicacion->fechaHoraSalidaLlegada = $ubicacionData['fechaHoraSalidaLlegada'] ?? '';
                    $ubicacion->calle = $ubicacionData['calle'] ?? '';
                    $ubicacion->numeroExterior = $ubicacionData['numeroExterior'] ?? '';
                    $ubicacion->numeroInterior = $ubicacionData['numeroInterior'] ?? '';
                    $ubicacion->colonia = $ubicacionData['colonia'] ?? '';
                    $ubicacion->municipio = $ubicacionData['municipio'] ?? '';
                    $ubicacion->estado = $ubicacionData['estado'] ?? '';
                    $ubicacion->pais = $ubicacionData['pais'] ?? '';
                    $ubicacion->codigoPostal = $ubicacionData['codigoPostal'] ?? 0;
                    $ubicacion->totalDistRec = $ubicacionData['totalDistRec'] ?? 0;
                    $ubicacion->idUbicacion = $ubicacionData['idUbicacion'] ?? '';

                    $totalDistanciaRecorrida += $ubicacion->totalDistRec;
                    $ubicaciones [] = $ubicacion;
                }

                if($totalDistanciaRecorrida > 0)
                    $cartaPorte->totalDistanciaRecorrida = $totalDistanciaRecorrida;

                $cartaPorte->ubicaciones = $ubicaciones;
            }

            $cartaPorte->figurasTransporte = null;

            if(isset($cartaPorteData['figurasTransporte'])){

                $figurasTransporte = array();
                foreach ($cartaPorteData['figurasTransporte'] as $figuraTransporteData){
                    $figuraTransporte = new \stdClass();
                    $figuraTransporte->tipoFigura = $figuraTransporteData['tipoFigura'] ?? '';
                    $figuraTransporte->rFCFigura = $figuraTransporteData['rFCFigura'] ?? '';
                    $figuraTransporte->numLicencia = $figuraTransporteData['numLicencia'] ?? '';
                    $figuraTransporte->nombreFigura = $figuraTransporteData['nombreFigura'] ?? '';
                    $figuraTransporte->numRegIdTribFigura = $figuraTransporteData['numRegIdTribFigura'] ?? '';
                    $figuraTransporte->parteTransporte = $figuraTransporteData['parteTransporte'] ?? '';
                    $figuraTransporte->pais = $figuraTransporteData['pais'] ?? '';
                    $figuraTransporte->estado = $figuraTransporteData['estado'] ?? '';
                    $figuraTransporte->codigoPostal = $figuraTransporteData['codigoPostal'] ?? '';
                    $figurasTransporte [] = $figuraTransporte;
                }

                $cartaPorte->figurasTransporte = $figurasTransporte;
            }

            $datosFactura->cartaPorte = $cartaPorte;
        }

        //Leyendas fiscales
        if(!empty($factura['norma'])){
            $leyendaFiscal = new \stdClass();
            $leyendaFiscal->norma = trim($factura['norma']);
            $leyendaFiscal->leyenda = trim($factura['leyenda']);

            $datosFactura->norma = trim($factura['norma']);
            $datosFactura->leyenda = trim($factura['leyenda']);

        }

        //INE
        $datosFactura->ine = null;
        if(!empty($factura['ine']) && !empty($factura['ine']['tipoProceso'])){

            $ine = $factura['ine'];
            $ineObj = new \stdClass();
            $ineObj->tipoProceso = $ine['tipoProceso'];
            $ineObj->version = '1.1';
            $ineObj->ambito = $ine['ambito'];
            $ineObj->comite = $ine['comite'];
            $ineObj->claveEntidad = $ine['claveEntidad'];
            $ineObj->idContabilidad = $ine['idContabilidad'];

            $datosFactura->ine = $ineObj;
        }

        //INBURSA
        $datosFactura->inbursa = null;
        if(!empty($factura['inbursa']) && !empty($factura['inbursa']['deducible'])){

            $inbursa = $factura['inbursa'];
            $inbursaObj = new \stdClass();
            $inbursaObj->emisor = $inbursa['emisor'];
            $inbursaObj->numero = $inbursa['numero'];
            $inbursaObj->afectado = $inbursa['afectado'];
            $inbursaObj->deducible = $inbursa['deducible'];
            $inbursaObj->descuento = $inbursa['descuento'];
            $inbursaObj->manaoObra = $inbursa['manaoObra'];
            $inbursaObj->refacciones = $inbursa['refacciones'];
            $inbursaObj->fechaEntrega = date('Y-m-d', strtotime($inbursa['fechaEntrega']));

            $datosFactura->inbursa = $inbursaObj;
        }

        $datosFactura->addenda = null;
        if(isset($factura['addenda']) && isset($factura['id_addenda']['id_addenda'])){

            $addenda = new \stdClass();
            $addenda->Importe = $factura['addenda']['importe'];
            $addenda->PeriodoEnMeses = $factura['addenda']['period'];
            $addenda->Descripcion = $factura['addenda']['description'];

            $datosFactura->addenda = $addenda;
        }

        $xml = XMLUtils::createXML40 ( $datosFactura, $proveedor );

        $sello = $xml->query ( '//cfdi:Comprobante' ) [0]->getAttribute ( 'Sello' );

        $nombreArchivo = "$proveedor->rFCEmisor-" . date ( 'YmdHis' );

        file_put_contents ( "tmp/$nombreArchivo.xml", $xml );

        $urlTimbrado = "https://facturacion.finkok.com/servicios/soap/stamp.wsdl";
        $usuarioInt = "saul.flores@soliat.com";
        $passwordInt = "S3rgio.Fl0res";

        if ($proveedor->id_proveedor == 1089) {
            $urlTimbrado = "https://demo-facturacion.finkok.com/servicios/soap/stamp.wsdl";
        }

        $params = array ();
        $params ['xml'] = $xml;
        $params ['username'] = $usuarioInt;
        $params ['password'] = $passwordInt;

        $client = new SoapClient ( $urlTimbrado, array (
            'encoding' => 'UTF-8',
            "connection_timeout" => 250
        ) );
        $client->soap_defencoding = "UTF-8";
        $resultado = $client->__soapCall ( 'stamp', array (
            $params
        ) );

        $logToSave = print_r ( $resultado, true );

        $log = env ( 'DIR_LOGS' ) . "/" . date ( "Y-m-d" ) . ".log";
        $fp = fopen ( $log, "a" );
        fwrite ( $fp, "\n\n===" . date ( "Y-m-d:H:i:s" ) . "\n\n" );
        fwrite ( $fp, "\n\n$nombreArchivo\n\n" );
        fwrite ( $fp, $logToSave );
        fwrite ( $fp, "\n\n===" );
        fclose ( $fp );

        $success = false;
        $errorCode = 0;
        $errortext = '';
        $facturaResult = '';
        $extraInfo = '';

        if (is_object ( $resultado ) && isset ( $resultado->stampResult ) && isset ( $resultado->stampResult->UUID ) && !empty($resultado->stampResult->xml)) {
            $success = true;

            $xmlTimbrado = new \DOMDocument ( "1.0", "uft-8" );
            $xmlTimbrado->loadXML ( $resultado->stampResult->xml );

            $idDoc = new IdDoc ();

            $timbreFiscal = $xmlTimbrado->getElementsByTagName ( 'TimbreFiscalDigital' );

            foreach ( $timbreFiscal as $timbreFiscal ) {

                $fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );
                $fechaTimbradoArray = explode ( ".", $fechaTimbrado );

                $idDoc->version = $timbreFiscal->getAttribute ( 'Version' );
                $idDoc->fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );
                $idDoc->selloCFD = $timbreFiscal->getAttribute ( 'SelloCFD' );
                $idDoc->noCertificadoSAT = $timbreFiscal->getAttribute ( 'NoCertificadoSAT' );
                $idDoc->selloSAT = $timbreFiscal->getAttribute ( 'SelloSAT' );
                $idDoc->uUID = $timbreFiscal->getAttribute ( 'UUID' );
                $idDoc->sello = $sello;
                $idDoc->rfcProvCertif = $timbreFiscal->getAttribute ( 'RfcProvCertif' );
            }

            $isPagado = 0;
            if ($factura ['metodoDePago'] == 'PUE')
                $isPagado = 1;

            $clienteObj = Cliente::with('domicilio')->find($factura ['id_cliente'] ['id_cliente']);
            $domicilioObj = $clienteObj->domicilio;
            if(!is_object($domicilioObj)){
                $domicilioObj = new DomFiscalRcp();
                $domicilioObj->id_cliente = $factura ['id_cliente'] ['id_cliente'];
            }
            $clienteObj->tipoPersona = $factura ['id_cliente'] ['tipoPersona'];
            $clienteObj->regimenFiscalReceptor = $factura ['id_cliente'] ['regimenFiscalReceptor'];
            $clienteObj->nmbRecep = $factura ['id_cliente'] ['nmbRecep'];
            $clienteObj->metodoPago = $factura ['formaPago'];
            $clienteObj->save();

            $domicilioObj->codigoPostal = $factura ['id_cliente'] ['codigoPostal'];
            $domicilioObj->save();

            $facturaObj = new Factura ();
            $facturaObj->id_proveedor = $user ['id_proveedor'];
            $facturaObj->id_cliente = $factura ['id_cliente'] ['id_cliente'];
            $facturaObj->id_certificadoProveedor = $certificadoHaUsar->id;
            $facturaObj->nmbEmisor = $proveedor->nmbEmisor;
            $facturaObj->rFCEmisor = $proveedor->rFCEmisor;
            $facturaObj->nmbRecep = $factura ['id_cliente'] ['nmbRecep'];
            $facturaObj->rFCRecep = $factura ['id_cliente'] ['rFCRecep'];
            $facturaObj->regimenFiscal = $proveedor->regimenFiscal33;
            $facturaObj->timeStamp = $timeStamp;
            $facturaObj->noFactura = $noFactura->noFactura;
            $facturaObj->version = "4.0";
            $facturaObj->generadoPor = 4;
            $facturaObj->nota = (isset ( $factura ['comentario'] )) ? Utils::deleteExtraSpaces ( $factura ['comentario'] ) : '';
            $facturaObj->tipoDeComprobante = $factura ['tipoDocumento'];
            $facturaObj->precission = $factura ['decimales'];
            $facturaObj->status = 1;
            $facturaObj->isPagado = $isPagado;
            $facturaObj->numRegIdTrib = $datosFactura->numRegIdTrib;
            $facturaObj->pais = $datosFactura->pais;
            $facturaObj->regimenFiscalReceptor = $datosFactura->regimenFiscalReceptor;
            $facturaObj->exportacion = $datosFactura->exportacion;
            $facturaObj->domicilioFiscalReceptor = $datosFactura->domicilioFiscalReceptor;
            $facturaObj->numRegIdTrib = $datosFactura->numRegIdTrib;
            $facturaObj->save ();

            $idDoc->id_factura = $facturaObj->id_factura;
            $idDoc->serie = $factura ['serie'];
            $idDoc->folio = $noFactura->noFactura;
            $idDoc->formaPago = $factura ['formaPago'];
            $idDoc->condicionesDePago = (isset ( $factura ['condicionesPago'] )) ? Utils::deleteExtraSpaces ( $factura ['condicionesPago'] ) : '';
            $idDoc->lugarExpedicion = Utils::deleteExtraSpaces ( $factura ['lugarExpedicion'] );
            $idDoc->usoCFDI = $factura ['usoCFDI'];
            $idDoc->metodoDePago = $factura ['metodoDePago'];
            $idDoc->sello = $sello;
            $idDoc->tipoFacturasRelacionadas = $datosFactura->tipoFacturasRelacionadas;
            $idDoc->save ();

            $totales = new Totales ();
            $totales->id_factura = $facturaObj->id_factura;
            $totales->moneda = $factura ['moneda'];
            $totales->tipoCambio = $factura ['tipoCambio'];
            $totales->subTotal = $factura ['subtotal'];
            $totales->mntBase = $factura ['base'];
            $totales->vlrPagar = $factura ['total'];
            $totales->descuento = $factura ['descuento'];
            $totales->save ();

            $detalles = array ();

            foreach ( $datosFactura->conceptos as $concepto ) {

                $conceptoObj = new Concepto ();
                $conceptoObj->clave = $concepto->clave;
                $conceptoObj->cdgItem = $concepto->cdgItem;
                $conceptoObj->dscItem = $concepto->dscItem;
                $conceptoObj->unmdItem = $concepto->unmdItem;
                $conceptoObj->qtyItem = $concepto->qtyItem;
                $conceptoObj->montoNetoItem = $concepto->montoNetoItem;
                $conceptoObj->prcNetoItem = $concepto->prcNetoItem;
                $conceptoObj->descuento = $concepto->descuento;
                $conceptoObj->peso = $concepto->peso;
                $conceptoObj->fracArancelaria = $concepto->fracArancelaria;
                $conceptoObj->objetoImp = $concepto->objetoImp;
                $conceptoObj->id_factura = $facturaObj->id_factura;
                $conceptoObj->save ();

                if (isset ( $factura ['guardarProd'] ) && $factura ['guardarProd'] == true) {

                    if ($concepto->id_producto > 0) {
                        $concepto2Obj = Producto::find ( $concepto->id_producto );
                    } else {
                        $concepto2Obj = new Producto ();
                    }

                    $concepto2Obj->id_proveedor = $user ['id_proveedor'];
                    $concepto2Obj->clave = $concepto->clave;
                    $concepto2Obj->nombre = $concepto->dscItem;
                    $concepto2Obj->precioU = $concepto->montoNetoItem;
                    $concepto2Obj->unidad = $concepto->unmdItem;
                    $concepto2Obj->codigo = $concepto->cdgItem;
                    $concepto2Obj->objetoImp = $concepto->objetoImp;
                    $concepto2Obj->status = 1;
                    $concepto2Obj->save ();
                }

                foreach ( $concepto->impuestosTrasladados as $impuesto ) {

                    $impuestoObj = new ExImpuestos ();
                    $impuestoObj->base = $impuesto->base;
                    $impuestoObj->factor = $impuesto->factor;
                    $impuestoObj->tipoImp = $impuesto->tipoImp;
                    $impuestoObj->tasaImp = $impuesto->tasaImp;
                    $impuestoObj->tipo = $impuesto->tipo;
                    $impuestoObj->montoImp = $impuesto->montoImp;
                    $impuestoObj->id_detalle = $conceptoObj->id_detalle;
                    $impuestoObj->save ();
                }

                foreach ( $concepto->impuestosRetenidos as $impuesto ) {

                    $impuestoObj = new ExImpuestos ();
                    $impuestoObj->base = $impuesto->base;
                    $impuestoObj->factor = $impuesto->factor;
                    $impuestoObj->tipoImp = $impuesto->tipoImp;
                    $impuestoObj->tasaImp = $impuesto->tasaImp;
                    $impuestoObj->tipo = $impuesto->tipo;
                    $impuestoObj->montoImp = $impuesto->montoImp;
                    $impuestoObj->id_detalle = $conceptoObj->id_detalle;
                    $impuestoObj->save ();
                }

                if(isset($concepto->alumno) && $concepto->alumno != null){
                    $alumnoObj = new AlumnoDetalle();
                    $alumnoObj->id_detalle = $conceptoObj->id_detalle;
                    $alumnoObj->curp = $concepto->alumno->curp;
                    $alumnoObj->nombreAlumno = $concepto->alumno->nombreAlumno;
                    $alumnoObj->autRVOE = $concepto->alumno->autRVOE;
                    $alumnoObj->nivelEducativo = $concepto->alumno->nivelEducativo;
                    $alumnoObj->rfcPago = $concepto->alumno->rfcPago;
                    $alumnoObj->save();
                }
            }

            foreach ( $datosFactura->facturasRelacionadas as $facturaRelacionada ) {

                $facturaRelacionadaObj = new FacturasRelacionadas ();
                $facturaRelacionadaObj->id_factura = $facturaObj->id_factura;
                $facturaRelacionadaObj->uuid = $facturaRelacionada->uuid;
                $facturaRelacionadaObj->tipoRelacion = $facturaRelacionada->tipoRelacion != '' ? $facturaRelacionada->tipoRelacion : null;
                $facturaRelacionadaObj->save ();
            }

            if (count ( $datosFactura->impuestosRetenidosLcl ) > 0)
                foreach ( $datosFactura->impuestosRetenidosLcl as $impuesto ) {

                    $impuestoObj = new ExImpuestos ();
                    $impuestoObj->tipoImp = $impuesto->tipoImp;
                    $impuestoObj->tasaImp = $impuesto->tasaImp;
                    $impuestoObj->tipo = $impuesto->tipo;
                    $impuestoObj->montoImp = $impuesto->montoImp;
                    $impuestoObj->id_factura = $facturaObj->id_factura;
                    $impuestoObj->save ();
                }

            if (count ( $datosFactura->impuestosTrasladadosLcl ) > 0)
                foreach ( $datosFactura->impuestosTrasladadosLcl as $impuesto ) {

                    $impuestoObj = new ExImpuestos ();
                    $impuestoObj->tipoImp = $impuesto->tipoImp;
                    $impuestoObj->tasaImp = $impuesto->tasaImp;
                    $impuestoObj->tipo = $impuesto->tipo;
                    $impuestoObj->montoImp = $impuesto->montoImp;
                    $impuestoObj->id_factura = $facturaObj->id_factura;
                    $impuestoObj->save ();
                }

            if ($datosFactura->cuentaPredial != '') {

                $arrendamiento = new Arrendamiento ();
                $arrendamiento->id_factura = $facturaObj->id_factura;
                $arrendamiento->cuentaPredial = $datosFactura->cuentaPredial;
                $arrendamiento->save ();
            }

            if($datosFactura->rFCRecep == "XAXX010101000" && $datosFactura->nmbRecep == 'PUBLICO EN GENERAL'){
                $informacionGlobalObj = new InformacionGlobal();
                $informacionGlobalObj->id_factura = $facturaObj->id_factura;
                $informacionGlobalObj->anio = $informacionGlobal->anio;
                $informacionGlobalObj->meses = $informacionGlobal->meses;
                $informacionGlobalObj->periodicidad = $informacionGlobal->periodicidad;
                $informacionGlobalObj->save();
            }

            //Leyendas fiscales
            if(!empty($factura['norma'])){
                $leyendaFiscalObj = new LeyendaFiscal();
                $leyendaFiscalObj->norma = $leyendaFiscal->norma;
                $leyendaFiscalObj->leyenda = $leyendaFiscal->leyenda;
                $leyendaFiscalObj->id_factura = $facturaObj->id_factura;
                $leyendaFiscalObj->save();
            }


            if($datosFactura->comercio != null){

                $comercioEObjS = new ComercioE();
                $comercioEObjS->id_factura = $facturaObj->id_factura;
                $comercioEObjS->Incoterm = $datosFactura->comercio->datos->Incoterm;
                $comercioEObjS->clavePedimento = $datosFactura->comercio->datos->clavePedimento;
                $comercioEObjS->tipoOperacion = $datosFactura->comercio->datos->tipoOperacion;
                $comercioEObjS->rfcExtranjero = $datosFactura->comercio->datos->rfcExtranjero;
                $comercioEObjS->curp = $datosFactura->comercio->datos->curp;
                $comercioEObjS->motivoTraslado = $datosFactura->comercio->datos->motivoTraslado;
                $comercioEObjS->totalUSD = $datosFactura->comercio->datos->totalUSD;
                $comercioEObjS->save();

                $emisor = $comercio['emisor'];

                $domicilioEmisorObjS = new DomFiscalFact();
                $domicilioEmisorObjS->id_factura = $facturaObj->id_factura;
                $domicilioEmisorObjS->calle = $datosFactura->comercio->emisor->calle;
                $domicilioEmisorObjS->nroExterior = $datosFactura->comercio->emisor->nroExterior;
                $domicilioEmisorObjS->nroInterior = $datosFactura->comercio->emisor->nroInterior;
                $domicilioEmisorObjS->colonia = $datosFactura->comercio->emisor->colonia;
                $domicilioEmisorObjS->municipio = $datosFactura->comercio->emisor->municipio;
                $domicilioEmisorObjS->estado = $datosFactura->comercio->emisor->estado;
                $domicilioEmisorObjS->pais = $datosFactura->comercio->emisor->pais;
                $domicilioEmisorObjS->codigoPostal = $datosFactura->comercio->emisor->codigoPostal;
                $domicilioEmisorObjS->save();


                $domicilioReceptorObjS = new DomFiscalRcpFact();
                $domicilioReceptorObjS->id_factura = $facturaObj->id_factura;
                $domicilioReceptorObjS->calle = $datosFactura->comercio->receptor->calle;
                $domicilioReceptorObjS->nroExterior = $datosFactura->comercio->receptor->nroExterior;
                $domicilioReceptorObjS->nroInterior = $datosFactura->comercio->receptor->nroInterior;
                $domicilioReceptorObjS->colonia = $datosFactura->comercio->receptor->colonia;
                $domicilioReceptorObjS->municipio = $datosFactura->comercio->receptor->municipio;
                $domicilioReceptorObjS->estado = $datosFactura->comercio->receptor->estado;
                $domicilioReceptorObjS->pais = $datosFactura->comercio->receptor->pais;
                $domicilioReceptorObjS->codigoPostal = $datosFactura->comercio->receptor->codigoPostal;
                $domicilioReceptorObjS->save();

                foreach ($datosFactura->mercanciasComercio as $marcancia){

                    $mercanciaObj = new MercanciaComercio();
                    $mercanciaObj->id_factura = $facturaObj->id_factura;
                    $mercanciaObj->noIdentificacion = $marcancia->noIdentificacion;
                    $mercanciaObj->fraccionArancelaria = $marcancia->fraccionArancelaria;
                    $mercanciaObj->cantidadAduana = $marcancia->cantidadAduana;
                    $mercanciaObj->unidadAduana = $marcancia->unidadAduana;
                    $mercanciaObj->valorUnitarioAduana = $marcancia->valorUnitarioAduana;
                    $mercanciaObj->valorDolares = $marcancia->valorDolares;
                    $mercanciaObj->save();

                }


            }


            if($datosFactura->cartaPorte != null){

                $cartaPorte = $datosFactura->cartaPorte;

                $cartaPorteObj = new CartaPorte();
                $cartaPorteObj->id_factura = $facturaObj->id_factura;
                $cartaPorteObj->transpInternac = $cartaPorte->transpInternac;
                $cartaPorteObj->entradaSalidaMerc = $cartaPorte->entradaSalidaMerc;
                $cartaPorteObj->paisOrigenDestino = $cartaPorte->paisOrigenDestino;
                $cartaPorteObj->viaEntradaSalida = $cartaPorte->viaEntradaSalida;
                $cartaPorteObj->pesoBrutoTotal = $cartaPorte->pesoBrutoTotal;
                $cartaPorteObj->unidadPeso = $cartaPorte->unidadPeso;
                $cartaPorteObj->idccp = $cartaPorte->idccp;
                $cartaPorteObj->numTotalMercancias = count($cartaPorte->mercancias);
                $cartaPorteObj->save();

                foreach ($cartaPorte->mercancias as $mercanciaData){
                    $mercanciaObj = new Mercancia();
                    $mercanciaObj->id_cartaPorte = $cartaPorteObj->id;
                    $mercanciaObj->claveUnidad = $mercanciaData->claveUnidad;
                    $mercanciaObj->bienesTransp = $mercanciaData->bienesTransp;
                    $mercanciaObj->cantidad = $mercanciaData->cantidad;
                    $mercanciaObj->peso = $mercanciaData->peso;
                    $mercanciaObj->descripcion = $mercanciaData->descripcion;
                    $mercanciaObj->moneda = $mercanciaData->moneda;
                    $mercanciaObj->valorMercancia = $mercanciaData->valorMercancia;
                    $mercanciaObj->fraccionArancelaria = $mercanciaData->fraccionArancelaria;
                    $mercanciaObj->pedimento = $mercanciaData->pedimento;
                    $mercanciaObj->save();
                }

                if($cartaPorte->autotransporte != null){

                    $autotransporte = $cartaPorte->autotransporte;

                    $autotransporteObj = new Autotransporte();
                    $autotransporteObj->id_cartaPorte = $cartaPorteObj->id;
                    $autotransporteObj->tipoPermiso = $autotransporte->tipoPermiso;
                    $autotransporteObj->noPermiso = $autotransporte->noPermiso;
                    $autotransporteObj->configTransporte = $autotransporte->configTransporte;
                    $autotransporteObj->anioModeloVM = $autotransporte->anioModeloVM;
                    $autotransporteObj->placaVM = $autotransporte->placaVM;
                    $autotransporteObj->aseguraRespCivil = $autotransporte->aseguraRespCivil;
                    $autotransporteObj->polizaRespCivil = $autotransporte->polizaRespCivil;
                    $autotransporteObj->pesoBrutoVehicular = $autotransporte->pesoBrutoVehicular;
                    $autotransporteObj->save();

                    if (isset ( $factura ['guardarProd'] ) && $factura ['guardarProd'] == true) {
                        $autotransporteObj = new AutotransporteBase();
                        $autotransporteObj->id_proveedor = $user ['id_proveedor'];
                        $autotransporteObj->tipoPermiso = $autotransporte->tipoPermiso;
                        $autotransporteObj->noPermiso = $autotransporte->noPermiso;
                        $autotransporteObj->configTransporte = $autotransporte->configTransporte;
                        $autotransporteObj->anioModeloVM = $autotransporte->anioModeloVM;
                        $autotransporteObj->placaVM = $autotransporte->placaVM;
                        $autotransporteObj->aseguraRespCivil = $autotransporte->aseguraRespCivil;
                        $autotransporteObj->polizaRespCivil = $autotransporte->polizaRespCivil;
                        $autotransporteObj->pesoBrutoVehicular = $autotransporte->pesoBrutoVehicular;
                        $autotransporteObj->save();
                    }

                    if($autotransporte->remolques != null){
                        foreach ($autotransporte->remolques as $remolque){
                            $remolquesObj = new Remolque();
                            $remolquesObj->id_cartaPorte = $cartaPorteObj->id;
                            $remolquesObj->subTipoRem = $remolque->subTipoRem;
                            $remolquesObj->placa = $remolque->placa;
                            $remolquesObj->save();
                        }
                    }

                }

                if($cartaPorte->ubicaciones != null){
                    foreach ($cartaPorte->ubicaciones as $ubicacion){
                        $ubicacionObj = new Ubicacion();
                        $ubicacionObj->id_cartaPorte = $cartaPorteObj->id;
                        $ubicacionObj->tipoUbicacion = $ubicacion->tipoUbicacion;
                        $ubicacionObj->rFCRemitenteDestinatario = $ubicacion->rFCRemitenteDestinatario;
                        $ubicacionObj->nombreDestinatario = $ubicacion->nombreDestinatario;
                        $ubicacionObj->numRegIdTrib = $ubicacion->numRegIdTrib;
                        $ubicacionObj->fechaHoraSalidaLlegada = $ubicacion->fechaHoraSalidaLlegada;
                        $ubicacionObj->calle = $ubicacion->calle;
                        $ubicacionObj->numeroExterior = $ubicacion->numeroExterior;
                        $ubicacionObj->numeroInterior = $ubicacion->numeroInterior;
                        $ubicacionObj->colonia = $ubicacion->colonia;
                        $ubicacionObj->municipio = $ubicacion->municipio;
                        $ubicacionObj->estado = $ubicacion->estado;
                        $ubicacionObj->pais = $ubicacion->pais;
                        $ubicacionObj->codigoPostal = $ubicacion->codigoPostal;
                        $ubicacionObj->totalDistRec = $ubicacion->totalDistRec;
                        $ubicacionObj->idUbicacion = $ubicacion->idUbicacion;
                        $ubicacionObj->save();


                        if (isset ( $factura ['guardarProd'] ) && $factura ['guardarProd'] == true) {
                            $ubicacionBaseObj = new UbicacionBase();
                            $ubicacionBaseObj->id_proveedor = $user ['id_proveedor'];
                            $ubicacionBaseObj->tipoUbicacion = $ubicacion->tipoUbicacion;
                            $ubicacionBaseObj->rFCRemitenteDestinatario = $ubicacion->rFCRemitenteDestinatario;
                            $ubicacionBaseObj->nombreDestinatario = $ubicacion->nombreDestinatario;
                            $ubicacionBaseObj->numRegIdTrib = $ubicacion->numRegIdTrib;
                            $ubicacionBaseObj->fechaHoraSalidaLlegada = $ubicacion->fechaHoraSalidaLlegada;
                            $ubicacionBaseObj->calle = $ubicacion->calle;
                            $ubicacionBaseObj->numeroExterior = $ubicacion->numeroExterior;
                            $ubicacionBaseObj->numeroInterior = $ubicacion->numeroInterior;
                            $ubicacionBaseObj->colonia = $ubicacion->colonia;
                            $ubicacionBaseObj->municipio = $ubicacion->municipio;
                            $ubicacionBaseObj->estado = $ubicacion->estado;
                            $ubicacionBaseObj->pais = $ubicacion->pais;
                            $ubicacionBaseObj->codigoPostal = $ubicacion->codigoPostal;
                            $ubicacionBaseObj->totalDistRec = $ubicacion->totalDistRec;
                            $ubicacionBaseObj->idUbicacion = $ubicacion->idUbicacion;
                            $ubicacionBaseObj->save();
                        }
                    }
                }

                if($cartaPorte->figurasTransporte != null){
                    foreach ($cartaPorte->figurasTransporte as $figuras){
                        $figuraTransporteObj = new FigurasTransporte();
                        $figuraTransporteObj->id_cartaPorte = $cartaPorteObj->id;
                        $figuraTransporteObj->tipoFigura = $figuras->tipoFigura;
                        $figuraTransporteObj->rFCFigura = $figuras->rFCFigura;
                        $figuraTransporteObj->numLicencia = $figuras->numLicencia;
                        $figuraTransporteObj->nombreFigura = $figuras->nombreFigura;
                        $figuraTransporteObj->numRegIdTribFigura = $figuras->numRegIdTribFigura;
                        $figuraTransporteObj->parteTransporte = $figuras->parteTransporte;
                        $figuraTransporteObj->pais = $figuras->pais;
                        $figuraTransporteObj->estado = $figuras->estado;
                        $figuraTransporteObj->codigoPostal = $figuras->codigoPostal;
                        $figuraTransporteObj->save();

                        if (isset ( $factura ['guardarProd'] ) && $factura ['guardarProd'] == true) {

                            $figuraTransporteObj = new FigurasTransporteBase();
                            $figuraTransporteObj->id_proveedor = $user ['id_proveedor'];
                            $figuraTransporteObj->tipoFigura = $figuras->tipoFigura;
                            $figuraTransporteObj->rFCFigura = $figuras->rFCFigura;
                            $figuraTransporteObj->numLicencia = $figuras->numLicencia;
                            $figuraTransporteObj->nombreFigura = $figuras->nombreFigura;
                            $figuraTransporteObj->numRegIdTribFigura = $figuras->numRegIdTribFigura;
                            $figuraTransporteObj->parteTransporte = $figuras->parteTransporte;
                            $figuraTransporteObj->pais = $figuras->pais;
                            $figuraTransporteObj->estado = $figuras->estado;
                            $figuraTransporteObj->codigoPostal = $figuras->codigoPostal;
                            $figuraTransporteObj->save();

                        }

                    }
                }

            }

            if($datosFactura->addenda != null){

                $addendaObj = new AddendaFondoGarantia();
                $addendaObj->id_factura = $facturaObj->id_factura;
                $addendaObj->Importe = $datosFactura->addenda->Importe;
                $addendaObj->PeriodoEnMeses = $datosFactura->addenda->PeriodoEnMeses;
                $addendaObj->Descripcion = $datosFactura->addenda->Descripcion;
                $addendaObj->save();

            }

            if($datosFactura->ine != null){

                $ineObj = new Ine();
                $ineObj->id_factura = $facturaObj->id_factura;
                $ineObj->tipoProceso = $datosFactura->ine->tipoProceso;
                $ineObj->version = $datosFactura->ine->version;
                $ineObj->ambito = $datosFactura->ine->ambito;
                $ineObj->comite = $datosFactura->ine->comite;
                $ineObj->claveEntidad = $datosFactura->ine->claveEntidad;
                $ineObj->idContabilidad = $datosFactura->ine->idContabilidad;
                $ineObj->save();

            }

            if($datosFactura->inbursa != null){

                $inbursa = $datosFactura->inbursa;

                $inbursaObj = new Inbursa();
                $inbursaObj->id_factura = $facturaObj->id_factura;
                $inbursaObj->emisor = $inbursa->emisor;
                $inbursaObj->numero = $inbursa->numero;
                $inbursaObj->afectado = $inbursa->afectado;
                $inbursaObj->deducible = $inbursa->deducible;
                $inbursaObj->descuento = $inbursa->descuento;
                $inbursaObj->manaoObra = $inbursa->manaoObra;
                $inbursaObj->refacciones = $inbursa->refacciones;
                $inbursaObj->fechaEntrega = date('Y-m-d', strtotime($inbursa->fechaEntrega));
                $inbursaObj->save();
            }


            $facturaResult = $datosFactura->serie . $datosFactura->folio;
        } else {

            $errorCode = 10001;
            $errorMsg = 'Hubo un error al crear su factura. Vuelva a intentarlo.';

            if (is_object ( $resultado ) && isset ( $resultado->stampResult ) && isset ( $resultado->stampResult->Incidencias )
                && isset ( $resultado->stampResult->Incidencias->Incidencia )) {

                $errorMsg = $resultado->stampResult->Incidencias->Incidencia->MensajeIncidencia;
                if($resultado->stampResult->Incidencias->Incidencia->CodigoError == 'CFDI40144'){
                    $errorMsg = "El nombre de su cliente no corresponde al listado del SAT. Es necesario validarlo con su cliente o directamente en el SAT.";
                    $errorCode = 10011;
                }else if($resultado->stampResult->Incidencias->Incidencia->CodigoError == 'CFDI33132' ||
                    $resultado->stampResult->Incidencias->Incidencia->CodigoError == 'CFDI40143' ){
                    $errorMsg = "El RFC de su cliente no existe en el SAT, favor de verificarlo";
                }else if($resultado->stampResult->Incidencias->Incidencia->CodigoError == '305' ){
                    $errorMsg = "Su CSD (Certificado de sellos digitales) ha caducado, es necesario generar uno nuevo en el portal del SAT.
                    Una vez generado, vaya a la sección de Mis datos y cargue este nuevo CSD";
                }else if($resultado->stampResult->Incidencias->Incidencia->CodigoError == 'CFDI40138'){
                    $errorMsg = "Hemos detectado que su nombre no se encontraba actualizado de acuerdo con los registros del SAT. Es necesario que vaya a la sección de Mis datos y lo actualice tal cual aparece en su constancia de situación fiscal";
                    $errorCode = 10012;
                }else if($resultado->stampResult->Incidencias->Incidencia->CodigoError == 'CFDI40161'){
                    $errorMsg = "El Uso del CFDI no es válido para el tipo de persona de su cliente, seleccione un uso diferente.";
                    $errorCode = 10013;
                }else if($resultado->stampResult->Incidencias->Incidencia->CodigoError == 'CFDI40147'){
                    $errorMsg = "El código postal de su cliente no es correcto, debebe pedir a su cliente le confirme el correcto o validarlo en el SAT ";
                    $errorCode = 10013;
                }
            }

            $errortext = $errorMsg;
        }

        return Response::json ( array (
            'success' => $success,
            'errorCode' => $errorCode,
            'errortext' => $errortext,
            'facturaResult' => $facturaResult,
            'nombreArchivo' => $nombreArchivo,
            'extraInfo' => $extraInfo
        ) );
    }


    public function facturarPorConcepto40(Request $request) {
        ini_set ( 'default_socket_timeout', 250 );

        $factura = $request->input ( 'factura' );
        $user = $request->input ( 'user' );
        $proveedor = Proveedor::with('domicilio')->find ( $user ['id_proveedor'] );
        $nombreArchivo = '';

        $textLess = '-125 minutes';
        if (in_array ( $user ['id_proveedor'], $this->rfcHorasAntes ))
            $textLess = '-70 hours';

        $timeStamp = date ( "Y-m-d H:i:s", strtotime ( $textLess ) );
        $noFactura = DB::select ( "SELECT MAX(noFactura) as noFactura FROM Factura f JOIN IdDoc i ON f.id_factura = i.id_factura WHERE id_proveedor = " . $user ['id_proveedor'] . " AND i.serie = '" . $factura ['serie'] . "'" ) [0];
        $noFactura->noFactura ++;
        $certificadoHaUsar = CertificadoProveedor::where ( 'id_proveedor', '=', $user ['id_proveedor'] )->where ( 'status', '=', 1 )->first ();

        if(!is_object($certificadoHaUsar)){
            return Response::json ( array (
                'success' => false,
                'errorCode' => 1009,
                'errortext' => "El certificado CSD no fue configurado de forma correcta",
                'facturaResult' => "El certificado CSD no fue configurado de forma correcta",
                'nombreArchivo' => ""
            ) );
        }

        $datosFactura = new \stdClass ();
        $datosFactura->timeStamp = $timeStamp;
        $datosFactura->tipoDeComprobante = $factura ['tipoDocumento'];
        $datosFactura->serie = $factura ['serie'];
        $datosFactura->folio = $noFactura->noFactura;
        $datosFactura->noCertificado = $certificadoHaUsar->noCertificado;
        $datosFactura->certificado = $certificadoHaUsar->certificado;
        $datosFactura->mntBase = $factura ['base'];
        $datosFactura->subtotal = $factura ['subtotal'];
        $datosFactura->moneda = $factura ['moneda'];
        $datosFactura->total = $factura ['total'];
        $datosFactura->formaPago = $factura ['formaPago'];
        $datosFactura->descuento = $factura ['descuento'];
        $datosFactura->precission = $factura ['decimales'];
        $datosFactura->tipoCambio = $factura ['tipoCambio'];
        $datosFactura->lugarExpedicion = Utils::deleteExtraSpaces ( $factura ['lugarExpedicion'] );
        $datosFactura->usoCFDI = $factura ['usoCFDI'];
        $datosFactura->metodoDePago = $factura ['metodoDePago'];
        $datosFactura->condicionesDePago = (isset ( $factura ['condicionesPago'] )) ? Utils::deleteExtraSpaces ( $factura ['condicionesPago'] ) : '';
        $datosFactura->cuentaPredial = (isset ( $factura ['cuentaPredial'] )) ? Utils::deleteExtraSpaces ( $factura ['cuentaPredial'] ) : '';
        $datosFactura->tipoFacturasRelacionadas = $factura ['facturasRelacionadas'] ['tipoRelacion'];
        $datosFactura->rFCEmisor = $proveedor->rFCEmisor;
        $datosFactura->nmbEmisor = $proveedor->nmbEmisor;
        $datosFactura->rFCRecep = $factura ['id_cliente'] ['rFCRecep'];
        $datosFactura->nmbRecep = $factura ['id_cliente'] ['nmbRecep'];
        $datosFactura->regimenFiscalReceptor = $factura ['id_cliente'] ['regimenFiscalReceptor'];
        $datosFactura->domicilioFiscalReceptor = $factura ['id_cliente'] ['codigoPostal'];
        $datosFactura->exportacion = $factura ['exportacion'];
        $datosFactura->regimenFiscal = $proveedor->regimenFiscal33;
        $datosFactura->numRegIdTrib = isset ( $factura ['numRegIdTrib'] ) ? $factura ['numRegIdTrib'] : '';
        $datosFactura->pais = isset ( $factura ['pais'] ) ? $factura ['pais'] : '';
        $datosFactura->tipoPersona = $proveedor->tipoPersona;

        $datosFactura->conceptos = [ ];
        $datosFactura->impuestosTrasladados = [ ];
        $datosFactura->impuestosRetenidos = [ ];
        $datosFactura->impuestosTrasladadosLcl = [ ];
        $datosFactura->impuestosTrasladadosLclTotal = 0;
        $datosFactura->impuestosRetenidosLcl = [ ];
        $datosFactura->impuestosRetenidosLclTotal = 0;
        $totalImpRetenidos = 0;
        $totalImpTrasladados = 0;

        foreach ( $factura ['detalles'] as $detalle ) {

            $concepto = new \stdClass ();
            $concepto->clave = $detalle ['clave'];
            $concepto->id_producto = isset ( $detalle ['id_producto'] ) ? $detalle ['id_producto'] : 0;
            $concepto->cdgItem = Utils::deleteExtraSpaces ( $detalle ['codigo'] );
            $concepto->dscItem = Utils::deleteExtraSpaces ( $detalle ['nombre'] );
            $concepto->unmdItem = (isset ( $detalle ['unidad'] )) ? $detalle ['unidad'] : '';
            $concepto->qtyItem = $detalle ['qty'];
            $concepto->montoNetoItem = $detalle ['precioU'];
            $concepto->prcNetoItem = $detalle ['qty'] * $detalle ['precioU'];
            $concepto->descuento = $detalle ['descuento'];
            $concepto->objetoImp = $detalle ['objetoImp'];

            $concepto->impuestosTrasladados = [ ];

            $base = Utils::formatNumber ( (($detalle ['qty'] * $detalle ['precioU']) - $detalle ['descuento']), $factura ['decimales'] );
            foreach ( $detalle ['impuestosTrasladados'] as $traslado ) {

                if ($traslado ['impuesto'] == 'XXX') {

                    $impuestoLcl = new \stdClass ();
                    $impuestoLcl->tipoImp = $traslado ['label'];
                    $impuestoLcl->tasaImp = $traslado ['valor'];
                    $impuestoLcl->tipo = 1;

                    $importeImp = Utils::formatNumber ( $traslado ['total'], $factura ['decimales'] );

                    $impuestoLcl->montoImp = $importeImp;

                    $datosFactura->impuestosTrasladadosLclTotal += $importeImp;
                    $datosFactura->impuestosTrasladadosLcl [] = $impuestoLcl;
                } else {

                    $impuesto = new \stdClass ();
                    $impuesto->base = $traslado ['base'];
                    $impuesto->factor = $traslado ['factor'];
                    $impuesto->tipoImp = $traslado ['impuesto'];
                    $impuesto->tasaImp = $traslado ['valor'];
                    $impuesto->tipo = 1;

                    $importeImp = Utils::formatNumber ( $traslado ['total'], $factura ['decimales'] );

                    $impuesto->montoImp = $importeImp;

                    $totalImpTrasladados += $importeImp;

                    $concepto->impuestosTrasladados [] = $impuesto;

                    $isNuevo = true;
                    if (count ( $datosFactura->impuestosTrasladados ))
                        foreach ( $datosFactura->impuestosTrasladados as $impuestoGeneral ) {

                            if ($impuesto->tipoImp == $impuestoGeneral->impuesto && $impuesto->factor == $impuestoGeneral->tipoFactor && $impuesto->tasaImp == $impuestoGeneral->tasaOCuota) {
                                $isNuevo = false;
                                $impuestoGeneral->importe += $impuesto->montoImp;
                                $impuestoGeneral->base += $impuesto->base;
                                break;
                            }
                        }

                    if ($isNuevo && $traslado ['factor'] != 'Exento') {
                        $impuestoGeneral = new \stdClass ();
                        $impuestoGeneral->base = $impuesto->base;
                        $impuestoGeneral->importe = $impuesto->montoImp;
                        $impuestoGeneral->impuesto = $impuesto->tipoImp;
                        $impuestoGeneral->tipoFactor = $traslado ['factor'];
                        $impuestoGeneral->tasaOCuota = $traslado ['valor'];
                        $datosFactura->impuestosTrasladados [] = $impuestoGeneral;
                    }
                }
            }

            $concepto->impuestosRetenidos = array();

            foreach ( $detalle ['impuestosRetenidos'] as $retencion ) {

                if ($retencion ['impuesto'] == 'XXX') {

                    $impuestoLcl = new \stdClass ();
                    $impuestoLcl->tipoImp = $retencion ['label'];
                    $impuestoLcl->tasaImp = $retencion ['valor'];
                    $impuestoLcl->tipo = 0;

                    $importeImp = Utils::formatNumber ( $retencion ['total'], $factura ['decimales'] );

                    $impuestoLcl->montoImp = $importeImp;

                    $datosFactura->impuestosRetenidosLclTotal += $importeImp;
                    $datosFactura->impuestosRetenidosLcl [] = $impuestoLcl;
                } else {

                    $impuesto = new \stdClass ();
                    $impuesto->base = $retencion ['base'];
                    $impuesto->factor = $retencion ['factor'];
                    $impuesto->tipoImp = $retencion ['impuesto'];
                    $impuesto->tasaImp = $retencion ['valor'];
                    $impuesto->tipo = 0;

                    $importeImp = Utils::formatNumber ( $retencion ['total'], $factura ['decimales'] );

                    $impuesto->montoImp = $importeImp;

                    $totalImpRetenidos += $importeImp;

                    $concepto->impuestosRetenidos [] = $impuesto;

                    $isNuevo = true;
                    if (count ( $datosFactura->impuestosRetenidos ))
                        foreach ( $datosFactura->impuestosRetenidos as $impuestoGeneral ) {
                            if ($impuesto->tipoImp == $impuestoGeneral->impuesto) {
                                $isNuevo = false;
                                $impuestoGeneral->importe += $impuesto->montoImp;
                                break;
                            }
                        }

                    if ($isNuevo && $retencion ['factor'] != 'Exento') {
                        $impuestoGeneral = new \stdClass ();
                        $impuestoGeneral->importe = $impuesto->montoImp;
                        $impuestoGeneral->impuesto = $impuesto->tipoImp;
                        $datosFactura->impuestosRetenidos [] = $impuestoGeneral;
                    }
                }
            }

            $datosFactura->conceptos [] = $concepto;
        }

        $datosFactura->totalImpRetenidos = $totalImpRetenidos;
        $datosFactura->totalImpTrasladados = $totalImpTrasladados;

        $datosFactura->facturasRelacionadas = [ ];

        if (count ( $factura ['facturasRelacionadas'] ['uuids'] ))
            foreach ( $factura ['facturasRelacionadas'] ['uuids'] as $facturaRelacionada ) {

                $relacionObj = new \stdClass ();
                $relacionObj->uuid = $facturaRelacionada ['uUID'];
                $datosFactura->facturasRelacionadas [] = $relacionObj;
            }

        $datosFactura->infGlobal = null;
        if($datosFactura->rFCRecep == "XAXX010101000" && $datosFactura->nmbRecep == 'PUBLICO EN GENERAL'){
            $informacionGlobal = new \stdClass ();
            $informacionGlobal->anio = $factura ['publico'] ['anio'];
            $informacionGlobal->meses = $factura ['publico'] ['meses'];
            $informacionGlobal->periodicidad = $factura ['publico'] ['periodicidad'];
            $datosFactura->infGlobal = $informacionGlobal;
        }

        $xml = XMLUtils::createXML40 ( $datosFactura, $proveedor );

        $sello = $xml->query ( '//cfdi:Comprobante' ) [0]->getAttribute ( 'Sello' );

        $nombreArchivo = "$proveedor->rFCEmisor-" . date ( 'YmdHis' );

        file_put_contents ( "tmp/$nombreArchivo.xml", $xml );

        $urlTimbrado = "https://facturacion.finkok.com/servicios/soap/stamp.wsdl";
        $usuarioInt = "saul.flores@soliat.com";
        $passwordInt = "S3rgio.Fl0res";

        if ($proveedor->id_proveedor == 1089) {

            $urlTimbrado = "https://demo-facturacion.finkok.com/servicios/soap/stamp.wsdl";
            $usuarioInt = "saul.flores@soliat.com";
            $passwordInt = "S3rgio.Fl0res";
        }

        $params = array ();
        $params ['xml'] = $xml;
        $params ['username'] = $usuarioInt;
        $params ['password'] = $passwordInt;

        $client = new SoapClient ( $urlTimbrado, array (
            'encoding' => 'UTF-8',
            "connection_timeout" => 250
        ) );
        $client->soap_defencoding = "UTF-8";
        $resultado = $client->__soapCall ( 'stamp', array (
            $params
        ) );

        $logToSave = print_r ( $resultado, true );

        $log = env ( 'DIR_LOGS' ) . "/" . date ( "Y-m-d" ) . ".log";
        $fp = fopen ( $log, "a" );
        fwrite ( $fp, "\n\n===" . date ( "Y-m-d:H:i:s" ) . "\n\n" );
        fwrite ( $fp, "\n\n$nombreArchivo\n\n" );
        fwrite ( $fp, $logToSave );
        fwrite ( $fp, "\n\n===" );
        fclose ( $fp );

        $success = false;
        $errorCode = 0;
        $errortext = '';
        $facturaResult = '';

        if (is_object ( $resultado ) && isset ( $resultado->stampResult ) && isset ( $resultado->stampResult->UUID ) && !empty($resultado->stampResult->xml)) {
            $success = true;

            $xmlTimbrado = new \DOMDocument ( "1.0", "uft-8" );
            $xmlTimbrado->loadXML ( $resultado->stampResult->xml );

            $idDoc = new IdDoc ();

            $timbreFiscal = $xmlTimbrado->getElementsByTagName ( 'TimbreFiscalDigital' );

            foreach ( $timbreFiscal as $timbreFiscal ) {

                $fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );
                $fechaTimbradoArray = explode ( ".", $fechaTimbrado );

                $idDoc->version = $timbreFiscal->getAttribute ( 'Version' );
                $idDoc->fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );
                $idDoc->selloCFD = $timbreFiscal->getAttribute ( 'SelloCFD' );
                $idDoc->noCertificadoSAT = $timbreFiscal->getAttribute ( 'NoCertificadoSAT' );
                $idDoc->selloSAT = $timbreFiscal->getAttribute ( 'SelloSAT' );
                $idDoc->uUID = $timbreFiscal->getAttribute ( 'UUID' );
                $idDoc->sello = $sello;
                $idDoc->rfcProvCertif = $timbreFiscal->getAttribute ( 'RfcProvCertif' );
            }

            $isPagado = 0;
            if ($factura ['metodoDePago'] == 'PUE')
                $isPagado = 1;

            $clienteObj = Cliente::with('domicilio')->find($factura ['id_cliente'] ['id_cliente']);
            $domicilioObj = $clienteObj->domicilio;
            if(!is_object($domicilioObj)){
                $domicilioObj = new DomFiscalRcp();
                $domicilioObj->id_cliente = $factura ['id_cliente'] ['id_cliente'];
            }
            $clienteObj->tipoPersona = $factura ['id_cliente'] ['tipoPersona'];
            $clienteObj->regimenFiscalReceptor = $factura ['id_cliente'] ['regimenFiscalReceptor'];
            $clienteObj->save();

            $domicilioObj->codigoPostal = $factura ['id_cliente'] ['codigoPostal'];
            $domicilioObj->save();

            $facturaObj = new Factura ();
            $facturaObj->id_proveedor = $user ['id_proveedor'];
            $facturaObj->id_cliente = $factura ['id_cliente'] ['id_cliente'];
            $facturaObj->id_certificadoProveedor = $certificadoHaUsar->id;
            $facturaObj->nmbEmisor = $proveedor->nmbEmisor;
            $facturaObj->rFCEmisor = $proveedor->rFCEmisor;
            $facturaObj->nmbRecep = $factura ['id_cliente'] ['nmbRecep'];
            $facturaObj->rFCRecep = $factura ['id_cliente'] ['rFCRecep'];
            $facturaObj->regimenFiscal = $proveedor->regimenFiscal33;
            $facturaObj->timeStamp = $timeStamp;
            $facturaObj->noFactura = $noFactura->noFactura;
            $facturaObj->version = "4.0";
            $facturaObj->generadoPor = 4;
            $facturaObj->nota = (isset ( $factura ['comentario'] )) ? Utils::deleteExtraSpaces ( $factura ['comentario'] ) : '';
            $facturaObj->tipoDeComprobante = $factura ['tipoDocumento'];
            $facturaObj->precission = $factura ['decimales'];
            $facturaObj->status = 1;
            $facturaObj->isPagado = $isPagado;
            $facturaObj->regimenFiscalReceptor = $datosFactura->regimenFiscalReceptor;
            $facturaObj->exportacion = $datosFactura->exportacion;
            $facturaObj->domicilioFiscalReceptor = $datosFactura->domicilioFiscalReceptor;
            $facturaObj->save ();

            $idDoc->id_factura = $facturaObj->id_factura;
            $idDoc->serie = $factura ['serie'];
            $idDoc->folio = $noFactura->noFactura;
            $idDoc->formaPago = $factura ['formaPago'];
            $idDoc->condicionesDePago = (isset ( $factura ['condicionesPago'] )) ? Utils::deleteExtraSpaces ( $factura ['condicionesPago'] ) : '';
            $idDoc->lugarExpedicion = Utils::deleteExtraSpaces ( $factura ['lugarExpedicion'] );
            $idDoc->usoCFDI = $factura ['usoCFDI'];
            $idDoc->metodoDePago = $factura ['metodoDePago'];
            $idDoc->sello = $sello;
            $idDoc->tipoFacturasRelacionadas = $datosFactura->tipoFacturasRelacionadas;
            $idDoc->save ();

            $totales = new Totales ();
            $totales->id_factura = $facturaObj->id_factura;
            $totales->moneda = $factura ['moneda'];
            $totales->tipoCambio = $factura ['tipoCambio'];
            $totales->subTotal = $factura ['subtotal'];
            $totales->mntBase = $factura ['base'];
            $totales->vlrPagar = $factura ['total'];
            $totales->descuento = $factura ['descuento'];
            $totales->save ();

            $detalles = array ();

            foreach ( $datosFactura->conceptos as $concepto ) {

                $conceptoObj = new Concepto ();
                $conceptoObj->clave = $concepto->clave;
                $conceptoObj->cdgItem = $concepto->cdgItem;
                $conceptoObj->dscItem = $concepto->dscItem;
                $conceptoObj->unmdItem = $concepto->unmdItem;
                $conceptoObj->qtyItem = $concepto->qtyItem;
                $conceptoObj->montoNetoItem = $concepto->montoNetoItem;
                $conceptoObj->prcNetoItem = $concepto->prcNetoItem;
                $conceptoObj->descuento = $concepto->descuento;
                $conceptoObj->objetoImp = $concepto->objetoImp;
                $conceptoObj->id_factura = $facturaObj->id_factura;
                $conceptoObj->save ();

                if (isset ( $factura ['guardarProd'] ) && $factura ['guardarProd'] == true) {

                    if ($concepto->id_producto > 0) {
                        $concepto2Obj = Producto::find ( $concepto->id_producto );
                    } else {
                        $concepto2Obj = new Producto ();
                    }

                    $concepto2Obj->id_proveedor = $user ['id_proveedor'];
                    $concepto2Obj->clave = $concepto->clave;
                    $concepto2Obj->nombre = $concepto->dscItem;
                    $concepto2Obj->precioU = $concepto->montoNetoItem;
                    $concepto2Obj->unidad = $concepto->unmdItem;
                    $concepto2Obj->codigo = $concepto->cdgItem;
                    $concepto2Obj->objetoImp = $concepto->objetoImp;
                    $concepto2Obj->status = 1;
                    $concepto2Obj->save ();
                }

                foreach ( $concepto->impuestosTrasladados as $impuesto ) {

                    $impuestoObj = new ExImpuestos ();
                    $impuestoObj->base = $impuesto->base;
                    $impuestoObj->factor = $impuesto->factor;
                    $impuestoObj->tipoImp = $impuesto->tipoImp;
                    $impuestoObj->tasaImp = $impuesto->tasaImp;
                    $impuestoObj->tipo = $impuesto->tipo;
                    $impuestoObj->montoImp = $impuesto->montoImp;
                    $impuestoObj->id_detalle = $conceptoObj->id_detalle;
                    $impuestoObj->save ();
                }

                foreach ( $concepto->impuestosRetenidos as $impuesto ) {

                    $impuestoObj = new ExImpuestos ();
                    $impuestoObj->base = $impuesto->base;
                    $impuestoObj->factor = $impuesto->factor;
                    $impuestoObj->tipoImp = $impuesto->tipoImp;
                    $impuestoObj->tasaImp = $impuesto->tasaImp;
                    $impuestoObj->tipo = $impuesto->tipo;
                    $impuestoObj->montoImp = $impuesto->montoImp;
                    $impuestoObj->id_detalle = $conceptoObj->id_detalle;
                    $impuestoObj->save ();
                }
            }

            foreach ( $datosFactura->facturasRelacionadas as $facturaRelacionada ) {

                $facturaRelacionadaObj = new FacturasRelacionadas ();
                $facturaRelacionadaObj->id_factura = $facturaObj->id_factura;
                $facturaRelacionadaObj->uuid = $facturaRelacionada->uuid;
                $facturaRelacionadaObj->save ();
            }

            if (count ( $datosFactura->impuestosRetenidosLcl ) > 0)
                foreach ( $datosFactura->impuestosRetenidosLcl as $impuesto ) {

                    $impuestoObj = new ExImpuestos ();
                    $impuestoObj->tipoImp = $impuesto->tipoImp;
                    $impuestoObj->tasaImp = $impuesto->tasaImp;
                    $impuestoObj->tipo = $impuesto->tipo;
                    $impuestoObj->montoImp = $impuesto->montoImp;
                    $impuestoObj->id_factura = $facturaObj->id_factura;
                    $impuestoObj->save ();
                }

            if (count ( $datosFactura->impuestosTrasladadosLcl ) > 0)
                foreach ( $datosFactura->impuestosTrasladadosLcl as $impuesto ) {

                    $impuestoObj = new ExImpuestos ();
                    $impuestoObj->tipoImp = $impuesto->tipoImp;
                    $impuestoObj->tasaImp = $impuesto->tasaImp;
                    $impuestoObj->tipo = $impuesto->tipo;
                    $impuestoObj->montoImp = $impuesto->montoImp;
                    $impuestoObj->id_factura = $facturaObj->id_factura;
                    $impuestoObj->save ();
                }

            if ($datosFactura->cuentaPredial != '') {

                $arrendamiento = new Arrendamiento ();
                $arrendamiento->id_factura = $facturaObj->id_factura;
                $arrendamiento->cuentaPredial = $datosFactura->cuentaPredial;
                $arrendamiento->save ();
            }

            if($datosFactura->rFCRecep == "XAXX010101000" && $datosFactura->nmbRecep == 'PUBLICO EN GENERAL'){
                $informacionGlobalObj = new InformacionGlobal();
                $informacionGlobalObj->id_factura = $facturaObj->id_factura;
                $informacionGlobalObj->anio = $informacionGlobal->anio;
                $informacionGlobalObj->meses = $informacionGlobal->meses;
                $informacionGlobalObj->periodicidad = $informacionGlobal->periodicidad;
                $informacionGlobalObj->save();
            }

            $facturaResult = $datosFactura->serie . $datosFactura->folio;
        } else {

            $errorCode = 10001;
            $errorMsg = 'Hubo un error al crear su factura. Vuelva a intentarlo.';

            if (is_object ( $resultado ) && isset ( $resultado->stampResult ) && isset ( $resultado->stampResult->Incidencias )
                && isset ( $resultado->stampResult->Incidencias->Incidencia )) {

                $errorMsg = $resultado->stampResult->Incidencias->Incidencia->MensajeIncidencia;
            }

            $errortext = $errorMsg;
        }

        return Response::json ( array (
            'success' => $success,
            'errorCode' => $errorCode,
            'errortext' => $errortext,
            'facturaResult' => $facturaResult,
            'nombreArchivo' => $nombreArchivo
        ) );
    }

    public function facturarPago40(Request $request) {
        ini_set ( 'default_socket_timeout', 300 );
        ini_set ( 'max_execution_time', 300 );
        set_time_limit ( 300 );

        $factura = $request->input ( 'factura' );
        $user = $request->input ( 'user' );
        $proveedor = Proveedor::with('domicilio')->find ( $user ['id_proveedor'] );
        $nombreArchivo = '';

        $textLess = '-125 minutes';
        if (in_array ( $user ['id_proveedor'], $this->rfcHorasAntes ))
            $textLess = '-70 hours';

        $timeStamp = date ( "Y-m-d H:i:s", strtotime ( $textLess ) );

        $noFactura = DB::select ( "SELECT MAX(noFactura) as noFactura FROM Factura f JOIN IdDoc i ON f.id_factura = i.id_factura WHERE id_proveedor = " . $user ['id_proveedor'] . " AND i.serie = '" . $factura ['serie'] . "'" ) [0];
        $noFactura->noFactura ++;
        $certificadoHaUsar = CertificadoProveedor::where ( 'id_proveedor', '=', $user ['id_proveedor'] )->where ( 'status', '=', 1 )->first ();

        if(!is_object($certificadoHaUsar)){
            return Response::json ( array (
                'success' => false,
                'errorCode' => 1009,
                'errortext' => "El certificado CSD no fue configurado de forma correcta",
                'facturaResult' => "El certificado CSD no fue configurado de forma correcta",
                'nombreArchivo' => ""
            ) );
        }

        $datosFactura = new \stdClass ();
        $datosFactura->timeStamp = $timeStamp;
        $datosFactura->tipoDeComprobante = 'P';
        $datosFactura->serie = $factura ['serie'];
        $datosFactura->folio = $noFactura->noFactura;
        $datosFactura->noCertificado = $certificadoHaUsar->noCertificado;
        $datosFactura->certificado = $certificadoHaUsar->certificado;
        $datosFactura->mntBase = 0;
        $datosFactura->subtotal = 0;
        $datosFactura->moneda = 'XXX';
        $datosFactura->total = 0;
        $datosFactura->formaPago = '';
        $datosFactura->condicionesDePago = '';
        $datosFactura->descuento = 0;
        $datosFactura->precission = 0;
        $datosFactura->tipoCambio = 1;
        $datosFactura->lugarExpedicion = Utils::deleteExtraSpaces ( $factura ['lugarExpedicion'] );
        $datosFactura->usoCFDI = 'CP01';
        $datosFactura->metodoDePago = '';
        $datosFactura->condicionesDePago = '';
        $datosFactura->tipoFacturasRelacionadas = $factura ['facturasRelacionadas'] ['tipoRelacion'];
        $datosFactura->rFCEmisor = $proveedor->rFCEmisor;
        $datosFactura->nmbEmisor = $proveedor->nmbEmisor;
        $datosFactura->rFCRecep = $factura ['id_cliente'] ['rFCRecep'];
        $datosFactura->nmbRecep = $factura ['id_cliente'] ['nmbRecep'];
        $datosFactura->regimenFiscalReceptor = $factura ['id_cliente'] ['regimenFiscalReceptor'];
        $datosFactura->domicilioFiscalReceptor = $factura ['id_cliente'] ['codigoPostal'];
        $datosFactura->exportacion = '01';
        $datosFactura->regimenFiscal = $proveedor->regimenFiscal33;
        $datosFactura->numRegIdTrib = isset ( $factura ['numRegIdTrib'] ) ? $factura ['numRegIdTrib'] : '';
        $datosFactura->pais = isset ( $factura ['pais'] ) ? $factura ['pais'] : '';
        $datosFactura->tipoPersona = $proveedor->tipoPersona;

        $datosFactura->conceptos = [ ];
        $datosFactura->impuestosTrasladados = [ ];
        $datosFactura->impuestosRetenidos = [ ];
        $totalImpRetenidos = 0;
        $totalImpTrasladados = 0;

        $detalle = array (
            'clave' => '84111506',
            'codigo' => '',
            'nombre' => 'Pago',
            'unidad' => 'ACT',
            'qty' => 1,
            'precioU' => 0,
            'descuento' => 0
        );
        $factura ['detalles'] = [ ];
        $factura ['detalles'] [] = $detalle;

        $totalesP = new \stdClass ();
        $totalesP->totalRetencionesIVA = 0;
        $totalesP->totalRetencionesISR = 0;
        $totalesP->totalRetencionesIEPS = 0;
        $totalesP->totalTrasladosBaseIVA16 = 0;
        $totalesP->totalTrasladosImpuestoIVA16 = 0;
        $totalesP->totalTrasladosBaseIVA8 = 0;
        $totalesP->totalTrasladosImpuestoIVA8 = 0;
        $totalesP->totalTrasladosBaseIVA0 = 0;
        $totalesP->totalTrasladosImpuestoIVA0 = 0;
        $totalesP->totalTrasladosBaseIVAExento = 0;
        $totalesP->montoTotalPagos = 0;

        foreach ( $factura ['detalles'] as $detalle ) {

            $concepto = new \stdClass ();
            $concepto->clave = $detalle ['clave'];
            $concepto->cdgItem = Utils::deleteExtraSpaces ( $detalle ['codigo'] );
            $concepto->dscItem = Utils::deleteExtraSpaces ( $detalle ['nombre'] );
            $concepto->unmdItem = (isset ( $detalle ['unidad'] )) ? $detalle ['unidad'] : '';
            $concepto->qtyItem = $detalle ['qty'];
            $concepto->montoNetoItem = $detalle ['precioU'];
            $concepto->prcNetoItem = $detalle ['qty'] * $detalle ['precioU'];
            $concepto->descuento = $detalle ['descuento'];
            $concepto->objetoImp = '01';

            $concepto->impuestosTrasladados = [ ];
            $concepto->impuestosRetenidos = [ ];
            $datosFactura->conceptos [] = $concepto;
        }

        $datosFactura->pagos = [ ];
        $montoTotalPagos = 0;
        foreach ( $factura ['pagos'] as $pago ) {

            $pagoObj = new \stdClass ();
            $pagoObj->FechaPago = $pago ['fechaPago'];
            $pagoObj->FormaDePagoP = $pago ['formaPago'];
            $pagoObj->MonedaP = $pago ['moneda'];
            $pagoObj->TipoCambioP = ($pago ['tipoCambio'] > 1) ? $pago ['tipoCambio'] : 0;
            $montoTotalPagos += $pagoObj->Monto = $pago ['totalPago'];
            $pagoObj->banco = $pago ['banco'] ?? '';
            $pagoObj->cuenta = $pago ['cuenta'] ?? '';
            $pagoObj->rfcEmisorCtaBen = isset($pago ['rfcEmisorCtaBen']) ? trim($pago ['rfcEmisorCtaBen']) : '';
            $pagoObj->ctaBeneficiario = isset($pago ['ctaBeneficiario']) ? trim($pago ['ctaBeneficiario']) : '';
            $pagoObj->noOperacion = $pago ['noOperacion'] ?? '';
            $pagoObj->documentosRelacionado = [ ];

            foreach ( $pago ['documentoRelacionado'] as $documentoRelacionado ) {

                $doctoRelacionado = new \stdClass ();
                $doctoRelacionado->IdDocumento = $documentoRelacionado ['uuid'];
                $doctoRelacionado->MonedaDR = $documentoRelacionado ['moneda'];
                $doctoRelacionado->TipoCambioDR = (isset($documentoRelacionado ['tipoCambioDR']) && $documentoRelacionado ['tipoCambioDR'] > 1) ? $documentoRelacionado ['tipoCambioDR'] : null;
                $doctoRelacionado->MetodoDePagoDR = 'PPD';
                $doctoRelacionado->NumParcialidad = $documentoRelacionado ['parcialidad'];
                $doctoRelacionado->ImpSaldoAnt = $documentoRelacionado ['saldoAnterior'];
                $doctoRelacionado->ImpPagado = $documentoRelacionado ['pago'];
                $doctoRelacionado->ImpSaldoInsoluto = $documentoRelacionado ['saldoInsoluto'];
                $doctoRelacionado->ObjetoImpDR = $documentoRelacionado ['objetoImp'];
                $doctoRelacionado->MontoPagoMoneda = $documentoRelacionado ['montoPagoMoneda'] ?? 0;

                $equivalenciaDR = 1;
                if($doctoRelacionado->MonedaDR == 'USD' && $pagoObj->MonedaP == 'MXN' ){
                    $equivalenciaDR = Utils::formatNumber ($doctoRelacionado->ImpPagado / $doctoRelacionado->MontoPagoMoneda, 6);
                    while($doctoRelacionado->ImpPagado / $equivalenciaDR > $doctoRelacionado->MontoPagoMoneda) {
                        $equivalenciaDR += 0.000001;
                    }
                }
                $doctoRelacionado->EquivalenciaDR = $equivalenciaDR;

                if(isset($documentoRelacionado['impuestos'])){

                    $impuestos = new \stdClass ();
                    $impuestos->impuestosRetenidos = [];
                    $impuestos->impuestosTrasladados = [];

                    foreach ($documentoRelacionado['impuestos']['impuestosRetenidos'] as $impuestoRetenido ){
                        $retencionesDR = new \stdClass ();
                        $retencionesDR->base = $impuestoRetenido['base'];
                        $retencionesDR->tipoFactor = $impuestoRetenido['factor'];
                        $retencionesDR->importe = $impuestoRetenido['montoImp'];
                        $retencionesDR->tasaCuota = $impuestoRetenido['tasaImp'];
                        $retencionesDR->impuesto = $impuestoRetenido['tipoImp'];
                        $retencionesDR->tipo = 0;

                        $impuestos->impuestosRetenidos [] = $retencionesDR;
                    }

                    foreach ($documentoRelacionado['impuestos']['impuestosTrasladados'] as $impuestoTrasladado ){
                        $trasladoDR = new \stdClass ();
                        $trasladoDR->base = $impuestoTrasladado['base'];
                        $trasladoDR->tipoFactor = $impuestoTrasladado['factor'];
                        $trasladoDR->importe = $impuestoTrasladado['montoImp'];
                        $trasladoDR->tasaCuota = $impuestoTrasladado['tasaImp'];
                        $trasladoDR->impuesto = $impuestoTrasladado['tipoImp'];
                        $trasladoDR->tipo = 1;

                        $impuestos->impuestosTrasladados [] = $trasladoDR;
                    }

                    $doctoRelacionado->impuestos = $impuestos;
                }

                $pagoObj->documentosRelacionado [] = $doctoRelacionado;
            }

            if((isset($pago ['impuestosRetenidos']) && count($pago ['impuestosRetenidos']) > 0)
                || (isset($pago ['impuestosTrasladados']) && count($pago ['impuestosTrasladados']) > 0)){

                $impuestos = new \stdClass ();
                $impuestos->impuestosRetenidos = [];
                $impuestos->impuestosTrasladados = [];

                if(isset($pago ['impuestosRetenidos']))
                foreach ($pago ['impuestosRetenidos'] as $impuestosRetenido){
                    $retencionesDR = new \stdClass ();
                    $retencionesDR->importe = $impuestosRetenido['montoImp'];
                    $retencionesDR->impuesto = $impuestosRetenido['tipoImp'];

                    if($retencionesDR->impuesto == '001'){
                        $totalesP->totalRetencionesISR += $retencionesDR->importe;
                    } else if($retencionesDR->impuesto == '002'){
                        $totalesP->totalRetencionesIVA += $retencionesDR->importe;
                        $totalesP->tieneRetencionIVA = true;
                    } else if($retencionesDR->impuesto == '003'){
                        $totalesP->totalRetencionesIEPS += $retencionesDR->importe;
                    }


                    $impuestos->impuestosRetenidos [] = $retencionesDR;
                }

                if(isset($pago ['impuestosTrasladados']))
                foreach ($pago ['impuestosTrasladados'] as $impuestoTrasladado){
                    $trasladoDR = new \stdClass ();
                    $trasladoDR->base = $impuestoTrasladado['base'];
                    $trasladoDR->tipoFactor = $impuestoTrasladado['factor'];
                    $trasladoDR->importe = $impuestoTrasladado['montoImp'];
                    $trasladoDR->tasaCuota = $impuestoTrasladado['tasaImp'];
                    $trasladoDR->impuesto = $impuestoTrasladado['tipoImp'];
                    $impuestos->impuestosTrasladados [] = $trasladoDR;

                    if($trasladoDR->impuesto == '002'){
                        if($trasladoDR->tipoFactor == 'Exento'){
                            $totalesP->totalTrasladosBaseIVAExento += $trasladoDR->base;
                        } else if($trasladoDR->tasaCuota == 0.16){
                            $totalesP->totalTrasladosBaseIVA16 += $trasladoDR->base;
                            $totalesP->totalTrasladosImpuestoIVA16 += $trasladoDR->importe;
                        }else if($trasladoDR->tasaCuota == 0.08){
                            $totalesP->totalTrasladosBaseIVA8 += $trasladoDR->base;
                            $totalesP->totalTrasladosImpuestoIVA8 += $trasladoDR->importe;
                        }else if($trasladoDR->tasaCuota == 0){
                            $totalesP->totalTrasladosBaseIVA0 += $trasladoDR->base;
                            $totalesP->totalTrasladosImpuestoIVA0 += $trasladoDR->importe;
                        }
                    }

                }

                $pagoObj->impuestos = $impuestos;
            }


            $datosFactura->pagos [] = $pagoObj;
        }


        $datosFactura->montoTotalPagos = $montoTotalPagos;
        $datosFactura->totalImpRetenidos = $totalImpRetenidos;
        $datosFactura->totalImpTrasladados = $totalImpTrasladados;

        $datosFactura->facturasRelacionadas = [ ];

        if (count ( $factura ['facturasRelacionadas'] ['uuids'] ))
            foreach ( $factura ['facturasRelacionadas'] ['uuids'] as $facturaRelacionada ) {

                $relacionObj = new \stdClass ();
                $relacionObj->uuid = $facturaRelacionada ['uUID'];
                $datosFactura->facturasRelacionadas [] = $relacionObj;
            }

        $totalesP->montoTotalPagos = $montoTotalPagos;
        $datosFactura->totalesPagos = $totalesP;

        $xml = XMLUtils::createXML40 ( $datosFactura, $proveedor );

        $sello = $xml->query ( '//cfdi:Comprobante' ) [0]->getAttribute ( 'Sello' );

        $nombreArchivo = "$proveedor->rFCEmisor-" . date ( 'YmdHis' );

        file_put_contents ( "tmp/$nombreArchivo.xml", $xml );

        $urlTimbrado = "https://facturacion.finkok.com/servicios/soap/stamp.wsdl";
        $usuarioInt = "saul.flores@soliat.com";
        $passwordInt = "S3rgio.Fl0res";

        if ($proveedor->id_proveedor == 1089) {

            $urlTimbrado = "https://demo-facturacion.finkok.com/servicios/soap/stamp.wsdl";
            $usuarioInt = "saul.flores@soliat.com";
            $passwordInt = "S3rgio.Fl0res";
        }

        $params = array ();
        $params ['xml'] = $xml;
        $params ['username'] = $usuarioInt;
        $params ['password'] = $passwordInt;

        $client = new SoapClient ( $urlTimbrado, array (
            'encoding' => 'UTF-8',
            "connection_timeout" => 250
        ) );
        $client->soap_defencoding = "UTF-8";
        $resultado = $client->__soapCall ( 'stamp', array (
            $params
        ) );

        $logToSave = print_r ( $resultado, true );

        $log = env ( 'DIR_LOGS' ) . "/" . date ( "Y-m-d" ) . ".log";
        $fp = fopen ( $log, "a" );
        fwrite ( $fp, "\n\n===" . date ( "Y-m-d:H:i:s" ) . "\n\n" );
        fwrite ( $fp, "\n\n$nombreArchivo\n\n" );
        fwrite ( $fp, $logToSave );
        fwrite ( $fp, "\n\n===" );
        fclose ( $fp );

        $success = false;
        $errorCode = 0;
        $errortext = '';
        $facturaResult = '';

        if (is_object ( $resultado ) && isset ( $resultado->stampResult ) && isset ( $resultado->stampResult->UUID ) && !empty($resultado->stampResult->xml)) {

            $success = true;

            $xmlTimbrado = new \DOMDocument ( "1.0", "uft-8" );
            $xmlTimbrado->loadXML ( $resultado->stampResult->xml );

            $idDoc = new IdDoc ();

            $timbreFiscal = $xmlTimbrado->getElementsByTagName ( 'TimbreFiscalDigital' );

            foreach ( $timbreFiscal as $timbreFiscal ) {

                $fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );
                $fechaTimbradoArray = explode ( ".", $fechaTimbrado );

                $idDoc->version = $timbreFiscal->getAttribute ( 'Version' );
                $idDoc->fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );
                $idDoc->selloCFD = $timbreFiscal->getAttribute ( 'SelloCFD' );
                $idDoc->noCertificadoSAT = $timbreFiscal->getAttribute ( 'NoCertificadoSAT' );
                $idDoc->selloSAT = $timbreFiscal->getAttribute ( 'SelloSAT' );
                $idDoc->uUID = $timbreFiscal->getAttribute ( 'UUID' );
                $idDoc->sello = $sello;
                $idDoc->rfcProvCertif = $timbreFiscal->getAttribute ( 'RfcProvCertif' );
            }

            $clienteObj = Cliente::with('domicilio')->find($factura ['id_cliente'] ['id_cliente']);
            $domicilioObj = $clienteObj->domicilio;
            if(!is_object($domicilioObj)){
                $domicilioObj = new DomFiscalRcp();
                $domicilioObj->id_cliente = $factura ['id_cliente'] ['id_cliente'];
            }
            $clienteObj->tipoPersona = $factura ['id_cliente'] ['tipoPersona'];
            $clienteObj->regimenFiscalReceptor = $factura ['id_cliente'] ['regimenFiscalReceptor'];
            $clienteObj->save();

            $domicilioObj->codigoPostal = $factura ['id_cliente'] ['codigoPostal'];
            $domicilioObj->save();

            $facturaObj = new Factura ();
            $facturaObj->id_proveedor = $user ['id_proveedor'];
            $facturaObj->id_cliente = $factura ['id_cliente'] ['id_cliente'];
            $facturaObj->id_certificadoProveedor = $certificadoHaUsar->id;
            $facturaObj->nmbEmisor = $proveedor->nmbEmisor;
            $facturaObj->rFCEmisor = $proveedor->rFCEmisor;
            $facturaObj->nmbRecep = $factura ['id_cliente'] ['nmbRecep'];
            $facturaObj->rFCRecep = $factura ['id_cliente'] ['rFCRecep'];
            $facturaObj->regimenFiscal = $proveedor->regimenFiscal33;
            $facturaObj->timeStamp = $timeStamp;
            $facturaObj->noFactura = $noFactura->noFactura;
            $facturaObj->version = "4.0";
            $facturaObj->generadoPor = 4;
            $facturaObj->nota = (isset ( $factura ['comentario'] )) ? Utils::deleteExtraSpaces ( $factura ['comentario'] ) : '';
            $facturaObj->tipoDeComprobante = $factura ['tipoDocumento'];
            $facturaObj->precission = $factura ['decimales'];
            $facturaObj->status = 1;
            $facturaObj->regimenFiscalReceptor = $datosFactura->regimenFiscalReceptor;
            $facturaObj->exportacion = $datosFactura->exportacion;
            $facturaObj->domicilioFiscalReceptor = $datosFactura->domicilioFiscalReceptor;
            $facturaObj->save ();

            $idDoc->id_factura = $facturaObj->id_factura;
            $idDoc->serie = $factura ['serie'];
            $idDoc->folio = $noFactura->noFactura;
            $idDoc->formaPago = '';
            $idDoc->condicionesDePago = (isset ( $factura ['condicionesPago'] )) ? Utils::deleteExtraSpaces ( $factura ['condicionesPago'] ) : '';
            $idDoc->lugarExpedicion = Utils::deleteExtraSpaces ( $factura ['lugarExpedicion'] );
            $idDoc->usoCFDI = 'CP01';
            $idDoc->metodoDePago = '';
            $idDoc->sello = $sello;
            $idDoc->tipoFacturasRelacionadas = $datosFactura->tipoFacturasRelacionadas;
            $idDoc->save ();

            $totales = new Totales ();
            $totales->id_factura = $facturaObj->id_factura;
            $totales->moneda = 'XXX';
            $totales->tipoCambio = 0;
            $totales->subTotal = 0;
            $totales->mntBase = 0;
            $totales->vlrPagar = 0;
            $totales->descuento = 0;
            $totales->save ();

            $detalles = array ();

            foreach ( $datosFactura->conceptos as $concepto ) {

                $conceptoObj = new Concepto ();
                $conceptoObj->clave = $concepto->clave;
                $conceptoObj->cdgItem = $concepto->cdgItem;
                $conceptoObj->dscItem = $concepto->dscItem;
                $conceptoObj->unmdItem = $concepto->unmdItem;
                $conceptoObj->qtyItem = $concepto->qtyItem;
                $conceptoObj->montoNetoItem = $concepto->montoNetoItem;
                $conceptoObj->prcNetoItem = $concepto->prcNetoItem;
                $conceptoObj->descuento = $concepto->descuento;
                $conceptoObj->objetoImp = $concepto->objetoImp;
                $conceptoObj->id_factura = $facturaObj->id_factura;
                $conceptoObj->save ();

                foreach ( $concepto->impuestosTrasladados as $impuesto ) {

                    $impuestoObj = new ExImpuestos ();
                    $impuestoObj->base = $impuesto->base;
                    $impuestoObj->factor = $impuesto->factor;
                    $impuestoObj->tipoImp = $impuesto->tipoImp;
                    $impuestoObj->tasaImp = $impuesto->tasaImp;
                    $impuestoObj->tipo = $impuesto->tipo;
                    $impuestoObj->montoImp = $impuesto->montoImp;
                    $impuestoObj->id_detalle = $conceptoObj->id_detalle;
                    $impuestoObj->save ();
                }

                foreach ( $concepto->impuestosRetenidos as $impuesto ) {

                    $impuestoObj = new ExImpuestos ();
                    $impuestoObj->base = $impuesto->base;
                    $impuestoObj->factor = $impuesto->factor;
                    $impuestoObj->tipoImp = $impuesto->tipoImp;
                    $impuestoObj->tasaImp = $impuesto->tasaImp;
                    $impuestoObj->tipo = $impuesto->tipo;
                    $impuestoObj->montoImp = $impuesto->montoImp;
                    $impuestoObj->id_detalle = $conceptoObj->id_detalle;
                    $impuestoObj->save ();
                }
            }

            foreach ( $datosFactura->facturasRelacionadas as $facturaRelacionada ) {

                $facturaRelacionadaObj = new FacturasRelacionadas ();
                $facturaRelacionadaObj->id_factura = $facturaObj->id_factura;
                $facturaRelacionadaObj->uuid = $facturaRelacionada->uuid;
                $facturaRelacionadaObj->save ();
            }

            $totalesPObj = new TotalesP();
            $totalesPObj->id_factura = $facturaObj->id_factura;
            $totalesPObj->totalRetencionesIVA = $totalesP->totalRetencionesIVA;
            $totalesPObj->totalRetencionesISR = $totalesP->totalRetencionesISR;
            $totalesPObj->totalRetencionesIEPS = $totalesP->totalRetencionesIEPS;
            $totalesPObj->totalTrasladosBaseIVA16 = $totalesP->totalTrasladosBaseIVA16;
            $totalesPObj->totalTrasladosImpuestoIVA16 = $totalesP->totalTrasladosImpuestoIVA16;
            $totalesPObj->totalTrasladosBaseIVA8 = $totalesP->totalTrasladosBaseIVA8;
            $totalesPObj->totalTrasladosImpuestoIVA8 = $totalesP->totalTrasladosImpuestoIVA8;
            $totalesPObj->totalTrasladosBaseIVA0 = $totalesP->totalTrasladosBaseIVA0;
            $totalesPObj->totalTrasladosImpuestoIVA0 = $totalesP->totalTrasladosImpuestoIVA0;
            $totalesPObj->totalTrasladosBaseIVAExento = $totalesP->totalTrasladosBaseIVAExento;
            $totalesPObj->montoTotalPagos = $totalesP->montoTotalPagos;
            $totalesPObj->save();


            foreach ( $datosFactura->pagos as $pago ) {

                $pago->FechaPago = str_replace ('T', ' ', $pago->FechaPago);
                $pago->FechaPago = substr($pago->FechaPago, 0, 19);

                $pagoObj = new Pago ();
                $pagoObj->FechaPago = $pago->FechaPago;
                $pagoObj->FormaDePagoP = $pago->FormaDePagoP;
                $pagoObj->MonedaP = $pago->MonedaP;
                $pagoObj->TipoCambioP = $pago->TipoCambioP;
                $pagoObj->Monto = $pago->Monto;
                $pagoObj->banco = $pago->banco;
                $pagoObj->cuenta = $pago->cuenta;
                $pagoObj->rfcEmisorCtaBen = $pago->rfcEmisorCtaBen;
                $pagoObj->ctaBeneficiario = $pago->ctaBeneficiario;
                $pagoObj->noOperacion = $pago->noOperacion;
                $pagoObj->id_factura = $facturaObj->id_factura;
                $pagoObj->save ();

                foreach ( $pago->documentosRelacionado as $doctoRelacionado ) {

                    $doctoRelacionadoObj = new DoctoRelacionado ();
                    $doctoRelacionadoObj->IdDocumento = $doctoRelacionado->IdDocumento;
                    $doctoRelacionadoObj->MonedaDR = $doctoRelacionado->MonedaDR;
                    $doctoRelacionadoObj->TipoCambioDR = $doctoRelacionado->TipoCambioDR;
                    $doctoRelacionadoObj->MetodoDePagoDR = $doctoRelacionado->MetodoDePagoDR;
                    $doctoRelacionadoObj->NumParcialidad = $doctoRelacionado->NumParcialidad;
                    $doctoRelacionadoObj->ImpSaldoAnt = $doctoRelacionado->ImpSaldoAnt;
                    $doctoRelacionadoObj->ImpPagado = $doctoRelacionado->ImpPagado;
                    $doctoRelacionadoObj->ImpSaldoInsoluto = $doctoRelacionado->ImpSaldoInsoluto;
                    $doctoRelacionadoObj->ObjetoImpDR = $doctoRelacionado->ObjetoImpDR;
                    $doctoRelacionadoObj->MontoPagoMoneda = $doctoRelacionado->MontoPagoMoneda;
                    $doctoRelacionadoObj->id_pago = $pagoObj->id;
                    $doctoRelacionadoObj->save ();

                    if ($doctoRelacionadoObj->ImpSaldoInsoluto <= 0) {

                        $idDocObj = IdDoc::where ( 'uUID', '=', $doctoRelacionado->IdDocumento )->with ( 'factura' )->first ();
                        $facturaIdDoc = $idDocObj->factura;
                        $facturaIdDoc->isPagado = 1;
                        $facturaIdDoc->save ();
                    }


                    if(isset($doctoRelacionado->impuestos)){

                        if(count($doctoRelacionado->impuestos->impuestosRetenidos) > 0){
                            foreach ($doctoRelacionado->impuestos->impuestosRetenidos as $impuesto){
                                $impuestoDrObj = new ImpuestosDR();
                                $impuestoDrObj->id_doctoRelacionado = $doctoRelacionadoObj->id;
                                $impuestoDrObj->tipo = 0;
                                $impuestoDrObj->base = $impuesto->base;
                                $impuestoDrObj->importe = $impuesto->importe;
                                $impuestoDrObj->impuesto = $impuesto->impuesto;
                                $impuestoDrObj->tasaCuota = $impuesto->tasaCuota;
                                $impuestoDrObj->tipoFactor = $impuesto->tipoFactor;
                                $impuestoDrObj->save();
                            }

                        }

                        if(count($doctoRelacionado->impuestos->impuestosTrasladados) > 0){
                            foreach ($doctoRelacionado->impuestos->impuestosTrasladados as $impuesto){

                                $impuestoDrObj = new ImpuestosDR();
                                $impuestoDrObj->id_doctoRelacionado = $doctoRelacionadoObj->id;
                                $impuestoDrObj->tipo = 1;
                                $impuestoDrObj->base = $impuesto->base;
                                $impuestoDrObj->importe = $impuesto->importe;
                                $impuestoDrObj->impuesto = $impuesto->impuesto;
                                $impuestoDrObj->tasaCuota = $impuesto->tasaCuota;
                                $impuestoDrObj->tipoFactor = $impuesto->tipoFactor;
                                $impuestoDrObj->save();

                            }
                        }

                    }

                }
            }

            $facturaResult = $datosFactura->serie . $datosFactura->folio;
        } else {

            $errorCode = 10001;
            $errorMsg = 'Hubo un error al crear su factura. Vuelva a intentarlo.';

            if (is_object ( $resultado ) && isset ( $resultado->stampResult ) && isset ( $resultado->stampResult->Incidencias )
                && isset ( $resultado->stampResult->Incidencias->Incidencia )) {

                $errorMsg = $resultado->stampResult->Incidencias->Incidencia->MensajeIncidencia;
            }

            $errortext = $errorMsg;
        }

        return Response::json ( array (
            'success' => $success,
            'errorCode' => $errorCode,
            'errortext' => $errortext,
            'facturaResult' => $facturaResult,
            'nombreArchivo' => $nombreArchivo
        ) );
    }


}
